/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class FolderNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private boolean m_hasExpanded;
    private Tree m_folder;
    private MdObjectStore m_store;

    public FolderNode(Tree folder, MdObjectStore store) {
        super(folder);
        this.m_folder = folder;
        this.m_store = store;
    }

    public Tree getFolder() {
        return this.m_folder;
    }

    @Override
    public boolean isLeaf() {
        return this.m_hasExpanded && this.getChildCount() == 0;
    }

    public boolean hasExpanded() {
        return this.m_hasExpanded;
    }

    public void setHasExpanded(boolean expanded) {
        this.m_hasExpanded = expanded;
    }

    public void addChildren() throws MdException, RemoteException {
        if (this.hasExpanded()) {
            return;
        }
        if (this.m_folder == null) {
            return;
        }
        List<Object> trees = MetaUtilities.getSubFolders(this.m_store, this.m_folder);
        for (int index = 0; index < trees.size(); ++index) {
            Tree tree = (Tree)trees.get(index);
            FolderNode nodeTree = new FolderNode(tree, this.m_store);
            this.add(nodeTree);
        }
        this.setHasExpanded(true);
    }
}

