/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.scheduler.api.oma.FilterRule;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.FlowColumnSelectorModel;
import com.sas.scheduler.model.SchedulerException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterSelector {
    private static final String FilterTagStart = "FilterV1:";
    private static final String FilterTagEnd = "||";
    private String m_name;
    private String m_desc = "";
    private int m_grouping = 0;
    private ArrayList m_rules = new ArrayList();

    public FilterSelector(String name) {
        this.m_name = name;
    }

    public FilterSelector(String name, String description) {
        this.m_name = name;
        this.m_desc = description;
    }

    public FilterSelector(String name, FilterRule rule) {
        this.m_name = name;
        this.m_rules.add(rule);
    }

    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public boolean setDescription(String description) {
        this.m_desc = description;
        return true;
    }

    public boolean addRule(FilterRule rule) {
        return this.m_rules.add(rule);
    }

    public boolean removeRule(FilterRule rule) {
        return this.m_rules.remove(rule);
    }

    public int getRuleCount() {
        return this.m_rules.size();
    }

    public FilterRule getRule(int subscript) {
        return (FilterRule)this.m_rules.get(subscript);
    }

    public String toString() {
        return this.m_name;
    }

    public void setGrouping(int type) {
        this.m_grouping = type;
    }

    public int getGrouping() {
        return this.m_grouping;
    }

    public boolean isSimpleNameFilter() {
        String nameCol = FlowColumnSelectorModel.getColumnNameForKey((int)0);
        return this.m_rules.size() == 1 && ((FilterRule)this.m_rules.get(0)).getColumnName().equalsIgnoreCase(nameCol);
    }

    public String generateDefinition() {
        StringBuffer filterXML = new StringBuffer();
        filterXML.append(FilterTagStart);
        filterXML.append("<Filter Name=\"" + this.m_name + "\" Description=\"" + this.m_desc + "\">");
        for (FilterRule rule : this.m_rules) {
            filterXML.append(rule.generateXML());
        }
        filterXML.append("</Filter>");
        filterXML.append(FilterTagEnd);
        return filterXML.toString();
    }

    public boolean initFromDefinition(String content, boolean keepName) {
        if (content == null) {
            return false;
        }
        boolean isRule = content.startsWith(FilterTagStart);
        if (!isRule) {
            return false;
        }
        this.m_rules.clear();
        String xml = this.getFilterString(content);
        try {
            Node node1;
            Document doc = MetaUtilities.parseXML(xml);
            NodeList nodes = doc.getElementsByTagName("Filter");
            Node node = nodes.item(0);
            NamedNodeMap map = node.getAttributes();
            if (!keepName && (node1 = map.getNamedItem("Name")) != null) {
                this.m_name = node1.getNodeValue();
            }
            if ((node1 = map.getNamedItem("Description")) != null) {
                this.m_desc = node1.getNodeValue();
            }
            nodes = node.getChildNodes();
            int numNodes = nodes.getLength();
            for (int x = 0; x < numNodes; ++x) {
                Node cnode = nodes.item(x);
                FilterRule rule = new FilterRule();
                rule.initFromNode(cnode);
                this.addRule(rule);
            }
        }
        catch (SchedulerException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
        return true;
    }

    private String getFilterString(String definition) {
        int start = definition.indexOf(FilterTagStart, 0);
        if (start < 0) {
            return null;
        }
        int end = definition.indexOf(FilterTagEnd, start);
        if (end < 0) {
            return null;
        }
        String result = definition.substring(start + FilterTagStart.length(), end).trim();
        return result;
    }
}

