/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.EventListItem;
import com.sas.scheduler.api.oma.ExportJobDefinition;
import com.sas.scheduler.api.oma.FileEvent;
import com.sas.scheduler.api.oma.GroupingEvent;
import com.sas.scheduler.api.oma.JobEvent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.api.oma.TriggerEvent;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.ip.DIPServiceProxy;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.api.servers.sasjfs.SASJFSServiceProxy;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.FlowPFD;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.JobDefinitionInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTable;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeployedFlow
implements Comparable<Object> {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedFlow.class);
    public static final String StrGroupAnd = "AND";
    public static final String StrGroupOr = "OR";
    private static final String StrGroupName = "Grouping SyncStep";
    public static final int JOB_CompletesSuccessfully = 0;
    public static final int JOB_EndsWithAnyExitCode = 1;
    public static final int JOB_Starts = 2;
    public static final int JOB_MissesScheduledTime = 6;
    public static final int JOB_FailsToStart = 7;
    public static final int JOB_CannotRun = 8;
    public static final int JOB_RunsMoreThan = 4;
    public static final int JOB_RunsLessThan = 5;
    public static final int JOB_EndsExitCode = 3;
    public static final int FLOW_CompletesSuccessfully = 10;
    public static final int FLOW_EndsWithAnyExitCode = 11;
    public static final int FLOW_MissesScheduledTime = 16;
    public static final int FLOW_CannotRun = 18;
    public static final int FLOW_RunsMoreThan = 14;
    public static final int FLOW_RunsLessThan = 15;
    public static final int FLOW_EndsExitCode = 13;
    public static final int TIME_event = 40;
    public static final int FILE_event = 41;
    public static final int Compare_Equal = 21;
    public static final int Compare_NotEqual = 22;
    public static final int Compare_GreaterThan = 23;
    public static final int Compare_GreaterThanEqual = 24;
    public static final int Compare_LessThan = 25;
    public static final int Compare_LessThanEqual = 26;
    public static final int Group_AND = 31;
    public static final int Group_OR = 32;
    private static final String WaitEventRole = "EVENTWAIT";
    public static final String RoleFileEvent = "FileEvent";
    public static final String RoleTimeEvent = "TimeEvent";
    public static final String RoleJob = "JOB";
    public static final String RoleFlow = "FLOW";
    public static final String PropertyOperatorName = "OPERATOR";
    public static final String PropertyValueName = "VALUE";
    public static final String PropertyDependencyTypeName = "DEPENDENCYTYPE";
    private static final String PropertyEventDefinitionName = "Definition";
    public static final String PropertyTriggerEventDefinitionName = "Definition";
    public static final String PropertyTimeEventDefinitionName = "Definition";
    public static final String PropertyTimeEventCalDefinitionName = "CalendarDefinition";
    public static final String PropertyTimeEventCalDefinitionExpression = "CalendarExpression";
    public static final String PropertyFileEventDefinitionName = "Definition";
    public static final String PropertyPFDModel = "PFDModel";
    public static final String PropertyFlowCompletion = "FlowCompletionCriteria";
    public static final String PropertyFlowCompletionJobList = "FlowCompletionSelectedJobs";
    public static final String PropertyEmailNotification = "EmailNotification";
    public static final String PropertyEmailNotificationAddress = "EmailNotificationAddress";
    public static final String PropertyFlowEndBehavior = "FlowEndBehavior";
    public static final String PropertyFlowExitcodeBehavior = "FlowExitcodeBehavior";
    public static final String PropertyFlowExclusive = "FlowExclusiveCriteria";
    public static final String PropertyFlowSaveLayout = "FlowSaveLayout";
    public static final String PropertyJobDefaultEmailNotification = "JobDefaultEmailNotification";
    public static final String PropertyJobDefaultEmailNotificationAddress = "JobDefaultEmailNotificationAddress";
    public static final String PropertyJobDefaultPriority = "JobDefaultPriority";
    public static final String PropertyJobDefaultEnvironmentVariables = "JobDefaultEnvironmentVariables";
    public static final String PropertyJobDefaultExceptionHandlers = "JobDefaultExceptionHandlers";
    public static final String TRIGGERTYPE_PROPNAME = "TriggerType";
    public static final String PropertyScheduleID = "SCHEDULEID";
    public static final String PropertyScheduleIDType = "SCHEDULEID";
    public static final String PropertySubmitted = "SUBMITTED";
    public static final String PropertySubmittedType = "SUBMITTED";
    public static final String PropertyDefaultQueue = "QUEUE";
    public static final String PropertyDefaultHandler = "HANDLER";
    public static final int FLOWNAME = 0;
    public static final int JOBNAME = 1;
    public static final String ArithmeticOperator_Equal_Text = FlowInfo.ArithmeticOperator_Equal_Text;
    public static final String ArithmeticOperator_Equal_Symbol = FlowInfo.ArithmeticOperator_Equal_Symbol;
    public static final String ArithmeticOperator_NotEqual_Text = FlowInfo.ArithmeticOperator_NotEqual_Text;
    public static final String ArithmeticOperator_NotEqual_Symbol = FlowInfo.ArithmeticOperator_NotEqual_Symbol;
    public static final String ArithmeticOperator_GreaterThan_Text = FlowInfo.ArithmeticOperator_GreaterThan_Text;
    public static final String ArithmeticOperator_GreaterThan_Symbol = FlowInfo.ArithmeticOperator_GreaterThan_Symbol;
    public static final String ArithmeticOperator_GreaterThanEqual_Text = FlowInfo.ArithmeticOperator_GreaterThanEqual_Text;
    public static final String ArithmeticOperator_GreaterThanEqual_Symbol = FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol;
    public static final String ArithmeticOperator_LessThan_Text = FlowInfo.ArithmeticOperator_LessThan_Text;
    public static final String ArithmeticOperator_LessThan_Symbol = FlowInfo.ArithmeticOperator_LessThan_Symbol;
    public static final String ArithmeticOperator_LessThanEqual_Text = FlowInfo.ArithmeticOperator_LessThanEqual_Text;
    public static final String ArithmeticOperator_LessThanEqual_Symbol = FlowInfo.ArithmeticOperator_LessThanEqual_Symbol;
    private static final int ValidName = 0;
    private static final int InvalidName_MissingOrBlank = 1;
    private static final int InvalidName_InvalidCharacters = 2;
    private static final int InvalidName_NotUnique = 3;
    private JFJob m_flow;
    private FlowInfo m_info = null;
    private static final int INFO = 1;
    private TransformationActivity m_activity;
    private String m_repos;
    private MdFactory m_factory = null;
    private MdObjectStore m_store = null;
    private Scheduler m_scheduler;
    private String m_queue = null;
    private List<Object> m_jobs = new ArrayList<Object>();
    private Vector<Vector> m_data = null;
    private static final int DATA = 2;
    private boolean m_dirty = true;
    private String m_previousTriggerType = null;
    private int m_defaultGrouping = 32;
    private long m_scheduleID = -2L;
    private ArrayList<String> m_deleteList = new ArrayList();
    private Frame m_frame = null;
    private PromptCallbackInterface m_prompt = null;
    private int m_errorFlag = 0;
    private ArrayList<Object> m_JobsInError = new ArrayList();
    private static final int MISSING_SCHEDULING_SERVER = 1;
    private static final int CLEAR_MISSING_SCHEDULING_SERVER_ERROR = 4368;
    private static final int CORRUPTED_ASSOCIATED_JOBS = 16;
    private static final int CLEAR_CORRUPTED_ASSOCIATED_JOBS = 4353;

    public DeployedFlow(JFJob flow) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)flow.getObjectStore();
        String repos = flow.getId().substring(0, 8);
        this.initialize(flow.getName(), store, repos);
        this.m_flow = flow;
        this.m_activity = (TransformationActivity)flow.getJobActivities().get(0);
        for (TransformationStep step : this.m_activity.getSteps()) {
            if (step instanceof SyncStep) continue;
            String reposID = "A0000001." + repos;
            JFJob jfjob = this.getJFJobFromStep(step, store, reposID);
            try {
                DeployedJob djob;
                if (jfjob == null) continue;
                step.setName(JobEvent.getName(jfjob));
                if (step.getTransformRole().equalsIgnoreCase(RoleJob)) {
                    djob = new DeployedJob(jfjob);
                    if (djob.hasErrors()) {
                        this.m_errorFlag |= 0x10;
                        this.m_JobsInError.add(djob);
                    }
                    this.m_jobs.add(djob);
                    continue;
                }
                if (step.getTransformRole().equalsIgnoreCase(RoleFlow)) {
                    DeployedFlow sflow = new DeployedFlow(jfjob);
                    if (sflow.hasErrors()) {
                        this.m_errorFlag |= 0x10;
                        this.m_JobsInError.add(sflow);
                    }
                    this.m_jobs.add(sflow);
                    continue;
                }
                djob = new DeployedJob(jfjob);
                if (djob.hasErrors()) {
                    this.m_errorFlag |= 0x10;
                    this.m_JobsInError.add(djob);
                }
                this.m_jobs.add(djob);
            }
            catch (InvalidParameterException ex) {
                if (jfjob != null && jfjob.getTransformRole().compareTo("SCHEDULER_FLOW") != 0) {
                    this.m_errorFlag |= 0x10;
                }
                if (!MetaUtilities.isDebug()) continue;
                if (jfjob != null) {
                    System.out.println("Ignoring " + jfjob.getName());
                }
                ex.printStackTrace();
            }
        }
    }

    public DeployedFlow(JFJob flow, MdStore store) throws MdException, RemoteException {
        this(flow, (MdObjectStore)store);
    }

    public DeployedFlow(JFJob flow, MdObjectStore store) throws MdException, RemoteException {
        this.initialize(flow.getName(), store, flow.getId().substring(0, 8));
        this.initializeFromJFJob(flow, null);
    }

    public DeployedFlow(JFJob flow, MdObjectStore store, Scheduler scheduler) throws MdException, RemoteException {
        this.initialize(flow.getName(), store, flow.getId().substring(0, 8));
        this.initializeFromJFJob(flow, scheduler);
    }

    public DeployedFlow(FlowInfo flowinfo, MdObjectStore store, String repos) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this(flowinfo, (PromptCallbackInterface)null, store, repos);
    }

    public DeployedFlow(FlowInfo flowinfo, PromptCallbackInterface prompt, MdObjectStore store, String repos) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this.m_prompt = prompt;
        this.initialize(flowinfo.getName(), store, repos);
        String reposID = "A0000001." + repos;
        String fqid = flowinfo.getId();
        if (flowinfo.isDisplayInformationOnly() && fqid != null) {
            List jobs;
            JFJob jfjob = MetaUtilities.getJFJob(fqid, "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.m_store, reposID);
            this.initializeFromJFJob(jfjob, null);
            SchedulerServerInfo schinfo = flowinfo.getScheduler();
            if (schinfo == null && this.m_scheduler != null) {
                schinfo = this.m_scheduler.getServerComponent();
                flowinfo.setScheduler(schinfo);
            } else if (schinfo != null) {
                this.m_scheduler = MetaUtilities.getSchedulingServer(schinfo, this.m_store);
            }
            if (flowinfo.getTriggerEvent() == null) {
                ArrayList<TriggerEventInfo> triggerList = new ArrayList<TriggerEventInfo>();
                TriggerEventInfo tinfo = this.getTriggerEventInfo(triggerList, schinfo);
                flowinfo.setTriggerEvent(tinfo);
                flowinfo.setTriggerEventList(triggerList);
            }
            if ((jobs = flowinfo.getJobs()) == null || jobs.size() == 0) {
                this.setJobInfo(flowinfo, this.m_scheduler);
            }
            return;
        }
        Scheduler sch = null;
        SchedulerServerInfo scheduler = flowinfo.getScheduler();
        if (scheduler != null) {
            sch = MetaUtilities.getSchedulingServer(scheduler, this.m_store);
        }
        this.initializeFromInfo(flowinfo, sch);
    }

    public DeployedFlow(FlowInfo flowinfo, Scheduler scheduler, MdObjectStore store, String repos) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this(flowinfo, (PromptCallbackInterface)null, scheduler, store, repos);
    }

    public DeployedFlow(FlowInfo flowinfo, PromptCallbackInterface prompt, Scheduler scheduler, MdObjectStore store, String repos) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this.m_prompt = prompt;
        if (scheduler.isConnectionNeededForTimeEvents() && !scheduler.isConnected()) {
            throw new IllegalArgumentException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.ScheduleMustBeConnected.msg.fmt"), scheduler.getClassId()));
        }
        this.initialize(flowinfo.getName(), store, repos);
        this.initializeFromInfo(flowinfo, scheduler);
    }

    public DeployedFlow(String name, MdObjectStore store, String repos, ServerComponent scheduler) throws MdException, IllegalArgumentException, RemoteException {
        this(name, store, repos, scheduler, (List)null);
    }

    public DeployedFlow(String name, MdObjectStore store, String repos, ServerComponent scheduler, List<?> jobs) throws MdException, IllegalArgumentException, RemoteException {
        this.initialize(name, store, repos);
        this.m_scheduler = MetaUtilities.getSchedulingServer(scheduler);
        this.validateFlowname(name, this.m_scheduler);
        if (jobs != null) {
            for (Object obj : jobs) {
                if (obj instanceof DeployedJob) {
                    this.addJobToFlow((DeployedJob)obj);
                    continue;
                }
                if (obj instanceof DeployedFlow) {
                    this.addSubFlowToFlow((DeployedFlow)obj);
                    continue;
                }
                IllegalArgumentException ex = new IllegalArgumentException(m_bundle.getString("DeployedFlow.InvalidObject.SubFlowJob.txt"));
                throw ex;
            }
        }
    }

    public DeployedFlow(String name, MdObjectStore store, String repos, SchedulerServerInfo scheduler) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this(name, store, repos, scheduler, (List)null);
    }

    public DeployedFlow(String name, MdObjectStore store, String repos, Scheduler scheduler) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this(name, store, repos, scheduler, (List)null);
    }

    public DeployedFlow(String name, MdObjectStore store, String repos, SchedulerServerInfo scheduler, List<?> jobs) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this(name, store, repos, MetaUtilities.getSchedulingServer(scheduler, store), jobs);
    }

    public DeployedFlow(String name, MdObjectStore store, String repos, Scheduler scheduler, List<?> jobs) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        this.initialize(name, store, repos);
        this.m_scheduler = scheduler;
        if (this.m_scheduler == null) {
            this.m_errorFlag |= 1;
        }
        this.validateFlowname(name, this.m_scheduler);
        if (jobs != null) {
            for (Object obj : jobs) {
                if (obj instanceof JobInfo) {
                    this.addJobToFlow(new DeployedJob((JobInfo)obj, this.getName(), this.m_store, this.m_repos));
                    continue;
                }
                if (obj instanceof FlowInfo) {
                    this.addSubFlowToFlow(new DeployedFlow((FlowInfo)obj, this.m_store, this.m_repos));
                    continue;
                }
                if (obj instanceof DeployedJob) {
                    this.addJobToFlow((DeployedJob)obj);
                    continue;
                }
                if (obj instanceof DeployedFlow) {
                    this.addSubFlowToFlow((DeployedFlow)obj);
                    continue;
                }
                IllegalArgumentException ex = new IllegalArgumentException(m_bundle.getString("DeployedFlow.InvalidObject.SubFlowJob.txt"));
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetFromInfo(FlowInfo flowinfo, PromptCallbackInterface prompt, Scheduler scheduler) throws IllegalArgumentException, RemoteException, MdException, SchedulerException {
        boolean rc = false;
        MdObjectStore hold_store = null;
        MdObjectStore temp_store = null;
        try {
            this.m_prompt = prompt;
            hold_store = this.m_store;
            this.m_store = temp_store = this.m_factory.createObjectStore(null, "ResetFromInfo");
            this.initializeFromInfo(flowinfo, scheduler);
            this.m_store.updatedMetadataAll();
            this.m_store = hold_store;
            this.refresh();
            this.m_info = flowinfo;
            rc = true;
        }
        finally {
            if (temp_store != null) {
                temp_store.dispose();
            }
        }
        return rc;
    }

    private void initializeFromInfo(FlowInfo flowinfo, Scheduler scheduler) throws MdException, IllegalArgumentException, RemoteException, SchedulerException {
        block61: {
            try {
                List jobs;
                block60: {
                    block59: {
                        FlowPFD pfd;
                        Property prop;
                        TimeEvent temp;
                        Event eventobj;
                        TriggerEvent te;
                        String reposID = "A0000001." + this.m_repos;
                        HashMap<String, String> jobsMap = null;
                        String fqid = flowinfo.getId();
                        if (fqid != null && fqid.trim().length() > 0) {
                            if (MetaUtilities.isDebug()) {
                                System.out.println("DEPLOYEDFLOW: Updating the flow.");
                            }
                            this.m_flow = MetaUtilities.getJFJob(fqid, "<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.m_store, reposID);
                            this.m_activity = (TransformationActivity)this.m_flow.getJobActivities().get(0);
                            jobsMap = this.getJobNamesList();
                            DeployedFlow.deleteFlowEvents(this.m_flow, this.m_activity, false);
                            this.m_activity.getSteps().clear();
                            this.m_jobs.clear();
                            this.clearTriggerEvent();
                            if (scheduler == null) {
                                try {
                                    ServerComponent scomponent = (ServerComponent)this.m_flow.getComputeLocations().get(0);
                                    this.setScheduleServer(MetaUtilities.getSchedulingServer(scomponent));
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    this.m_scheduler = null;
                                    this.m_errorFlag |= 1;
                                }
                            } else {
                                this.setScheduleServer(scheduler);
                            }
                            this.setScheduleID(flowinfo.getScheduleID());
                            this.setScheduleDefinition(flowinfo.getScheduleDefinitionId());
                        } else {
                            this.m_scheduler = scheduler;
                            String name = flowinfo.getName();
                            this.validateFlowname(name, this.m_scheduler);
                        }
                        try {
                            Tree folder = MetaUtilities.getFolder(flowinfo.getLocation(), this.m_store, this.m_repos);
                            this.setFolder(folder);
                        }
                        catch (NotFound nf) {
                            this.m_factory.getUtil().printOutputln(nf.getLocalizedMessage());
                        }
                        catch (NoContext e) {
                            this.m_factory.getUtil().printOutputln(e.getLocalizedMessage());
                        }
                        Iterator it = flowinfo.getFlowTriggerEvents("Event").iterator();
                        Vector<TriggerEvent> triggers = new Vector<TriggerEvent>();
                        while (it.hasNext()) {
                            try {
                                TriggerEventInfo tei = (TriggerEventInfo)it.next();
                                te = new TriggerEvent(tei, this.m_scheduler, this.m_store, reposID);
                                eventobj = te.getEvent();
                                if (eventobj != null && eventobj.getEventRole().compareToIgnoreCase(RoleTimeEvent) == 0 && (temp = te.getTimeEvent()) != null) {
                                    MetaUtilities.setStringProperty((Root)eventobj, "Definition", this.m_factory, this.m_store, temp.generateDefinition());
                                    prop = MetaUtilities.setStringProperty((Root)eventobj, PropertyTimeEventCalDefinitionName, this.m_factory, this.m_store, temp.generateCalendarDefinition());
                                    prop.setDesc(temp.getCalendarName());
                                }
                                triggers.add(te);
                            }
                            catch (SchedulerException se) {
                                this.m_factory.getUtil().printOutputln("INTERNAL ERROR: " + se.toString() + "\n" + se.getStackTrace()[0].toString() + "\n" + se.getStackTrace()[1].toString() + "\n");
                            }
                            catch (RuntimeException rte) {
                                this.m_factory.getUtil().printOutputln("INTERNAL ERROR: " + rte.toString() + "\n" + rte.getStackTrace()[0].toString() + "\n" + rte.getStackTrace()[1].toString() + "\n");
                            }
                        }
                        TriggerEventInfo trei = flowinfo.getTriggerEvent();
                        te = null;
                        if (triggers.size() > 0) {
                            this.setTriggerEventList(triggers);
                        } else if (trei != null) {
                            try {
                                AbstractEventInfo d = trei.getEvent();
                                if (d instanceof GroupingEventInfo) {
                                    GroupingEventInfo gei = (GroupingEventInfo)d;
                                    for (DisplayInfo di : gei.getDependencies2()) {
                                        TriggerEvent tre;
                                        TriggerEventInfo trigger;
                                        if (di instanceof TimeEventInfo) {
                                            trigger = new TriggerEventInfo((TimeEventInfo)di, this.m_scheduler.getServerComponent());
                                            tre = new TriggerEvent(trigger, this.m_scheduler, this.m_store, reposID);
                                            triggers.add(tre);
                                            continue;
                                        }
                                        if (!(di instanceof FileEventInfo)) continue;
                                        trigger = new TriggerEventInfo((FileEventInfo)di, this.m_scheduler.getServerComponent());
                                        tre = new TriggerEvent(trigger, this.m_scheduler, this.m_store, reposID);
                                        triggers.add(tre);
                                    }
                                } else {
                                    te = new TriggerEvent(trei, this.m_scheduler, this.m_store, reposID);
                                    triggers.add(te);
                                }
                            }
                            catch (SchedulerException se) {
                                this.m_factory.getUtil().printOutputln("INTERNAL ERROR: " + se.toString() + "\n" + se.getStackTrace()[0].toString() + "\n" + se.getStackTrace()[1].toString() + "\n");
                            }
                            catch (RuntimeException rte) {
                                this.m_factory.getUtil().printOutputln("INTERNAL ERROR: " + rte.toString() + "\n" + rte.getStackTrace()[0].toString() + "\n" + rte.getStackTrace()[1].toString() + "\n");
                            }
                        }
                        if (trei != null) {
                            try {
                                if (trei.getEvent() instanceof GroupingEventInfo) {
                                    SyncStep step = this.setupTriggering(true);
                                    trei.setId(step.getId());
                                }
                                if (te == null) {
                                    te = new TriggerEvent(trei, this.m_scheduler, this.m_store, reposID);
                                }
                                if ((eventobj = te.getEvent()) != null && eventobj.getEventRole().compareToIgnoreCase(RoleTimeEvent) == 0 && (temp = te.getTimeEvent()) != null) {
                                    MetaUtilities.setStringProperty((Root)eventobj, "Definition", this.m_factory, this.m_store, temp.generateDefinition());
                                    prop = MetaUtilities.setStringProperty((Root)eventobj, PropertyTimeEventCalDefinitionName, this.m_factory, this.m_store, temp.generateCalendarDefinition());
                                    prop.setDesc(temp.getCalendarName());
                                }
                                this.setTriggerEvent(te);
                            }
                            catch (SchedulerException se) {
                                this.m_factory.getUtil().printOutputln("INTERNAL ERROR: " + se.toString() + "\n" + se.getStackTrace()[0].toString() + "\n" + se.getStackTrace()[1].toString() + "\n");
                            }
                            catch (RuntimeException rte) {
                                this.m_factory.getUtil().printOutputln("INTERNAL ERROR: " + rte.toString() + "\n" + rte.getStackTrace()[0].toString() + "\n" + rte.getStackTrace()[1].toString() + "\n");
                            }
                        }
                        if ((jobs = flowinfo.getJobs()) != null) {
                            JobInfo jobinfo;
                            ArrayList copyJobs = new ArrayList();
                            copyJobs.addAll(jobs);
                            Iterator i = copyJobs.iterator();
                            ArrayList<Object> djobs = new ArrayList<Object>();
                            while (i.hasNext()) {
                                DisplayInfo jinfo = (DisplayInfo)i.next();
                                if (jobsMap != null && jobsMap.containsKey(jinfo.getName())) {
                                    String jobid = jobsMap.get(jinfo.getName());
                                    jinfo.setId(jobid);
                                }
                                if (jinfo instanceof JobInfo) {
                                    jobinfo = (JobInfo)jinfo;
                                    if (jobinfo.isSubflow()) {
                                        JFJob sf_jfjob = MetaUtilities.getJFJob(jobinfo.getId(), (MdStore)this.m_store, reposID);
                                        DeployedFlow sflow = new DeployedFlow(sf_jfjob, this.m_store);
                                        DeployedFlow.addSubFlowToFlow(sflow, this.m_activity, this.m_jobs, this.m_factory, this.m_store, this.m_repos);
                                        djobs.add(sflow);
                                        flowinfo.convertJobInfoToFlowInfo(jobinfo, sflow.getInfo());
                                        continue;
                                    }
                                    DeployedJob djob = new DeployedJob(jobinfo, this.getName(), this.m_store, this.m_repos);
                                    TransformationStep step = DeployedFlow.addJobToFlow(djob, this.m_activity, this.m_jobs, this.m_factory, this.m_store, this.m_repos);
                                    String jobcmd = jobinfo.getCommandLine();
                                    jobcmd = djob.replaceCommandLineArgs(jobcmd);
                                    String cmdline = CommandUtilities.getCommandLine(djob.getDeployedJobObject(), flowinfo.getName());
                                    if (jobcmd != null && jobcmd.compareTo(cmdline) != 0) {
                                        DeployedJob.setCmdLineProperty((Root)step, jobcmd);
                                    }
                                    if (jobinfo.getSchedulerProperties() != null) {
                                        String details = jobinfo.getSchedulerProperties();
                                        DeployedJob.setSchedulingDetails(step, details);
                                    } else {
                                        DeployedJob.clearSchedulingDetails(step);
                                    }
                                    if (jobinfo.getSchedulerResources() != null) {
                                        String expression = jobinfo.getSchedulerResources();
                                        DeployedJob.setResources((Root)step, expression);
                                    } else {
                                        DeployedJob.clearResources((Root)step);
                                    }
                                    if (jobinfo.getUserId() != null) {
                                        String runas = jobinfo.getUserId();
                                        DeployedJob.setRunAs((Root)step, runas);
                                    } else {
                                        DeployedJob.clearRunAs((Root)step);
                                    }
                                    djobs.add(djob);
                                    continue;
                                }
                                if (!(jinfo instanceof FlowInfo)) continue;
                                FlowInfo finfo = (FlowInfo)jinfo;
                                DeployedFlow sflow = null;
                                if (finfo.getId() != null) {
                                    JFJob jfjob = MetaUtilities.getJFJob(finfo.getId(), (MdStore)this.m_store, reposID);
                                    sflow = new DeployedFlow(jfjob, this.m_store);
                                } else {
                                    sflow = new DeployedFlow(finfo, this.m_store, this.m_repos);
                                }
                                DeployedFlow.addSubFlowToFlow(sflow, this.m_activity, this.m_jobs, this.m_factory, this.m_store, this.m_repos);
                                djobs.add(sflow);
                            }
                            i = jobs.iterator();
                            int count = 0;
                            while (i.hasNext()) {
                                jobinfo = (DisplayInfo)i.next();
                                Object object = djobs.get(count++);
                                DisplayInfo info = null;
                                if (jobinfo instanceof JobInfo) {
                                    info = flowinfo.getEvent(jobinfo);
                                    this.processFlowEventInfo(flowinfo, info, (DeployedJob)object, djobs);
                                    continue;
                                }
                                if (!(jobinfo instanceof FlowInfo)) continue;
                                info = flowinfo.getEvent((FlowInfo)jobinfo);
                                this.processFlowEventInfo(flowinfo, info, (DeployedFlow)object, djobs);
                            }
                        }
                        if ((pfd = flowinfo.getPFD()) != null) {
                            this.setPFD(pfd);
                        }
                        this.setDescription(flowinfo.getDescription());
                        this.setFlowSubmitted(flowinfo.isFlowSubmitted(), flowinfo.getScheduledUser());
                        this.setTriggerProperty(flowinfo.getTriggerType());
                        this.setScheduleDefinition(flowinfo.getScheduleDefinitionId());
                        this.setResponsiblePartyForDeployment(flowinfo.getResponsiblePartyDataBinding());
                        this.setEmailNotification(flowinfo.isNotifyEmail(), flowinfo.emailNotificationLevel(), flowinfo.emailAddress());
                        this.setCompletion(flowinfo.hasAdvanceCompletion(), flowinfo.completionLevel(), flowinfo.completionSelectedJobs());
                        try {
                            this.setEndBehavior(flowinfo.getEndBehaviorDataBinding());
                        }
                        catch (NullPointerException npe) {
                            if (this.getEndbehavior() != 0) break block59;
                            this.setEndBehavior(1);
                        }
                    }
                    try {
                        this.setExitcodeBehavior(flowinfo.getExitcodeBehaviorDataBinding());
                    }
                    catch (NullPointerException npe) {
                        if (this.getExitcodebehavior() != 0) break block60;
                        this.setExitcodeBehavior(2);
                    }
                }
                this.setExclusive(flowinfo.hasExclusive());
                this.setSaveLayout(flowinfo.saveLayout());
                this.setQueue(jobs, flowinfo.getSchedulerQueue());
                this.setJobDefaultEmailNotification(jobs, flowinfo.isJobDefaultNotifyEmail(), flowinfo.jobDefaultEmailNotificationLevel(), flowinfo.jobDefaultEmailAddress());
                this.setJobDefaultPriority(jobs, flowinfo.getJobDefaultPriority());
                this.setJobDefaultEnvironmentVariables(jobs, flowinfo.getJobDefaultEnvironmentVariables());
                this.setJobDefaultExceptionHandlers(jobs, flowinfo.getJobDefaultExceptionHandlers());
                this.m_info = flowinfo;
            }
            catch (RuntimeException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                throw e;
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block61;
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFlowEventInfo(FlowInfo flow, DisplayInfo info, Object dobj, List<Object> djobs) throws RemoteException, MdException, SchedulerException {
        if (info == null) {
            return;
        }
        if (info instanceof GroupingEventInfo) {
            GroupingEventInfo ginfo = (GroupingEventInfo)info;
            int condition = -1;
            switch (ginfo.getEventType()) {
                case 0: {
                    condition = 31;
                    break;
                }
                default: {
                    condition = 32;
                }
            }
            List list = ginfo.getDependencies();
            int numEvents = list.size();
            DeployedJob depend = this.groupDependencies(list, condition, null);
            flow.resetEventId(ginfo.getId(), depend.getLogicalJob(this.m_activity).getId());
            for (int x = 0; x < numEvents; ++x) {
                DisplayInfo ai = (DisplayInfo)list.get(x);
                if (ai instanceof GroupingEventInfo) {
                    this.processFlowEventInfo(flow, ai, depend, djobs);
                    continue;
                }
                if (ai instanceof JobEventInfo) {
                    DeployedJob job = null;
                    DeployedFlow subflow = null;
                    JobEventInfo jei = (JobEventInfo)ai;
                    int type = jei.getEventType();
                    switch (type) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 6: 
                        case 7: 
                        case 8: {
                            job = this.findJobInList((DisplayInfo)jei.getJobInfo(), djobs);
                            this.addJobSimpleDependency(depend, job, type, null);
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 16: 
                        case 18: {
                            subflow = this.findSubflowInList((DisplayInfo)jei.getJobInfo(), djobs);
                            this.addJobSimpleDependency(depend, subflow, type, null);
                            break;
                        }
                        case 4: 
                        case 5: {
                            job = this.findJobInList((DisplayInfo)jei.getJobInfo(), djobs);
                            this.addJobTimeDependency(depend, job, type, jei.getValue(), null);
                            break;
                        }
                        case 14: 
                        case 15: {
                            subflow = this.findSubflowInList((DisplayInfo)jei.getJobInfo(), djobs);
                            this.addJobTimeDependency(depend, subflow, type, jei.getValue(), null);
                            break;
                        }
                        case 3: {
                            job = this.findJobInList((DisplayInfo)jei.getJobInfo(), djobs);
                            this.addJobExitCodeDependency(depend, job, jei.getOperator(), jei.getValue(), null);
                            break;
                        }
                        case 13: {
                            subflow = this.findSubflowInList((DisplayInfo)jei.getJobInfo(), djobs);
                            this.addJobExitCodeDependency(depend, subflow, jei.getOperator(), jei.getValue(), null);
                        }
                    }
                    continue;
                }
                if (ai instanceof TimeEventInfo) {
                    TimeEventInfo tei = (TimeEventInfo)ai;
                    TimeEvent te = new TimeEvent(tei, this.m_scheduler);
                    if (te.getCalendar() == null) {
                        if (this.m_prompt == null) throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                        String title = MetaUtilities.messageString(m_bundle.getString("DeployedFlow.ConnectToScheduler.fmt"), this.m_scheduler.getName());
                        String[] cred = this.m_prompt.promptLogin(title, null, null);
                        int promptrc = Integer.valueOf(cred[0]);
                        if (promptrc != 1) throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                        int connected = this.m_scheduler.makeConnection(cred[1], cred[2] != null ? new SealedString(cred[2]) : null);
                        if (connected != 1) throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                        te = new TimeEvent(tei, this.m_scheduler);
                        this.m_scheduler.closeConnection();
                        if (te.getCalendar() == null) {
                            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                        }
                    }
                    this.addTimeEvent(depend, te);
                    continue;
                }
                if (!(ai instanceof FileEventInfo)) continue;
                FileEventInfo fei = (FileEventInfo)ai;
                this.addFileEvent(depend, new FileEvent(fei));
            }
            if (dobj instanceof DeployedJob) {
                this.addJobSimpleDependency((DeployedJob)dobj, depend, condition, null);
                return;
            } else {
                if (!(dobj instanceof DeployedFlow)) return;
                this.addJobSimpleDependency((DeployedFlow)dobj, depend, condition, null);
            }
            return;
        } else if (info instanceof JobEventInfo) {
            DeployedJob job = null;
            DeployedFlow subflow = null;
            JobEventInfo jei = (JobEventInfo)info;
            int type = jei.getEventType();
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 8: {
                    job = this.findJobInList((DisplayInfo)jei.getJobInfo(), djobs);
                    if (dobj instanceof DeployedJob) {
                        this.addJobSimpleDependency((DeployedJob)dobj, job, type, null);
                        return;
                    }
                    if (!(dobj instanceof DeployedFlow)) return;
                    this.addJobSimpleDependency((DeployedFlow)dobj, job, type, null);
                    return;
                }
                case 10: 
                case 11: 
                case 16: 
                case 18: {
                    subflow = this.findSubflowInList((DisplayInfo)jei.getJobInfo(), djobs);
                    if (dobj instanceof DeployedJob) {
                        this.addJobSimpleDependency((DeployedJob)dobj, subflow, type, null);
                        return;
                    }
                    if (!(dobj instanceof DeployedFlow)) return;
                    this.addJobSimpleDependency((DeployedFlow)dobj, subflow, type, null);
                    return;
                }
                case 4: 
                case 5: {
                    job = this.findJobInList((DisplayInfo)jei.getJobInfo(), djobs);
                    if (dobj instanceof DeployedJob) {
                        this.addJobTimeDependency((DeployedJob)dobj, job, type, jei.getValue(), null);
                        return;
                    }
                    if (!(dobj instanceof DeployedFlow)) return;
                    this.addJobTimeDependency((DeployedFlow)dobj, job, type, jei.getValue(), null);
                    return;
                }
                case 14: 
                case 15: {
                    subflow = this.findSubflowInList((DisplayInfo)jei.getJobInfo(), djobs);
                    if (dobj instanceof DeployedJob) {
                        this.addJobTimeDependency((DeployedJob)dobj, subflow, type, jei.getValue(), null);
                        return;
                    }
                    if (!(dobj instanceof DeployedFlow)) return;
                    this.addJobTimeDependency((DeployedFlow)dobj, subflow, type, jei.getValue(), null);
                    return;
                }
                case 3: {
                    job = this.findJobInList((DisplayInfo)jei.getJobInfo(), djobs);
                    if (dobj instanceof DeployedJob) {
                        this.addJobExitCodeDependency((DeployedJob)dobj, job, jei.getOperator(), jei.getValue(), null);
                        return;
                    }
                    if (!(dobj instanceof DeployedFlow)) return;
                    this.addJobExitCodeDependency((DeployedFlow)dobj, job, jei.getOperator(), jei.getValue(), null);
                    return;
                }
                case 13: {
                    subflow = this.findSubflowInList((DisplayInfo)jei.getJobInfo(), djobs);
                    if (dobj instanceof DeployedJob) {
                        this.addJobExitCodeDependency((DeployedJob)dobj, subflow, jei.getOperator(), jei.getValue(), null);
                        return;
                    }
                    if (!(dobj instanceof DeployedFlow)) return;
                    this.addJobExitCodeDependency((DeployedFlow)dobj, subflow, jei.getOperator(), jei.getValue(), null);
                }
            }
            return;
        } else if (info instanceof TimeEventInfo) {
            TimeEventInfo tei = (TimeEventInfo)info;
            TimeEvent te = new TimeEvent(tei, this.m_scheduler);
            if (te.getCalendar() == null) {
                if (this.m_prompt == null) throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                String title = MetaUtilities.messageString(m_bundle.getString("DeployedFlow.ConnectToScheduler.fmt"), this.m_scheduler.getName());
                String[] cred = this.m_prompt.promptLogin(title, null, null);
                int promptrc = Integer.valueOf(cred[0]);
                if (promptrc != 1) throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                int connected = this.m_scheduler.makeConnection(cred[1], new SealedString(cred[2]));
                if (connected != 1) throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                te = new TimeEvent(tei, this.m_scheduler);
                this.m_scheduler.closeConnection();
                if (te.getCalendar() == null) {
                    throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.getCalendarName()));
                }
            }
            if (dobj instanceof DeployedJob) {
                this.addTimeEvent((DeployedJob)dobj, te);
                return;
            } else {
                if (!(dobj instanceof DeployedFlow)) return;
                this.addTimeEvent((DeployedFlow)dobj, te);
            }
            return;
        } else {
            if (!(info instanceof FileEventInfo)) return;
            FileEventInfo fei = (FileEventInfo)info;
            if (dobj instanceof DeployedJob) {
                this.addFileEvent((DeployedJob)dobj, new FileEvent(fei));
                return;
            } else {
                if (!(dobj instanceof DeployedFlow)) return;
                this.addFileEvent((DeployedFlow)dobj, new FileEvent(fei));
            }
        }
    }

    private DeployedJob findJobInList(DisplayInfo jinfo, List<Object> djobs) throws RemoteException {
        String id = jinfo.getId();
        for (Object obj : djobs) {
            DeployedJob job;
            if (!(obj instanceof DeployedJob) || (job = (DeployedJob)obj).getId().compareToIgnoreCase(id) != 0) continue;
            return job;
        }
        return null;
    }

    private DeployedFlow findSubflowInList(DisplayInfo sflow, List<Object> djobs) throws RemoteException {
        String id = sflow.getId();
        for (Object obj : djobs) {
            DeployedFlow subflow;
            if (!(obj instanceof DeployedFlow) || (subflow = (DeployedFlow)obj).getId().compareTo(id) != 0) continue;
            return subflow;
        }
        return null;
    }

    private void validateFlowname(String name, Scheduler scheduler) throws IllegalArgumentException, RemoteException, MdException {
        int isValid = this.validateName(name);
        IllegalArgumentException ex = null;
        switch (isValid) {
            case 0: {
                this.createJFJobObject(name, scheduler);
                break;
            }
            case 1: 
            case 2: {
                ex = new IllegalArgumentException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.invalidName.msg.fmt"), MetaUtilities.INVALIDFLOWNAMECHARACTERS));
                throw ex;
            }
            case 3: {
                ex = new IllegalArgumentException(m_bundle.getString("MetaUtilities.notUniqueName.msg.txt"));
                throw ex;
            }
            default: {
                throw new RuntimeException("INTERNAL ERROR: DeployedFlow constructor");
            }
        }
    }

    public void refresh() throws MdException, RemoteException {
        if (this.m_store == null) {
            this.m_store = this.m_factory.createObjectStore(null, "DeployedFlow");
        }
        Map ids = this.m_store.getDeletedObjects();
        for (String id : new ArrayList(ids.keySet())) {
            if (!this.m_deleteList.contains(id)) continue;
            this.m_store.restoreObject(id);
            this.m_deleteList.remove(id);
        }
        try {
            this.m_flow = MetaUtilities.getJFJob(this.m_flow.getId(), this.m_store);
        }
        catch (SchedulerException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            MdException md = new MdException(e.toString());
            md.initCause((Throwable)e);
            throw md;
        }
        catch (NullPointerException e) {
            try {
                if (this.m_info != null) {
                    this.m_flow = MetaUtilities.getJFJob(this.m_info.getId(), this.m_store);
                }
            }
            catch (SchedulerException e1) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                MdException md = new MdException(e1.toString());
                md.initCause((Throwable)e1);
                throw md;
            }
        }
        this.m_store.refreshObjectFromServer((CMetadata)this.m_flow, true, true);
        for (Property prop : this.m_flow.getProperties(true)) {
            this.m_store.refreshObjectFromServer((CMetadata)prop, true, true);
        }
        this.m_activity = (TransformationActivity)this.m_flow.getJobActivities(true).get(0);
        this.m_store.refreshObjectFromServer((CMetadata)this.m_activity, true, true);
        for (TransformationStep step : this.m_flow.getSteps()) {
            if (!(step instanceof SyncStep)) continue;
            this.m_store.refreshObjectFromServer((CMetadata)step, true, true);
        }
        for (TransformationStep step : this.m_activity.getSteps(true)) {
            this.m_store.refreshObjectFromServer((CMetadata)step, true, true);
        }
        this.getSchedulerComponentFromServer();
        this.m_scheduleID = -2L;
        this.setupTriggering(false);
        this.getJobsRefreshedFromServer();
        this.m_info = null;
        this.m_queue = null;
        this.m_data = null;
        this.m_dirty = true;
    }

    public void restoreFromServer() throws MdException, RemoteException {
        this.refresh();
        if (this.m_jobs != null) {
            Iterator<Object> i = this.m_jobs.iterator();
            while (i.hasNext()) {
                ((DeployedJob)i.next()).refresh();
            }
        }
    }

    public long getScheduleID() {
        return this.m_scheduleID;
    }

    public void setScheduleID(long id) {
        this.m_scheduleID = id;
    }

    public String getScheduleDefinition() throws RemoteException {
        return DeployedFlow.getScheduleDefinition(this.m_flow);
    }

    public static String getScheduleDefinition(JFJob flow) throws RemoteException {
        Property property = DeployedFlow.getFlowID(flow);
        if (property != null) {
            return property.getDefaultValue();
        }
        return "";
    }

    public String getExceptionHandlers() throws RemoteException, MdException {
        return DeployedFlow.getExceptionHandlers(this.m_flow);
    }

    public static String getExceptionHandlers(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyDefaultHandler)) continue;
            return property.getDefaultValue();
        }
        return "";
    }

    public boolean setExceptionHandlers(String xml) throws RemoteException, MdException {
        if (DeployedFlow.setExceptionHandlers(this.m_flow, xml)) {
            this.m_dirty = true;
            return true;
        }
        return false;
    }

    public static boolean setExceptionHandlers(JFJob flow, String xml) throws RemoteException, MdException {
        if (xml == null) {
            return false;
        }
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyDefaultHandler)) continue;
            if (xml.compareTo(property.getDefaultValue()) != 0) {
                property.setDefaultValue(xml);
                flow.addElementToChangeList((CMetadata)property);
            }
            return true;
        }
        return false;
    }

    private static Property getFlowID(JFJob flow) {
        block5: {
            try {
                AssociationList properties = flow.getProperties();
                int numprops = properties.size();
                for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                    Property property = (Property)properties.get(propertyCounter);
                    if (!property.getPropertyName().equalsIgnoreCase("SCHEDULEID")) continue;
                    return property;
                }
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (RemoteException ex) {
                if (!MetaUtilities.isDebug()) break block5;
                ex.printStackTrace();
            }
        }
        return null;
    }

    private boolean setScheduleDefinition(String id) throws RemoteException, MdException {
        if (id == null) {
            return false;
        }
        Property property = MetaUtilities.setStringProperty((Root)this.m_flow, "SCHEDULEID", this.m_factory, this.m_store, id);
        if (property != null) {
            if (id.compareTo(property.getDefaultValue()) != 0) {
                property.setDefaultValue(id);
                this.m_flow.addElementToChangeList((CMetadata)property);
                this.m_dirty = true;
            }
            return true;
        }
        return false;
    }

    public String getQueue() {
        if (this.m_queue == null) {
            try {
                this.m_queue = DeployedFlow.getQueue(this.m_flow);
            }
            catch (MdException mde) {
                this.m_queue = null;
            }
            catch (RemoteException re) {
                this.m_queue = null;
            }
        }
        return this.m_queue;
    }

    public static String getQueue(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyDefaultQueue)) continue;
            String value = property.getDefaultValue();
            if (value != null && value.isEmpty()) {
                return null;
            }
            return value;
        }
        return null;
    }

    private boolean setQueue(List<DisplayInfo> jobs, String queue) throws RemoteException, MdException {
        Property existing = MetaUtilities.getPropertyObject((Root)this.m_flow, PropertyDefaultQueue);
        if (existing != null) {
            for (DisplayInfo o : jobs) {
                String neoDetails;
                JobInfo djob;
                String details;
                if (!(o instanceof JobInfo) || (details = (djob = (JobInfo)o).getSchedulerProperties()) == null || (neoDetails = this.m_scheduler.clearJobPropertyOnMatch(djob.getName(), details, PropertyDefaultQueue, existing.getDefaultValue())).equals(details)) continue;
                djob.setSchedulerProperties(neoDetails);
            }
        }
        this.m_dirty = this.setQueue(queue);
        return true;
    }

    public boolean setQueue(String queue) {
        this.m_queue = queue;
        try {
            Property property = MetaUtilities.setStringProperty((Root)this.m_flow, PropertyDefaultQueue, this.m_factory, this.m_store, this.m_queue);
            if (property != null) {
                this.m_flow.addElementToChangeList((CMetadata)property);
                this.m_dirty = true;
            }
        }
        catch (MdException ex) {
            return false;
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public String getScheduledUser() throws MdException, RemoteException {
        return DeployedFlow.getScheduledUser(this.m_flow);
    }

    public static String getScheduledUser(JFJob flow) throws MdException, RemoteException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase("SUBMITTED")) continue;
            String username = property.getDefaultValue();
            if (username.equalsIgnoreCase("1")) {
                return null;
            }
            if (username.equalsIgnoreCase("0")) continue;
            return username;
        }
        return null;
    }

    public boolean isFlowSubmitted() throws MdException, RemoteException {
        return DeployedFlow.isFlowSubmitted(this.m_flow);
    }

    public static boolean isFlowSubmitted(JFJob flow) throws MdException, RemoteException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase("SUBMITTED") || property.getDefaultValue().equalsIgnoreCase("0")) continue;
            return true;
        }
        return false;
    }

    public boolean setFlowSubmitted(boolean submitted) {
        String username = this.m_scheduler != null ? this.m_scheduler.getCurrentUserID() : null;
        return this.setFlowSubmitted(submitted, username);
    }

    private boolean setFlowSubmitted(boolean submitted, String username) {
        try {
            AssociationList properties = this.m_flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase("SUBMITTED")) continue;
                if (submitted) {
                    property.setDefaultValue(username != null ? username : "1");
                } else {
                    try {
                        if (this.m_scheduler != null && this.m_scheduler.isFlowScheduled(this.getInfo())) {
                            this.m_scheduler.removeFlow(this.getInfo());
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                    }
                    catch (SchedulerException ex) {
                        this.m_factory.getUtil().printOutputln(ex.getLocalizedMessage());
                    }
                    catch (Exception ex) {
                        this.m_factory.getUtil().printOutputln(ex.getStackTrace().toString());
                    }
                    property.setDefaultValue("0");
                }
                this.m_flow.addElementToChangeList((CMetadata)property);
                this.m_dirty = true;
                return true;
            }
        }
        catch (MdException ex) {
            return false;
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    public boolean unschedule() {
        boolean unscheduled = true;
        try {
            if (this.m_scheduler.isFlowScheduled(this.getInfo()) && (unscheduled = this.m_scheduler.removeFlow(this.getInfo()))) {
                DeployedFlow.setFlowSubmitted(this.m_flow, this.m_scheduler, false);
                this.commitChangesWithNoValidation();
                return true;
            }
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
        catch (SchedulerException ex) {
            return false;
        }
        return false;
    }

    private static boolean setFlowSubmitted(JFJob flow, Scheduler scheduler, boolean submitted) throws SchedulerException {
        try {
            AssociationList properties = flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase("SUBMITTED")) continue;
                if (submitted) {
                    String username = scheduler.getCurrentUserID();
                    property.setDefaultValue(username != null ? username : "1");
                } else {
                    FlowInfo info = new FlowInfo(flow.getName(), null, scheduler.getServerComponent());
                    String flowname = scheduler.genFlowName(info);
                    if (scheduler.isFlowScheduled(flowname)) {
                        scheduler.removeFlow(flowname);
                    }
                    property.setDefaultValue("0");
                }
                flow.addElementToChangeList((CMetadata)property);
                return true;
            }
        }
        catch (MdException ex) {
            return false;
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DeployedFlow) {
            try {
                return this.m_flow.getId().equalsIgnoreCase(((DeployedFlow)obj).getId());
            }
            catch (RemoteException ex) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.m_flow != null) {
            try {
                int value = 0;
                String id = this.m_flow.getId();
                for (int x = 0; x < id.length(); ++x) {
                    char c = id.charAt(x);
                    value *= 10;
                    value += c;
                }
                return value;
            }
            catch (RemoteException ex) {
                return super.hashCode();
            }
        }
        return super.hashCode();
    }

    public String toString() {
        String text = null;
        try {
            text = this.m_flow.getName();
        }
        catch (RemoteException ex) {
            text = "";
        }
        return text;
    }

    public String getId() throws RemoteException {
        return this.m_flow.getId();
    }

    public JFJob getMetadataObject() {
        return this.m_flow;
    }

    public TransformationActivity getTA() {
        return this.m_activity;
    }

    public static TransformationActivity getTA(JFJob flow) throws RemoteException, MdException {
        return (TransformationActivity)flow.getJobActivities().get(0);
    }

    public HashMap<String, String> getJobNamesList() throws RemoteException, MdException, SchedulerException {
        return DeployedFlow.getJobNamesList(this.m_flow);
    }

    public static HashMap<String, String> getJobNamesList(JFJob flow) throws RemoteException, MdException, SchedulerException {
        String repos;
        HashMap<String, String> jobNames = new HashMap<String, String>();
        MdFactory factory = flow.getObjectStore().getFactory();
        MdObjectStore tempstore = factory.createObjectStore(null, "getJobNamesList");
        String flowid = flow.getId();
        JFJob jfjob1 = MetaUtilities.getJFJob(flowid, "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)tempstore, repos = "A0000001." + flowid.substring(0, 8));
        TransformationActivity ta = (TransformationActivity)jfjob1.getJobActivities().get(0);
        if (ta != null) {
            for (TransformationStep step : ta.getSteps()) {
                if (step instanceof SyncStep) continue;
                try {
                    JFJob jfjob2 = (JFJob)step.getTransformations().get(0);
                    if (jfjob2 == null) continue;
                    jobNames.put(jfjob2.getName(), jfjob2.getId());
                }
                catch (ArrayIndexOutOfBoundsException ex) {}
            }
        }
        tempstore.dispose();
        return jobNames;
    }

    public MdObjectStore getStore() throws RemoteException {
        if (this.m_store == null && this.m_flow != null) {
            this.m_store = (MdObjectStore)this.m_flow.getObjectStore();
        }
        return this.m_store;
    }

    public String getDateCreated(boolean localformat) {
        return DeployedFlow.getDateCreated(this.m_flow, localformat);
    }

    public static String getDateCreated(JFJob flow, boolean localformat) {
        String dtc = null;
        try {
            dtc = MetaUtilities.getDateCreated((CMetadata)flow, localformat);
        }
        catch (RemoteException ex) {
            dtc = ex.getMessage();
        }
        return dtc;
    }

    public Date getDateCreated() {
        return DeployedFlow.getDateCreated(this.m_flow);
    }

    public static Date getDateCreated(JFJob flow) {
        try {
            return MetaUtilities.getDateCreated((CMetadata)flow);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public String getDateModified(boolean localformat) {
        return DeployedFlow.getDateModified(this.m_flow, this.m_activity, localformat);
    }

    public static String getDateModified(JFJob flow, TransformationActivity activity, boolean localformat) {
        String dtm = null;
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(flow);
            try {
                list.addAll((Collection<Object>)flow.getComputeLocations());
                list.addAll((Collection<Object>)flow.getSteps());
                if (activity == null) {
                    activity = (TransformationActivity)flow.getJobActivities().get(0);
                }
                if (activity != null) {
                    list.addAll((Collection<Object>)activity.getSteps());
                }
            }
            catch (MdException ex) {
                list.clear();
                list.add(flow);
                list.add(activity);
            }
            dtm = MetaUtilities.getDateModified(list, localformat);
        }
        catch (RemoteException ex) {
            dtm = ex.getMessage();
        }
        return dtm;
    }

    public Date getDateModified() {
        return DeployedFlow.getDateModified(this.m_flow, this.m_activity);
    }

    public static Date getDateModified(JFJob flow, TransformationActivity activity) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(flow);
            try {
                list.addAll((Collection<Object>)flow.getComputeLocations());
                list.addAll((Collection<Object>)flow.getSteps());
                if (activity == null) {
                    activity = (TransformationActivity)flow.getJobActivities().get(0);
                }
                if (activity != null) {
                    list.addAll((Collection<Object>)activity.getSteps());
                }
            }
            catch (MdException ex) {
                list.clear();
                list.add(flow);
                list.add(activity);
            }
            return MetaUtilities.getDateModified(list);
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public List<Property> getProperties() throws MdException, RemoteException {
        return this.m_flow.getProperties();
    }

    public String getName() throws RemoteException {
        return DeployedFlow.getName(this.m_flow);
    }

    public static String getName(JFJob flow) throws RemoteException {
        if (flow == null) {
            return null;
        }
        return flow.getName();
    }

    public int getDefaultGrouping() {
        return this.m_defaultGrouping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDefaultGrouping(DeployedJob job) throws RemoteException, MdException {
        TransformationStep step = job.getLogicalJob(this.m_activity);
        if (step instanceof SyncStep) {
            return DeployedFlow.getGroupingType((SyncStep)step);
        }
        AssociationList predecessors = step.getPredecessorDependencies();
        if (predecessors.size() != 1) return 32;
        StepPrecedence sp = (StepPrecedence)predecessors.get(0);
        if (sp == null) return 32;
        AssociationList successors = sp.getSuccessors();
        if (successors.size() != 1) return 32;
        TransformationStep predStep = (TransformationStep)successors.get(0);
        if (!(predStep instanceof SyncStep)) return 32;
        if (predStep.getTransformRole().equalsIgnoreCase(StrGroupAnd)) {
            return 31;
        }
        if (!predStep.getTransformRole().equalsIgnoreCase(StrGroupOr)) return 32;
        return 32;
    }

    public static int getGroupingType(SyncStep step) throws RemoteException {
        if (step.getTransformRole().equalsIgnoreCase(StrGroupAnd)) {
            return 31;
        }
        return 32;
    }

    public Tree getFolder() throws RemoteException, MdException {
        return DeployedFlow.getFolder(this.m_flow);
    }

    public static Tree getFolder(JFJob flow) throws RemoteException, MdException {
        AssociationList trees = flow.getTrees();
        if (trees.size() > 0) {
            return (Tree)trees.get(0);
        }
        return null;
    }

    public boolean setFolder(Tree folder) throws RemoteException, MdException {
        AssociationList trees = this.m_flow.getTrees();
        trees.clear();
        return trees.add(folder);
    }

    public void setResponsiblePartyForDeployment(String person) throws RemoteException, MdException {
        String repos = "A0000001." + this.m_flow.getId().substring(0, 8);
        DeployedFlow.setResponsiblePartyForDeployment(person, this.m_flow, this.m_store, repos);
    }

    public static boolean setResponsiblePartyForDeployment(String party, JFJob flow, MdObjectStore store, String repos) throws RemoteException, MdException {
        if (party == null) {
            return false;
        }
        AssociationList list = flow.getResponsibleParties(true);
        for (int x = list.size() - 1; x >= 0; --x) {
            ResponsibleParty rp = (ResponsibleParty)list.get(x);
            if (rp.getRole().compareTo("Reporting_Scheduler_Job_Owner") != 0) continue;
            list.remove(x);
        }
        Person person = MetaUtilities.createPerson(party, store, repos);
        if (person != null) {
            ResponsibleParty rparty = MetaUtilities.getResposibleParty(person, "Reporting_Scheduler_Job_Owner");
            list.add((Object)rparty);
            flow.setResponsibleParties(list);
            return true;
        }
        return false;
    }

    public String getResponsiblePartyForDeployment() throws RemoteException, MdException {
        return DeployedFlow.getResponsibleUser(this.m_flow);
    }

    public static String getResponsiblePartyForDeployment(JFJob flow) throws RemoteException, MdException {
        return DeployedFlow.getResponsibleUser(flow);
    }

    private static String getResponsibleUser(JFJob flow) throws RemoteException, MdException {
        String person = null;
        AssociationList list = flow.getResponsibleParties();
        for (Object element : list) {
            AssociationList persons;
            if (!(element instanceof ResponsibleParty)) continue;
            ResponsibleParty party = (ResponsibleParty)element;
            if (party.getRole().equals("Reporting_Scheduler_Job_Owner")) {
                persons = ((ResponsibleParty)element).getPersons();
                if (persons.size() <= 0) continue;
                return ((Identity)persons.get(0)).getName();
            }
            if (!party.getRole().equals("Modified By") || (persons = ((ResponsibleParty)element).getPersons()).size() <= 0) continue;
            person = ((Identity)persons.get(0)).getName();
        }
        return person;
    }

    public AssociationList getResposibleParty() throws RemoteException, MdException {
        if (this.m_flow != null) {
            return this.m_flow.getResponsibleParties();
        }
        return null;
    }

    public boolean addResposibleParty(ResponsibleParty party) throws RemoteException, MdException {
        if (party != null && this.m_flow != null) {
            return this.m_flow.getResponsibleParties().add((Object)party);
        }
        return false;
    }

    public boolean setResposibleParties(AssociationList list) throws RemoteException {
        if (this.m_flow != null) {
            this.m_flow.setResponsibleParties(list);
            return true;
        }
        return false;
    }

    public boolean setResposibleParties(List<Root> list) throws RemoteException, MdException {
        if (this.m_flow != null) {
            this.m_flow.getResponsibleParties().clear();
            this.m_flow.getResponsibleParties().addAll(list);
            return true;
        }
        return false;
    }

    public boolean removeJob(DeployedJob job) {
        if (this.m_jobs == null) {
            return false;
        }
        if (this.m_jobs.remove(job)) {
            try {
                return job.remove(this);
            }
            catch (MdException mde) {
                return false;
            }
            catch (RemoteException mde) {
                return false;
            }
        }
        return false;
    }

    public boolean removeJob(DeployedFlow subflow) {
        if (this.m_jobs == null) {
            return false;
        }
        if (this.m_jobs.remove(subflow)) {
            try {
                return subflow.remove(this);
            }
            catch (MdException mde) {
                return false;
            }
            catch (RemoteException mde) {
                return false;
            }
        }
        return false;
    }

    public boolean remove(DeployedFlow dflow) throws MdException, RemoteException {
        JFJob flow = dflow.getMetadataObject();
        if (flow != null) {
            AssociationList steps = this.m_flow.getSteps();
            int numsteps = steps.size();
            for (int i = 0; i < numsteps; ++i) {
                AssociationList transformations;
                TransformationStep step;
                if (steps.get(i) instanceof SyncStep || (step = (TransformationStep)steps.get(i)).getActivities() == null || step.getActivities().size() <= 0) continue;
                TransformationActivity activity = (TransformationActivity)step.getActivities().get(0);
                JFJob currentFlow = null;
                AssociationList associationList = transformations = activity != null ? activity.getJobs() : null;
                if (transformations != null && transformations.size() > 0) {
                    currentFlow = (JFJob)transformations.get(0);
                }
                if (currentFlow == null || !flow.getFQID().equalsIgnoreCase(currentFlow.getFQID())) continue;
                DeployedJob.deleteEvents(step);
                step.delete();
                step.updateMetadataAll();
                dflow.removeJob(this);
                dflow.refresh();
                break;
            }
        }
        return true;
    }

    public void removeThisSubFlowFromAllFlows() throws MdException, RemoteException {
        ArrayList<TransformationStep> deleteList = new ArrayList<TransformationStep>();
        Object[] steps = this.m_flow.getSteps().toArray();
        int stlen = steps.length;
        for (int j = stlen - 1; j >= 0; --j) {
            if (steps[j] instanceof SyncStep) continue;
            TransformationStep step = (TransformationStep)steps[j];
            DeployedJob.deleteEvents(step);
            deleteList.add(step);
        }
        if (deleteList.size() > 0) {
            this.m_factory.deleteMetadataObjects(deleteList);
        }
    }

    public List<Object> getJobsRefreshedFromServer() {
        this.m_jobs = new ArrayList<Object>();
        this.m_JobsInError = new ArrayList();
        try {
            for (TransformationStep step : this.m_activity.getSteps(true)) {
                if (step instanceof SyncStep) continue;
                try {
                    JFJob jfjob = (JFJob)step.getTransformations(true).get(0);
                    if (step.getTransformRole().equalsIgnoreCase(RoleFlow)) {
                        DeployedFlow sflow = new DeployedFlow(jfjob, this.m_store);
                        sflow.refresh();
                        if (sflow.hasErrors()) {
                            this.m_errorFlag |= 0x10;
                            this.m_JobsInError.add(sflow);
                        }
                        this.m_jobs.add(sflow);
                        continue;
                    }
                    if (!step.getTransformRole().equalsIgnoreCase(RoleJob)) continue;
                    DeployedJob djob = new DeployedJob(jfjob);
                    djob.refresh();
                    if (djob.hasErrors()) {
                        this.m_errorFlag |= 0x10;
                        this.m_JobsInError.add(djob);
                    }
                    this.m_jobs.add(djob);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    this.m_errorFlag |= 0x10;
                    this.m_JobsInError.add(step);
                }
            }
        }
        catch (MdException ex) {
            this.m_jobs = null;
        }
        catch (RemoteException ex) {
            this.m_jobs = null;
        }
        return this.m_jobs;
    }

    public List<Object> getJobs() {
        return this.m_jobs;
    }

    public void checkJobsJCL() throws SchedulerException {
        for (Object obj : this.m_jobs) {
            if (!(obj instanceof DeployedJob)) continue;
            ((DeployedJob)obj).checkJCLGeneration();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FlowInfo getInfo(JFJob flow, MdObjectStore store, boolean displayOnly) throws RemoteException, MdException {
        try {
            HashMap<Object, AbstractEventInfo> events;
            ArrayList<Object> jobs;
            ArrayList availableTriggers;
            TriggerEventInfo trigger;
            SchedulerServerInfo scheduler;
            block57: {
                scheduler = null;
                Scheduler schedulerServer = null;
                try {
                    ServerComponent sc = (ServerComponent)flow.getComputeLocations().get(0);
                    schedulerServer = MetaUtilities.getSchedulingServer(sc);
                    scheduler = schedulerServer.getServerComponent();
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    scheduler = null;
                }
                if (displayOnly) {
                    FlowInfo info = new FlowInfo(flow.getName(), null, scheduler);
                    String pfddata = DeployedFlow.getPFD(flow);
                    if (pfddata != null) {
                        FlowPFD pfd = new FlowPFD(pfddata);
                        info.setPFD(pfd);
                    }
                    info.setDescription(flow.getDesc());
                    info.setId(flow.getFQID());
                    Date d = DeployedFlow.getDateCreated(flow);
                    if (d != null) {
                        GregorianCalendar ccal = new GregorianCalendar();
                        ccal.setTime(d);
                        info.setCreationDateDataBinding((Calendar)ccal);
                    }
                    if ((d = DeployedFlow.getDateModified(flow, (TransformationActivity)flow.getJobActivities().get(0))) != null) {
                        GregorianCalendar mcal = new GregorianCalendar();
                        mcal.setTime(d);
                        info.setModifiedDateDataBinding((Calendar)mcal);
                    }
                    info.setResponsiblePartyDataBinding(DeployedFlow.getResponsiblePartyForDeployment(flow));
                    info.setFlowSubmitted(DeployedFlow.isFlowSubmitted(flow), DeployedFlow.getScheduledUser(flow));
                    Tree folder = DeployedFlow.getFolder(flow);
                    if (folder != null) {
                        info.setLocation(MetaUtilities.getFolderLocation(folder));
                        info.setLocationId(folder.getId());
                    }
                    info.setDisplayOnly(displayOnly);
                    return info;
                }
                trigger = null;
                availableTriggers = new ArrayList();
                jobs = new ArrayList<Object>();
                events = new HashMap<Object, AbstractEventInfo>();
                ArrayList<TransformationStep> deletelist = new ArrayList<TransformationStep>();
                trigger = DeployedFlow.getTriggerEvent(flow, availableTriggers, schedulerServer, store.getFactory());
                TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
                Iterator it = null;
                if (activity != null) {
                    it = activity.getSteps().iterator();
                }
                while (it != null && it.hasNext()) {
                    TransformationStep step = (TransformationStep)it.next();
                    if (step instanceof SyncStep) {
                        if (step.getSuccessorDependencies().size() != 0 || step.getPredecessorDependencies().size() != 0) continue;
                        try {
                            Event event = (Event)step.getTriggeringEvents().get(0);
                            int n = event.getProperties().size();
                            if (n != 0) continue;
                            deletelist.add(step);
                        }
                        catch (RuntimeException e) {
                            deletelist.add(step);
                        }
                        continue;
                    }
                    JFJob jfjob = null;
                    try {
                        jfjob = (JFJob)step.getTransformations().get(0);
                        if (step.getTransformRole().equalsIgnoreCase(RoleJob)) {
                            String runas;
                            String resources;
                            File jcl;
                            File source;
                            Tree folder;
                            void var14_24;
                            Object var14_22 = null;
                            ServerComponent bs = CommandUtilities.getServerComponentForJob(jfjob);
                            if (bs != null) {
                                int operatingsystem = CommandUtilities.getTargetOSForBatchServer(bs);
                                BatchServerInfo batchServerInfo = new BatchServerInfo(bs.getName(), bs.getClassIdentifier(), operatingsystem);
                                MetaUtilities.setBatchServerProperties(batchServerInfo, bs);
                            }
                            JobInfo job = new JobInfo(jfjob.getName(), jfjob.getFQID(), (BatchServerInfo)var14_24);
                            GregorianCalendar ccal = new GregorianCalendar();
                            Date d = DeployedJob.getDateCreated(jfjob);
                            if (d != null) {
                                ccal.setTime(d);
                                job.setCreationDateDataBinding((Calendar)ccal);
                            }
                            GregorianCalendar mcal = new GregorianCalendar();
                            d = DeployedJob.getDateModified(jfjob);
                            if (d != null) {
                                mcal.setTime(d);
                                job.setModifiedDateDataBinding((Calendar)mcal);
                            }
                            if ((folder = DeployedJob.getFolder(jfjob)) != null) {
                                job.setLocation(MetaUtilities.getFolderLocation(folder));
                                job.setLocationId(folder.getId());
                            }
                            Job jobObj = jfjob.getAssociatedJob();
                            DisplayInfo j = null;
                            if (jobObj != null) {
                                j = new DisplayInfo(jobObj.getName(), null, null);
                                j.setId(jobObj.getId());
                                job.setJob(j);
                            }
                            if ((source = DeployedJob.getSourceCode(jfjob)) != null) {
                                String filename = source.getFileName();
                                String fileext = source.getFileExtension();
                                if (fileext != null && fileext.length() > 0) {
                                    filename = filename + "." + fileext;
                                }
                                job.setSourceFile(filename);
                                AssociationList dirs = source.getDirectories();
                                if (dirs.size() != 0) {
                                    Directory dir = (Directory)dirs.get(0);
                                    job.setSourceDir(new DirectoryInfo(dir.getName(), dir.getDirectoryName()));
                                }
                                if (j != null) {
                                    String repos = "A0000001." + jobObj.getId().substring(0, 8);
                                    job.setOriginalSourceFileDataBinding(DeployedJob.getSourceCodes(j, store, repos));
                                }
                            }
                            if ((jcl = DeployedJob.getJCL(jfjob)) != null) {
                                job.setRawCommandLine(CommandUtilities.getActualCommandLine(jfjob, flow.getName()));
                                String jclname = jcl.getFileName();
                                String jclext = jcl.getFileExtension();
                                if (jclext != null && jclext.length() > 0) {
                                    jclname = jclname + "." + jclext;
                                }
                                String filepath = "";
                                AssociationList dirs = jcl.getDirectories();
                                if (dirs.size() != 0) {
                                    Directory dir = (Directory)dirs.get(0);
                                    filepath = dir.getDirectoryName();
                                }
                                job.setJCL(CommandUtilities.createFullPath(filepath, jclname, CommandUtilities.getTargetOSForBatchServer(bs)));
                            }
                            step.setName(JobEvent.getName(jfjob));
                            String cmdOverride = DeployedJob.getCmdLineProperty((Root)jfjob);
                            if (cmdOverride != null) {
                                job.setCommandLine(cmdOverride, false);
                            } else {
                                job.setCommandLine(CommandUtilities.getCommandLine(jfjob, flow.getName()), true);
                            }
                            job.setResponsiblePartyDataBinding(DeployedJob.getResponsiblePartyForDeployment(jfjob));
                            job.setJobArgs(DeployedJob.getJobArgs(jfjob));
                            job.setEncodedArgs(DeployedJob.getEncodedJobArgsProperty(jfjob));
                            String schedulingDetails = DeployedJob.getSchedulingDetails(step);
                            if (schedulingDetails != null && schedulingDetails.length() > 0) {
                                job.setSchedulerProperties(schedulingDetails);
                            }
                            if ((resources = DeployedJob.getResources((Root)step)) != null && resources.length() > 0) {
                                job.setSchedulerResources(resources);
                            }
                            if ((runas = DeployedJob.getRunAs((Root)step)) != null && runas.length() > 0) {
                                job.setUserId(runas);
                            }
                            job.setDisplayOnly(false);
                            jobs.add(job);
                            AbstractEventInfo elist = DeployedFlow.getComplexEvents(step, job.getName(), job.getId(), flow.getName(), schedulerServer, false);
                            events.put(job, elist);
                            continue;
                        }
                        if (step.getTransformRole().equalsIgnoreCase(RoleFlow)) {
                            void var14_28;
                            Object var14_25 = null;
                            try {
                                ServerComponent sc2 = (ServerComponent)flow.getComputeLocations().get(0);
                                Scheduler s2 = MetaUtilities.getSchedulingServer(sc2);
                                SchedulerServerInfo schedulerServerInfo = s2.getServerComponent();
                            }
                            catch (ArrayIndexOutOfBoundsException aioobe) {
                                Object var14_27 = null;
                            }
                            JFJob subflow = (JFJob)step.getTransformations().get(0);
                            ArrayList availableTriggers2 = new ArrayList();
                            TriggerEventInfo trigger2 = DeployedFlow.getTriggerEvent(subflow, availableTriggers2, schedulerServer, store.getFactory());
                            FlowInfo sflow = new FlowInfo(jfjob.getName(), trigger2, (SchedulerServerInfo)var14_28);
                            sflow.setId(jfjob.getId());
                            jobs.add(sflow);
                            sflow.setSchedulerQueue(DeployedFlow.getQueue(subflow));
                            try {
                                sflow.setJobDefaultEmailNotification(DeployedFlow.isJobDefaultNotifyEmail(subflow), DeployedFlow.getJobDefaultEmailNotificationLevel(subflow), DeployedFlow.getJobDefaultEmailAddress(subflow));
                            }
                            catch (SchedulerException se) {
                                sflow.setJobDefaultEmailNotification(false, -1, "");
                            }
                            sflow.setJobDefaultPriority(DeployedFlow.getJobDefaultPriority(subflow));
                            sflow.setJobDefaultEnvironmentVariables(DeployedFlow.getJobDefaultEnvironmentVariables(subflow));
                            sflow.setJobDefaultExceptionHandlers(DeployedFlow.getJobDefaultExceptionHandlers(subflow));
                            AbstractEventInfo elist = DeployedFlow.getComplexEvents(step, sflow.getName(), sflow.getId(), flow.getName(), schedulerServer, false);
                            events.put(sflow, elist);
                            continue;
                        }
                        String string = jfjob.getTransformRole();
                        if (string.compareTo("SCHEDULER_FLOW_DELETE") != 0 && string.compareTo("SCHEDULER_JOB_DELETE") != 0) continue;
                        deletelist.add(step);
                    }
                    catch (InvalidParameterException invalidParameterException) {
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    }
                    catch (RuntimeException runtimeException) {
                        if (!MetaUtilities.isDebug()) continue;
                        runtimeException.printStackTrace();
                    }
                }
                if (deletelist.size() > 0) {
                    try {
                        store.getFactory().deleteMetadataObjects(deletelist);
                    }
                    catch (Exception ex) {
                        if (!MetaUtilities.isDebug()) break block57;
                        ex.printStackTrace();
                    }
                }
            }
            FlowInfo info = new FlowInfo(flow.getName(), trigger, jobs, scheduler);
            info.setDisplayOnly(displayOnly);
            info.setTriggerEventList(availableTriggers);
            for (Object e : jobs) {
                if (e instanceof JobInfo) {
                    JobInfo job = (JobInfo)e;
                    AbstractEventInfo elist = (AbstractEventInfo)events.get(e);
                    info.addEvent((DisplayInfo)job, elist);
                    continue;
                }
                if (!(e instanceof FlowInfo)) continue;
                FlowInfo sflow = (FlowInfo)e;
                JobInfo jobinfo = new JobInfo(sflow.getName(), sflow.getId(), null);
                jobinfo.setDisplayOnly(true);
                AbstractEventInfo elist = (AbstractEventInfo)events.get(e);
                info.addEvent((DisplayInfo)jobinfo, elist);
            }
            String string = DeployedFlow.getPFD(flow);
            if (string != null) {
                FlowPFD pfd = new FlowPFD(string);
                info.setPFD(pfd);
            }
            info.setDescription(flow.getDesc());
            info.setId(flow.getFQID());
            Date d = DeployedFlow.getDateCreated(flow);
            if (d != null) {
                GregorianCalendar ccal = new GregorianCalendar();
                ccal.setTime(d);
                info.setCreationDateDataBinding((Calendar)ccal);
            }
            if ((d = DeployedFlow.getDateModified(flow, (TransformationActivity)flow.getJobActivities().get(0))) != null) {
                GregorianCalendar mcal = new GregorianCalendar();
                mcal.setTime(d);
                info.setModifiedDateDataBinding((Calendar)mcal);
            }
            info.setFlowSubmitted(DeployedFlow.isFlowSubmitted(flow), DeployedFlow.getScheduledUser(flow));
            info.setTriggerType(DeployedFlow.getTriggerType(flow));
            info.setScheduleDefinitionId(DeployedFlow.getScheduleDefinition(flow));
            info.setResponsiblePartyDataBinding(DeployedFlow.getResponsiblePartyForDeployment(flow));
            info.setSchedulerQueue(DeployedFlow.getQueue(flow));
            try {
                info.setEmailNotification(DeployedFlow.isNotifyEmail(flow), DeployedFlow.getEmailNotificationLevel(flow), DeployedFlow.getEmailAddress(flow));
            }
            catch (SchedulerException se) {
                info.setEmailNotification(false, -1, "");
            }
            try {
                info.setCompletion(DeployedFlow.hasAdvanceCompletion(flow), DeployedFlow.getCompletionLevel(flow), DeployedFlow.getCompletionSelectedJobs(flow));
                info.setEndBehaviorDataBinding(Integer.valueOf(DeployedFlow.getEndbehavior(flow)));
                info.setExitcodeBehaviorDataBinding(Integer.valueOf(DeployedFlow.getExitcodebehavior(flow)));
            }
            catch (SchedulerException se) {
                info.setCompletion(false, 0, null);
                info.setEndBehaviorDataBinding(Integer.valueOf(0));
                info.setExitcodeBehaviorDataBinding(Integer.valueOf(0));
            }
            info.setExclusive(DeployedFlow.hasExclusive(flow));
            info.setSaveLayout(DeployedFlow.saveLayout(flow));
            try {
                info.setJobDefaultEmailNotification(DeployedFlow.isJobDefaultNotifyEmail(flow), DeployedFlow.getJobDefaultEmailNotificationLevel(flow), DeployedFlow.getJobDefaultEmailAddress(flow));
            }
            catch (SchedulerException se) {
                info.setJobDefaultEmailNotification(false, -1, "");
            }
            info.setJobDefaultPriority(DeployedFlow.getJobDefaultPriority(flow));
            info.setJobDefaultEnvironmentVariables(DeployedFlow.getJobDefaultEnvironmentVariables(flow));
            info.setJobDefaultExceptionHandlers(DeployedFlow.getJobDefaultExceptionHandlers(flow));
            Tree folder = DeployedFlow.getFolder(flow);
            if (folder != null) {
                info.setLocation(MetaUtilities.getFolderLocation(folder));
                info.setLocationId(folder.getId());
            }
            return info;
        }
        catch (RuntimeException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public boolean checkInfoAfterSelectingTriggers(FlowInfo flowinfo) throws SchedulerException {
        boolean changed = false;
        boolean updateInfo = this.m_info != null ? !this.m_info.equals(flowinfo) : false;
        try {
            boolean listChanged;
            String id2;
            SchedulerServerInfo schinfo = null;
            if (this.m_scheduler != null) {
                schinfo = this.m_scheduler.getServerComponent();
            }
            ArrayList<TriggerEventInfo> triggers = new ArrayList<TriggerEventInfo>();
            TriggerEventInfo trigger = this.getTriggerEventInfo(triggers, schinfo, false);
            List list = flowinfo.getFlowTriggerEvents("Event");
            TriggerEventInfo trigger2 = flowinfo.getTriggerEvent();
            String id = trigger != null && trigger.getId() != null ? trigger.getId() : "unset";
            String string = id2 = trigger2 != null && trigger2.getId() != null ? trigger2.getId() : "missing";
            if (id.compareTo(id2) != 0) {
                String type = flowinfo.getTriggerType();
                if (type.compareTo("RunNow") != 0) {
                    if (type.compareTo("Manual") == 0) {
                        if (!this.getTriggerType().equals("Manual")) {
                            TriggerEvent tevent = new TriggerEvent(this.m_scheduler, m_bundle.getString("DeployedFlow.Manual.txt"), "Manual");
                            this.setTriggerEvent(tevent);
                            trigger2 = tevent.getInfo();
                            changed = true;
                        }
                    } else {
                        if (trigger2.getEvent() instanceof GroupingEventInfo) {
                            SyncStep step = this.setupTriggering(true);
                            trigger2.setId(step.getId());
                        }
                        String reposID = "A0000001." + this.m_repos;
                        TriggerEvent tevent = new TriggerEvent(trigger2, this.m_scheduler, this.m_store, reposID);
                        this.setTriggerEvent(tevent);
                        changed = true;
                    }
                }
                if (updateInfo) {
                    this.m_info.setTriggerEvent(trigger2);
                }
            }
            boolean bl = listChanged = list.size() != triggers.size();
            if (!listChanged) {
                for (int i = 0; i < list.size(); ++i) {
                    TriggerEventInfo t = (TriggerEventInfo)list.get(i);
                    String text = t.toString();
                    boolean found = false;
                    Iterator it = triggers.iterator();
                    while (!found && it.hasNext()) {
                        TriggerEventInfo te = (TriggerEventInfo)it.next();
                        if (te.toString().compareTo(text) != 0) continue;
                        found = true;
                    }
                    if (found) continue;
                    listChanged = true;
                    break;
                }
            }
            if (listChanged) {
                ArrayList<TriggerEvent> neoList = new ArrayList<TriggerEvent>();
                for (int i = 0; i < list.size(); ++i) {
                    TimeEvent temp;
                    TriggerEventInfo t = (TriggerEventInfo)list.get(i);
                    TriggerEvent tevent = new TriggerEvent(t, this.m_scheduler, this.m_store, this.m_repos);
                    neoList.add(tevent);
                    Event eventobj = tevent.getEvent();
                    if (eventobj == null || eventobj.getEventRole().compareToIgnoreCase(RoleTimeEvent) != 0 || (temp = tevent.getTimeEvent()) == null) continue;
                    MetaUtilities.setStringProperty((Root)eventobj, "Definition", this.m_factory, this.m_store, temp.generateDefinition());
                    Property prop = MetaUtilities.setStringProperty((Root)eventobj, PropertyTimeEventCalDefinitionName, this.m_factory, this.m_store, temp.generateCalendarDefinition());
                    prop.setDesc(temp.getCalendarName());
                }
                this.setTriggerEventList(neoList);
                if (updateInfo) {
                    this.m_info.setTriggerEventList(flowinfo.getFlowTriggerEvents());
                }
                changed = true;
            }
            return changed;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public boolean updateInfoAfterScheduled(FlowInfo flowinfo) throws SchedulerException {
        boolean changed = false;
        boolean updateInfo = this.m_info != null ? !this.m_info.equals(flowinfo) : false;
        try {
            String newDef;
            long id;
            String username2;
            boolean scheduled = this.isFlowSubmitted();
            String username = this.getScheduledUser() != null ? this.getScheduledUser() : "";
            String string = username2 = flowinfo.getScheduledUser() != null ? flowinfo.getScheduledUser() : "";
            if (scheduled != flowinfo.isFlowSubmitted() || username.compareTo(username2) != 0) {
                this.setFlowSubmitted(flowinfo.isFlowSubmitted(), username2);
                if (updateInfo) {
                    this.m_info.setFlowSubmitted(flowinfo.isFlowSubmitted(), username2);
                }
                changed = true;
            }
            if ((id = this.getScheduleID()) != flowinfo.getScheduleID()) {
                this.setScheduleID(flowinfo.getScheduleID());
                if (updateInfo) {
                    this.m_info.setScheduleID(flowinfo.getScheduleID());
                }
                changed = true;
            }
            String def = this.getScheduleDefinition();
            String string2 = newDef = flowinfo.getScheduleDefinitionId() != null ? flowinfo.getScheduleDefinitionId() : "NULLVALUE";
            if (def.compareTo(newDef) != 0) {
                this.setScheduleDefinition(flowinfo.getScheduleDefinitionId());
                if (updateInfo) {
                    this.m_info.setScheduleDefinitionId(flowinfo.getScheduleDefinitionId());
                }
                changed = true;
            }
            if (changed) {
                return this.commitChanges();
            }
            return true;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public FlowInfo getInfo() throws SchedulerException {
        try {
            if (this.m_info != null && !this.m_dirty) {
                return this.m_info;
            }
            SchedulerServerInfo schinfo = null;
            if (this.m_scheduler != null) {
                schinfo = this.m_scheduler.getServerComponent();
            }
            ArrayList<TriggerEventInfo> triggerList = new ArrayList<TriggerEventInfo>();
            TriggerEventInfo tinfo = this.getTriggerEventInfo(triggerList, schinfo);
            FlowPFD pfd = null;
            String pfdData = this.getPFD();
            if (pfdData != null) {
                pfd = new FlowPFD(pfdData);
            }
            this.m_info = new FlowInfo(this.m_flow.getName(), tinfo, schinfo);
            Tree folder = this.getFolder();
            if (folder != null) {
                this.m_info.setLocation(MetaUtilities.getFolderLocation(folder));
                this.m_info.setLocationId(folder.getId());
            }
            this.m_info.setTriggerEventList(triggerList);
            this.m_info.setTriggerType(this.getTriggerType());
            this.m_info.setId(this.m_flow.getFQID());
            Date d = DeployedFlow.getDateCreated(this.m_flow);
            if (d != null) {
                GregorianCalendar ccal = new GregorianCalendar();
                ccal.setTime(d);
                this.m_info.setCreationDateDataBinding((Calendar)ccal);
            }
            if ((d = DeployedFlow.getDateModified(this.m_flow, this.m_activity)) != null) {
                GregorianCalendar mcal = new GregorianCalendar();
                mcal.setTime(d);
                this.m_info.setModifiedDateDataBinding((Calendar)mcal);
            }
            this.m_info.setScheduleID(this.getScheduleID());
            this.m_info.setDescription(this.m_flow.getDesc());
            this.m_info.setFlowSubmitted(this.isFlowSubmitted(), this.getScheduledUser());
            this.m_info.setScheduleDefinitionId(this.getScheduleDefinition());
            this.m_info.setSchedulerQueue(this.getQueue());
            this.m_info.setResponsiblePartyDataBinding(this.getResponsiblePartyForDeployment());
            if (pfd != null) {
                this.m_info.setPFD(pfd);
            }
            this.setJobInfo(this.m_info, this.m_scheduler);
            if (this.isNotifyEmail()) {
                this.m_info.setEmailNotification(true, this.getEmailNotificationLevel(), this.getEmailAddress());
            } else {
                this.m_info.setEmailNotification(false, this.getEmailNotificationLevel(), this.getEmailAddress());
            }
            if (this.hasAdvanceCompletion()) {
                this.m_info.setCompletion(true, this.getCompletionLevel(), this.getCompletionSelectedJobs());
            } else {
                this.m_info.setCompletion(false, this.getCompletionLevel(), this.getCompletionSelectedJobs());
            }
            this.m_info.setEndBehaviorDataBinding(Integer.valueOf(this.getEndbehavior()));
            this.m_info.setExitcodeBehaviorDataBinding(Integer.valueOf(this.getExitcodebehavior()));
            this.m_info.setExclusive(this.hasExclusive());
            this.m_info.setSaveLayout(this.saveLayout());
            if (this.isJobDefaultNotifyEmail()) {
                this.m_info.setJobDefaultEmailNotification(true, this.getJobDefaultEmailNotificationLevel(), this.getJobDefaultEmailAddress());
            } else {
                this.m_info.setJobDefaultEmailNotification(false, this.getJobDefaultEmailNotificationLevel(), this.getJobDefaultEmailAddress());
            }
            this.m_info.setJobDefaultPriority(this.getJobDefaultPriority());
            this.m_info.setJobDefaultEnvironmentVariables(this.getJobDefaultEnvironmentVariables());
            this.m_info.setJobDefaultExceptionHandlers(this.getJobDefaultExceptionHandlers());
            this.resetDirty(1);
            return this.m_info;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public static void setJobsInInfo(FlowInfo info, MdObjectStore store) throws RemoteException, MdException, SchedulerException {
        ArrayList<Object> jobs = new ArrayList<Object>();
        String flowid = info.getId();
        String repos = "A0000001." + flowid.substring(0, 8);
        JFJob flow = MetaUtilities.getJFJob(flowid, (MdStore)store, repos);
        TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
        Iterator it = null;
        if (activity != null) {
            it = activity.getSteps().iterator();
        }
        while (it != null && it.hasNext()) {
            TransformationStep step = (TransformationStep)it.next();
            if (step instanceof SyncStep) continue;
            JFJob jfjob = null;
            try {
                jfjob = (JFJob)step.getTransformations().get(0);
                if (step.getTransformRole().equalsIgnoreCase(RoleJob)) {
                    Tree folder;
                    JobInfo job = new JobInfo(jfjob.getName(), jfjob.getFQID(), null);
                    job.setDisplayOnly(true);
                    Date d = DeployedJob.getDateCreated(jfjob);
                    if (d != null) {
                        GregorianCalendar ccal = new GregorianCalendar();
                        ccal.setTime(d);
                        info.setCreationDateDataBinding((Calendar)ccal);
                    }
                    if ((d = DeployedJob.getDateModified(jfjob)) != null) {
                        GregorianCalendar mcal = new GregorianCalendar();
                        mcal.setTime(d);
                        info.setModifiedDateDataBinding((Calendar)mcal);
                    }
                    if ((folder = DeployedJob.getFolder(jfjob)) != null) {
                        job.setLocation(MetaUtilities.getFolderLocation(folder));
                        job.setLocationId(folder.getId());
                    }
                    job.setResponsiblePartyDataBinding(DeployedJob.getResponsiblePartyForDeployment(jfjob));
                    jobs.add(job);
                    continue;
                }
                if (!step.getTransformRole().equalsIgnoreCase(RoleFlow)) continue;
                FlowInfo sflow = new FlowInfo(jfjob.getName(), null, null);
                sflow.setId(jfjob.getId());
                sflow.setDisplayOnly(true);
                jobs.add(sflow);
            }
            catch (InvalidParameterException ex) {
            }
            catch (ArrayIndexOutOfBoundsException ex) {}
        }
        info.setJobs(jobs);
    }

    private void setJobInfo(FlowInfo info, Scheduler scheduler) throws RemoteException, MdException, SchedulerException {
        ArrayList<Object> jobsinfo = new ArrayList<Object>();
        for (Object obj : this.getJobs()) {
            AbstractEventInfo events = null;
            JobInfo jobinfo = null;
            if (obj instanceof DeployedJob) {
                DeployedJob job = (DeployedJob)obj;
                jobinfo = job.getInfo(info.getName());
                jobinfo.setId(job.getId());
                GroupingEventInfo ginfo = info.getLogicalGrouping(jobinfo);
                if (ginfo == null) {
                    ginfo = this.getDefaultGrouping(job) == 31 ? new GroupingEventInfo(jobinfo, 0) : new GroupingEventInfo(jobinfo, 1);
                }
                info.setLogicalGrouping(jobinfo, ginfo);
                jobsinfo.add(jobinfo);
                events = this.getComplexEvents(job, info.getName(), scheduler, true);
                info.addEvent((DisplayInfo)jobinfo, events);
                continue;
            }
            if (!(obj instanceof DeployedFlow)) continue;
            DeployedFlow subflow = (DeployedFlow)obj;
            FlowInfo sfinfo = subflow.getInfo();
            jobsinfo.add(sfinfo);
            events = this.getComplexEvents(subflow, info.getName(), scheduler, true);
            info.addEvent((DisplayInfo)sfinfo, events);
        }
        info.setJobs(jobsinfo);
    }

    public JTable getTable(boolean readFromServer) throws MdException, RemoteException, InvalidParameterException {
        JTable table = null;
        if (this.m_data == null || this.m_dirty || readFromServer) {
            Vector list = null;
            try {
                list = this.getData(readFromServer);
            }
            catch (SchedulerException se) {
                InvalidParameterException ex = new InvalidParameterException();
                ex.initCause(se);
                throw ex;
            }
            table = new JTable(list, this.getColumns()){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    Object tip = null;
                    if (rowIndex >= 0 && colIndex >= 0) {
                        try {
                            tip = this.getValueAt(rowIndex, colIndex);
                        }
                        catch (RuntimeException ex) {
                            tip = null;
                        }
                    }
                    return tip != null ? tip.toString() : "";
                }
            };
        }
        return table;
    }

    public Vector<String> getColumns() {
        return FlowInfo.getColumns();
    }

    public Vector getData(boolean readFromServer) throws MdException, RemoteException, InvalidParameterException, SchedulerException {
        if (this.m_data == null || this.m_dirty || readFromServer) {
            this.m_data = new Vector();
            if (this.m_info == null) {
                this.getInfo();
            }
            if (this.m_info != null) {
                AssociationList steps = this.m_activity.getSteps();
                for (int i = 0; i < steps.size(); ++i) {
                    JFJob jfjob;
                    TransformationStep step = (TransformationStep)steps.get(i);
                    if (step instanceof SyncStep || !(jfjob = (JFJob)step.getTransformations().get(0)).getTransformRole().equals("SCHEDULER_FLOW")) continue;
                    FlowInfo subflow = DeployedFlow.getInfo(jfjob, (MdObjectStore)jfjob.getObjectStore(), false);
                    Vector subdata = subflow.getData(readFromServer);
                    this.m_data.addAll(0, subdata);
                }
                Vector<String> row = new Vector<String>();
                row.add(" ");
                row.add(this.m_info.getId());
                row.add(this.m_info.getName());
                row.add("TopFlow");
                row.add(" ");
                row.add(this.m_info.getLocation());
                row.add(this.getScheduledUser());
                row.add(this.m_info.getDescription());
                this.m_data.add(row);
                SchedulerServerInfo schinfo = this.m_info.getScheduler();
                if (schinfo != null) {
                    row = new Vector();
                    row.add(" ");
                    row.add(schinfo.getId());
                    row.add(schinfo.getName());
                    row.add("Scheduler");
                    row.add(schinfo.getClassId());
                    row.add(" ");
                    row.add(" ");
                    row.add(schinfo.getDescription());
                    this.m_data.add(row);
                }
                this.m_data.addAll(this.m_info.getData(true));
            }
            this.resetDirty(2);
        }
        return this.m_data;
    }

    public StringBuffer getXML() throws MdException, IOException, InvalidParameterException, SchedulerException {
        return this.getXML(false);
    }

    public StringBuffer getXML(boolean blankJobID) throws MdException, IOException, InvalidParameterException, SchedulerException {
        String xml;
        StringBuffer xmlbuffer = new StringBuffer();
        Vector<ExportJobDefinition> jobDefs = new Vector<ExportJobDefinition>();
        AssociationList steps = this.m_activity.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            TransformationStep step = (TransformationStep)steps.get(i);
            if (step instanceof SyncStep) continue;
            ExportJobDefinition definition = this.getStepXML(step, xmlbuffer);
            if (blankJobID) {
                definition.blankJobIds(this.m_flow.getId());
            }
            jobDefs.add(definition);
        }
        Tree location = this.getFolder();
        String folder = location != null ? location.getName() : "";
        xmlbuffer.append("<FlowDef  Name=\"" + this.getName() + "\" Id=\"" + this.m_flow.getId() + "\" Description=\"" + MetaUtilities.replaceString(this.m_flow.getDesc(), "\"", "'") + "\" Created=\"" + this.getDateCreated(false) + "\" Modified=\"" + this.getDateModified(false) + "\" Location=\"" + folder + "\" >\n");
        ServerComponent sc = this.getSchedulerComponent();
        if (sc != null) {
            SchedulerServerInfo sinfo = new SchedulerServerInfo(sc.getName(), sc.getClassIdentifier());
            sinfo.setId(sc.getId());
            xmlbuffer.append(sinfo.generateXML());
        }
        int jobDefsize = jobDefs.size();
        for (int i = 0; i < jobDefsize; ++i) {
            xml = ((JobDefinitionInfo)jobDefs.get(i)).generateXML();
            if (xml == null) continue;
            xmlbuffer.append(xml);
        }
        TriggerEvent trigger = DeployedFlow.getTriggerEvent(this.m_flow, this.m_scheduler);
        if (trigger != null && (xml = trigger.generateXML()) != null) {
            xmlbuffer.append(xml);
        }
        for (int i = 0; i < jobDefsize; ++i) {
            JobDefinitionInfo jobdef = (JobDefinitionInfo)jobDefs.get(i);
            String xml2 = jobdef.generateDependenciesXML();
            if (xml2 == null) continue;
            xmlbuffer.append(xml2);
        }
        xmlbuffer.append("</FlowDef>\n");
        return xmlbuffer;
    }

    private ExportJobDefinition getStepXML(TransformationStep step, StringBuffer xmlbuffer) throws MdException, IOException, InvalidParameterException, SchedulerException {
        if (step.getTransformations().size() != 0 && step.getTransformations().get(0) instanceof JFJob) {
            JFJob jfjob = (JFJob)step.getTransformations().get(0);
            ExportJobDefinition definition = null;
            boolean isFlow = false;
            if (jfjob.getTransformRole().equals("SCHEDULER_FLOW")) {
                isFlow = true;
            } else if (jfjob.getTransformRole().equals("") && 0 != jfjob.getJobActivities().size()) {
                isFlow = true;
            }
            if (isFlow) {
                DeployedFlow sflow = new DeployedFlow(jfjob, (MdObjectStore)jfjob.getObjectStore());
                xmlbuffer.append(sflow.getXML());
                String host = null;
                ServerComponent sc = CommandUtilities.getServerComponentForJob(jfjob);
                if (sc != null) {
                    Machine machine = sc.getAssociatedMachine();
                    host = machine != null ? machine.getName() : null;
                }
                definition = new ExportJobDefinition(jfjob, 1, jfjob.getName(), sflow.getFolder().getName(), null, host);
            } else {
                String cmdline = DeployedJob.getCmdLineProperty((Root)step);
                if (cmdline == null) {
                    cmdline = CommandUtilities.getCommandLine(jfjob, this.m_flow.getName());
                }
                if (cmdline != null && cmdline.length() != 0) {
                    Tree folder = DeployedJob.getFolder(jfjob);
                    String location = folder != null ? folder.getName() : "";
                    String userid = DeployedJob.getRunAs((Root)step);
                    ServerComponent sc = CommandUtilities.getServerComponentForJob(jfjob);
                    Machine machine = sc.getAssociatedMachine();
                    String host = machine != null ? machine.getName() : null;
                    definition = new ExportJobDefinition(jfjob, 0, cmdline, location, userid, host);
                } else {
                    throw new MdException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.SchedulingDetailsError.fmt"), DeployedJob.getName(jfjob)));
                }
            }
            AbstractEventInterface event = DeployedFlow.getAbstractEvents(step, this.m_scheduler, true);
            definition.addDependency(event);
            return definition;
        }
        throw new MdException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.MissingJFJobError.msg.fmt"), step.getName()));
    }

    @Deprecated
    public static Vector<FlowInfo> generateFlowsFromXML(String xml, MdObjectStore store, String repos, String user, String passwd) throws InvalidParameterException, SchedulerException {
        return DeployedFlow.generateFlowsFromXML(xml, store, repos, user, passwd != null ? new SealedString(passwd) : null);
    }

    public static Vector<FlowInfo> generateFlowsFromXML(String xml, MdObjectStore store, String repos, String user, SealedString passwd) throws InvalidParameterException, SchedulerException {
        Vector<FlowInfo> flows = new Vector<FlowInfo>();
        try {
            Document doc = GeneralUtilities.parseXML((String)xml);
            Node mainNode = doc.getElementsByTagName("xmlFlowDef").item(0);
            NodeList nodes = null;
            nodes = mainNode != null ? mainNode.getChildNodes() : doc.getElementsByTagName("FlowDef");
            int numNodes = nodes.getLength();
            for (int i = 0; i < numNodes; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeName().compareTo("FlowDef") != 0) continue;
                NamedNodeMap map = node.getAttributes();
                String flowName = map.getNamedItem("Name").getNodeValue();
                Node tnode = map.getNamedItem("Id");
                String id = null;
                if (tnode != null && tnode.getNodeValue().length() > 0) {
                    id = tnode.getNodeValue();
                }
                String flowLoc = map.getNamedItem("Location").getNodeValue();
                String description = map.getNamedItem("Description").getNodeValue();
                TriggerEventInfo trigger = null;
                SchedulerServerInfo sinfo = null;
                FlowInfo flow = new FlowInfo(flowName, trigger, sinfo);
                flow.setId(id);
                flow.setLocation(flowLoc);
                flow.setDescription(description);
                boolean jobsAdded = false;
                HashMap<String, JobInfo> jobs = new HashMap<String, JobInfo>();
                NodeList cnodes = node.getChildNodes();
                int numCNodes = cnodes.getLength();
                for (int x = 0; x < numCNodes; ++x) {
                    String jobName;
                    NamedNodeMap attrs;
                    Node cnode = cnodes.item(x);
                    String tagname = cnode.getNodeName();
                    if (tagname.compareTo("Scheduler") == 0) {
                        attrs = cnode.getAttributes();
                        String schName = attrs.getNamedItem("Name").getNodeValue();
                        String schClassID = attrs.getNamedItem("ClassID").getNodeValue();
                        String schID = attrs.getNamedItem("Id").getNodeValue();
                        sinfo = new SchedulerServerInfo(schName, schClassID);
                        sinfo.setId(schID);
                        sinfo.setUsername(user);
                        sinfo.setPassword(passwd != null ? String.valueOf(passwd.getCharacters()) : null);
                        flow.setSchedulerDataBinding(sinfo);
                        continue;
                    }
                    if (tagname.compareTo("TriggerEvents") == 0) {
                        TriggerEventInfo tei;
                        attrs = cnode.getAttributes();
                        String condition = attrs.getNamedItem("CombinationType").getNodeValue();
                        GroupingEventInfo gei = DeployedFlow.processEvents(cnode, null, null, sinfo, store, repos);
                        List list = gei.getDependencies();
                        if (list.size() > 1) {
                            TriggerEventInfo tei2 = new TriggerEventInfo(gei, sinfo);
                            flow.setTriggerEvent(tei2);
                            continue;
                        }
                        if (list.size() != 1) continue;
                        DisplayInfo info = (DisplayInfo)list.get(0);
                        if (info instanceof TimeEventInfo) {
                            tei = new TriggerEventInfo((TimeEventInfo)info, sinfo);
                            flow.setTriggerEvent(tei);
                            continue;
                        }
                        if (!(info instanceof FileEventInfo)) continue;
                        tei = new TriggerEventInfo((FileEventInfo)info, sinfo);
                        flow.setTriggerEvent(tei);
                        continue;
                    }
                    if (tagname.compareTo("JobDef") == 0) {
                        attrs = cnode.getAttributes();
                        jobName = attrs.getNamedItem("Name").getNodeValue();
                        Node tnode2 = attrs.getNamedItem("Id");
                        String jobId = null;
                        if (tnode2 != null && tnode2.getNodeValue().length() > 0) {
                            jobId = tnode2.getNodeValue();
                        }
                        String jobType = attrs.getNamedItem("Type").getNodeValue();
                        String jobLoc = attrs.getNamedItem("Location").getNodeValue();
                        String jobDesc = attrs.getNamedItem("Description").getNodeValue();
                        String jobCmd = null;
                        String jobHost = null;
                        if (jobType.compareTo("Job") != 0 && jobType.compareTo("subFlow") != 0) continue;
                        NodeList snodes = cnode.getChildNodes();
                        int numSNodes = snodes.getLength();
                        for (int y = 0; y < numSNodes; ++y) {
                            NamedNodeMap sattrs;
                            Node snode = snodes.item(y);
                            String stagname = snode.getNodeName();
                            if (stagname.compareTo("JobCmdLine") == 0) {
                                sattrs = snode.getAttributes();
                                jobCmd = sattrs.getNamedItem("Value").getNodeValue();
                                continue;
                            }
                            if (stagname.compareTo("Host") != 0) continue;
                            sattrs = snode.getAttributes();
                            jobHost = sattrs.getNamedItem("Value").getNodeValue();
                        }
                        String cmd = "";
                        if (jobCmd != null) {
                            cmd = jobCmd.indexOf(" ") > 0 ? jobCmd.substring(0, jobCmd.indexOf(" ")) : jobCmd;
                        }
                        BatchServerInfo binfo = CommandUtilities.findBatchServerFromCommand(cmd, jobHost, (MdStore)store, repos);
                        JobInfo job = new JobInfo(jobName, jobId, binfo);
                        job.setDisplayOnly(true);
                        job.setLocation(jobLoc);
                        job.setDescription(jobDesc);
                        if (binfo == null) {
                            job.setCommandLine(jobCmd, false);
                        } else {
                            String srcfile = CommandUtilities.findSourceFileFromCommand(jobCmd, binfo, jobHost, (MdStore)store, repos);
                            job.setSourceFile(srcfile);
                            DirectoryInfo dinfo = CommandUtilities.findSourceDirectoryFromCommand(jobCmd, binfo, jobHost, (MdStore)store, repos);
                            job.setSourceDir(dinfo);
                        }
                        jobs.put(job.getName(), job);
                        continue;
                    }
                    if (tagname.compareTo("Dependencies") != 0) continue;
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Reference").getNodeValue();
                    String jobType = attrs.getNamedItem("Type").getNodeValue();
                    flow.setJobs(new Vector(jobs.values()));
                    jobsAdded = true;
                    JobInfo job = (JobInfo)jobs.get(jobName);
                    GroupingEventInfo event = null;
                    if (jobType.compareTo("Job") == 0 || jobType.compareTo("subFlow") == 0) {
                        NodeList snodes = cnode.getChildNodes();
                        int numSNodes = snodes.getLength();
                        for (int y = 0; y < numSNodes; ++y) {
                            Node snode = snodes.item(y);
                            String stagname = snode.getNodeName();
                            if (stagname.compareTo("Events") != 0) continue;
                            event = DeployedFlow.processEvents(snode, job, jobs, sinfo, store, repos);
                        }
                    }
                    flow.addEvent((DisplayInfo)job, event);
                }
                if (!jobsAdded) {
                    flow.setJobs(new Vector(jobs.values()));
                }
                flows.add(flow);
            }
            return flows;
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)npe);
            throw se;
        }
        catch (RemoteException re) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)re);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)rte);
            throw se;
        }
    }

    private static GroupingEventInfo processEvents(Node node, JobInfo job, HashMap jobs, SchedulerServerInfo sinfo, MdObjectStore store, String repos) throws SchedulerException, RemoteException {
        NamedNodeMap sattrs = node.getAttributes();
        String mainCombination = sattrs.getNamedItem("CombinationType").getNodeValue();
        int condition = 1;
        if (mainCombination.compareToIgnoreCase(StrGroupAnd) == 0) {
            condition = 0;
        }
        GroupingEventInfo info = new GroupingEventInfo(job, condition);
        Scheduler scheduler = MetaUtilities.getSchedulingServer(sinfo, store);
        GroupingEventInfo event = null;
        NodeList cnodes = node.getChildNodes();
        int numNodes = cnodes.getLength();
        for (int y = 0; y < numNodes; ++y) {
            Node cnode = cnodes.item(y);
            String tagname = cnode.getNodeName();
            if (tagname.compareTo("Events") == 0) {
                event = DeployedFlow.processEvents(cnode, job, jobs, sinfo, store, repos);
                info.addDependency((AbstractEventInfo)event);
                continue;
            }
            if (tagname.compareTo("Event") != 0) continue;
            NamedNodeMap attrs = cnode.getAttributes();
            String type = attrs.getNamedItem("Type").getNodeValue();
            if (type.compareTo("Job") == 0) {
                JobEvent je = new JobEvent();
                je.initFromNode(cnode);
                event = je.getInfo((JobInfo)jobs.get(je.getName()));
                info.addDependency((AbstractEventInfo)event);
                continue;
            }
            if (type.compareTo("Time") == 0) {
                TimeEvent te = new TimeEvent();
                int connected = 0;
                if (scheduler.isConnectionNeededForTimeEvents() && sinfo.getUsername() != null) {
                    connected = scheduler.makeConnection(sinfo.getUsername(), ((SchedulerIMPL)scheduler).getSchServerInfoPasswordSealedString());
                }
                try {
                    te.initFromNode(cnode, scheduler);
                    event = te.getInfo();
                    info.addDependency((AbstractEventInfo)event);
                    if (connected != 1) continue;
                    scheduler.closeConnection();
                    continue;
                }
                catch (SchedulerException se) {
                    SchedulerException ex = new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.Error.ProcessingTimeEvent.msg.fmt"), te.toString()));
                    ex.initCause((Throwable)se);
                    throw ex;
                }
            }
            if (type.compareTo("File") != 0) continue;
            FileEventInfo fe = new FileEventInfo();
            fe.initFromNode(cnode);
            fe.setScheduler(sinfo);
            info.addDependency((AbstractEventInfo)fe);
        }
        return info;
    }

    public ServerComponent getSchedulerComponent() throws RemoteException, MdException {
        ServerComponent sc = DeployedFlow.getSchedulerComponent(this.m_flow);
        if (sc == null) {
            this.m_errorFlag |= 1;
        }
        return sc;
    }

    public static ServerComponent getSchedulerComponent(JFJob flow) throws RemoteException, MdException {
        if (flow == null) {
            return null;
        }
        AssociationList computeList = flow.getComputeLocations();
        if (computeList.size() == 0) {
            return null;
        }
        return (ServerComponent)computeList.get(0);
    }

    public String getSchedulerName() throws RemoteException, MdException {
        ServerComponent sc = DeployedFlow.getSchedulerComponent(this.m_flow);
        if (sc == null) {
            this.m_errorFlag |= 1;
            return null;
        }
        return sc.getName();
    }

    public static String getSchedulerName(JFJob flow) throws RemoteException, MdException {
        if (flow == null) {
            return null;
        }
        AssociationList computeList = flow.getComputeLocations();
        if (computeList.size() == 0) {
            return null;
        }
        ServerComponent sc = (ServerComponent)computeList.get(0);
        if (sc != null) {
            return sc.getName();
        }
        return null;
    }

    public ServerComponent getScheduleServerComponent() throws MdException, RemoteException {
        return this.getSchedulerComponent();
    }

    public ServerComponent getSchedulerComponentFromServer() throws MdException, RemoteException {
        String oldId;
        ServerComponent sc = null;
        try {
            sc = (ServerComponent)this.m_flow.getComputeLocations(true).get(0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            sc = null;
            this.m_scheduler = null;
            this.m_errorFlag |= 1;
        }
        if (!(this.m_scheduler == null || (oldId = this.m_scheduler.getServerComponent().getId()) != null && oldId.equalsIgnoreCase(sc.getId()))) {
            this.m_scheduler = MetaUtilities.getSchedulingServer(sc);
        }
        return sc;
    }

    public boolean setScheduleServerComponent(ServerComponent server) throws MdException, RemoteException {
        this.m_scheduler = MetaUtilities.getSchedulingServer(server);
        this.m_flow.getComputeLocations().clear();
        this.m_flow.getComputeLocations().add((Object)server);
        this.m_dirty = true;
        return true;
    }

    public boolean setScheduleServer(Scheduler server) throws MdException, RemoteException {
        SchedulerServerInfo info;
        String newId;
        String oldId = null;
        if (this.m_scheduler != null) {
            oldId = this.m_scheduler.getServerComponent().getId();
        }
        String string = newId = (info = server.getServerComponent()) != null ? info.getId() : null;
        if (newId == null) {
            return false;
        }
        if (oldId == null || oldId.compareTo(info.getId()) != 0) {
            String reposID = "A0000001." + this.m_repos;
            ServerComponent sc = MetaUtilities.getSchedulerServer(info, (MdStore)this.m_store, reposID);
            this.m_flow.getComputeLocations().clear();
            this.m_flow.getComputeLocations().add((Object)sc);
            this.m_dirty = true;
        }
        this.m_scheduler = server;
        return true;
    }

    public Scheduler getSchedulingServer() {
        block8: {
            try {
                if (this.m_scheduler == null) {
                    this.m_errorFlag |= 1;
                    break block8;
                }
                try {
                    ServerComponent temp = (ServerComponent)this.m_flow.getComputeLocations(true).get(0);
                    String oldId = this.m_scheduler.getServerComponent().getId();
                    if (oldId != null && oldId.equalsIgnoreCase(temp.getId())) break block8;
                    if (temp != null) {
                        this.m_scheduler = MetaUtilities.getSchedulingServer(temp);
                        break block8;
                    }
                    this.m_errorFlag |= 1;
                    this.m_scheduler = null;
                }
                catch (NullPointerException ex) {
                    this.m_errorFlag |= 1;
                    this.m_scheduler = null;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    this.m_errorFlag |= 1;
                    this.m_scheduler = null;
                }
            }
            catch (MdException ex) {
                this.m_errorFlag |= 1;
                this.m_scheduler = null;
            }
            catch (RemoteException ex) {
                this.m_errorFlag |= 1;
                this.m_scheduler = null;
            }
        }
        return this.m_scheduler;
    }

    public int getNumofJobs() {
        return this.m_jobs != null ? this.m_jobs.size() : 0;
    }

    public List<EventListItem> getEvents(DeployedJob job, boolean readFromServer) throws MdException, RemoteException {
        ArrayList<EventListItem> list = new ArrayList<EventListItem>();
        TransformationStep step = null;
        try {
            step = job.getLogicalJob(this.m_activity);
        }
        catch (InvalidParameterException ipe) {
            this.m_factory.getUtil().printOutputln(ipe.getLocalizedMessage());
            if (!this.m_JobsInError.contains(job)) {
                this.m_JobsInError.add(job);
            }
            return list;
        }
        ArrayList<EventListItem> elist = new ArrayList<EventListItem>();
        if (this.initializeFromJob(step, elist, readFromServer) > 0) {
            list.addAll(elist);
        }
        return list;
    }

    public boolean hasComplexDependencies(DeployedJob job) {
        try {
            AbstractEventInfo events = this.getComplexEvents(job, this.m_flow.getName(), this.m_scheduler, false);
            return this.hasComplexDependencies((DisplayInfo)events);
        }
        catch (RemoteException e) {
            return false;
        }
        catch (MdException e) {
            return false;
        }
    }

    private boolean hasComplexDependencies(DisplayInfo events) {
        if (events instanceof GroupingEventInfo) {
            GroupingEventInfo gei = (GroupingEventInfo)events;
            for (Object obj : gei.getDependencies()) {
                if (!(obj instanceof GroupingEventInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private AbstractEventInfo getComplexEvents(DeployedJob job, String flowname, Scheduler scheduler, boolean readFromServer) throws MdException, RemoteException {
        AbstractEventInfo info = null;
        TransformationStep step = null;
        try {
            step = job.getLogicalJob(this.m_activity);
        }
        catch (InvalidParameterException ipe) {
            this.m_factory.getUtil().printOutputln(ipe.getLocalizedMessage());
            if (!this.m_JobsInError.contains(job)) {
                this.m_JobsInError.add(job);
            }
            return info;
        }
        info = DeployedFlow.getComplexEvents(step, job.getName(), job.getId(), flowname, scheduler, readFromServer);
        return info;
    }

    private AbstractEventInfo getComplexEvents(DeployedFlow subflow, String flowname, Scheduler scheduler, boolean readFromServer) throws MdException, RemoteException, SchedulerException {
        AbstractEventInfo info = null;
        TransformationStep step = null;
        try {
            step = subflow.getLogicalJob(this.m_activity, readFromServer);
        }
        catch (InvalidParameterException ipe) {
            this.m_factory.getUtil().printOutputln(ipe.getLocalizedMessage());
            if (!this.m_JobsInError.contains(subflow)) {
                this.m_JobsInError.add(subflow);
            }
            return info;
        }
        info = DeployedFlow.getComplexEvents(step, subflow.getName(), subflow.getId(), flowname, scheduler, readFromServer);
        return info;
    }

    public static List<FileEventInfo> getFileEvents(JFJob flow, boolean readFromServer) throws RemoteException, MdException {
        ArrayList<FileEventInfo> orderedList = new ArrayList<FileEventInfo>();
        TransformationActivity ta = (TransformationActivity)flow.getJobActivities(readFromServer).get(0);
        for (TransformationStep step : ta.getSteps()) {
            Event event;
            if (!step.getTransformRole().equalsIgnoreCase(WaitEventRole) || (event = (Event)step.getTriggeringEvents(readFromServer).get(0)) == null || !event.getEventRole().equalsIgnoreCase(RoleFileEvent)) continue;
            FileEventInfo fei = new FileEventInfo();
            String strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
            if (strDefinition == null || !fei.initFromDefinition(strDefinition)) {
                FileEvent fileEvent = new FileEvent();
                ServerComponent schedulerServer = (ServerComponent)flow.getComputeLocations();
                Scheduler scheduler = MetaUtilities.getSchedulingServer(schedulerServer);
                if (!fileEvent.initFromCondition(scheduler, event.getCondition())) continue;
                fei = fileEvent.getInfo();
                fei.setId(event.getId());
                orderedList.add(fei);
                continue;
            }
            fei.setId(event.getId());
            orderedList.add(fei);
        }
        AssociationList steps = flow.getSteps(readFromServer);
        boolean triggerFound = false;
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            TransformationStep ts = (TransformationStep)steps.get(i);
            if (!(ts instanceof SyncStep)) continue;
            triggerFound = true;
            SyncStep step = (SyncStep)ts;
            AssociationList lstTriggeringEvents = step.getTriggeringEvents(readFromServer);
            if (null != lstTriggeringEvents && 0 != lstTriggeringEvents.size()) {
                for (Event event : lstTriggeringEvents) {
                    if (event == null || !event.getEventRole().equalsIgnoreCase(RoleFileEvent)) continue;
                    FileEventInfo fei = new FileEventInfo();
                    String strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
                    if (strDefinition == null || !fei.initFromDefinition(strDefinition)) {
                        FileEvent fileEvent = new FileEvent();
                        ServerComponent schedulerServer = (ServerComponent)flow.getComputeLocations(readFromServer).get(0);
                        Scheduler scheduler = MetaUtilities.getSchedulingServer(schedulerServer);
                        if (!fileEvent.initFromCondition(scheduler, event.getCondition())) continue;
                        fei = fileEvent.getInfo();
                        fei.setId(event.getId());
                        orderedList.add(fei);
                        continue;
                    }
                    fei.setId(event.getId());
                    orderedList.add(fei);
                }
            }
            if (triggerFound) break;
        }
        return orderedList;
    }

    public static boolean updateFileEvent(JFJob flow, FileEventInfo fei) throws RemoteException, MdException, SchedulerException {
        if (flow == null || fei == null || fei.getId() == null || fei.getId().length() == 0) {
            return false;
        }
        MdObjectStore store = (MdObjectStore)flow.getObjectStore();
        MdFactory factory = store.getFactory();
        String repos = "A0000001." + flow.getId().substring(0, 8);
        Event event = MetaUtilities.getEvent(fei.getId(), (MdStore)store, repos);
        String strDefinition = fei.generateDefinition();
        MetaUtilities.setStringProperty((Root)event, "Definition", factory, store, strDefinition);
        ServerComponent schedulerServer = DeployedFlow.getSchedulerComponent(flow);
        Scheduler scheduler = MetaUtilities.getSchedulingServer(schedulerServer);
        String strCondition = scheduler.createFileConditionString(fei.getFileName(), fei.getEventType(), fei.getOperator(), fei.getValue());
        event.setCondition(strCondition);
        return true;
    }

    public static AbstractEventInterface getAbstractEvents(TransformationStep step, Scheduler scheduler, boolean readFromServer) throws MdException, RemoteException, IOException, SchedulerException {
        Object returnEvent = null;
        AssociationList predecessors = step.getPredecessorDependencies(readFromServer);
        if (predecessors.size() == 1) {
            TransformationStep predStep;
            StepPrecedence sp = (StepPrecedence)predecessors.get(0);
            TransformationStep transformationStep = predStep = sp != null ? (TransformationStep)sp.getSuccessors().get(0) : null;
            if (predStep instanceof SyncStep) {
                if (predStep.getTransformRole().equalsIgnoreCase(StrGroupAnd) || predStep.getTransformRole().equalsIgnoreCase(StrGroupOr)) {
                    GroupingEvent event;
                    returnEvent = event = DeployedFlow.processGrouping((SyncStep)predStep, scheduler, readFromServer);
                } else if (predStep.getTransformRole().equalsIgnoreCase(WaitEventRole)) {
                    try {
                        Event event = (Event)predStep.getTriggeringEvents().get(0);
                        AbstractEventInterface aevent = DeployedFlow.processWaitEvent(event, scheduler);
                        returnEvent = aevent;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        predStep.getObjectStore().getFactory().deleteMetadataObject((CMetadata)predStep);
                        throw new MdException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.InvalidDependencyError.msg.fmt"), step.getName()));
                    }
                }
            } else if (predStep != null && predStep.getTransformations().get(0) instanceof JFJob) {
                JFJob job = (JFJob)predStep.getTransformations().get(0);
                if (job == null) {
                    throw new MdException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.InvalidDependencyError.msg.fmt"), step.getName()));
                }
                boolean isFlow = false;
                if (job.getTransformRole().equals("SCHEDULER_FLOW")) {
                    isFlow = true;
                } else if (job.getTransformRole().equals("") && 0 != job.getJobActivities().size()) {
                    isFlow = true;
                }
                if (isFlow) {
                    String command = predStep.getName();
                    JobEvent jobEvent = new JobEvent(job.getName(), command, sp);
                    returnEvent = jobEvent;
                } else {
                    JobEvent jobEvent = new JobEvent(new DeployedJob(job), sp);
                    returnEvent = jobEvent;
                }
            }
        } else {
            boolean firstSS = false;
            ArrayList<Object> deleteList = new ArrayList<Object>();
            MdFactory factory = step.getObjectStore().getFactory();
            for (StepPrecedence sp : predecessors) {
                TransformationStep predStep;
                TransformationStep transformationStep = predStep = sp != null ? (TransformationStep)sp.getSuccessors().get(0) : null;
                if (!firstSS && predStep instanceof SyncStep) {
                    firstSS = true;
                    continue;
                }
                deleteList.add(sp);
                deleteList.add(predStep);
            }
            if (deleteList.size() > 0) {
                factory.deleteMetadataObjects(deleteList);
            }
        }
        return returnEvent;
    }

    public static AbstractEventInterface processWaitEvent(Event event, Scheduler scheduler) throws IOException, SchedulerException {
        if (event.getEventRole().equalsIgnoreCase(RoleTimeEvent)) {
            TimeEvent object = new TimeEvent();
            try {
                String strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
                if (strDefinition != null) {
                    if (!object.initFromDefinition(scheduler, strDefinition)) {
                        object.initFromCondition(scheduler, event.getCondition());
                    } else {
                        object.setDescription(strDefinition);
                    }
                } else {
                    object.initFromCondition(scheduler, event.getCondition());
                }
            }
            catch (MdException ex) {
                object.initFromCondition(scheduler, event.getCondition());
            }
            return object;
        }
        if (event.getEventRole().equalsIgnoreCase(RoleFileEvent)) {
            FileEvent object = new FileEvent();
            try {
                String strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
                if (strDefinition != null) {
                    if (!object.initFromDefinition(scheduler, strDefinition)) {
                        object.initFromCondition(scheduler, event.getCondition());
                    } else {
                        object.setDescription(strDefinition);
                    }
                } else {
                    object.initFromCondition(scheduler, event.getCondition());
                }
            }
            catch (MdException ex) {
                object.initFromCondition(scheduler, event.getCondition());
            }
            return object;
        }
        return null;
    }

    public boolean areTimeEvents() throws RemoteException, MdException {
        for (TransformationStep ts : this.m_flow.getSteps()) {
            if (!(ts instanceof SyncStep)) continue;
            SyncStep step = (SyncStep)ts;
            Event event = null;
            AssociationList events = step.getTriggeringEvents();
            if (events.size() > 0) {
                event = (Event)events.get(0);
            }
            if (event != null && event.getEventRole().equalsIgnoreCase(RoleTimeEvent)) {
                return true;
            }
            for (Event e : step.getTriggeredEvents()) {
                if (!e.getEventRole().equalsIgnoreCase(RoleTimeEvent)) continue;
                return true;
            }
        }
        for (TransformationStep step : this.m_activity.getSteps()) {
            Event event;
            if (!step.getTransformRole().equalsIgnoreCase(WaitEventRole) || (event = (Event)step.getTriggeringEvents().get(0)) == null || !event.getEventRole().equalsIgnoreCase(RoleTimeEvent)) continue;
            return true;
        }
        return false;
    }

    public List getTimeEvents(DeployedJob job, boolean readFromServer) throws MdException, RemoteException {
        ArrayList<EventListItem> elist;
        ArrayList<EventListItem> list = new ArrayList<EventListItem>();
        TransformationStep step = job.getLogicalJob(this.m_activity);
        if (this.initializeFromJob(step, elist = new ArrayList<EventListItem>(), readFromServer) > 0) {
            for (EventListItem entry : elist) {
                try {
                    String eventRole = entry.getEvent().getEventRole();
                    if (!eventRole.equalsIgnoreCase(RoleTimeEvent)) continue;
                    list.add(entry);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return list;
    }

    public boolean checkAllCompliantFlowEvents(Scheduler scheduler, String oldClassID, String newClassID) throws MdException, RemoteException, SchedulerException {
        boolean compatible = SchedulerServerInfo.checkCompatible((String)oldClassID, (String)newClassID);
        for (TransformationStep step : this.m_activity.getSteps()) {
            String strDefinition;
            String eventRole;
            if (!step.getTransformRole().equalsIgnoreCase(WaitEventRole)) continue;
            Event event = (Event)step.getTriggeringEvents().get(0);
            String string = eventRole = event != null ? event.getEventRole() : "";
            if (eventRole.equalsIgnoreCase(RoleTimeEvent)) {
                TimeEvent timeEvent = new TimeEvent();
                strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
                if (strDefinition != null && timeEvent.validateFromDefinition(strDefinition) || compatible && timeEvent.initFromCondition(scheduler, event.getCondition())) continue;
                return false;
            }
            if (!eventRole.equalsIgnoreCase(RoleFileEvent)) continue;
            FileEvent fileEvent = new FileEvent();
            strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
            if (strDefinition != null && fileEvent.initFromDefinition(scheduler, strDefinition) || compatible && fileEvent.initFromCondition(scheduler, event.getCondition())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAllNonCompliantFlowEvents(Scheduler scheduler, String oldClassID, String newClassID) throws MdException, RemoteException, SchedulerException {
        ArrayList<Event> deletelist = new ArrayList<Event>();
        boolean compatible = SchedulerServerInfo.checkCompatible((String)oldClassID, (String)newClassID);
        for (TransformationStep step : this.m_activity.getSteps()) {
            AssociationList list;
            String strDefinition;
            String eventRole;
            if (!step.getTransformRole().equalsIgnoreCase(WaitEventRole)) continue;
            Event event = (Event)step.getTriggeringEvents().get(0);
            String string = eventRole = event != null ? event.getEventRole() : "";
            if (eventRole.equalsIgnoreCase(RoleTimeEvent)) {
                TimeEvent timeEvent = new TimeEvent();
                strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
                if (strDefinition != null && timeEvent.initFromDefinition(scheduler, strDefinition) || compatible && timeEvent.initFromCondition(scheduler, event.getCondition())) continue;
                list = step.getSuccessorDependencies();
                deletelist.addAll((Collection<Event>)list);
                list = event.getTriggeredTransforms();
                deletelist.addAll((Collection<Event>)list);
                deletelist.add(event);
                continue;
            }
            if (!eventRole.equalsIgnoreCase(RoleFileEvent)) continue;
            FileEvent fileEvent = new FileEvent();
            strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
            if (strDefinition != null && fileEvent.initFromDefinition(scheduler, strDefinition) || compatible && fileEvent.initFromCondition(scheduler, event.getCondition())) continue;
            list = step.getSuccessorDependencies();
            deletelist.addAll((Collection<Event>)list);
            list = event.getTriggeredTransforms();
            deletelist.addAll((Collection<Event>)list);
            deletelist.add(event);
        }
        for (int j = 0; j < deletelist.size(); ++j) {
            CMetadata object = (CMetadata)deletelist.get(j);
            this.m_deleteList.add(object.getId());
            object.delete();
        }
        return true;
    }

    public static String hasCircularLogic(String flowid, String subflowid, MdObjectStore store, String repos) throws RemoteException, MdException, SchedulerException {
        TransformationActivity ta;
        JFJob jfjob = MetaUtilities.getJFJob(subflowid, (MdStore)store, repos);
        if (flowid.compareTo(subflowid) == 0) {
            return jfjob.getName();
        }
        if (jfjob.getTransformRole().compareTo("SCHEDULER_FLOW") == 0 && (ta = (TransformationActivity)jfjob.getJobActivities().get(0)) != null) {
            for (TransformationStep step : ta.getSteps()) {
                if (step instanceof SyncStep) continue;
                try {
                    String temp;
                    JFJob jfjob2 = (JFJob)step.getTransformations().get(0);
                    if (jfjob2 == null || (temp = DeployedFlow.hasCircularLogic(flowid, jfjob2.getId(), store, repos)) == null) continue;
                    return jfjob.getName() + ":" + temp;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                }
            }
        }
        return null;
    }

    public List getJobEvents(DeployedJob job, boolean readFromServer) throws MdException, RemoteException {
        ArrayList<EventListItem> elist;
        ArrayList<Object> list = new ArrayList<Object>();
        TransformationStep step = job.getLogicalJob(this.m_activity);
        if (this.initializeFromJob(step, elist = new ArrayList<EventListItem>(), readFromServer) > 0) {
            for (EventListItem entry : elist) {
                Object event = entry.getProperty("JobEvent");
                if (!(event instanceof JobEvent)) continue;
                list.add(event);
            }
        }
        return list;
    }

    public static List getJobEvents(TransformationStep step, boolean readFromServer) throws MdException, RemoteException {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<EventListItem> elist = new ArrayList<EventListItem>();
        DeployedFlow.initializeFromJob2(step, elist, readFromServer);
        for (EventListItem entry : elist) {
            Object event = entry.getProperty("JobEvent");
            if (!(event instanceof JobEvent)) continue;
            list.add(event);
        }
        return list;
    }

    public List getFileEvents(DeployedJob job, boolean readFromServer) throws MdException, RemoteException {
        ArrayList<EventListItem> elist;
        ArrayList<EventListItem> list = new ArrayList<EventListItem>();
        TransformationStep step = job.getLogicalJob(this.m_activity);
        if (this.initializeFromJob(step, elist = new ArrayList<EventListItem>(), readFromServer) > 0) {
            for (EventListItem entry : elist) {
                try {
                    String eventRole = entry.getEvent().getEventRole();
                    if (!eventRole.equalsIgnoreCase(RoleFileEvent)) continue;
                    list.add(entry);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return list;
    }

    public void deleteEvent(DeployedJob job, EventListItem entry) throws MdException, RemoteException {
        this.deleteEvent(job.getLogicalJob(this.m_activity), entry.getSyncStep());
        entry.deleteStepPrecedence();
    }

    public StepPrecedence deleteGrouping(DeployedJob job, DeployedJob group) throws MdException, RemoteException {
        EventListItem singleevent = null;
        List<EventListItem> list = this.getEvents(job, false);
        if (list.size() == 1) {
            singleevent = list.get(0);
        }
        this.deleteGrouping(job, group, singleevent);
        return singleevent != null ? singleevent.getStepPrecedence() : null;
    }

    public void deleteGrouping(DeployedJob job, DeployedJob group, EventListItem entry) throws MdException, RemoteException {
        SyncStep sstep;
        TransformationStep jobTS = job.getLogicalJob(this.m_activity);
        SyncStep groupTS = (SyncStep)group.getLogicalJob(this.m_activity);
        if (jobTS != null && groupTS != null && (sstep = this.getJobGrouping(jobTS)) != null && sstep.getFQID().equals(groupTS.getFQID())) {
            StepPrecedence sp2;
            AssociationList succSteps;
            StepPrecedence neosp = null;
            AssociationList predSteps = groupTS.getPredecessorDependencies();
            if (predSteps.size() > 0) {
                StepPrecedence sp = (StepPrecedence)predSteps.get(0);
                AssociationList jobTSList = jobTS.getPredecessorDependencies();
                neosp = (StepPrecedence)this.m_factory.createComplexMetadataObject(this.m_store, null, sp.getName(), "StepPrecedence", this.m_repos, null);
                for (TransformationStep step : sp.getSuccessors()) {
                    neosp.getSuccessors().add((Object)step);
                }
                neosp.getProperties().addAll((Collection)sp.getProperties());
                jobTSList.clear();
                jobTSList.add((Object)neosp);
                this.m_deleteList.add(sp.getId());
                sp.delete();
            }
            if ((succSteps = groupTS.getSuccessorDependencies()).size() > 0 && (sp2 = (StepPrecedence)succSteps.get(0)) != null) {
                this.m_deleteList.add(sp2.getId());
                sp2.delete();
            }
            this.m_deleteList.add(groupTS.getId());
            groupTS.delete();
            if (entry != null) {
                entry.deleteStepPrecedence();
                entry.deleteSyncStep();
                if (neosp != null) {
                    entry.addMetadataObject((CMetadata)neosp);
                }
            }
        }
        this.m_dirty = true;
    }

    @Override
    public int compareTo(Object other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public int compareTo(DeployedFlow other) {
        return this.toString().compareTo(other.toString());
    }

    public boolean addSubFlowToFlow(DeployedFlow deployedflow) throws MdException, RemoteException {
        return DeployedFlow.addSubFlowToFlow(deployedflow, this.m_activity, this.m_jobs, this.m_factory, this.m_store, this.m_repos) != null;
    }

    private static TransformationStep addSubFlowToFlow(DeployedFlow deployedflow, TransformationActivity activity, List<Object> jobs, MdFactory factory, MdObjectStore store, String repos) throws MdException, RemoteException {
        JFJob job = deployedflow.getMetadataObject();
        TransformationStep step = (TransformationStep)factory.createComplexMetadataObject(store, null, JobEvent.getName(job), "TransformationStep", repos, null);
        step.getTransformations().add((Object)job);
        step.setTransformRole(RoleFlow);
        activity.getSteps().add((Object)step);
        jobs.add(deployedflow);
        return step;
    }

    public boolean addJobToFlow(DeployedJob deployedjob) throws MdException, RemoteException {
        return DeployedFlow.addJobToFlow(deployedjob, this.m_activity, this.m_jobs, this.m_factory, this.m_store, this.m_repos) != null;
    }

    private static TransformationStep addJobToFlow(DeployedJob deployedjob, TransformationActivity activity, List<Object> jobs, MdFactory factory, MdObjectStore store, String repos) throws MdException, RemoteException {
        JFJob job = deployedjob.getDeployedJobObject();
        TransformationStep step = (TransformationStep)factory.createComplexMetadataObject(store, null, JobEvent.getName(job), "TransformationStep", repos, null);
        step.getTransformations().add((Object)job);
        step.setTransformRole(RoleJob);
        activity.getSteps().add((Object)step);
        jobs.add(deployedjob);
        return step;
    }

    public boolean addJobToFlow(JobInfo deployedjob) throws MdException, RemoteException {
        String reposID = "A0000001." + this.m_repos;
        try {
            JFJob job = MetaUtilities.getJFJob(deployedjob.getId(), "<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)this.m_store, reposID);
            TransformationStep step = (TransformationStep)this.m_factory.createComplexMetadataObject(this.m_store, null, JobEvent.getName(job), "TransformationStep", this.m_repos, null);
            step.getTransformations().add((Object)job);
            step.setTransformRole(RoleJob);
            if (deployedjob.getSchedulerProperties() != null) {
                String details = deployedjob.getSchedulerProperties();
                DeployedJob.setSchedulingDetails(step, details);
            }
            if (deployedjob.getSchedulerResources() != null) {
                String expression = deployedjob.getSchedulerResources();
                DeployedJob.setResources((Root)step, expression);
            }
            if (deployedjob.getUserId() != null) {
                String runas = deployedjob.getUserId();
                DeployedJob.setRunAs((Root)step, runas);
            }
            this.m_activity.getSteps().add((Object)step);
            this.getJobs().add(deployedjob);
            return true;
        }
        catch (SchedulerException se) {
            return false;
        }
    }

    public StepPrecedence addJobSimpleDependency(DeployedJob depend, DeployedJob pred, int type, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 0 || type == 1 || type == 2 || type == 6 || type == 7 || type == 8 || type == 31 || type == 32) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, 0);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobSimpleDependency(DeployedFlow depend, DeployedJob pred, int type, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 0 || type == 1 || type == 2 || type == 6 || type == 7 || type == 8 || type == 31 || type == 32) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, 0);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobSimpleDependency(DeployedJob depend, DeployedFlow pred, int type, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 10 || type == 11 || type == 16 || type == 18 || type == 31 || type == 32) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, 0);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("TYPE: " + type);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobSimpleDependency(DeployedFlow depend, DeployedFlow pred, int type, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 10 || type == 11 || type == 16 || type == 18 || type == 31 || type == 32) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, 0);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("TYPE: " + type);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobTimeDependency(DeployedJob depend, DeployedJob pred, int type, int minutes, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 4 || type == 5) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, minutes);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("TYPE: " + type);
                    System.out.println("MINUTES: " + minutes);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobTimeDependency(DeployedFlow depend, DeployedJob pred, int type, int minutes, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 4 || type == 5) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, minutes);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("TYPE: " + type);
                    System.out.println("MINUTES: " + minutes);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobTimeDependency(DeployedJob depend, DeployedFlow pred, int type, int minutes, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 14 || type == 15) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, minutes);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("TYPE: " + type);
                    System.out.println("MINUTES: " + minutes);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobTimeDependency(DeployedFlow depend, DeployedFlow pred, int type, int minutes, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (type == 14 || type == 15) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), type, 0, minutes);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(type)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("TYPE: " + type);
                    System.out.println("MINUTES: " + minutes);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobExitCodeDependency(DeployedJob depend, DeployedJob pred, int condition, int value, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (condition == 21 || condition == 22 || condition == 23 || condition == 24 || condition == 25 || condition == 26) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), 3, condition, value);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(condition)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("CONDITION: " + condition);
                    System.out.println("VALUE: " + value);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobExitCodeDependency(DeployedFlow depend, DeployedJob pred, int condition, int value, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (condition == 21 || condition == 22 || condition == 23 || condition == 24 || condition == 25 || condition == 26) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), 3, condition, value);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(condition)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("CONDITION: " + condition);
                    System.out.println("VALUE: " + value);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobExitCodeDependency(DeployedJob depend, DeployedFlow pred, int condition, int value, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (condition == 21 || condition == 22 || condition == 23 || condition == 24 || condition == 25 || condition == 26) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), 13, condition, value);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(condition)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("CONDITION: " + condition);
                    System.out.println("VALUE: " + value);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public StepPrecedence addJobExitCodeDependency(DeployedFlow depend, DeployedFlow pred, int condition, int value, String desc) throws RemoteException {
        StepPrecedence sp;
        block7: {
            sp = null;
            try {
                if (condition == 21 || condition == 22 || condition == 23 || condition == 24 || condition == 25 || condition == 26) {
                    sp = this.addJobDependency(depend.getLogicalJob(this.m_activity), pred.getLogicalJob(this.m_activity), 13, condition, value);
                    if (desc != null) {
                        sp.setDesc(desc);
                    }
                    break block7;
                }
                throw new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SP.InvalidParam.fmt"), String.valueOf(condition)));
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                    System.out.println("DEPEND: " + depend);
                    System.out.println("PRED: " + pred);
                    System.out.println("CONDITION: " + condition);
                    System.out.println("VALUE: " + value);
                    System.out.println("DESC: " + desc);
                }
                return null;
            }
            catch (NullPointerException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        return sp;
    }

    public DeployedJob getJobGrouping(DeployedJob djob) throws MdException, RemoteException {
        SyncStep step = this.getJobGrouping(djob.getLogicalJob(this.m_activity));
        if (step != null) {
            return new DeployedJob((TransformationStep)step, this.m_flow);
        }
        return null;
    }

    public DeployedJob groupJobs(List jobs, int condition, String desc) throws RemoteException {
        DeployedJob logicJob = null;
        try {
            SyncStep step = (SyncStep)this.m_factory.createComplexMetadataObject(this.m_store, null, StrGroupName, "SyncStep", this.m_repos, null);
            switch (condition) {
                case 31: {
                    step.setTransformRole(StrGroupAnd);
                    break;
                }
                default: {
                    step.setTransformRole(StrGroupOr);
                }
            }
            this.m_defaultGrouping = condition;
            logicJob = new DeployedJob((TransformationStep)step, this.m_flow);
            this.m_activity.getSteps().add((Object)step);
            for (Object obj : jobs) {
                TransformationStep ts = null;
                if (obj instanceof DeployedJob) {
                    ts = ((DeployedJob)obj).getLogicalJob(this.m_activity);
                } else if (obj instanceof DeployedFlow) {
                    ts = ((DeployedFlow)obj).getLogicalJob(this.m_activity);
                }
                StepPrecedence sp = this.addJobDependency((TransformationStep)step, ts, condition, 0, 0);
                if (desc == null) continue;
                sp.setDesc(desc);
            }
        }
        catch (MdException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
        return logicJob;
    }

    public DeployedJob groupDependencies(List events, int condition, String desc) throws RemoteException {
        DeployedJob logicJob = null;
        try {
            SyncStep step = (SyncStep)this.m_factory.createComplexMetadataObject(this.m_store, null, StrGroupName, "SyncStep", this.m_repos, null);
            switch (condition) {
                case 31: {
                    step.setTransformRole(StrGroupAnd);
                    break;
                }
                default: {
                    step.setTransformRole(StrGroupOr);
                }
            }
            this.m_defaultGrouping = condition;
            logicJob = new DeployedJob((TransformationStep)step, this.m_flow);
            this.m_activity.getSteps().add((Object)step);
            for (Object obj : events) {
                TransformationStep ts = null;
                StepPrecedence sp = null;
                if (!(obj instanceof EventListItem)) continue;
                EventListItem entry = (EventListItem)obj;
                ts = entry.getTransformationStep();
                Event event = entry.getEvent();
                if (event != null) {
                    String eventRole = event.getEventRole();
                    sp = eventRole.equalsIgnoreCase(RoleTimeEvent) ? this.addJobDependency((TransformationStep)step, ts, 40, 0, 0) : (eventRole.equalsIgnoreCase(RoleFileEvent) ? this.addJobDependency((TransformationStep)step, ts, 41, 0, 0) : this.addJobDependency((TransformationStep)step, ts, condition, 0, 0));
                }
                if (desc == null || sp == null) continue;
                sp.setDesc(desc);
            }
        }
        catch (MdException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
        return logicJob;
    }

    public DeployedJob addToGroup(DeployedJob group, DeployedJob job) {
        try {
            TransformationStep ts = group.getLogicalJob(this.m_activity);
            int condition = 0;
            condition = ts.getTransformRole().equalsIgnoreCase(StrGroupAnd) ? 31 : 32;
            StepPrecedence sp = this.addJobDependency(ts, job.getLogicalJob(this.m_activity), condition, 0, 0);
            if (sp == null) {
                return null;
            }
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
        return group;
    }

    public DeployedJob addToGroup(DeployedJob group, EventListItem entry, int condition) {
        try {
            TransformationStep ts = group.getLogicalJob(this.m_activity);
            SyncStep ds = entry.getSyncStep();
            StepPrecedence sp = this.addJobDependency(ts, (TransformationStep)ds, condition, 0, 0);
            if (sp == null) {
                return null;
            }
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
        return group;
    }

    public boolean ChangeGroupingType(DeployedJob group, int condition) throws MdException, RemoteException {
        block5: {
            block4: {
                TransformationStep step = group.getLogicalJob(this.m_activity);
                if (!(step instanceof SyncStep)) break block4;
                switch (condition) {
                    case 31: {
                        step.setTransformRole(StrGroupAnd);
                        break block5;
                    }
                    case 32: {
                        step.setTransformRole(StrGroupOr);
                        break block5;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        this.m_defaultGrouping = condition;
        return true;
    }

    public boolean createFileEvent(EventListItem entry, String strCondition, String strDescription) throws MdException, RemoteException {
        SyncStep step;
        block7: {
            step = null;
            AbstractEventInterface event = (AbstractEventInterface)entry.getProperty("eventObject");
            try {
                if (event instanceof FileEvent) {
                    step = this.createEvent((DisplayInfo)((FileEvent)event).getInfo(), RoleFileEvent);
                    entry.addMetadataObject((CMetadata)step);
                } else {
                    FileEvent fe = new FileEvent();
                    if (fe.initFromCondition(this.m_scheduler, strCondition)) {
                        step = this.createEvent((DisplayInfo)fe.getInfo(), RoleFileEvent);
                        entry.addMetadataObject((CMetadata)step);
                    } else if (fe.initFromDefinition(this.m_scheduler, strDescription)) {
                        step = this.createEvent((DisplayInfo)fe.getInfo(), RoleFileEvent);
                        entry.addMetadataObject((CMetadata)step);
                    }
                }
            }
            catch (SchedulerException ex) {
                if (!MetaUtilities.isDebug()) break block7;
                ex.printStackTrace();
            }
        }
        return step != null;
    }

    public boolean addFileEvent(DeployedJob job, FileEvent event) throws MdException, RemoteException, SchedulerException {
        SyncStep step = this.createEvent((DisplayInfo)event.getInfo(), RoleFileEvent);
        if (step != null) {
            if (this.addEvent(job, step, 41) != null) {
                String strDescription = event.generateDefinition();
                Event eventobj = (Event)step.getTriggeringEvents().get(0);
                MetaUtilities.setStringProperty((Root)eventobj, "Definition", this.m_factory, this.m_store, strDescription);
                String strCondition = this.m_scheduler.createFileConditionString(event.getFileName(), event.getEventType(), event.getOperator(), event.getValue());
                eventobj.setCondition(strCondition);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean addFileEvent(DeployedFlow sflow, FileEvent event) throws MdException, RemoteException, SchedulerException {
        SyncStep step = this.createEvent((DisplayInfo)event.getInfo(), RoleFileEvent);
        if (step != null) {
            if (this.addEvent(sflow, step, 41) != null) {
                String strDescription = event.generateDefinition();
                Event eventobj = (Event)step.getTriggeringEvents().get(0);
                MetaUtilities.setStringProperty((Root)eventobj, "Definition", this.m_factory, this.m_store, strDescription);
                String strCondition = this.m_scheduler.createFileConditionString(event.getFileName(), event.getEventType(), event.getOperator(), event.getValue());
                eventobj.setCondition(strCondition);
                return true;
            }
            return false;
        }
        return false;
    }

    public TriggerEvent addTriggerFileEvent(FileEvent fileevent) throws MdException, RemoteException, SchedulerException {
        TriggerEventInfo triggerInfo = new TriggerEventInfo(fileevent.getInfo(), this.m_scheduler.getServerComponent());
        Event event = this.createTriggerEvent(triggerInfo);
        if (event != null) {
            TriggerEvent trigger = new TriggerEvent(triggerInfo, this.m_scheduler, this.m_store, this.m_repos);
            trigger.setEvent(event);
            if (this.setTriggerEvent(trigger)) {
                MetaUtilities.setStringProperty((Root)event, "Definition", this.m_factory, this.m_store, fileevent.generateDefinition());
                return trigger;
            }
            return null;
        }
        return null;
    }

    public boolean createTimeEvent(EventListItem entry, String strCondition, String strDescription) throws MdException, RemoteException {
        SyncStep step;
        block7: {
            step = null;
            AbstractEventInterface event = (AbstractEventInterface)entry.getProperty("eventObject");
            try {
                if (event instanceof TimeEvent) {
                    step = this.createEvent((DisplayInfo)((TimeEvent)event).getInfo(), RoleTimeEvent);
                    entry.addMetadataObject((CMetadata)step);
                } else {
                    TimeEvent te = new TimeEvent();
                    if (te.initFromCondition(this.m_scheduler, strCondition)) {
                        step = this.createEvent((DisplayInfo)te.getInfo(), RoleTimeEvent);
                        entry.addMetadataObject((CMetadata)step);
                    } else if (te.initFromDefinition(this.m_scheduler, strDescription)) {
                        step = this.createEvent((DisplayInfo)te.getInfo(), RoleTimeEvent);
                        entry.addMetadataObject((CMetadata)step);
                    }
                }
            }
            catch (SchedulerException ex) {
                if (!MetaUtilities.isDebug()) break block7;
                ex.printStackTrace();
            }
        }
        return step != null;
    }

    public boolean addTimeEvent(DeployedJob job, TimeEvent event) throws MdException, RemoteException {
        try {
            SyncStep step = this.createEvent((DisplayInfo)event.getInfo(), RoleTimeEvent);
            if (step != null) {
                if (this.addEvent(job, step, 40) != null) {
                    String strDescription = event.generateDefinition();
                    Event eventobj = (Event)step.getTriggeringEvents().get(0);
                    MetaUtilities.setStringProperty((Root)eventobj, "Definition", this.m_factory, this.m_store, strDescription);
                    Property property = MetaUtilities.setStringProperty((Root)eventobj, PropertyTimeEventCalDefinitionName, this.m_factory, this.m_store, event.generateCalendarDefinition());
                    property.setDesc(event.getCalendarName());
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SchedulerException ex) {
            return false;
        }
    }

    public boolean addTimeEvent(DeployedFlow sflow, TimeEvent event) throws MdException, RemoteException {
        try {
            SyncStep step = this.createEvent((DisplayInfo)event.getInfo(), RoleTimeEvent);
            if (step != null) {
                if (this.addEvent(sflow, step, 40) != null) {
                    MdObjectStore store = (MdObjectStore)step.getObjectStore();
                    MdFactory factory = store.getFactory();
                    String strDescription = event.generateDefinition();
                    Event eventobj = (Event)step.getTriggeringEvents().get(0);
                    MetaUtilities.setStringProperty((Root)eventobj, "Definition", factory, store, strDescription);
                    Property property = MetaUtilities.setStringProperty((Root)eventobj, PropertyTimeEventCalDefinitionName, factory, store, event.generateCalendarDefinition());
                    property.setDesc(event.getCalendarName());
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SchedulerException ex) {
            return false;
        }
    }

    public TriggerEvent addTriggerTimeEvent(TimeEvent timeevent) throws MdException, RemoteException, SchedulerException {
        TriggerEventInfo tei = new TriggerEventInfo(timeevent.getInfo(), this.m_scheduler.getServerComponent());
        Event event = this.createTriggerEvent(tei);
        if (event != null) {
            TriggerEvent trigger = new TriggerEvent(tei, this.m_scheduler, this.m_store, this.m_repos);
            trigger.setEvent(event);
            if (this.setTriggerEvent(trigger)) {
                MetaUtilities.setStringProperty((Root)event, "Definition", this.m_factory, this.m_store, timeevent.getDescription());
                MetaUtilities.setStringProperty((Root)event, PropertyTimeEventCalDefinitionName, this.m_factory, this.m_store, timeevent.generateCalendarDefinition());
                Property property = MetaUtilities.setStringProperty((Root)event, PropertyTimeEventCalDefinitionName, this.m_factory, this.m_store, timeevent.generateCalendarDefinition());
                property.setDesc(timeevent.getCalendarName());
                return trigger;
            }
            return null;
        }
        return null;
    }

    public boolean updateTimeEvent(EventListItem entry, String definition, String description) throws MdException, RemoteException {
        Event event = entry.getEvent();
        event.setCondition(definition);
        event.setDesc(description);
        entry.setDisplayName(definition);
        String propertyValue = null;
        TimeEvent te = (TimeEvent)entry.getProperty("eventObject");
        if (te != null) {
            propertyValue = te.generateDefinition();
        }
        try {
            MetaUtilities.setProperty((Root)event, "Definition", null, null, propertyValue);
        }
        catch (NullPointerException npe) {
            MetaUtilities.setStringProperty((Root)event, "Definition", this.m_factory, this.m_store, propertyValue);
        }
        this.m_dirty = true;
        return true;
    }

    public boolean updateFileEvent(EventListItem entry, String definition, String description) throws MdException, RemoteException {
        entry.setDisplayName(definition);
        Event event = entry.getEvent();
        event.setCondition(definition);
        event.setDesc(description);
        String strDescription = definition;
        FileEvent fe = (FileEvent)entry.getProperty("eventObject");
        if (fe != null) {
            strDescription = fe.generateDefinition();
        }
        MetaUtilities.setStringProperty((Root)event, "Definition", this.m_factory, this.m_store, strDescription);
        this.m_dirty = true;
        return true;
    }

    public boolean updateJobEvent(EventListItem entry, String definition, JobEvent oldJobEvent, JobEvent newJobEvent) throws MdException, RemoteException {
        entry.setDisplayName(definition);
        entry.putProperty("JobEvent", newJobEvent);
        StepPrecedence sp = entry.getStepPrecedence();
        this.updateJobDependencyProperties(sp, newJobEvent);
        JFJob newJob = newJobEvent.getMDJob();
        JFJob oldJob = oldJobEvent.getMDJob();
        if (!newJob.getId().equalsIgnoreCase(oldJob.getId())) {
            sp.getSuccessors().remove((Object)this.getTransformationStepForJob(oldJob));
            sp.getSuccessors().add((Object)this.getTransformationStepForJob(newJob));
        }
        this.m_dirty = true;
        return true;
    }

    public String getTriggerType() throws MdException, RemoteException {
        return DeployedFlow.getTriggerType(this.m_flow);
    }

    public static String getTriggerType(JFJob flow) throws MdException, RemoteException {
        Property property = DeployedFlow.getTriggerTypeProperty(flow);
        if (property != null) {
            return property.getDefaultValue();
        }
        return "RunNow";
    }

    private static Property getTriggerTypeProperty(JFJob flow) throws RemoteException, MdException {
        Property prop = null;
        ArrayList<Property> deleteList = new ArrayList<Property>();
        AssociationList flowProperties = flow.getProperties();
        for (Property property : flowProperties) {
            if (!property.getPropertyName().equalsIgnoreCase(TRIGGERTYPE_PROPNAME)) continue;
            if (prop == null) {
                prop = property;
                continue;
            }
            deleteList.add(property);
        }
        if (deleteList.size() > 0) {
            flow.getObjectStore().getFactory().deleteMetadataObjects(deleteList);
        }
        return prop;
    }

    private boolean setTriggerProperty(String triggerType) throws RemoteException, MdException {
        Property triggerProperty = DeployedFlow.getTriggerTypeProperty(this.m_flow);
        if (null == triggerProperty) {
            String repos = this.m_flow.getId().substring(0, 8);
            triggerProperty = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, TRIGGERTYPE_PROPNAME, "Property", repos, null);
            triggerProperty.setSQLType(12);
            triggerProperty.setPropertyName(TRIGGERTYPE_PROPNAME);
            this.getProperties().add(triggerProperty);
        }
        this.m_previousTriggerType = triggerProperty.getDefaultValue();
        triggerProperty.setDefaultValue(triggerType);
        return true;
    }

    public String getPreviousTriggerType() {
        return this.m_previousTriggerType;
    }

    public boolean removeTriggerEvent(TriggerEvent trigger) throws MdException, RemoteException {
        return this.removeTriggerEvent(trigger, false);
    }

    private boolean removeTriggerEvent(TriggerEvent trigger, boolean now) throws MdException, RemoteException {
        Event tevent = trigger.getEvent();
        if (tevent == null) {
            return true;
        }
        SyncStep trstep = this.setupTriggering(false);
        if (trstep == null) {
            return false;
        }
        ArrayList<Object> deleteList = new ArrayList<Object>();
        for (Event event : trstep.getTriggeredEvents()) {
            if (!tevent.getFQID().equalsIgnoreCase(event.getFQID())) continue;
            for (SyncStep step : event.getTriggeredTransforms()) {
                if (step.getFQID().compareTo(trstep.getFQID()) == 0) continue;
                deleteList.add(step);
            }
            deleteList.addAll((Collection<Object>)event.getProperties());
            deleteList.add(event);
            break;
        }
        for (int x = 0; x < deleteList.size(); ++x) {
            CMetadata o = (CMetadata)deleteList.get(x);
            if (o == null) continue;
            if (now) {
                this.m_factory.deleteMetadataObject(o);
                continue;
            }
            this.m_deleteList.add(o.getId());
            o.delete();
        }
        this.m_dirty = true;
        return true;
    }

    public boolean removeTriggerEvent() throws MdException, RemoteException {
        ArrayList<Object> deleteList = new ArrayList<Object>();
        SyncStep step = this.setupTriggering(false);
        Property triggerProperty = DeployedFlow.getTriggerTypeProperty(this.m_flow);
        if (triggerProperty != null && triggerProperty.getDefaultValue().equalsIgnoreCase("Event")) {
            Iterator events;
            Iterator iterator = events = step != null ? step.getTriggeringEvents().iterator() : null;
            while (events != null && events.hasNext()) {
                Event event = (Event)events.next();
                if (event.getTriggeredTransforms().size() != 1) continue;
                deleteList.add(event);
            }
            deleteList.add(triggerProperty);
        }
        if (deleteList.size() > 0) {
            this.m_factory.deleteMetadataObjects(deleteList);
        }
        return true;
    }

    private boolean eventIsActiveTrigger(Root obj) throws RemoteException, MdException {
        if (obj == null) {
            return false;
        }
        SyncStep step = this.setupTriggering(true);
        if (step == null) {
            return false;
        }
        AssociationList list = step.getTriggeringEvents();
        for (Event e : list) {
            if (obj instanceof Event) {
                Event event = (Event)obj;
                if (event.getId().compareToIgnoreCase(e.getId()) != 0 && event.getCondition().compareTo(e.getCondition()) != 0) continue;
                return true;
            }
            if (!(obj instanceof SyncStep)) continue;
            SyncStep ts = (SyncStep)obj;
            AssociationList l2 = ts.getTriggeringEvents();
            for (Event e2 : l2) {
                if (e2.getId().compareToIgnoreCase(e.getId()) != 0 && e2.getCondition().compareTo(e.getCondition()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private SyncStep setupTriggering(boolean createIfMissing) throws RemoteException, MdException {
        boolean foundTrigger = false;
        SyncStep step = null;
        ArrayList<TransformationStep> deleteList = new ArrayList<TransformationStep>();
        AssociationList steps = this.m_flow.getSteps();
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            TransformationStep ts = (TransformationStep)steps.get(i);
            if (!(ts instanceof SyncStep)) continue;
            if (!foundTrigger) {
                step = (SyncStep)ts;
                foundTrigger = true;
                continue;
            }
            deleteList.add(ts);
        }
        if (deleteList.size() > 0) {
            this.m_factory.deleteMetadataObjects(deleteList);
        }
        if (createIfMissing && !foundTrigger) {
            String repos = this.m_flow.getId().substring(0, 8);
            step = MetaUtilities.createTriggerStep(31, this.m_store, repos);
            step.getTransformations().add((Object)this.getMetadataObject());
        }
        return step;
    }

    public TriggerEvent getTriggerEvent() throws MdException, RemoteException {
        AssociationList steps = this.m_flow.getSteps();
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            TransformationStep ts = (TransformationStep)steps.get(i);
            if (!(ts instanceof SyncStep)) continue;
            SyncStep step = (SyncStep)ts;
            AssociationList lstTriggeringEvents = step.getTriggeringEvents();
            Event event2 = null;
            if (null == lstTriggeringEvents || 0 == lstTriggeringEvents.size()) continue;
            int condition = 0;
            if (((SyncStep)ts).getTransformRole().equalsIgnoreCase(StrGroupOr)) {
                condition = 1;
            }
            if (lstTriggeringEvents.size() > 1) {
                GroupingEventInfo gei = new GroupingEventInfo(null, condition);
                try {
                    for (Event event2 : lstTriggeringEvents) {
                        TriggerEvent te = new TriggerEvent(this.m_scheduler, event2);
                        AbstractEventInfo di = te.getEventInfo();
                        di.setId(event2.getId());
                        gei.addDependency(di);
                    }
                    TriggerEventInfo tei = new TriggerEventInfo(gei, this.m_scheduler.getServerComponent());
                    tei.setId(ts.getId());
                    String reposId = "A0000001." + ts.getId().substring(0, 8);
                    return new TriggerEvent(tei, this.m_scheduler, (MdObjectStore)ts.getObjectStore(), reposId);
                }
                catch (SchedulerException se) {
                    return null;
                }
            }
            event2 = (Event)lstTriggeringEvents.get(0);
            if (event2 != null) {
                return new TriggerEvent(this.m_scheduler, event2);
            }
            this.m_factory.deleteMetadataObject((CMetadata)step);
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TriggerEventInfo getTriggerEvent(JFJob flow, List availableTriggers, Scheduler scheduler, MdFactory factory) throws MdException, RemoteException {
        TriggerEventInfo tei = null;
        AssociationList steps = flow.getSteps();
        int numSteps = steps.size();
        int i = 0;
        while (true) {
            block30: {
                SyncStep step;
                TransformationStep ts;
                block28: {
                    block31: {
                        if (i >= numSteps) {
                            return tei;
                        }
                        ts = (TransformationStep)steps.get(i);
                        if (!(ts instanceof SyncStep)) break block30;
                        step = (SyncStep)ts;
                        AssociationList lstTriggeringEvents = step.getTriggeringEvents();
                        Event event2 = null;
                        if (null == lstTriggeringEvents || 0 == lstTriggeringEvents.size()) break block31;
                        int condition = 0;
                        if (((SyncStep)ts).getTransformRole().equalsIgnoreCase(StrGroupOr)) {
                            condition = 1;
                        }
                        GroupingEventInfo gei = new GroupingEventInfo(null, condition);
                        if (lstTriggeringEvents.size() > 1) {
                            try {
                                for (Event event2 : lstTriggeringEvents) {
                                    TriggerEvent te = new TriggerEvent(scheduler, event2);
                                    AbstractEventInfo di = te.getEventInfo();
                                    di.setId(event2.getId());
                                    gei.addDependency(di);
                                }
                                tei = new TriggerEventInfo(gei, scheduler.getServerComponent());
                                tei.setId(ts.getId());
                            }
                            catch (SchedulerException se) {
                                if (MetaUtilities.isDebug()) {
                                    se.printStackTrace();
                                }
                                return null;
                            }
                            catch (RuntimeException ex) {
                                if (MetaUtilities.isDebug()) {
                                    ex.printStackTrace();
                                }
                                return null;
                            }
                        }
                        event2 = (Event)lstTriggeringEvents.get(0);
                        if (event2 != null) {
                            try {
                                TriggerEvent te = new TriggerEvent(scheduler, event2);
                                tei = te.getInfo();
                                if (tei != null) {
                                    tei.setId(event2.getId());
                                }
                                break block28;
                            }
                            catch (SchedulerException se) {
                                if (MetaUtilities.isDebug()) {
                                    se.printStackTrace();
                                }
                                tei = null;
                            }
                            catch (RuntimeException ex) {
                                if (MetaUtilities.isDebug()) {
                                    ex.printStackTrace();
                                }
                                tei = null;
                            }
                            break block28;
                        } else {
                            if (MetaUtilities.isDebug()) {
                                System.out.println("TRACE: Event object is null.");
                            }
                            factory.deleteMetadataObject((CMetadata)step);
                            return null;
                        }
                    }
                    if (MetaUtilities.isDebug()) {
                        System.out.println("TRACE: Active Trigger not found.");
                    }
                }
                AssociationList lstTriggeredEvents = ts.getTriggeredEvents();
                Iterator i2 = lstTriggeredEvents.iterator();
                while (i2.hasNext()) {
                    String strName = null;
                    Event event2 = (Event)i2.next();
                    if (event2 != null) {
                        TriggerEventInfo trigger2;
                        block29: {
                            String classid = "a1661499-5d7d-4fcc-8fc3-c6509853e116";
                            SchedulerServerInfo ssi = null;
                            if (scheduler != null) {
                                classid = scheduler.getClassId();
                                ssi = scheduler.getServerComponent();
                            }
                            strName = TriggerEvent.makeValidTriggerName(event2.getCondition(), classid);
                            trigger2 = new TriggerEventInfo(strName, ssi, "Event");
                            try {
                                AbstractEventInterface aei = DeployedFlow.processWaitEvent(event2, scheduler);
                                trigger2.setId(event2.getId());
                                if (aei instanceof TimeEvent) {
                                    trigger2.setEvent((DisplayInfo)((TimeEvent)aei).getInfo());
                                    break block29;
                                }
                                if (aei instanceof FileEvent) {
                                    trigger2.setEvent((DisplayInfo)((FileEvent)aei).getInfo());
                                }
                            }
                            catch (Exception e) {
                                if (!MetaUtilities.isDebug()) break block29;
                                e.printStackTrace();
                            }
                        }
                        availableTriggers.add(trigger2);
                        continue;
                    }
                    if (MetaUtilities.isDebug()) {
                        System.out.println("TRACE: Event object is missing.");
                    }
                    factory.deleteMetadataObject((CMetadata)step);
                    return null;
                }
            }
            ++i;
        }
    }

    private boolean clearTriggerEvent() throws MdException, RemoteException {
        ArrayList<Property> deleteList = new ArrayList<Property>();
        List<Property> flowProperties = this.getProperties();
        for (Property property : flowProperties) {
            if (!property.getPropertyName().equalsIgnoreCase(TRIGGERTYPE_PROPNAME)) continue;
            deleteList.add(property);
        }
        if (deleteList.size() > 0) {
            this.m_factory.deleteMetadataObjects(deleteList);
        }
        return true;
    }

    public static TriggerEvent getTriggerEvent(JFJob flow, Scheduler scheduler) throws MdException, RemoteException {
        AssociationList steps = flow.getSteps();
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            TransformationStep ts = (TransformationStep)steps.get(i);
            if (!(ts instanceof SyncStep)) continue;
            SyncStep step = (SyncStep)ts;
            TriggerEvent trigger = new TriggerEvent(flow.getName(), scheduler, step);
            return trigger;
        }
        return null;
    }

    public static List getTriggerEvents(JFJob flow, Scheduler scheduler) throws MdException, RemoteException {
        AssociationList steps = flow.getSteps();
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            TransformationStep ts = (TransformationStep)steps.get(i);
            if (!(ts instanceof SyncStep)) continue;
            SyncStep step = (SyncStep)ts;
            AssociationList lstTriggeringEvents = step.getTriggeringEvents();
            if (null != lstTriggeringEvents && 0 != lstTriggeringEvents.size()) {
                if (lstTriggeringEvents.size() > 1) {
                    // empty if block
                }
                ArrayList<TriggerEvent> list = new ArrayList<TriggerEvent>();
                Iterator it2 = lstTriggeringEvents.iterator();
                while (it2.hasNext()) {
                    list.add(new TriggerEvent(scheduler, (Event)it2.next()));
                }
                return list;
            }
            return null;
        }
        return null;
    }

    public TriggerEventInfo getTriggerEventInfo(List<TriggerEventInfo> triggerList, SchedulerServerInfo schinfo) throws RemoteException, MdException, SchedulerException {
        return this.getTriggerEventInfo(triggerList, schinfo, true);
    }

    private TriggerEventInfo getTriggerEventInfo(List<TriggerEventInfo> triggerList, SchedulerServerInfo schinfo, boolean allTypes) throws RemoteException, MdException, SchedulerException {
        TriggerEventInfo tinfo = null;
        TriggerEvent trigger = this.getTriggerEvent();
        for (TriggerEvent tre : this.getFlowTriggerEvents()) {
            FileEventInfo info = null;
            boolean setTinfo = false;
            if (this.eventIsActiveTrigger(tre.getObject())) {
                setTinfo = true;
            }
            TriggerEventInfo t = null;
            if (tre.getType().compareTo("RunNow") == 0) {
                TriggerEventInfo runOnce = new TriggerEventInfo(m_bundle.getString("DeployedFlow.RunOnce.txt"), schinfo, "RunNow");
                if (allTypes) {
                    triggerList.add(runOnce);
                }
                if (trigger == null) {
                    tinfo = runOnce;
                }
            } else if (tre.getType().compareTo("Manual") == 0) {
                TriggerEventInfo manual = new TriggerEventInfo(m_bundle.getString("DeployedFlow.Manual.txt"), schinfo, "Manual");
                if (allTypes) {
                    triggerList.add(manual);
                }
                if (this.getTriggerType().compareTo("Manual") == 0) {
                    tinfo = manual;
                }
            } else {
                AbstractEventInterface ae = tre.getAbstractEvent();
                if (ae instanceof TimeEvent) {
                    TimeEvent tevent = (TimeEvent)ae;
                    if (tevent.isCalendarOkay()) {
                        com.sas.scheduler.api.servers.Calendar cal = tevent.getCalendar();
                        IRecurrenceInfo irinfo = null;
                        irinfo = cal != null ? cal.getDays() : tevent.getRecurrence();
                        try {
                            TimeEventInfo te = new TimeEventInfo(irinfo, tevent.getUser(), tevent.getHours(), tevent.getMinutes(), tevent.getDuration(), tevent.getOccur(), tevent.getTimezoneId());
                            te.setDescription(tevent.generateDefinition());
                            if (te.getName() == null || te.getName().length() == 0) {
                                te.setName(ae.getDescription());
                            }
                            t = new TriggerEventInfo(te, schinfo);
                            t.setId(tre.getId());
                            triggerList.add(t);
                            info = te;
                        }
                        catch (InvalidParameterException ipe) {
                            this.removeTriggerEvent(tre, true);
                        }
                    } else {
                        this.removeTriggerEvent(tre, true);
                    }
                } else if (ae instanceof FileEvent) {
                    FileEvent fevent = (FileEvent)ae;
                    try {
                        FileEventInfo fe = new FileEventInfo(schinfo, fevent.getFileName(), fevent.getEventType(), fevent.getOperator(), fevent.getValue());
                        t = new TriggerEventInfo(fe, schinfo);
                        t.setId(tre.getId());
                        triggerList.add(t);
                        info = fe;
                    }
                    catch (InvalidParameterException ipe) {
                        this.removeTriggerEvent(tre, true);
                    }
                }
            }
            if (!setTinfo) continue;
            if (tinfo == null) {
                tinfo = t;
                continue;
            }
            if (tinfo.getEvent() instanceof GroupingEventInfo) {
                GroupingEventInfo gei = (GroupingEventInfo)tinfo.getEvent();
                gei.addDependency(info);
                continue;
            }
            int condition = 0;
            SyncStep step = this.setupTriggering(false);
            if (step != null && step.getTransformRole().equalsIgnoreCase(StrGroupOr)) {
                condition = 1;
            }
            GroupingEventInfo gei = new GroupingEventInfo(null, condition);
            gei.addDependency(tinfo.getEvent());
            gei.addDependency(info);
            tinfo = new TriggerEventInfo(gei, schinfo);
        }
        return tinfo;
    }

    public List getFlowTriggerEvents() throws MdException, RemoteException {
        TriggerEvent entry;
        ArrayList<TriggerEvent> returnList = new ArrayList<TriggerEvent>();
        TriggerEvent runOnce = new TriggerEvent(this.m_scheduler, m_bundle.getString("DeployedFlow.RunOnce.txt"), "RunNow");
        returnList.add(runOnce);
        TriggerEvent manual = new TriggerEvent(this.m_scheduler, m_bundle.getString("DeployedFlow.Manual.txt"), "Manual");
        returnList.add(manual);
        String repos = "A0000001." + this.m_flow.getId().substring(0, 8);
        int flags = 8588;
        String selectXML = "<XMLSELECT search=\"*[TriggeredTransforms/SyncStep/Transformations/JFJob[@Id='" + this.getId() + "']]\" /><Templates><Event><Properties/><TriggeredTransforms/><TriggeringTransforms/></Event></Templates>";
        List list = this.m_factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, repos, "Event", flags, selectXML);
        for (Event event : list) {
            entry = new TriggerEvent(this.m_scheduler, event);
            returnList.add(entry);
        }
        selectXML = "<XMLSELECT search=\"*[TriggeringTransforms/SyncStep/Transformations/JFJob[@Id='" + this.getId() + "']]\" /><Templates><Event><Properties/><TriggeredTransforms/><TriggeringTransforms/></Event></Templates>";
        list = this.m_factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, repos, "Event", flags, selectXML);
        for (Event event : list) {
            if (this.eventIsActiveTrigger((Root)event)) continue;
            entry = new TriggerEvent(this.m_scheduler, event);
            returnList.add(entry);
        }
        return returnList;
    }

    public boolean setTriggerEvent(TriggerEventInfo trigger) throws MdException, RemoteException, SchedulerException {
        this.setupTriggering(true);
        AbstractEventInfo obj = trigger.getEvent();
        if (obj instanceof GroupingEventInfo) {
            SyncStep step = this.setupTriggering(true);
            trigger.setId(step.getId());
        }
        String reposID = "A0000001." + this.m_repos;
        TriggerEvent triggerEvent = new TriggerEvent(trigger, this.m_scheduler, this.m_store, reposID);
        this.m_dirty = true;
        return this.setTriggerEvent(triggerEvent);
    }

    public boolean setTriggerEvent(TriggerEvent event) throws MdException, RemoteException {
        if (event == null) {
            return false;
        }
        String triggerType = event.getType();
        if (!(triggerType == null || triggerType.equalsIgnoreCase("Manual") || triggerType.equalsIgnoreCase("RunNow") || this.eventIsActiveTrigger(event.getObject()))) {
            SyncStep ts;
            SyncStep step = this.setupTriggering(true);
            Root obj = event.getObject();
            if (obj instanceof Event) {
                AssociationList alEvents = step.getTriggeringEvents();
                alEvents.clear();
                alEvents.add((Object)((Event)obj));
                step.setTriggeringEvents(alEvents);
            } else if (obj instanceof SyncStep && (ts = (SyncStep)obj).getId().compareTo(step.getId()) != 0) {
                AssociationList alEvents = ts.getTriggeringEvents();
                step.getTriggeredEvents().clear();
                step.setTriggeringEvents(alEvents);
            }
        }
        this.setTriggerProperty(triggerType);
        this.m_dirty = true;
        return true;
    }

    public boolean setTriggerEvents(List events) throws MdException, RemoteException {
        SyncStep step = this.setupTriggering(true);
        for (TriggerEvent triggerevent : events) {
            String triggerType = triggerevent.getType();
            if (triggerType.equalsIgnoreCase("Manual") || triggerType.equalsIgnoreCase("RunNow")) {
                return false;
            }
            step.getTriggeringEvents().add((Object)triggerevent.getEvent());
        }
        this.setTriggerProperty("Event");
        this.m_dirty = true;
        return true;
    }

    public boolean setTriggerEventList(List events) throws MdException, RemoteException {
        SyncStep step = this.setupTriggering(true);
        AssociationList list = step.getTriggeredEvents();
        list.clear();
        for (TriggerEvent triggerevent : events) {
            String triggerType = triggerevent.getType();
            if (triggerType.equalsIgnoreCase("Manual") || triggerType.equalsIgnoreCase("RunNow")) continue;
            list.add(triggerevent.getEvent());
        }
        this.setTriggerProperty("Event");
        this.m_dirty = true;
        return true;
    }

    public List getListofFlows() throws MdException, RemoteException {
        return DeployedFlow.getListofFlows(this.m_flow);
    }

    public static List getListofFlows(JFJob jfjob) throws MdException, RemoteException {
        ArrayList<JFJob> flownames = new ArrayList<JFJob>();
        ArrayList<Object> deletelist = new ArrayList<Object>();
        AssociationList steps = jfjob.getSteps();
        int num = steps.size();
        for (int j = 0; j < num; ++j) {
            TransformationStep step = (TransformationStep)steps.get(j);
            if (step instanceof SyncStep) continue;
            TransformationActivity ta = null;
            try {
                ta = (TransformationActivity)step.getActivities().get(0);
            }
            catch (ArrayIndexOutOfBoundsException ab) {
                deletelist.add(step);
                continue;
            }
            AssociationList list = ta.getJobs();
            if (list.size() > 0) {
                JFJob flow = (JFJob)list.get(0);
                if (flownames.contains(flow)) continue;
                flownames.add(flow);
                continue;
            }
            deletelist.add(ta);
        }
        if (deletelist.size() > 0) {
            MdFactory factory = jfjob.getObjectStore().getFactory();
            factory.deleteMetadataObjects(deletelist);
        }
        return flownames;
    }

    public boolean hasAdvanceCompletion() throws SchedulerException {
        return DeployedFlow.hasAdvanceCompletion(this.m_flow);
    }

    private static boolean hasAdvanceCompletion(JFJob flow) throws SchedulerException {
        int level = DeployedFlow.getCompletionLevel(flow);
        switch (level) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
        }
        return true;
    }

    public int getCompletionLevel() throws SchedulerException {
        return DeployedFlow.getCompletionLevel(this.m_flow);
    }

    private static int getCompletionLevel(JFJob flow) throws SchedulerException {
        try {
            AssociationList properties = flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase(PropertyFlowCompletion)) continue;
                String defaultvalue = property.getDefaultValue();
                if (defaultvalue.compareTo("No") == 0) {
                    return 0;
                }
                try {
                    return Integer.parseInt(defaultvalue);
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return 0;
    }

    public boolean setEndBehavior(int behavior) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setEndBehavior(this.m_flow, this.m_factory, this.m_store, behavior);
        return true;
    }

    private static boolean setEndBehavior(JFJob flow, MdFactory factory, MdObjectStore store, int behavior) throws RemoteException, MdException {
        boolean dirty = false;
        String defaultvalue = String.valueOf(behavior);
        Property property = MetaUtilities.setStringProperty((Root)flow, PropertyFlowEndBehavior, factory, store, defaultvalue);
        if (property != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        return dirty;
    }

    private int getEndbehavior() throws SchedulerException {
        return DeployedFlow.getEndbehavior(this.m_flow);
    }

    private static int getEndbehavior(JFJob flow) throws SchedulerException {
        try {
            AssociationList properties = flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase(PropertyFlowEndBehavior)) continue;
                String defaultvalue = property.getDefaultValue();
                if (defaultvalue.compareTo("No") == 0) {
                    return 0;
                }
                try {
                    return Integer.parseInt(defaultvalue);
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return 0;
    }

    public boolean setExitcodeBehavior(int behavior) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setExitcodeBehavior(this.m_flow, this.m_factory, this.m_store, behavior);
        return true;
    }

    private static boolean setExitcodeBehavior(JFJob flow, MdFactory factory, MdObjectStore store, int behavior) throws RemoteException, MdException {
        boolean dirty = false;
        String defaultvalue = String.valueOf(behavior);
        Property property = MetaUtilities.setStringProperty((Root)flow, PropertyFlowExitcodeBehavior, factory, store, defaultvalue);
        if (property != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        return dirty;
    }

    private int getExitcodebehavior() throws SchedulerException {
        return DeployedFlow.getExitcodebehavior(this.m_flow);
    }

    private static int getExitcodebehavior(JFJob flow) throws SchedulerException {
        try {
            AssociationList properties = flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase(PropertyFlowExitcodeBehavior)) continue;
                String defaultvalue = property.getDefaultValue();
                if (defaultvalue.compareTo("No") == 0) {
                    return 0;
                }
                try {
                    return Integer.parseInt(defaultvalue);
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return 0;
    }

    public boolean hasExclusive() throws RemoteException, MdException {
        return DeployedFlow.hasExclusive(this.m_flow);
    }

    private static boolean hasExclusive(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyFlowExclusive)) continue;
            String defaultvalue = property.getDefaultValue();
            return defaultvalue.compareTo("Yes") == 0;
        }
        return false;
    }

    public boolean setExclusive(boolean enabled) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setExclusive(this.m_flow, this.m_factory, this.m_store, enabled);
        return true;
    }

    private static boolean setExclusive(JFJob flow, MdFactory factory, MdObjectStore store, boolean enabled) throws RemoteException, MdException {
        Property property;
        boolean dirty = false;
        String defaultvalue = "No";
        if (enabled) {
            defaultvalue = "Yes";
        }
        if ((property = MetaUtilities.setStringProperty((Root)flow, PropertyFlowExclusive, factory, store, defaultvalue)) != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        return dirty;
    }

    private static boolean saveLayout(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyFlowSaveLayout)) continue;
            String defaultvalue = property.getDefaultValue();
            return defaultvalue.compareTo("Yes") == 0;
        }
        return false;
    }

    public boolean saveLayout() throws RemoteException, MdException {
        return DeployedFlow.saveLayout(this.m_flow);
    }

    public boolean setSaveLayout(boolean enabled) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setSaveLayout(this.m_flow, this.m_factory, this.m_store, enabled);
        return true;
    }

    private static boolean setSaveLayout(JFJob flow, MdFactory factory, MdObjectStore store, boolean enabled) throws RemoteException, MdException {
        Property property;
        boolean dirty = false;
        String defaultvalue = "No";
        if (enabled) {
            defaultvalue = "Yes";
        }
        if ((property = MetaUtilities.setStringProperty((Root)flow, PropertyFlowSaveLayout, factory, store, defaultvalue)) != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        return dirty;
    }

    public List<String> getCompletionSelectedJobs() throws SchedulerException {
        return DeployedFlow.getCompletionSelectedJobs(this.m_flow);
    }

    private static List<String> getCompletionSelectedJobs(JFJob flow) throws SchedulerException {
        try {
            AssociationList properties = flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase(PropertyFlowCompletionJobList)) continue;
                String data = property.getDefaultValue();
                Vector<String> jobList = new Vector<String>();
                String[] jobs = data.split(":");
                for (int index = 0; index < jobs.length; ++index) {
                    jobList.add(jobs[index]);
                }
                return jobList;
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return null;
    }

    public boolean setCompletion(boolean enabled, int value, List selectedJobs) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setCompletion(this.m_flow, this.m_factory, this.m_store, enabled, value, selectedJobs);
        return true;
    }

    private static boolean setCompletion(JFJob flow, MdFactory factory, MdObjectStore store, boolean enabled, int value, List selectedJobs) throws RemoteException, MdException {
        Property property;
        boolean dirty = false;
        String defaultvalue = "No";
        if (enabled) {
            defaultvalue = String.valueOf(value);
        }
        if ((property = MetaUtilities.setStringProperty((Root)flow, PropertyFlowCompletion, factory, store, defaultvalue)) != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        if (selectedJobs == null || selectedJobs.size() <= 0) {
            Property property2 = MetaUtilities.setStringProperty((Root)flow, PropertyFlowCompletionJobList, factory, store, "");
            if (property2 != null) {
                flow.addElementToChangeList((CMetadata)property2);
                dirty = true;
            }
        } else {
            StringBuffer jobsvalue = new StringBuffer(selectedJobs.get(0).toString());
            for (int index = 1; index < selectedJobs.size(); ++index) {
                jobsvalue.append(":" + selectedJobs.get(index).toString());
            }
            Property property2 = MetaUtilities.setStringProperty((Root)flow, PropertyFlowCompletionJobList, factory, store, jobsvalue.toString());
            if (property2 != null) {
                flow.addElementToChangeList((CMetadata)property2);
                dirty = true;
            }
        }
        return dirty;
    }

    public boolean isNotifyEmail() throws SchedulerException {
        return DeployedFlow.isNotifyEmail(this.m_flow);
    }

    private static boolean isNotifyEmail(JFJob flow) throws SchedulerException {
        try {
            return DeployedFlow.getEmailNotificationLevel(flow) != -1;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public int getEmailNotificationLevel() throws RemoteException, MdException {
        return DeployedFlow.getEmailNotificationLevel(this.m_flow);
    }

    private static int getEmailNotificationLevel(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyEmailNotification)) continue;
            String defaultvalue = property.getDefaultValue();
            if (defaultvalue.compareTo("No") == 0) {
                return -1;
            }
            try {
                return Integer.parseInt(defaultvalue);
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }

    public String getEmailAddress() throws SchedulerException {
        return DeployedFlow.getEmailAddress(this.m_flow);
    }

    private static String getEmailAddress(JFJob flow) throws SchedulerException {
        try {
            AssociationList properties = flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase(PropertyEmailNotificationAddress)) continue;
                return property.getDefaultValue();
            }
            return null;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public boolean setEmailNotification(boolean enabled, int value, String emailaddress) throws RemoteException, MdException {
        Property existing2;
        Property existing = MetaUtilities.getPropertyObject((Root)this.m_flow, PropertyJobDefaultEmailNotification);
        if (existing != null && !existing.getDefaultValue().equals("No")) {
            List<Object> list = this.getJobs();
            for (Object o : list) {
                String neoEmail;
                if (!(o instanceof DeployedJob)) continue;
                DeployedJob djob = (DeployedJob)o;
                TransformationStep step = djob.getLogicalJob(this.m_activity);
                String details = DeployedJob.getSchedulingDetails(step);
                if (details == null || (neoEmail = this.m_scheduler.clearJobPropertyOnMatch(djob.getName(), details, PropertyJobDefaultEmailNotification, existing.getDefaultValue())).equals(details)) continue;
                DeployedJob.setSchedulingDetails(step, neoEmail);
            }
        }
        if ((existing2 = MetaUtilities.getPropertyObject((Root)this.m_flow, PropertyJobDefaultEmailNotificationAddress)) != null) {
            List<Object> list = this.getJobs();
            for (Object o : list) {
                String neoEmail;
                if (!(o instanceof DeployedJob)) continue;
                DeployedJob djob = (DeployedJob)o;
                TransformationStep step = djob.getLogicalJob(this.m_activity);
                String details = DeployedJob.getSchedulingDetails(step);
                if (details == null || (neoEmail = this.m_scheduler.clearJobPropertyOnMatch(djob.getName(), details, PropertyJobDefaultEmailNotificationAddress, existing2.getDefaultValue())).equals(details)) continue;
                DeployedJob.setSchedulingDetails(step, neoEmail);
            }
        }
        this.m_dirty = DeployedFlow.setEmailNotification(this.m_flow, this.m_factory, this.m_store, enabled, value, emailaddress);
        return true;
    }

    private static boolean setEmailNotification(JFJob flow, MdFactory factory, MdObjectStore store, boolean enabled, int value, String emailaddress) throws RemoteException, MdException {
        Property property2;
        Property property;
        boolean dirty = false;
        String defaultvalue = "No";
        if (enabled) {
            defaultvalue = String.valueOf(value);
        }
        if ((property = MetaUtilities.setStringProperty((Root)flow, PropertyEmailNotification, factory, store, defaultvalue)) != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        if ((property2 = MetaUtilities.setStringProperty((Root)flow, PropertyEmailNotificationAddress, factory, store, emailaddress)) != null) {
            flow.addElementToChangeList((CMetadata)property2);
            dirty = true;
        }
        return dirty;
    }

    public boolean isJobDefaultNotifyEmail() throws SchedulerException {
        return DeployedFlow.isJobDefaultNotifyEmail(this.m_flow);
    }

    private static boolean isJobDefaultNotifyEmail(JFJob flow) throws SchedulerException {
        try {
            return DeployedFlow.getJobDefaultEmailNotificationLevel(flow) != -1;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public int getJobDefaultEmailNotificationLevel() throws RemoteException, MdException {
        return DeployedFlow.getJobDefaultEmailNotificationLevel(this.m_flow);
    }

    private static int getJobDefaultEmailNotificationLevel(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyJobDefaultEmailNotification)) continue;
            String defaultvalue = property.getDefaultValue();
            if (defaultvalue.compareTo("No") == 0) {
                return -1;
            }
            try {
                return Integer.parseInt(defaultvalue);
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }

    public String getJobDefaultEmailAddress() throws SchedulerException {
        return DeployedFlow.getJobDefaultEmailAddress(this.m_flow);
    }

    private static String getJobDefaultEmailAddress(JFJob flow) throws SchedulerException {
        try {
            AssociationList properties = flow.getProperties();
            int numprops = properties.size();
            for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                Property property = (Property)properties.get(propertyCounter);
                if (!property.getPropertyName().equalsIgnoreCase(PropertyJobDefaultEmailNotificationAddress)) continue;
                return property.getDefaultValue();
            }
            return null;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public boolean setJobDefaultEmailNotification(List<DisplayInfo> jobs, boolean enabled, int value, String emailaddress) throws RemoteException, MdException {
        Property existing = MetaUtilities.getPropertyObject((Root)this.m_flow, PropertyJobDefaultEmailNotification);
        if (existing != null && !existing.getDefaultValue().equals("No")) {
            for (DisplayInfo o : jobs) {
                String neoDetails;
                JobInfo djob;
                String details;
                if (!(o instanceof JobInfo) || (details = (djob = (JobInfo)o).getSchedulerProperties()) == null || (neoDetails = this.m_scheduler.clearJobPropertyOnMatch(djob.getName(), details, PropertyJobDefaultEmailNotification, existing.getDefaultValue())).equals(details)) continue;
                djob.setSchedulerProperties(neoDetails);
            }
        }
        this.m_dirty = DeployedFlow.setJobDefaultEmailNotification(this.m_flow, this.m_factory, this.m_store, enabled, value, emailaddress);
        return true;
    }

    public boolean setJobDefaultEmailNotification(boolean enabled, int value, String emailaddress) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setJobDefaultEmailNotification(this.m_flow, this.m_factory, this.m_store, enabled, value, emailaddress);
        return true;
    }

    private static boolean setJobDefaultEmailNotification(JFJob flow, MdFactory factory, MdObjectStore store, boolean enabled, int value, String emailaddress) throws RemoteException, MdException {
        Property property2;
        Property property;
        boolean dirty = false;
        String defaultvalue = "No";
        if (enabled) {
            defaultvalue = String.valueOf(value);
        }
        if ((property = MetaUtilities.setStringProperty((Root)flow, PropertyJobDefaultEmailNotification, factory, store, defaultvalue)) != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        if ((property2 = MetaUtilities.setStringProperty((Root)flow, PropertyJobDefaultEmailNotificationAddress, factory, store, emailaddress)) != null) {
            flow.addElementToChangeList((CMetadata)property2);
            dirty = true;
        }
        return dirty;
    }

    public int getJobDefaultPriority() throws RemoteException, MdException {
        return DeployedFlow.getJobDefaultPriority(this.m_flow);
    }

    private static int getJobDefaultPriority(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyJobDefaultPriority)) continue;
            try {
                String defaultvalue = property.getDefaultValue();
                return Integer.parseInt(defaultvalue);
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }

    private boolean setJobDefaultPriority(List<DisplayInfo> jobs, int value) throws RemoteException, MdException {
        Property existing = MetaUtilities.getPropertyObject((Root)this.m_flow, PropertyJobDefaultPriority);
        if (existing != null) {
            for (DisplayInfo o : jobs) {
                String neoDetails;
                JobInfo djob;
                String details;
                if (!(o instanceof JobInfo) || (details = (djob = (JobInfo)o).getSchedulerProperties()) == null || (neoDetails = this.m_scheduler.clearJobPropertyOnMatch(djob.getName(), details, PropertyJobDefaultPriority, existing.getDefaultValue())).equals(details)) continue;
                djob.setSchedulerProperties(neoDetails);
            }
        }
        this.m_dirty = DeployedFlow.setJobDefaultPriority(this.m_flow, this.m_factory, this.m_store, value);
        return true;
    }

    public boolean setJobDefaultPriority(int value) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setJobDefaultPriority(this.m_flow, this.m_factory, this.m_store, value);
        return true;
    }

    private static boolean setJobDefaultPriority(JFJob flow, MdFactory factory, MdObjectStore store, int value) throws RemoteException, MdException {
        boolean dirty = false;
        String defaultvalue = String.valueOf(value);
        Property property = MetaUtilities.setStringProperty((Root)flow, PropertyJobDefaultPriority, factory, store, defaultvalue);
        if (property != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        return dirty;
    }

    public String getJobDefaultEnvironmentVariables() throws RemoteException, MdException {
        return DeployedFlow.getJobDefaultEnvironmentVariables(this.m_flow);
    }

    private static String getJobDefaultEnvironmentVariables(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyJobDefaultEnvironmentVariables)) continue;
            String defaultvalue = property.getDefaultValue();
            return defaultvalue;
        }
        return null;
    }

    private boolean setJobDefaultEnvironmentVariables(List<DisplayInfo> jobs, String value) throws RemoteException, MdException {
        Property existing = MetaUtilities.getPropertyObject((Root)this.m_flow, PropertyJobDefaultEnvironmentVariables);
        if (existing != null) {
            for (DisplayInfo o : jobs) {
                String neoDetails;
                JobInfo djob;
                String details;
                if (!(o instanceof JobInfo) || (details = (djob = (JobInfo)o).getSchedulerProperties()) == null || (neoDetails = this.m_scheduler.clearJobPropertyOnMatch(djob.getName(), details, PropertyJobDefaultEnvironmentVariables, existing.getDefaultValue())).equals(details)) continue;
                djob.setSchedulerProperties(neoDetails);
            }
        }
        this.m_dirty = DeployedFlow.setJobDefaultEnvironmentVariables(this.m_flow, this.m_factory, this.m_store, value);
        return true;
    }

    public boolean setJobDefaultEnvironmentVariables(String value) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setJobDefaultEnvironmentVariables(this.m_flow, this.m_factory, this.m_store, value);
        return true;
    }

    private static boolean setJobDefaultEnvironmentVariables(JFJob flow, MdFactory factory, MdObjectStore store, String value) throws RemoteException, MdException {
        boolean dirty = false;
        Property property = MetaUtilities.setStringProperty((Root)flow, PropertyJobDefaultEnvironmentVariables, factory, store, value);
        if (property != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        return dirty;
    }

    public String getJobDefaultExceptionHandlers() throws RemoteException, MdException {
        return DeployedFlow.getJobDefaultExceptionHandlers(this.m_flow);
    }

    private static String getJobDefaultExceptionHandlers(JFJob flow) throws RemoteException, MdException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyJobDefaultExceptionHandlers)) continue;
            String defaultvalue = property.getDefaultValue();
            return defaultvalue;
        }
        return null;
    }

    private boolean setJobDefaultExceptionHandlers(List<DisplayInfo> jobs, String value) throws RemoteException, MdException {
        Property existing = MetaUtilities.getPropertyObject((Root)this.m_flow, PropertyJobDefaultExceptionHandlers);
        if (existing != null) {
            for (DisplayInfo o : jobs) {
                String neoDetails;
                JobInfo djob;
                String details;
                if (!(o instanceof JobInfo) || (details = (djob = (JobInfo)o).getSchedulerProperties()) == null || (neoDetails = this.m_scheduler.clearJobPropertyOnMatch(djob.getName(), details, PropertyJobDefaultExceptionHandlers, existing.getDefaultValue())).equals(details)) continue;
                djob.setSchedulerProperties(neoDetails);
            }
        }
        this.m_dirty = DeployedFlow.setJobDefaultExceptionHandlers(this.m_flow, this.m_factory, this.m_store, value);
        return true;
    }

    public boolean setJobDefaultExceptionHandlers(String value) throws RemoteException, MdException {
        this.m_dirty = DeployedFlow.setJobDefaultExceptionHandlers(this.m_flow, this.m_factory, this.m_store, value);
        return true;
    }

    private static boolean setJobDefaultExceptionHandlers(JFJob flow, MdFactory factory, MdObjectStore store, String value) throws RemoteException, MdException {
        boolean dirty = false;
        Property property = MetaUtilities.setStringProperty((Root)flow, PropertyJobDefaultExceptionHandlers, factory, store, value);
        if (property != null) {
            flow.addElementToChangeList((CMetadata)property);
            dirty = true;
        }
        return dirty;
    }

    public String getPFD() throws MdException, RemoteException {
        return DeployedFlow.getPFD(this.m_flow);
    }

    public static String getPFD(JFJob flow) throws MdException, RemoteException {
        AssociationList properties = flow.getProperties();
        int numprops = properties.size();
        for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
            Property property = (Property)properties.get(propertyCounter);
            if (!property.getPropertyName().equalsIgnoreCase(PropertyPFDModel)) continue;
            return property.getDefaultValue();
        }
        return null;
    }

    public boolean setPFD(FlowPFD pfd) throws RemoteException, MdException {
        String value = pfd != null ? pfd.getTextData() : null;
        Property property = MetaUtilities.setStringProperty((Root)this.m_flow, PropertyPFDModel, this.m_factory, this.m_store, value);
        if (property != null) {
            this.m_flow.addElementToChangeList((CMetadata)property);
            this.m_dirty = true;
        }
        return true;
    }

    public void commitChangesOnly() throws RemoteException, MdException {
        this.m_flow.updateMetadataAll();
        this.m_deleteList.clear();
    }

    public boolean commitChanges() throws RemoteException {
        if (this.validateData()) {
            if (MetaUtilities.isDebug()) {
                System.out.println("Data validation passed, writing flow to metadata.");
            }
            return this.commitChangesWithNoValidation();
        }
        if (MetaUtilities.isDebug()) {
            System.out.println("Data validation failed, not updating flow to metadata.");
        }
        return false;
    }

    public boolean commitChangesWithNoValidation() {
        try {
            this.m_flow.updateMetadataAll();
            this.m_deleteList.clear();
            return true;
        }
        catch (MdException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            if (this.m_scheduler instanceof DIPServiceProxy || this.m_scheduler instanceof SASJFSServiceProxy) {
                return true;
            }
            if (System.getProperty("sas.sch.RecoverOnMetadataWriteFailure") != null) {
                try {
                    this.m_store.clearChangeList();
                    this.refresh();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        catch (RemoteException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
        catch (Exception ex) {
            StackTraceElement[] st = ex.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                if (!st[i].getMethodName().contains("MdFactoryImpl.fireMdObject")) continue;
                ex.printStackTrace();
                return true;
            }
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public boolean delete() throws MdException, RemoteException {
        return DeployedFlow.delete(this.m_flow, this.m_factory);
    }

    public static boolean delete(JFJob flow, MdFactory factory) throws MdException, RemoteException {
        flow.setTransformRole("SCHEDULER_FLOW_DELETE");
        try {
            flow.updateMetadataAll();
        }
        catch (MdException mdException) {
            // empty catch block
        }
        ArrayList<Object> deleteList = new ArrayList<Object>();
        deleteList.add(flow);
        AssociationList list = flow.getSteps(true);
        for (TransformationStep step : list) {
            if (step instanceof SyncStep) continue;
            deleteList.add(step);
        }
        factory.deleteMetadataObjects(deleteList);
        return true;
    }

    private static void deleteFlowEvents(JFJob flow, TransformationActivity ta, boolean readFromServer) throws MdException, RemoteException {
        MdFactory factory = flow.getObjectStore().getFactory();
        AssociationList list = ta.getSteps(readFromServer);
        for (TransformationStep step : list) {
            factory.deleteMetadataObjects((List)step.getPredecessorDependencies());
            factory.deleteMetadataObjects((List)step.getSuccessorDependencies());
            factory.deleteMetadataObjects((List)step.getProperties());
            for (Event event : step.getTriggeringEvents()) {
                factory.deleteMetadataObjects((List)event.getProperties());
            }
            factory.deleteMetadataObjects((List)step.getTriggeringEvents());
        }
        factory.deleteMetadataObjects((List)list);
        list = flow.getSteps(readFromServer);
        ArrayList<TransformationStep> deleteList = new ArrayList<TransformationStep>();
        for (TransformationStep step : list) {
            if (!(step instanceof SyncStep)) continue;
            for (Event event : step.getTriggeringEvents()) {
                factory.deleteMetadataObjects((List)event.getProperties());
            }
            factory.deleteMetadataObjects((List)step.getTriggeringEvents());
            for (Event event : step.getTriggeredEvents()) {
                factory.deleteMetadataObjects((List)event.getProperties());
            }
            factory.deleteMetadataObjects((List)step.getTriggeredEvents());
            deleteList.add(step);
        }
        factory.deleteMetadataObjects(deleteList);
    }

    public boolean delete(String username, String password) throws MdException, RemoteException, SchedulerException {
        this.m_flow.setTransformRole("SCHEDULER_FLOW_DELETE");
        this.m_flow.updateMetadataAll();
        if (this.isFlowSubmitted()) {
            this.m_scheduler.makeConnection(username, password != null ? new SealedString(password) : null);
            this.m_scheduler.removeFlow(this.getInfo());
            this.m_scheduler.closeConnection();
        }
        return DeployedFlow.delete(this.m_flow, this.m_factory);
    }

    public static boolean delete(JFJob flow, MdFactory factory, Scheduler scheduler) throws MdException, RemoteException, SchedulerException {
        flow.setTransformRole("SCHEDULER_FLOW_DELETE");
        flow.updateMetadataAll();
        if (DeployedFlow.isFlowSubmitted(flow)) {
            DeployedFlow.setFlowSubmitted(flow, scheduler, false);
            flow.updateMetadataAll();
            FlowInfo info = new FlowInfo(flow.getName(), null, scheduler.getServerComponent());
            scheduler.removeFlow(scheduler.genFlowName(info));
        }
        return DeployedFlow.delete(flow, factory);
    }

    public static String getInvalidChars() {
        return MetaUtilities.INVALIDFLOWNAMECHARACTERS;
    }

    public String getInvalidChars(int type) {
        if (this.m_scheduler != null) {
            if (type == 0) {
                return this.m_scheduler.getInvalidChars(true);
            }
            return this.m_scheduler.getInvalidChars(false);
        }
        if (type == 0) {
            return MetaUtilities.INVALIDFLOWNAMECHARACTERS;
        }
        return MetaUtilities.INVALIDJOBNAMECHARACTERS;
    }

    public boolean isValidName(String name, int type) {
        if (this.m_scheduler != null) {
            if (type == 0) {
                return this.m_scheduler.isValidFlowName(name);
            }
            return this.m_scheduler.isValidJobName(name);
        }
        return DeployedFlow.isValidName(name);
    }

    public static boolean isValidName(String name) {
        int namelen = name.length();
        if (namelen == 0) {
            return false;
        }
        for (int i = 0; i < namelen; ++i) {
            if (MetaUtilities.INVALIDFLOWNAMECHARACTERS.indexOf(name.substring(i, i + 1)) == -1) continue;
            return false;
        }
        return true;
    }

    public static String genValidFlowName(String nameStr) {
        String myname = nameStr;
        int slen = MetaUtilities.INVALIDFLOWNAMECHARACTERS.length();
        for (int i = 0; i < slen; ++i) {
            char c = MetaUtilities.INVALIDFLOWNAMECHARACTERS.charAt(i);
            if (nameStr.indexOf(c) <= 0) continue;
            myname = nameStr.replace(c, MetaUtilities.SUBCHAR);
        }
        myname = myname + ((long)MetaUtilities.SUBCHAR + System.currentTimeMillis());
        return myname;
    }

    public static boolean isValidFlowName(String name) {
        return MetaUtilities.isValidFlowName(name);
    }

    public boolean setDescription(String description) throws RemoteException {
        if (this.m_flow == null) {
            return false;
        }
        this.m_flow.setDesc(description);
        return true;
    }

    public boolean hasErrors() {
        return this.m_errorFlag != 0;
    }

    public boolean hasErrorsInJobs() {
        return (this.m_errorFlag & 0x10) != 0;
    }

    public boolean hasCriticalErrors() {
        return (this.m_errorFlag & 1) != 0;
    }

    public String errorConditions() throws RemoteException {
        return this.errorConditions(0);
    }

    public String errorConditions(int tablevel) throws RemoteException {
        StringBuffer errmessage = new StringBuffer();
        String tabchar = "   ";
        String tabprefix = "";
        for (int i = 0; i < tablevel; ++i) {
            tabprefix = tabprefix + tabchar;
        }
        if (this.m_errorFlag != 0) {
            errmessage.append(tabprefix);
            errmessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.ErrorsDetected.Header.fmt"), this.m_flow.getName()) + "\n");
        }
        if ((this.m_errorFlag & 1) != 0) {
            errmessage.append(tabchar);
            errmessage.append(m_bundle.getString("DeployedFlow.MissingRequiredObject.ScheduleServer.txt") + "\n");
        }
        if ((this.m_errorFlag & 0x10) != 0) {
            for (Object obj : this.m_JobsInError) {
                String text = "";
                text = obj instanceof DeployedJob ? ((DeployedJob)obj).errorConditions() : (obj instanceof DeployedFlow ? ((DeployedFlow)obj).errorConditions(tablevel) : MetaUtilities.messageString(m_bundle.getString("DeployedFlow.MissingJobError.msg.fmt"), obj));
                errmessage.append(tabprefix);
                errmessage.append(tabchar);
                errmessage.append(text);
            }
        }
        if (this.m_errorFlag != 0) {
            errmessage.append(tabprefix);
            errmessage.append(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.ErrorsDetected.Footer.fmt"), this.m_flow.getName()) + "\n");
        }
        return errmessage.toString();
    }

    public void checkAssociatedJobForErrors(DeployedJob job) {
        if (this.m_jobs != null && this.m_jobs.contains(job) && job.hasErrors()) {
            this.m_errorFlag |= 0x10;
            if (!this.m_JobsInError.contains(job)) {
                this.m_JobsInError.add(job);
            }
        }
    }

    public void checkAssociatedSubflowForErrors(DeployedFlow sflow) {
        if (this.m_jobs != null && this.m_jobs.contains(sflow) && sflow.hasErrors()) {
            this.m_errorFlag |= 0x10;
            if (!this.m_JobsInError.contains(sflow)) {
                this.m_JobsInError.add(sflow);
            }
        }
    }

    public void reevaluateErrors() {
        if ((this.m_errorFlag & 1) != 0) {
            try {
                ServerComponent sc = (ServerComponent)this.m_flow.getComputeLocations().get(0);
                this.m_scheduler = MetaUtilities.getSchedulingServer(sc);
            }
            catch (MdException ex) {
                this.m_scheduler = null;
                return;
            }
            catch (RemoteException ex) {
                this.m_scheduler = null;
                return;
            }
            catch (RuntimeException ex) {
                this.m_scheduler = null;
                return;
            }
            this.m_errorFlag &= 0x1110;
        }
        if ((this.m_errorFlag & 0x10) != 0) {
            ArrayList<Object> removelist = new ArrayList<Object>();
            int count = 0;
            for (Object obj : this.m_JobsInError) {
                if (obj instanceof DeployedJob) {
                    DeployedJob djob = (DeployedJob)obj;
                    djob.reevaluateErrors();
                    if (djob.hasErrors()) {
                        ++count;
                        continue;
                    }
                    removelist.add(obj);
                    continue;
                }
                if (obj instanceof DeployedFlow) {
                    DeployedFlow sflow = (DeployedFlow)obj;
                    sflow.reevaluateErrors();
                    if (sflow.hasErrors()) {
                        ++count;
                        continue;
                    }
                    removelist.add(obj);
                    continue;
                }
                if (!(obj instanceof TransformationStep)) continue;
                TransformationStep estep = (TransformationStep)obj;
                try {
                    for (TransformationStep step : this.m_activity.getSteps()) {
                        if (step instanceof SyncStep || estep.getId().compareTo(step.getId()) != 0) continue;
                        step.getTransformations().get(0);
                        removelist.add(obj);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ++count;
                }
                catch (RemoteException e) {
                    ++count;
                }
                catch (MdException e) {
                    ++count;
                }
            }
            if (removelist.size() > 0) {
                this.m_JobsInError.removeAll(removelist);
            }
            if (count == 0) {
                this.m_errorFlag &= 0x1101;
            }
        }
    }

    private static GroupingEvent processGrouping(SyncStep step, Scheduler scheduler, boolean readFromServer) throws RemoteException, MdException, IOException, SchedulerException {
        GroupingEvent object = new GroupingEvent(step.getTransformRole());
        AssociationList predecessors = step.getPredecessorDependencies(readFromServer);
        int numPreds = predecessors.size();
        for (int i = 0; i < numPreds; ++i) {
            StepPrecedence sp = (StepPrecedence)predecessors.get(i);
            TransformationStep predStep = (TransformationStep)sp.getSuccessors().get(0);
            if (predStep instanceof SyncStep) {
                GroupingEvent event;
                if (predStep.getTransformRole().equalsIgnoreCase(StrGroupAnd) || predStep.getTransformRole().equalsIgnoreCase(StrGroupOr)) {
                    event = DeployedFlow.processGrouping((SyncStep)predStep, scheduler, readFromServer);
                    object.addDependency(event);
                    continue;
                }
                if (!predStep.getTransformRole().equalsIgnoreCase(WaitEventRole)) continue;
                try {
                    event = (Event)predStep.getTriggeringEvents().get(0);
                    AbstractEventInterface aevent = DeployedFlow.processWaitEvent((Event)event, scheduler);
                    object.addDependency(aevent);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    predStep.getObjectStore().getFactory().deleteMetadataObject((CMetadata)predStep);
                    throw new MdException(MetaUtilities.messageString(m_bundle.getString("DeployedFlow.InvalidDependencyError.msg.fmt"), step.getName()));
                }
            }
            if (predStep == null || !(predStep.getTransformations().get(0) instanceof JFJob)) continue;
            JFJob job = (JFJob)predStep.getTransformations().get(0);
            boolean isFlow = false;
            if (job.getTransformRole().equals("SCHEDULER_FLOW")) {
                isFlow = true;
            } else if (job.getTransformRole().equals("") && 0 != job.getJobActivities().size()) {
                isFlow = true;
            }
            if (isFlow) {
                String command = predStep.getName();
                JobEvent jobEvent = new JobEvent(job.getName(), command, sp);
                object.addDependency(jobEvent);
                continue;
            }
            JobEvent jobEvent = new JobEvent(new DeployedJob(job), sp);
            object.addDependency(jobEvent);
        }
        return object;
    }

    private void updateJobDependencyProperties(StepPrecedence sp, JobEvent newJobEvent) throws MdException, RemoteException {
        AssociationList alProperties = sp.getProperties();
        for (Property property : alProperties) {
            String sName = property.getPropertyName();
            if (sName.equalsIgnoreCase(PropertyOperatorName)) {
                property.setDefaultValue(GeneralUtilities.getOperatorSymbolString((int)newJobEvent.getOperator()));
                continue;
            }
            if (sName.equalsIgnoreCase(PropertyValueName)) {
                property.setDefaultValue(Integer.toString(newJobEvent.getValue()));
                continue;
            }
            if (!sName.equalsIgnoreCase(PropertyDependencyTypeName)) continue;
            property.setDefaultValue(Integer.toString(newJobEvent.getType()));
        }
        sp.setDesc(newJobEvent.getDescription());
    }

    private int initializeFromJob(TransformationStep step, List<EventListItem> list, boolean readFromServer) throws MdException, RemoteException {
        int defaultgrouping = DeployedFlow.initializeFromJob2(step, list, readFromServer);
        if (defaultgrouping != -1) {
            this.m_defaultGrouping = defaultgrouping;
        }
        return list.size();
    }

    private static int initializeFromJob2(TransformationStep step, List<EventListItem> list, boolean readFromServer) throws MdException, RemoteException {
        int defaultgrouping = -1;
        if (step != null) {
            EventListItem entry = null;
            AssociationList steppreds = step.getPredecessorDependencies(readFromServer);
            int stepsize = steppreds.size();
            for (int k = 0; k < stepsize; ++k) {
                entry = null;
                StepPrecedence steppred = (StepPrecedence)steppreds.get(k);
                TransformationStep ts = null;
                AssociationList predecessors = steppred.getSuccessors(readFromServer);
                if (predecessors.size() > 0) {
                    ts = (TransformationStep)predecessors.get(0);
                }
                if (ts instanceof SyncStep) {
                    SyncStep predStep = (SyncStep)ts;
                    String predStepRole = predStep.getTransformRole();
                    if (predStepRole.equalsIgnoreCase(WaitEventRole)) {
                        entry = MetaUtilities.processWaitEvent(predStep);
                        if (entry == null) continue;
                        list.add(entry);
                        continue;
                    }
                    if (predStepRole.equalsIgnoreCase(StrGroupAnd) || predStepRole.equalsIgnoreCase(StrGroupOr)) {
                        DeployedFlow.initializeFromJob2((TransformationStep)predStep, list, readFromServer);
                        if (predStepRole.equalsIgnoreCase(StrGroupAnd)) {
                            defaultgrouping = 31;
                            continue;
                        }
                        defaultgrouping = 32;
                        continue;
                    }
                    MdException ex = new MdException("DeployedFlow.InvalidMetadataModel.txt");
                    throw ex;
                }
                if (ts != null) {
                    entry = MetaUtilities.processJobEvent(steppred, ts);
                    if (entry == null) continue;
                    list.add(entry);
                    continue;
                }
                if (readFromServer) {
                    steppred.getObjectStore().getFactory().deleteMetadataObject((CMetadata)steppred);
                    continue;
                }
                steppred.delete();
            }
        }
        return defaultgrouping;
    }

    private static AbstractEventInfo getComplexEvents(TransformationStep step, String targetName, String targetId, String flowname, Scheduler scheduler, boolean readFromServer) throws MdException, RemoteException {
        if (step != null) {
            GroupingEventInfo info = null;
            String stepRole = step.getTransformRole();
            if (step instanceof SyncStep && (stepRole.equalsIgnoreCase(StrGroupAnd) || stepRole.equalsIgnoreCase(StrGroupOr))) {
                if (stepRole.equalsIgnoreCase(StrGroupAnd)) {
                    info = new GroupingEventInfo(new JobInfo(targetName, targetId, null), 0);
                } else if (stepRole.equalsIgnoreCase(StrGroupOr)) {
                    info = new GroupingEventInfo(new JobInfo(targetName, targetId, null), 1);
                }
                info.setId(step.getId());
                AssociationList grouppreds = step.getPredecessorDependencies(readFromServer);
                int stepsize2 = grouppreds.size();
                for (int k = 0; k < stepsize2; ++k) {
                    StepPrecedence pred = (StepPrecedence)grouppreds.get(k);
                    TransformationStep tstep = null;
                    AssociationList predecessors = pred.getSuccessors(readFromServer);
                    if (predecessors.size() > 0) {
                        tstep = (TransformationStep)predecessors.get(0);
                    }
                    AbstractEventInfo i = null;
                    if (tstep instanceof SyncStep) {
                        i = DeployedFlow.getComplexEvents(tstep, targetName, targetId, flowname, scheduler, readFromServer);
                    } else if (tstep instanceof TransformationStep) {
                        EventListItem entry = MetaUtilities.processJobEvent(pred, tstep);
                        if (entry != null) {
                            Object jobevent = entry.getProperty("JobEvent");
                            JobEvent je = (JobEvent)jobevent;
                            i = je.getInfo(je.getDeployedJob().getInfo(flowname));
                        } else if (MetaUtilities.isDebug()) {
                            System.out.println("Warning: Potential metadata issue: Missing association to Deployed Job from Deployed Flow(" + tstep.getName() + "{" + tstep.getId() + "}).  Job dependency is ignored.");
                        }
                    } else if (readFromServer) {
                        pred.getObjectStore().getFactory().deleteMetadataObject((CMetadata)pred);
                    } else {
                        pred.delete();
                    }
                    if (i == null) continue;
                    info.addDependency(i);
                }
                return info;
            }
            if (step instanceof SyncStep) {
                if (stepRole.equalsIgnoreCase(WaitEventRole)) {
                    String eventRole;
                    EventListItem entry = MetaUtilities.processWaitEvent((SyncStep)step);
                    Event event = entry.getEvent();
                    String string = eventRole = event != null ? event.getEventRole() : "";
                    if (eventRole.equalsIgnoreCase(RoleFileEvent)) {
                        FileEvent fe = (FileEvent)entry.getProperty("eventObject");
                        if (fe == null) {
                            try {
                                fe = (FileEvent)DeployedFlow.processWaitEvent(entry.getEvent(), scheduler);
                            }
                            catch (SchedulerException tstep) {
                            }
                            catch (IOException tstep) {
                                // empty catch block
                            }
                        }
                        if (fe != null) {
                            info = fe.getInfo();
                            try {
                                info.setId(entry.getSyncStep().getId());
                            }
                            catch (NullPointerException npe) {
                                info.setId(null);
                            }
                        }
                    } else if (eventRole.equalsIgnoreCase(RoleTimeEvent)) {
                        TimeEvent te = (TimeEvent)entry.getProperty("eventObject");
                        if (te == null) {
                            try {
                                te = (TimeEvent)DeployedFlow.processWaitEvent(entry.getEvent(), scheduler);
                            }
                            catch (SchedulerException npe) {
                            }
                            catch (IOException npe) {
                                // empty catch block
                            }
                        }
                        if (te != null) {
                            info = te.getInfo();
                            try {
                                info.setId(entry.getSyncStep().getId());
                            }
                            catch (NullPointerException npe) {
                                info.setId(null);
                            }
                        }
                    } else {
                        MdException ex = new MdException("DeployedFlow.InvalidMetadataModel.txt");
                        throw ex;
                    }
                }
                return info;
            }
            AssociationList steppreds = step.getPredecessorDependencies(readFromServer);
            int stepsize = steppreds.size();
            if (stepsize > 0) {
                StepPrecedence steppred = (StepPrecedence)steppreds.get(0);
                TransformationStep ts = null;
                AssociationList predecessors = steppred.getSuccessors(readFromServer);
                if (predecessors.size() > 0) {
                    ts = (TransformationStep)predecessors.get(0);
                }
                if (ts instanceof SyncStep) {
                    info = DeployedFlow.getComplexEvents(ts, targetName, targetId, flowname, scheduler, readFromServer);
                } else if (ts != null) {
                    EventListItem entry = MetaUtilities.processJobEvent(steppred, ts);
                    if (entry != null) {
                        Object jobevent = entry.getProperty("JobEvent");
                        JobEvent je = (JobEvent)jobevent;
                        info = je.getInfo(je.getDeployedJob().getInfo(flowname));
                    }
                } else if (readFromServer) {
                    steppred.getObjectStore().getFactory().deleteMetadataObject((CMetadata)steppred);
                } else {
                    steppred.delete();
                }
            }
            return info;
        }
        return null;
    }

    private void createJFJobObject(String name, Scheduler scheduler) throws MdException, RemoteException {
        this.m_flow = (JFJob)this.m_factory.createComplexMetadataObject(this.m_store, null, name, "JFJob", this.m_repos, null);
        this.m_activity = (TransformationActivity)this.m_factory.createComplexMetadataObject(this.m_store, null, name, "TransformationActivity", this.m_repos, null);
        this.m_flow.setTransformRole("SCHEDULER_FLOW");
        this.m_flow.setUsageVersion("2000000.0");
        this.m_flow.setPublicType("DeployedFlow");
        this.m_flow.getJobActivities().add((Object)this.m_activity);
        ServerComponent sc = MetaUtilities.getSchedulerServer(scheduler.getServerComponent(), this.m_store);
        this.m_flow.getComputeLocations().add((Object)sc);
        Property submit = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, "SUBMITTED", "Property", this.m_repos, null);
        submit.setPropertyName("SUBMITTED");
        submit.setDefaultValue("0");
        submit.setSQLType(12);
        this.m_flow.getProperties().add((Object)submit);
    }

    private StepPrecedence addJobDependency(TransformationStep dJobTS, TransformationStep pJobTS, int type, int operator, int value) throws MdException, RemoteException {
        boolean createSP;
        TransformationStep pTS = null;
        TransformationStep sTS = null;
        StepPrecedence sp = null;
        boolean found = false;
        if (pJobTS != null && dJobTS != null) {
            AssociationList listSPs = dJobTS.getPredecessorDependencies();
            Iterator i = listSPs.iterator();
            while (!found && i.hasNext()) {
                sp = (StepPrecedence)i.next();
                AssociationList listTS = sp.getSuccessors();
                Iterator j = listTS.iterator();
                while (!found && j.hasNext()) {
                    TransformationStep ts = (TransformationStep)j.next();
                    if (!ts.getFQID().equals(pJobTS.getFQID())) continue;
                    sTS = dJobTS;
                    pTS = pJobTS;
                    found = true;
                }
            }
        }
        boolean areGrouping = sTS == null && (type == 32 || type == 31);
        boolean bl = createSP = areGrouping && !found || !areGrouping;
        if (createSP) {
            String strCondition = this.createTypeName(type);
            sp = (StepPrecedence)this.m_factory.createComplexMetadataObject(this.m_store, null, strCondition, "StepPrecedence", this.m_repos, null);
            AssociationList listJobs = this.m_activity.getSteps();
            for (TransformationStep ts : listJobs) {
                if (dJobTS != null && ts.getFQID().equals(dJobTS.getFQID())) {
                    sTS = ts;
                    continue;
                }
                if (pJobTS == null || !ts.getFQID().equals(pJobTS.getFQID())) continue;
                pTS = ts;
            }
        }
        if (pTS != null && sTS != null && sp != null) {
            if (createSP) {
                sp.getSuccessors().add(pTS);
                sp.getPredecessors().add(sTS);
            }
            if (type != 31 && type != 32 && type != 40 && type != 41) {
                sp.getProperties().clear();
                Property operatorProperty = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, sp.getName(), "Property", this.m_repos, null);
                operatorProperty.setPropertyName(PropertyOperatorName);
                operatorProperty.setDefaultValue(this.getOperatorString(operator));
                operatorProperty.setSQLType(12);
                sp.getProperties().add((Object)operatorProperty);
                Property valueProperty = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, sp.getName(), "Property", this.m_repos, null);
                valueProperty.setPropertyName(PropertyValueName);
                valueProperty.setDefaultValue(Integer.toString(value));
                valueProperty.setSQLType(12);
                sp.getProperties().add((Object)valueProperty);
                Property dependencyTypeProperty = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, sp.getName(), "Property", this.m_repos, null);
                dependencyTypeProperty.setPropertyName(PropertyDependencyTypeName);
                dependencyTypeProperty.setDefaultValue(Integer.toString(type));
                dependencyTypeProperty.setSQLType(12);
                sp.getProperties().add((Object)dependencyTypeProperty);
            }
        } else {
            MdException ex = new MdException(m_bundle.getString("DeployedFlow.MissingStepsToSetPrecedence.txt"));
            throw ex;
        }
        this.m_dirty = true;
        return sp;
    }

    private Event createTriggerEvent(TriggerEventInfo trigger) throws RemoteException, MdException, SchedulerException {
        String reposid = this.m_flow.getId().substring(0, 8);
        return MetaUtilities.createTriggerEventObject((DisplayInfo)trigger.getEvent(), this.m_scheduler, this.m_store, reposid);
    }

    private SyncStep createEvent(DisplayInfo info, String strRole) throws MdException, RemoteException, SchedulerException {
        String syncMetadataName = MetaUtilities.messageString(m_bundle.getString("MetaUtilities.SyncStepName.Event.fmt"), strRole);
        String reposid = this.m_flow.getId().substring(0, 8);
        SyncStep syncstep = (SyncStep)this.m_factory.createComplexMetadataObject(this.m_store, null, syncMetadataName, "SyncStep", reposid, null);
        syncstep.setTransformRole(WaitEventRole);
        syncstep.getActivities().add((Object)this.m_activity);
        Event event = MetaUtilities.createTriggerEventObject(info, this.m_scheduler, this.m_store, reposid);
        syncstep.getTriggeringEvents().add((Object)event);
        return syncstep;
    }

    private StepPrecedence addEvent(DeployedJob job, SyncStep syncstep, int condition) throws MdException, RemoteException {
        TransformationStep ts = job.getLogicalJob(this.m_activity);
        int type = 32;
        if (ts.getTransformRole().equalsIgnoreCase(StrGroupAnd)) {
            type = 31;
        }
        this.m_defaultGrouping = type;
        StepPrecedence sp = this.addJobDependency(ts, (TransformationStep)syncstep, condition, 0, 0);
        this.m_dirty = true;
        return sp;
    }

    private StepPrecedence addEvent(DeployedFlow sflow, SyncStep syncstep, int condition) throws MdException, RemoteException {
        TransformationStep ts = sflow.getLogicalJob(this.m_activity);
        int type = 32;
        if (ts.getTransformRole().equalsIgnoreCase(StrGroupAnd)) {
            type = 31;
        }
        this.m_defaultGrouping = type;
        StepPrecedence sp = this.addJobDependency(ts, (TransformationStep)syncstep, condition, 0, 0);
        this.m_dirty = true;
        return sp;
    }

    private AssociationList deleteEvent(TransformationStep step, SyncStep estep) throws MdException, RemoteException {
        Event event;
        SyncStep eTS = null;
        TransformationStep TS = null;
        StepPrecedence sp = null;
        boolean found = false;
        if (estep != null && step != null) {
            AssociationList listSPs = null;
            SyncStep sstep = this.getJobGrouping(step);
            listSPs = sstep != null ? sstep.getPredecessorDependencies() : step.getPredecessorDependencies();
            Iterator i = listSPs.iterator();
            while (!found && i.hasNext()) {
                sp = (StepPrecedence)i.next();
                AssociationList listTS = sp.getSuccessors();
                Iterator j = listTS.iterator();
                while (!found && j.hasNext()) {
                    TransformationStep ts = (TransformationStep)j.next();
                    if (!ts.getFQID().equals(estep.getFQID())) continue;
                    TS = step;
                    eTS = estep;
                    found = true;
                }
            }
        }
        if (!found) {
            return null;
        }
        AssociationList returnvalue = null;
        if (eTS != null && TS != null) {
            AssociationList successorSteps = eTS.getSuccessorDependencies();
            StepPrecedence successorSP = (StepPrecedence)successorSteps.get(0);
            if (successorSP != null) {
                returnvalue = successorSP.getSuccessors();
                this.m_deleteList.add(successorSP.getId());
                successorSP.delete();
            }
            event = (Event)eTS.getTriggeringEvents().get(0);
            TriggerEvent tevent = this.getTriggerEvent();
            if (tevent != null && tevent.getEvent().getId().equalsIgnoreCase(event.getId())) {
                this.removeTriggerEvent();
            }
            ArrayList<Property> deletepr = new ArrayList<Property>();
            for (Property property : event.getProperties()) {
                deletepr.add(property);
            }
            if (deletepr.size() > 0) {
                for (int x = deletepr.size() - 1; x >= 0; --x) {
                    Property p = (Property)deletepr.get(x);
                    this.m_deleteList.add(p.getId());
                    p.delete();
                }
            }
        } else {
            MdException ex = new MdException(m_bundle.getString("DeployedFlow.MissingStepsToSetPrecedence.txt"));
            throw ex;
        }
        this.m_deleteList.add(event.getId());
        event.delete();
        this.m_deleteList.add(eTS.getId());
        eTS.delete();
        this.m_dirty = true;
        return returnvalue;
    }

    private TransformationStep getTransformationStepForJob(JFJob job) throws MdException, RemoteException {
        TransformationStep step = null;
        AssociationList tsteps = null;
        int numSteps = 0;
        if (job != null) {
            tsteps = job.getSteps();
            numSteps = tsteps.size();
        }
        if (this.m_flow != null) {
            for (int i = 0; i < numSteps; ++i) {
                AssociationList activites;
                if (tsteps == null || !(tsteps.get(i) instanceof TransformationStep) || (activites = (step = (TransformationStep)tsteps.get(i)).getActivities()) == null || activites.size() <= 0) continue;
                TransformationActivity activity = (TransformationActivity)activites.get(0);
                JFJob currentFlow = null;
                AssociationList transformations = activity.getJobs();
                if (transformations != null && transformations.size() > 0) {
                    currentFlow = (JFJob)transformations.get(0);
                }
                if (currentFlow != null && this.m_flow.getFQID().equalsIgnoreCase(currentFlow.getFQID())) break;
            }
        }
        return step;
    }

    public boolean cleanupJobProperties(List djobIdList) throws RemoteException, MdException {
        if (djobIdList == null) {
            return true;
        }
        AssociationList list = this.m_activity.getSteps();
        for (TransformationStep ts : list) {
            try {
                String id = ((JFJob)ts.getTransformations().get(0)).getId();
                if (!djobIdList.contains(id)) continue;
                DeployedJob.removeCmdLineProperty((Root)ts);
                if (!(this.m_scheduler instanceof LSFScheduler)) continue;
                String details = DeployedJob.getSchedulingDetails(ts);
                String neoDetails = LSFScheduler.cleanSchedulingDetails(details);
                return DeployedJob.setSchedulingDetails(ts, neoDetails);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
        }
        return true;
    }

    public boolean hasCustomCalendars() {
        block16: {
            if (this.m_scheduler != null && this.m_scheduler.getServerComponent().hasCustomCalendarSupport()) {
                List<Object> list = null;
                try {
                    Property property;
                    AssociationList steps = this.m_flow.getSteps();
                    int numSteps = steps.size();
                    for (int i = 0; i < numSteps; ++i) {
                        AssociationList lstTriggeredEvents;
                        TransformationStep ts = (TransformationStep)steps.get(i);
                        if (!(ts instanceof SyncStep)) continue;
                        SyncStep step = (SyncStep)ts;
                        AssociationList lstTriggeringEvents = step.getTriggeringEvents();
                        if (null != lstTriggeringEvents && 0 != lstTriggeringEvents.size()) {
                            for (Event event : lstTriggeringEvents) {
                                property = null;
                                if (event != null) {
                                    property = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                                }
                                if (property == null) continue;
                                return true;
                            }
                        }
                        if (null == (lstTriggeredEvents = step.getTriggeredEvents()) || 0 == lstTriggeredEvents.size()) continue;
                        for (Event event : lstTriggeredEvents) {
                            Property property2 = null;
                            if (event != null) {
                                property2 = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                            }
                            if (property2 == null) continue;
                            return true;
                        }
                    }
                    list = this.getJobs();
                    for (Object o : list) {
                        DeployedFlow subflow;
                        if (o instanceof DeployedJob) {
                            DeployedJob djob = (DeployedJob)o;
                            for (EventListItem entry : this.getTimeEvents(djob, false)) {
                                Event event;
                                event = entry.getEvent();
                                property = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                                if (property == null) continue;
                                return true;
                            }
                            continue;
                        }
                        if (!(o instanceof DeployedFlow) || !(subflow = (DeployedFlow)o).createCustomCalendars()) continue;
                        return true;
                    }
                }
                catch (MdException mde) {
                    if (MetaUtilities.isDebug()) {
                        mde.printStackTrace();
                    }
                }
                catch (RemoteException e) {
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    if (!MetaUtilities.isDebug()) break block16;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public boolean createCustomCalendars() {
        boolean rc = true;
        List<Object> list = null;
        try {
            Property prop;
            Property property;
            AssociationList steps = this.m_flow.getSteps();
            int numSteps = steps.size();
            for (int i = 0; i < numSteps; ++i) {
                AssociationList lstTriggeredEvents;
                TransformationStep ts = (TransformationStep)steps.get(i);
                if (!(ts instanceof SyncStep)) continue;
                SyncStep step = (SyncStep)ts;
                AssociationList lstTriggeringEvents = step.getTriggeringEvents();
                if (null != lstTriggeringEvents && 0 != lstTriggeringEvents.size()) {
                    for (Event event : lstTriggeringEvents) {
                        property = null;
                        if (event != null) {
                            property = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                        }
                        if (property == null) continue;
                        try {
                            String value = property.getDefaultValue();
                            if (value.indexOf("schedule") >= 0) {
                                try {
                                    IRecurrenceInfo recurrenceInfo = RecurrenceBaseClass.createFromXML((String)value);
                                    if (this.m_scheduler.createCalendar(recurrenceInfo) != null) continue;
                                    rc = false;
                                }
                                catch (Exception e) {
                                    if (this.m_scheduler.createCalendar(property.getDesc(), value) != null) continue;
                                    rc = false;
                                }
                                continue;
                            }
                            if (this.m_scheduler.createCalendar(property.getDesc(), value) != null) continue;
                            rc = false;
                        }
                        catch (SchedulerException se) {
                            prop = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                            if (prop != null) {
                                String expression = prop.getDefaultValue();
                                if (this.m_scheduler.createCalendar(property.getDefaultValue(), expression) != null) continue;
                                rc = false;
                                continue;
                            }
                            rc = false;
                        }
                        catch (Exception ex) {
                            if (MetaUtilities.isDebug()) {
                                ex.printStackTrace();
                            }
                            rc = false;
                        }
                    }
                }
                if (null == (lstTriggeredEvents = step.getTriggeredEvents()) || 0 == lstTriggeredEvents.size()) continue;
                for (Event event : lstTriggeredEvents) {
                    Property property2 = null;
                    if (event != null) {
                        property2 = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                    }
                    if (property2 == null) continue;
                    try {
                        String value = property2.getDefaultValue();
                        if (value.indexOf("schedule") >= 0) {
                            try {
                                IRecurrenceInfo recurrenceInfo = RecurrenceBaseClass.createFromXML((String)value);
                                if (this.m_scheduler.createCalendar(recurrenceInfo) != null) continue;
                                rc = false;
                            }
                            catch (Exception e) {
                                if (this.m_scheduler.createCalendar(property2.getDesc(), value) != null) continue;
                                rc = false;
                            }
                            continue;
                        }
                        if (this.m_scheduler.createCalendar(property2.getDesc(), value) != null) continue;
                        rc = false;
                    }
                    catch (SchedulerException se) {
                        Property prop2 = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                        if (prop2 != null) {
                            String expression;
                            String calname = prop2.getDesc();
                            if (this.m_scheduler.createCalendar(calname, expression = prop2.getDefaultValue()) != null) continue;
                            rc = false;
                            continue;
                        }
                        rc = false;
                    }
                    catch (Exception ex) {
                        if (MetaUtilities.isDebug()) {
                            ex.printStackTrace();
                        }
                        rc = false;
                    }
                }
            }
            list = this.getJobs();
            for (Object o : list) {
                DeployedFlow subflow;
                if (o instanceof DeployedJob) {
                    DeployedJob djob = (DeployedJob)o;
                    for (EventListItem entry : this.getTimeEvents(djob, false)) {
                        Event event;
                        event = entry.getEvent();
                        property = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionName);
                        if (property == null) continue;
                        try {
                            if (this.m_scheduler.createCalendar(property.getDesc(), property.getDefaultValue()) != null) continue;
                            rc = false;
                        }
                        catch (SchedulerException se) {
                            prop = MetaUtilities.getPropertyObject((Root)event, PropertyTimeEventCalDefinitionExpression);
                            if (prop != null) {
                                String expression;
                                String calname = prop.getDesc();
                                if (this.m_scheduler.createCalendar(calname, expression = prop.getDefaultValue()) != null) continue;
                                rc = false;
                                continue;
                            }
                            rc = false;
                        }
                        catch (Exception ex) {
                            if (MetaUtilities.isDebug()) {
                                ex.printStackTrace();
                            }
                            rc = false;
                        }
                    }
                    continue;
                }
                if (!(o instanceof DeployedFlow) || (subflow = (DeployedFlow)o).createCustomCalendars()) continue;
                rc = false;
            }
        }
        catch (MdException mde) {
            if (MetaUtilities.isDebug()) {
                mde.printStackTrace();
            }
            return false;
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (Exception e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        return rc;
    }

    private SyncStep getJobGrouping(TransformationStep jobTS) throws MdException, RemoteException {
        AssociationList list = this.m_activity.getSteps();
        for (TransformationStep ts : list) {
            if (!(ts instanceof SyncStep) || !ts.getTransformRole().equalsIgnoreCase(StrGroupAnd) && !ts.getTransformRole().equalsIgnoreCase(StrGroupOr)) continue;
            AssociationList listofSPs = ts.getSuccessorDependencies();
            for (StepPrecedence sp : listofSPs) {
                if (!sp.getPredecessors().contains((Object)jobTS)) continue;
                return (SyncStep)ts;
            }
        }
        return null;
    }

    public TransformationStep getLogicalJob(TransformationActivity flowTA) throws MdException, RemoteException {
        AssociationList list = this.m_flow.getSteps();
        for (TransformationStep ts : list) {
            TransformationActivity ta;
            AssociationList activities;
            if (ts instanceof SyncStep || (activities = ts.getActivities()).size() <= 0 || (ta = (TransformationActivity)activities.get(0)) == null || !flowTA.getFQID().equalsIgnoreCase(ta.getFQID())) continue;
            return ts;
        }
        return null;
    }

    public TransformationStep getLogicalJob(TransformationActivity flowTA, boolean readFromServer) throws MdException, RemoteException {
        AssociationList list = this.m_flow.getSteps(readFromServer);
        for (TransformationStep ts : list) {
            TransformationActivity ta;
            AssociationList activities;
            if (ts instanceof SyncStep || (activities = ts.getActivities(readFromServer)).size() <= 0 || (ta = (TransformationActivity)activities.get(0)) == null || !flowTA.getFQID().equalsIgnoreCase(ta.getFQID())) continue;
            return ts;
        }
        return null;
    }

    private String createTypeName(int type) {
        String strCondition = null;
        switch (type) {
            case 0: 
            case 10: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_CompletesSuccessfully.txt");
                break;
            }
            case 1: 
            case 11: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_EndsWithAnyExitCode.txt");
                break;
            }
            case 3: 
            case 13: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_EndsExitCode.txt");
                break;
            }
            case 2: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_Starts.txt");
                break;
            }
            case 6: 
            case 16: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_MissesScheduledTime.txt");
                break;
            }
            case 7: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_FailsToStart.txt");
                break;
            }
            case 8: 
            case 18: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_CannotRun.txt");
                break;
            }
            case 4: 
            case 14: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_RunsMoreThan.txt");
                break;
            }
            case 5: 
            case 15: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_RunsLessThan.txt");
                break;
            }
            case 21: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_ExitCodeCompare_Equal.txt");
                break;
            }
            case 22: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_ExitCodeCompare_NotEqual.txt");
                break;
            }
            case 23: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_ExitCodeCompare_GreaterThan.txt");
                break;
            }
            case 24: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_ExitCodeCompare_GreaterThanEqual.txt");
                break;
            }
            case 25: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_ExitCodeCompare_LessThan.txt");
                break;
            }
            case 26: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOB_ExitCodeCompare_LessThanEqual.txt");
                break;
            }
            case 31: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOBGRP_AND.txt");
                break;
            }
            case 32: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.JOBGRP_OR.txt");
                break;
            }
            case 40: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.TimeEvent.txt");
                break;
            }
            case 41: {
                strCondition = m_bundle.getString("MetaUtilities.SPName.FileEvent.txt");
            }
        }
        return strCondition;
    }

    private String getOperatorString(int type) {
        String strSymbol = null;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                strSymbol = "";
                break;
            }
            case 21: {
                strSymbol = FlowInfo.ArithmeticOperator_Equal_Symbol;
                break;
            }
            case 22: {
                strSymbol = FlowInfo.ArithmeticOperator_NotEqual_Symbol;
                break;
            }
            case 23: {
                strSymbol = FlowInfo.ArithmeticOperator_GreaterThan_Symbol;
                break;
            }
            case 24: {
                strSymbol = FlowInfo.ArithmeticOperator_GreaterThanEqual_Symbol;
                break;
            }
            case 25: {
                strSymbol = FlowInfo.ArithmeticOperator_LessThan_Symbol;
                break;
            }
            case 26: {
                strSymbol = FlowInfo.ArithmeticOperator_LessThanEqual_Symbol;
            }
        }
        return strSymbol;
    }

    public boolean validateData() throws RemoteException {
        return this.m_scheduler != null;
    }

    private int validateName(String name) throws MdException, RemoteException {
        if (name.length() == 0) {
            return 1;
        }
        int namelen = name.length();
        for (int i = 0; i < namelen; ++i) {
            if (MetaUtilities.INVALIDFLOWNAMECHARACTERS.indexOf(name.substring(i, i + 1)) == -1) continue;
            return 2;
        }
        MdObjectStore tempStore = null;
        String repos = "A0000001." + this.m_repos;
        int valid = 0;
        try {
            tempStore = this.m_factory.createObjectStore(null, "tempStore");
            if (MetaUtilities.doesFlowExist(name, (MdStore)tempStore, repos)) {
                valid = 3;
            }
        }
        catch (MdException mde) {
            throw mde;
        }
        finally {
            if (tempStore != null) {
                tempStore.dispose();
                tempStore = null;
            }
        }
        return valid;
    }

    public void setDirty() {
        this.m_dirty = true;
    }

    private void resetDirty(int flag) {
        this.m_dirty = false;
        switch (flag) {
            case 2: {
                break;
            }
            case 1: {
                this.m_data = null;
            }
        }
    }

    private void initializeFromJFJob(JFJob flow, Scheduler scheduler) throws RemoteException, MdException, InvalidParameterException {
        this.m_flow = flow;
        try {
            this.m_activity = (TransformationActivity)flow.getJobActivities().get(0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            if (this.m_flow.getTransformRole().compareTo("SCHEDULER_FLOW") == 0) {
                this.m_activity = (TransformationActivity)this.m_factory.createComplexMetadataObject(this.m_store, null, this.m_flow.getName(), "TransformationActivity", this.m_repos, null);
                this.m_flow.getJobActivities().add((Object)this.m_activity);
            }
            throw new InvalidParameterException(m_bundle.getString("DeployedFlow.InvalidMetadataTransformRole.txt"));
        }
        try {
            if (scheduler != null) {
                this.m_scheduler = scheduler;
            } else {
                ServerComponent scomponent = (ServerComponent)flow.getComputeLocations().get(0);
                this.m_scheduler = MetaUtilities.getSchedulingServer(scomponent);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.m_scheduler = null;
            this.m_errorFlag |= 1;
        }
        ArrayList<TransformationStep> deletelist = new ArrayList<TransformationStep>();
        TriggerEvent te = this.getTriggerEvent();
        for (TransformationStep step : this.m_activity.getSteps()) {
            if (step instanceof SyncStep) {
                if (step.getSuccessorDependencies().size() != 0 || step.getPredecessorDependencies().size() != 0) continue;
                try {
                    Event event = (Event)step.getTriggeringEvents().get(0);
                    int numProperties = event.getProperties().size();
                    if (numProperties != 0) continue;
                    deletelist.add(step);
                }
                catch (RuntimeException e) {
                    deletelist.add(step);
                }
                continue;
            }
            String reposID = "A0000001." + this.m_repos;
            JFJob jfjob = this.getJFJobFromStep(step, this.m_store, reposID);
            try {
                DeployedJob djob;
                if (jfjob == null) continue;
                step.setName(JobEvent.getName(jfjob));
                if (step.getTransformRole().equalsIgnoreCase(RoleJob)) {
                    djob = new DeployedJob(jfjob);
                    if (djob.hasErrors()) {
                        this.m_errorFlag |= 0x10;
                        this.m_JobsInError.add(djob);
                    }
                    this.m_jobs.add(djob);
                    continue;
                }
                if (step.getTransformRole().equalsIgnoreCase(RoleFlow)) {
                    DeployedFlow sflow = new DeployedFlow(jfjob, this.m_store);
                    if (sflow.hasErrors()) {
                        this.m_errorFlag |= 0x10;
                        this.m_JobsInError.add(sflow);
                    }
                    this.m_jobs.add(sflow);
                    continue;
                }
                djob = new DeployedJob(jfjob);
                if (djob.hasErrors()) {
                    this.m_errorFlag |= 0x10;
                    this.m_JobsInError.add(djob);
                }
                this.m_jobs.add(djob);
            }
            catch (InvalidParameterException ex) {
                if (jfjob != null && jfjob.getTransformRole().compareTo("SCHEDULER_FLOW") != 0) {
                    this.m_errorFlag |= 0x10;
                }
                if (!MetaUtilities.isDebug()) continue;
                if (jfjob != null) {
                    System.out.println("Ignoring " + jfjob.getName());
                }
                ex.printStackTrace();
            }
        }
        if (deletelist.size() > 0) {
            this.m_factory.deleteMetadataObjects(deletelist);
        }
    }

    private JFJob getJFJobFromStep(TransformationStep step, MdObjectStore store, String repos) {
        JFJob jfjob;
        block20: {
            jfjob = null;
            try {
                if (step.getTransformations().isEmpty()) {
                    if (MetaUtilities.isDebug()) {
                        System.out.println("INTERNAL METADATA ERROR: Missing TS-->JFJob. Attempting to repair for " + step.getName());
                    }
                    if (step.getTransformRole().compareTo(RoleFlow) == 0) {
                        List<JFJob> slist = MetaUtilities.getJFJobList(step.getName(), true, (MdStore)store, repos);
                        if (slist.size() == 1) {
                            jfjob = slist.get(0);
                            jfjob.getSteps().add((Object)step);
                            jfjob.updateMetadataAll();
                        } else if (MetaUtilities.isDebug()) {
                            System.out.println("INTERNAL METADATA ERROR: Ignoring subflow: " + step.getName());
                            RuntimeException rte = new RuntimeException();
                            rte.printStackTrace();
                        }
                    } else if (step.getTransformRole().compareTo(RoleJob) == 0) {
                        List<JFJob> jlist = MetaUtilities.getJFJobList(step.getName(), false, (MdStore)this.m_store, repos);
                        if (jlist.size() == 1) {
                            jfjob = jlist.get(0);
                            jfjob.getSteps().add((Object)step);
                            jfjob.updateMetadataAll();
                        } else if (MetaUtilities.isDebug()) {
                            System.out.println("INTERNAL METADATA ERROR: Ignoring deployed job: " + step.getName());
                            RuntimeException rte = new RuntimeException();
                            rte.printStackTrace();
                        }
                    } else {
                        List<JFJob> jlist = MetaUtilities.getJFJobList(step.getName(), false, (MdStore)store, repos);
                        if (jlist.size() == 1) {
                            jfjob = jlist.get(0);
                            jfjob.getSteps().add((Object)step);
                            jfjob.updateMetadataAll();
                        } else if (MetaUtilities.isDebug()) {
                            System.out.println("INTERNAL METADATA ERROR: Ignoring deployed job: " + step.getName());
                            RuntimeException rte = new RuntimeException();
                            rte.printStackTrace();
                        }
                    }
                } else {
                    jfjob = (JFJob)step.getTransformations().get(0);
                }
            }
            catch (RemoteException re) {
                jfjob = null;
            }
            catch (MdException re) {
                jfjob = null;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (!MetaUtilities.isDebug()) break block20;
                ex.printStackTrace();
            }
        }
        return jfjob;
    }

    private void initialize(String name, MdObjectStore store, String repos) throws RemoteException, MdException {
        if (store != null) {
            this.m_factory = store.getFactory();
            this.m_store = store;
        } else {
            this.m_factory = MetaUtilities.getMdFactory(false);
            this.m_store = this.m_factory.createObjectStore(null, "DeployedFlow_" + name);
        }
        if (repos == null) {
            throw new InvalidParameterException(m_bundle.getString("DeployedFlow.InvalidParam.RepositoryID.txt"));
        }
        this.m_repos = repos;
    }
}

