/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.build;

import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.FileEvent;
import com.sas.scheduler.api.oma.GroupingEvent;
import com.sas.scheduler.api.oma.JobEvent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Vector;

public class ImportFlowFromFile {
    private ImportFlowFromFile() {
    }

    public static FlowInfo processFlow(String flowName, ITextStream file, Vector<?> vars, int maxPredecessors, MdObjectStore store, String repos) throws InvalidParameterException, GenericError, SchedulerException, RemoteException {
        int x;
        String preds;
        int predIndex = -1;
        int idIndex = -1;
        int nameIndex = -1;
        int typeIndex = -1;
        int eventIndex = -1;
        int locIndex = -1;
        int runasIndex = -1;
        int descIndex = -1;
        int numVars = vars.size();
        for (int i = 0; i < numVars; ++i) {
            String var = (String)vars.get(i);
            if (var.equalsIgnoreCase(FlowInfo.TableHeader_Predecessors)) {
                predIndex = i;
                continue;
            }
            if (var.equalsIgnoreCase(FlowInfo.TableHeader_ID)) {
                idIndex = i;
                continue;
            }
            if (var.equalsIgnoreCase(FlowInfo.TableHeader_Name)) {
                nameIndex = i;
                continue;
            }
            if (var.equalsIgnoreCase(FlowInfo.TableHeader_Type)) {
                typeIndex = i;
                continue;
            }
            if (var.equalsIgnoreCase(FlowInfo.TableHeader_Event)) {
                eventIndex = i;
                continue;
            }
            if (var.equalsIgnoreCase(FlowInfo.TableHeader_Location)) {
                locIndex = i;
                continue;
            }
            if (var.equalsIgnoreCase(FlowInfo.TableHeader_RunAs)) {
                runasIndex = i;
                continue;
            }
            if (!var.equalsIgnoreCase(FlowInfo.TableHeader_Description)) continue;
            descIndex = i;
        }
        SchedulerServerInfo sinfo = null;
        FlowInfo flow = new FlowInfo(flowName, null, sinfo);
        HashMap<String, Object> events = new HashMap<String, Object>();
        HashMap<String, String> predList = new HashMap<String, String>();
        HashMap<String, JobInfo> jobs = new HashMap<String, JobInfo>();
        HashMap<String, JobEvent> jobevents = new HashMap<String, JobEvent>();
        Vector<TriggerEventInfo> triggers = new Vector<TriggerEventInfo>();
        Scheduler scheduler = null;
        LongSeqHolder truncatedLines = new LongSeqHolder();
        StringSeqHolder textLines = new StringSeqHolder();
        boolean done = false;
        while (!done) {
            file.ReadLines(1024, truncatedLines, textLines);
            String[] lines = textLines.value;
            if (lines.length < 1024) {
                done = true;
            }
            if (truncatedLines.value.length > 0) {
                store.getFactory().getUtil().printOutputln("Truncated lines: " + truncatedLines.value);
            }
            for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
                String line = lines[lineNum];
                String[] tokens = line.split(",", vars.size());
                preds = "";
                String id = "";
                String name = "";
                String type = "";
                String event = "";
                String loc = "";
                String runas = "";
                String desc = "";
                try {
                    preds = tokens[predIndex];
                    id = tokens[idIndex];
                    name = tokens[nameIndex];
                    type = tokens[typeIndex];
                    event = tokens[eventIndex];
                    loc = tokens[locIndex];
                    runas = tokens[runasIndex];
                    desc = tokens[descIndex];
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    store.getFactory().getUtil().printOutputln("WARNING: invalid line is ignored: " + line);
                    continue;
                }
                store.getFactory().getUtil().printOutputln(line);
                if (type.compareTo("TopFlow") == 0) {
                    flow.setName(name);
                    flow.setId(id);
                    flow.setDescription(desc);
                    flow.setLocation(loc);
                    continue;
                }
                if (type.compareTo("Scheduler") == 0) {
                    String classId = event;
                    sinfo = new SchedulerServerInfo(name, classId);
                    if (id != null && id.length() > 0) {
                        sinfo.setId(id);
                    }
                    flow.setScheduler(sinfo);
                    scheduler = MetaUtilities.getSchedulingServer(sinfo, store);
                    continue;
                }
                if (type.compareTo("TriggerEvent") == 0) {
                    TriggerEventInfo trei = null;
                    String eventType = name;
                    if (name.compareTo("Flow Trigger") == 0) {
                        eventType = runas;
                    }
                    if (eventType.compareTo("TimeEvent") == 0) {
                        TimeEvent te = new TimeEvent();
                        if (!(desc != null && te.initFromDefinition(scheduler, desc) || te.initFromCondition(scheduler, event))) {
                            store.getFactory().getUtil().printOutputln("Cannot process the trigger event");
                            continue;
                        }
                        trei = new TriggerEventInfo(te.getInfo(), sinfo);
                    } else if (eventType.compareTo("FileEvent") == 0) {
                        FileEvent fe = new FileEvent();
                        if (!(desc != null && fe.initFromDefinition(scheduler, desc) || fe.initFromCondition(scheduler, event))) {
                            store.getFactory().getUtil().printOutputln("Cannot process the trigger event");
                            continue;
                        }
                        trei = new TriggerEventInfo(fe.getInfo(), sinfo);
                    }
                    if (name.compareTo("Flow Trigger") == 0) {
                        flow.setTriggerEvent(trei);
                    }
                    if (desc != null && desc.trim().length() > 0 && trei != null) {
                        trei.setDescription(desc);
                    }
                    triggers.add(trei);
                    continue;
                }
                if (type.compareTo("FLOW") == 0 || type.compareTo("JOB") == 0) {
                    String jobCmd = event;
                    String jobHost = null;
                    predList.put(id, preds);
                    String cmd = jobCmd.substring(0, jobCmd.indexOf(" "));
                    BatchServerInfo binfo = CommandUtilities.findBatchServerFromCommand(cmd, jobHost, (MdStore)store, repos);
                    JobInfo job = new JobInfo(name, id, binfo);
                    job.setLocation(loc);
                    job.setDescription(desc);
                    if (runas != null && runas.trim().length() > 0) {
                        job.setUserId(runas);
                    }
                    if (binfo == null) {
                        job.setCommandLine(jobCmd);
                    } else {
                        String srcfile = CommandUtilities.findSourceFileFromCommand(jobCmd, binfo, jobHost, (MdStore)store, repos);
                        job.setSourceFile(srcfile);
                        DirectoryInfo dinfo = CommandUtilities.findSourceDirectoryFromCommand(jobCmd, binfo, jobHost, (MdStore)store, repos);
                        job.setSourceDir(dinfo);
                    }
                    jobs.put(name, job);
                    continue;
                }
                if (type.compareTo("Gate") == 0) {
                    GroupingEvent ge = new GroupingEvent();
                    ge.initFromDefinition(desc);
                    GroupingEventInfo gei = new GroupingEventInfo(null, ge.getType());
                    for (String token : preds.split(FlowInfo.PredecessorSeparator, maxPredecessors)) {
                        if (token == null || token.length() <= 0) continue;
                        AbstractEventInfo depend = (AbstractEventInfo)events.get(token);
                        if (depend == null) {
                            store.getFactory().getUtil().printOutputln("Grouping Event: cannot process the event: " + token);
                            continue;
                        }
                        gei.addDependency(depend);
                    }
                    events.put(id, gei);
                    continue;
                }
                if (type.compareTo("JobEvent") == 0) {
                    JobEvent je = new JobEvent();
                    if (!je.initFromDefinition(scheduler, desc) && !je.initFromCondition(event, false)) {
                        store.getFactory().getUtil().printOutputln("Cannot process the job event: " + event);
                        continue;
                    }
                    jobevents.put(id, je);
                    JobInfo info = new JobInfo(je.getName(), null, -1);
                    info.setDisplayOnly(true);
                    JobEventInfo jei = je.getInfo(info);
                    events.put(id, jei);
                    continue;
                }
                if (type.compareTo("TimeEvent") == 0) {
                    TimeEvent te = new TimeEvent();
                    if (!(desc != null && te.initFromDefinition(scheduler, desc) || te.initFromCondition(scheduler, event))) {
                        store.getFactory().getUtil().printOutputln("Cannot process the time event: " + desc);
                        continue;
                    }
                    TimeEventInfo tei = te.getInfo();
                    events.put(id, tei);
                    continue;
                }
                if (type.compareTo("FileEvent") != 0) continue;
                FileEvent fe = new FileEvent();
                if (!(desc != null && fe.initFromDefinition(scheduler, desc) || fe.initFromCondition(scheduler, event))) {
                    store.getFactory().getUtil().printOutputln("Cannot process the file event:" + desc);
                    continue;
                }
                FileEventInfo fei = fe.getInfo();
                events.put(id, fei);
            }
        }
        flow.setTriggerEventList(triggers);
        Vector jobList = new Vector(jobs.values());
        flow.setJobs(jobList);
        Vector jobEventKeys = new Vector(jobevents.keySet());
        for (x = 0; x < jobEventKeys.size(); ++x) {
            String id = (String)jobEventKeys.get(x);
            JobEvent je = (JobEvent)jobevents.get(id);
            JobInfo info = (JobInfo)jobs.get(je.getName());
            if (info == null) {
                store.getFactory().getUtil().printOutputln("Cannot process the job event: " + id);
                events.remove(id);
                continue;
            }
            JobEventInfo jei = (JobEventInfo)events.get(id);
            jei.setJobInfo(info);
            jei.setId(info.getId());
        }
        for (x = 0; x < jobList.size(); ++x) {
            JobInfo job = (JobInfo)jobList.get(x);
            preds = (String)predList.get(job.getId());
            if (preds == null || preds.trim().length() <= 0) continue;
            AbstractEventInfo eventObj = (AbstractEventInfo)events.get(preds);
            flow.addEvent((DisplayInfo)job, eventObj);
        }
        return flow;
    }
}

