/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.xpath.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.contrib.dom.DOM;
import org.jdom2.contrib.dom.Wrapper;
import org.jdom2.filter.Filter;
import org.jdom2.internal.ArrayCopy;
import org.jdom2.xpath.util.AbstractXPathCompiled;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaXPathExpression<T>
extends AbstractXPathCompiled<T>
implements XPathVariableResolver,
NamespaceContext {
    private static final Namespace[] EMPTYNS = new Namespace[0];
    final XPathExpression rawexpression;
    final Namespace[] nsraw;

    public JavaXPathExpression(String query, Filter<T> filter, Map<String, Object> variables, Namespace[] namespaces, XPathFactory fac) {
        super(query, filter, variables, namespaces);
        this.nsraw = namespaces == null ? EMPTYNS : (Namespace[])ArrayCopy.copyOf((Object[])namespaces, (int)namespaces.length);
        XPath xp = fac.newXPath();
        xp.setNamespaceContext(this);
        xp.setXPathVariableResolver(this);
        try {
            this.rawexpression = xp.compile(query);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Unable to compile expression: " + query, e);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.getNamespace(prefix).getURI();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Null namespaceURI");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        for (Namespace ns : this.nsraw) {
            if (!namespaceURI.equals(ns.getURI())) continue;
            return ns.getPrefix();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Null namespaceURI");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return Collections.singleton("xml").iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return Collections.singleton("xmlns").iterator();
        }
        ArrayList<String> pfx = new ArrayList<String>();
        for (Namespace ns : this.nsraw) {
            if (!namespaceURI.equals(ns.getURI())) continue;
            pfx.add(ns.getPrefix());
        }
        return Collections.unmodifiableList(pfx).iterator();
    }

    @Override
    public Object resolveVariable(QName variableName) {
        return this.getVariable(variableName.getLocalPart(), Namespace.getNamespace((String)variableName.getNamespaceURI()));
    }

    private Object wrapContext(Object context) {
        if (context instanceof Content) {
            switch (((Content)context).getCType()) {
                case CDATA: {
                    return DOM.wrap((CDATA)context);
                }
                case Comment: {
                    return DOM.wrap((Comment)context);
                }
                case DocType: {
                    return DOM.wrap((DocType)context);
                }
                case Element: {
                    return DOM.wrap((Element)context);
                }
                case EntityRef: {
                    return DOM.wrap((EntityRef)context);
                }
                case ProcessingInstruction: {
                    return DOM.wrap((ProcessingInstruction)context);
                }
                case Text: {
                    return DOM.wrap((Text)context);
                }
            }
            throw new IllegalStateException("Should never break out of switch");
        }
        if (context instanceof Attribute) {
            return DOM.wrap((Attribute)context);
        }
        if (context instanceof Document) {
            return DOM.wrap((Document)context);
        }
        throw new IllegalArgumentException("Unable to process context: " + context);
    }

    private Object unWrap(Object o) {
        if (o instanceof Wrapper) {
            return ((Wrapper)o).getWrapped();
        }
        if (o instanceof Attr) {
            Attr a = (Attr)o;
            if ("http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI())) {
                return Namespace.getNamespace((String)a.getLocalName(), (String)a.getValue());
            }
            if ("".equals(a.getNamespaceURI()) && "xmlns".equals(a.getLocalName())) {
                return Namespace.getNamespace((String)a.getValue());
            }
        }
        return o;
    }

    protected List<?> evaluateRawAll(Object context) {
        Object ctx = this.wrapContext(context);
        try {
            NodeList nl = (NodeList)this.rawexpression.evaluate(ctx, XPathConstants.NODESET);
            int sz = nl.getLength();
            ArrayList<Object> ret = new ArrayList<Object>(sz);
            for (int i = 0; i < sz; ++i) {
                ret.add(this.unWrap(nl.item(i)));
            }
            return ret;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Unable to evaluate expression: " + this.toString(), e);
        }
    }

    protected Object evaluateRawFirst(Object context) {
        Object ctx = this.wrapContext(context);
        try {
            NodeList nl = (NodeList)this.rawexpression.evaluate(ctx, XPathConstants.NODESET);
            if (nl.getLength() == 0) {
                return null;
            }
            return this.unWrap(nl.item(0));
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Unable to evaluate expression: " + this.toString(), e);
        }
    }
}

