/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.xop;

import jakarta.activation.DataHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.xop.AbstractXOPEncodingFilterHandler;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.om.impl.stream.xop.ContentIDGenerator;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicy;
import org.apache.axiom.om.impl.stream.xop.XOPHandler;

public final class XOPEncodingFilterHandler
extends AbstractXOPEncodingFilterHandler
implements XOPHandler,
OMAttachmentAccessor {
    private final Map<String, Object> dataHandlerObjects = new LinkedHashMap<String, Object>();
    private final ContentIDGenerator contentIDGenerator;
    private final OptimizationPolicy optimizationPolicy;

    public XOPEncodingFilterHandler(XmlHandler parent, ContentIDGenerator contentIDGenerator, OptimizationPolicy optimizationPolicy) {
        super(parent);
        this.contentIDGenerator = contentIDGenerator;
        this.optimizationPolicy = optimizationPolicy;
    }

    @Override
    public String prepareDataHandler(DataHandler dataHandler) {
        boolean doOptimize;
        try {
            doOptimize = this.optimizationPolicy.isOptimized(dataHandler, true);
        }
        catch (IOException ex) {
            doOptimize = true;
        }
        if (doOptimize) {
            String contentID = this.contentIDGenerator.generateContentID(null);
            this.dataHandlerObjects.put(contentID, dataHandler);
            return contentID;
        }
        return null;
    }

    public Set<String> getContentIDs() {
        return Collections.unmodifiableSet(this.dataHandlerObjects.keySet());
    }

    public DataHandler getDataHandler(String contentID) {
        Object dataHandlerObject = this.dataHandlerObjects.get(contentID);
        if (dataHandlerObject == null) {
            return null;
        }
        if (dataHandlerObject instanceof DataHandler) {
            return (DataHandler)dataHandlerObject;
        }
        try {
            return ((DataHandlerProvider)dataHandlerObject).getDataHandler();
        }
        catch (IOException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    @Override
    protected String processCharacterData(Object data) throws StreamException {
        TextContent textContent;
        if (data instanceof TextContent && (textContent = (TextContent)data).isBinary()) {
            boolean optimize;
            Object dataHandlerObject = textContent.getDataHandlerObject();
            try {
                optimize = dataHandlerObject instanceof DataHandlerProvider ? this.optimizationPolicy.isOptimized((DataHandlerProvider)dataHandlerObject, textContent.isOptimize()) : this.optimizationPolicy.isOptimized((DataHandler)dataHandlerObject, textContent.isOptimize());
            }
            catch (IOException ex) {
                throw new StreamException(ex);
            }
            if (optimize) {
                String contentID = this.contentIDGenerator.generateContentID(textContent.getContentID());
                this.dataHandlerObjects.put(contentID, dataHandlerObject);
                return contentID;
            }
        }
        return null;
    }
}

