/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;

public class Retry {
    private static final SteadyTimer steadyClock = new SteadyTimer();

    public static <T> T tryFor(long timeout, TimeUnit timeoutUnit, long interval, TimeUnit intervalUnit, Supplier<T> supplier, Predicate<T> predicate) throws TimeoutException, InterruptedException {
        return Retry.tryFor(timeout, timeoutUnit, interval, intervalUnit, supplier, predicate, steadyClock);
    }

    @VisibleForTesting
    static <T> T tryFor(long timeout, TimeUnit timeoutUnit, long interval, TimeUnit intervalUnit, Supplier<T> supplier, Predicate<T> predicate, Timer timer) throws TimeoutException, InterruptedException {
        long until = timer.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, timeoutUnit);
        long intervalNano = TimeUnit.NANOSECONDS.convert(interval, intervalUnit);
        while (true) {
            T value;
            if (predicate.test(value = supplier.get())) {
                return value;
            }
            if (timer.nanoTime() + intervalNano >= until) break;
            timer.sleep(intervalNano);
        }
        throw new TimeoutException();
    }

    static class SteadyTimer
    implements Timer {
        SteadyTimer() {
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }

        @Override
        public void sleep(long sleepTimeInNano) throws InterruptedException {
            long millis = TimeUnit.NANOSECONDS.toMillis(sleepTimeInNano);
            if (millis > 0L) {
                Thread.sleep(millis);
            }
        }
    }

    static interface Timer {
        public long nanoTime();

        public void sleep(long var1) throws InterruptedException;
    }
}

