/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.cache.lucene.internal.filesystem.ChunkKey;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystemStats;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FileSystem {
    private static final Logger logger = LogService.getLogger();
    private final Map fileAndChunkRegion;
    static final int CHUNK_SIZE = 0x100000;
    private final FileSystemStats stats;

    public FileSystem(Map fileAndChunkRegion, FileSystemStats stats) {
        this.fileAndChunkRegion = fileAndChunkRegion;
        this.stats = stats;
    }

    public Collection<String> listFileNames() {
        return this.fileAndChunkRegion.keySet().stream().filter(entry -> entry instanceof String && !((String)entry).equalsIgnoreCase("APACHE_GEODE_INDEX_COMPLETE")).collect(Collectors.toList());
    }

    public File createFile(String name) throws IOException {
        File file = new File(this, name);
        if (null != this.fileAndChunkRegion.putIfAbsent(name, file)) {
            throw new IOException("File exists.");
        }
        this.stats.incFileCreates(1);
        return file;
    }

    public File putIfAbsentFile(String name, File file) throws IOException {
        if (null != this.fileAndChunkRegion.putIfAbsent(name, file)) {
            throw new IOException("File exists.");
        }
        this.stats.incFileCreates(1);
        return file;
    }

    public File createTemporaryFile(String name) throws IOException {
        File file = new File(this, name);
        this.stats.incTemporaryFileCreates(1);
        return file;
    }

    public File getFile(String name) throws FileNotFoundException {
        File file = (File)this.fileAndChunkRegion.get(name);
        if (null == file) {
            throw new FileNotFoundException(name);
        }
        file.setFileSystem(this);
        return file;
    }

    public void deleteFile(String name) throws FileNotFoundException {
        File file = (File)this.fileAndChunkRegion.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        if (!file.possiblyRenamed) {
            ChunkKey key = new ChunkKey(file.id, 0);
            while (null != this.fileAndChunkRegion.remove(key)) {
                ++key.chunkId;
            }
        }
        this.stats.incFileDeletes(1);
    }

    public void renameFile(String source, String dest) throws IOException {
        File sourceFile = (File)this.fileAndChunkRegion.get(source);
        if (null == sourceFile) {
            throw new FileNotFoundException(source);
        }
        File destFile = new File(this, dest);
        destFile.chunks = sourceFile.chunks;
        destFile.created = sourceFile.created;
        destFile.length = sourceFile.length;
        destFile.modified = sourceFile.modified;
        destFile.id = sourceFile.id;
        sourceFile.possiblyRenamed = true;
        this.updateFile(sourceFile);
        this.putIfAbsentFile(dest, destFile);
        this.fileAndChunkRegion.remove(source);
        this.stats.incFileRenames(1);
    }

    byte[] getChunk(File file, int id) {
        ChunkKey key = new ChunkKey(file.id, id);
        if (id >= file.chunks) {
            while (this.fileAndChunkRegion.containsKey(key)) {
                this.fileAndChunkRegion.remove(key);
                ++key.chunkId;
            }
            return null;
        }
        byte[] chunk = (byte[])this.fileAndChunkRegion.get(key);
        if (chunk != null) {
            this.stats.incReadBytes(chunk.length);
        } else {
            logger.debug("Chunk was null for file:" + file.getName() + " file id: " + String.valueOf(key.getFileId()) + " chunkKey:" + key.chunkId);
        }
        return chunk;
    }

    public void putChunk(File file, int id, byte[] chunk) {
        ChunkKey key = new ChunkKey(file.id, id);
        this.fileAndChunkRegion.put(key, chunk);
        this.stats.incWrittenBytes(chunk.length);
    }

    void updateFile(File file) {
        this.fileAndChunkRegion.put(file.getName(), file);
    }

    public Map getFileAndChunkRegion() {
        return this.fileAndChunkRegion;
    }

    public void export(java.io.File exportLocation) {
        this.listFileNames().stream().forEach(fileName -> {
            try {
                this.getFile((String)fileName).export(exportLocation);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        });
    }
}

