/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.repository.serializer.HeterogeneousLuceneSerializer;
import org.apache.geode.internal.VersionedDataSerializable;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneIndexCreationProfile
implements CacheServiceProfile,
VersionedDataSerializable {
    private String indexName;
    private String[] fieldNames;
    private String analyzerClass;
    private Map<String, String> fieldAnalyzers;
    private String serializerClass = HeterogeneousLuceneSerializer.class.getSimpleName();
    private String regionPath;

    public LuceneIndexCreationProfile() {
    }

    public LuceneIndexCreationProfile(String indexName, String regionPath, String[] fieldNames, Analyzer analyzer, Map<String, Analyzer> fieldAnalyzers, LuceneSerializer serializer) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.fieldNames = fieldNames;
        this.analyzerClass = analyzer.getClass().getSimpleName();
        this.initializeFieldAnalyzers(fieldAnalyzers);
        if (serializer != null) {
            this.serializerClass = serializer.getClass().getSimpleName();
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public String getAnalyzerClass() {
        return this.analyzerClass;
    }

    public Map<String, String> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    public String getSerializerClass() {
        return this.serializerClass;
    }

    protected void initializeFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = new HashMap<String, String>();
        for (String field : this.fieldNames) {
            if (fieldAnalyzers != null && !fieldAnalyzers.isEmpty()) {
                this.fieldAnalyzers.put(field, fieldAnalyzers.get(field) == null ? StandardAnalyzer.class.getSimpleName() : fieldAnalyzers.get(field).getClass().getSimpleName());
                continue;
            }
            this.fieldAnalyzers.put(field, StandardAnalyzer.class.getSimpleName());
        }
    }

    public String getId() {
        return LuceneIndexCreationProfile.generateId(this.indexName, this.regionPath);
    }

    public static String generateId(String indexName, String regionPath) {
        return "lucene_" + LuceneServiceImpl.getUniqueIndexName(indexName, regionPath);
    }

    public String checkCompatibility(String regionPath, CacheServiceProfile profile) {
        String result = null;
        LuceneIndexCreationProfile remoteProfile = (LuceneIndexCreationProfile)profile;
        if (this.getFieldNames().length != remoteProfile.getFieldNames().length || !Arrays.asList(this.getFieldNames()).containsAll(Arrays.asList(remoteProfile.getFieldNames()))) {
            return String.format("Cannot create Lucene index %s on region %s with fields %s because another member defines the same index with fields %s.", this.getIndexName(), regionPath, Arrays.toString(this.getFieldNames()), Arrays.toString(remoteProfile.getFieldNames()));
        }
        if (!this.getFieldAnalyzers().equals(remoteProfile.getFieldAnalyzers())) {
            if (this.getFieldAnalyzers().size() != remoteProfile.getFieldAnalyzers().size()) {
                return String.format("Cannot create Lucene index %s on region %s with field analyzers %s because another member defines the same index with field analyzers %s.", this.getIndexName(), regionPath, Arrays.toString(this.getFieldAnalyzers().values().toArray()), Arrays.toString(remoteProfile.getFieldAnalyzers().values().toArray()));
            }
            for (String field : this.getFieldAnalyzers().keySet()) {
                if (remoteProfile.getFieldAnalyzers().get(field).equals(this.getFieldAnalyzers().get(field))) continue;
                return String.format("Cannot create Lucene index %s on region %s with analyzer %s on field %s because another member defines the same index with analyzer %s on that field.", this.getIndexName(), regionPath, this.getFieldAnalyzers().get(field), field, remoteProfile.getFieldAnalyzers().get(field));
            }
        }
        if (!this.getSerializerClass().equals(remoteProfile.getSerializerClass())) {
            return String.format("Cannot create Lucene index %s on region %s with serializer %s because another member defines the same index with different serializer %s.", this.getIndexName(), regionPath, this.getSerializerClass(), remoteProfile.getSerializerClass());
        }
        return result;
    }

    public String getMissingProfileMessage(boolean existsInThisMember) {
        return existsInThisMember ? String.format("Cannot create Lucene index %s on region %s because it is not defined in another member.", this.getIndexName(), this.regionPath) : String.format("Must create Lucene index %s on region %s because it is defined in another member.", this.getIndexName(), this.regionPath);
    }

    public void toData(DataOutput out) throws IOException {
        this.toDataPre_GEODE_1_4_0_0(out);
        DataSerializer.writeString((String)this.serializerClass, (DataOutput)out);
    }

    public void toDataPre_GEODE_1_4_0_0(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.indexName, (DataOutput)out);
        DataSerializer.writeString((String)this.regionPath, (DataOutput)out);
        DataSerializer.writeStringArray((String[])this.fieldNames, (DataOutput)out);
        DataSerializer.writeString((String)this.analyzerClass, (DataOutput)out);
        DataSerializer.writeHashMap(this.fieldAnalyzers, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataPre_GEODE_1_4_0_0(in);
        this.serializerClass = DataSerializer.readString((DataInput)in);
    }

    public void fromDataPre_GEODE_1_4_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.indexName = DataSerializer.readString((DataInput)in);
        this.regionPath = DataSerializer.readString((DataInput)in);
        this.fieldNames = DataSerializer.readStringArray((DataInput)in);
        this.analyzerClass = DataSerializer.readString((DataInput)in);
        this.fieldAnalyzers = DataSerializer.readHashMap((DataInput)in);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[indexName=" + this.indexName + "; regionPath=" + this.regionPath + "; fieldNames=" + Arrays.toString(this.fieldNames) + "; analyzerClass=" + this.analyzerClass + "; fieldAnalyzers=" + String.valueOf(this.fieldAnalyzers) + "; serializer=" + this.serializerClass + "]";
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public KnownVersion[] getSerializationVersions() {
        return new KnownVersion[]{KnownVersion.GEODE_1_4_0};
    }
}

