/*
 * Decompiled with CFR 0.152.
 */
package com.sas.filter.model;

import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterUtil;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterSelector {
    private static final ResourceBundle m_bundle = FilterUtil.getMyResourceBundle(FilterSelector.class);
    private static final String FilterTagStart = "FilterV1:";
    private static final String FilterTagEnd = "||";
    private String m_name;
    private String m_desc = "";
    private ArrayList m_rules = new ArrayList();

    public FilterSelector(String name) {
        this.m_name = name;
    }

    public FilterSelector(String name, String description) {
        this.m_name = name;
        this.m_desc = description;
    }

    public FilterSelector(String name, FilterRule rule) {
        this.m_name = name;
        this.m_rules.add(rule);
    }

    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public boolean setDescription(String description) {
        this.m_desc = description;
        return true;
    }

    public boolean addRule(FilterRule rule) {
        return this.m_rules.add(rule);
    }

    public boolean removeRule(FilterRule rule) {
        return this.m_rules.remove(rule);
    }

    public int getRuleCount() {
        return this.m_rules.size();
    }

    public FilterRule getRule(int subscript) {
        return (FilterRule)this.m_rules.get(subscript);
    }

    public String toString() {
        return this.m_name;
    }

    public boolean isSimpleNameFilter() {
        String nameCol = m_bundle.getString("FilterSelector.ColumnHeader.Name.txt");
        return this.m_rules.size() == 1 && ((FilterRule)this.m_rules.get(0)).getColumnName().equalsIgnoreCase(nameCol);
    }

    public String generateDefinition() {
        StringBuffer filterXML = new StringBuffer();
        filterXML.append(FilterTagStart);
        filterXML.append("<Filter Name=\"" + this.m_name + "\" Description=\"" + this.m_desc + "\">");
        for (FilterRule rule : this.m_rules) {
            filterXML.append(rule.generateXML());
        }
        filterXML.append("</Filter>");
        filterXML.append(FilterTagEnd);
        return filterXML.toString();
    }

    public boolean initFromDefinition(String content, boolean keepName) {
        if (content == null) {
            return false;
        }
        boolean isRule = content.startsWith(FilterTagStart);
        if (!isRule) {
            return false;
        }
        this.m_rules.clear();
        String xml = this.getFilterString(content);
        try {
            Node node1;
            Document doc = FilterUtil.parseXML(xml);
            NodeList nodes = doc.getElementsByTagName("Filter");
            Node node = nodes.item(0);
            NamedNodeMap map = node.getAttributes();
            if (!keepName && (node1 = map.getNamedItem("Name")) != null) {
                this.m_name = node1.getNodeValue();
            }
            if ((node1 = map.getNamedItem("T")) != null) {
                this.m_desc = node1.getNodeValue();
            }
            nodes = node.getChildNodes();
            int numNodes = nodes.getLength();
            for (int x = 0; x < numNodes; ++x) {
                Node cnode = nodes.item(x);
                FilterRule rule = new FilterRule();
                rule.initFromNode(cnode);
                this.addRule(rule);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private String getFilterString(String definition) {
        int start = definition.indexOf(FilterTagStart, 0);
        if (start < 0) {
            return null;
        }
        int end = definition.indexOf(FilterTagEnd, start);
        if (end < 0) {
            return null;
        }
        String result = definition.substring(start + FilterTagStart.length(), end).trim();
        return result;
    }
}

