/*
 * Decompiled with CFR 0.152.
 */
package com.sas.grid.representations.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateDeserializer
extends JsonDeserializer<Date> {
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String text = jp.getText();
        if (text == null || text.isEmpty()) {
            return null;
        }
        try {
            dateTimeFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateTimeFormatter.parse(text);
        }
        catch (ParseException ex) {
            try {
                dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                return dateFormatter.parse(text);
            }
            catch (ParseException parseException) {
                throw new JsonParseException("Error parsing date '" + text + "'", null, (Throwable)ex);
            }
        }
    }
}

