/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno.ui;

import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.NumberRangeListener;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.SGDecimalFormat;
import com.sas.graphics.sg.util.Util;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AreaElement;
import com.sas.graphics.sganno.LineElement;
import com.sas.graphics.sganno.ui.RB;
import com.sas.graphics.sganno.ui.TitlePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class PositionCustomizerPanel
extends JPanel
implements ActionListener,
ChangeListener {
    public static final String RB_KEY = "PositionCustomizerPanel.";
    AnnotateElement annotate;
    JSpinner rotationspinner;
    JSpinner horzspinner;
    JSpinner vertspinner;
    boolean isScreenSpace;
    double validXMin;
    double validXMax;
    double validYMin;
    double validYMax;
    private JComboBox pointBox;
    private JCheckBox crop;
    private JCheckBox attach;
    private static final int dlu4 = UIUtil.DLU * 4;
    private static final int dlu7 = UIUtil.DLU * 7;
    private static final Border empty = BorderFactory.createEmptyBorder(dlu7, dlu7, dlu7, dlu7);
    private static final Border left = BorderFactory.createEmptyBorder(0, dlu4, 0, dlu4);
    private JPanel pointPositionPanel;

    public PositionCustomizerPanel(AnnotateElement annotate) {
        this.annotate = annotate;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel posPanel = this.annotate instanceof AreaElement ? this.createAreaPositionPanel((AreaElement)this.annotate) : this.createLinePositionPanel((LineElement)this.annotate);
        this.add(posPanel);
        posPanel.setMaximumSize(new Dimension(1000, posPanel.getPreferredSize().height));
        this.add(Box.createVerticalGlue());
    }

    private JPanel createAreaPositionPanel(AreaElement ae) {
        JPanel posPanel = new JPanel();
        posPanel.setLayout(new BoxLayout(posPanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.attach = new JCheckBox(RB.getStringResource(RB_KEY, "attachToData.txt"));
        this.attach.addActionListener(this);
        this.attach.setEnabled(ae.canAnchorAttachedToData());
        boolean isAttach = ae.isAnchorAttachedToData();
        this.attach.setSelected(isAttach);
        this.attach.setActionCommand("attach");
        panel.add(this.attach);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        posPanel.add(Box.createRigidArea(new Dimension(0, dlu4)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(dlu7, 0)));
        this.crop = new JCheckBox(RB.getStringResource(RB_KEY, "crop.txt"));
        this.crop.addActionListener(this);
        boolean iscrop = ae.isClipOutsideDataOn();
        this.crop.setSelected(iscrop);
        this.crop.setEnabled(isAttach);
        this.crop.setActionCommand("crop");
        panel.add(this.crop);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        posPanel.add(Box.createRigidArea(new Dimension(0, dlu4)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(left);
        JLabel label = new JLabel(RB.getStringResource(RB_KEY, "rotation.txt"));
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        int value = (int)Math.round(ae.getRotationAngle());
        SpinnerNumberModel model = new SpinnerNumberModel(value, 0, 359, 10);
        this.rotationspinner = new JSpinner(model);
        NumberRangeListener.addRangeListener(this.rotationspinner, 0.0, 360.0);
        JFormattedTextField textField = ((JSpinner.DefaultEditor)this.rotationspinner.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        this.rotationspinner.addChangeListener(this);
        this.rotationspinner.setMaximumSize(this.rotationspinner.getPreferredSize());
        Dimension ps = label.getPreferredSize();
        label.setMaximumSize(ps);
        Dimension wps = this.rotationspinner.getPreferredSize();
        wps.setSize(wps.width, (int)(1.5 * (double)wps.height));
        this.rotationspinner.setPreferredSize(wps);
        this.rotationspinner.setMaximumSize(wps);
        panel.add(this.rotationspinner);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        posPanel.add(Box.createVerticalGlue());
        posPanel.setBorder(empty);
        return posPanel;
    }

    private JPanel createLinePositionPanel(LineElement le) {
        JPanel posPanel = new JPanel();
        posPanel.setLayout(new BoxLayout(posPanel, 1));
        posPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(7 * UIUtil.DLU, 0)));
        this.crop = new JCheckBox(RB.getStringResource(RB_KEY, "crop.txt"));
        this.crop.addActionListener(this);
        this.crop.setActionCommand("crop");
        panel.add(this.crop);
        panel.add(Box.createHorizontalGlue());
        boolean iscrop = le.isClipOutsideDataOn();
        this.crop.setSelected(iscrop);
        this.crop.setEnabled(le.isAnchorAttachedToData() && le.isSecondaryAttachedToData());
        this.crop.setActionCommand("crop");
        posPanel.add(panel);
        JPanel pointPanel = new JPanel();
        pointPanel.setBorder(empty);
        pointPanel.setLayout(new BoxLayout(pointPanel, 1));
        JPanel attachPanel = this._createAttachPanel(le);
        pointPanel.add(attachPanel);
        pointPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        JPanel pointPos = this._createPointPosition(le);
        pointPanel.add(pointPos);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        JLabel label = new JLabel(RB.getStringResource(RB_KEY, "linePoint.txt"));
        titlePanel.add(label);
        titlePanel.add(Box.createRigidArea(new Dimension(dlu7, 0)));
        this.pointBox = new JComboBox<String>(new String[]{RB.getStringResource("start.txt"), RB.getStringResource("end.txt")});
        Dimension ps = this.pointBox.getPreferredSize();
        ps.width += UIUtil.DLU * 6;
        this.pointBox.setPreferredSize(ps);
        this.pointBox.addActionListener(this);
        this.pointBox.setActionCommand("point");
        titlePanel.add(this.pointBox);
        titlePanel.setBorder(left);
        CompoundBorder outside = BorderFactory.createCompoundBorder(empty, new LineBorder(Color.GRAY));
        CompTitledBorder pointBorder = new CompTitledBorder((Border)outside, titlePanel);
        panel = new TitlePanel(pointPanel, titlePanel, pointBorder);
        ps = panel.getPreferredSize();
        Dimension ps2 = this.pointPositionPanel.getPreferredSize();
        ps = new Dimension(ps2.width + 14 * UIUtil.DLU, ps.height);
        panel.setPreferredSize(ps);
        posPanel.add(Box.createRigidArea(new Dimension(0, dlu4)));
        posPanel.add(panel);
        return posPanel;
    }

    private JPanel _createAttachPanel(LineElement le) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.attach = new JCheckBox(RB.getStringResource(RB_KEY, "attachToData.txt"));
        this.attach.addActionListener(this);
        boolean isAttach = le.isAnchorAttachedToData();
        this.attach.setSelected(isAttach);
        this.attach.setActionCommand("ptattach");
        panel.add(this.attach);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private JPanel _createPointPosition(LineElement le) {
        this.pointPositionPanel = new JPanel();
        this.pointPositionPanel.setLayout(new BoxLayout(this.pointPositionPanel, 1));
        this.pointPositionPanel.setBorder(left);
        JPanel hp = new JPanel();
        hp.setLayout(new BoxLayout(hp, 1));
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new BoxLayout(lpanel, 0));
        JLabel hlabel = new JLabel(RB.getStringResource(RB_KEY, "horizontal.txt"));
        lpanel.add(hlabel);
        this.horzspinner = new JSpinner();
        lpanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        this.horzspinner.addChangeListener(this);
        lpanel.add(this.horzspinner);
        lpanel.add(Box.createHorizontalGlue());
        hp.add(lpanel);
        hp.add(Box.createHorizontalGlue());
        this.pointPositionPanel.add(hp);
        this.pointPositionPanel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        JPanel vp = new JPanel();
        vp.setLayout(new BoxLayout(vp, 1));
        lpanel = new JPanel();
        lpanel.setLayout(new BoxLayout(lpanel, 0));
        JLabel vlabel = new JLabel(RB.getStringResource(RB_KEY, "vertical.txt"));
        lpanel.add(vlabel);
        this.vertspinner = new JSpinner();
        lpanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.vertspinner.addChangeListener(this);
        lpanel.add(this.vertspinner);
        lpanel.add(Box.createHorizontalGlue());
        vp.add(lpanel);
        this.pointPositionPanel.add(vp);
        this.pointPositionPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        Dimension ps1 = hlabel.getPreferredSize();
        Dimension ps2 = vlabel.getPreferredSize();
        Dimension ps = new Dimension(Math.max(ps1.width, ps2.width), (int)(1.5 * (double)Math.max(ps1.height, ps2.height)));
        hlabel.setPreferredSize(ps1);
        hlabel.setMaximumSize(ps1);
        vlabel.setPreferredSize(ps1);
        vlabel.setMaximumSize(ps1);
        ps1 = this.horzspinner.getPreferredSize();
        ps.width = Math.max(ps1.width, ps2.width);
        SGDecimalFormat format = new SGDecimalFormat(1, 4, 3, 3);
        JLabel ll = new JLabel(format.format(9999L));
        ps.width += ll.getPreferredSize().width;
        this.horzspinner.setPreferredSize(ps);
        this.horzspinner.setMaximumSize(ps);
        this.vertspinner.setPreferredSize(ps);
        this.vertspinner.setMaximumSize(ps);
        this._updatePointPositionPanel(le, 0);
        return this.pointPositionPanel;
    }

    private void _updatePointPositionPanel(LineElement le, int index) {
        SGDecimalFormat format;
        JFormattedTextField textField;
        int nfrac;
        double absmax;
        JFormattedTextField textField2;
        SpinnerDoubleModel model;
        double[] r;
        Point2D p;
        this.horzspinner.removeChangeListener(this);
        this.vertspinner.removeChangeListener(this);
        Rectangle bounds = le.getAnchorBounds();
        if (index == 0) {
            this.isScreenSpace = !le.isAnchorAttachedToData();
            p = le.getAnchorPoint();
            r = le.getAnchorRange();
        } else {
            this.isScreenSpace = !le.isSecondaryAttachedToData();
            p = le.getSecondaryPoint();
            r = le.getSecondaryRange();
        }
        this.validXMin = r[0];
        this.validXMax = r[1];
        this.validYMin = r[2];
        this.validYMax = r[3];
        double step = (r[1] - r[0]) / (double)bounds.width;
        if (this.isScreenSpace) {
            step = Math.round(step);
            model = new SpinnerDoubleModel(p.getX() * 0.01, this.validXMin * 0.01, this.validXMax * 0.01, step * 0.01);
            this.horzspinner.setModel(model);
            NumberRangeListener.addRangeListener(this.horzspinner, this.validXMin * 0.01, (this.validXMax + 1.0) * 0.01);
            textField2 = ((JSpinner.DefaultEditor)this.horzspinner.getEditor()).getTextField();
            textField2.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(Util.DOUBLE_FORMAT)));
        } else {
            double factor;
            double dd = Math.log10(step);
            step = dd < 0.0 ? ((step = 2.0 * (factor = Math.pow(10.0, dd = Math.ceil(-dd))) * step) <= 2.5 ? 2.5 / factor : (step <= 5.0 ? 5.0 / factor : 10.0 / factor)) : (dd > 0.5 ? ((step = (factor = Math.pow(10.0, dd = Math.ceil(dd))) / step) <= 2.0 ? factor : (step <= 5.0 ? factor / 2.0 : factor / 10.0)) : 2.0);
            this.validXMin = Math.ceil(this.validXMin / step) * step;
            this.validXMax = Math.floor(this.validXMax / step) * step;
            p.setLocation(Math.max(this.validXMin, Math.min(this.validXMax, p.getX())), p.getY());
            model = new SpinnerDoubleModel(p.getX(), this.validXMin, this.validXMax, step);
            this.horzspinner.setModel(model);
            int nints = 6;
            absmax = Math.abs(this.validXMax);
            if (absmax > 10000.0) {
                nints = (int)Math.ceil(Math.log10(absmax)) + 2;
            }
            nfrac = 0;
            if (step < 1.0) {
                nfrac = Double.toString(step).length() - 2;
                step = 1.0 / Math.pow(10.0, nfrac);
            } else {
                step = 1.0;
            }
            textField = ((JSpinner.DefaultEditor)this.horzspinner.getEditor()).getTextField();
            format = new SGDecimalFormat(1, nints, nfrac, nfrac);
            textField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(format)));
            NumberRangeListener.addRangeListener(this.horzspinner, this.validXMin, this.validXMax + step);
        }
        step = (r[3] - r[2]) / (double)bounds.height;
        if (this.isScreenSpace) {
            step = Math.round(step);
            model = new SpinnerDoubleModel(p.getY() * 0.01, this.validYMin * 0.01, this.validYMax * 0.01, step * 0.01);
            this.vertspinner.setModel(model);
            NumberRangeListener.addRangeListener(this.vertspinner, this.validYMin * 0.01, (this.validYMax + 1.0) * 0.01);
            textField2 = ((JSpinner.DefaultEditor)this.vertspinner.getEditor()).getTextField();
            textField2.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(Util.DOUBLE_FORMAT)));
        } else {
            double factor;
            double dd = Math.log10(step);
            step = dd < 0.0 ? ((step = 2.0 * (factor = Math.pow(10.0, dd = Math.ceil(-dd))) * step) <= 2.5 ? 2.5 / factor : (step <= 5.0 ? 5.0 / factor : 10.0 / factor)) : (dd > 0.5 ? ((step = (factor = Math.pow(10.0, dd = Math.ceil(dd))) / step) <= 2.0 ? factor : (step <= 5.0 ? factor / 2.0 : factor / 10.0)) : 2.0);
            this.validYMin = Math.ceil(this.validYMin / step) * step;
            this.validYMax = Math.floor(this.validYMax / step) * step;
            p.setLocation(p.getX(), Math.max(this.validYMin, Math.min(this.validYMax, p.getY())));
            model = new SpinnerDoubleModel(p.getY(), this.validYMin, this.validYMax, step);
            this.vertspinner.setModel(model);
            int nints = 6;
            absmax = Math.abs(this.validYMax);
            if (absmax > 10000.0) {
                nints = (int)Math.ceil(Math.log10(absmax)) + 2;
            }
            nfrac = 0;
            if (step < 1.0) {
                nfrac = Double.toString(step).length() - 2;
                step = 1.0 / Math.pow(10.0, nfrac);
            } else {
                step = 1.0;
            }
            textField = ((JSpinner.DefaultEditor)this.vertspinner.getEditor()).getTextField();
            format = new SGDecimalFormat(1, nints, nfrac, nfrac);
            textField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(format)));
            NumberRangeListener.addRangeListener(this.vertspinner, this.validYMin, this.validYMax + step);
        }
        this.horzspinner.addChangeListener(this);
        this.vertspinner.addChangeListener(this);
        if (index == 0) {
            this.attach.setEnabled(le.canAnchorAttachedToData());
        } else {
            this.attach.setEnabled(le.canSecondaryAttachedToData());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("attach")) {
            boolean isAttach = this.attach.isSelected();
            this.annotate.setAnchorAttachedToData(isAttach);
            this.crop.setEnabled(isAttach);
        } else if (cmd.equals("ptattach")) {
            LineElement le = (LineElement)this.annotate;
            boolean isAttach = this.attach.isSelected();
            int index = this.pointBox.getSelectedIndex();
            if (index == 0) {
                le.setAnchorAttachedToData(isAttach);
            } else {
                le.setSecondaryAttachedToData(isAttach);
            }
            this._updatePointPositionPanel(le, index);
            this.crop.setEnabled(le.isAnchorAttachedToData() && le.isSecondaryAttachedToData());
            this.repaint();
        } else if (cmd.equals("crop")) {
            this.annotate.setClipOutsideDataOn(this.crop.isSelected());
        } else if (cmd.equals("point")) {
            LineElement le = (LineElement)this.annotate;
            int index = this.pointBox.getSelectedIndex();
            if (index == 0) {
                this.attach.setSelected(le.isAnchorAttachedToData());
            } else {
                this.attach.setSelected(le.isSecondaryAttachedToData());
            }
            this._updatePointPositionPanel(le, index);
            this.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.rotationspinner) {
            Number value = (Number)this.rotationspinner.getModel().getValue();
            this.annotate.setRotationAngle(value.intValue());
        } else if (src == this.horzspinner) {
            Number value = (Number)this.horzspinner.getModel().getValue();
            if (this.pointBox.getSelectedIndex() == 0) {
                Point2D p = ((LineElement)this.annotate).getAnchorPoint();
                if (this.isScreenSpace) {
                    p.setLocation(100.0 * value.doubleValue(), p.getY());
                } else {
                    try {
                        JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.horzspinner.getEditor()).getTextField().getFormatter();
                        String vv1 = formatter.valueToString(new Double(p.getX()));
                        String vv2 = formatter.valueToString(value);
                        if (!vv1.equals(vv2)) {
                            p.setLocation(value.doubleValue(), p.getY());
                        }
                    }
                    catch (ParseException formatter) {
                        // empty catch block
                    }
                }
                ((LineElement)this.annotate).setAnchorPoint(p);
            } else {
                Point2D p = ((LineElement)this.annotate).getSecondaryPoint();
                if (this.isScreenSpace) {
                    p.setLocation(100.0 * value.doubleValue(), p.getY());
                } else {
                    try {
                        JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.horzspinner.getEditor()).getTextField().getFormatter();
                        String vv1 = formatter.valueToString(new Double(p.getX()));
                        String vv2 = formatter.valueToString(value);
                        if (!vv1.equals(vv2)) {
                            p.setLocation(value.doubleValue(), p.getY());
                        }
                    }
                    catch (ParseException formatter) {
                        // empty catch block
                    }
                }
                ((LineElement)this.annotate).setSecondaryPoint(p);
            }
        } else if (src == this.vertspinner) {
            Number value = (Number)this.vertspinner.getModel().getValue();
            if (this.pointBox.getSelectedIndex() == 0) {
                Point2D p = ((LineElement)this.annotate).getAnchorPoint();
                if (this.isScreenSpace) {
                    p.setLocation(p.getX(), 100.0 * value.doubleValue());
                } else {
                    try {
                        JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.vertspinner.getEditor()).getTextField().getFormatter();
                        String vv1 = formatter.valueToString(new Double(p.getX()));
                        String vv2 = formatter.valueToString(value);
                        if (!vv1.equals(vv2)) {
                            p.setLocation(p.getX(), value.doubleValue());
                        }
                    }
                    catch (ParseException formatter) {
                        // empty catch block
                    }
                }
                ((LineElement)this.annotate).setAnchorPoint(p);
            } else {
                Point2D p = ((LineElement)this.annotate).getSecondaryPoint();
                if (this.isScreenSpace) {
                    p.setLocation(p.getX(), 100.0 * value.doubleValue());
                } else {
                    try {
                        JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.vertspinner.getEditor()).getTextField().getFormatter();
                        String vv1 = formatter.valueToString(new Double(p.getX()));
                        String vv2 = formatter.valueToString(value);
                        if (!vv1.equals(vv2)) {
                            p.setLocation(p.getX(), value.doubleValue());
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                ((LineElement)this.annotate).setSecondaryPoint(p);
            }
        }
    }

    class SpinnerDoubleModel
    extends SpinnerNumberModel {
        double min;
        double max;

        public SpinnerDoubleModel(double value, double min, double max, double step) {
            super(value, min, max, step);
            this.min = min;
            this.max = max;
        }

        @Override
        public Object getNextValue() {
            Object next = super.getNextValue();
            if (next instanceof Number) {
                if (next instanceof Integer) {
                    next = new Double(((Integer)next).doubleValue());
                } else if (next instanceof Long) {
                    next = new Double(((Long)next).doubleValue());
                }
            }
            return next;
        }

        @Override
        public Object getPreviousValue() {
            Object prev = super.getPreviousValue();
            if (prev instanceof Number) {
                if (prev instanceof Integer) {
                    prev = new Double(((Integer)prev).doubleValue());
                } else if (prev instanceof Long) {
                    prev = new Double(((Long)prev).doubleValue());
                }
            }
            return prev;
        }

        @Override
        public Object getValue() {
            Object value = super.getValue();
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    value = new Double(((Integer)value).doubleValue());
                } else if (value instanceof Long) {
                    value = new Double(((Long)value).doubleValue());
                }
            }
            return value;
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Number)) {
                super.setValue(value);
                return;
            }
            double nv = ((Number)value).doubleValue();
            if (nv < this.min || nv > this.max) {
                return;
            }
            super.setValue(value);
        }
    }
}

