/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.interfaces.DefaultMarkerInterface;
import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sg.util.SGActionEvent;
import com.sas.graphics.sganno.AAreaStyle;
import com.sas.graphics.sganno.AMarkerStyle;
import com.sas.graphics.sganno.ATextStyle;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.RB;
import com.sas.graphics.sganno.RectangleElement;
import com.sas.graphics.util.Markers;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Element;

public class MarkerElement
extends RectangleElement
implements MarkerInterface,
DefaultMarkerInterface {
    static final int DEFAULT_SIZE = 7;
    static final int DEFAULT_SYMBOL = 23;
    private AMarkerStyle markerStyle;
    private int customDefaultMarker = -1;
    private int customDefaultMarkerSize = -1;

    MarkerElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent, AMarkerStyle mi) {
        super(annotate, graph, x, null, parent);
        this.init(annotate, x, node, parent, mi);
    }

    MarkerElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent, AMarkerStyle mi) {
        super(annotate, graph, x, null, parent);
        Point2D p = graph.convertDataToScreen(parent, x);
        this.init(annotate, new Point((int)p.getX(), (int)p.getY()), node, parent, mi);
    }

    private void init(Annotate annotate, Point x, Element node, String parent, AMarkerStyle mi) {
        this.areaAttrsEnabled = false;
        this.outlineAttrsEnabled = false;
        this.textPosition = 3;
        this.style.setLineOn(false);
        this.style.setFillOn(false);
        this.markerStyle = new AMarkerStyle(annotate.getDefaultMarkerStyle());
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("MarkerElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
            this.elem.setAttribute("textPosition", "bottom");
            this.elem.setAttribute("line", "false");
            this.elem.setAttribute("fill", "false");
        }
        int size = mi == null || mi.getMarkerSize() == -1 ? this.markerStyle.getMarkerSize() : mi.getMarkerSize();
        this.width = size + 8;
        this.height = size + 8;
        int dx = (int)this.width / 2;
        int dy = (int)this.height / 2;
        this.anchor.move(-dx, -dy);
        this.secondary.move((int)(this.width - (double)dx), (int)(this.height - (double)dy));
        this.x = x.getX() - (double)dx;
        this.y = x.getY() - (double)dy;
        if (mi != null) {
            this.setMarkerStyle(mi);
        }
        this.textwrapping = false;
    }

    @Override
    void load(Element aElem, boolean loadOnly) {
        super.load(aElem, loadOnly);
        if (this.customAttrs != null && this.customAttrs.hasAttribute("marker")) {
            this.customDefaultMarker = Integer.parseInt(this.customAttrs.getAttribute("marker"));
            this.markerStyle.setMarkerSymbol(this.customDefaultMarker);
        }
        if (aElem.hasAttribute("symbol")) {
            int marker = Integer.parseInt(aElem.getAttribute("symbol"));
            this.markerStyle.setMarkerSymbol(marker);
            if (this.customAttrs == null) {
                this.customDefaultMarker = marker;
            }
        }
        if (this.style.isLineColorCustom()) {
            this.markerStyle.setMarkerColor(this.style.getLineColor());
        }
        int w = (int)Math.round(Math.abs(this.secondary.screen.getX() - this.anchor.screen.getX()));
        int h = (int)Math.round(Math.abs(this.secondary.screen.getY() - this.anchor.screen.getY()));
        int newsize = Math.max(1, Math.min(w, h) - 8);
        if (this.customAttrs != null) {
            if (this.customAttrs.hasAttribute("markerSize")) {
                this.customDefaultMarkerSize = Integer.parseInt(this.customAttrs.getAttribute("markerSize"));
                this.markerStyle.setMarkerSize(this.customDefaultMarkerSize);
            }
        } else if (newsize == this.markerStyle.defaultStyle.getMarkerSize()) {
            this.markerStyle.setMarkerSize(-1);
        } else {
            this.customDefaultMarkerSize = newsize;
        }
        this.markerStyle.setMarkerSize(newsize);
    }

    @Override
    void paint(Graphics2D gc) {
        int symbol;
        Shape prevClip = gc.getClip();
        if (this.parentID != null && this.clip != null && this.clipOutside) {
            if (prevClip == null) {
                gc.setClip(this.clip);
            } else {
                gc.setClip(this.clip.getBounds2D().createIntersection(prevClip.getBounds2D()));
            }
        }
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform save = gc.getTransform();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        int edgeWeight = Markers.isBold((int)(symbol = this.markerStyle.getMarkerSymbol())) ? 2 : 0;
        int edgeSize = MarkerElement.getMarkerEdgeWidth(this.markerStyle.getMarkerSize(), edgeWeight);
        Color cc = this.style.getLineColor();
        Markers.draw((Graphics)gc, (Color)cc, null, (int)symbol, (int)this.markerStyle.getMarkerSize(), (int)((int)(this.x + this.width / 2.0)), (int)((int)(this.y + this.height / 2.0)), (boolean)false, (int)edgeWeight, (int)edgeSize);
        Stroke saveStroke = gc.getStroke();
        gc.setStroke(this.stroke);
        Font f = this.textStyle.getFont();
        Font f2 = new Font(f.getFamily(), f.getStyle(), f.getSize() + 2);
        gc.setFont(f2);
        if (this.frc == null) {
            this.frc = gc.getFontRenderContext();
            this.lbm = null;
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        if (this.text != null && this.text.length() > 0) {
            boolean extsel;
            if (this.lbm == null) {
                this.checkTextLayout();
            }
            boolean bl = extsel = this.caretPosition != this.selectAnchor && this.selectAnchor != -1;
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, selectedTextColor);
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            } else if (this.rotation != 0.0) {
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            }
            if (this.caretOn) {
                this._drawBorderAndCaret(gc);
            }
            float tx = (float)this.textAnchor.getX();
            float ty = (float)this.textAnchor.getY();
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            if (this.textwrapping) {
                while (true) {
                    float start = this._getTextAnchor(tl);
                    tl.draw(gc, start, ty);
                    ty += tl.getDescent() + tl.getLeading();
                    tl = this.lbm.nextLayout(this.wrappingWidth);
                    if (tl != null) {
                        ty += tl.getAscent();
                        continue;
                    }
                    break;
                }
            } else {
                tl.draw(gc, tx, ty);
            }
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textStyle.getFontColor());
                this.lbm = null;
            }
        } else if (this.caretOn) {
            this._drawBorderAndCaret(gc);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        gc.setStroke(saveStroke);
        gc.setClip(prevClip);
    }

    public static int getMarkerEdgeWidth(double size, int weight) {
        double width;
        double ratio = size / 7.0;
        if (weight == 2) {
            double power = 0.7;
            double minWidth = 2.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else if (weight == 1) {
            double power = 0.65;
            double minWidth = 1.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else {
            double power = 0.5;
            double minWidth = 1.0;
            width = ratio <= 3.0 ? minWidth : minWidth + Math.pow(ratio - 3.0, power);
        }
        return (int)width;
    }

    @Override
    public void setMarkerSymbol(int symbol) {
        int oldSymbol = this.markerStyle.getMarkerSymbol();
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("MarkerAttrs");
            e.setAttribute("symbol", Integer.toString(oldSymbol));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if (symbol == -1) {
            symbol = this.customDefaultMarker;
        }
        this.markerStyle.setMarkerSymbol(symbol);
        if (symbol != -1) {
            this.elem.setAttribute("symbol", Integer.toString(symbol));
        } else if (symbol == -1 && this.elem.hasAttribute("symbol")) {
            this.elem.removeAttribute("symbol");
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "markerSymbol", new Integer(oldSymbol), new Integer(symbol));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public int getMarkerSymbol() {
        int symbol = this.markerStyle.getMarkerSymbol();
        if (this.customDefaultMarker != -1) {
            if (symbol == this.customDefaultMarker) {
                return -1;
            }
            return symbol;
        }
        if (this.markerStyle.isMarkerSymbolCustom()) {
            return symbol;
        }
        return -1;
    }

    @Override
    public void setMarkerSize(int size) {
        if (this.markerStyle.getMarkerSize() == size) {
            return;
        }
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("MarkerAttrs");
            int cursize = this.markerStyle.isMarkerSizeCustom() ? this.markerStyle.getMarkerSize() : -1;
            e.setAttribute("size", Integer.toString(cursize));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.markerStyle.setMarkerSize(size);
        size = this.markerStyle.getMarkerSize();
        int newwidth = size + 8;
        int newheight = size + 8;
        int dx = newwidth - (int)Math.round(this.width);
        int dy = newheight - (int)Math.round(this.height);
        int dxby2 = dx / 2;
        int dyby2 = dy / 2;
        this.anchor.move(-dxby2, -dyby2);
        this.secondary.move(dx - dxby2, dy - dyby2);
        this.width = newwidth;
        this.height = newheight;
        this.finish();
    }

    @Override
    public int getMarkerSize() {
        int size = this.markerStyle.getMarkerSize();
        if (this.customDefaultMarkerSize != -1) {
            if (this.customDefaultMarkerSize == size) {
                return -1;
            }
            return size;
        }
        if (this.markerStyle.isMarkerSizeCustom()) {
            return size;
        }
        return -1;
    }

    @Override
    public Color getMarkerColor() {
        return this.getLineColor();
    }

    @Override
    public void setMarkerColor(Color color) {
        this.setLineColor(color);
    }

    @Override
    public void setMarkerWeight(int weight) {
    }

    @Override
    public int getMarkerWeight() {
        if (Markers.isBold((int)this.markerStyle.getMarkerSymbol())) {
            return 2;
        }
        return 0;
    }

    public void setMarkerStyle(MarkerInterface style) {
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("MarkerAttrs");
            int symbol = this.markerStyle.isMarkerSymbolCustom() ? this.markerStyle.getMarkerSymbol() : -1;
            e.setAttribute("symbol", Integer.toString(symbol));
            int size = this.markerStyle.isMarkerSizeCustom() ? this.markerStyle.getMarkerSize() : -1;
            e.setAttribute("size", Integer.toString(size));
            Color c = this.style.isLineColorCustom() ? this.style.getLineColor() : null;
            String curValue = c == null ? " " : Integer.toString(c.getRGB());
            e.setAttribute("color", curValue);
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        int ds = style == null || style.getMarkerSymbol() == -1 || style.getMarkerSymbol() == this.markerStyle.defaultStyle.getMarkerSymbol() ? -1 : style.getMarkerSymbol();
        this.markerStyle.setMarkerSymbol(ds);
        if (this.elem != null) {
            if (ds != -1) {
                this.elem.setAttribute("symbol", Integer.toString(ds));
            } else if (this.elem.hasAttribute("symbol")) {
                this.elem.removeAttribute("symbol");
            }
        }
        Color c = style == null || style.getMarkerColor() == null || style.getMarkerColor().getRGB() == this.markerStyle.defaultStyle.getMarkerColor().getRGB() ? null : style.getMarkerColor();
        this.markerStyle.setMarkerColor(c);
        this.style.setLineColor(c);
        if (this.elem != null) {
            if (c != null) {
                if (this.outlineAttrs == null) {
                    this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                    this.elem.appendChild(this.outlineAttrs);
                }
                this.outlineAttrs.setAttribute("color", Integer.toString(c.getRGB()));
            } else if (this.outlineAttrs != null && this.outlineAttrs.hasAttribute("color")) {
                this.outlineAttrs.removeAttribute("color");
            }
        }
        int oldSize = this.markerStyle.getMarkerSize();
        int size = style == null || style.getMarkerSize() == -1 || style.getMarkerSize() == this.markerStyle.defaultStyle.getMarkerSize() ? -1 : style.getMarkerSize();
        this.markerStyle.setMarkerSize(size);
        size = this.markerStyle.getMarkerSize();
        if (oldSize != size) {
            size = style.getMarkerSize();
            int dx = (int)Math.max(0.0, this.width - (double)(size + 16));
            int dy = (int)Math.max(0.0, this.height - (double)(size + 16));
            this.anchor.move(dx / 2, dy / 2);
            this.secondary.move(dx - dx / 2, dy - dy / 2);
            this.finish();
        } else {
            int lsize = this.listeners.size();
            if (lsize > 0) {
                PropertyChangeEvent pce = new PropertyChangeEvent(this, "multiple", null, null);
                for (int i = 0; i < lsize; ++i) {
                    ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
                }
            }
        }
    }

    @Override
    protected Element _undo(Element savedElem) {
        String elemtag = savedElem.getTagName();
        if ("MarkerAttrs".equals(elemtag)) {
            String newValue;
            String oldValue;
            Element e = this.elem.getOwnerDocument().createElement("MarkerAttrs");
            if (savedElem.hasAttribute("symbol")) {
                oldValue = this.markerStyle.isMarkerSymbolCustom() ? Integer.toString(this.markerStyle.getMarkerSymbol()) : Integer.toString(-1);
                newValue = savedElem.getAttribute("symbol");
                e.setAttribute("symbol", oldValue);
                if (this.elem != null) {
                    this.elem.setAttribute("symbol", newValue);
                }
                this.markerStyle.setMarkerSymbol(Integer.parseInt(newValue));
            }
            if (savedElem.hasAttribute("color")) {
                Color color;
                oldValue = this.markerStyle.isMarkerColorCustom() ? Integer.toString(this.markerStyle.getMarkerColor().getRGB()) : " ";
                newValue = savedElem.getAttribute("color");
                e.setAttribute("color", oldValue);
                Color color2 = color = newValue.equals(" ") ? null : new Color(Integer.parseInt(newValue));
                if (this.elem != null) {
                    if (color != null) {
                        if (this.outlineAttrs == null) {
                            this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                            this.elem.appendChild(this.outlineAttrs);
                        }
                        this.outlineAttrs.setAttribute("color", Integer.toString(color.getRGB()));
                    } else if (this.outlineAttrs != null && this.outlineAttrs.hasAttribute("color")) {
                        this.outlineAttrs.removeAttribute("color");
                    }
                }
                this.style.setLineColor(color);
                this.markerStyle.setMarkerColor(color);
            }
            if (savedElem.hasAttribute("size")) {
                oldValue = this.markerStyle.isMarkerSizeCustom() ? Integer.toString(this.markerStyle.getMarkerSize()) : "-1";
                newValue = savedElem.getAttribute("size");
                e.setAttribute("size", oldValue);
                int size = Integer.parseInt(newValue);
                this.markerStyle.setMarkerSize(size);
                size = this.markerStyle.getMarkerSize();
                int newwidth = size + 8;
                int newheight = size + 8;
                int dx = newwidth - (int)Math.round(this.width);
                int dy = newheight - (int)Math.round(this.height);
                int dxby2 = dx / 2;
                int dyby2 = dy / 2;
                this.anchor.move(-dxby2, -dyby2);
                this.secondary.move(dx - dxby2, dy - dyby2);
                this.width = newwidth;
                this.height = newheight;
                this.finish();
            }
            return e;
        }
        if ("TextPosition".equals(elemtag)) {
            if (savedElem.hasAttribute("textPosition")) {
                String oldValue = Integer.toString(this.textPosition);
                String newValue = savedElem.getAttribute("textPosition");
                this.textPosition = Integer.parseInt(newValue);
                savedElem.setAttribute("textPosition", oldValue);
                if (this.textPosition == 3) {
                    this.elem.setAttribute("textPosition", "Bottom");
                } else if (this.textPosition == 1) {
                    this.elem.setAttribute("textPosition", "Top");
                } else if (this.textPosition == 10) {
                    this.elem.setAttribute("textPosition", "Start");
                } else if (this.textPosition == 11) {
                    this.elem.setAttribute("textPosition", "End");
                } else {
                    this.elem.setAttribute("textPosition", "Bottom");
                }
            }
            return savedElem;
        }
        if ("MarkerElement".equals(elemtag) && savedElem.hasAttribute("symbol")) {
            String oldValue = this.markerStyle.isMarkerSymbolCustom() ? Integer.toString(this.markerStyle.getMarkerSymbol()) : "-1";
            String newValue = savedElem.getAttribute("symbol");
            savedElem.setAttribute("symbol", oldValue);
            int symbol = Integer.parseInt(newValue);
            this.markerStyle.setMarkerSymbol(symbol);
            if (this.elem != null) {
                if (symbol != -1) {
                    this.elem.setAttribute("symbol", Integer.toString(symbol));
                } else if (this.elem.hasAttribute("symbol")) {
                    this.elem.removeAttribute("symbol");
                }
            }
        }
        return super._undo(savedElem);
    }

    @Override
    void setInternalVariables() {
        super.setInternalVariables();
        if (this.markerStyle != null) {
            int newsize = Math.max(1, (int)Math.min(this.width, this.height) - 8);
            if (newsize == this.markerStyle.defaultStyle.getMarkerSize()) {
                this.markerStyle.setMarkerSize(-1);
            } else {
                this.markerStyle.setMarkerSize(newsize);
            }
        }
    }

    @Override
    protected void setTextVariables() {
        if (this.text != null || this.caretOn) {
            this.wrappingWidth = !this.textwrapping ? 2.1474836E9f : (this.width > 8.0 ? (float)this.width - 6.0f : (float)this.minTextWidth);
            this.checkTextLayout();
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            this.bounds = tl.getBounds();
            double twidth = tl.getAdvance() + 6.0f;
            double theight = 12.0f + tl.getAscent() + tl.getDescent() + tl.getLeading();
            while ((tl = this.lbm.nextLayout(this.wrappingWidth)) != null) {
                theight += (double)(tl.getAscent() + tl.getDescent() + tl.getLeading());
                twidth = Math.max(twidth, (double)tl.getAdvance());
            }
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(this.wrappingWidth);
            if (this.text == null || twidth < (double)this.minTextWidth) {
                double tx = this.x + this.width / 2.0 - (double)(this.minTextWidth / 2) - 4.0;
                double ty = this.y + this.height / 2.0 - theight / 2.0;
                if (this.textPosition == 3) {
                    ty += (this.height + theight) / 2.0;
                } else if (this.textPosition == 1) {
                    ty -= (this.height + theight) / 2.0;
                }
                this.outside.setRect(tx, ty, this.minTextWidth + 6, theight);
                if (this.text == null) {
                    this.textAnchor.setLocation(this.x + this.width / 2.0 - 2.0, ty + (double)tl.getAscent() + 6.0);
                } else {
                    this.textAnchor.setLocation(this.x + this.width / 2.0 - twidth / 2.0 + 2.0, ty + (double)tl.getAscent() + 6.0);
                }
            } else {
                double tx = this.x + this.width / 2.0 - twidth / 2.0 - 4.0;
                double ty = this.y + this.height / 2.0 - theight / 2.0;
                if (this.textPosition == 3) {
                    ty += (this.height + theight) / 2.0;
                } else if (this.textPosition == 1) {
                    ty -= (this.height + theight) / 2.0;
                }
                this.outside.setRect(tx, ty, twidth + 6.0, theight);
                this.textAnchor.setLocation(tx + 6.0, ty + (double)tl.getAscent() + 6.0);
            }
        } else {
            this.outside.setRect(0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getDefaultMarkerSymbol() {
        if (this.customDefaultMarker != -1) {
            return this.customDefaultMarker;
        }
        return this.markerStyle.defaultStyle.getMarkerSymbol();
    }

    @Override
    public String getDefaultMarkerSymbolSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public int getDefaultMarkerSize() {
        if (this.customDefaultMarkerSize != -1) {
            return this.customDefaultMarkerSize;
        }
        return this.markerStyle.defaultStyle.getMarkerSize();
    }

    @Override
    public String getDefaultMarkerSizeSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public Color getDefaultMarkerColor() {
        return this.getDefaultLineColor();
    }

    @Override
    public String getDefaultMarkerColorSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public int getDefaultMarkerWeight() {
        return this.markerStyle.defaultStyle.getMarkerWeight();
    }

    @Override
    public String getDefaultMarkerWeightSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public boolean isDefaultMarkerOn() {
        return true;
    }

    @Override
    public void resetStyle(AAreaStyle areaStyle, ATextStyle textStyle, AMarkerStyle markerStyle) {
        double h;
        double w;
        int newsize;
        super.resetStyle(areaStyle, textStyle, markerStyle);
        this.markerStyle = new AMarkerStyle(markerStyle);
        if (this.elem.hasAttribute("symbol")) {
            this.markerStyle.setMarkerSymbol(Integer.parseInt(this.elem.getAttribute("symbol")));
        }
        if (this.style.isLineColorCustom()) {
            this.markerStyle.setMarkerColor(this.style.getLineColor());
        }
        if ((newsize = Math.max(1, (int)Math.min(w = (double)Math.round(Math.abs(this.secondary.screen.getX() - this.anchor.screen.getX())), h = (double)Math.round(Math.abs(this.secondary.screen.getY() - this.anchor.screen.getY()))) - 8)) == markerStyle.defaultStyle.getMarkerSize()) {
            this.markerStyle.setMarkerSize(-1);
        } else {
            this.markerStyle.setMarkerSize(newsize);
        }
    }

    @Override
    void drawHandles(Graphics2D gc) {
        this._drawHandles(gc);
    }

    @Override
    void drawHandles(Graphics2D gc, Color color) {
        this._drawHandles(gc, color);
    }

    @Override
    public Element getCustomAttrs() {
        if (this.customAttrs != null) {
            return this.customAttrs;
        }
        this.customAttrs = super.getCustomAttrs();
        if (this.customDefaultMarker != -1) {
            this.customAttrs.setAttribute("marker", Integer.toString(this.customDefaultMarker));
        }
        if (this.customDefaultMarkerSize != -1) {
            this.customAttrs.setAttribute("markerSize", Integer.toString(this.customDefaultMarkerSize));
        }
        return this.customAttrs;
    }
}

