/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.util.SGActionEvent;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AnnotatePoint;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.EllipseElement;
import com.sas.graphics.sganno.RectangleElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedString;
import org.w3c.dom.Element;

public class LineElement
extends AnnotateElement {
    int align = 0;
    String secondaryParent;
    Rectangle2D innerBounds = new Rectangle2D.Double();
    int dx;
    int dy;
    boolean building = true;

    LineElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    LineElement(Annotate annotate, BaseAnnotatable graph, Point x1, Point x2, Element node, String parent) {
        super(annotate, graph, x1, null, parent);
        this.init(node, parent);
        if (graph instanceof Annotatable) {
            this.secondary.setPoint((Annotatable)graph, parent, x2);
        } else {
            this.secondary.setPoint(x2);
        }
    }

    private void init(Element node, String parent) {
        this.secondaryParent = parent;
        this.setInternalVariables();
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("LineElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
        }
        this.style.setFillOn(false);
        this.style.setLineOn(true);
        this.rotation = 0.0;
        this.textwrapping = false;
    }

    LineElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    LineElement(Annotate annotate, Annotatable graph, Object[] x1, Object[] x2, Element node, String parent) {
        super(annotate, graph, x1, null, parent);
        this.init(node, parent);
        this.secondary.setPoint(graph, parent, x2);
    }

    public Point2D getAnchorPoint() {
        if (this.anchor.type == 1) {
            return new Point2D.Double((Double)this.anchor.data[0], (Double)this.anchor.data[1]);
        }
        return new Point((int)Math.round(this.anchor.screen.getX()), (int)Math.round(this.anchor.screen.getY()));
    }

    public Point2D getSecondaryPoint() {
        if (this.secondary.type == 1) {
            return new Point2D.Double((Double)this.secondary.data[0], (Double)this.secondary.data[1]);
        }
        return new Point((int)Math.round(this.secondary.screen.getX()), (int)Math.round(this.secondary.screen.getY()));
    }

    public void setSecondaryPoint(Point2D p) {
        int lsize;
        if (this.secondary.type == 1) {
            double oldx = (Double)this.secondary.data[0];
            double oldy = (Double)this.secondary.data[1];
            if (oldx == p.getX() && oldy == p.getY()) {
                return;
            }
            if (this.listener != null) {
                Element e = this.elem.getOwnerDocument().createElement("Position");
                e.setAttribute("SecondaryX", this.secondary.data[0].toString());
                e.setAttribute("SecondaryY", this.secondary.data[1].toString());
                this.listener.actionPerformed(new SGActionEvent(this, e));
            }
            this.secondary.data[0] = new Double(p.getX());
            this.secondary.data[1] = new Double(p.getY());
            this.secondary.update(this.graph, this.secondaryParent);
        } else {
            int oldx = (int)Math.round(this.secondary.screen.getX());
            int oldy = (int)Math.round(this.secondary.screen.getY());
            if (oldx == (int)p.getX() && oldy == (int)p.getY()) {
                return;
            }
            if (this.listener != null) {
                Element e = this.elem.getOwnerDocument().createElement("Position");
                e.setAttribute("SSecondaryX", Integer.toString((int)Math.round(this.secondary.screen.getX())));
                e.setAttribute("SSecondaryY", Integer.toString((int)Math.round(this.secondary.screen.getY())));
                this.listener.actionPerformed(new SGActionEvent(this, e));
            }
            this.secondary.screen.setLocation(Math.round(p.getX()), Math.round(p.getY()));
            this.secondary.finish(this.graph, this.secondaryParent);
        }
        this.setInternalVariables();
        if (this.elem != null) {
            this.elem.setAttribute("SSecondaryX", Integer.toString((int)Math.round(this.secondary.screen.getX())));
            this.elem.setAttribute("SSecondaryY", Integer.toString((int)Math.round(this.secondary.screen.getY())));
            this.elem.setAttribute("SecondaryX", this.secondary.data[0].toString());
            this.elem.setAttribute("SecondaryY", this.secondary.data[1].toString());
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "setSecondaryPoint", null, p);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        this.savedSecondary = new Point((int)Math.round(this.secondary.screen.getX()), (int)Math.round(this.secondary.screen.getY()));
    }

    @Override
    public Rectangle getAnchorBounds() {
        Dimension d = this.graph.getAnnotationSize();
        Rectangle r = new Rectangle(0, 0, d.width, d.height);
        return r;
    }

    @Override
    public Rectangle getSecondaryBounds() {
        return this.getAnchorBounds();
    }

    public double[] getAnchorRange() {
        if (!this.anchorAttachedToData || this.parentID == null || !(this.graph instanceof Annotatable)) {
            return this._getRangeInScreenSpace();
        }
        return this._getRangeInDataSpace(this.parentID);
    }

    public double[] getSecondaryRange() {
        if (!this.secondaryAttachedToData || this.secondaryParent == null || !(this.graph instanceof Annotatable)) {
            return this._getRangeInScreenSpace();
        }
        return this._getRangeInDataSpace(this.secondaryParent);
    }

    private double[] _getRangeInDataSpace(String parent) {
        double factor;
        double[] range = new double[4];
        Dimension d = this.graph.getAnnotationSize();
        Point p1 = new Point(0, 0);
        Point p2 = new Point(d.width, d.height);
        Object[] data1 = new Double[2];
        Object[] data2 = new Double[2];
        ((Annotatable)this.graph).convertScreenToData(parent, p1, data1);
        ((Annotatable)this.graph).convertScreenToData(parent, p2, data2);
        double x1 = (Double)data1[0];
        double x2 = (Double)data2[0];
        double y1 = (Double)data1[1];
        double y2 = (Double)data2[1];
        range[0] = Math.min(x1, x2);
        range[1] = Math.max(x1, x2);
        range[2] = Math.min(y1, y2);
        range[3] = Math.max(y1, y2);
        double rr = Math.log10((range[1] - range[0]) / (double)d.width);
        if (rr < 0.0) {
            rr = Math.ceil(-rr);
            factor = Math.pow(10.0, rr);
            range[0] = (double)Math.round(factor * range[0]) / factor;
            range[1] = (double)Math.round(factor * range[1]) / factor;
        } else if (rr > 1.0) {
            rr = Math.ceil(rr);
            factor = Math.pow(10.0, rr);
            range[0] = factor * (double)Math.round(range[0] / factor);
            range[1] = factor * (double)Math.round(range[1] / factor);
        }
        rr = Math.log10((range[3] - range[2]) / (double)d.height);
        if (rr < 0.0) {
            rr = Math.ceil(-rr);
            factor = Math.pow(10.0, rr);
            range[2] = (double)Math.round(factor * range[2]) / factor;
            range[3] = (double)Math.round(factor * range[3]) / factor;
        } else if (rr > 1.0) {
            rr = Math.ceil(rr);
            factor = Math.pow(10.0, rr);
            range[2] = factor * (double)Math.round(range[2] / factor);
            range[3] = factor * (double)Math.round(range[3] / factor);
        }
        return range;
    }

    private double[] _getRangeInScreenSpace() {
        double[] range = new double[4];
        Dimension d = this.graph.getAnnotationSize();
        range[2] = 0.0;
        range[0] = 0.0;
        range[1] = d.width;
        range[3] = d.height;
        return range;
    }

    @Override
    public Object undo(Object savedElem) {
        Element se;
        String elemtag;
        if (savedElem instanceof Element && "Position".equals(elemtag = (se = (Element)savedElem).getTagName())) {
            int savey;
            int cury;
            double savey2;
            double savex;
            double cury2;
            double curx;
            if ((se.hasAttribute("AnchorX") || se.hasAttribute("AnchorY")) && this.anchor.type == 1) {
                curx = (Double)this.anchor.data[0];
                cury2 = (Double)this.anchor.data[1];
                savex = se.hasAttribute("AnchorX") ? Double.parseDouble(se.getAttribute("AnchorX")) : curx;
                double d = savey2 = se.hasAttribute("AnchorY") ? Double.parseDouble(se.getAttribute("AnchorY")) : cury2;
                if (curx == savex && cury2 == savey2) {
                    return savedElem;
                }
                se.setAttribute("AnchorX", ((Double)this.anchor.data[0]).toString());
                se.setAttribute("AnchorY", ((Double)this.anchor.data[1]).toString());
                this.anchor.data[0] = new Double(savex);
                this.anchor.data[1] = new Double(savey2);
                this.elem.setAttribute("AnchorX", ((Double)this.anchor.data[0]).toString());
                this.elem.setAttribute("AnchorY", ((Double)this.anchor.data[1]).toString());
                this.anchor.update(this.graph, this.parentID);
            }
            if ((se.hasAttribute("SecondaryX") || se.hasAttribute("SecondaryY")) && this.secondary.type == 1) {
                curx = (Double)this.secondary.data[0];
                cury2 = (Double)this.secondary.data[1];
                savex = se.hasAttribute("SecondaryX") ? Double.parseDouble(se.getAttribute("SecondaryX")) : curx;
                double d = savey2 = se.hasAttribute("SecondaryY") ? Double.parseDouble(se.getAttribute("SecondaryY")) : cury2;
                if (curx == savex && cury2 == savey2) {
                    return savedElem;
                }
                se.setAttribute("SecondaryX", ((Double)this.secondary.data[0]).toString());
                se.setAttribute("SecondaryY", ((Double)this.secondary.data[1]).toString());
                this.secondary.data[0] = new Double(savex);
                this.secondary.data[1] = new Double(savey2);
                this.elem.setAttribute("SecondaryX", ((Double)this.secondary.data[0]).toString());
                this.elem.setAttribute("SecondaryY", ((Double)this.secondary.data[1]).toString());
                this.secondary.update(this.graph, this.secondaryParent);
            }
            if ((se.hasAttribute("SAnchorX") || se.hasAttribute("SAnchorY")) && this.anchor.type == 0) {
                int curx2 = (int)Math.round(this.anchor.screen.getX());
                cury = (int)Math.round(this.anchor.screen.getY());
                int savex2 = se.hasAttribute("SAnchorX") ? (int)Math.round(Double.parseDouble(se.getAttribute("SAnchorX"))) : curx2;
                int n = savey = se.hasAttribute("SAnchorY") ? (int)Math.round(Double.parseDouble(se.getAttribute("SAnchorY"))) : cury;
                if (curx2 == savex2 && cury == savey) {
                    return savedElem;
                }
                se.setAttribute("SAnchorX", Integer.toString(curx2));
                se.setAttribute("SAnchorY", Integer.toString(cury));
                this.anchor.screen.setLocation(savex2, savey);
                this.elem.setAttribute("SAnchorX", Integer.toString(savex2));
                this.elem.setAttribute("SAnchorY", Integer.toString(savey));
                this.anchor.finish(this.graph, this.parentID);
            }
            if ((se.hasAttribute("SSecondaryX") || se.hasAttribute("SSecondaryY")) && this.secondary.type == 0) {
                int curx3 = (int)Math.round(this.secondary.screen.getX());
                cury = (int)Math.round(this.secondary.screen.getY());
                int savex3 = se.hasAttribute("SSecondaryX") ? (int)Math.round(Double.parseDouble(se.getAttribute("SSecondaryX"))) : curx3;
                int n = savey = se.hasAttribute("SSecondaryY") ? (int)Math.round(Double.parseDouble(se.getAttribute("SSecondaryY"))) : cury;
                if (curx3 == savex3 && cury == savey) {
                    return savedElem;
                }
                se.setAttribute("SSecondaryX", Integer.toString(curx3));
                se.setAttribute("SSecondaryY", Integer.toString(cury));
                this.secondary.screen.setLocation(savex3, savey);
                this.elem.setAttribute("SSecondaryX", Integer.toString(savex3));
                this.elem.setAttribute("SSecondaryY", Integer.toString(savey));
                this.secondary.finish(this.graph, this.secondaryParent);
            }
            this.setInternalVariables();
            this.fireUndoPropertyEvent(null, null);
            return savedElem;
        }
        return super.undo(savedElem);
    }

    public void setAnchorPoint(Point2D p) {
        int lsize;
        if (this.anchor.type == 1) {
            double oldx = (Double)this.anchor.data[0];
            double oldy = (Double)this.anchor.data[1];
            if (oldx == p.getX() && oldy == p.getY()) {
                return;
            }
            if (this.listener != null) {
                Element e = this.elem.getOwnerDocument().createElement("Position");
                e.setAttribute("AnchorX", this.anchor.data[0].toString());
                e.setAttribute("AnchorY", this.anchor.data[1].toString());
                this.listener.actionPerformed(new SGActionEvent(this, e));
            }
            this.anchor.data[0] = new Double(p.getX());
            this.anchor.data[1] = new Double(p.getY());
            this.anchor.update(this.graph, this.parentID);
        } else {
            int oldx = (int)Math.round(this.anchor.screen.getX());
            int oldy = (int)Math.round(this.anchor.screen.getY());
            if (oldx == (int)p.getX() && oldy == (int)p.getY()) {
                return;
            }
            if (this.listener != null) {
                Element e = this.elem.getOwnerDocument().createElement("Position");
                e.setAttribute("SAnchorX", Integer.toString((int)Math.round(this.anchor.screen.getX())));
                e.setAttribute("SAnchorY", Integer.toString((int)Math.round(this.anchor.screen.getY())));
                this.listener.actionPerformed(new SGActionEvent(this, e));
            }
            this.anchor.screen.setLocation((int)Math.round(p.getX()), (int)Math.round(p.getY()));
            this.anchor.finish(this.graph, this.parentID);
        }
        this.setInternalVariables();
        if (this.elem != null) {
            this.elem.setAttribute("SAnchorX", Integer.toString((int)Math.round(this.anchor.screen.getX())));
            this.elem.setAttribute("SAnchorY", Integer.toString((int)Math.round(this.anchor.screen.getY())));
            this.elem.setAttribute("AnchorX", this.anchor.data[0].toString());
            this.elem.setAttribute("AnchorY", this.anchor.data[1].toString());
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "setAnchorPoint", null, p);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        this.savedAnchor = new Point((int)Math.round(this.anchor.screen.getX()), (int)Math.round(this.anchor.screen.getY()));
    }

    @Override
    protected Element _undo(Element savedElem) {
        String elemtag = savedElem.getTagName();
        boolean update = false;
        if (elemtag.equals("Position")) {
            int newy;
            int newx;
            int oldy;
            int oldx;
            Element e = this.elem.getOwnerDocument().createElement("Position");
            if (savedElem.hasAttribute("SAnchorX")) {
                oldx = (int)Math.round(this.anchor.screen.getX());
                oldy = (int)Math.round(this.anchor.screen.getY());
                newx = Integer.parseInt(savedElem.getAttribute("SAnchorX"));
                newy = Integer.parseInt(savedElem.getAttribute("SAnchorY"));
                if (oldx != newx || oldy != newy) {
                    update = true;
                    e.setAttribute("SAnchorX", Integer.toString(oldx));
                    e.setAttribute("SAnchorY", Integer.toString(oldy));
                }
                this.anchor.setPoint(new Point(newx, newy));
                this.anchor.finish(this.graph, this.parentID);
            }
            if (savedElem.hasAttribute("SSecondaryX")) {
                oldx = (int)Math.round(this.secondary.screen.getX());
                oldy = (int)Math.round(this.secondary.screen.getY());
                newx = Integer.parseInt(savedElem.getAttribute("SSecondaryX"));
                newy = Integer.parseInt(savedElem.getAttribute("SSecondaryY"));
                if (oldx != newx || oldy != newy) {
                    update = true;
                    e.setAttribute("SSecondaryX", Integer.toString(oldx));
                    e.setAttribute("SSecondaryY", Integer.toString(oldy));
                }
                this.secondary.setPoint(new Point(newx, newy));
                this.secondary.finish(this.graph, this.parentID);
            }
            if (update) {
                if (this.elem != null) {
                    this.elem.setAttribute("SAnchorX", Integer.toString((int)Math.round(this.anchor.screen.getX())));
                    this.elem.setAttribute("SAnchorY", Integer.toString((int)Math.round(this.anchor.screen.getY())));
                    this.elem.setAttribute("AnchorX", this.anchor.data[0].toString());
                    this.elem.setAttribute("AnchorY", this.anchor.data[1].toString());
                    this.elem.setAttribute("SSecondaryX", Integer.toString((int)Math.round(this.secondary.screen.getX())));
                    this.elem.setAttribute("SSecondaryY", Integer.toString((int)Math.round(this.secondary.screen.getY())));
                    this.elem.setAttribute("SecondaryX", this.secondary.data[0].toString());
                    this.elem.setAttribute("SecondaryY", this.secondary.data[1].toString());
                }
                return e;
            }
            return null;
        }
        return super._undo(savedElem);
    }

    @Override
    void finish() {
        if (this.building) {
            if (this.anchorAttachedToData && this.parentID != null) {
                this.anchor.setSpaceType(1);
            } else {
                this.anchor.setSpaceType(0);
            }
            if (this.secondaryAttachedToData && this.secondaryParent != null) {
                this.secondary.setSpaceType(1);
            } else {
                this.secondary.setSpaceType(0);
            }
            this.building = false;
        }
        this.anchor.finish(this.graph, this.parentID);
        this.secondary.finish(this.graph, this.secondaryParent);
        this.setInternalVariables();
        this.updateXMLNode();
        this.controlOn = false;
        this.shiftOn = false;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "finish", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        this.clip = this.clipOutside && this.anchor.type == 1 && this.secondary.type == 1 ? this.anGraph.getDataBoundingBox(this.parentID) : null;
    }

    @Override
    protected void updateXMLNode() {
        if (this.elem != null) {
            this.elem.setAttribute("SAnchorX", Integer.toString((int)Math.round(this.anchor.screen.getX())));
            this.elem.setAttribute("SAnchorY", Integer.toString((int)Math.round(this.anchor.screen.getY())));
            this.elem.setAttribute("SSecondaryX", Integer.toString((int)Math.round(this.secondary.screen.getX())));
            this.elem.setAttribute("SSecondaryY", Integer.toString((int)Math.round(this.secondary.screen.getY())));
            this.elem.setAttribute("AnchorX", this.anchor.data[0].toString());
            this.elem.setAttribute("AnchorY", this.anchor.data[1].toString());
            this.elem.setAttribute("SecondaryX", this.secondary.data[0].toString());
            this.elem.setAttribute("SecondaryY", this.secondary.data[1].toString());
            if (this.parentID != null) {
                this.elem.setAttribute("Parent", this.parentID);
            }
            if (this.secondaryParent != null) {
                this.elem.setAttribute("SecondaryParent", this.secondaryParent);
            }
            if (this.textPosition == 1) {
                this.elem.setAttribute("textPosition", "top");
            } else if (this.textPosition == 3) {
                this.elem.setAttribute("textPosition", "bottom");
            } else if (this.textPosition == 11) {
                this.elem.setAttribute("textPosition", "end");
            } else if (this.textPosition == 10) {
                this.elem.setAttribute("textPosition", "start");
            } else {
                this.elem.setAttribute("textPosition", "center");
            }
        }
    }

    @Override
    void update() {
        this.anchor.update(this.graph, this.parentID);
        this.secondary.update(this.graph, this.secondaryParent);
        this.setInternalVariables();
        this.updateXMLNode();
        this.clip = this.anchor.type == 1 && this.secondary.type == 1 && this.clipOutside ? this.anGraph.getDataBoundingBox(this.parentID) : null;
    }

    @Override
    protected Shape _drawBorderAndCaret(Graphics2D gc) {
        gc.setColor(Color.lightGray);
        gc.draw(this.handles[0]);
        Shape s = null;
        if (this.caretOn) {
            s = this._drawCaret(gc);
        }
        return s;
    }

    @Override
    void setInternalVariables() {
        boolean horzText;
        if (this.graph != null && this.annotate.isClipToScreenEnabled()) {
            double yo;
            double xo;
            double x1 = this.anchor.screen.getX();
            double x2 = this.secondary.screen.getX();
            double y1 = this.anchor.screen.getY();
            double y2 = this.secondary.screen.getY();
            Dimension d = this.graph.getAnnotationSize();
            if (x1 < 0.0 || x1 > (double)d.width || y1 < 0.0 || y1 > (double)d.height) {
                xo = Math.max(0.0, Math.min((double)d.width, x1));
                yo = Math.max(0.0, Math.min((double)d.height, y1));
                this.anchor.screen.setLocation(xo, yo);
                if (this.moveType == 10) {
                    this.secondary.screen.setLocation(x2 += xo - x1, y2 += yo - y1);
                }
                x1 = xo;
                y1 = yo;
            }
            if (x2 < 0.0 || x2 > (double)d.width || y2 < 0.0 || y2 > (double)d.height) {
                xo = Math.max(0.0, Math.min((double)d.width, x2));
                yo = Math.max(0.0, Math.min((double)d.height, y2));
                this.secondary.screen.setLocation(xo, yo);
                if (this.moveType == 10) {
                    this.anchor.screen.setLocation(x1 += xo - x2, y1 += yo - y2);
                }
                x2 = xo;
                y2 = yo;
            }
        }
        if (this.annotate.isDataValuesDirty()) {
            if (this.isAnchorAttachedToData()) {
                this.anchor.finish(this.graph, this.parentID);
            }
            if (this.isSecondaryAttachedToData()) {
                this.secondary.finish(this.graph, this.secondaryParent);
            }
        }
        this.at.setToIdentity();
        boolean bl = horzText = this.textPosition == 11 || this.textPosition == 10;
        if (this.text != null || this.caretOn) {
            this.checkTextLayout();
            this.wrappingWidth = this.textwrapping ? (float)Math.max((double)this.minTextWidth, this.anchor.screen.distance(this.secondary.screen) - 6.0) : 2.1474836E9f;
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            this.bounds = tl.getBounds();
            double twidth = tl.getAdvance() + 4.0f;
            double theight = 4.0f + tl.getAscent() + tl.getDescent() + tl.getLeading();
            int lineCount = 1;
            while ((tl = this.lbm.nextLayout(this.wrappingWidth)) != null) {
                theight += (double)(tl.getAscent() + tl.getDescent() + tl.getLeading());
                twidth = Math.max(twidth, tl.getBounds().getWidth());
                ++lineCount;
            }
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(this.wrappingWidth);
            if (horzText) {
                double ox;
                double oy;
                double ty;
                boolean centerVert;
                double y1;
                double x1;
                double y0;
                double x0;
                if (this.textPosition == 11) {
                    x0 = this.anchor.screen.getX();
                    y0 = this.anchor.screen.getY();
                    x1 = this.secondary.screen.getX();
                    y1 = this.secondary.screen.getY();
                } else {
                    x1 = this.anchor.screen.getX();
                    y1 = this.anchor.screen.getY();
                    x0 = this.secondary.screen.getX();
                    y0 = this.secondary.screen.getY();
                }
                double angle = Math.atan((y1 - y0) / (x1 - x0));
                double degrees = Math.abs(Math.toDegrees(angle));
                boolean centerHorz = degrees < 10.0;
                boolean bl2 = centerVert = degrees > 80.0;
                if (centerHorz) {
                    ty = y1 - theight / 2.0 + (double)tl.getAscent() + 2.0;
                    oy = y1 - theight / 2.0;
                } else if (y0 > y1) {
                    ty = y1 - theight + (double)tl.getAscent() + 2.0;
                    oy = y1 - theight;
                } else {
                    ty = y1 + (double)tl.getAscent() + 2.0;
                    oy = y1;
                }
                if (centerVert) {
                    this.align = 0;
                    if (this.text == null) {
                        double tx = this.bounds.getX() + x1;
                        ox = tx - (double)(this.minTextWidth / 2);
                        this.outside.setRect(ox, oy, this.minTextWidth + 6, theight);
                        this.textAnchor.setLocation(tx, ty);
                    } else if ((double)this.minTextWidth > twidth) {
                        double tx = this.bounds.getX() + x1 - twidth / 2.0;
                        ox = this.bounds.getX() + x1 - (double)(this.minTextWidth / 2) - 2.0;
                        this.outside.setRect(ox, oy, this.minTextWidth + 2, theight);
                        this.textAnchor.setLocation(tx, ty);
                    } else {
                        double tx = this.bounds.getX() + x1 - twidth / 2.0;
                        ox = this.bounds.getX() + x1 - twidth / 2.0 - 2.0;
                        this.outside.setRect(ox, oy, twidth, theight);
                        this.textAnchor.setLocation(tx, ty);
                    }
                } else if (x0 > x1) {
                    this.align = 4;
                    if (this.text == null) {
                        double tx = this.bounds.getX() + x1 - 2.0;
                        ox = tx - (double)this.minTextWidth;
                        this.outside.setRect(ox, oy, this.minTextWidth + 6, theight);
                        this.textAnchor.setLocation(tx, ty);
                    } else if ((double)this.minTextWidth > twidth) {
                        double tx = this.bounds.getX() + x1 - twidth;
                        ox = this.bounds.getX() + x1 - (double)this.minTextWidth - 2.0;
                        this.outside.setRect(ox, oy, this.minTextWidth + 2, theight);
                        this.textAnchor.setLocation(tx, ty);
                    } else {
                        double tx = this.bounds.getX() + x1 - twidth;
                        ox = this.bounds.getX() + x1 - twidth - 2.0;
                        this.outside.setRect(ox, oy, twidth, theight);
                        this.textAnchor.setLocation(tx, ty);
                    }
                } else {
                    this.align = 2;
                    double tx = this.bounds.getX() + x1 + 2.0;
                    this.textAnchor.setLocation(tx, ty);
                    ox = tx - 2.0;
                    if (this.text == null || (double)this.minTextWidth > twidth) {
                        this.outside.setRect(ox, oy, this.minTextWidth + 2, theight);
                    } else {
                        this.outside.setRect(ox, oy, twidth, theight);
                    }
                }
            } else {
                double x1 = this.anchor.screen.getX();
                double x2 = this.secondary.screen.getX();
                double y1 = this.anchor.screen.getY();
                double y2 = this.secondary.screen.getY();
                double midx = (x1 + x2) / 2.0;
                double midy = (y1 + y2) / 2.0;
                if (this.text == null || twidth < (double)this.minTextWidth && this.caretOn) {
                    double tx = midx - (double)(this.minTextWidth / 2) - 2.0 + this.bounds.getX();
                    double ty = midy - theight / 2.0;
                    if (this.textPosition == 1) {
                        ty -= theight;
                    } else if (this.textPosition == 3) {
                        ty += theight;
                    }
                    this.outside.setRect(tx, ty, this.minTextWidth + 2, theight);
                    if (this.text == null) {
                        this.textAnchor.setLocation(midx - 2.0, ty + (double)tl.getAscent() + 2.0);
                        this.innerBounds.setRect(midx - 2.0, ty + 2.0, 2.0, theight - 4.0);
                    } else {
                        this.textAnchor.setLocation(midx - twidth / 2.0 + 2.0, ty + (double)tl.getAscent() + 2.0);
                        this.innerBounds.setRect(midx + (double)(this.minTextWidth / 2) - twidth / 2.0 - 2.0, ty + 2.0, twidth - 4.0, theight - 4.0);
                    }
                } else {
                    double tx = this.bounds.getX() + midx - twidth / 2.0 - 2.0;
                    double ty = midy - theight / 2.0;
                    if (this.textPosition == 1) {
                        ty -= theight;
                    } else if (this.textPosition == 3) {
                        ty += theight;
                    }
                    this.outside.setRect(tx, ty, twidth, theight);
                    this.textAnchor.setLocation(tx - this.bounds.getX() + 2.0, ty + (double)tl.getAscent() + 2.0);
                    if (lineCount > 1) {
                        this.innerBounds.setRect(midx - (double)(this.wrappingWidth / 2.0f), ty + 2.0, this.wrappingWidth, theight - 4.0);
                    } else {
                        this.innerBounds.setRect(tx + 2.0, ty + 2.0, twidth - 4.0, theight - 4.0);
                    }
                }
                double rot = x2 > x1 ? Math.atan2(y2 - y1, x2 - x1) : Math.atan2(y1 - y2, x1 - x2);
                this.at.rotate(rot, midx, midy);
            }
        } else if (!(this.caretOn || this.text != null && this.text.length() != 0)) {
            this.bounds = null;
            this.innerBounds.setRect(0.0, 0.0, 0.0, 0.0);
            this.outside.setRect(0.0, 0.0, 0.0, 0.0);
        }
        this.createHandles();
        this.shape = new Line2D.Double(this.anchor.screen.getX(), this.anchor.screen.getY(), this.secondary.screen.getX(), this.secondary.screen.getY());
    }

    @Override
    public boolean isFillOn() {
        return false;
    }

    @Override
    public boolean isLineOn() {
        return true;
    }

    Line2D getLine() {
        return (Line2D)this.shape;
    }

    @Override
    void createHandles() {
        double ax = this.anchor.screen.getX();
        double ay = this.anchor.screen.getY();
        double sx = this.secondary.screen.getX();
        double sy = this.secondary.screen.getY();
        if (this.handles == null) {
            this.handles = new Shape[3];
            this.handles[0] = this.outside;
            this.handles[1] = new Ellipse2D.Double();
            this.handles[2] = new Ellipse2D.Double();
        }
        ((Ellipse2D)this.handles[1]).setFrameFromCenter(ax, ay, ax - 4.0, ay - 4.0);
        ((Ellipse2D)this.handles[2]).setFrameFromCenter(sx, sy, sx + 4.0, sy + 4.0);
    }

    @Override
    int getHandleAt(int x, int y) {
        if (this.handles == null) {
            this.createHandles();
        }
        if (this.handles[1].contains(x, y)) {
            return 0;
        }
        if (this.handles[2].contains(x, y)) {
            return 4;
        }
        if (this.handles[0].contains(x, y)) {
            return 9;
        }
        if (((Line2D)this.shape).ptLineDist(x, y) < 2.0) {
            return 10;
        }
        return -1;
    }

    @Override
    void move(int moveType, int x, int y) {
        this.moveType = moveType;
        switch (moveType) {
            default: {
                break;
            }
            case 9: {
                super.move(moveType, x, y);
                return;
            }
            case 0: {
                double yo;
                double xo;
                this.anchor.move(x + this.dx, y + this.dy);
                if (this.controlOn) {
                    this.secondary.move(-x - this.dx, -y - this.dy);
                    xo = (this.anchor.screen.getX() + this.secondary.screen.getX()) / 2.0;
                    yo = (this.anchor.screen.getY() + this.secondary.screen.getY()) / 2.0;
                } else {
                    xo = this.secondary.screen.getX();
                    yo = this.secondary.screen.getY();
                }
                if (!this.shiftOn) break;
                double actx = this.anchor.screen.getX();
                double acty = this.anchor.screen.getY();
                double dist = this.anchor.screen.distance(xo, yo);
                double angle = Math.toDegrees(Math.atan2(this.anchor.screen.getY() - yo, this.anchor.screen.getX() - xo));
                double modangle = Math.round(angle / 15.0) * 15L;
                double x1 = dist * Math.cos(Math.toRadians(modangle));
                double y1 = dist * Math.sin(Math.toRadians(modangle));
                this.anchor.screen.setLocation(xo + x1, yo + y1);
                this.dx = (int)Math.round(actx - this.anchor.screen.getX());
                this.dy = (int)Math.round(acty - this.anchor.screen.getY());
                if (!this.controlOn) break;
                this.secondary.screen.setLocation(xo - x1, yo - y1);
                break;
            }
            case 4: {
                double yo;
                double xo;
                this.secondary.move(x + this.dx, y + this.dy);
                if (this.controlOn) {
                    this.anchor.move(-x - this.dx, -y - this.dy);
                    xo = (this.anchor.screen.getX() + this.secondary.screen.getX()) / 2.0;
                    yo = (this.anchor.screen.getY() + this.secondary.screen.getY()) / 2.0;
                } else {
                    xo = this.anchor.screen.getX();
                    yo = this.anchor.screen.getY();
                }
                if (!this.shiftOn) break;
                double actx = this.secondary.screen.getX();
                double acty = this.secondary.screen.getY();
                double dist = this.secondary.screen.distance(xo, yo);
                double angle = Math.toDegrees(Math.atan2(this.secondary.screen.getY() - yo, this.secondary.screen.getX() - xo));
                double modangle = Math.round(angle / 15.0) * 15L;
                double x1 = dist * Math.cos(Math.toRadians(modangle));
                double y1 = dist * Math.sin(Math.toRadians(modangle));
                this.secondary.screen.setLocation(xo + x1, yo + y1);
                this.dx = (int)Math.round(actx - this.secondary.screen.getX());
                this.dy = (int)Math.round(acty - this.secondary.screen.getY());
                if (!this.controlOn) break;
                this.anchor.screen.setLocation(xo - x1, yo - y1);
                break;
            }
            case 10: {
                this.anchor.move(x, y);
                this.secondary.move(x, y);
            }
        }
        if (moveType == 9) {
            this.prevx += x;
            this.prevy += y;
            this.setCaretPosition(this.prevx, this.prevy);
        } else if (!this.finishingMove) {
            this.setInternalVariables();
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    void finishMove(int moveType, int x, int y) {
        this.finishingMove = true;
        this.move(moveType, x, y);
        if (moveType != 9) {
            this.finish();
            this.createHandles();
        }
        this.finishingMove = false;
        this.dy = 0;
        this.dx = 0;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "finishMove", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public boolean isSelected(int x, int y) {
        double distance;
        this.createHandles();
        Rectangle bounds = ((Line2D)this.shape).getBounds();
        if (bounds.width == 0) {
            --bounds.x;
            bounds.width = 2;
        }
        if (bounds.height == 0) {
            --bounds.y;
            bounds.height = 2;
        }
        if (bounds.contains(x, y) && (distance = ((Line2D)this.shape).ptLineDist(x, y)) > -2.0 && distance <= 2.0) {
            return true;
        }
        for (int i = 0; i < this.handles.length; ++i) {
            if (!this.handles[i].contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    void resetPoint(Point p) {
        double yo;
        double xo;
        if (this.controlOn) {
            double ax = this.anchor.screen.getX();
            double ay = this.anchor.screen.getY();
            double sx = this.secondary.screen.getX();
            double sy = this.secondary.screen.getY();
            xo = (ax + sx) / 2.0;
            yo = (ay + sy) / 2.0;
            this.anchor.screen.setLocation(ax - (p.getX() - sx), ay - (p.getY() - sy));
        } else {
            xo = this.anchor.screen.getX();
            yo = this.anchor.screen.getY();
        }
        this.secondary.setPoint(p);
        if (this.shiftOn) {
            double dist = this.secondary.screen.distance(xo, yo);
            double angle = Math.toDegrees(Math.atan2(this.secondary.screen.getY() - yo, this.secondary.screen.getX() - xo));
            double modangle = Math.round(angle / 15.0) * 15L;
            double x1 = dist * Math.cos(Math.toRadians(modangle));
            double y1 = dist * Math.sin(Math.toRadians(modangle));
            this.secondary.screen.setLocation(xo + x1, yo + y1);
            if (this.controlOn) {
                this.anchor.screen.setLocation(xo - x1, yo - y1);
            }
        }
        if (this.anGraph != null) {
            int sx = (int)Math.round(this.secondary.screen.getX());
            int sy = (int)Math.round(this.secondary.screen.getY());
            this.secondaryParent = this.anGraph.getGraphIDAt(sx, sy);
        }
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    void load(Element aElem, boolean loadOnly) {
        super.load(aElem, false);
        if (this.anGraph == null) {
            if (this.elem.hasAttribute("SecondaryParent")) {
                this.elem.removeAttribute("SecondaryParent");
            }
            if (this.elem.hasAttribute("SecondaryAttachedToData")) {
                this.elem.removeAttribute("SecondaryAttachedToData");
            }
            this.secondaryAttachedToData = false;
        } else {
            if (this.elem.hasAttribute("SecondaryParent")) {
                this.secondaryParent = this.elem.getAttribute("SecondaryParent");
                if (this.secondaryParent != null && this.secondaryParent.length() == 0) {
                    this.secondaryParent = null;
                }
            }
            boolean bl = this.elem.hasAttribute("SecondaryAttachedToData") ? "true".equalsIgnoreCase(this.elem.getAttribute("SecondaryAttachedToData")) : (this.secondaryAttachedToData = this.secondaryParent != null);
            if (this.anchorAttachedToData != this.secondaryAttachedToData || this.secondaryAttachedToData && this.secondaryParent != null && !this.secondaryParent.equals(this.parentID)) {
                if (!this.secondaryAttachedToData || this.secondaryParent == null) {
                    double x = Double.parseDouble(this.elem.getAttribute("SSecondaryX"));
                    double y = Double.parseDouble(this.elem.getAttribute("SSecondaryY"));
                    this.secondary = new AnnotatePoint(new Point2D.Double(x, y));
                    this.secondary.setSpaceType(0);
                } else {
                    double x = Double.parseDouble(this.elem.getAttribute("SecondaryX"));
                    double y = Double.parseDouble(this.elem.getAttribute("SecondaryY"));
                    Object[] pt = new Double[]{new Double(x), new Double(y)};
                    this.secondary = new AnnotatePoint((Annotatable)this.graph, this.secondaryParent, pt);
                }
            }
        }
        this.style.setFillOn(false);
        this.style.setLineOn(true);
        this.rotation = 0.0;
        if (loadOnly) {
            this.elem = null;
        }
    }

    @Override
    void paint(Graphics2D gc) {
        Shape prevClip = gc.getClip();
        if (this.clip != null && this.clipOutside) {
            if (prevClip == null) {
                gc.setClip(this.clip);
            } else {
                gc.setClip(this.clip.getBounds2D().createIntersection(prevClip.getBounds2D()));
            }
        }
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        boolean horzText = this.textPosition == 11 || this.textPosition == 10;
        AffineTransform save = gc.getTransform();
        Stroke saveStroke = gc.getStroke();
        gc.setStroke(this.stroke);
        Font f2 = this.scaledFont(this.textStyle.getFont());
        gc.setFont(f2);
        if (this.frc == null) {
            this.frc = gc.getFontRenderContext();
            this.lbm = null;
        }
        gc.setColor(this.style.getLineColor());
        if (!horzText) {
            if ((this.text != null && this.text.length() > 0 || this.caretOn) && this.outside != null && this.outside.getWidth() > 0.0) {
                Rectangle cp = gc.getClipBounds();
                GeneralPath gp = new GeneralPath(0);
                if (cp == null) {
                    double x1 = Math.min(this.anchor.screen.getX(), this.secondary.screen.getX());
                    double x2 = Math.max(this.anchor.screen.getX(), this.secondary.screen.getX());
                    double y1 = Math.min(this.anchor.screen.getY(), this.secondary.screen.getY());
                    double y2 = Math.max(this.anchor.screen.getY(), this.secondary.screen.getY());
                    Rectangle2D.Double rr = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
                    gp.append(rr, false);
                } else {
                    gp.append(cp, false);
                }
                Shape ncp = this.at.createTransformedShape(this.outside);
                gp.append(ncp, false);
                gc.setClip(gp);
                if (this.clip != null && this.clipOutside) {
                    gc.clip(this.clip);
                }
                this.drawShape(gc);
                gc.setClip(cp);
            } else {
                this.drawShape(gc);
            }
            gc.transform(this.at);
        } else {
            this.drawShape(gc);
        }
        Color cc = this.textStyle.getFontColor();
        if (this.text != null && !this.text.equals("")) {
            boolean extsel;
            this.as = new AttributedString(this.text);
            this.as.addAttribute(TextAttribute.FONT, f2);
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            boolean bl = extsel = this.caretPosition != this.selectAnchor && this.selectAnchor != -1;
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, selectedTextColor);
            }
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            if (this.caretOn) {
                this._drawCaret(gc);
            }
            gc.setColor(cc);
            float tx = (float)this.textAnchor.getX();
            float ty = (float)this.textAnchor.getY();
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            tl.draw(gc, tx, ty);
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textStyle.getFontColor());
                this.lbm = null;
            }
        } else if (this.caretOn) {
            this._drawBorderAndCaret(gc);
        }
        if (!horzText) {
            gc.setTransform(save);
        }
        gc.setStroke(saveStroke);
        gc.setClip(prevClip);
    }

    @Override
    public void setAnchorAttachedToData(boolean flag) {
        Boolean oldValue;
        Boolean bl = oldValue = this.anchorAttachedToData ? Boolean.TRUE : Boolean.FALSE;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("AttachedToData");
            e.setAttribute("anchor", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.anchorAttachedToData = flag;
        this.anchor.setSpaceType(this.anchorAttachedToData ? 1 : 0);
        this.anchor.finish(this.graph, this.parentID);
        if (this.elem != null) {
            this.elem.setAttribute("AnchorAttachedToData", Boolean.toString(flag));
        }
        this.clip = this.anchor.type == 1 && this.secondary.type == 1 && this.clipOutside ? this.anGraph.getDataBoundingBox(this.parentID) : null;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "setAnchorAttachedToData", oldValue, new Boolean(flag));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public boolean canSecondaryAttachedToData() {
        return this.secondaryParent != null;
    }

    @Override
    public boolean isSecondaryAttachedToData() {
        return this.secondaryAttachedToData && this.secondaryParent != null;
    }

    @Override
    public void setSecondaryAttachedToData(boolean flag) {
        Boolean oldValue;
        Boolean bl = oldValue = this.secondaryAttachedToData ? Boolean.TRUE : Boolean.FALSE;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("AttachedToData");
            e.setAttribute("secondary", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.secondaryAttachedToData = flag;
        this.secondary.setSpaceType(this.secondaryAttachedToData ? 1 : 0);
        this.secondary.finish(this.graph, this.secondaryParent);
        if (this.elem != null) {
            this.elem.setAttribute("SecondaryAttachedToData", Boolean.toString(flag));
        }
        this.clip = this.anchor.type == 1 && this.secondary.type == 1 && this.clipOutside ? this.anGraph.getDataBoundingBox(this.parentID) : null;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "setSecondaryAttachedToData", oldValue, new Boolean(flag));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public String getSecondaryParent() {
        return this.secondaryParent;
    }

    public String getParent() {
        return this.parentID;
    }

    public void setSecondaryParent(String newParent) {
        this.secondaryAttachedToData = this.elem.hasAttribute("SecondaryAttachedToData") ? "true".equalsIgnoreCase(this.elem.getAttribute("SecondaryAttachedToData")) : newParent != null;
        this.secondaryParent = newParent;
        if (this.secondaryParent == null || !this.secondaryAttachedToData) {
            this.secondary.setSpaceType(0);
            this.clip = null;
            if (this.building) {
                return;
            }
            this.elem.setAttribute("SSecondaryX", Integer.toString((int)Math.round(this.secondary.screen.getX())));
            this.elem.setAttribute("SSecondaryY", Integer.toString((int)Math.round(this.secondary.screen.getY())));
        } else {
            this.secondary.setSpaceType(1);
            if (this.clipOutside && this.parentID != null && this.anchorAttachedToData && this.parentID.equals(this.secondaryParent)) {
                this.clip = this.anGraph.getDataBoundingBox(this.parentID);
            }
            if (this.building) {
                return;
            }
            this.secondary.update(this.graph, this.secondaryParent);
            this.elem.setAttribute("SecondaryX", this.secondary.data[0].toString());
            this.elem.setAttribute("SecondaryY", this.secondary.data[1].toString());
        }
        if (this.elem != null) {
            this.elem.setAttribute("SecondaryParent", this.secondaryParent);
        }
    }

    @Override
    public void setParent(String newParent) {
        this.anchorAttachedToData = this.elem.hasAttribute("AnchorAttachedToData") ? "true".equalsIgnoreCase(this.elem.getAttribute("AnchorAttachedToData")) : newParent != null;
        this.parentID = newParent;
        if (this.parentID == null || !this.anchorAttachedToData) {
            this.anchor.setSpaceType(0);
            this.clip = null;
            if (this.building) {
                return;
            }
            this.elem.setAttribute("SAnchorX", Integer.toString((int)Math.round(this.anchor.screen.getX())));
            this.elem.setAttribute("SAnchorY", Integer.toString((int)Math.round(this.anchor.screen.getY())));
        } else {
            this.anchor.setSpaceType(1);
            if (this.clipOutside && this.secondaryParent != null && this.secondaryAttachedToData) {
                this.clip = this.anGraph.getDataBoundingBox(this.parentID);
            }
            if (this.building) {
                return;
            }
            this.anchor.update(this.graph, this.parentID);
            this.elem.setAttribute("AnchorX", this.anchor.data[0].toString());
            this.elem.setAttribute("AnchorY", this.anchor.data[1].toString());
        }
        if (this.elem != null) {
            this.elem.setAttribute("Parent", this.parentID);
        }
    }

    @Override
    public boolean intersects(AnnotateElement ae) {
        Rectangle2D r1 = ae.outside;
        if (this.shape.intersects(r1) || this.outside.intersects(r1) || ae.shape.intersects(this.outside)) {
            return true;
        }
        if (ae instanceof EllipseElement) {
            return ae.shape.intersects(this.shape.getBounds2D()) && this.shape.intersects(ae.shape.getBounds2D());
        }
        if (ae instanceof RectangleElement) {
            Rectangle2D r2 = ae.shape.getBounds2D();
            return this.shape.intersects(r2);
        }
        if (ae instanceof EllipseElement) {
            double y2;
            double x2;
            double y1;
            Ellipse2D ellipse = ((EllipseElement)ae).getEllipse();
            double width = ellipse.getWidth();
            double scale = width / ellipse.getHeight();
            double ptX = ellipse.getCenterX();
            double ptY = scale * ellipse.getCenterY();
            double x1 = this.anchor.screen.getX();
            double distance = Line2D.ptLineDist(x1, y1 = scale * this.anchor.screen.getY(), x2 = this.secondary.screen.getX(), y2 = scale * this.secondary.screen.getY(), ptX, ptY);
            return distance < width / 2.0;
        }
        return false;
    }

    @Override
    void drawHandles(Graphics2D gc, Color color) {
        int i;
        gc.setColor(Color.white);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.fill(this.handles[i]);
        }
        gc.setColor(color);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.draw(this.handles[i]);
        }
    }

    @Override
    void drawHandles(Graphics2D gc) {
        int i;
        Stroke stroke = gc.getStroke();
        gc.setColor(Color.white);
        gc.setStroke(elemBorder);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.fill(this.handles[i]);
        }
        gc.setColor(Color.lightGray);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.draw(this.handles[i]);
        }
        gc.setStroke(stroke);
    }

    protected void drawShape(Graphics2D gc) {
        gc.draw(this.shape);
    }

    @Override
    public final void setFillColor(Color c) {
    }

    @Override
    public final void setFillColor(Color c, int alpha) {
    }

    @Override
    public final void setClipOutsideDataOn(boolean flag) {
        int lsize;
        Boolean oldValue;
        Boolean bl = oldValue = this.clipOutside ? Boolean.TRUE : Boolean.FALSE;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("ClipOutside");
            e.setAttribute("clip", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.clipOutside = flag;
        if (!flag) {
            this.clip = null;
        } else if (this.anchor.type == 1 && this.secondary.type == 1) {
            this.clip = this.anGraph.getDataBoundingBox(this.parentID);
        }
        if (this.elem != null) {
            this.elem.setAttribute("ClipOutside", Boolean.toString(flag));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "clipOutsideDataOn", oldValue, new Boolean(flag));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void setFillOn(boolean fill) {
    }

    @Override
    public final void setLineOn(boolean line) {
    }

    @Override
    public final void setRotationAngle(double angleInDegrees) {
    }

    @Override
    public Rectangle getScreenBounds() {
        Rectangle r;
        Rectangle rectangle = r = this.shape != null ? this.shape.getBounds() : new Rectangle();
        if (this.text != null && this.text.length() > 0) {
            r = r.union(this.handles[0].getBounds());
        }
        return r;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle r;
        Rectangle rectangle = r = this.shape != null ? this.shape.getBounds() : new Rectangle();
        if (this.text != null && this.text.length() > 0) {
            r = r.union(this.handles[0].getBounds());
        }
        if (this.anchorAttachedToData) {
            Point p1 = new Point(r.x, r.y);
            Point p2 = new Point(r.x + r.width, r.y + r.height);
            Object[] d1 = new Double[2];
            Object[] d2 = new Double[2];
            d1 = ((Annotatable)this.graph).convertScreenToData(this.parentID, p1, d1);
            d2 = ((Annotatable)this.graph).convertScreenToData(this.parentID, p2, d2);
            double x1 = (Double)d1[0];
            double x2 = (Double)d2[0];
            double y1 = (Double)d1[1];
            double y2 = (Double)d2[1];
            double xo = Math.min(x1, x2);
            double yo = Math.min(y1, y2);
            double ww = Math.abs(x2 - x1);
            double hh = Math.abs(y2 - y1);
            return new Rectangle2D.Double(xo, yo, ww, hh);
        }
        return r;
    }
}

