/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.util.Util;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.RectangleElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class ImageElement
extends RectangleElement
implements ImageObserver {
    String file;
    Image image;
    Image gimage;
    double imwidth;
    double imheight;
    double curwidth;
    double curheight;
    private Graphics2D g2c;
    private boolean loading = false;
    private boolean invalidFile = false;
    private AffineTransform imat = new AffineTransform();
    private boolean greyscale = false;
    JComponent c = null;

    ImageElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent, String file) {
        super(annotate, graph, x, null, parent);
        this.file = file;
        this.init(node, parent);
    }

    private void init(Element node, String parent) {
        this.areaAttrsEnabled = false;
        if (this.image != null) {
            this.imwidth = this.width = (double)this.image.getWidth(this);
            this.imheight = this.height = (double)this.image.getHeight(this);
            this.loading = this.imwidth == -1.0 || this.imheight == -1.0;
            Point p = new Point((int)(this.anchor.screen.getX() + this.width), (int)(this.anchor.screen.getY() + this.height));
            this.resetPoint(p);
        } else if (this.file != null) {
            this.loadFile();
        }
        this.textPosition = 3;
        this.style.setLineOn(false);
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("ImageElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
            if (this.file != null) {
                this.elem.setAttribute("File", this.file);
            }
            this.elem.setAttribute("TextPosition", "bottom");
            this.elem.setAttribute("line", "false");
            this.elem.setAttribute("fill", "false");
        }
    }

    ImageElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent, String file, Image im) {
        super(annotate, graph, x, null, parent);
        this.file = file;
        this.image = im;
        this.init(node, parent);
    }

    ImageElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent, String file) {
        super(annotate, graph, x, null, parent);
        this.file = file;
        this.init(node, parent);
    }

    ImageElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent, String file, Image im) {
        super(annotate, graph, x, null, parent);
        this.file = file;
        this.image = im;
        this.init(node, parent);
    }

    private void loadFile() {
        File f = null;
        int index = this.file.lastIndexOf(File.separator);
        if (index > 0 && index < this.file.length()) {
            String name = this.file.substring(index + 1);
            f = new File(name);
        }
        if (f == null || !f.exists()) {
            f = new File(this.file);
        }
        FileImageInputStream imageInput = null;
        try {
            imageInput = new FileImageInputStream(f);
            Iterator<ImageReader> it = ImageIO.getImageReaders(imageInput);
            if (!it.hasNext()) {
                this.width = 24.0;
                this.imwidth = 24.0;
                this.height = 24.0;
                this.imheight = 24.0;
                this.image = Util.getImage(null, "a_blank.gif");
                this.image = this.image.getScaledInstance((int)this.imwidth, (int)this.imheight, 2);
                Point p = new Point((int)(this.anchor.screen.getX() + this.width), (int)(this.anchor.screen.getY() + this.height));
                this.resetPoint(p);
                this.invalidFile = true;
                return;
            }
            ImageReader reader = null;
            while (it.hasNext()) {
                reader = it.next();
            }
            reader.setInput(imageInput);
            this.image = reader.read(0);
            reader.dispose();
            this.imwidth = this.width = (double)this.image.getWidth(this);
            this.imheight = this.height = (double)this.image.getHeight(this);
            this.loading = this.imwidth == -1.0 || this.imheight == -1.0;
            Point p = new Point((int)(this.anchor.screen.getX() + this.width), (int)(this.anchor.screen.getY() + this.height));
            this.resetPoint(p);
            imageInput.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void loadFileWithoutUpdate() {
        File f = new File(this.file);
        FileImageInputStream imageInput = null;
        boolean secondTime = false;
        while (true) {
            try {
                imageInput = new FileImageInputStream(f);
                Iterator<ImageReader> it = ImageIO.getImageReaders(imageInput);
                if (!it.hasNext()) {
                    return;
                }
                ImageReader reader = null;
                while (it.hasNext()) {
                    reader = it.next();
                }
                reader.setInput(imageInput);
                this.image = reader.read(0);
                reader.dispose();
                this.imwidth = this.image.getWidth(this);
                this.imheight = this.image.getHeight(this);
                imageInput.close();
            }
            catch (Exception e) {
                if (!secondTime) {
                    System.out.println(System.getProperty("user.dir"));
                    f = new File(System.getProperty("user.dir"), this.file);
                    secondTime = true;
                    continue;
                }
                int x1 = Integer.parseInt(this.elem.getAttribute("SAnchorX"));
                int y1 = Integer.parseInt(this.elem.getAttribute("SAnchorY"));
                int x2 = Integer.parseInt(this.elem.getAttribute("SSecondaryX"));
                int y2 = Integer.parseInt(this.elem.getAttribute("SSecondaryY"));
                this.imwidth = x2 - x1;
                this.imheight = y2 - y1;
                this.image = Util.getImage(null, "a_blank.gif");
                this.image = this.image.getScaledInstance((int)this.imwidth, (int)this.imheight, 2);
                System.out.println(e.getMessage());
                this.invalidFile = true;
            }
            break;
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int ix, int iy, int iwidth, int iheight) {
        if ((infoflags & 2) == 0 || (infoflags & 1) == 0) {
            return true;
        }
        if (this.loading) {
            this.width = this.imwidth = (double)iwidth;
            this.height = this.imheight = (double)iheight;
            Point p = new Point((int)this.anchor.screen.getX() + iwidth, (int)this.anchor.screen.getY() + iheight);
            this.resetPoint(p);
            this.loading = false;
        }
        if (this.g2c != null) {
            this.g2c.drawImage(this.image, this.at, null);
            this.g2c = null;
        }
        return false;
    }

    @Override
    void load(Element aElem, boolean loadOnly) {
        super.load(aElem, loadOnly);
        this.file = aElem.getAttribute("File");
        if (this.file != null && !this.file.equals("")) {
            this.loadFileWithoutUpdate();
        }
        this.width = Math.abs(this.secondary.screen.getX() - this.anchor.screen.getX());
        this.height = Math.abs(this.secondary.screen.getY() - this.anchor.screen.getY());
    }

    @Override
    void paint(Graphics2D gc) {
        this.g2c = gc;
        Shape prevClip = gc.getClip();
        if (this.parentID != null && this.clip != null && this.clipOutside) {
            if (prevClip == null) {
                gc.setClip(this.clip);
            } else {
                gc.setClip(this.clip.getBounds2D().createIntersection(prevClip.getBounds2D()));
            }
        }
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        gc.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        AffineTransform save = gc.getTransform();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        this.imat.setToIdentity();
        this.imat.translate(this.x, this.y);
        this.imat.scale(this.width / this.imwidth, this.height / this.imheight);
        if (this.greyscale) {
            if (this.gimage == null) {
                this.createGreyscaleImage(this.c);
            }
            gc.drawImage(this.gimage, this.imat, this);
        } else {
            gc.drawImage(this.image, this.imat, this);
        }
        if (this.invalidFile) {
            gc.setColor(this.style.getFillColor());
            gc.fill(this.shape);
            gc.setColor(Color.red);
            FontMetrics fm = gc.getFontMetrics();
            int sz = fm.getAscent();
            int x0 = (int)(this.x + (double)(sz / 2));
            int y0 = (int)(this.y + (double)(sz / 2));
            gc.drawLine(x0, y0, x0 + sz / 2, y0 + sz / 2);
            gc.drawLine(x0 + sz / 2, y0, x0, y0 + sz / 2);
            gc.setColor(this.textStyle.getFontColor());
            x0 = (int)(this.x + (double)(sz / 2));
            gc.drawString(this.file, x0, (int)(this.y + 2.2 * (double)sz));
        }
        Stroke saveStroke = gc.getStroke();
        gc.setStroke(this.stroke);
        Font f2 = this.scaledFont(this.textStyle.getFont());
        gc.setFont(f2);
        if (this.frc == null) {
            this.frc = gc.getFontRenderContext();
            this.lbm = null;
        }
        if (this.style.isLineOn() || this.invalidFile) {
            gc.setColor(this.style.getLineColor());
            gc.draw(this.shape);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        if (this.text != null && this.text.length() > 0) {
            boolean extsel;
            if (this.lbm == null) {
                this.checkTextLayout();
            }
            boolean bl = extsel = this.caretPosition != this.selectAnchor && this.selectAnchor != -1;
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, selectedTextColor);
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            } else if (this.rotation != 0.0) {
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            }
            if (this.caretOn) {
                this._drawBorderAndCaret(gc);
            }
            float tx = (float)this.textAnchor.getX();
            float ty = (float)this.textAnchor.getY();
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            if (this.textwrapping) {
                while (true) {
                    float start = this._getTextAnchor(tl);
                    tl.draw(gc, start, ty);
                    ty += tl.getDescent() + tl.getLeading();
                    tl = this.lbm.nextLayout(this.wrappingWidth);
                    if (tl != null) {
                        ty += tl.getAscent();
                        continue;
                    }
                    break;
                }
            } else {
                tl.draw(gc, tx, ty);
            }
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textStyle.getFontColor());
                this.lbm = null;
            }
        } else if (this.caretOn) {
            this._drawBorderAndCaret(gc);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        gc.setStroke(saveStroke);
        gc.setClip(prevClip);
    }

    boolean needReset() {
        return this.width != this.imwidth || this.height != this.imheight || this.rotation != 0.0;
    }

    void reset() {
        int dx = (int)(this.width - this.imwidth);
        int dy = (int)(this.height - this.imheight);
        this.secondary.move(-dx, -dy);
        this.rotation = 0.0;
        if (this.elem.hasAttribute("Rotation")) {
            this.elem.setAttribute("Rotation", Double.toString(this.rotation));
        }
        this.finish();
        this.createHandles();
    }

    boolean isGreyscale() {
        return this.greyscale;
    }

    void setGreyscale(JComponent c, boolean trueOrFalse) {
        this.greyscale = trueOrFalse;
        if (this.gimage == null) {
            this.createGreyscaleImage(c);
        }
    }

    private void createGreyscaleImage(JComponent cc) {
        this.c = cc;
    }

    @Override
    public final void setFillColor(Color c) {
    }

    @Override
    public final void setFillColor(Color c, int alpha) {
    }

    @Override
    public final void setFillOn(boolean fill) {
    }

    @Override
    protected Element _undo(Element savedElem) {
        String elemtag = savedElem.getTagName();
        if ("Line".equals(elemtag)) {
            Element e = this.elem.getOwnerDocument().createElement("Line");
            String newValue = savedElem.hasAttribute("line") ? savedElem.getAttribute("line") : "";
            String oldValue = "";
            if (this.elem.hasAttribute("line")) {
                oldValue = this.elem.getAttribute("line");
                e.setAttribute("line", oldValue);
            }
            if (newValue.equals("")) {
                newValue = "false";
            }
            this.style.setLineOn(newValue.toLowerCase().equals("true"));
            if (this.stroke == null) {
                this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
            }
            return e;
        }
        if ("TextPosition".equals(elemtag)) {
            if (savedElem.hasAttribute("textPosition")) {
                String oldValue = Integer.toString(this.textPosition);
                String newValue = savedElem.getAttribute("textPosition");
                this.textPosition = Integer.parseInt(newValue);
                savedElem.setAttribute("textPosition", oldValue);
                if (this.textPosition == 3) {
                    this.elem.setAttribute("textPosition", "Bottom");
                } else if (this.textPosition == 1) {
                    this.elem.setAttribute("textPosition", "Top");
                } else if (this.textPosition == 10) {
                    this.elem.setAttribute("textPosition", "Start");
                } else if (this.textPosition == 11) {
                    this.elem.setAttribute("textPosition", "End");
                } else {
                    this.elem.setAttribute("textPosition", "Bottom");
                }
            }
            return savedElem;
        }
        if (elemtag.equals("ImageElement")) {
            if (!savedElem.hasAttribute("line")) {
                savedElem.setAttribute("line", "false");
            }
            if (!savedElem.hasAttribute("textPosition")) {
                savedElem.setAttribute("textPosition", "Bottom");
            }
        }
        Element e = super._undo(savedElem);
        return e;
    }

    @Override
    void drawHandles(Graphics2D gc) {
        this._drawHandles(gc);
    }

    @Override
    void drawHandles(Graphics2D gc, Color color) {
        this._drawHandles(gc, color);
    }
}

