/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.interfaces.AreaInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.util.SGActionEvent;
import com.sas.graphics.sg.util.SGActionListener;
import com.sas.graphics.sg.util.UnDoable;
import com.sas.graphics.sganno.AAreaStyle;
import com.sas.graphics.sganno.ATextStyle;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AnnotatePropertyChangeListener;
import com.sas.graphics.sganno.ImageElement;
import com.sas.graphics.sganno.LineElement;
import com.sas.graphics.sganno.MarkerElement;
import com.sas.graphics.sganno.TextElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Group
implements AreaInterface,
TextInterface,
UnDoable {
    protected String id;
    protected ATextStyle textStyle;
    protected SGActionListener listener;
    int prevx;
    int prevy;
    protected AAreaStyle style;
    boolean validColor = true;
    boolean validFont = true;
    boolean validFontFamily = true;
    boolean validFontSize = true;
    boolean validFontBold = true;
    boolean validFontItalic = true;
    boolean validFillOn = true;
    boolean validLineOn = true;
    boolean validLineColor = true;
    boolean validLineWidth = true;
    boolean validLinePattern = true;
    boolean validFillColor = true;
    boolean validDisplay = true;
    boolean validTransparency = true;
    private ArrayList listeners = new ArrayList();
    private ArrayList members = new ArrayList();
    private Rectangle bounds = new Rectangle();
    private boolean visible = true;
    private boolean areaAttrsEnabled = false;
    private boolean outlineAttrsEnabled = false;
    private boolean outlineOnAttrsEnabled = false;
    private boolean textOrMarkersOnly = true;
    private Annotate annotate = null;

    public Group(Annotate annotate, String id) {
        this.id = id;
        this.annotate = annotate;
        this.textStyle = new ATextStyle(annotate.getDefaultTextStyle());
        this.style = new AAreaStyle(annotate.getDefaultAreaStyle());
    }

    void move(int x, int y) {
        int i;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        for (i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            ae.move(10, x, y);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (int i2 = 0; i2 < lsize; ++i2) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i2)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i2)).propertyChange(pce);
            }
        }
    }

    void finishMove(int moveType, int x, int y) {
        int i;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        for (i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            ae.finishMove(10, x, y);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (int i2 = 0; i2 < lsize; ++i2) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i2)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i2)).propertyChange(pce);
            }
        }
    }

    void fireProperty(PropertyChangeEvent pce) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    void startMove(int moveType) {
        if (moveType != 10) {
            return;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            ae.startMove(10);
        }
        if (this.listener != null) {
            String action = "move:" + this.bounds.x + "," + this.bounds.y;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
    }

    String _undoTails(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.members.size() && st.hasMoreTokens(); ++i) {
            String str = st.nextToken();
            Object obj = this.members.get(i);
            if (obj instanceof LineElement) {
                StringTokenizer st1 = new StringTokenizer(str, ",");
                double x = Double.parseDouble(st1.nextToken());
                double y = Double.parseDouble(st1.nextToken());
                LineElement le = (LineElement)obj;
                Point2D p1 = le.getSecondaryPoint();
                sb.append(":" + p1.getX() + "," + p1.getY());
                le.setSecondaryPoint(new Point2D.Double(x, y));
                continue;
            }
            sb.append(":");
        }
        String state = "aligntails" + sb;
        this.resetBounds();
        return state;
    }

    String _undoMove(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.members.size() && st.hasMoreTokens(); ++i) {
            String str = st.nextToken();
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            StringTokenizer st1 = new StringTokenizer(str, ",");
            int x = Integer.parseInt(st1.nextToken());
            int y = Integer.parseInt(st1.nextToken());
            Rectangle r = ae.shape.getBounds();
            sb.append(":" + r.x + "," + r.y);
            ae.finishMove(10, x - r.x, y - r.y);
        }
        String state = "move" + sb;
        this.resetBounds();
        return state;
    }

    public boolean contains(int x, int y) {
        return this.bounds.contains(x, y);
    }

    @Override
    public Object undo(Object state) {
        int i;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).propertyChange(new PropertyChangeEvent(this, "undo", null, null));
            }
        }
        if (state instanceof String) {
            StringTokenizer st = new StringTokenizer((String)state, ":");
            String action = st.nextToken();
            if (action.equals("move")) {
                StringTokenizer st1 = new StringTokenizer(st.nextToken(), ",");
                int x = Integer.parseInt(st1.nextToken());
                int y = Integer.parseInt(st1.nextToken());
                state = "move:" + this.bounds.x + "," + this.bounds.y;
                int dx = x - this.bounds.x;
                int dy = y - this.bounds.y;
                this.bounds.setLocation(x, y);
                this.finishMove(10, dx, dy);
                this.fireProperty(new PropertyChangeEvent(this, "move", null, null));
                return state;
            }
            if (action.equals("linecolor")) {
                String rs = this._undoLineColor(st);
                this.fireProperty(new PropertyChangeEvent(this, "linecolor", null, null));
                return rs;
            }
            if (action.equals("display")) {
                String rs = this._undoDisplay(st);
                this.fireProperty(new PropertyChangeEvent(this, "display", null, null));
                return rs;
            }
            if (action.equals("linewidth")) {
                String rs = this._undoLineWidth(st);
                this.fireProperty(new PropertyChangeEvent(this, "linewidth", null, null));
                return rs;
            }
            if (action.equals("linepattern")) {
                String rs = this._undoLinePattern(st);
                this.fireProperty(new PropertyChangeEvent(this, "linepattern", null, null));
                return rs;
            }
            if (action.equals("lineon")) {
                String rs = this._undoLineOn(st);
                this.fireProperty(new PropertyChangeEvent(this, "lineon", null, null));
                return rs;
            }
            if (action.equals("fillcolor")) {
                String rs = this._undoFillColor(st);
                this.fireProperty(new PropertyChangeEvent(this, "fillcolor", null, null));
                return rs;
            }
            if (action.equals("fillon")) {
                String rs = this._undoFillOn(st);
                this.fireProperty(new PropertyChangeEvent(this, "fillon", null, null));
                return rs;
            }
            if (action.equals("color")) {
                String rs = this._undoColor(st);
                this.fireProperty(new PropertyChangeEvent(this, "color", null, null));
                return rs;
            }
            if (action.equals("font")) {
                String rs = this._undoFont(st);
                this.fireProperty(new PropertyChangeEvent(this, "font", null, null));
                return rs;
            }
            if (action.equals("fontfamily")) {
                String rs = this._undoFontFamily(st);
                this.fireProperty(new PropertyChangeEvent(this, "font", null, null));
                return rs;
            }
            if (action.equals("fontsize")) {
                String rs = this._undoFontSize(st);
                this.fireProperty(new PropertyChangeEvent(this, "font", null, null));
                return rs;
            }
            if (action.equals("fontstyle")) {
                String rs = this._undoFontStyle(st);
                this.fireProperty(new PropertyChangeEvent(this, "font", null, null));
                return rs;
            }
            if (action.equals("fontbold")) {
                String rs = this._undoFontBold(st);
                this.fireProperty(new PropertyChangeEvent(this, "font", null, null));
                return rs;
            }
            if (action.equals("fontitalic")) {
                String rs = this._undoFontItalic(st);
                this.fireProperty(new PropertyChangeEvent(this, "font", null, null));
                return rs;
            }
            if (action.equals("transparency")) {
                String rs = this._undoTransparency(st);
                this.fireProperty(new PropertyChangeEvent(this, "transparency", null, null));
                return rs;
            }
        } else {
            if (state instanceof AnnotateElement) {
                if (this.members.indexOf(state) == -1) {
                    this._add((AnnotateElement)state);
                } else {
                    this._remove((AnnotateElement)state);
                }
                this.fireProperty(new PropertyChangeEvent(this, "", null, null));
                return state;
            }
            if (state instanceof Element) {
                i = 0;
                Element elem = (Element)state;
                Element newlist = (Element)elem.cloneNode(false);
                for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element)) continue;
                    AnnotateElement ae = (AnnotateElement)this.members.get(i);
                    Object newstate = ae.undo(node);
                    if (newstate instanceof Node) {
                        newlist.appendChild((Node)newstate);
                    }
                    ++i;
                }
                this.reset();
                this.fireProperty(new PropertyChangeEvent(this, "", null, null));
                return newlist;
            }
        }
        return null;
    }

    private String _undoDisplay(StringTokenizer st) {
        AnnotateElement ae;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        String display = st.nextToken();
        boolean saveValid = this.validDisplay;
        boolean bl = this.validDisplay = !st.hasMoreElements();
        while (st.hasMoreTokens()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getDisplay());
            }
            ae.setDisplay(display);
            display = st.nextToken();
            ++i;
        }
        while (i < this.members.size()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getDisplay());
            }
            ae.setDisplay(display);
            ++i;
        }
        String state = saveValid ? "display:" + this.style.getDisplay() : "display" + sb;
        if (this.validDisplay) {
            this.style.setDisplay(display);
        } else {
            this.style.setDisplay("");
        }
        return state;
    }

    private String _undoLineColor(StringTokenizer st) {
        Color aec;
        AnnotateElement ae;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Color c = new Color(Integer.parseInt(st.nextToken()));
        boolean saveValid = this.validLineColor;
        boolean bl = this.validLineColor = !st.hasMoreElements();
        while (st.hasMoreTokens()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                aec = ae.getLineColor();
                if (aec == null) {
                    aec = ae.getDefaultLineColor();
                }
                sb.append(":" + aec.getRGB());
            }
            ae.setLineColor(c);
            c = new Color(Integer.parseInt(st.nextToken()));
            ++i;
        }
        while (i < this.members.size()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                aec = ae.getLineColor();
                if (aec == null) {
                    aec = ae.getDefaultLineColor();
                }
                sb.append(":" + aec.getRGB());
            }
            ae.setLineColor(c);
            ++i;
        }
        String state = saveValid ? "linecolor:" + this.style.getLineColor().getRGB() : "linecolor" + sb;
        if (this.validLineColor) {
            this.style.setLineColor(c);
        } else {
            this.style.setLineColor(null);
        }
        return state;
    }

    private String _undoLineWidth(StringTokenizer st) {
        AnnotateElement ae;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int w = Integer.parseInt(st.nextToken());
        boolean saveValid = this.validLineWidth;
        boolean bl = this.validLineWidth = !st.hasMoreElements();
        while (st.hasMoreTokens()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getLineWidth());
            }
            ae.setLineWidth(w);
            w = Integer.parseInt(st.nextToken());
            ++i;
        }
        while (i < this.members.size()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getLineWidth());
            }
            ae.setLineWidth(w);
            ++i;
        }
        String state = saveValid ? "linewidth:" + this.style.getLineWidth() : "linewidth" + sb;
        if (this.validLineWidth) {
            this.style.setLineWidth(w);
        } else {
            this.style.setLineWidth(-1);
        }
        return state;
    }

    private String _undoLinePattern(StringTokenizer st) {
        AnnotateElement ae;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int p = Integer.parseInt(st.nextToken());
        boolean saveValid = this.validLinePattern;
        boolean bl = this.validLinePattern = !st.hasMoreElements();
        while (st.hasMoreTokens()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getLinePattern());
            }
            ae.setLinePattern(p);
            p = Integer.parseInt(st.nextToken());
            ++i;
        }
        while (i < this.members.size()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getLinePattern());
            }
            ae.setLinePattern(p);
            ++i;
        }
        String state = saveValid ? "linepattern:" + this.style.getLinePattern() : "linepattern" + sb;
        if (this.validLinePattern) {
            this.style.setLinePattern(p);
        } else {
            this.style.setLinePattern(-1);
        }
        return state;
    }

    private String _undoFillColor(StringTokenizer st) {
        Color aec;
        AnnotateElement ae;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Color c = new Color(Integer.parseInt(st.nextToken()));
        boolean saveValid = this.validFillColor;
        boolean bl = this.validFillColor = !st.hasMoreElements();
        while (st.hasMoreTokens()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                aec = ae.getFillColor();
                if (aec == null) {
                    aec = ae.getDefaultFillColor();
                }
                sb.append(":" + aec.getRGB());
            }
            ae.setFillColor(c);
            c = new Color(Integer.parseInt(st.nextToken()));
            ++i;
        }
        while (i < this.members.size()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                aec = ae.getFillColor();
                if (aec == null) {
                    aec = ae.getDefaultFillColor();
                }
                sb.append(":" + aec.getRGB());
            }
            ae.setFillColor(c);
            ++i;
        }
        String state = saveValid ? "fillcolor:" + this.style.getFillColor().getRGB() : "fillcolor" + sb;
        if (this.validFillColor) {
            this.style.setFillColor(c);
        } else {
            this.style.setFillColor(null);
        }
        return state;
    }

    private String _undoColor(StringTokenizer st) {
        Color aec;
        AnnotateElement ae;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Color c = new Color(Integer.parseInt(st.nextToken()));
        boolean saveValid = this.validColor;
        boolean bl = this.validColor = !st.hasMoreElements();
        while (st.hasMoreTokens()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                aec = ae.getColor();
                if (aec == null) {
                    aec = ae.getDefaultFontColor();
                }
                sb.append(":" + aec.getRGB());
            }
            ae.setColor(c);
            c = new Color(Integer.parseInt(st.nextToken()));
            ++i;
        }
        while (i < this.members.size()) {
            ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                aec = ae.getColor();
                if (aec == null) {
                    aec = ae.getDefaultFontColor();
                }
                sb.append(":" + aec.getRGB());
            }
            ae.setColor(c);
            ++i;
        }
        String state = saveValid ? "color:" + this.textStyle.getFontColor().getRGB() : "color" + sb;
        if (this.validColor) {
            this.textStyle.setFontColor(c);
        } else {
            this.textStyle.setFontColor(null);
        }
        return state;
    }

    private String _undoTransparency(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        int transparency = Integer.parseInt(st.nextToken());
        boolean saveValid = this.validTransparency;
        this.validTransparency = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getFillTrans());
            }
            ae.setFillTrans(transparency);
            if (!st.hasMoreTokens()) continue;
            transparency = Integer.parseInt(st.nextToken());
        }
        String state = saveValid ? "transparency:" + this.style.getFillTrans() : "transparency" + sb;
        if (this.validTransparency) {
            this.style.setFillTrans(transparency);
        } else {
            this.style.setFillTrans(-1);
        }
        return state;
    }

    private String _undoFont(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st1 = new StringTokenizer(st.nextToken(), ",");
        Font f = new Font(st1.nextToken(), Integer.parseInt(st1.nextToken()), Integer.parseInt(st1.nextToken()));
        boolean saveValid = this.validFont;
        this.validFont = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                Font f1 = ae.getFont();
                sb.append(":" + f1.getFamily() + "," + f1.getStyle() + "," + f1.getSize());
            }
            ae.setFont(f);
            if (!st.hasMoreTokens()) continue;
            st1 = new StringTokenizer(st.nextToken(), ",");
            f = new Font(st1.nextToken(), Integer.parseInt(st1.nextToken()), Integer.parseInt(st1.nextToken()));
        }
        String state = saveValid ? "font:" + f.getFamily() + "," + f.getStyle() + "," + f.getSize() : "font" + sb;
        if (this.validFont) {
            this.textStyle.setFont(f);
        } else {
            this.textStyle.setFont(null);
        }
        this.resetBounds();
        return state;
    }

    private String _undoFontFamily(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        String st1 = st.nextToken();
        boolean saveValid = this.validFontFamily;
        boolean bl = this.validFontFamily = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getFontFamily());
            }
            ae.setFontFamily(st1);
            if (!st.hasMoreTokens()) continue;
            st1 = st.nextToken();
        }
        String state = saveValid ? "fontfamily:" + this.textStyle.getFontFamily() : "fontfamily" + sb;
        if (this.validFontFamily) {
            this.textStyle.setFontFamily(st1);
        } else {
            this.textStyle.setFontFamily("");
        }
        this.resetBounds();
        return state;
    }

    private String _undoFontSize(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        int s = Integer.parseInt(st.nextToken());
        boolean saveValid = this.validFontSize;
        this.validFontSize = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getFontSize());
            }
            ae.setFontSize(s);
            if (!st.hasMoreTokens()) continue;
            s = Integer.parseInt(st.nextToken());
        }
        String state = saveValid ? "fontsize:" + this.textStyle.getFontSize() : "fontsize" + sb;
        if (this.validFontSize) {
            this.textStyle.setFontSize(s);
        } else {
            this.textStyle.setFontSize(-1);
        }
        this.resetBounds();
        return state;
    }

    private String _undoFontStyle(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        int b = Integer.parseInt(st.nextToken());
        boolean saveValid = this.validFontItalic && this.validFontBold;
        this.validFontBold = this.validFontItalic = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.getFontStyle());
            }
            ae.setFontStyle(b);
            if (!st.hasMoreTokens()) continue;
            b = Integer.parseInt(st.nextToken());
        }
        String state = saveValid ? "fontstyle:" + this.textStyle.getFontStyle() : "fontstyle" + sb;
        if (this.validFontItalic) {
            this.textStyle.setFontStyle(b);
        } else {
            this.textStyle.setFontStyle(-1);
        }
        return state;
    }

    private String _undoFontItalic(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        boolean b = "true".equalsIgnoreCase(st.nextToken());
        boolean saveValid = this.validFontItalic;
        this.validFontItalic = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + (ae.isItalic() ? "true" : "false"));
            }
            ae.setItalic(b);
            if (!st.hasMoreTokens()) continue;
            b = "true".equalsIgnoreCase(st.nextToken());
        }
        String state = saveValid ? "fontitalic:" + (this.textStyle.isItalic() ? "true" : "false") : "fontitalic" + sb;
        if (this.validFontItalic) {
            this.textStyle.setItalic(b);
        } else {
            this.textStyle.setItalic(false);
        }
        return state;
    }

    private String _undoFontBold(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        boolean b = "true".equalsIgnoreCase(st.nextToken());
        boolean saveValid = this.validFontBold;
        boolean bl = this.validFontBold = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + (ae.isBold() ? "true" : "false"));
            }
            ae.setBold(b);
            if (!st.hasMoreTokens()) continue;
            b = "true".equalsIgnoreCase(st.nextToken());
        }
        String state = saveValid ? "fontbold:" + (this.textStyle.isBold() ? "true" : "false") : "fontbold" + sb;
        if (this.validFontBold) {
            this.textStyle.setBold(b);
        } else {
            this.textStyle.setBold(false);
        }
        return state;
    }

    private String _undoFillOn(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        boolean b = "true".equalsIgnoreCase(st.nextToken());
        boolean saveValid = this.validFillOn;
        this.validFillOn = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.isFillOn());
            }
            ae.setFillOn(b);
            if (!st.hasMoreTokens()) continue;
            b = "true".equalsIgnoreCase(st.nextToken());
        }
        String state = saveValid ? "fillon:" + this.style.isFillOn() : "fillon" + sb;
        if (this.validFillOn) {
            this.style.setFillOn(b);
        }
        return state;
    }

    private String _undoLineOn(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        boolean b = "true".equalsIgnoreCase(st.nextToken());
        boolean saveValid = this.validLineOn;
        this.validLineOn = !st.hasMoreElements();
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!saveValid) {
                sb.append(":" + ae.isLineOn());
            }
            ae.setLineOn(b);
            if (!st.hasMoreTokens()) continue;
            b = "true".equalsIgnoreCase(st.nextToken());
        }
        String state = saveValid ? "lineon:" + this.style.isLineOn() : "lineon" + sb;
        if (this.validLineOn) {
            this.style.setLineOn(b);
        }
        return state;
    }

    void drawHandles(Graphics2D gc) {
        gc.setColor(Color.lightGray);
        Stroke save = gc.getStroke();
        gc.setStroke(AnnotateElement.elemBorder);
        gc.draw(this.bounds);
        Ellipse2D.Double handle = new Ellipse2D.Double(this.bounds.x - 4, this.bounds.y - 4, 8.0, 8.0);
        gc.draw(handle);
        gc.translate(this.bounds.width, 0);
        gc.draw(handle);
        gc.translate(0, this.bounds.height);
        gc.draw(handle);
        gc.translate(-this.bounds.width, 0);
        gc.draw(handle);
        gc.translate(0, -this.bounds.height);
        gc.setStroke(save);
    }

    void move(int moveType, int x, int y) {
        int i;
        if (moveType != 10) {
            return;
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        for (i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            ae.move(10, x, y);
        }
        if (this.annotate.isDataValuesDirty()) {
            this.resetBounds();
        } else {
            this.bounds.translate(x, y);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (int i2 = 0; i2 < lsize; ++i2) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i2)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i2)).propertyChange(pce);
            }
        }
    }

    @Override
    public final Color getFillColor() {
        return this.validFillColor ? this.style.getFillColor() : null;
    }

    @Override
    public final Color getLineColor() {
        return this.validLineColor ? this.style.getLineColor() : null;
    }

    @Override
    public final int getLinePattern() {
        return this.validLinePattern ? this.style.getLinePattern() : -1;
    }

    @Override
    public final int getLineWidth() {
        return this.validLineWidth ? this.style.getLineWidth() : -1;
    }

    @Override
    public final void setLineColor(Color c) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validLineColor) {
                Color ac = ae.getLineColor();
                if (ac == null) {
                    ac = ae.getDefaultLineColor();
                }
                sb.append(":" + ac.getRGB());
            }
            if (!ae.isOutlineAttrsEnabled()) continue;
            ae.setLineColor(c);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "lineColor", this.getLineColor(), c);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validLineColor ? "linecolor:" + this.style.getLineColor().getRGB() : "linecolor" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validLineColor = true;
        this.style.setLineColor(c);
    }

    @Override
    public final void setLinePattern(int p) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validLinePattern) {
                sb.append(":" + ae.getLinePattern());
            }
            if (!ae.isOutlineAttrsEnabled()) continue;
            ae.setLinePattern(p);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "linePattern", new Integer(this.getLinePattern()), new Integer(p));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validLinePattern ? "linepattern:" + this.style.getLinePattern() : "linepattern" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validLinePattern = true;
        this.style.setLinePattern(p);
    }

    @Override
    public final void setLineWidth(int w) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validLineWidth) {
                sb.append(":" + ae.getLineWidth());
            }
            if (!ae.isOutlineAttrsEnabled()) continue;
            ae.setLineWidth(w);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "lineWidth", new Integer(this.getLineWidth()), new Integer(w));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validLineWidth ? "linewidth:" + this.style.getLineWidth() : "linewidth" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validLineWidth = true;
        this.style.setLineWidth(w);
    }

    public void isLineOn(boolean b) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validLineOn) {
                sb.append(":" + ae.isLineOn());
            }
            ae.setLineOn(b);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "lineOn", new Boolean(this.isLineOn()), new Boolean(b));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validLineOn ? "lineon:" + this.style.isLineOn() : "lineon" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validLineOn = true;
        this.style.setLineOn(b);
    }

    @Override
    public void setFillColor(Color c) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFillColor) {
                Color ac = ae.getFillColor();
                if (ac == null) {
                    ac = ae.getDefaultFillColor();
                }
                sb.append(":" + ac.getRGB());
            }
            if (!ae.isAreaAttrsEnabled()) continue;
            ae.setFillColor(c);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fillColor", this.getFillColor(), c);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validFillColor ? "fillcolor:" + this.style.getFillColor().getRGB() : "fillcolor" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFillColor = true;
        this.style.setFillColor(c);
    }

    @Override
    public boolean isFillOn() {
        return this.style.isFillOn();
    }

    @Override
    public final void setFillTrans(int transparency) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        Integer oldValue = new Integer(this.style.getFillTrans());
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validTransparency) {
                sb.append(":" + ae.getFillTrans());
            }
            if (!ae.isAreaAttrsEnabled()) continue;
            ae.setFillTrans(transparency);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "transparency", oldValue, new Integer(transparency));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validTransparency ? "transparency:" + this.style.getFillTrans() : "transparency" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validTransparency = true;
        this.style.setFillTrans(transparency);
    }

    @Override
    public final int getFillTrans() {
        return this.validTransparency ? this.style.getFillTrans() : 0;
    }

    @Override
    public void setFontColor(Color c) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validColor) {
                Color ac = ae.getFontColor();
                if (ac == null) {
                    ac = ae.getDefaultFontColor();
                }
                sb.append(":" + ac.getRGB());
            }
            ae.setColor(c);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "color", this.getFontColor(), c);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validColor ? "color:" + this.textStyle.getFontColor().getRGB() : "color" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validColor = true;
        this.textStyle.setFontColor(c);
    }

    @Override
    public void setFont(Font f) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFont) {
                Font f1 = ae.getFont();
                sb.append(":" + f1.getFamily() + "," + f1.getStyle() + "," + f1.getSize());
            }
            ae.setFont(f);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "font", this.getFont(), f);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action;
            if (this.validFont) {
                Font f1 = this.textStyle.getFont();
                action = "font:" + f1.getFamily() + "," + f1.getStyle() + "," + f1.getSize();
            } else {
                action = "font" + sb;
            }
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFont = true;
        this.textStyle.setFont(f);
        this.resetBounds();
    }

    @Override
    public void setFontFamily(String f) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFontFamily) {
                sb.append(":" + ae.getFontFamily());
            }
            ae.setFontFamily(f);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fontfamily", this.getFont(), f);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action;
            if (this.validFontFamily) {
                Font f1 = this.textStyle.getFont();
                action = "fontfamily:" + f1.getFamily();
            } else {
                action = "fontfamily" + sb;
            }
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFontFamily = true;
        this.textStyle.setFontFamily(f);
        this.resetBounds();
    }

    @Override
    public void setFontStyle(int f) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFontItalic || !this.validFontBold) {
                sb.append(":" + ae.getFontStyle());
            }
            ae.setFontStyle(f);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fontstyle", null, Integer.toString(f));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validFontBold && this.validFontItalic ? "fontstyle:" + this.textStyle.getFontStyle() : "fontstyle" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFontBold = true;
        this.validFontItalic = true;
        this.textStyle.setFontStyle(f);
    }

    @Override
    public void setBold(boolean bold) {
        String f = bold ? "true" : "false";
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFontItalic) {
                sb.append(":" + ae.isBold());
            }
            ae.setBold(bold);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "bold", "", f);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action;
            if (this.validFontBold) {
                Font f1 = this.textStyle.getFont();
                action = "fontbold:" + f1.isBold();
            } else {
                action = "fontbold" + sb;
            }
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFontBold = true;
        this.textStyle.setBold(bold);
    }

    @Override
    public void setItalic(boolean italic) {
        String f = italic ? "true" : "false";
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFontItalic) {
                sb.append(":" + ae.isItalic());
            }
            ae.setItalic(italic);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "italic", "", f);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action;
            if (this.validFontItalic) {
                Font f1 = this.textStyle.getFont();
                action = "fontitalic:" + f1.isItalic();
            } else {
                action = "fontitalic" + sb;
            }
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFontItalic = true;
        this.textStyle.setItalic(italic);
    }

    @Override
    public void setFontSize(int f) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFontSize) {
                sb.append(":" + ae.getFontSize());
            }
            ae.setFontSize(f);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fontsize", null, Integer.toString(f));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action;
            if (this.validFontSize) {
                Font f1 = this.textStyle.getFont();
                action = "fontsize:" + f1.getSize();
            } else {
                action = "fontsize" + sb;
            }
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFontSize = true;
        this.textStyle.setFontSize(f);
        this.resetBounds();
    }

    @Override
    public void setFillOn(boolean fill) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        Boolean oldValue = new Boolean(this.style.isFillOn());
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validFillOn) {
                sb.append(":" + ae.isFillOn());
            }
            if (!ae.isAreaAttrsEnabled()) continue;
            ae.setFillOn(fill);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fillOn", oldValue, new Boolean(fill));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validFillOn ? "fillon:" + this.style.isFillOn() : "fillon" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validFillOn = true;
        this.style.setFillOn(fill);
    }

    @Override
    public void setLineOn(boolean line) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        Boolean oldValue = new Boolean(this.style.isLineOn());
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validLineOn) {
                sb.append(":" + ae.isLineOn());
            }
            if (!ae.isOutlineAttrsEnabled()) continue;
            ae.setLineOn(line);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "lineOn", oldValue, new Boolean(line));
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validLineOn ? "lineon:" + this.style.isLineOn() : "lineon" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validLineOn = true;
        this.style.setLineOn(line);
    }

    public boolean contains(AnnotateElement ae) {
        return this.members.indexOf(ae) != -1;
    }

    public boolean isSelected(Graphics2D gc, int x, int y) {
        return this.bounds.contains(x, y);
    }

    private boolean _add(AnnotateElement ae) {
        if (this.members.indexOf(ae) != -1) {
            return false;
        }
        ae.addToGroup(this.id);
        ae.removeActionListener(this.listener);
        this.members.add(ae);
        if (this.members.size() == 1) {
            this.reset();
        } else {
            if (this.validColor) {
                this.validColor = this.textStyle.getFontColor().getRGB() == ae.textStyle.getFontColor().getRGB();
            }
            Font f1 = this.textStyle.getFont();
            Font f2 = ae.textStyle.getFont();
            if (this.validFontFamily) {
                this.validFontFamily = f1.getFamily().equals(f2.getFamily());
            }
            if (this.validFontSize) {
                boolean bl = this.validFontSize = f1.getSize() == f2.getSize();
            }
            if (this.validFontBold) {
                boolean bl = this.validFontBold = f1.isBold() == f2.isBold();
            }
            if (this.validFontItalic) {
                boolean bl = this.validFontItalic = f1.isItalic() == f2.isItalic();
            }
            if (this.validFont) {
                this.validFont = this.validFontFamily && this.validFontSize && this.validFontItalic && this.validFontBold;
            }
            boolean lineAttrs = ae.isOutlineAttrsEnabled();
            boolean areaAttrs = ae.isAreaAttrsEnabled();
            if (!this.areaAttrsEnabled && areaAttrs) {
                this.style.setFillTrans(ae.style.getFillTrans());
                this.style.setFillColor(ae.style.getFillColor());
                this.style.setFillOn(ae.isFillOn());
                this.areaAttrsEnabled = true;
            } else if (areaAttrs) {
                if (this.validFillColor) {
                    boolean bl = this.validFillColor = this.style.getFillColor().getRGB() == ae.style.getFillColor().getRGB();
                }
                if (this.validFillOn) {
                    boolean bl = this.validFillOn = this.style.isFillOn() == ae.isFillOn();
                }
                if (this.validTransparency) {
                    boolean bl = this.validTransparency = this.style.getFillTrans() == ae.getFillTrans();
                }
            }
            if (lineAttrs && !this.outlineAttrsEnabled) {
                this.style.setLineColor(ae.style.getLineColor());
                this.style.setLineOn(ae.isLineOn());
                this.style.setLineColor(ae.style.getLineColor());
                this.style.setLineWidth(ae.style.getLineWidth());
                this.style.setLinePattern(ae.style.getLinePattern());
                this.outlineAttrsEnabled = true;
            }
            if (lineAttrs) {
                if (this.validLineColor) {
                    boolean bl = this.validLineColor = this.style.getLineColor().getRGB() == ae.style.getLineColor().getRGB();
                }
                if (this.validLineOn) {
                    boolean bl = this.validLineOn = this.style.isLineOn() == ae.isLineOn();
                }
                if (this.validLineWidth) {
                    boolean bl = this.validLineWidth = this.style.getLineWidth() == ae.style.getLineWidth();
                }
                if (this.validLinePattern) {
                    this.validLinePattern = this.style.getLinePattern() == ae.style.getLinePattern();
                }
            }
            this.outlineOnAttrsEnabled |= areaAttrs || ae instanceof ImageElement;
            this.bounds = this.bounds.union(ae.shape.getBounds());
            if (ae.getText() != null) {
                this.bounds = this.bounds.union(ae.outside.getBounds());
            }
            this.textOrMarkersOnly &= ae instanceof TextElement || ae instanceof MarkerElement;
        }
        return true;
    }

    public boolean add(AnnotateElement ae) {
        boolean ok = this._add(ae);
        if (ok && this.listener != null) {
            this.listener.actionPerformed(new SGActionEvent(this, ae));
        }
        return ok;
    }

    private boolean _remove(AnnotateElement ae) {
        int index = this.members.indexOf(ae);
        if (index == -1) {
            return false;
        }
        ae.removeFromGroup(this.id);
        this.members.remove(index);
        ae.addActionListener(this.listener);
        this.reset();
        return true;
    }

    public boolean remove(AnnotateElement ae) {
        boolean ok = this._remove(ae);
        if (ok && this.listener != null) {
            this.listener.actionPerformed(new SGActionEvent(this, ae));
        }
        return ok;
    }

    public ArrayList removeAll() {
        int msize = this.members.size();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            ae.removeFromGroup(this.id);
            ae.addActionListener(this.listener);
        }
        ArrayList rv = this.members;
        this.members = new ArrayList();
        this.bounds.setSize(0, 0);
        this.reset();
        return rv;
    }

    private void reset() {
        int size = this.members.size();
        this.validColor = true;
        this.validFillColor = true;
        this.validFillOn = true;
        this.validFont = true;
        this.validFontBold = true;
        this.validFontItalic = true;
        this.validLineColor = true;
        this.validLineWidth = true;
        this.validLinePattern = true;
        this.validTransparency = true;
        this.areaAttrsEnabled = false;
        this.textOrMarkersOnly = true;
        this.outlineAttrsEnabled = false;
        this.outlineOnAttrsEnabled = false;
        if (size == 0) {
            return;
        }
        AnnotateElement ae = (AnnotateElement)this.members.get(0);
        this.textStyle.setFontColor(ae.textStyle.getFontColor());
        this.textStyle.setFont(ae.textStyle.getFont());
        boolean lineAttrs = ae.isOutlineAttrsEnabled();
        boolean fillAttrs = ae.isAreaAttrsEnabled();
        this.outlineOnAttrsEnabled |= fillAttrs || ae instanceof ImageElement;
        if (lineAttrs) {
            this.style.setLineColor(ae.style.getLineColor());
            this.style.setLineOn(ae.isLineOn());
            this.style.setLineColor(ae.style.getLineColor());
            this.style.setLineWidth(ae.style.getLineWidth());
            this.style.setLinePattern(ae.style.getLinePattern());
            this.outlineAttrsEnabled = true;
        }
        if (fillAttrs) {
            this.style.setFillTrans(ae.style.getFillTrans());
            this.style.setFillColor(ae.style.getFillColor());
            this.style.setFillOn(ae.isFillOn());
            this.areaAttrsEnabled = true;
        }
        Rectangle aeb = ae.shape.getBounds();
        this.bounds.setRect(aeb.x, aeb.y, aeb.width, aeb.height);
        String text = ae.getText();
        if (text != null && text.length() > 0) {
            this.bounds = this.bounds.union(ae.outside.getBounds());
        }
        this.textOrMarkersOnly &= ae instanceof TextElement || ae instanceof MarkerElement;
        for (int i = 1; i < size; ++i) {
            ae = (AnnotateElement)this.members.get(i);
            if (this.validColor) {
                this.validColor = this.textStyle.getFontColor().getRGB() == ae.textStyle.getFontColor().getRGB();
            }
            Font f1 = this.textStyle.getFont();
            Font f2 = ae.textStyle.getFont();
            if (this.validFontFamily) {
                this.validFontFamily = f1.getFamily().equals(f2.getFamily());
            }
            if (this.validFontSize) {
                boolean bl = this.validFontSize = f1.getSize() == f2.getSize();
            }
            if (this.validFontBold) {
                boolean bl = this.validFontBold = f1.isBold() == f2.isBold();
            }
            if (this.validFontItalic) {
                boolean bl = this.validFontItalic = f1.isItalic() == f2.isItalic();
            }
            if (this.validFont) {
                this.validFont = this.validFontFamily && this.validFontSize && this.validFontItalic && this.validFontBold;
            }
            lineAttrs = ae.isOutlineAttrsEnabled();
            fillAttrs = ae.isAreaAttrsEnabled();
            this.outlineOnAttrsEnabled |= fillAttrs || ae instanceof ImageElement;
            if (!this.outlineAttrsEnabled && lineAttrs) {
                this.style.setLineColor(ae.style.getLineColor());
                this.style.setLineOn(ae.isLineOn());
                this.style.setLineColor(ae.style.getLineColor());
                this.style.setLineWidth(ae.style.getLineWidth());
                this.style.setLinePattern(ae.style.getLinePattern());
                this.outlineAttrsEnabled = true;
            } else if (lineAttrs) {
                if (this.validLineColor) {
                    boolean bl = this.validLineColor = this.style.getLineColor().getRGB() == ae.style.getLineColor().getRGB();
                }
                if (this.validLineOn) {
                    boolean bl = this.validLineOn = this.style.isLineOn() == ae.isLineOn();
                }
                if (this.validLineWidth) {
                    boolean bl = this.validLineWidth = this.style.getLineWidth() == ae.style.getLineWidth();
                }
                if (this.validLinePattern) {
                    boolean bl = this.validLinePattern = this.style.getLinePattern() == ae.style.getLinePattern();
                }
                if (this.validTransparency) {
                    boolean bl = this.validTransparency = this.style.getFillTrans() == ae.getFillTrans();
                }
            }
            if (!this.areaAttrsEnabled && fillAttrs) {
                this.style.setFillTrans(ae.style.getFillTrans());
                this.style.setFillColor(ae.style.getFillColor());
                this.style.setFillOn(ae.isFillOn());
                this.areaAttrsEnabled = true;
            } else if (fillAttrs) {
                if (this.validFillColor) {
                    boolean bl = this.validFillColor = this.style.getFillColor().getRGB() == ae.style.getFillColor().getRGB();
                }
                if (this.validFillOn) {
                    this.validFillOn = this.style.isFillOn() == ae.isFillOn();
                }
            }
            aeb = ae.shape.getBounds();
            this.bounds = this.bounds.union(aeb);
            text = ae.getText();
            if (text != null && text.length() > 0) {
                this.bounds = this.bounds.union(ae.outside.getBounds());
            }
            this.textOrMarkersOnly &= ae instanceof TextElement || ae instanceof MarkerElement;
        }
    }

    void resetBounds() {
        int size = this.members.size();
        if (size == 0) {
            return;
        }
        AnnotateElement ae = (AnnotateElement)this.members.get(0);
        Rectangle aeb = ae.shape.getBounds();
        this.bounds.setRect(aeb.x, aeb.y, aeb.width, aeb.height);
        for (int i = 1; i < size; ++i) {
            ae = (AnnotateElement)this.members.get(i);
            aeb = ae.shape.getBounds();
            this.bounds = this.bounds.union(aeb);
            if (ae.outside == null || !(ae.outside.getWidth() > 0.0) || !(ae.outside.getHeight() > 0.0)) continue;
            this.bounds = this.bounds.union(ae.outside.getBounds());
        }
    }

    public Rectangle2D getBounds() {
        int size = this.members.size();
        if (size == 0) {
            return new Rectangle();
        }
        AnnotateElement ae = (AnnotateElement)this.members.get(0);
        boolean dataSpace = ae.isAnchorAttachedToData();
        Rectangle2D aeb = ae.getBounds();
        for (int i = 1; i < size && dataSpace; ++i) {
            ae = (AnnotateElement)this.members.get(i);
            dataSpace = ae.isAnchorAttachedToData();
            Rectangle2D r2d = ae.getBounds();
            double xo = Math.min(aeb.getX(), r2d.getX());
            double x1 = Math.max(aeb.getX() + aeb.getWidth(), r2d.getX() + r2d.getWidth());
            double yo = Math.min(aeb.getY(), r2d.getY());
            double y1 = Math.max(aeb.getY() + aeb.getHeight(), r2d.getY() + r2d.getHeight());
            aeb.setRect(xo, yo, x1 - xo, y1 - yo);
        }
        if (dataSpace) {
            return aeb;
        }
        return this.getScreenBounds();
    }

    boolean isAllAttachedToData() {
        int size = this.members.size();
        for (int i = 0; i < size; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (ae.isAnchorAttachedToData()) continue;
            return false;
        }
        return true;
    }

    public Rectangle getScreenBounds() {
        int size = this.members.size();
        if (size == 0) {
            return new Rectangle();
        }
        AnnotateElement ae = (AnnotateElement)this.members.get(0);
        Rectangle r = ae.getScreenBounds();
        for (int i = 1; i < size; ++i) {
            ae = (AnnotateElement)this.members.get(i);
            Rectangle r2 = ae.getScreenBounds();
            r = r.union(r2);
        }
        return r;
    }

    void moveAll(int handle, int dx, int dy) {
        this.bounds.translate(dx, dy);
        for (int i = 0; i < this.members.size(); ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            ae.finishMove(handle, dx, dy);
        }
    }

    @Override
    public boolean isLineOn() {
        return this.style.isLineOn();
    }

    public void setLineStyle(LineInterface mi) {
        this.style.setLineColor(mi.getLineColor());
        this.style.setLineWidth(mi.getLineWidth());
        this.style.setLinePattern(mi.getLinePattern());
    }

    @Override
    public Font getFont() {
        return this.validFont ? this.textStyle.getFont() : null;
    }

    @Override
    public Color getFontColor() {
        return this.validColor ? this.textStyle.getFontColor() : null;
    }

    @Override
    public boolean isBold() {
        return this.validFontBold ? this.textStyle.isBold() : false;
    }

    @Override
    public boolean isItalic() {
        return this.validFontItalic ? this.textStyle.isItalic() : false;
    }

    @Override
    public int getFontStyle() {
        return this.validFontBold && this.validFontItalic ? this.textStyle.getFontStyle() : -1;
    }

    @Override
    public String getFontFamily() {
        return this.validFontFamily ? this.textStyle.getFontFamily() : "";
    }

    @Override
    public int getFontSize() {
        return this.validFontSize ? this.textStyle.getFontSize() : -1;
    }

    @Override
    public Element getState() {
        int size = this.members.size();
        if (size == 0) {
            return null;
        }
        AnnotateElement ae = (AnnotateElement)this.members.get(0);
        Element aelem = ae.getState();
        Element gelem = aelem.getOwnerDocument().createElement("Group");
        gelem.appendChild(aelem);
        for (int i = 1; i < size; ++i) {
            gelem.appendChild(((AnnotateElement)this.members.get(i)).getState());
        }
        return gelem;
    }

    public Element getCopy() {
        int size = this.members.size();
        if (size == 0) {
            return null;
        }
        AnnotateElement ae = (AnnotateElement)this.members.get(0);
        Element aelem = ae.getState();
        aelem.appendChild(ae.getCustomAttrs());
        Element gelem = aelem.getOwnerDocument().createElement("Group");
        gelem.appendChild(aelem);
        for (int i = 1; i < size; ++i) {
            ae = (AnnotateElement)this.members.get(i);
            aelem = ae.getState();
            aelem.appendChild(ae.getCustomAttrs());
            gelem.appendChild(aelem);
        }
        return gelem;
    }

    @Override
    public void addActionListener(SGActionListener l) {
        this.listener = l;
    }

    public void removeActionListener(SGActionListener l) {
        if (l == this.listener) {
            this.listener = null;
        }
    }

    public boolean isValidColor() {
        return this.validColor;
    }

    public boolean isValidFillColor() {
        return this.validFillColor;
    }

    public boolean isValidFillOn() {
        return this.validFillOn;
    }

    public boolean isValidFont() {
        return this.validFont;
    }

    public boolean isValidLineColor() {
        return this.validLineColor;
    }

    public boolean isValidLineOn() {
        return this.validLineOn;
    }

    public boolean isValidLinePattern() {
        return this.validLinePattern;
    }

    public boolean isValidLineWidth() {
        return this.validLineWidth;
    }

    public boolean isValidTransparency() {
        return this.validTransparency;
    }

    public String getID() {
        return this.id;
    }

    public ArrayList getAllMembers() {
        return this.members;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners.indexOf(pcl) == -1) {
            this.listeners.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public String getDisplay() {
        if (this.validDisplay) {
            return this.style.getDisplay();
        }
        return "";
    }

    public void setDisplay(String display) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        int msize = this.members.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.members.get(i);
            if (!this.validDisplay) {
                sb.append(":" + ae.getDisplay());
            }
            ae.setDisplay(display);
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "display", this.getDisplay(), display);
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = this.validDisplay ? "display:" + this.style.getDisplay() : "display" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
        this.validDisplay = true;
        this.style.setDisplay(display);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isAreaAttrsEnabled() {
        return this.areaAttrsEnabled;
    }

    public boolean isOutlineAttrsEnabled() {
        return this.outlineAttrsEnabled;
    }

    public boolean isOutlineOnAttrsEnabled() {
        return this.outlineOnAttrsEnabled;
    }

    public boolean isTextOrMarkersOnly() {
        return this.textOrMarkersOnly;
    }

    public Rectangle getShapeBounds() {
        return this.bounds;
    }
}

