/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotatePoint;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.LineElement;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Element;

class ArrowLineElement
extends LineElement {
    GeneralPath arrow;
    static final int DEFAULT_ARROW_SHAPE = 0;
    static final int TRIANGLE_ARROW_SHAPE = 1;
    int arrowShape = 0;

    static double calculateDir(AnnotatePoint from, AnnotatePoint to) {
        double dx = to.screen.getX() - from.screen.getX();
        double dy = to.screen.getY() - from.screen.getY();
        double ang = 0.0;
        if (dx == 0.0) {
            if (dy > 0.0) {
                ang = 1.5707963267948966;
            } else if (dy < 0.0) {
                ang = -1.5707963267948966;
            }
        } else if (dy == 0.0) {
            if (dx > 0.0) {
                ang = 0.0;
            } else if (dx < 0.0) {
                ang = Math.PI;
            }
        } else {
            ang = dx > 0.0 && dy > 0.0 || dx > 0.0 && dy < 0.0 ? Math.atan(dy / dx) : (dx < 0.0 && dy > 0.0 ? Math.PI - Math.atan(-dy / dx) : Math.PI + Math.atan(dy / dx));
        }
        return ang;
    }

    ArrowLineElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    ArrowLineElement(Annotate annotate, BaseAnnotatable graph, Point x1, Point x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
    }

    private void init(Element node, String parent) {
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("ArrowLineElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
        }
    }

    ArrowLineElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    ArrowLineElement(Annotate annotate, Annotatable graph, Object[] x1, Object[] x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
        if (node != null) {
            this.updateXMLNode();
        }
    }

    @Override
    void setInternalVariables() {
        super.setInternalVariables();
        this._setArrow();
    }

    private void _setArrow() {
        float al;
        float aw;
        float penWidth = this.stroke == null ? 2.0f : this.stroke.getLineWidth();
        float arrowBase = 2.0f * penWidth + 1.0f;
        float arrowLength = 1.5f * arrowBase;
        float fx = (float)this.anchor.screen.getX();
        float fy = (float)this.anchor.screen.getY();
        float x = (float)this.secondary.screen.getX();
        float y = (float)this.secondary.screen.getY();
        if (Math.abs(fx - x) + Math.abs(fy - y) < 1.0f) {
            this.arrow = null;
            return;
        }
        switch (this.arrowShape) {
            default: {
                aw = 2.0f * penWidth + arrowBase;
                al = aw / 4.0f + arrowLength;
                break;
            }
            case 1: {
                aw = arrowBase;
                al = arrowLength;
            }
        }
        this.arrow = new GeneralPath(0, 3);
        double rot = Math.PI + ArrowLineElement.calculateDir(this.anchor, this.secondary);
        switch (this.arrowShape) {
            default: {
                this.arrow.moveTo(x, y);
                this.arrow.lineTo(x + al, y - aw / 2.0f);
                this.arrow.lineTo(x + 0.75f * al, y);
                this.arrow.lineTo(x + al, y + aw / 2.0f);
                this.arrow.closePath();
                break;
            }
            case 1: {
                this.arrow.moveTo(x, y);
                this.arrow.lineTo(x + al, y - aw / 2.0f);
                this.arrow.lineTo(x + al, y + aw / 2.0f);
                this.arrow.closePath();
            }
        }
        AffineTransform r = AffineTransform.getRotateInstance(rot, x, y);
        this.arrow.transform(r);
    }

    @Override
    protected void drawShape(Graphics2D gc) {
        float penWidth = this.stroke == null ? 2.0f : this.stroke.getLineWidth();
        float halfLength = 0.75f * (2.0f * penWidth + 1.0f);
        double rot = Math.PI + ArrowLineElement.calculateDir(this.anchor, this.secondary);
        Line2D.Double line = new Line2D.Double(this.anchor.screen.getX(), this.anchor.screen.getY(), this.secondary.screen.getX() + (double)halfLength * Math.cos(rot), this.secondary.screen.getY() + (double)halfLength * Math.sin(rot));
        gc.draw(line);
        if (this.arrow == null) {
            return;
        }
        gc.setStroke(new BasicStroke());
        gc.fill(this.arrow);
        gc.draw(this.arrow);
    }

    @Override
    void load(Element aElem, boolean loadOnly) {
        super.load(aElem, loadOnly);
    }

    @Override
    protected Element _undo(Element savedElem) {
        Element saved = super._undo(savedElem);
        return saved;
    }

    @Override
    public void setLineWidth(int thickness) {
        super.setLineWidth(thickness);
        this._setArrow();
    }

    @Override
    void resetPoint(Point p) {
        if (!this.controlOn) {
            super.resetPoint(p);
            return;
        }
        double x1 = this.secondary.screen.getX();
        double y1 = this.secondary.screen.getY();
        this.anchor.setPoint(p);
        if (this.shiftOn) {
            double dist = this.anchor.screen.distance(x1, y1);
            double angle = Math.toDegrees(Math.atan2(y1 - this.anchor.screen.getY(), x1 - this.anchor.screen.getX()));
            double modangle = Math.round(angle / 15.0) * 15L;
            double xo = dist * Math.cos(Math.toRadians(modangle));
            double yo = dist * Math.sin(Math.toRadians(modangle));
            this.anchor.screen.setLocation(x1 - xo, y1 - yo);
        }
        if (this.anGraph != null) {
            int sx = (int)Math.round(this.anchor.screen.getX());
            int sy = (int)Math.round(this.anchor.screen.getY());
            this.parentID = this.anGraph.getGraphIDAt(sx, sy);
        }
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }
}

