/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.BaseAnnotatable;
import java.awt.Dimension;
import java.awt.geom.Point2D;

class AnnotatePoint {
    public static final int NORMALIZED_SCREEN_SPACE = 0;
    public static final int DATA_SPACE = 1;
    Object[] data = new Object[2];
    int type = 0;
    Point2D screen;

    AnnotatePoint(Point2D screen) {
        this.screen = screen;
    }

    AnnotatePoint(Annotatable graph, String id, Object[] data) {
        this.type = id == null || id.equalsIgnoreCase("") ? 0 : 1;
        this._setData(graph, id, data);
    }

    AnnotatePoint(Annotatable graph, String id, Object[] data, int type) {
        this.type = type;
        this._setData(graph, id, data);
    }

    void move(int x, int y) {
        double newx = this.screen.getX() + (double)x;
        double newy = this.screen.getY() + (double)y;
        this.screen.setLocation(newx, newy);
    }

    private void _setData(Annotatable graph, String id, Object[] dataArray) {
        this.data[0] = dataArray[0];
        this.data[1] = dataArray[1];
        this.screen = graph.convertDataToScreen(id, dataArray);
    }

    void setData(BaseAnnotatable graph, String id, Object[] data) {
        this.data[0] = data[0];
        this.data[1] = data[1];
        this.update(graph, id);
    }

    void setSpaceType(int spaceType) {
        this.type = spaceType;
    }

    void update(BaseAnnotatable graph, String overlayID) {
        if (this.type == 0 || overlayID == null || !(graph instanceof Annotatable)) {
            double xo = (Double)this.data[0];
            double yo = (Double)this.data[1];
            Dimension size = graph.getAnnotationSize();
            this.screen = new Point2D.Double(xo * (double)size.width, yo * (double)size.height);
        } else {
            this.screen = ((Annotatable)graph).convertDataToScreen(overlayID, this.data);
        }
    }

    void finish(BaseAnnotatable graph, String overlayID) {
        if (this.type == 0 || overlayID == null || !(graph instanceof Annotatable)) {
            Dimension size = graph.getAnnotationSize();
            this.data[0] = new Double(this.screen.getX() / (double)size.width);
            this.data[1] = new Double(this.screen.getY() / (double)size.height);
        } else {
            this.data = ((Annotatable)graph).convertScreenToData(overlayID, this.screen, this.data);
        }
    }

    void setPoint(Point2D p) {
        this.screen = p;
    }

    void setPoint(Annotatable graph, String overlayID, Point2D p) {
        this.screen = p;
        this.update(graph, overlayID);
    }

    void setPoint(Annotatable graph, String overlayID, Object[] data) {
        if (overlayID != null) {
            this._setData(graph, overlayID, data);
        }
    }
}

