/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.util.SGActionEvent;
import com.sas.graphics.sg.util.SGActionListener;
import com.sas.graphics.sg.util.UnDoable;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AnnotatePropertyChangeListener;
import com.sas.graphics.sganno.Group;
import com.sas.graphics.sganno.LineElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

class AnnotateList
extends ArrayList
implements UnDoable {
    private SGActionListener listener;
    private ArrayList listeners = new ArrayList();
    private boolean modified = false;

    AnnotateList() {
    }

    @Override
    public void addActionListener(SGActionListener l) {
        this.listener = l;
    }

    public boolean contains(int x, int y) {
        for (int i = 0; i < this.size(); ++i) {
            Group gr;
            AnnotateElement ae;
            Object obj = this.get(i);
            if (!(obj instanceof AnnotateElement ? (ae = (AnnotateElement)obj).isSelected(x, y) : (gr = (Group)obj).contains(x, y))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object c) {
        if (super.contains(c)) {
            return true;
        }
        for (int i = 0; i < this.size(); ++i) {
            Group gr;
            Object obj = this.get(i);
            if (!(obj instanceof Group) || !(gr = (Group)obj).getAllMembers().contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object undo(Object state) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).propertyChange(new PropertyChangeEvent(this, "undo", null, null));
            }
        }
        if (state instanceof String) {
            StringTokenizer st = new StringTokenizer((String)state, ":");
            String action = st.nextToken();
            if (action.equals("align")) {
                String oldObj = this._undoAlign(st);
                this.fireProperty(new PropertyChangeEvent(this, "align", null, null));
                return oldObj;
            }
            if (action.equals("aligntails")) {
                String oldObj = this._undoAlignTails(st);
                this.fireProperty(new PropertyChangeEvent(this, "aligntails", null, null));
                return oldObj;
            }
            if (action.equals("alignheads")) {
                String oldObj = this._undoAlignHeads(st);
                this.fireProperty(new PropertyChangeEvent(this, "alignheads", null, null));
                return oldObj;
            }
        }
        return null;
    }

    void fireProperty(PropertyChangeEvent pce) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners.indexOf(pcl) == -1) {
            this.listeners.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    AnnotateElement getSelectedItem() {
        if (this.isEmpty()) {
            return null;
        }
        return (AnnotateElement)this.get(0);
    }

    @Override
    public boolean add(Object o) {
        if ((o instanceof AnnotateElement || o instanceof Group) && this.indexOf(o) == -1) {
            return super.add(o);
        }
        return false;
    }

    public void removeActionListener(SGActionListener l) {
        if (l == this.listener) {
            this.listener = l;
        }
    }

    void drawHandles(Graphics2D gc) {
        if (this.isEmpty()) {
            return;
        }
        Color color = gc.getColor();
        gc.setColor(Color.lightGray);
        Stroke save = gc.getStroke();
        gc.setStroke(AnnotateElement.elemBorder);
        Object obj = this.get(0);
        if (obj instanceof AnnotateElement) {
            ((AnnotateElement)obj).drawHandles(gc, Color.lightGray);
        } else {
            ((Group)obj).drawHandles(gc);
        }
        gc.setStroke(AnnotateElement.textBorder);
        for (int i = 1; i < this.size(); ++i) {
            obj = this.get(i);
            if (obj instanceof AnnotateElement) {
                ((AnnotateElement)obj).drawHandles(gc, Color.lightGray);
                continue;
            }
            ((Group)obj).drawHandles(gc);
        }
        gc.setColor(color);
        gc.setStroke(save);
    }

    @Override
    public Element getState() {
        if (this.isEmpty()) {
            return null;
        }
        int size = this.size();
        Object obj = this.get(0);
        Element aelem = obj instanceof AnnotateElement ? ((AnnotateElement)obj).getState() : ((Group)obj).getState();
        Element gelem = aelem.getOwnerDocument().createElement("AnnotateList");
        gelem.appendChild(aelem);
        for (int i = 1; i < size; ++i) {
            obj = this.get(i);
            aelem = obj instanceof AnnotateElement ? ((AnnotateElement)obj).getState() : ((Group)obj).getState();
            gelem.appendChild(((AnnotateElement)this.get(i)).getState());
        }
        return gelem;
    }

    String _undoTails(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size() && st.hasMoreTokens(); ++i) {
            String str = st.nextToken();
            Object obj = this.get(i);
            if (obj instanceof LineElement) {
                StringTokenizer st1 = new StringTokenizer(str, ",");
                double x = Double.parseDouble(st1.nextToken());
                double y = Double.parseDouble(st1.nextToken());
                LineElement le = (LineElement)obj;
                Point2D p1 = le.getSecondaryPoint();
                sb.append(":" + p1.getX() + "," + p1.getY());
                le.setSecondaryPoint(new Point2D.Double(x, y));
                continue;
            }
            sb.append(":");
        }
        String state = "aligntails" + sb;
        return state;
    }

    String _undoAlign(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size() && st.hasMoreTokens(); ++i) {
            Rectangle r;
            String str = st.nextToken();
            Object obj = this.get(i);
            StringTokenizer st1 = new StringTokenizer(str, ",");
            int x = Integer.parseInt(st1.nextToken());
            int y = Integer.parseInt(st1.nextToken());
            if (obj instanceof AnnotateElement) {
                AnnotateElement ae = (AnnotateElement)obj;
                r = ae.getShapeBounds();
                sb.append(":" + r.x + "," + r.y);
                ae.finishMove(10, x - r.x, y - r.y);
                continue;
            }
            Group gr = (Group)obj;
            r = gr.getShapeBounds();
            sb.append(":" + r.x + "," + r.y);
            gr.moveAll(10, x - r.x, y - r.y);
        }
        String state = "align" + sb;
        return state;
    }

    private String _undoAlignTails(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size() && st.hasMoreTokens(); ++i) {
            String str = st.nextToken();
            Object obj = this.get(i);
            if (obj instanceof LineElement) {
                LineElement le = (LineElement)obj;
                StringTokenizer st1 = new StringTokenizer(str, ",");
                double x = Double.parseDouble(st1.nextToken());
                double y = Double.parseDouble(st1.nextToken());
                Point2D p1 = le.getSecondaryPoint();
                sb.append(":" + p1.getX() + "," + p1.getY());
                le.setSecondaryPoint(new Point2D.Double(x, y));
                continue;
            }
            sb.append(":");
        }
        String state = "aligntails" + sb;
        return state;
    }

    private String _undoAlignHeads(StringTokenizer st) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size() && st.hasMoreTokens(); ++i) {
            String str = st.nextToken();
            Object obj = this.get(i);
            if (obj instanceof LineElement) {
                LineElement le = (LineElement)obj;
                StringTokenizer st1 = new StringTokenizer(str, ",");
                double x = Double.parseDouble(st1.nextToken());
                double y = Double.parseDouble(st1.nextToken());
                Point2D p1 = le.getAnchorPoint();
                sb.append(":" + p1.getX() + "," + p1.getY());
                le.setAnchorPoint(new Point2D.Double(x, y));
                continue;
            }
            sb.append(":");
        }
        String state = "alignheads" + sb;
        return state;
    }

    public void align(int align) {
        Rectangle aeb;
        int i;
        if (this.size() < 2) {
            return;
        }
        this.modified = true;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).disablePropertyEvents();
            }
        }
        i = 0;
        int msize = this.size();
        StringBuffer sb = new StringBuffer();
        Object obj = this.get(i);
        if (obj instanceof AnnotateElement) {
            aeb = ((AnnotateElement)obj).getShapeBounds();
            sb.append(":" + aeb.x + "," + aeb.y);
        } else {
            aeb = ((Group)obj).getShapeBounds();
            sb.append(":" + aeb.x + "," + aeb.y);
        }
        switch (align) {
            default: {
                Group gr;
                int dy;
                int dx;
                Rectangle r;
                AnnotateElement ae;
                int x = aeb.x + aeb.width / 2;
                int y = aeb.y + aeb.height / 2;
                for (i = 1; i < msize; ++i) {
                    obj = this.get(i);
                    if (obj instanceof AnnotateElement) {
                        ae = (AnnotateElement)obj;
                        r = ae.getShapeBounds();
                        dx = x - (r.x + r.width / 2);
                        dy = y - (r.y + r.height / 2);
                        sb.append(":" + r.x + "," + r.y);
                        ae.finishMove(10, dx, dy);
                        continue;
                    }
                    gr = (Group)obj;
                    r = gr.getShapeBounds();
                    dx = x - (r.x + r.width / 2);
                    dy = y - (r.y + r.height / 2);
                    sb.append(":" + r.x + "," + r.y);
                    gr.moveAll(10, dx, dy);
                }
                break;
            }
            case 2: {
                Group gr;
                int dx;
                Rectangle r;
                AnnotateElement ae;
                int x = aeb.x;
                for (i = 1; i < msize; ++i) {
                    obj = this.get(i);
                    if (obj instanceof AnnotateElement) {
                        ae = (AnnotateElement)obj;
                        r = ae.getShapeBounds();
                        dx = x - r.x;
                        sb.append(":" + r.x + "," + r.y);
                        ae.finishMove(10, dx, 0);
                        continue;
                    }
                    gr = (Group)obj;
                    r = gr.getShapeBounds();
                    dx = x - r.x;
                    sb.append(":" + r.x + "," + r.y);
                    gr.moveAll(10, dx, 0);
                }
                break;
            }
            case 4: {
                Group gr;
                int dx;
                Rectangle r;
                AnnotateElement ae;
                int x = aeb.x + aeb.width;
                for (i = 1; i < msize; ++i) {
                    obj = this.get(i);
                    if (obj instanceof AnnotateElement) {
                        ae = (AnnotateElement)obj;
                        r = ae.getShapeBounds();
                        dx = x - (r.x + r.width);
                        sb.append(":" + r.x + "," + r.y);
                        ae.finishMove(10, dx, 0);
                        continue;
                    }
                    gr = (Group)obj;
                    r = gr.getShapeBounds();
                    dx = x - (r.x + r.width);
                    sb.append(":" + r.x + "," + r.y);
                    gr.moveAll(10, dx, 0);
                }
                break;
            }
            case 3: {
                Group gr;
                int dy;
                Rectangle r;
                AnnotateElement ae;
                int y = aeb.y + aeb.height;
                for (i = 1; i < msize; ++i) {
                    obj = this.get(i);
                    if (obj instanceof AnnotateElement) {
                        ae = (AnnotateElement)obj;
                        r = ae.getShapeBounds();
                        dy = y - (r.y + r.height);
                        sb.append(":" + r.x + "," + r.y);
                        ae.finishMove(10, 0, dy);
                        continue;
                    }
                    gr = (Group)obj;
                    r = gr.getShapeBounds();
                    dy = y - (r.y + r.height);
                    sb.append(":" + r.x + "," + r.y);
                    gr.moveAll(10, 0, dy);
                }
                break;
            }
            case 1: {
                Group gr;
                int dy;
                Rectangle r;
                AnnotateElement ae;
                int y = aeb.y;
                ++i;
                while (i < msize) {
                    obj = this.get(i);
                    if (obj instanceof AnnotateElement) {
                        ae = (AnnotateElement)obj;
                        r = ae.getShapeBounds();
                        dy = y - r.y;
                        sb.append(":" + r.x + "," + r.y);
                        ae.finishMove(10, 0, dy);
                    } else {
                        gr = (Group)obj;
                        r = gr.getShapeBounds();
                        dy = y - r.y;
                        sb.append(":" + r.x + "," + r.y);
                        gr.moveAll(10, 0, dy);
                    }
                    ++i;
                }
                break block0;
            }
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = "align" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
    }

    public void alignTails(int dir) {
        int i;
        boolean horz;
        if (this.size() < 2 || !(this.get(0) instanceof LineElement)) {
            return;
        }
        this.modified = true;
        int lsize = this.listeners.size();
        boolean bl = horz = dir == 0;
        if (lsize > 0) {
            for (int i2 = 0; i2 < lsize; ++i2) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i2)).disablePropertyEvents();
            }
        }
        Point2D p = ((LineElement)this.get(0)).getSecondaryPoint();
        int msize = this.size();
        StringBuffer sb = new StringBuffer();
        sb.append(":" + p.getX() + "," + p.getY());
        for (i = 1; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.get(i);
            if (!(ae instanceof LineElement)) {
                sb.append(":");
                continue;
            }
            Point2D p1 = ((LineElement)ae).getSecondaryPoint();
            sb.append(":" + p1.getX() + "," + p1.getY());
            if (horz) {
                ((LineElement)ae).setSecondaryPoint(new Point2D.Double(p1.getX(), p.getY()));
                continue;
            }
            ((LineElement)ae).setSecondaryPoint(new Point2D.Double(p.getX(), p1.getY()));
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "alignTails", null, null);
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = "aligntails" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
    }

    public void alignHeads(int dir) {
        int i;
        boolean horz;
        if (this.size() < 2 || !(this.get(0) instanceof LineElement)) {
            return;
        }
        this.modified = true;
        int lsize = this.listeners.size();
        boolean bl = horz = dir == 0;
        if (lsize > 0) {
            for (int i2 = 0; i2 < lsize; ++i2) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i2)).disablePropertyEvents();
            }
        }
        Point2D p = ((LineElement)this.get(0)).getAnchorPoint();
        int msize = this.size();
        StringBuffer sb = new StringBuffer();
        sb.append(":" + p.getX() + "," + p.getY());
        for (i = 1; i < msize; ++i) {
            AnnotateElement ae = (AnnotateElement)this.get(i);
            if (!(ae instanceof LineElement)) {
                sb.append(":");
                continue;
            }
            Point2D p1 = ((LineElement)ae).getAnchorPoint();
            sb.append(":" + p1.getX() + "," + p1.getY());
            if (horz) {
                ((LineElement)ae).setAnchorPoint(new Point2D.Double(p1.getX(), p.getY()));
                continue;
            }
            ((LineElement)ae).setAnchorPoint(new Point2D.Double(p.getX(), p1.getY()));
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "alignHeads", null, null);
            for (i = 0; i < lsize; ++i) {
                ((AnnotatePropertyChangeListener)this.listeners.get(i)).enablePropertyEvents();
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (this.listener != null) {
            String action = "alignheads" + sb;
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
    }

    boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    public Rectangle2D getBounds() {
        int size = this.size();
        if (size == 0) {
            return new Rectangle();
        }
        Object ae = this.get(0);
        boolean dataSpace = ae instanceof AnnotateElement ? ((AnnotateElement)ae).isAnchorAttachedToData() : ((Group)ae).isAllAttachedToData();
        Rectangle2D aeb = ae instanceof AnnotateElement ? ((AnnotateElement)ae).getBounds() : ((Group)ae).getBounds();
        for (int i = 1; i < size && (dataSpace &= (ae = this.get(i)) instanceof AnnotateElement ? ((AnnotateElement)ae).isAnchorAttachedToData() : ((Group)ae).isAllAttachedToData()); ++i) {
            Rectangle2D r2d = ae instanceof AnnotateElement ? ((AnnotateElement)ae).getBounds() : ((Group)ae).getBounds();
            double xo = Math.min(aeb.getX(), r2d.getX());
            double x1 = Math.max(aeb.getX() + aeb.getWidth(), r2d.getX() + r2d.getWidth());
            double yo = Math.min(aeb.getY(), r2d.getY());
            double y1 = Math.max(aeb.getY() + aeb.getHeight(), r2d.getY() + r2d.getHeight());
            aeb.setRect(xo, yo, x1 - xo, y1 - yo);
        }
        if (dataSpace) {
            return aeb;
        }
        return this.getScreenBounds();
    }

    public Rectangle getScreenBounds() {
        int size = this.size();
        if (size == 0) {
            return new Rectangle();
        }
        Object ae = this.get(0);
        Rectangle r = ae instanceof AnnotateElement ? ((AnnotateElement)ae).getScreenBounds() : ((Group)ae).getScreenBounds();
        for (int i = 1; i < size; ++i) {
            ae = this.get(i);
            Rectangle r2 = ae instanceof AnnotateElement ? ((AnnotateElement)ae).getScreenBounds() : ((Group)ae).getScreenBounds();
            r = r.union(r2);
        }
        return r;
    }
}

