/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.interfaces.AreaInterface;
import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.interfaces.DefaultTextInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.util.SGActionEvent;
import com.sas.graphics.sg.util.SGActionListener;
import com.sas.graphics.sg.util.UnDoable;
import com.sas.graphics.sg.util.Util;
import com.sas.graphics.sganno.AAreaStyle;
import com.sas.graphics.sganno.AMarkerStyle;
import com.sas.graphics.sganno.ATextStyle;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotatePoint;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.LineElement;
import com.sas.graphics.sganno.RB;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AnnotateElement
implements KeyListener,
TextInterface,
DefaultAreaInterface,
AreaInterface,
UnDoable,
PropertyChangeListener,
DefaultTextInterface,
FocusListener {
    static final int HANDLE_NONE = -1;
    static final int HANDLE_TOPLEFT = 0;
    static final int HANDLE_LEFT = 1;
    static final int HANDLE_BOTTOMLEFT = 2;
    static final int HANDLE_BOTTOM = 3;
    static final int HANDLE_BOTTOMRIGHT = 4;
    static final int HANDLE_RIGHT = 5;
    static final int HANDLE_TOPRIGHT = 6;
    static final int HANDLE_TOP = 7;
    static final int HANDLE_ROTATE = 8;
    static final int HANDLE_MOVE = 10;
    static final int HANDLE_TEXT = 9;
    static float MITTER_LIMITS = 30.0f;
    static float PHASE = 0.0f;
    static int END_CAPS = 2;
    static int LINE_JOINS = 0;
    static final Color selectionColor = new JTextField().getSelectionColor();
    static final Color selectedTextColor = new JTextField().getSelectedTextColor();
    static final Stroke textBorder = Util.getStroke(2, 1.0f);
    static final Stroke elemBorder = new BasicStroke(2.0f);
    static final int HANDLE_WIDTH = 8;
    protected String id;
    protected String parentID;
    protected AnnotatePoint anchor;
    protected AnnotatePoint secondary;
    protected Point savedAnchor = null;
    protected Point savedSecondary = null;
    protected BasicStroke stroke;
    protected Shape shape;
    protected Shape[] handles;
    protected Element elem;
    protected Element outlineAttrs;
    protected Element fillAttrs;
    protected Element customAttrs;
    protected boolean clipOutside = true;
    protected boolean anchorAttachedToData = true;
    protected boolean secondaryAttachedToData = true;
    protected BaseAnnotatable graph;
    protected Annotatable anGraph;
    protected double rotation = 0.0;
    protected double rotx = 0.0;
    protected double roty = 0.0;
    protected AffineTransform at = new AffineTransform();
    protected boolean handleRotated = false;
    protected AAreaStyle style;
    protected Element textAttrs;
    protected Element defaultTextAttrs;
    protected ATextStyle textStyle;
    protected FontRenderContext frc = null;
    protected LineBreakMeasurer lbm = null;
    protected AttributedString as = null;
    protected int caretPosition = 0;
    protected int selectAnchor = -1;
    protected Point curPosition;
    protected boolean caretOn = false;
    protected Rectangle2D bounds;
    protected Point2D textAnchor = new Point2D.Double();
    protected Rectangle2D outside = new Rectangle2D.Double();
    protected String text = null;
    protected float wrappingWidth = 2.1474836E9f;
    protected int minTextWidth = 40;
    static final String TEMP_TEXT = " ";
    protected boolean textwrapping = true;
    Rectangle clip = null;
    protected boolean controlOn = false;
    protected boolean shiftOn = false;
    protected double aspect = 1.0;
    protected ArrayList listeners = new ArrayList();
    protected SGActionListener listener;
    protected boolean areaAttrsEnabled = false;
    protected boolean outlineAttrsEnabled = true;
    protected Annotate annotate = null;
    protected int textPosition = 0;
    protected int textAlign = 2;
    protected boolean formattingEnabled = true;
    protected int moveType = 4;
    protected boolean finishingMove = false;
    protected Color customDefaultFillColor = null;
    protected Color customDefaultLineColor = null;
    protected Color customDefaultTextColor = null;
    protected int customDefaultWidth = -1;
    protected int customDefaultPattern = -1;
    protected String customDefaultFamily = null;
    protected String customDefaultWeight = null;
    protected String customDefaultStyle = null;
    protected int customDefaultFontSize = -1;
    protected int customDefaultStyleValue = -1;
    protected boolean customDefaultFill = false;
    protected boolean customDefaultLine = true;
    String savedText = null;
    private Component c;
    protected int prevx;
    protected int prevy;

    abstract void update();

    abstract void finish();

    abstract void setInternalVariables();

    abstract void createHandles();

    abstract int getHandleAt(int var1, int var2);

    @Override
    public abstract void setFillColor(Color var1);

    public abstract void setFillColor(Color var1, int var2);

    public abstract void setAnchorAttachedToData(boolean var1);

    public abstract void setClipOutsideDataOn(boolean var1);

    public abstract void setSecondaryAttachedToData(boolean var1);

    public abstract Rectangle getAnchorBounds();

    public abstract Rectangle getSecondaryBounds();

    @Override
    public abstract void setFillOn(boolean var1);

    @Override
    public abstract void setLineOn(boolean var1);

    public abstract void setRotationAngle(double var1);

    public abstract boolean intersects(AnnotateElement var1);

    protected abstract void updateXMLNode();

    protected void setRotationVariables() {
    }

    AnnotateElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        this.graph = graph;
        this.annotate = annotate;
        this.parentID = parent;
        this.anchor = new AnnotatePoint(x);
        this.secondary = new AnnotatePoint(new Point(x.x, x.y));
        if (parent == null) {
            this.anchor.setSpaceType(0);
            this.secondary.setSpaceType(0);
        } else {
            this.anchor.setSpaceType(1);
            this.secondary.setSpaceType(1);
        }
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("AnnotateElement");
            node.appendChild(this.elem);
            this.elem.setAttribute("Parent", parent);
        }
        this.style = new AAreaStyle(annotate.getDefaultAreaStyle());
        this.textStyle = new ATextStyle(annotate.getDefaultTextStyle());
        if (graph instanceof Annotatable) {
            this.anGraph = (Annotatable)graph;
            if (this.parentID != null) {
                this.clip = this.anGraph.getDataBoundingBox(this.parentID);
            }
        } else {
            this.anGraph = null;
        }
        this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
    }

    AnnotateElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        this.graph = graph;
        this.annotate = annotate;
        this.parentID = parent;
        this.anchor = new AnnotatePoint(graph, parent, x);
        this.secondary = new AnnotatePoint(graph, parent, x);
        this.anchor.setSpaceType(1);
        this.secondary.setSpaceType(1);
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("AnnotateElement");
            node.appendChild(this.elem);
            this.elem.setAttribute("Parent", parent);
        }
        this.style = new AAreaStyle(annotate.getDefaultAreaStyle());
        this.textStyle = new ATextStyle(annotate.getDefaultTextStyle());
        this.anGraph = graph;
        this.clip = this.anGraph.getDataBoundingBox(this.parentID);
        this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
    }

    public void setParent(String newParent) {
        this.parentID = newParent;
        boolean bl = this.elem.hasAttribute("AnchorAttachedToData") ? "true".equalsIgnoreCase(this.elem.getAttribute("AnchorAttachedToData")) : (this.anchorAttachedToData = this.parentID != null);
        if (this.parentID == null || !this.anchorAttachedToData) {
            if (this.anchor.type != 0) {
                this.anchor.setSpaceType(0);
                this.anchor.finish(this.graph, this.parentID);
            }
            if (this.secondary.type != 0) {
                this.secondary.setSpaceType(0);
                this.secondary.finish(this.graph, this.parentID);
            }
        } else {
            if (this.anchor.type != 1) {
                this.anchor.setSpaceType(1);
                this.anchor.finish(this.graph, this.parentID);
            }
            if (this.secondary.type != 1) {
                this.secondary.setSpaceType(1);
                this.secondary.finish(this.graph, this.parentID);
            }
        }
        this.elem.setAttribute("Parent", this.parentID);
        if (this.parentID != null && this.anchorAttachedToData) {
            this.clip = this.anGraph.getDataBoundingBox(this.parentID);
        }
    }

    void drawHandles(Graphics2D gc) {
        this._drawHandles(gc);
    }

    protected void _drawHandles(Graphics2D gc) {
        int i;
        AffineTransform save = gc.getTransform();
        Stroke stroke = gc.getStroke();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        gc.setColor(Color.lightGray);
        gc.setStroke(elemBorder);
        gc.draw(this.shape.getBounds());
        gc.setColor(Color.white);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.fill(this.handles[i]);
        }
        gc.setColor(Color.lightGray);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.draw(this.handles[i]);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        gc.setStroke(stroke);
    }

    void drawHandles(Graphics2D gc, Color color) {
        this._drawHandles(gc, color);
    }

    protected void _drawHandles(Graphics2D gc, Color color) {
        int i;
        AffineTransform save = gc.getTransform();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        gc.setColor(color);
        gc.draw(this.shape.getBounds());
        gc.setColor(Color.white);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.fill(this.handles[i]);
        }
        gc.setColor(color);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.draw(this.handles[i]);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
    }

    protected Shape _drawBorderAndCaret(Graphics2D gc) {
        Stroke save = gc.getStroke();
        gc.setStroke(textBorder);
        gc.setColor(Color.LIGHT_GRAY);
        gc.draw(this.handles[9]);
        gc.setStroke(save);
        Shape s = null;
        if (this.caretOn) {
            s = this._drawCaret(gc);
        }
        return s;
    }

    protected float _getTextAnchor(TextLayout tl) {
        float start;
        if (this.textwrapping) {
            Rectangle r = this.handles[9].getBounds();
            float twidth = r.width;
            start = this.textAlign == 4 ? (float)r.x + twidth - 2.0f - tl.getAdvance() : (this.textAlign == 0 ? (float)r.x + (twidth - tl.getAdvance()) / 2.0f : (float)(r.x + 2));
        } else {
            start = (float)this.textAnchor.getX();
        }
        return start;
    }

    protected final Shape _drawCaret(Graphics2D gc) {
        boolean extsel;
        Stroke saveStroke = gc.getStroke();
        gc.setStroke(textBorder);
        this.checkTextLayout();
        gc.setColor(Color.LIGHT_GRAY);
        gc.draw(this.outside);
        gc.setStroke(new BasicStroke(1.0f));
        this.lbm.setPosition(0);
        int prevpos1 = 0;
        TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
        float tx = this._getTextAnchor(tl);
        float ty = (float)this.textAnchor.getY();
        Shape r = null;
        boolean bl = extsel = this.selectAnchor != -1 && this.selectAnchor != this.caretPosition;
        if (extsel) {
            gc.setColor(selectionColor);
            Rectangle2D rect = tl.getBounds();
            float tt = 0.0f;
            if (this.textwrapping) {
                do {
                    Rectangle2D rr = tl.getBounds();
                    rect.add(rr.getMinX() - 3.0, (double)tt + rr.getMinY() - 3.0);
                    rect.add(rr.getMaxX() + 3.0, (double)tt + rr.getMaxY() + 3.0);
                    tt += tl.getAscent() + tl.getDescent() + tl.getLeading();
                } while ((tl = this.lbm.nextLayout(this.wrappingWidth)) != null);
            }
            gc.translate(tx, ty);
            gc.fill(rect);
            gc.translate(-tx, -ty);
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(this.wrappingWidth);
            this.formattingEnabled = true;
        } else {
            boolean bl2 = this.formattingEnabled = this.text == null || this.text.length() == 0;
        }
        while (this.lbm.getPosition() < this.caretPosition) {
            prevpos1 = this.lbm.getPosition();
            ty += tl.getDescent() + tl.getLeading();
            tl = this.lbm.nextLayout(this.wrappingWidth);
            ty += tl.getAscent();
        }
        int relCaretPosition = this.caretPosition - prevpos1;
        Shape[] carets = tl.getCaretShapes(relCaretPosition);
        gc.setColor(Color.GRAY);
        float start = this._getTextAnchor(tl);
        gc.translate(start, ty);
        gc.draw(carets[0]);
        gc.translate(-start, -ty);
        gc.setStroke(saveStroke);
        return r;
    }

    void move(int moveType, int x, int y) {
        if (moveType == 10) {
            this.anchor.move(x, y);
        }
        if (this.annotate.isDataValuesDirty() && this.isAnchorAttachedToData()) {
            this.anchor.finish(this.graph, this.parentID);
        }
        if (moveType == 9) {
            this.prevx += x;
            this.prevy += y;
            this.setCaretPosition(this.prevx, this.prevy);
        } else if (!this.finishingMove) {
            this.setInternalVariables();
            int lsize = this.listeners.size();
            if (lsize > 0) {
                PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
                for (int i = 0; i < lsize; ++i) {
                    ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
                }
            }
        }
    }

    void finishMove(int moveType, int x, int y) {
        this.finishingMove = true;
        this.move(moveType, x, y);
        if (moveType != 9) {
            this.finish();
        }
        this.finishingMove = false;
    }

    void startMove(int moveType) {
        if (this.listener != null && (moveType != -1 || moveType != 9)) {
            Element e;
            if (this.caretOn && (this.savedText == null && this.text != null && this.text.length() > 0 || this.savedText != null && !this.savedText.equals(this.text))) {
                e = this.elem.getOwnerDocument().createElement("Text");
                e.setAttribute("text", this.savedText);
                this.listener.actionPerformed(new SGActionEvent(this, e));
                this.savedText = this.text;
            }
            e = this.elem.getOwnerDocument().createElement("Move");
            e.setAttribute("asx", Integer.toString((int)this.anchor.screen.getX()));
            e.setAttribute("asy", Integer.toString((int)this.anchor.screen.getY()));
            e.setAttribute("ssx", Integer.toString((int)this.secondary.screen.getX()));
            e.setAttribute("ssy", Integer.toString((int)this.secondary.screen.getY()));
            e.setAttribute("adx", this.anchor.data[0].toString());
            e.setAttribute("ady", this.anchor.data[1].toString());
            e.setAttribute("sdx", this.secondary.data[0].toString());
            e.setAttribute("sdy", this.secondary.data[1].toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
    }

    @Override
    public final Color getFillColor() {
        Color c = this.style.getFillColor();
        if (c.getRGB() != this.getDefaultFillColor().getRGB()) {
            return c;
        }
        return null;
    }

    @Override
    public final Color getLineColor() {
        Color c = this.style.getLineColor();
        if (c.getRGB() != this.getDefaultLineColor().getRGB()) {
            return c;
        }
        return null;
    }

    @Override
    public final int getLinePattern() {
        int pattern = this.style.getLinePattern();
        if (pattern != this.getDefaultLinePattern()) {
            return pattern;
        }
        return -1;
    }

    @Override
    public final int getLineWidth() {
        if (this.style.isLineWidthCustom()) {
            return this.style.getLineWidth();
        }
        return -1;
    }

    @Override
    public final void setLineColor(Color c) {
        int lsize;
        Color oldColor = this.style.getLineColor();
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("LineAttrs");
            e.setAttribute("color", Integer.toString(oldColor.getRGB()));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setLineColor(c);
        if (this.elem != null) {
            if (c != null) {
                if (this.outlineAttrs == null) {
                    this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                    this.elem.appendChild(this.outlineAttrs);
                }
                this.outlineAttrs.setAttribute("color", Integer.toString(c.getRGB()));
            } else if (this.outlineAttrs != null && this.outlineAttrs.hasAttribute("color")) {
                this.outlineAttrs.removeAttribute("color");
            }
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "lineColor", oldColor, c);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    private void _saveTextIfNeeded() {
        if (this.listener != null && (this.savedText == null && this.text != null && this.text.length() > 0 || this.savedText != null && !this.savedText.equals(this.text))) {
            Element e = this.elem.getOwnerDocument().createElement("Text");
            e.setAttribute("text", this.savedText);
            this.listener.actionPerformed(new SGActionEvent(this, e));
            this.savedText = "";
        }
    }

    private void _saveNullText() {
        if (this.listener != null && this.savedText == null && this.text != null && this.text.length() > 0) {
            Element e = this.elem.getOwnerDocument().createElement("Text");
            e.setAttribute("text", "");
            this.listener.actionPerformed(new SGActionEvent(this, e));
            this.savedText = "";
        }
    }

    @Override
    public final void setFontColor(Color c) {
        int lsize;
        Color oldColor = this.textStyle.getFontColor();
        if (c == null && this.customDefaultTextColor != null) {
            c = this.customDefaultTextColor;
        }
        this.textStyle.setFontColor(c);
        if (this.as != null) {
            Color cc = this.textStyle.getFontColor();
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            if (this.frc != null) {
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            }
        }
        if (this.elem != null) {
            if (c != null) {
                if (this.textAttrs == null) {
                    this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                    this.elem.appendChild(this.textAttrs);
                }
                this.textAttrs.setAttribute("color", Integer.toString(c.getRGB()));
            } else if (this.textAttrs != null && this.textAttrs.hasAttribute("color")) {
                this.textAttrs.removeAttribute("color");
            }
        }
        if (this.listener != null) {
            this._saveNullText();
            Element e = this.elem.getOwnerDocument().createElement("TextAttrs");
            if (oldColor != null) {
                e.setAttribute("color", Integer.toString(oldColor.getRGB()));
            }
            if (this.caretOn) {
                if (this.text != null && this.text.length() > 0) {
                    e.setAttribute("text", this.text);
                    this.savedText = this.text;
                } else {
                    this.savedText = "";
                    e.setAttribute("text", TEMP_TEXT);
                }
            }
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "textColor", oldColor, c);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final Color getFontColor() {
        Color c = this.textStyle.getFontColor();
        if (c != null && c.getRGB() == this.getDefaultFontColor().getRGB()) {
            return null;
        }
        return c;
    }

    @Override
    public final void setFont(Font f) {
        Font oldFont;
        Font font = oldFont = this.textStyle.isFontCustom() ? this.textStyle.getFont() : null;
        if (this.listener != null) {
            this._saveNullText();
            Element e = this.elem.getOwnerDocument().createElement("TextAttrs");
            if (oldFont != null) {
                e.setAttribute("size", Integer.toString(oldFont.getSize()));
                e.setAttribute("family", oldFont.getFamily());
                e.setAttribute("style", oldFont.isItalic() ? "italic" : "normal");
                e.setAttribute("weight", oldFont.isBold() ? "bold" : "normal");
            } else {
                e.setAttribute("font", "default");
            }
            if (this.caretOn) {
                if (this.text != null && this.text.length() > 0) {
                    e.setAttribute("text", this.text);
                    this.savedText = this.text;
                } else {
                    this.savedText = "";
                    e.setAttribute("text", TEMP_TEXT);
                }
            }
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if (this.elem != null) {
            if (f != null) {
                if (this.textAttrs == null) {
                    this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                    this.elem.appendChild(this.textAttrs);
                }
                this.textAttrs.setAttribute("family", f.getFamily());
                this.textAttrs.setAttribute("size", Integer.toString(f.getSize()));
                if (f.isItalic()) {
                    this.textAttrs.setAttribute("style", "italic");
                } else {
                    this.textAttrs.setAttribute("style", "normal");
                }
                if (f.isBold()) {
                    this.textAttrs.setAttribute("weight", "bold");
                } else {
                    this.textAttrs.setAttribute("weight", "normal");
                }
            } else if (this.textAttrs != null) {
                this.elem.removeChild(this.textAttrs);
                this.textAttrs = null;
            }
        }
        this.textStyle.setFont(f);
        this.lbm = null;
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "font", oldFont, f);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void setFontFamily(String f) {
        Font font = this.textStyle.getFont();
        String df = this.getDefaultFontFamily();
        String oldFamily = font.getFamily();
        if (f == null || f.length() == 0) {
            f = df;
        }
        if (this.listener != null) {
            this._saveNullText();
            Element e = this.elem.getOwnerDocument().createElement("TextAttrs");
            e.setAttribute("family", oldFamily);
            if (this.caretOn) {
                if (this.text != null && this.text.length() > 0) {
                    e.setAttribute("text", this.text);
                    this.savedText = this.text;
                } else {
                    this.savedText = "";
                    e.setAttribute("text", TEMP_TEXT);
                }
            }
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if (this.elem != null) {
            if (f.equalsIgnoreCase(this.customDefaultFamily) || !f.equalsIgnoreCase(df)) {
                if (this.textAttrs == null) {
                    this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                    this.elem.appendChild(this.textAttrs);
                }
                this.textAttrs.setAttribute("family", f);
            } else if (this.textAttrs != null) {
                this.textAttrs.removeAttribute("family");
            }
        }
        this.textStyle.setFontFamily(f);
        this.lbm = null;
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fontFamily", oldFamily, f);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void setFontSize(int sz) {
        Font font = this.textStyle.getFont();
        int dfsz = this.getDefaultFontSize();
        int oldSize = font.getSize();
        if (sz == -1) {
            sz = dfsz;
        }
        if (this.listener != null) {
            this._saveNullText();
            Element e = this.elem.getOwnerDocument().createElement("TextAttrs");
            e.setAttribute("size", Integer.toString(oldSize));
            if (this.caretOn) {
                if (this.text != null && this.text.length() > 0) {
                    e.setAttribute("text", this.text);
                    this.savedText = this.text;
                } else {
                    this.savedText = "";
                    e.setAttribute("text", TEMP_TEXT);
                }
            }
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if (this.elem != null) {
            if (sz == this.customDefaultFontSize || sz != dfsz) {
                if (this.textAttrs == null) {
                    this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                    this.elem.appendChild(this.textAttrs);
                }
                this.textAttrs.setAttribute("size", Integer.toString(sz));
            } else if (this.textAttrs != null) {
                this.textAttrs.removeAttribute("size");
            }
        }
        this.textStyle.setFontSize(sz);
        this.lbm = null;
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fontSize", Integer.toString(oldSize), Integer.toString(sz));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void setFontStyle(int style) {
        Font font = this.textStyle.getFont();
        int dfst = this.getDefaultFontStyle();
        int oldStyle = font.getStyle();
        if (style == -1) {
            style = dfst;
        }
        if (this.listener != null) {
            this._saveNullText();
            Element e = this.elem.getOwnerDocument().createElement("TextAttrs");
            e.setAttribute("style", Integer.toString(oldStyle));
            e.setAttribute("style", font.isItalic() ? "ITALIC" : "NORMAL");
            e.setAttribute("weight", font.isBold() ? "BOLD" : "NORMAL");
            if (this.caretOn) {
                if (this.text != null && this.text.length() > 0) {
                    e.setAttribute("text", this.text);
                    this.savedText = this.text;
                } else {
                    this.savedText = "";
                    e.setAttribute("text", TEMP_TEXT);
                }
            }
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if (this.elem != null) {
            if (style == this.customDefaultStyleValue || style != dfst) {
                if (this.textAttrs == null) {
                    this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                    this.elem.appendChild(this.textAttrs);
                }
                this.textAttrs.setAttribute("style", (style & 2) != 0 ? "ITALIC" : "NORMAL");
                this.textAttrs.setAttribute("weight", (style & 1) != 0 ? "BOLD" : "NORMAL");
            } else if (this.textAttrs != null) {
                this.textAttrs.removeAttribute("style");
                this.textAttrs.removeAttribute("weight");
            }
        }
        this.textStyle.setFontStyle(style);
        this.lbm = null;
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fontStyle", new Integer(oldStyle), new Integer(style));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void setBold(boolean bold) {
        String newValue;
        Font font = this.textStyle.getFont();
        String oldValue = font.isBold() ? "BOLD" : "NORMAL";
        String string = newValue = bold ? "BOLD" : "NORMAL";
        if (this.listener != null) {
            this._saveNullText();
            Element e = this.elem.getOwnerDocument().createElement("TextAttrs");
            e.setAttribute("weight", oldValue);
            if (this.caretOn) {
                if (this.text != null && this.text.length() > 0) {
                    e.setAttribute("text", this.text);
                    this.savedText = this.text;
                } else {
                    this.savedText = "";
                    e.setAttribute("text", TEMP_TEXT);
                }
            }
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if (this.elem != null) {
            if (this.textAttrs == null) {
                this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                this.elem.appendChild(this.textAttrs);
            }
            this.textAttrs.setAttribute("weight", newValue);
        }
        this.textStyle.setBold(bold);
        this.lbm = null;
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "bold", oldValue, newValue);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void setItalic(boolean italic) {
        String newValue;
        Font font = this.textStyle.getFont();
        String oldValue = font.isItalic() ? "ITALIC" : "NORMAL";
        String string = newValue = italic ? "ITALIC" : "NORMAL";
        if (this.listener != null) {
            this._saveNullText();
            Element e = this.elem.getOwnerDocument().createElement("TextAttrs");
            e.setAttribute("style", oldValue);
            if (this.caretOn) {
                if (this.text != null && this.text.length() > 0) {
                    e.setAttribute("text", this.text);
                    this.savedText = this.text;
                } else {
                    this.savedText = "";
                    e.setAttribute("text", TEMP_TEXT);
                }
            }
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        if (this.elem != null) {
            if (this.textAttrs == null) {
                this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                this.elem.appendChild(this.textAttrs);
            }
            this.textAttrs.setAttribute("style", newValue);
        }
        this.textStyle.setItalic(italic);
        this.lbm = null;
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "italic", oldValue, newValue);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final Font getFont() {
        return this.textStyle.getFont();
    }

    @Override
    public final String getFontFamily() {
        String f = this.textStyle.getFont().getFamily();
        if (f.equalsIgnoreCase(this.getDefaultFontFamily())) {
            return "";
        }
        return f;
    }

    @Override
    public final int getFontSize() {
        int f = this.textStyle.getFont().getSize();
        if (f == this.getDefaultFontSize()) {
            return -1;
        }
        return f;
    }

    @Override
    public final int getFontStyle() {
        int f = this.textStyle.getFont().getStyle();
        if (f == this.getDefaultFontStyle()) {
            return -1;
        }
        return f;
    }

    @Override
    public final boolean isBold() {
        return this.textStyle.isBold();
    }

    @Override
    public final boolean isItalic() {
        return this.textStyle.isItalic();
    }

    public boolean isSelected(int x, int y) {
        Point2D p1 = new Point2D.Double(x, y);
        if (this.rotation != 0.0) {
            try {
                p1 = this.at.inverseTransform(p1, p1);
            }
            catch (NoninvertibleTransformException e) {
                return false;
            }
        }
        if (this.shape.contains(p1)) {
            return true;
        }
        Rectangle bounds = this.shape.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            if (bounds.width == 0) {
                --bounds.x;
                bounds.width = 2;
            }
            if (bounds.height == 0) {
                --bounds.y;
                bounds.height = 2;
            }
            if (bounds.contains(p1)) {
                return true;
            }
        }
        for (int i = 0; i < this.handles.length; ++i) {
            if (!this.handles[i].contains(p1)) continue;
            return true;
        }
        return false;
    }

    public final void setColor(Color c) {
        this.setFontColor(c);
    }

    public final Color getColor() {
        if (this.textStyle.isCustomColor()) {
            return this.textStyle.getFontColor();
        }
        return null;
    }

    public final double getRotationAngle() {
        return this.rotation * 180.0 / Math.PI;
    }

    void paint(Graphics2D gc) {
        Shape prevClip = gc.getClip();
        if (this.clip != null && this.clipOutside) {
            Rectangle newclip = prevClip == null ? this.clip : this.clip.createIntersection(prevClip.getBounds2D());
            gc.setClip(newclip);
        }
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform save = gc.getTransform();
        int alpha = this.style.getAlpha();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        Stroke saveStroke = gc.getStroke();
        gc.setStroke(this.stroke);
        Font f = this.textStyle.getFont();
        gc.setFont(new Font(f.getFamily(), f.getStyle(), f.getSize() + 2));
        if (this.frc == null) {
            this.frc = gc.getFontRenderContext();
            this.lbm = null;
        }
        if (this.style.isFillOn()) {
            if (alpha >= 0 && alpha < 255) {
                Color c = this.style.getFillColor();
                int argb = alpha << 24 | c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
                gc.setColor(new Color(argb, true));
            } else {
                gc.setColor(this.style.getFillColor());
            }
            gc.fill(this.shape);
        }
        if (this.style.isLineOn()) {
            gc.setColor(this.style.getLineColor());
            gc.draw(this.shape);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        if (this.text != null) {
            boolean extsel;
            if (this.lbm == null) {
                this.checkTextLayout();
            }
            boolean bl = extsel = this.caretPosition != this.selectAnchor && this.selectAnchor != -1;
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, selectedTextColor);
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            } else if (this.rotation != 0.0) {
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            }
            if (this.caretOn) {
                this._drawBorderAndCaret(gc);
            }
            float tx = (float)this.textAnchor.getX();
            float ty = (float)this.textAnchor.getY();
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            if (this.textwrapping) {
                while (true) {
                    float start = this._getTextAnchor(tl);
                    tl.draw(gc, start, ty);
                    ty += tl.getDescent() + tl.getLeading();
                    tl = this.lbm.nextLayout(this.wrappingWidth);
                    if (tl != null) {
                        ty += tl.getAscent();
                        continue;
                    }
                    break;
                }
            } else {
                tl.draw(gc, tx, ty);
            }
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textStyle.getFontColor());
                this.lbm = null;
            }
        } else if (this.caretOn) {
            this._drawBorderAndCaret(gc);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        gc.setStroke(saveStroke);
        gc.setClip(prevClip);
    }

    @Override
    public boolean isFillOn() {
        return this.style.isFillOn();
    }

    public boolean isClipOutsideDataOn() {
        return this.clipOutside && this.parentID != null;
    }

    public boolean isAnchorAttachedToData() {
        return this.parentID != null && this.anchorAttachedToData;
    }

    public boolean isSecondaryAttachedToData() {
        return this.secondaryAttachedToData;
    }

    public boolean canAnchorAttachedToData() {
        return this.parentID != null;
    }

    public boolean canSecondaryAttachedToData() {
        return this.parentID != null;
    }

    @Override
    public boolean isLineOn() {
        return this.style.isLineOn();
    }

    void load(Element aElem, boolean loadOnly) {
        String value;
        this.elem = aElem;
        String string = this.parentID = this.graph instanceof Annotatable ? this.elem.getAttribute("Parent") : null;
        if (this.parentID != null && this.parentID.equals("")) {
            this.parentID = null;
        }
        if (this.elem.hasAttribute("Rotation")) {
            this.rotation = Double.parseDouble(this.elem.getAttribute("Rotation"));
        }
        if (this.elem.hasAttribute("textPosition")) {
            value = this.elem.getAttribute("textPosition");
            this.textPosition = value.equalsIgnoreCase("Top") ? 1 : (value.equalsIgnoreCase("Bottom") ? 3 : (value.equalsIgnoreCase("Start") ? 10 : (value.equalsIgnoreCase("End") ? 11 : 0)));
        }
        if (this.elem.hasAttribute("textAlignment")) {
            value = this.elem.getAttribute("textAlignment");
            this.textAlign = Integer.parseInt(value);
        }
        boolean bl = this.elem.hasAttribute("AnchorAttachedToData") ? "true".equalsIgnoreCase(this.elem.getAttribute("AnchorAttachedToData")) : (this.anchorAttachedToData = this.parentID != null);
        if (!this.anchorAttachedToData || this.parentID == null) {
            double x = Double.parseDouble(this.elem.getAttribute("SAnchorX"));
            double y = Double.parseDouble(this.elem.getAttribute("SAnchorY"));
            Point2D.Double pt = new Point2D.Double(x, y);
            this.anchor = new AnnotatePoint(pt);
            this.anchor.setSpaceType(0);
            x = Double.parseDouble(this.elem.getAttribute("SSecondaryX"));
            y = Double.parseDouble(this.elem.getAttribute("SSecondaryY"));
            pt = new Point2D.Double(x, y);
            this.secondary = new AnnotatePoint(pt);
        } else {
            String ax = this.elem.getAttribute("AnchorX");
            String ay = this.elem.getAttribute("AnchorY");
            Object[] pt = new Object[2];
            try {
                pt[0] = Double.valueOf(ax);
            }
            catch (NumberFormatException nfe) {
                pt[0] = ax;
            }
            try {
                pt[1] = Double.valueOf(ay);
            }
            catch (NumberFormatException nfe) {
                pt[1] = ay;
            }
            this.anchor = new AnnotatePoint((Annotatable)this.graph, this.parentID, pt);
            String sx = this.elem.getAttribute("SecondaryX");
            String sy = this.elem.getAttribute("SecondaryY");
            pt = new Object[2];
            try {
                pt[0] = Double.valueOf(sx);
            }
            catch (NumberFormatException nfe) {
                pt[0] = sx;
            }
            try {
                pt[1] = Double.valueOf(sy);
            }
            catch (NumberFormatException nfe) {
                pt[1] = sy;
            }
            this.secondary = new AnnotatePoint((Annotatable)this.graph, this.parentID, pt);
        }
        this._setCustomAttributes();
        if (this.customAttrs != null) {
            if (this.customAttrs.hasAttribute("fill")) {
                this.customDefaultFill = "true".equalsIgnoreCase(this.customAttrs.getAttribute("fill"));
                this.style.setFillOn(this.customDefaultFill);
            }
        } else if (this.elem.hasAttribute("fill")) {
            String str = this.elem.getAttribute("fill");
            this.customDefaultFill = !str.equalsIgnoreCase("false");
            this.style.setFillOn(this.customDefaultFill);
        }
        if (this.customAttrs != null) {
            if (this.customAttrs.hasAttribute("line")) {
                this.customDefaultLine = "true".equalsIgnoreCase(this.customAttrs.getAttribute("line"));
                this.style.setLineOn(this.customDefaultLine);
            }
        } else if (this.elem.hasAttribute("line")) {
            String str = this.elem.getAttribute("line");
            this.customDefaultLine = !str.equalsIgnoreCase("false");
            this.style.setLineOn(this.customDefaultLine);
        }
        if (this.elem.hasAttribute("display")) {
            String str = this.elem.getAttribute("display");
            boolean fill = false;
            boolean line = false;
            if (str.equalsIgnoreCase("fill")) {
                this.style.setFillOn(true);
                this.style.setLineOn(false);
                fill = true;
            } else if (str.equalsIgnoreCase("fillOutline")) {
                this.style.setFillOn(true);
                this.style.setLineOn(true);
                fill = true;
                line = true;
            } else {
                this.style.setFillOn(false);
                this.style.setLineOn(true);
                line = true;
            }
            this.elem.removeAttribute("display");
            if (fill) {
                this.elem.setAttribute("fill", "true");
            }
            if (!line) {
                this.elem.setAttribute("line", "false");
            }
        } else {
            if (this.elem.hasAttribute("line")) {
                boolean line = this.elem.getAttribute("line").toLowerCase().equals("true");
                this.style.setLineOn(line);
            }
            if (this.elem.hasAttribute("fill")) {
                boolean fill = this.elem.getAttribute("fill").toLowerCase().equals("true");
                this.style.setFillOn(fill);
            }
        }
        if (this.elem.hasAttribute("transparency")) {
            String ca = this.elem.getAttribute("transparency");
            int transparency = Integer.parseInt(ca);
            this.style.setFillTrans(transparency);
        }
        if (this.elem.hasAttribute("text")) {
            this.savedText = this.text = this.elem.getAttribute("text");
        }
        this.caretOn = false;
        this.lbm = null;
        if (this.elem.hasAttribute("AnchorAttachedToData")) {
            String str = this.elem.getAttribute("AnchorAttachedToData");
            this.anchorAttachedToData = str.equalsIgnoreCase("true");
            if (this.parentID != null && this.graph instanceof Annotatable && !this.anchorAttachedToData) {
                this.anchor.setSpaceType(0);
                this.anchor.finish(this.graph, this.parentID);
            }
        }
        if (this.elem.hasAttribute("SecondaryAttachedToData") || this.elem.hasAttribute("SecondaryParent")) {
            String secondaryParent;
            String str = this.elem.hasAttribute("SecondaryAttachedToData") ? this.elem.getAttribute("SecondaryAttachedToData") : "true";
            this.secondaryAttachedToData = !str.equalsIgnoreCase("false");
            String string2 = secondaryParent = this.graph instanceof Annotatable ? this.elem.getAttribute("SecondaryParent") : null;
            if (secondaryParent != null && secondaryParent.equals("")) {
                secondaryParent = null;
            }
            if (this.secondaryAttachedToData && secondaryParent != null && this.graph instanceof Annotatable) {
                this.secondary.setSpaceType(1);
                this.secondary.finish(this.graph, secondaryParent);
            } else {
                this.secondary.setSpaceType(0);
                this.secondary.finish(this.graph, secondaryParent);
            }
        }
        if (this.elem.hasAttribute("ClipOutside")) {
            String str = this.elem.getAttribute("ClipOutside");
            this.clipOutside = str.equalsIgnoreCase("true");
        }
        this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
        if (loadOnly) {
            this.elem = null;
        }
    }

    final Element getElement() {
        return this.elem;
    }

    protected final void _setCustomAttributes() {
        int rgb;
        int fstyle;
        boolean italic;
        boolean bold;
        Color color;
        int rgb2;
        String c;
        String elemTag = "";
        for (Node node = this.elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("LineAttrs")) {
                this.outlineAttrs = (Element)node;
                continue;
            }
            if (elemTag.equals("FillAttrs")) {
                this.fillAttrs = (Element)node;
                continue;
            }
            if (elemTag.equals("TextAttrs")) {
                this.textAttrs = (Element)node;
                continue;
            }
            if (!elemTag.equals("CustomAttrs")) continue;
            this.customAttrs = (Element)node;
        }
        if (this.customAttrs != null && this.customAttrs.hasAttribute("fillColor")) {
            c = this.customAttrs.getAttribute("fillColor");
            rgb2 = Integer.parseInt(c);
            this.customDefaultFillColor = new Color(rgb2);
            this.style.setFillColor(this.customDefaultFillColor);
        }
        if (this.fillAttrs != null && this.fillAttrs.hasAttribute("color")) {
            c = this.fillAttrs.getAttribute("color");
            rgb2 = Integer.parseInt(c);
            color = new Color(rgb2);
            this.style.setFillColor(color);
            if (this.customAttrs == null) {
                this.customDefaultFillColor = color;
            }
        }
        if (this.customAttrs != null) {
            if (this.customAttrs.hasAttribute("pattern")) {
                this.customDefaultPattern = Integer.parseInt(this.customAttrs.getAttribute("pattern"));
                this.style.setLinePattern(this.customDefaultPattern);
            }
            if (this.customAttrs.hasAttribute("width")) {
                this.customDefaultWidth = Integer.parseInt(this.customAttrs.getAttribute("width"));
                this.style.setLinePattern(this.customDefaultWidth);
            }
            if (this.customAttrs.hasAttribute("lineColor")) {
                c = this.customAttrs.getAttribute("lineColor");
                rgb2 = Integer.parseInt(c);
                this.customDefaultLineColor = new Color(rgb2);
                this.style.setLineColor(this.customDefaultLineColor);
            }
        }
        if (this.outlineAttrs != null) {
            if (this.outlineAttrs.hasAttribute("pattern")) {
                int pattern = Integer.parseInt(this.outlineAttrs.getAttribute("pattern"));
                this.style.setLinePattern(pattern);
                if (this.customAttrs == null) {
                    this.customDefaultPattern = pattern;
                }
            }
            if (this.outlineAttrs.hasAttribute("width")) {
                int width = Integer.parseInt(this.outlineAttrs.getAttribute("width"));
                this.style.setLineWidth(width);
                if (this.customAttrs == null) {
                    this.customDefaultWidth = width;
                }
            }
            if (this.outlineAttrs.hasAttribute("color")) {
                String c2 = this.outlineAttrs.getAttribute("color");
                rgb2 = Integer.parseInt(c2);
                color = new Color(rgb2);
                this.style.setLineColor(color);
                if (this.customAttrs == null) {
                    this.customDefaultLineColor = color;
                }
            }
        }
        boolean customText = false;
        String family = null;
        String weight = null;
        String style = null;
        int fsize = -1;
        if (this.customAttrs != null) {
            if (this.customAttrs.hasAttribute("family")) {
                family = this.customDefaultFamily = this.customAttrs.getAttribute("family");
                customText = true;
            }
            if (this.customAttrs.hasAttribute("fontSize")) {
                fsize = this.customDefaultFontSize = Integer.parseInt(this.customAttrs.getAttribute("fontSize"));
                customText = true;
            }
            if (this.customAttrs.hasAttribute("weight")) {
                weight = this.customDefaultWeight = this.customAttrs.getAttribute("weight");
                customText = true;
            }
            if (this.customAttrs.hasAttribute("style")) {
                style = this.customDefaultStyle = this.customAttrs.getAttribute("style");
                customText = true;
            }
        }
        if (this.textAttrs != null) {
            customText = true;
            if (this.textAttrs.hasAttribute("family")) {
                family = this.textAttrs.getAttribute("family");
                if (this.customAttrs == null) {
                    this.customDefaultFamily = family;
                }
            }
            if (this.textAttrs.hasAttribute("size")) {
                fsize = Integer.parseInt(this.textAttrs.getAttribute("size"));
                if (this.customAttrs == null) {
                    this.customDefaultFontSize = fsize;
                }
            }
            if (this.textAttrs.hasAttribute("weight")) {
                weight = this.textAttrs.getAttribute("weight").toUpperCase();
                if (this.customAttrs == null) {
                    this.customDefaultWeight = weight;
                }
            }
            if (this.textAttrs.hasAttribute("style")) {
                style = this.textAttrs.getAttribute("style").toUpperCase();
                if (this.customAttrs == null) {
                    this.customDefaultStyle = style;
                }
            }
        }
        Font f = this.textStyle.getFont();
        if (this.customDefaultStyle != null || this.customDefaultWeight != null) {
            bold = this.customDefaultWeight != null ? this.customDefaultWeight.equals("BOLD") : f.isBold();
            italic = this.customDefaultStyle != null ? this.customDefaultStyle.equals("ITALIC") : f.isItalic();
            fstyle = 0;
            if (bold) {
                fstyle |= 1;
            }
            if (italic) {
                fstyle |= 2;
            }
            if (style != null || weight != null) {
                this.customDefaultStyleValue = fstyle;
            }
        }
        if (customText) {
            if (family == null) {
                family = f.getFamily();
            }
            if (fsize == -1) {
                fsize = f.getSize();
            }
            bold = weight != null ? weight.equals("BOLD") : f.isBold();
            italic = style != null ? style.equals("ITALIC") : f.isItalic();
            fstyle = 0;
            if (bold) {
                fstyle |= 1;
            }
            if (italic) {
                fstyle |= 2;
            }
            this.textStyle.setFont(new Font(family, fstyle, fsize));
        }
        if (this.customAttrs != null && this.customAttrs.hasAttribute("textColor")) {
            String c3 = this.customAttrs.getAttribute("textColor");
            rgb = Integer.parseInt(c3);
            this.customDefaultTextColor = new Color(rgb);
            this.textStyle.setFontColor(this.customDefaultTextColor);
        }
        if (this.textAttrs != null && this.textAttrs.hasAttribute("color")) {
            String c4 = this.textAttrs.getAttribute("color");
            rgb = Integer.parseInt(c4);
            Color color2 = new Color(rgb);
            this.textStyle.setFontColor(color2);
            if (this.customAttrs == null) {
                this.customDefaultTextColor = color2;
            }
        }
    }

    public final boolean isLineColorCustom() {
        return this.outlineAttrs != null && this.outlineAttrs.hasAttribute("color");
    }

    public final boolean isLineThicknessCustom() {
        return this.outlineAttrs != null && this.outlineAttrs.hasAttribute("width");
    }

    public final boolean isLinePatternCustom() {
        return this.outlineAttrs != null && this.outlineAttrs.hasAttribute("pattern");
    }

    public final boolean isFillColorCustom() {
        return this.fillAttrs != null && this.fillAttrs.hasAttribute("color");
    }

    public final void setLineStyle(LineInterface li) {
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("LineAttrs");
            e.setAttribute("pattern", Integer.toString(this.style.getLinePattern()));
            e.setAttribute("width", Integer.toString(this.style.getLineWidth()));
            e.setAttribute("color", Integer.toString(this.style.getLineColor().getRGB()));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setLineStyle(li);
        if (this.elem != null) {
            if (this.style.isLineColorCustom() || this.style.isLinePatternCustom() || this.style.isLineWidthCustom()) {
                if (this.outlineAttrs == null) {
                    this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                    this.elem.appendChild(this.outlineAttrs);
                }
                if (this.style.isLineColorCustom()) {
                    Color c = li.getLineColor();
                    this.outlineAttrs.setAttribute("color", Integer.toString(c.getRGB()));
                } else if (this.outlineAttrs.hasAttribute("color")) {
                    this.outlineAttrs.removeAttribute("color");
                }
                if (this.style.isLinePatternCustom()) {
                    this.outlineAttrs.setAttribute("pattern", Integer.toString(li.getLinePattern()));
                } else if (this.outlineAttrs.hasAttribute("pattern")) {
                    this.outlineAttrs.removeAttribute("pattern");
                }
                if (this.style.isLineWidthCustom()) {
                    this.outlineAttrs.setAttribute("width", Integer.toString(li.getLineWidth()));
                } else if (this.outlineAttrs.hasAttribute("width")) {
                    this.outlineAttrs.removeAttribute("width");
                }
            } else if (this.outlineAttrs != null) {
                this.elem.removeChild(this.outlineAttrs);
                this.outlineAttrs = null;
            }
        }
        this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "multiple", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public final void setStyle(AAreaStyle aStyle) {
        this.setFillOn(aStyle.isFillOn());
        if (aStyle.isFillColorCustom()) {
            this.setFillColor(aStyle.getFillColor(), aStyle.getFillTrans());
        }
        this.setLineOn(aStyle.isLineOn());
        int transparency = aStyle.getFillTrans();
        if (transparency != 0) {
            this.setFillTrans(transparency);
        }
        if (aStyle.isLineColorCustom()) {
            this.setLineColor(aStyle.getLineColor());
        }
        if (aStyle.isLinePatternCustom()) {
            this.setLinePattern(aStyle.getLinePattern());
        }
        if (aStyle.isLineWidthCustom()) {
            this.setLineWidth(aStyle.getLineWidth());
        }
    }

    public final void setStyle(ATextStyle aStyle) {
        this.setFont(aStyle.getFont());
        this.setFontColor(aStyle.getFontColor());
    }

    @Override
    public final void setFillTrans(int transparency) {
        int lsize;
        Integer oldValue = new Integer(this.style.getFillTrans());
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("Transparency");
            e.setAttribute("transparency", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.lbm = null;
        this.style.setFillTrans(transparency);
        if (this.elem != null) {
            this.elem.setAttribute("transparency", Integer.toString(transparency));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "transperancy", oldValue, new Integer(this.style.getFillTrans()));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final int getFillTrans() {
        return this.style.getFillTrans();
    }

    @Override
    public final void setLinePattern(int pattern) {
        int oldValue = this.style.getLinePattern();
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("LineAttrs");
            e.setAttribute("pattern", Integer.toString(oldValue));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setLinePattern(pattern);
        if (this.elem != null) {
            if (this.outlineAttrs == null) {
                this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                this.elem.appendChild(this.outlineAttrs);
            }
            this.outlineAttrs.setAttribute("pattern", Integer.toString(pattern));
        }
        this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "linePattern", new Integer(oldValue), new Integer(pattern));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public void setLineWidth(int thickness) {
        int oldValue = this.style.getLineWidth();
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("LineAttrs");
            e.setAttribute("width", Integer.toString(oldValue));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setLineWidth(thickness);
        if (this.elem != null) {
            if (this.outlineAttrs == null) {
                this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                this.elem.appendChild(this.outlineAttrs);
            }
            this.outlineAttrs.setAttribute("width", Integer.toString(this.style.getLineWidth()));
        }
        this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "lineWidth", new Integer(oldValue), new Integer(thickness));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public final boolean isCaretOn() {
        return this.caretOn;
    }

    public final void setCaretOn(Component comp, boolean con) {
        if (this.caretOn == con) {
            return;
        }
        if (con) {
            this.c = comp;
            this.c.addKeyListener(this);
            this.c.requestFocus();
            this.c.addFocusListener(this);
            this.savedText = this.text;
        } else {
            this._saveTextIfNeeded();
            if (this.c != null) {
                this.c.removeKeyListener(this);
                this.c.removeFocusListener(this);
                this.c = null;
            }
        }
        Boolean oldValue = this.caretOn ? Boolean.TRUE : Boolean.FALSE;
        this.caretOn = con;
        this.selectAnchor = -1;
        if (this.text == null || this.text.length() < 6) {
            this.setInternalVariables();
        }
        this.formattingEnabled = !this.caretOn || this.text == null || this.text.length() == 0;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "caretOn", oldValue, new Boolean(this.caretOn));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String text) {
        int lsize;
        if ((text == null || text.equals("")) && (this.savedText == null || this.savedText.equals(""))) {
            return;
        }
        if (this.listener != null && (text == null && this.savedText != null || text != null && !text.equals(this.savedText))) {
            Element e = this.elem.getOwnerDocument().createElement("Text");
            e.setAttribute("text", this.savedText == null ? "" : this.savedText);
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.savedText = text;
        this.text = text;
        this.lbm = null;
        this.setInternalVariables();
        if (this.elem != null) {
            this.elem.setAttribute("text", text);
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "text", this.savedText, text);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public final void setTextPosition(int pos) {
        int lsize;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("TextPosition");
            e.setAttribute("textPosition", Integer.toString(this.textPosition));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        int oldValue = this.textPosition;
        this.textPosition = pos;
        this.lbm = null;
        this.setInternalVariables();
        if (this.elem != null) {
            String value = "center";
            if (pos == 3) {
                value = "bottom";
            } else if (pos == 1) {
                value = "top";
            } else if (pos == 10) {
                value = "start";
            } else if (pos == 11) {
                value = "end";
            }
            this.elem.setAttribute("textPosition", value);
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "textPosition", new Integer(oldValue), new Integer(pos));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public final int getTextPosition() {
        return this.textPosition;
    }

    public final void setTextAlignment(int align) {
        int lsize;
        int oldValue = this.textAlign;
        if (this.listener != null && this.savedText != null) {
            Element e = this.elem.getOwnerDocument().createElement("TextAlignment");
            e.setAttribute("textAlignment", Integer.toString(this.textAlign));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.textAlign = align;
        if (this.elem != null) {
            this.elem.setAttribute("textAlignment", Integer.toString(this.textAlign));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "textAlignment", new Integer(oldValue), new Integer(align));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public final int getTextAlignment() {
        return this.textAlign;
    }

    public final Font scaledFont(Font f) {
        int fs = f.getSize();
        fs = fs <= 12 ? (int)Math.ceil((double)fs * 1.3) : (int)Math.ceil((double)fs * 100.0 / 72.0);
        return new Font(f.getFamily(), f.getStyle(), fs);
    }

    protected final void checkTextLayout() {
        FontRenderContext frc = this.frc;
        if (frc == null) {
            frc = this.graph.getFontRenderContext();
        }
        if (this.lbm == null) {
            this.as = this.text == null ? new AttributedString(TEMP_TEXT) : (this.text.length() == 0 ? new AttributedString(TEMP_TEXT) : new AttributedString(this.text));
            Color cc = this.textStyle.getFontColor();
            this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), frc);
        }
    }

    void insertChar(char c) {
        int lsize;
        if (c == '\r' || c == '\n') {
            return;
        }
        if (this.text == null || this.selectAnchor != -1 && this.selectAnchor != this.caretPosition) {
            this.text = new String("" + c);
            this.caretPosition = 0;
            this.selectAnchor = -1;
        } else {
            this.text = this.text.substring(0, this.caretPosition) + c + this.text.substring(this.caretPosition);
        }
        ++this.caretPosition;
        this.lbm = null;
        int index = this.text.indexOf("\\u");
        if (index != -1 && index + 6 <= this.text.length()) {
            try {
                String temp;
                String code = this.text.substring(index + 2, index + 6);
                char ch = (char)Integer.parseInt(code, 16);
                this.text = temp = new String((index > 0 ? this.text.substring(0, index) : "") + ch + (index + 6 < this.text.length() ? this.text.substring(index + 6) : ""));
                this.caretPosition -= 5;
            }
            catch (NumberFormatException code) {
                // empty catch block
            }
        }
        this.setInternalVariables();
        if (this.elem != null) {
            if (this.text == null) {
                this.elem.removeAttribute("text");
            } else {
                this.elem.setAttribute("text", this.text);
            }
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "insertChar", null, Character.toString(c));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    void deleteChar(boolean forward) {
        int lsize;
        Color cc = this.textStyle.getFontColor();
        if (this.selectAnchor != -1 && this.selectAnchor != this.caretPosition) {
            this.text = "";
            this.as = new AttributedString(TEMP_TEXT);
            this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            this.caretPosition = 0;
            this.selectAnchor = -1;
        } else if (this.text != null) {
            if (forward && this.caretPosition < this.text.length()) {
                if (this.text.length() == 1) {
                    this.text = "";
                    this.as = new AttributedString(TEMP_TEXT);
                    this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
                } else {
                    this.text = this.caretPosition == 0 ? this.text.substring(1) : this.text.substring(0, this.caretPosition) + this.text.substring(this.caretPosition + 1);
                    this.as = new AttributedString(this.text);
                    this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
                }
            } else if (!forward && this.caretPosition > 0) {
                if (this.text.length() == 1) {
                    this.text = "";
                    this.caretPosition = 0;
                    this.as = new AttributedString(TEMP_TEXT);
                    this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
                } else {
                    this.text = this.caretPosition == this.text.length() ? this.text.substring(0, this.caretPosition - 1) : this.text.substring(0, this.caretPosition - 1) + this.text.substring(this.caretPosition);
                    this.as = new AttributedString(this.text);
                    this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    --this.caretPosition;
                    this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
                }
            }
        }
        if (this.elem != null) {
            this.elem.setAttribute("text", this.text);
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "deleteChar", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    void setCaretPosition(int x, int y) {
        float ty = (float)((double)y - (this.outside.getY() - this.bounds.getY() + 2.0));
        this._setCaret(x, ty);
    }

    void setSelectPosition(int x, int y) {
        float ty = (float)((double)y - (this.outside.getY() - this.bounds.getY() + 2.0));
        this._setCaret(x, ty);
        this.selectAnchor = this.caretPosition;
    }

    protected void _setCaret(float x, float ty) {
        if (this.text == null) {
            this.caretPosition = 0;
            this.formattingEnabled = true;
            return;
        }
        if (this.lbm == null) {
            this.as = this.text == null || this.text.length() == 0 ? new AttributedString(TEMP_TEXT) : new AttributedString(this.text);
            this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
            Color cc = this.textStyle.getFontColor();
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            this.setInternalVariables();
        }
        this.lbm.setPosition(0);
        TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
        int offset = 0;
        Rectangle2D tbounds = tl.getBounds();
        while (tbounds.getHeight() <= (double)ty && this.lbm.getPosition() < this.text.length()) {
            ty = (float)((double)ty - tbounds.getHeight());
            offset = this.lbm.getPosition();
            tl = this.lbm.nextLayout(this.wrappingWidth);
        }
        float tx = x - this._getTextAnchor(tl);
        TextHitInfo thi = tl.hitTestChar(tx, ty);
        if (thi != null) {
            this.caretPosition = offset + thi.getInsertionIndex();
        }
        if (this.caretPosition > this.text.length()) {
            this.caretPosition = this.text.length();
        }
        this.formattingEnabled = this.text == null || this.text.length() == 0 || this.selectAnchor != -1 && this.selectAnchor != this.caretPosition;
    }

    public void mouseClicked(MouseEvent arg0) {
        if (this.text == null) {
            return;
        }
        int x = arg0.getX();
        int y = arg0.getY();
        int count = arg0.getClickCount();
        if (count == 1) {
            this.selectAnchor = -1;
            this.setCaretPosition(x, y);
            this.formattingEnabled = this.text.length() == 0;
        } else {
            this.selectAnchor = 0;
            this.caretPosition = this.text.length();
            this.formattingEnabled = true;
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "mouseClicked", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void keyTyped(KeyEvent e) {
        this.processEvent(e);
    }

    @Override
    public final void keyPressed(KeyEvent e) {
    }

    @Override
    public final void keyReleased(KeyEvent e) {
        this.processEvent(e);
    }

    protected final void processEvent(KeyEvent e) {
        int kid = e.getID();
        if (kid == 400) {
            char ch = e.getKeyChar();
            if (Character.isIdentifierIgnorable(ch)) {
                return;
            }
            this.insertChar(ch);
        } else {
            int keyCode = e.getKeyCode();
            int lsize = this.listeners.size();
            boolean extsel = this.selectAnchor != -1 && this.selectAnchor != this.caretPosition;
            switch (keyCode) {
                case 8: {
                    this.deleteChar(false);
                    break;
                }
                case 37: {
                    if (!extsel && this.caretPosition <= 0) break;
                    this.selectAnchor = -1;
                    this.caretPosition = extsel ? 0 : --this.caretPosition;
                    if (lsize <= 0) break;
                    PropertyChangeEvent pce = new PropertyChangeEvent(this, "setPosition", null, null);
                    for (int i = 0; i < lsize; ++i) {
                        ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
                    }
                    break;
                }
                case 39: {
                    if (!extsel && this.caretPosition >= this.text.length()) break;
                    this.selectAnchor = -1;
                    this.caretPosition = extsel ? this.text.length() : ++this.caretPosition;
                    if (lsize <= 0) break;
                    PropertyChangeEvent pce = new PropertyChangeEvent(this, "setPosition", null, null);
                    for (int i = 0; i < lsize; ++i) {
                        ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
                    }
                    break;
                }
                case 10: {
                    this.setCaretOn(null, false);
                    break;
                }
                case 36: {
                    this.caretPosition = 0;
                    this.selectAnchor = -1;
                    if (lsize <= 0) break;
                    PropertyChangeEvent pce = new PropertyChangeEvent(this, "setPosition", null, null);
                    for (int i = 0; i < lsize; ++i) {
                        ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
                    }
                    break;
                }
                case 35: {
                    this.selectAnchor = -1;
                    this.caretPosition = this.getText().length();
                    if (lsize <= 0) break;
                    PropertyChangeEvent pce = new PropertyChangeEvent(this, "setPosition", null, null);
                    for (int i = 0; i < lsize; ++i) {
                        ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
                    }
                    break;
                }
            }
        }
    }

    final boolean hasText() {
        return this.text != null;
    }

    final void insertText(Component c) {
        if (this.caretOn) {
            KeyListener[] ll = c.getKeyListeners();
            for (int i = 0; i < ll.length; ++i) {
                if (ll[i] != this) continue;
                return;
            }
        }
        this.caretOn = true;
        this.c = c;
        c.addKeyListener(this);
        c.setFocusable(true);
        c.requestFocus();
        c.addFocusListener(this);
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "insertText", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    final void deleteText() {
        int lsize;
        if (this.text == null || this.text.equals("")) {
            return;
        }
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("Text");
            e.setAttribute("text", this.text);
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.lbm = null;
        this.caretPosition = 0;
        this.curPosition = null;
        this.caretOn = false;
        if (this.c != null) {
            this.c.removeKeyListener(this);
            this.c = null;
        }
        this.bounds = null;
        this.outside.setRect(0.0, 0.0, 0.0, 0.0);
        this.text = null;
        this.savedText = null;
        if (this.elem != null) {
            this.elem.removeAttribute("text");
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "deleteText", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public Element getState() {
        Element curState = (Element)this.elem.cloneNode(true);
        return curState;
    }

    @Override
    public Object undo(Object savedElem) {
        if (savedElem instanceof String) {
            String action = (String)savedElem;
            if (action.startsWith("addgroup")) {
                return this._addToGroup(action.substring(9));
            }
            if (action.startsWith("removegroup")) {
                return this._removeFromGroup(action.substring(12));
            }
            return null;
        }
        if (!(savedElem instanceof Element) || Util.isSame(this.elem, (Element)savedElem)) {
            return null;
        }
        String oldText = this.text;
        Element oldState = this._undo((Element)savedElem);
        String newText = this.text;
        this.caretPosition = 0;
        if (oldState == null) {
            return null;
        }
        this.lbm = null;
        this.setInternalVariables();
        this.fireUndoPropertyEvent(oldText, newText);
        return oldState;
    }

    protected void fireUndoPropertyEvent(String oldText, String newText) {
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "undo", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    protected Element _undo(Element savedElem) {
        Element ta;
        Element la;
        Object y;
        Object x;
        String stry;
        String strx;
        String newValue;
        String elemtag = savedElem.getTagName();
        if ("Move".equals(elemtag)) {
            int asx = Integer.parseInt(savedElem.getAttribute("asx"));
            int asy = Integer.parseInt(savedElem.getAttribute("asy"));
            int ssx = Integer.parseInt(savedElem.getAttribute("ssx"));
            int ssy = Integer.parseInt(savedElem.getAttribute("ssy"));
            double adx = Double.parseDouble(savedElem.getAttribute("adx"));
            double ady = Double.parseDouble(savedElem.getAttribute("ady"));
            double sdx = Double.parseDouble(savedElem.getAttribute("sdx"));
            double sdy = Double.parseDouble(savedElem.getAttribute("sdy"));
            savedElem.setAttribute("asx", Integer.toString((int)this.anchor.screen.getX()));
            savedElem.setAttribute("asy", Integer.toString((int)this.anchor.screen.getY()));
            savedElem.setAttribute("ssx", Integer.toString((int)this.secondary.screen.getX()));
            savedElem.setAttribute("ssy", Integer.toString((int)this.secondary.screen.getY()));
            savedElem.setAttribute("adx", this.anchor.data[0].toString());
            savedElem.setAttribute("ady", this.anchor.data[1].toString());
            savedElem.setAttribute("sdx", this.secondary.data[0].toString());
            savedElem.setAttribute("sdy", this.secondary.data[1].toString());
            this.anchor.screen.setLocation(asx, asy);
            this.anchor.data[0] = new Double(adx);
            this.anchor.data[1] = new Double(ady);
            this.secondary.screen.setLocation(ssx, ssy);
            this.secondary.data[0] = new Double(sdx);
            this.secondary.data[1] = new Double(sdy);
            this.setInternalVariables();
            this.updateXMLNode();
            return savedElem;
        }
        if ("TextAttrs".equals(elemtag)) {
            String oldStyle;
            String style;
            block170: {
                String newValue2;
                String oldValue;
                this.lbm = null;
                if (this.textAttrs == null) {
                    this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                    this.elem.appendChild(this.textAttrs);
                }
                if (savedElem.hasAttribute("text")) {
                    oldValue = this.text;
                    newValue2 = savedElem.getAttribute("text");
                    this.text = newValue2.length() == 0 ? null : newValue2;
                    savedElem.setAttribute("text", oldValue);
                    this.elem.setAttribute("text", newValue2);
                }
                if (savedElem.hasAttribute("color")) {
                    oldValue = this.textStyle.isCustomColor() ? Integer.toString(this.textStyle.getFontColor().getRGB()) : TEMP_TEXT;
                    newValue2 = savedElem.getAttribute("color");
                    savedElem.setAttribute("color", oldValue);
                    try {
                        this.textStyle.setFontColor(new Color(Integer.parseInt(newValue2)));
                        this.textAttrs.setAttribute("color", newValue2);
                    }
                    catch (NumberFormatException nfe) {
                        this.textStyle.setFontColor(null);
                        if (!this.textAttrs.hasAttribute("color")) break block170;
                        this.textAttrs.removeAttribute("color");
                    }
                }
            }
            if (savedElem.hasAttribute("size")) {
                int sz = Integer.parseInt(savedElem.getAttribute("size"));
                Font font = this.textStyle.getFont();
                int dfsz = this.getDefaultFontSize();
                int oldSize = font.getSize();
                savedElem.setAttribute("size", Integer.toString(oldSize));
                if (this.elem != null) {
                    if (sz == this.customDefaultFontSize || sz != dfsz) {
                        if (this.textAttrs == null) {
                            this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                            this.elem.appendChild(this.textAttrs);
                        }
                        this.textAttrs.setAttribute("size", Integer.toString(sz));
                    } else if (this.textAttrs != null) {
                        this.textAttrs.removeAttribute("size");
                    }
                }
                this.textStyle.setFontSize(sz);
            }
            if (savedElem.hasAttribute("style")) {
                Font font = this.textStyle.getFont();
                int dfst = this.getDefaultFontStyle();
                String dstyle = (dfst & 2) != 0 ? "italic" : "normal";
                String cdstyle = (this.customDefaultStyleValue & 2) != 0 ? "italic" : "normal";
                style = savedElem.getAttribute("style");
                oldStyle = (font.getStyle() & 2) != 0 ? "italic" : "normal";
                savedElem.setAttribute("style", oldStyle);
                if (this.elem != null) {
                    if (style.equalsIgnoreCase(cdstyle) || !style.equalsIgnoreCase(dstyle)) {
                        if (this.textAttrs == null) {
                            this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                            this.elem.appendChild(this.textAttrs);
                        }
                        this.textAttrs.setAttribute("style", style);
                    } else if (this.textAttrs != null) {
                        this.textAttrs.removeAttribute("style");
                    }
                }
                this.textStyle.setItalic(style.equalsIgnoreCase("italic"));
            }
            if (savedElem.hasAttribute("weight")) {
                Font font = this.textStyle.getFont();
                int dfst = this.getDefaultFontStyle();
                String dstyle = (dfst & 1) != 0 ? "bold" : "normal";
                String cdstyle = (this.customDefaultStyleValue & 1) != 0 ? "bold" : "normal";
                style = savedElem.getAttribute("weight");
                oldStyle = (font.getStyle() & 1) != 0 ? "bold" : "normal";
                savedElem.setAttribute("weight", oldStyle);
                if (this.elem != null) {
                    if (style.equalsIgnoreCase(cdstyle) || !style.equalsIgnoreCase(dstyle)) {
                        if (this.textAttrs == null) {
                            this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                            this.elem.appendChild(this.textAttrs);
                        }
                        this.textAttrs.setAttribute("weight", style);
                    } else if (this.textAttrs != null) {
                        this.textAttrs.removeAttribute("weight");
                    }
                }
                this.textStyle.setBold(style.equalsIgnoreCase("bold"));
            }
            if (savedElem.hasAttribute("family")) {
                String f = savedElem.getAttribute("family");
                Font font = this.textStyle.getFont();
                String df = this.getDefaultFontFamily();
                savedElem.setAttribute("family", font.getFamily());
                if (this.elem != null) {
                    if (f.equalsIgnoreCase(this.customDefaultFamily) || !f.equalsIgnoreCase(df)) {
                        if (this.textAttrs == null) {
                            this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                            this.elem.appendChild(this.textAttrs);
                        }
                        this.textAttrs.setAttribute("family", f);
                    } else if (this.textAttrs != null) {
                        this.textAttrs.removeAttribute("family");
                    }
                }
                this.textStyle.setFontFamily(f);
            }
            if (savedElem.hasAttribute("font")) {
                Font f;
                Font font = f = this.textStyle.isFontCustom() ? this.textStyle.getFont() : this.textStyle.getDefaultFont();
                if (f == null) {
                    return null;
                }
                savedElem.setAttribute("size", Integer.toString(f.getSize()));
                savedElem.setAttribute("family", f.getFamily());
                savedElem.setAttribute("style", f.isItalic() ? "italic" : "normal");
                savedElem.setAttribute("weight", f.isBold() ? "bold" : "normal");
                this.textStyle.setFont(null);
                if (this.textAttrs != null) {
                    if (this.textAttrs.hasAttribute("size")) {
                        this.textAttrs.removeAttribute("size");
                    }
                    if (this.textAttrs.hasAttribute("family")) {
                        this.textAttrs.removeAttribute("family");
                    }
                    if (this.textAttrs.hasAttribute("style")) {
                        this.textAttrs.removeAttribute("style");
                    }
                    if (this.textAttrs.hasAttribute("weight")) {
                        this.textAttrs.removeAttribute("weight");
                    }
                }
            }
            return savedElem;
        }
        if ("Fill".equals(elemtag)) {
            Element e = this.elem.getOwnerDocument().createElement("Fill");
            if (savedElem.hasAttribute("fill")) {
                String oldValue = this.elem.getAttribute("fill");
                String newValue3 = savedElem.getAttribute("fill");
                e.setAttribute("fill", oldValue);
                if (newValue3.equals("")) {
                    newValue3 = this.style.defaultStyle.isFillOn() ? "true" : "false";
                }
                this.elem.setAttribute("fill", newValue3);
                this.style.setFillOn(newValue3.toLowerCase().equals("true"));
            }
            return e;
        }
        if ("Line".equals(elemtag)) {
            Element e = this.elem.getOwnerDocument().createElement("Line");
            if (savedElem.hasAttribute("line")) {
                String oldValue = this.elem.getAttribute("line");
                String newValue4 = savedElem.getAttribute("line");
                e.setAttribute("line", oldValue);
                if (newValue4.equals("")) {
                    newValue4 = this.style.defaultStyle.isLineOn() ? "true" : "false";
                }
                this.style.setLineOn(newValue4.toLowerCase().equals("true"));
                this.elem.setAttribute("line", newValue4);
            }
            if (this.stroke == null) {
                this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
            }
            return e;
        }
        if ("LineAttrs".equals(elemtag)) {
            String oldValue;
            Element e;
            block171: {
                e = this.elem.getOwnerDocument().createElement("LineAttrs");
                if (this.outlineAttrs == null) {
                    this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                    this.elem.appendChild(this.outlineAttrs);
                }
                if (savedElem.hasAttribute("color")) {
                    oldValue = this.style.isLineColorCustom() ? Integer.toString(this.style.getLineColor().getRGB()) : TEMP_TEXT;
                    String newValue5 = savedElem.getAttribute("color");
                    e.setAttribute("color", oldValue);
                    try {
                        this.style.setLineColor(new Color(Integer.parseInt(newValue5)));
                        this.outlineAttrs.setAttribute("color", newValue5);
                    }
                    catch (NumberFormatException nfe) {
                        this.style.setLineColor(null);
                        if (!this.outlineAttrs.hasAttribute("color")) break block171;
                        this.outlineAttrs.removeAttribute("color");
                    }
                }
            }
            if (savedElem.hasAttribute("width")) {
                oldValue = this.style.isLineWidthCustom() ? Integer.toString(this.style.getLineWidth()) : "-1";
                e.setAttribute("width", oldValue);
                int value = Integer.parseInt(savedElem.getAttribute("width"));
                if (value != -1) {
                    this.outlineAttrs.setAttribute("width", savedElem.getAttribute("width"));
                } else if (this.outlineAttrs.hasAttribute("width")) {
                    this.outlineAttrs.removeAttribute("width");
                }
                this.style.setLineWidth(value);
            }
            if (savedElem.hasAttribute("pattern")) {
                oldValue = this.style.isLinePatternCustom() ? Integer.toString(this.style.getLinePattern()) : "-1";
                e.setAttribute("pattern", oldValue);
                int value = Integer.parseInt(savedElem.getAttribute("pattern"));
                if (value != -1) {
                    this.outlineAttrs.setAttribute("pattern", savedElem.getAttribute("pattern"));
                } else if (this.outlineAttrs.hasAttribute("width")) {
                    this.outlineAttrs.removeAttribute("width");
                }
                this.style.setLinePattern(value);
            }
            this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
            return e;
        }
        if ("FillAttrs".equals(elemtag)) {
            String newValue6;
            String oldValue;
            Element e;
            block172: {
                e = this.elem.getOwnerDocument().createElement("FillAttrs");
                if (this.fillAttrs == null) {
                    this.fillAttrs = this.elem.getOwnerDocument().createElement("FillAttrs");
                    this.elem.appendChild(this.fillAttrs);
                }
                if (savedElem.hasAttribute("color")) {
                    oldValue = this.style.isFillColorCustom() ? Integer.toString(this.style.getFillColor().getRGB()) : TEMP_TEXT;
                    newValue6 = savedElem.getAttribute("color");
                    e.setAttribute("color", oldValue);
                    try {
                        this.style.setFillColor(new Color(Integer.parseInt(newValue6)));
                        this.fillAttrs.setAttribute("color", newValue6);
                    }
                    catch (NumberFormatException nfe) {
                        this.style.setFillColor(null);
                        if (!this.fillAttrs.hasAttribute("color")) break block172;
                        this.fillAttrs.removeAttribute("color");
                    }
                }
            }
            if (savedElem.hasAttribute("transparency")) {
                oldValue = Integer.toString(this.style.getFillTrans());
                newValue6 = savedElem.getAttribute("transparency");
                e.setAttribute("transparency", oldValue);
                this.elem.setAttribute("transparency", newValue6);
                this.style.setFillTrans(Integer.parseInt(newValue6));
            }
            return e;
        }
        if ("Transparency".equals(elemtag)) {
            this.lbm = null;
            if (savedElem.hasAttribute("transparency")) {
                String oldValue = Integer.toString(this.style.getFillTrans());
                String newValue7 = savedElem.getAttribute("transparency");
                this.style.setFillTrans(Integer.parseInt(newValue7));
                savedElem.setAttribute("transparency", oldValue);
                this.elem.setAttribute("transparency", newValue7);
            }
            return savedElem;
        }
        if ("Rotation".equals(elemtag)) {
            if (savedElem.hasAttribute("rotation")) {
                String oldValue = Double.toString(this.rotation);
                String newValue8 = savedElem.getAttribute("rotation");
                this.rotation = Double.parseDouble(newValue8);
                savedElem.setAttribute("rotation", oldValue);
                this.elem.setAttribute("Rotation", newValue8);
                this.setRotationVariables();
            }
            return savedElem;
        }
        if ("TextPosition".equals(elemtag)) {
            if (savedElem.hasAttribute("textPosition")) {
                String oldValue = Integer.toString(this.textPosition);
                String newValue9 = savedElem.getAttribute("textPosition");
                this.textPosition = Integer.parseInt(newValue9);
                savedElem.setAttribute("textPosition", oldValue);
                if (this.textPosition == 3) {
                    this.elem.setAttribute("textPosition", "Bottom");
                } else if (this.textPosition == 1) {
                    this.elem.setAttribute("textPosition", "Top");
                } else if (this.textPosition == 10) {
                    this.elem.setAttribute("textPosition", "Start");
                } else if (this.textPosition == 11) {
                    this.elem.setAttribute("textPosition", "End");
                } else {
                    this.elem.setAttribute("textPosition", "Center");
                }
            }
            return savedElem;
        }
        if ("TextAlignment".equals(elemtag)) {
            if (savedElem.hasAttribute("textAlignment")) {
                String oldValue = Integer.toString(this.textAlign);
                String newValue10 = savedElem.getAttribute("textAlignment");
                this.textAlign = Integer.parseInt(newValue10);
                savedElem.setAttribute("textAlignment", oldValue);
                this.elem.setAttribute("textAlignment", newValue10);
            }
            return savedElem;
        }
        if ("Text".equals(elemtag)) {
            if (savedElem.hasAttribute("text")) {
                String oldValue = this.text;
                String newValue11 = savedElem.getAttribute("text");
                this.text = newValue11.length() == 0 ? null : newValue11;
                savedElem.setAttribute("text", oldValue);
                this.elem.setAttribute("text", newValue11);
            }
            return savedElem;
        }
        if ("AttachedToData".equals(elemtag)) {
            String newValue12;
            String oldValue;
            if (savedElem.hasAttribute("anchor") && !(oldValue = this.anchorAttachedToData ? "true" : "false").equalsIgnoreCase(newValue12 = savedElem.getAttribute("anchor"))) {
                savedElem.setAttribute("anchor", oldValue);
                this.anchorAttachedToData = newValue12.equalsIgnoreCase("true");
                this.anchor.setSpaceType(this.anchorAttachedToData ? 1 : 0);
                this.anchor.finish(this.graph, this.parentID);
                this.elem.setAttribute("AnchorAttachedToData", newValue12);
            }
            if (savedElem.hasAttribute("secondary") && !(oldValue = this.secondaryAttachedToData ? "true" : "false").equalsIgnoreCase(newValue12 = savedElem.getAttribute("secondary"))) {
                savedElem.setAttribute("secondary", oldValue);
                this.secondaryAttachedToData = newValue12.equalsIgnoreCase("true");
                this.secondary.setSpaceType(this.anchorAttachedToData ? 1 : 0);
                if (this instanceof LineElement) {
                    this.secondary.finish(this.graph, ((LineElement)this).secondaryParent);
                } else {
                    this.secondary.finish(this.graph, this.parentID);
                }
                this.elem.setAttribute("SecondaryAttachedToData", newValue12);
            }
            this.clip = this.clipOutside && this.isAnchorAttachedToData() && this.isSecondaryAttachedToData() ? ((Annotatable)this.graph).getDataBoundingBox(this.parentID) : null;
            return savedElem;
        }
        if ("ClipOutside".equals(elemtag)) {
            if (savedElem.hasAttribute("clip")) {
                String oldValue = this.clipOutside ? "true" : "false";
                String newValue13 = savedElem.getAttribute("clip");
                savedElem.setAttribute("clip", oldValue);
                this.clipOutside = newValue13.equalsIgnoreCase("true");
                if (this.clipOutside) {
                    this.elem.removeAttribute("ClipOutside");
                    this.clip = this.anchor.type == 1 ? this.anGraph.getDataBoundingBox(this.parentID) : null;
                } else {
                    this.elem.setAttribute("ClipOutside", newValue13);
                    this.clip = null;
                }
            }
            return savedElem;
        }
        if ("Finish".equals(elemtag)) {
            Element e = this.elem.getOwnerDocument().createElement("Finish");
            e.setAttribute("anchorx", Integer.toString(this.savedAnchor.x));
            e.setAttribute("anchory", Integer.toString(this.savedAnchor.y));
            e.setAttribute("secondaryx", Integer.toString(this.savedSecondary.x));
            e.setAttribute("secondaryy", Integer.toString(this.savedSecondary.y));
            e.setAttribute("rotation", Double.toString(this.rotation));
            Point p = new Point(Integer.parseInt(savedElem.getAttribute("anchorx")), Integer.parseInt(savedElem.getAttribute("anchory")));
            this.anchor.setPoint(p);
            p = new Point(Integer.parseInt(savedElem.getAttribute("secondaryx")), Integer.parseInt(savedElem.getAttribute("secondaryy")));
            this.secondary.setPoint(p);
            this.rotation = Double.parseDouble(savedElem.getAttribute("rotation"));
            this.finish();
            return e;
        }
        Element oldElem = this.getState();
        this.lbm = null;
        if (savedElem.hasAttribute("Rotation")) {
            String str = savedElem.getAttribute("Rotation");
            double rotation2 = Double.parseDouble(str);
            if (rotation2 != this.rotation) {
                this.rotation = rotation2;
                this.elem.setAttribute("Rotation", str);
            }
        } else if (this.rotation != 0.0) {
            this.elem.removeAttribute("Rotation");
            this.rotation = 0.0;
        }
        String oldValue = this.anchorAttachedToData ? "true" : "false";
        String string = newValue = savedElem.hasAttribute("AnchorAttachedToData") ? savedElem.getAttribute("AnchorAttachedToData") : "true";
        if (!oldValue.equalsIgnoreCase(newValue)) {
            savedElem.setAttribute("AnchorAttachedToData", oldValue);
            this.anchorAttachedToData = newValue.equalsIgnoreCase("true");
            if (this.anchorAttachedToData) {
                this.elem.removeAttribute("AnchorAttachedToData");
            } else {
                this.elem.setAttribute("AnchorAttachedToData", newValue);
            }
        }
        if (savedElem.hasAttribute("SecondaryAttachedToData") || this.elem.hasAttribute("SecondaryAttachedToData")) {
            oldValue = this.secondaryAttachedToData ? "true" : "false";
            String string2 = newValue = savedElem.hasAttribute("SecondaryAttachedToData") ? savedElem.getAttribute("SecondaryAttachedToData") : "true";
            if (!oldValue.equalsIgnoreCase(newValue)) {
                savedElem.setAttribute("SecondaryAttachedToData", oldValue);
                this.secondaryAttachedToData = newValue.equalsIgnoreCase("true");
                if (this.secondaryAttachedToData) {
                    this.elem.removeAttribute("SecondaryAttachedToData");
                } else {
                    this.elem.setAttribute("SecondaryAttachedToData", newValue);
                }
            }
        }
        if (this.parentID == null || !this.anchorAttachedToData) {
            strx = savedElem.getAttribute("SAnchorX");
            stry = savedElem.getAttribute("SAnchorY");
            x = Double.valueOf(strx);
            y = Double.valueOf(stry);
            this.elem.setAttribute("SAnchorX", strx);
            this.elem.setAttribute("SAnchorY", stry);
            this.anchor.screen.setLocation((int)Math.round((Double)x), (int)Math.round((Double)y));
            this.anchor.setSpaceType(0);
            this.anchor.finish(this.graph, this.parentID);
        } else {
            strx = savedElem.getAttribute("AnchorX");
            stry = savedElem.getAttribute("AnchorY");
            this.anchor.setSpaceType(1);
            x = strx;
            y = stry;
            try {
                x = Double.valueOf(strx);
            }
            catch (NumberFormatException nfe) {
                x = strx;
            }
            try {
                y = Double.valueOf(stry);
            }
            catch (NumberFormatException nfe) {
                y = stry;
            }
            this.elem.setAttribute("AnchorX", strx);
            this.elem.setAttribute("AnchorY", stry);
            this.anchor.setData(this.graph, this.parentID, new Object[]{x, y});
        }
        if (this instanceof LineElement) {
            if (this.elem.getAttribute("SecondaryParent").length() == 0 || !this.secondaryAttachedToData) {
                strx = savedElem.getAttribute("SSecondaryX");
                stry = savedElem.getAttribute("SSecondaryY");
                this.secondary.setSpaceType(0);
                x = Double.valueOf(strx);
                y = Double.valueOf(stry);
                this.elem.setAttribute("SSecondaryX", strx);
                this.elem.setAttribute("SSecondaryY", stry);
                this.secondary.screen.setLocation((int)Math.round((Double)x), (int)Math.round((Double)y));
            } else {
                strx = savedElem.getAttribute("SecondaryX");
                stry = savedElem.getAttribute("SecondaryY");
                this.secondary.setSpaceType(1);
                x = strx;
                y = stry;
                try {
                    x = Double.valueOf(strx);
                }
                catch (NumberFormatException nfe) {
                    x = strx;
                }
                try {
                    y = Double.valueOf(stry);
                }
                catch (NumberFormatException nfe) {
                    y = stry;
                }
                this.elem.setAttribute("SecondaryX", strx);
                this.elem.setAttribute("SecondaryY", stry);
                this.secondary.setData(this.graph, ((LineElement)this).secondaryParent, new Object[]{x, y});
            }
        }
        boolean updateline = false;
        boolean updatefill = false;
        boolean updatetext = false;
        if (this.graph instanceof Annotatable) {
            boolean fill2;
            String display;
            boolean line = true;
            boolean fill = false;
            if (savedElem.hasAttribute("fill")) {
                display = savedElem.getAttribute("fill");
                if (display.toLowerCase().equalsIgnoreCase("true")) {
                    fill = true;
                }
                this.elem.setAttribute("fill", display);
            } else {
                this.elem.removeAttribute("fill");
            }
            if (savedElem.hasAttribute("line")) {
                display = savedElem.getAttribute("line");
                if (display.toLowerCase().equalsIgnoreCase("false")) {
                    line = false;
                }
                this.elem.setAttribute("line", display);
            } else {
                this.elem.removeAttribute("line");
            }
            boolean line2 = this.style.isLineOn();
            if (line != line2) {
                this.style.setLineOn(line);
            }
            if (fill != (fill2 = this.style.isFillOn())) {
                this.style.setFillOn(fill);
            }
        }
        if ((la = this.getOptionAttrs(savedElem, "LineAttrs")) != null) {
            if (this.outlineAttrs == null) {
                this.outlineAttrs = la;
                this.elem.appendChild(la);
                updateline = true;
            } else if (!Util.isSame(la, this.outlineAttrs)) {
                this.elem.replaceChild(la, this.outlineAttrs);
                this.outlineAttrs = la;
                updateline = true;
            }
        } else if (this.outlineAttrs != null) {
            this.elem.removeChild(this.outlineAttrs);
            this.outlineAttrs = null;
            updateline = true;
        }
        Element fa = this.getOptionAttrs(savedElem, "FillAttrs");
        if (fa != null) {
            if (this.fillAttrs == null) {
                this.fillAttrs = fa;
                this.elem.appendChild(fa);
                updatefill = true;
            } else if (!Util.isSame(fa, this.fillAttrs)) {
                this.elem.replaceChild(fa, this.fillAttrs);
                this.fillAttrs = fa;
                updatefill = true;
            }
        } else if (this.fillAttrs != null) {
            this.elem.removeChild(this.fillAttrs);
            this.fillAttrs = null;
            updatefill = true;
        }
        if (updateline || updatefill) {
            this.style.reset();
            if (this.fillAttrs != null) {
                if (this.fillAttrs.hasAttribute("color")) {
                    String c = this.fillAttrs.getAttribute("color");
                    int rgb = Integer.parseInt(c);
                    Color color = new Color(rgb);
                    this.style.setFillColor(color);
                } else {
                    this.style.setFillColor(null);
                }
            }
            if (this.outlineAttrs != null) {
                if (this.outlineAttrs.hasAttribute("pattern")) {
                    this.style.setLinePattern(Integer.parseInt(this.outlineAttrs.getAttribute("pattern")));
                } else {
                    this.style.setLinePattern(-1);
                }
                if (this.outlineAttrs.hasAttribute("width")) {
                    int lineWidth = Integer.parseInt(this.outlineAttrs.getAttribute("width"));
                    this.style.setLineWidth(lineWidth);
                } else {
                    this.style.setLineWidth(-1);
                }
                if (this.outlineAttrs.hasAttribute("color")) {
                    String c = this.outlineAttrs.getAttribute("color");
                    int rgb = Integer.parseInt(c);
                    Color color = new Color(rgb);
                    this.style.setLineColor(color);
                } else {
                    this.style.setLineColor(null);
                }
            }
        }
        if ((ta = this.getOptionAttrs(savedElem, "TextAttrs")) != null) {
            if (this.textAttrs == null) {
                this.textAttrs = ta;
                this.elem.appendChild(ta);
                updatetext = true;
            } else if (!Util.isSame(ta, this.textAttrs)) {
                this.elem.replaceChild(ta, this.textAttrs);
                this.textAttrs = ta;
                updatetext = true;
            }
        } else if (this.textAttrs != null) {
            this.elem.removeChild(this.textAttrs);
            this.textAttrs = null;
            updatetext = true;
        }
        if (updatetext) {
            this.textStyle.reset();
            if (this.textAttrs != null) {
                Font f = this.textStyle.getFont();
                String family = this.textAttrs.hasAttribute("family") ? this.textAttrs.getAttribute("family") : f.getFamily();
                int fsize = this.textAttrs.hasAttribute("size") ? Integer.parseInt(this.textAttrs.getAttribute("size")) : f.getSize();
                boolean bold = this.textAttrs.hasAttribute("weight") ? this.textAttrs.getAttribute("weight").toUpperCase().equals("BOLD") : f.isBold();
                boolean italic = this.textAttrs.hasAttribute("style") ? this.textAttrs.getAttribute("style").toUpperCase().equals("ITALIC") : f.isItalic();
                int fstyle = 0;
                if (bold) {
                    fstyle |= 1;
                }
                if (italic) {
                    fstyle |= 2;
                }
                this.textStyle.setFont(new Font(family, fstyle, fsize));
                if (this.textAttrs.hasAttribute("color")) {
                    String c = this.textAttrs.getAttribute("color");
                    int rgb = Integer.parseInt(c);
                    this.textStyle.setFontColor(new Color(rgb));
                }
            }
        }
        if (savedElem.hasAttribute("transparency")) {
            String ca = savedElem.getAttribute("transparency");
            this.elem.setAttribute("transparency", ca);
            int alpha = Integer.parseInt(ca);
            this.style.setFillTrans(alpha);
        } else if (this.elem.hasAttribute("transparency")) {
            this.elem.removeAttribute("transparency");
            this.style.setFillTrans(0);
        }
        if (savedElem.hasAttribute("text")) {
            this.text = savedElem.getAttribute("text");
            this.elem.setAttribute("text", this.text);
        } else {
            this.elem.removeAttribute("text");
            this.text = null;
        }
        this.savedText = this.text;
        if (savedElem.hasAttribute("textPosition")) {
            newValue = savedElem.getAttribute("textPosition");
            this.elem.setAttribute("textPosition", newValue);
            this.textPosition = newValue.equalsIgnoreCase("start") ? 10 : (newValue.equalsIgnoreCase("end") ? 11 : (newValue.equalsIgnoreCase("top") ? 1 : (newValue.equalsIgnoreCase("bottom") ? 3 : 0)));
        } else {
            this.elem.removeAttribute("textPosition");
            this.textPosition = 0;
        }
        this.caretOn = false;
        if (this.c != null) {
            this.c.removeKeyListener(this);
            this.c = null;
        }
        this.lbm = null;
        oldValue = this.clipOutside ? "true" : "false";
        String string3 = newValue = savedElem.hasAttribute("ClipOutside") ? savedElem.getAttribute("clip") : "true";
        if (!oldValue.equalsIgnoreCase(newValue)) {
            this.clipOutside = newValue.equalsIgnoreCase("true");
            if (this.clipOutside) {
                this.elem.removeAttribute("ClipOutside");
                this.clip = this.anchor.type == 1 ? this.anGraph.getDataBoundingBox(this.parentID) : null;
            } else {
                this.elem.setAttribute("ClipOutside", newValue);
                this.clip = null;
            }
        }
        this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
        return oldElem;
    }

    public Element getOptionAttrs(Element element, String option) {
        String elemTag = "";
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals(option)) continue;
            return (Element)node;
        }
        return null;
    }

    public void setControlDown(boolean state) {
        this.controlOn = state;
    }

    public final void setShiftDown(boolean state) {
        this.shiftOn = state;
        if (state) {
            double dx = Math.abs(this.anchor.screen.getX() - this.secondary.screen.getX());
            double dy = Math.abs(this.anchor.screen.getY() - this.secondary.screen.getY());
            this.aspect = dx == 0.0 && dy == 0.0 ? 1.0 : (dx == 0.0 ? Double.MAX_VALUE : dy / dx);
        }
    }

    void resetPoint(Point p) {
        this.secondary.setPoint(p);
        this.setInternalVariables();
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "resetPoint", this.secondary.screen, p);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        this.savedAnchor = new Point((int)this.anchor.screen.getX(), (int)this.anchor.screen.getY());
        this.savedSecondary = new Point((int)this.secondary.screen.getX(), (int)this.secondary.screen.getY());
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners.indexOf(pcl) == -1) {
            this.listeners.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String cmd = pce.getPropertyName();
        if (pce.getSource() == this.style) {
            if (this.elem != null) {
                if (this.outlineAttrs == null) {
                    this.outlineAttrs = this.elem.getOwnerDocument().createElement("LineAttrs");
                    this.elem.appendChild(this.outlineAttrs);
                }
                if (cmd.equals("lineColor")) {
                    Color c = this.style.getLineColor();
                    this.outlineAttrs.setAttribute("color", Integer.toString(c.getRGB()));
                } else if (cmd.equals("lineWidth")) {
                    this.outlineAttrs.setAttribute("width", Integer.toString(this.style.getLineWidth()));
                } else if (cmd.equals("linePattern")) {
                    this.outlineAttrs.setAttribute("pattern", Integer.toString(this.style.getLinePattern()));
                }
            }
            this.stroke = Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth());
        } else if (pce.getSource() == this.textStyle) {
            if (cmd.equals("font")) {
                this.setInternalVariables();
                if (this.elem != null) {
                    if (this.textAttrs == null) {
                        this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                        this.elem.appendChild(this.textAttrs);
                    }
                    Font f = (Font)pce.getNewValue();
                    this.textAttrs.setAttribute("size", Integer.toString(f.getSize()));
                    this.textAttrs.setAttribute("family", f.getFamily());
                    this.textAttrs.setAttribute("style", f.isItalic() ? "italic" : "normal");
                    this.textAttrs.setAttribute("weight", f.isBold() ? "bold" : "normal");
                }
            } else if (cmd.equals("color") && this.elem != null) {
                if (this.textAttrs == null) {
                    this.textAttrs = this.elem.getOwnerDocument().createElement("TextAttrs");
                    this.elem.appendChild(this.textAttrs);
                }
                this.textAttrs.setAttribute("color", Integer.toString(this.textStyle.getFontColor().getRGB()));
            }
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public void addActionListener(SGActionListener listener) {
        this.listener = listener;
    }

    public void removeActionListener(SGActionListener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    public void addToGroup(String group) {
        if (this.elem == null) {
            return;
        }
        String action = this._addToGroup(group);
        if (action != null && this.listener != null) {
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
    }

    private String _addToGroup(String group) {
        this.elem.setAttribute("group", group);
        return "removegroup:" + group;
    }

    public void removeFromGroup(String group) {
        if (this.elem == null) {
            return;
        }
        String action = this._removeFromGroup(group);
        if (action != null && this.listener != null) {
            this.listener.actionPerformed(new SGActionEvent(this, action));
        }
    }

    private String _removeFromGroup(String group) {
        String gr;
        if (this.elem.hasAttribute("group") && (gr = this.elem.getAttribute("group")).equals(group)) {
            this.elem.removeAttribute("group");
            return "addgroup:" + group;
        }
        return null;
    }

    String getGroup() {
        if (this.elem.hasAttribute("group")) {
            return this.elem.getAttribute("group");
        }
        return "";
    }

    public Rectangle getShapeBounds() {
        if (this.shape != null) {
            return this.shape.getBounds();
        }
        return null;
    }

    @Override
    public Color getDefaultFillColor() {
        if (this.customDefaultFillColor != null) {
            return this.customDefaultFillColor;
        }
        return this.style.defaultStyle.getFillColor();
    }

    @Override
    public String getDefaultFillColorSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public Color getDefaultLineColor() {
        if (this.customDefaultLineColor != null) {
            return this.customDefaultLineColor;
        }
        return this.style.defaultStyle.getLineColor();
    }

    @Override
    public String getDefaultLineColorSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public int getDefaultLineWidth() {
        if (this.customDefaultWidth != -1) {
            return this.customDefaultWidth;
        }
        return this.style.defaultStyle.getLineWidth();
    }

    @Override
    public String getDefaultLineWidthSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public int getDefaultLinePattern() {
        if (this.customDefaultPattern != -1) {
            return this.customDefaultPattern;
        }
        return this.style.defaultStyle.getLinePattern();
    }

    @Override
    public String getDefaultLinePatternSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public Font getDefaultFont() {
        Font f = this.textStyle.defaultStyle.getFont();
        f = new Font(this.customDefaultFamily == null || this.customDefaultFamily.length() == 0 ? f.getFamily() : this.customDefaultFamily, this.getDefaultFontStyle() == -1 ? f.getStyle() : this.getDefaultFontStyle(), this.customDefaultFontSize == -1 ? f.getSize() : this.customDefaultFontSize);
        return f;
    }

    @Override
    public String getDefaultFontFamily() {
        if (this.customDefaultFamily != null) {
            return this.customDefaultFamily;
        }
        return this.textStyle.defaultStyle.getFont().getFamily();
    }

    @Override
    public int getDefaultFontSize() {
        if (this.customDefaultFontSize != -1) {
            return this.customDefaultFontSize;
        }
        return this.textStyle.defaultStyle.getFont().getSize();
    }

    @Override
    public int getDefaultFontStyle() {
        boolean italic;
        Font f = this.textStyle.defaultStyle.getFont();
        boolean bold = this.customDefaultWeight != null ? this.customDefaultWeight.equals("BOLD") : f.isBold();
        boolean bl = italic = this.customDefaultStyle != null ? this.customDefaultStyle.equals("ITALIC") : f.isItalic();
        if (bold && italic) {
            return 3;
        }
        if (bold) {
            return 1;
        }
        if (italic) {
            return 2;
        }
        return 0;
    }

    @Override
    public Color getDefaultFontColor() {
        if (this.customDefaultTextColor != null) {
            return this.customDefaultTextColor;
        }
        return this.textStyle.defaultStyle.getFontColor();
    }

    public String getDefaultTextColorSource() {
        return RB.getStringResource("automatic.txt");
    }

    public String getDisplay() {
        String display = this.style.isFillOn() && this.style.isLineOn() ? RB.getStringResource("fillOutline.txt") : (this.style.isFillOn() ? RB.getStringResource("fill.txt") : RB.getStringResource("outline.txt"));
        return display;
    }

    public void setDisplay(String value) {
        int lsize;
        boolean fill = false;
        boolean line = true;
        if (RB.getStringResource("fill.txt").equalsIgnoreCase(value)) {
            fill = true;
            line = false;
        } else if (RB.getStringResource("fillOutline.txt").equalsIgnoreCase(value)) {
            fill = true;
        }
        boolean[] savedDisplay = new boolean[]{this.style.isFillOn(), this.style.isLineOn()};
        if (savedDisplay[0] == fill && savedDisplay[1] == line) {
            return;
        }
        this.style.setFillOn(fill);
        this.style.setLineOn(line);
        if (this.elem != null) {
            this.elem.setAttribute("fill", fill ? "true" : "false");
            this.elem.setAttribute("line", line ? "true" : "false");
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "display", "", value);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public void resetStyle(AAreaStyle areaStyle, ATextStyle textStyle, AMarkerStyle markerStyle) {
        String str;
        int rgb;
        String c;
        this.style = new AAreaStyle(areaStyle);
        this.textStyle = new ATextStyle(textStyle);
        if (this.fillAttrs != null && this.fillAttrs.hasAttribute("color")) {
            c = this.fillAttrs.getAttribute("color");
            rgb = Integer.parseInt(c);
            Color cc = new Color(rgb);
            this.style.setFillColor(cc);
        }
        if (this.outlineAttrs != null) {
            if (this.outlineAttrs.hasAttribute("pattern")) {
                int pattern = Integer.parseInt(this.outlineAttrs.getAttribute("pattern"));
                this.style.setLinePattern(pattern);
            }
            if (this.outlineAttrs.hasAttribute("width")) {
                int width = Integer.parseInt(this.outlineAttrs.getAttribute("width"));
                this.style.setLineWidth(width);
            }
            if (this.outlineAttrs.hasAttribute("color")) {
                c = this.outlineAttrs.getAttribute("color");
                rgb = Integer.parseInt(c);
                Color color = new Color(rgb);
                this.style.setLineColor(color);
            }
        }
        if (this.textAttrs != null) {
            Font f = this.textStyle.getFont();
            String fa = "";
            String weight = "";
            String style = "";
            int size = -1;
            if (this.textAttrs.hasAttribute("family")) {
                fa = this.textAttrs.getAttribute("family");
            }
            if (this.textAttrs.hasAttribute("size")) {
                size = Integer.parseInt(this.textAttrs.getAttribute("size"));
            }
            if (this.textAttrs.hasAttribute("weight")) {
                weight = this.textAttrs.getAttribute("weight").toUpperCase();
            }
            if (this.textAttrs.hasAttribute("style")) {
                style = this.textAttrs.getAttribute("style").toUpperCase();
            }
            String family = fa != null ? fa : f.getFamily();
            int fsize = size != -1 ? size : f.getSize();
            boolean bold = weight != null ? weight.equals("BOLD") : f.isBold();
            boolean italic = style != null ? style.equals("ITALIC") : f.isItalic();
            int fstyle = 0;
            if (bold) {
                fstyle |= 1;
            }
            if (italic) {
                fstyle |= 2;
            }
            this.textStyle.setFont(new Font(family, fstyle, fsize));
            if (this.textAttrs.hasAttribute("color")) {
                String c2 = this.textAttrs.getAttribute("color");
                int rgb2 = Integer.parseInt(c2);
                Color color = new Color(rgb2);
                this.textStyle.setFontColor(color);
            }
        }
        if (this.elem.hasAttribute("fill")) {
            str = this.elem.getAttribute("fill");
            this.customDefaultFill = !str.equalsIgnoreCase("false");
            this.style.setFillOn(this.customDefaultFill);
        }
        if (this.elem.hasAttribute("line")) {
            str = this.elem.getAttribute("line");
            this.customDefaultLine = !str.equalsIgnoreCase("false");
            this.style.setLineOn(this.customDefaultLine);
        }
        if (this.elem.hasAttribute("transparency")) {
            String ca = this.elem.getAttribute("transparency");
            int transparency = Integer.parseInt(ca);
            this.style.setFillTrans(transparency);
        }
        if (this.elem.hasAttribute("text")) {
            this.savedText = this.text = this.elem.getAttribute("text");
        }
        if (this.as != null) {
            Color cc = this.textStyle.getFontColor();
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            this.as.addAttribute(TextAttribute.FONT, this.scaledFont(this.textStyle.getFont()));
            if (this.frc != null) {
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            }
        }
    }

    void requestFocus() {
        if (this.c != null) {
            this.c.requestFocus();
        }
    }

    public Element getCustomAttrs() {
        if (this.customAttrs != null) {
            return this.customAttrs;
        }
        this.customAttrs = this.elem.getOwnerDocument().createElement("CustomAttrs");
        this.customAttrs.setAttribute("fill", this.customDefaultFill ? "true" : "false");
        this.customAttrs.setAttribute("line", this.customDefaultLine ? "true" : "false");
        if (this.customDefaultFillColor != null) {
            this.customAttrs.setAttribute("fillColor", Integer.toString(this.customDefaultFillColor.getRGB()));
        }
        if (this.customDefaultPattern != -1) {
            this.customAttrs.setAttribute("pattern", Integer.toString(this.customDefaultPattern));
        }
        if (this.customDefaultLineColor != null) {
            this.customAttrs.setAttribute("lineColor", Integer.toString(this.customDefaultLineColor.getRGB()));
        }
        if (this.customDefaultWidth != -1) {
            this.customAttrs.setAttribute("width", Integer.toString(this.customDefaultWidth));
        }
        if (this.customDefaultFamily != null && this.customDefaultFamily.length() > 0) {
            this.customAttrs.setAttribute("family", this.customDefaultFamily);
        }
        if (this.customDefaultFontSize != -1) {
            this.customAttrs.setAttribute("size", Integer.toString(this.customDefaultFontSize));
        }
        if (this.customDefaultStyle != null && this.customDefaultStyle.length() > 0) {
            this.customAttrs.setAttribute("style", this.customDefaultStyle);
        }
        if (this.customDefaultWeight != null && this.customDefaultWeight.length() > 0) {
            this.customAttrs.setAttribute("weifht", this.customDefaultWeight);
        }
        if (this.customDefaultTextColor != null) {
            this.customAttrs.setAttribute("textColor", Integer.toString(this.customDefaultTextColor.getRGB()));
        }
        return this.customAttrs;
    }

    public boolean isFormattingEnabled() {
        return !this.caretOn || this.formattingEnabled;
    }

    public boolean isAreaAttrsEnabled() {
        return this.areaAttrsEnabled;
    }

    public boolean isOutlineAttrsEnabled() {
        return this.outlineAttrsEnabled;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Container container;
        FocusTraversalPolicy policy;
        Component c2;
        if (this.caretOn && this.c != null && this.c instanceof JPanel && (c2 = (policy = (container = this.c.getFocusCycleRootAncestor()).getFocusTraversalPolicy()).getComponentAfter(container, this.c)) == e.getOppositeComponent()) {
            this.c.requestFocus();
        }
    }

    public Rectangle2D getBounds() {
        Rectangle r;
        Rectangle rectangle = r = this.shape != null ? this.shape.getBounds() : new Rectangle();
        if (this.text != null && this.text.length() > 0) {
            r = r.union(this.handles[9].getBounds());
        }
        if (this.anchorAttachedToData) {
            Point p1 = new Point(r.x, r.y);
            Point p2 = new Point(r.x + r.width, r.y + r.height);
            Object[] d1 = new Double[2];
            Object[] d2 = new Double[2];
            d1 = ((Annotatable)this.graph).convertScreenToData(this.parentID, p1, d1);
            d2 = ((Annotatable)this.graph).convertScreenToData(this.parentID, p2, d2);
            double x1 = (Double)d1[0];
            double x2 = (Double)d2[0];
            double y1 = (Double)d1[1];
            double y2 = (Double)d2[1];
            double xo = Math.min(x1, x2);
            double yo = Math.min(y1, y2);
            double ww = Math.abs(x2 - x1);
            double hh = Math.abs(y2 - y1);
            return new Rectangle2D.Double(xo, yo, ww, hh);
        }
        return r;
    }

    public Rectangle getScreenBounds() {
        Rectangle r;
        Rectangle rectangle = r = this.shape != null ? this.shape.getBounds() : new Rectangle();
        if (this.text != null && this.text.length() > 0) {
            r = r.union(this.handles[9].getBounds());
        }
        return r;
    }
}

