/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.elements.SGMarker;
import com.sas.graphics.sg.interfaces.AlignInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.ui.Apply;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SimpleTextCustomizerPanel;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.util.GraphFileFilter;
import com.sas.graphics.sg.util.NameGenerator;
import com.sas.graphics.sg.util.SGActionEvent;
import com.sas.graphics.sg.util.SGActionListener;
import com.sas.graphics.sg.util.SGIcon;
import com.sas.graphics.sg.util.UnDoable;
import com.sas.graphics.sganno.AAreaStyle;
import com.sas.graphics.sganno.AMarkerStyle;
import com.sas.graphics.sganno.ATextStyle;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AnnotateList;
import com.sas.graphics.sganno.AnnotateParser;
import com.sas.graphics.sganno.AnnotatePropertyChangeListener;
import com.sas.graphics.sganno.AreaElement;
import com.sas.graphics.sganno.ArrowAndTextCompositeElement;
import com.sas.graphics.sganno.ArrowLineElement;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.EllipseElement;
import com.sas.graphics.sganno.Group;
import com.sas.graphics.sganno.ImageElement;
import com.sas.graphics.sganno.LineElement;
import com.sas.graphics.sganno.MarkerElement;
import com.sas.graphics.sganno.RB;
import com.sas.graphics.sganno.RectangleElement;
import com.sas.graphics.sganno.TextElement;
import com.sas.graphics.sganno.ui.AnnotateCustomizerPanel;
import com.sas.graphics.sganno.ui.GroupCustomizerPanel;
import com.sas.graphics.styles.Style;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.RepaintManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Annotate
implements MouseMotionListener,
MouseListener,
AnnotatePropertyChangeListener,
UnDoable,
ActionListener {
    public static final String RB_KEY = "Annotate.";
    static final int INTERACTION_NONE = -1;
    static final int DRAG_NONE = -1;
    static final int DRAG_TEXT = 9;
    static final int DRAG_TOPLEFT = 0;
    static final int DRAG_LEFT = 1;
    static final int DRAG_BOTTOMLEFT = 2;
    static final int DRAG_BOTTOM = 3;
    static final int DRAG_BOTTOMRIGHT = 4;
    static final int DRAG_RIGHT = 5;
    static final int DRAG_TOPRIGHT = 6;
    static final int DRAG_TOP = 7;
    static final int DRAG_ROTATE = 8;
    static final int DRAG_MOVE = 10;
    private static Cursor RotateCursor = com.sas.graphics.sg.util.Util.createCursor("Rotate", new Point(8, 8), "a_rotate5.gif");
    private static Cursor LineCursor = com.sas.graphics.sg.util.Util.createCursor("Line", new Point(0, 0), "c_line.gif");
    private static Cursor ArrowCursor = com.sas.graphics.sg.util.Util.createCursor("Arrow", new Point(1, 4), "c_arrow.gif");
    private static Cursor RectCursor = com.sas.graphics.sg.util.Util.createCursor("Rectangle", new Point(0, 2), "c_rect.gif");
    private static Cursor EllipseCursor = com.sas.graphics.sg.util.Util.createCursor("Oval", new Point(0, 4), "c_ellipse.gif");
    private static Cursor TextCursor = com.sas.graphics.sg.util.Util.createCursor("Text", new Point(1, 3), "c_text.gif");
    private static Cursor ImageCursor = com.sas.graphics.sg.util.Util.createCursor("Image", new Point(0, 4), "c_image.gif");
    private static Cursor MarkersCursor = com.sas.graphics.sg.util.Util.createCursor("Markers", new Point(1, 3), "c_markers.gif");
    Vector drawables = new Vector();
    BaseAnnotatable graph;
    private int drawType = -1;
    private AAreaStyle style;
    private ATextStyle textStyle;
    private AMarkerStyle markerStyle;
    private boolean dirty = false;
    private AnnotateElement curElement = null;
    private Document dom;
    private Element annoElem;
    boolean load = false;
    private Graphics2D bgc1;
    private boolean creatingElement = false;
    private boolean movingElement = false;
    private HashMap elemToAnnotate = new HashMap();
    private boolean ready = false;
    SGActionListener sgActionListener;
    private Element buffer;
    private boolean copying = false;
    private AnnotateList selectionList = new AnnotateList();
    private Group curGroup = null;
    private HashMap groups = new HashMap();
    private HashMap ungroups = new HashMap();
    private boolean insertPopupOn = true;
    private boolean popupEnabled = true;
    private boolean imageAttachToDataEnabled = false;
    private String imagePath = null;
    private AAreaStyle defaultStyle;
    private ATextStyle defaultTextStyle = null;
    private AMarkerStyle defaultMarkerStyle = null;
    private ActionListener toolListner = new ToolbarListener();
    private String lastPath = null;
    private boolean onText = false;
    private JComponent container;
    private JToolBar formatBar = null;
    private AbstractButton markerButton;
    private Element fillAttrs;
    private Element markerAttrs;
    private Element lineAttrs;
    private Element textAttrs;
    private ColorGrabber colorGrabber = null;
    private TreeSet imageFileList = new TreeSet();
    private boolean saveDefaultAttrs = false;
    private ArrayList globalMenuItems = null;
    private boolean clipToScreen = true;
    private boolean loadOnly = false;
    private int moveType = -1;
    private boolean drag = false;
    private int xdmin = 0;
    private int ydmin = 0;
    private int xdmax = 0;
    private int ydmax = 0;
    private boolean prevDirty = false;
    private Object[] prevDataPoint = new Double[2];
    int prevx;
    int prevy;
    private int xoffset = 0;
    private int yoffset = 0;
    private boolean clearBuffer = true;
    JPopupMenu shapePM;
    JPopupMenu textPM;
    JPopupMenu groupPM;
    JPopupMenu controlPM;
    JPopupMenu insertPM;
    Component popupComponent;
    int popupx;
    int popupy;
    private static final GraphFileFilter filter = new GraphFileFilter(10);
    private JToggleButton select;
    JPanel savedPanel = null;
    String savedTitle = null;
    Element savedElement = null;
    private Object lastAction = null;
    protected ArrayList changeListeners = new ArrayList();
    protected ArrayList propertyChangeListeners = new ArrayList();
    private boolean eventsEnabled = true;
    NameGenerator nameGenerator = new NameGenerator();
    private boolean dataValuesDirty = false;

    public Annotate(BaseAnnotatable an) {
        this(an, false);
    }

    public Annotate(BaseAnnotatable an, boolean saveDefaultAttrs) {
        Node node;
        NodeList list;
        this.dom = an.getDocument();
        this.saveDefaultAttrs = saveDefaultAttrs;
        if (this.dom == null) {
            DocumentBuilder builder = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            this.dom = builder.newDocument();
            Element root = this.dom.createElement("Root");
            this.dom.appendChild(root);
        }
        if ((list = this.dom.getElementsByTagName("Annotation")).getLength() > 0) {
            this.annoElem = (Element)list.item(0);
        } else {
            node = this.dom.getFirstChild();
            this.annoElem = this.dom.createElement("Annotation");
            node.appendChild(this.annoElem);
        }
        this.load = true;
        this.graph = an;
        if (this.graph instanceof Annotatable) {
            this.defaultStyle = new AAreaStyle((Annotatable)this.graph);
            this.defaultTextStyle = new ATextStyle((Annotatable)this.graph);
            this.defaultMarkerStyle = new AMarkerStyle((Annotatable)this.graph);
        } else {
            this.defaultStyle = new AAreaStyle((Annotatable)null);
            this.defaultTextStyle = new ATextStyle((Annotatable)null);
            this.defaultMarkerStyle = new AMarkerStyle((Annotatable)null);
        }
        String elemTag = "";
        for (node = this.annoElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("LineAttrs")) {
                this.lineAttrs = (Element)node;
                continue;
            }
            if (elemTag.equals("FillAttrs")) {
                this.fillAttrs = (Element)node;
                continue;
            }
            if (elemTag.equals("TextAttrs")) {
                this.textAttrs = (Element)node;
                continue;
            }
            if (!elemTag.equals("MarkerAttrs")) continue;
            this.markerAttrs = (Element)node;
        }
        if (this.graph instanceof Annotatable) {
            if (saveDefaultAttrs) {
                this.annoElem.setAttribute("line", this.defaultStyle.lineOn ? "true" : "false");
                this.annoElem.setAttribute("fill", this.defaultStyle.fillOn ? "true" : "false");
                this.annoElem.setAttribute("transparency", Integer.toString(this.defaultStyle.getFillTrans()));
                if (this.fillAttrs == null) {
                    this.fillAttrs = this.annoElem.getOwnerDocument().createElement("FillAttrs");
                    this.fillAttrs.setAttribute("color", Integer.toString(this.defaultStyle.getFillColor().getRGB()));
                    this.annoElem.appendChild(this.fillAttrs);
                }
                if (this.lineAttrs == null) {
                    this.lineAttrs = this.annoElem.getOwnerDocument().createElement("LineAttrs");
                    this.lineAttrs.setAttribute("color", Integer.toString(this.defaultStyle.getLineColor().getRGB()));
                    this.lineAttrs.setAttribute("pattern", Integer.toString(this.defaultStyle.getLinePattern()));
                    this.lineAttrs.setAttribute("width", Integer.toString(this.defaultStyle.getLineWidth()));
                    this.annoElem.appendChild(this.lineAttrs);
                }
                if (this.textAttrs == null) {
                    this.textAttrs = this.annoElem.getOwnerDocument().createElement("TextAttrs");
                    this.textAttrs.setAttribute("color", Integer.toString(this.defaultTextStyle.getFontColor().getRGB()));
                    this.textAttrs.setAttribute("family", this.defaultTextStyle.getFontFamily());
                    this.textAttrs.setAttribute("size", Integer.toString(this.defaultTextStyle.getFontSize()));
                    this.textAttrs.setAttribute("weight", this.defaultTextStyle.isBold() ? "BOLD" : "REGULAR");
                    this.textAttrs.setAttribute("style", this.defaultTextStyle.isItalic() ? "ITALIC" : "REGULAR");
                    this.annoElem.appendChild(this.textAttrs);
                }
                if (this.markerAttrs == null) {
                    this.markerAttrs = this.annoElem.getOwnerDocument().createElement("MarkerAttrs");
                    this.markerAttrs.setAttribute("color", Integer.toString(this.defaultMarkerStyle.getMarkerColor().getRGB()));
                    this.markerAttrs.setAttribute("symbol", Integer.toString(this.defaultMarkerStyle.getMarkerSymbol()));
                    this.markerAttrs.setAttribute("size", Integer.toString(this.defaultMarkerStyle.getMarkerSize()));
                    this.annoElem.appendChild(this.markerAttrs);
                }
            }
        } else {
            String c;
            int rgb;
            if (this.annoElem.hasAttribute("line")) {
                this.defaultStyle.setLineOn(this.annoElem.getAttribute("line").equalsIgnoreCase("true"));
            }
            if (this.annoElem.hasAttribute("fill")) {
                this.defaultStyle.setFillOn(this.annoElem.getAttribute("fill").equalsIgnoreCase("true"));
            }
            if (this.annoElem.hasAttribute("transparency")) {
                this.defaultStyle.setFillTrans(Integer.parseInt(this.annoElem.getAttribute("transparency")));
            }
            if (this.fillAttrs != null && this.fillAttrs.hasAttribute("color") && (rgb = Integer.parseInt(c = this.fillAttrs.getAttribute("color"))) != this.defaultStyle.getFillColor().getRGB()) {
                this.defaultStyle.setFillColor(new Color(rgb));
            }
            if (this.lineAttrs != null) {
                int pattern;
                if (this.lineAttrs.hasAttribute("pattern") && (pattern = Integer.parseInt(this.lineAttrs.getAttribute("pattern"))) != this.defaultStyle.getLinePattern()) {
                    this.defaultStyle.setLinePattern(pattern);
                }
                if (this.lineAttrs.hasAttribute("width")) {
                    int width = Integer.parseInt(this.lineAttrs.getAttribute("width"));
                    if (this.defaultStyle.getLineWidth() != width) {
                        this.defaultStyle.setLineWidth(width);
                    }
                }
                if (this.lineAttrs.hasAttribute("color") && (rgb = Integer.parseInt(c = this.lineAttrs.getAttribute("color"))) != this.defaultStyle.getLineColor().getRGB()) {
                    this.defaultStyle.setLineColor(new Color(rgb));
                }
            }
            if (this.textAttrs != null) {
                Font newFont;
                Font f = this.defaultTextStyle.getFont();
                String family = this.textAttrs.hasAttribute("family") ? this.textAttrs.getAttribute("family") : f.getFamily();
                int size = this.textAttrs.hasAttribute("size") ? Integer.parseInt(this.textAttrs.getAttribute("size")) : f.getSize();
                boolean bold = this.textAttrs.hasAttribute("weight") ? this.textAttrs.getAttribute("weight").equalsIgnoreCase("bold") : f.isBold();
                boolean italic = this.textAttrs.hasAttribute("style") ? this.textAttrs.getAttribute("style").equalsIgnoreCase("italic") : f.isItalic();
                int fstyle = 0;
                if (bold) {
                    fstyle |= 1;
                }
                if (italic) {
                    fstyle |= 2;
                }
                if (!(newFont = new Font(family, fstyle, size)).toString().equals(f.toString())) {
                    this.defaultTextStyle.setFont(newFont);
                }
                if (this.textAttrs.hasAttribute("color")) {
                    String c2 = this.textAttrs.getAttribute("color");
                    int rgb2 = Integer.parseInt(c2);
                    if (this.defaultTextStyle.getFontColor().getRGB() != rgb2) {
                        this.defaultTextStyle.setFontColor(new Color(rgb2));
                    }
                }
            }
            if (this.markerAttrs != null) {
                int symbol;
                if (this.markerAttrs.hasAttribute("symbol") && (symbol = Integer.parseInt(this.markerAttrs.getAttribute("symbol"))) != this.defaultMarkerStyle.getMarkerSymbol()) {
                    this.defaultMarkerStyle.setMarkerSymbol(symbol);
                }
                if (this.markerAttrs.hasAttribute("size")) {
                    int size = Integer.parseInt(this.markerAttrs.getAttribute("size"));
                    if (this.defaultMarkerStyle.getMarkerSize() != size) {
                        this.defaultMarkerStyle.setMarkerSize(size);
                    }
                }
                if (this.markerAttrs.hasAttribute("color")) {
                    c = this.markerAttrs.getAttribute("color");
                    rgb = Integer.parseInt(c);
                    if (this.defaultMarkerStyle.getMarkerColor().getRGB() != rgb) {
                        this.defaultMarkerStyle.setMarkerColor(new Color(rgb));
                    }
                }
            }
        }
        this.style = new AAreaStyle(this.defaultStyle);
        this.textStyle = new ATextStyle(this.defaultTextStyle);
        this.markerStyle = new AMarkerStyle(this.defaultMarkerStyle);
        this.selectionList.addPropertyChangeListener(this);
        this.markerStyle.setFallbackToDefault(false);
        this.style.setFallbackToDefault(false);
        this.textStyle.setFallbackToDefault(false);
    }

    public void setLoadOnly(boolean flag) {
        this.loadOnly = flag;
    }

    public void setReferencePath(String path) {
        this.lastPath = path;
    }

    public void resetStyle(Style style) {
        if (this.graph instanceof Annotatable) {
            Annotatable anGraph = (Annotatable)this.graph;
            this.defaultStyle.setStyle(anGraph, style);
            this.defaultTextStyle.setStyle(anGraph, style);
            this.defaultMarkerStyle.setStyle(anGraph, style);
            for (int i = 0; i < this.drawables.size(); ++i) {
                ((AnnotateElement)this.drawables.get(i)).resetStyle(this.defaultStyle, this.defaultTextStyle, this.defaultMarkerStyle);
            }
            if (this.saveDefaultAttrs) {
                this.annoElem.setAttribute("line", this.defaultStyle.lineOn ? "true" : "false");
                this.annoElem.setAttribute("fill", this.defaultStyle.fillOn ? "true" : "false");
                this.annoElem.setAttribute("transparency", Integer.toString(this.defaultStyle.getFillTrans()));
            }
            if (this.fillAttrs != null) {
                this.fillAttrs.setAttribute("color", Integer.toString(this.defaultStyle.getFillColor().getRGB()));
            }
            if (this.lineAttrs != null) {
                this.lineAttrs.setAttribute("color", Integer.toString(this.defaultStyle.getLineColor().getRGB()));
                this.lineAttrs.setAttribute("pattern", Integer.toString(this.defaultStyle.getLinePattern()));
                this.lineAttrs.setAttribute("width", Integer.toString(this.defaultStyle.getLineWidth()));
            }
            if (this.textAttrs != null) {
                this.textAttrs.setAttribute("color", Integer.toString(this.defaultTextStyle.getFontColor().getRGB()));
                this.textAttrs.setAttribute("family", this.defaultTextStyle.getFontFamily());
                this.textAttrs.setAttribute("size", Integer.toString(this.defaultTextStyle.getFontSize()));
                this.textAttrs.setAttribute("weight", this.defaultTextStyle.isBold() ? "BOLD" : "REGULAR");
                this.textAttrs.setAttribute("style", this.defaultTextStyle.isItalic() ? "ITALIC" : "REGULAR");
            }
            if (this.markerAttrs != null) {
                this.markerAttrs.setAttribute("color", Integer.toString(this.defaultMarkerStyle.getMarkerColor().getRGB()));
                this.markerAttrs.setAttribute("symbol", Integer.toString(this.defaultMarkerStyle.getMarkerSymbol()));
                this.markerAttrs.setAttribute("size", Integer.toString(this.defaultMarkerStyle.getMarkerSize()));
            }
        }
    }

    public void setColor(Color c) {
        this.style.setLineColor(c);
        if (this.curElement != null) {
            this.curElement.setColor(c);
            this.graph.annotateRepaint();
        }
    }

    public void setFont(Font f) {
        this.textStyle.setFont(new Font(f.getFamily(), f.getStyle(), f.getSize()));
        if (this.curElement != null) {
            this.curElement.setFont(new Font(f.getFamily(), f.getStyle(), f.getSize()));
            this.graph.annotateRepaint();
            if (this.onText) {
                this.curElement.requestFocus();
            }
        }
    }

    public Font getFont() {
        return this.textStyle.getFont();
    }

    public TextInterface getTextStyle() {
        if (this.curGroup != null) {
            return this.curGroup;
        }
        if (this.curElement != null) {
            return this.curElement;
        }
        return this.textStyle;
    }

    public Color getColor() {
        return this.style.getLineColor();
    }

    public void setLinePattern(int pattern) {
        this.style.setLinePattern(pattern);
        if (this.curElement != null) {
            this.curElement.setLinePattern(pattern);
            this.graph.annotateRepaint();
        }
    }

    public void setLineWidth(int thickness) {
        this.style.setLineWidth(thickness);
        if (this.curElement != null) {
            this.curElement.setLineWidth(thickness);
            this.graph.annotateRepaint();
        }
    }

    public void setLineStyle(LineInterface lineStyle) {
        this.style.setLineStyle(lineStyle);
        if (this.curElement != null) {
            this.curElement.setLineStyle(lineStyle);
            this.graph.annotateRepaint();
        }
    }

    public LineInterface getLineStyle() {
        return this.style;
    }

    public void setType(int aType) {
        this.drawType = aType;
        if (this.curElement != null) {
            if (this.curElement.isCaretOn()) {
                this.isDeletedOnDisable(this.curElement);
            }
            this.curElement = null;
            this.graph.annotateRepaint();
        }
    }

    public int getType() {
        return this.drawType;
    }

    public void paint(Graphics2D g) {
        AnnotateElement ae;
        if (this.load) {
            Object pointer = null;
            if (this.sgActionListener != null) {
                pointer = this.sgActionListener.getLastAction();
            }
            this.load = false;
            AnnotateParser.load(this, this.graph, this.annoElem, this.loadOnly);
            if (this.sgActionListener != null) {
                this.sgActionListener.discardActionsUpto(pointer);
            }
        }
        this.ready = true;
        if (this.drawables.size() == 0) {
            return;
        }
        if (this.dirty && !this.creatingElement) {
            HashSet<String> gl = new HashSet<String>();
            for (int i = 0; i < this.drawables.size(); ++i) {
                ae = (AnnotateElement)this.drawables.get(i);
                ae.update();
                String group = ae.getGroup();
                if (group.length() <= 0) continue;
                gl.add(group);
            }
            Iterator iter = gl.iterator();
            while (iter.hasNext()) {
                Group gg = this.getGroup((String)iter.next());
                gg.resetBounds();
            }
        }
        if (g != this.bgc1) {
            for (int i = 0; i < this.drawables.size(); ++i) {
                ((AnnotateElement)this.drawables.get(i)).paint(g);
            }
            if (this.selectionList.size() > 0) {
                this.selectionList.drawHandles(g);
            } else if (this.curGroup != null) {
                this.curGroup.drawHandles(g);
            } else if (this.curElement != null && this.drawType == -1) {
                this.curElement.drawHandles(g);
            }
        } else if (this.curGroup == null) {
            for (int i = 0; i < this.drawables.size(); ++i) {
                if (this.drawables.get(i) == this.curElement) continue;
                ((AnnotateElement)this.drawables.get(i)).paint(g);
            }
        } else {
            String gid = this.curGroup.getID();
            for (int i = 0; i < this.drawables.size(); ++i) {
                ae = (AnnotateElement)this.drawables.get(i);
                if (gid.equals(ae.getGroup())) continue;
                ((AnnotateElement)this.drawables.get(i)).paint(g);
            }
        }
        if (this.prevDirty) {
            Object obj;
            AnnotateElement ae2 = this.curElement;
            if (ae2 == null && (obj = this.curGroup.getAllMembers().get(0)) instanceof AnnotateElement) {
                ae2 = (AnnotateElement)obj;
            }
            if (ae2 != null && ae2.isAnchorAttachedToData()) {
                Point2D p = ((Annotatable)this.graph).convertDataToScreen(ae2.parentID, this.prevDataPoint);
                this.prevx = (int)p.getX();
                this.prevy = (int)p.getY();
            }
            this.prevDirty = false;
        }
        if (!this.creatingElement) {
            this.dirty = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        block51: {
            block50: {
                Component component;
                block52: {
                    boolean sameGroups;
                    ArrayList<AnnotateElement> list;
                    boolean sameElements;
                    int y;
                    int x;
                    Group oldGroup;
                    block54: {
                        block53: {
                            boolean pointMoved;
                            if (!this.ready || this.drawType == -2) {
                                return;
                            }
                            if ((arg0.getModifiers() & 0x10) == 0) {
                                return;
                            }
                            component = arg0.getComponent();
                            boolean bl = pointMoved = Math.abs(arg0.getX() - this.prevx) + Math.abs(arg0.getY() - this.prevy) > 2;
                            if ((this.curElement != null || this.curGroup != null) && (this.drag || !pointMoved && !this.dataValuesDirty)) break block51;
                            AnnotateElement old = this.curElement;
                            oldGroup = this.curGroup;
                            x = arg0.getX();
                            y = arg0.getY();
                            this.xdmax = 0;
                            this.xdmin = 0;
                            this.ydmax = 0;
                            this.ydmin = 0;
                            this.moveType = -1;
                            if (this.drawType != -1) break block52;
                            for (int i = this.drawables.size() - 1; i >= 0; --i) {
                                if (!((AnnotateElement)this.drawables.get(i)).isSelected(this.prevx, this.prevy)) continue;
                                this.curElement = (AnnotateElement)this.drawables.get(i);
                                break;
                            }
                            boolean bl2 = sameElements = old == this.curElement;
                            if (old != null && !sameElements) {
                                this.isDeletedOnDisable(old);
                            }
                            this.curGroup = null;
                            if (this.curElement == null) break block53;
                            String gr = this.curElement.getGroup();
                            if (gr == null || gr.length() <= 0) break block54;
                            this.curGroup = this.getGroup(gr);
                            if (this.curGroup != null && (list = this.curGroup.getAllMembers()).size() > 0) {
                                this.curElement = (AnnotateElement)list.get(0);
                            }
                            break block54;
                        }
                        for (Group gr : this.groups.values()) {
                            if (!gr.isVisible() || !gr.contains(this.prevx, this.prevy)) continue;
                            this.curGroup = gr;
                            break;
                        }
                    }
                    boolean bl = sameGroups = this.curGroup == oldGroup;
                    if (this.copying && this.graph instanceof Annotatable && !sameElements && !sameGroups) {
                        if (this.curGroup != null) {
                            list = this.curGroup.getAllMembers();
                        } else if (this.selectionList.size() > 1) {
                            list = this.selectionList;
                        } else {
                            list = new ArrayList<AnnotateElement>();
                            list.add(this.curElement);
                        }
                        if (this.graph instanceof Annotatable) {
                            this.setElementParent(list);
                        }
                    }
                    if (this.curElement != null || this.curGroup != null) {
                        Rectangle r;
                        this.moveType = this.selectionList.size() > 1 ? -1 : (this.curGroup == null ? this.curElement.getHandleAt(this.prevx, this.prevy) : 10);
                        boolean bl3 = this.movingElement = this.moveType >= 0;
                        if (this.moveType == 9) {
                            if (this.onText) {
                                this.movingElement = false;
                                this.curElement.setSelectPosition(x, y);
                            } else {
                                this.moveType = 10;
                            }
                        }
                        if (this.curGroup != null) {
                            this.curGroup.startMove(this.moveType);
                            r = this.curGroup.getScreenBounds();
                            this.xdmin = Math.max(0, x - r.x);
                            this.xdmax = Math.max(0, r.x + r.width - x);
                            this.ydmin = Math.max(0, y - r.y);
                            this.ydmax = Math.max(0, r.y + r.height - y);
                        } else if (this.moveType != -1 && this.moveType != 9) {
                            this.curElement.startMove(this.moveType);
                            r = this.curElement.getScreenBounds();
                            if (this.moveType == 10) {
                                this.xdmin = Math.max(0, x - r.x);
                                this.xdmax = Math.max(0, r.x + r.width - x);
                                this.ydmin = Math.max(0, y - r.y);
                                this.ydmax = Math.max(0, r.y + r.height - y);
                            }
                        }
                    } else {
                        for (Group gr : this.groups.values()) {
                            if (!gr.isVisible() || !gr.contains(this.prevx, this.prevy)) continue;
                            this.curGroup = gr;
                            this.moveType = 10;
                            this.movingElement = true;
                            this.curGroup.startMove(10);
                            break block50;
                        }
                    }
                    break block50;
                }
                if (this.drawType != 9 && this.drawType != 8) {
                    this.xdmax = 0;
                    this.xdmin = 0;
                    this.ydmax = 0;
                    this.ydmin = 0;
                    this.createElement(component, this.prevx, this.prevy);
                }
            }
            if (this.curElement != null) {
                if (this.creatingElement) {
                    this.curElement.setControlDown(arg0.isControlDown());
                }
                this.curElement.setShiftDown(arg0.isShiftDown());
            }
            this.drag = true;
        }
        if (this.curElement == null && this.curGroup == null) {
            return;
        }
        int x = arg0.getX();
        int y = arg0.getY();
        if (this.container != null && this.clipToScreen) {
            Rectangle d = this.container.getBounds();
            Graphics g = this.container.getGraphics();
            double sx = 1.0;
            double sy = 1.0;
            if (g instanceof Graphics2D) {
                sx = ((Graphics2D)g).getTransform().getScaleX();
                sy = ((Graphics2D)g).getTransform().getScaleY();
            }
            if ((double)(x - this.xdmin) < (double)d.x / sx) {
                x = (int)((double)d.x / sx) + this.xdmin;
            } else if ((double)(x + this.xdmax) > (double)(d.x + d.width) / sx) {
                x = (int)((double)(d.x + d.width) / sx) - this.xdmax;
            }
            if ((double)(y - this.ydmin) < (double)d.y / sy) {
                y = (int)((double)d.y / sy) + this.ydmin;
            } else if ((double)(y + this.ydmax) > (double)(d.y + d.height) / sy) {
                y = (int)((double)(d.y + d.height) / sy) - this.ydmax;
            }
        }
        if (this.movingElement) {
            if (this.dataValuesDirty) {
                Object obj;
                AnnotateElement ae = this.curElement;
                if (ae == null && (obj = this.curGroup.getAllMembers().get(0)) instanceof AnnotateElement) {
                    ae = (AnnotateElement)obj;
                }
                if (ae != null && ae.isAnchorAttachedToData()) {
                    this.prevDirty = true;
                    this.prevDataPoint = ((Annotatable)this.graph).convertScreenToData(ae.parentID, new Point(x, y), this.prevDataPoint);
                }
            }
            if (this.curGroup != null) {
                this.curGroup.move(this.moveType, x - this.prevx, y - this.prevy);
            } else {
                this.curElement.move(this.moveType, x - this.prevx, y - this.prevy);
            }
            this.prevx = x;
            this.prevy = y;
        } else if (this.creatingElement) {
            if (this.curElement instanceof LineElement) {
                Rectangle r;
                String parent;
                LineElement le = (LineElement)this.curElement;
                String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
                if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
                    parent = null;
                }
                String op = null;
                if (arg0.isControlDown() && this.curElement instanceof ArrowLineElement) {
                    this.curElement.setParent(parent);
                    op = le.getSecondaryParent();
                } else {
                    le.setSecondaryParent(parent);
                    op = parent;
                    parent = le.getParent();
                }
                if (op != null && !op.equals(parent)) {
                    le.setClipOutsideDataOn(false);
                } else {
                    le.setClipOutsideDataOn(true);
                }
            }
            this.curElement.resetPoint(new Point(x, y));
        } else if (this.curElement != null && this.curElement.isCaretOn()) {
            this.curElement.setCaretPosition(x, y);
            this.graph.annotateRepaint();
        }
        this.dataValuesDirty = false;
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        int curMoveType;
        if (!this.ready || this.drawType == -2) {
            return;
        }
        Component c = arg0.getComponent();
        if (this.drawType > -1) {
            switch (this.drawType) {
                default: {
                    c.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    c.setCursor(LineCursor);
                    break;
                }
                case 1: {
                    c.setCursor(TextCursor);
                    break;
                }
                case 4: {
                    c.setCursor(ArrowCursor);
                    break;
                }
                case 6: {
                    c.setCursor(RectCursor);
                    break;
                }
                case 5: {
                    c.setCursor(EllipseCursor);
                    break;
                }
                case 0: {
                    c.setCursor(TextCursor);
                    break;
                }
                case 8: {
                    c.setCursor(ImageCursor);
                    break;
                }
                case 9: {
                    c.setCursor(MarkersCursor);
                }
            }
            return;
        }
        AnnotateElement picked = null;
        int x = arg0.getX();
        int y = arg0.getY();
        for (int i = this.drawables.size() - 1; i >= 0; --i) {
            if (!((AnnotateElement)this.drawables.get(i)).isSelected(x, y)) continue;
            picked = (AnnotateElement)this.drawables.get(i);
            break;
        }
        if (picked != null) {
            curMoveType = picked.getGroup().equals("") ? picked.getHandleAt(x, y) : 10;
            switch (curMoveType) {
                default: {
                    break;
                }
                case 0: {
                    c.setCursor(Cursor.getPredefinedCursor(6));
                    break;
                }
                case 6: {
                    c.setCursor(Cursor.getPredefinedCursor(7));
                    break;
                }
                case 8: {
                    c.setCursor(RotateCursor);
                    break;
                }
                case 2: {
                    c.setCursor(Cursor.getPredefinedCursor(4));
                    break;
                }
                case 4: {
                    c.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 7: {
                    c.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 1: {
                    c.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 3: {
                    c.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 5: {
                    c.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                case 10: {
                    c.setCursor(Cursor.getPredefinedCursor(13));
                    break;
                }
                case 9: {
                    if (this.onText) {
                        c.setCursor(Cursor.getPredefinedCursor(2));
                        break;
                    }
                    c.setCursor(Cursor.getPredefinedCursor(13));
                    break;
                }
            }
        } else {
            curMoveType = -1;
            for (Group gr : this.groups.values()) {
                if (!gr.isVisible() || !gr.contains(x, y)) continue;
                curMoveType = 10;
                break;
            }
            if (curMoveType == 10) {
                c.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                c.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        int curMoveType;
        if (!this.ready || this.drawType == -2) {
            return;
        }
        this.drag = false;
        Component c = arg0.getComponent();
        if (arg0.isPopupTrigger() && this.popupEnabled) {
            this.doPopupMenu(arg0);
            return;
        }
        if (arg0.getButton() != 1) {
            return;
        }
        if (this.curElement != null && this.curElement.isCaretOn() && (curMoveType = this.curElement.getHandleAt(arg0.getX(), arg0.getY())) == 9) {
            this.curElement.mouseClicked(arg0);
            arg0.consume();
            this.graph.annotateRepaint();
            return;
        }
        if (arg0.getClickCount() > 1) {
            if (this.curElement != null) {
                arg0.consume();
                if (this.curElement.isCaretOn()) {
                    this.curElement.mouseClicked(arg0);
                    return;
                }
            }
            if (this.curGroup != null) {
                this.askAndSaveGroupAttrs();
            } else if (this.curElement != null) {
                curMoveType = this.curElement.getHandleAt(arg0.getX(), arg0.getY());
                boolean bl = this.onText = curMoveType == 9;
                if (this.onText) {
                    this.resetListeners(c, arg0.getX(), arg0.getY(), !arg0.isControlDown() && this.curGroup == null);
                    this.updateFormatToolBar();
                } else {
                    this.askAndSaveAnnoAttrs();
                }
            }
            return;
        }
        this.onText = false;
        if (this.drawType == -1) {
            AnnotateElement se = this.curElement;
            Group sg = this.curGroup;
            this.curElement = null;
            this.curGroup = null;
            int sc = this.selectionList.size();
            if (!arg0.isControlDown()) {
                this._resetSelectionList();
            }
            for (int i = this.drawables.size() - 1; i >= 0; --i) {
                if (!((AnnotateElement)this.drawables.get(i)).isSelected(arg0.getX(), arg0.getY())) continue;
                this.curElement = (AnnotateElement)this.drawables.get(i);
                break;
            }
            if (this.curElement != null) {
                String gid = this.curElement.getGroup();
                this.curGroup = this.getGroup(gid);
                if (this.curGroup == null) {
                    this.selectionList.add(this.curElement);
                } else {
                    this.selectionList.add(this.curGroup);
                }
                this.graph.annotateRepaint();
            } else {
                for (Group gr : this.groups.values()) {
                    if (!gr.isVisible() || !gr.contains(arg0.getX(), arg0.getY())) continue;
                    this.curGroup = gr;
                    this.selectionList.add(this.curGroup);
                    this.curElement = (AnnotateElement)this.curGroup.getAllMembers().get(0);
                    break;
                }
                if (arg0.isControlDown()) {
                    if (this.curElement == null) {
                        this.curElement = se;
                    }
                    if (this.curGroup == null) {
                        this.curGroup = sg;
                    }
                }
                if (se != this.curElement && (se != null || this.curGroup != null)) {
                    this.graph.annotateRepaint();
                }
            }
            this.resetListeners(c, arg0.getX(), arg0.getY(), !arg0.isControlDown() && this.curGroup == null);
            if (se != this.curElement || sg != this.curGroup || sc != this.selectionList.size()) {
                this.updateFormatToolBar();
            }
            return;
        }
        this.resetListeners(c, arg0.getX(), arg0.getY(), !arg0.isControlDown() && this.curGroup == null);
        if (this.drawType == 0) {
            arg0.consume();
            this.addText("", new Point(arg0.getX(), arg0.getY()), true);
            return;
        }
        if (this.drawType == 8) {
            arg0.consume();
            this.curElement = this._addImage(arg0.getX(), arg0.getY());
            this.updateFormatToolBar();
        } else if (this.drawType == 9) {
            arg0.consume();
            this.curElement = this._addMarker(arg0.getX(), arg0.getY());
            this.updateFormatToolBar();
        }
        arg0.getComponent().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void resetListeners(Component c, int x, int y, boolean editText) {
        KeyListener[] listeners = c.getKeyListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AnnotateElement)) continue;
            AnnotateElement ae = (AnnotateElement)listeners[i];
            if (ae == this.curElement && this.onText) {
                ae.setCaretOn(c, c != null);
                continue;
            }
            this.isDeletedOnDisable(ae);
        }
        if (!this.creatingElement && this.curElement != null && editText && this.onText && this.curElement.getText() != null) {
            if (!this.curElement.isCaretOn()) {
                this.curElement.setCaretOn(c, true);
            }
            if (!this.creatingElement) {
                this.curElement.setCaretPosition(x, y);
            }
            c.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    private void removeKeyListeners() {
        int size = this.drawables.size();
        for (int i = 0; i < size; ++i) {
            AnnotateElement ae = (AnnotateElement)this.drawables.get(i);
            if (!this.isDeletedOnDisable(ae)) continue;
            --i;
            --size;
        }
    }

    private boolean isDeletedOnDisable(AnnotateElement ae) {
        boolean removed = false;
        if (!ae.isCaretOn()) {
            return removed;
        }
        ae.setCaretOn(null, false);
        if (ae.getText() == null || ae.getText().equals("")) {
            if (ae instanceof TextElement) {
                Element celem = ae.elem;
                if (celem != null && celem.getParentNode() != null) {
                    Node pelem = celem.getParentNode();
                    pelem.removeChild(celem);
                }
                this.drawables.remove(ae);
                removed = true;
            } else {
                ae.deleteText();
            }
        }
        return removed;
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        int curMoveType;
        if (!this.ready || this.drawType == -2) {
            return;
        }
        this.prevx = arg0.getX();
        this.prevy = arg0.getY();
        if (arg0.isPopupTrigger() && this.popupEnabled) {
            this.doPopupMenu(arg0);
            return;
        }
        if (arg0.getButton() != 1) {
            return;
        }
        if (this.curElement != null && this.curElement.isCaretOn() && (curMoveType = this.curElement.getHandleAt(arg0.getX(), arg0.getY())) == 9) {
            return;
        }
        if (this.drawType == -1) {
            AnnotateElement se = this.curElement;
            Group sg = this.curGroup;
            this.curElement = null;
            this.curGroup = null;
            int sc = this.selectionList.size();
            if (!arg0.isControlDown()) {
                this._resetSelectionList();
            }
            for (int i = this.drawables.size() - 1; i >= 0; --i) {
                if (!((AnnotateElement)this.drawables.get(i)).isSelected(arg0.getX(), arg0.getY())) continue;
                this.curElement = (AnnotateElement)this.drawables.get(i);
                break;
            }
            if (this.curElement != null) {
                String gid = this.curElement.getGroup();
                this.curGroup = this.getGroup(gid);
                if (this.curGroup == null) {
                    this.selectionList.add(this.curElement);
                } else {
                    this.selectionList.add(this.curGroup);
                }
                if (this.curElement != se || !(this.curElement instanceof TextElement)) {
                    this.onText = false;
                }
                this.graph.annotateRepaint();
            } else {
                this.onText = false;
                for (Group gr : this.groups.values()) {
                    if (!gr.isVisible() || !gr.contains(arg0.getX(), arg0.getY())) continue;
                    this.curGroup = gr;
                    this.selectionList.add(this.curGroup);
                    this.curElement = (AnnotateElement)this.curGroup.getAllMembers().get(0);
                    break;
                }
                if (arg0.isControlDown()) {
                    if (this.curElement == null) {
                        this.curElement = se;
                    }
                    if (this.curGroup == null) {
                        this.curGroup = sg;
                    }
                }
                if (se != this.curElement && (se != null || this.curGroup != null)) {
                    this.graph.annotateRepaint();
                }
            }
            this.resetListeners(arg0.getComponent(), arg0.getX(), arg0.getY(), !arg0.isControlDown() && this.curGroup == null);
            if (se != this.curElement || sg != this.curGroup || sc != this.selectionList.size()) {
                this.updateFormatToolBar();
            }
            return;
        }
        this.onText = false;
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (!this.ready || this.drawType == -2) {
            return;
        }
        if (arg0.isPopupTrigger() && this.popupEnabled) {
            this.doPopupMenu(arg0);
            return;
        }
        if (arg0.getButton() != 1) {
            return;
        }
        Component component = arg0.getComponent();
        RepaintManager.currentManager(component).setDoubleBufferingEnabled(true);
        if (this.copying && this.graph instanceof Annotatable) {
            ArrayList<AnnotateElement> list;
            if (this.curGroup != null) {
                list = this.curGroup.getAllMembers();
            } else if (this.selectionList.isModified()) {
                list = new AnnotateList();
                list.addAll(this.selectionList);
                this.selectionList = (AnnotateList)list;
            } else if (this.selectionList.size() > 1) {
                list = this.selectionList;
            } else {
                list = new ArrayList<AnnotateElement>();
                list.add(this.curElement);
            }
            if (this.graph instanceof Annotatable) {
                this.setElementParent(list);
            }
            this.copy();
            this.copying = false;
        }
        if (this.movingElement) {
            this.finishMove(arg0.getX(), arg0.getY());
        } else if (this.creatingElement) {
            this.finishElement(arg0);
        } else if (this.drawType == 8) {
            this.curElement = this._addImage(arg0.getX(), arg0.getY());
            this.graph.annotateRepaint();
        } else if (this.drawType == 9) {
            this.curElement = this._addMarker(arg0.getX(), arg0.getY());
            this.graph.annotateRepaint();
        }
        this.updateFormatToolBar();
        this.drag = false;
        arg0.getComponent().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setElementParent(ArrayList list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Iterator iter;
            Object obj = list.get(i);
            Iterator iterator = iter = obj instanceof Group ? ((Group)obj).getAllMembers().iterator() : null;
            if (iter != null && iter.hasNext()) {
                obj = iter.next();
            }
            while (obj instanceof AnnotateElement) {
                Rectangle r;
                AnnotateElement ai = (AnnotateElement)obj;
                ai.removeActionListener(this.sgActionListener);
                if (ai instanceof AreaElement && !(obj instanceof ImageElement)) {
                    AreaElement ae = (AreaElement)ai;
                    Point p1 = ae.getUpperLeftCorner();
                    Point p2 = ae.getLowerRightCorner();
                    String parentID = ((Annotatable)this.graph).getGraphIDAt(p1.x, p1.y);
                    if (parentID == null) {
                        parentID = ((Annotatable)this.graph).getGraphIDAt(p2.x, p2.y);
                    }
                    if (parentID != null && ((r = ((Annotatable)this.graph).getDataBoundingBox(parentID)).contains(p1) || r.contains(p2))) {
                        ai.setParent(parentID);
                    }
                } else if (ai instanceof LineElement) {
                    Rectangle r2;
                    String secondary;
                    LineElement le = (LineElement)ai;
                    Point2D p = le.anchor.screen;
                    String lpid = ((Annotatable)this.graph).getGraphIDAt((int)p.getX(), (int)p.getY());
                    boolean attachedToData = true;
                    if (le.elem.hasAttribute("AnchorAttachedToData")) {
                        attachedToData = "true".equalsIgnoreCase(le.elem.getAttribute("AnchorAttachedToData"));
                    }
                    if (lpid != null && attachedToData && (r = ((Annotatable)this.graph).getDataBoundingBox(lpid)).contains(p)) {
                        Point2D p2d = le.getAnchorPoint();
                        ai.setParent(lpid);
                        Object[] data = new Double[2];
                        ((Annotatable)this.graph).convertScreenToData(lpid, p2d, data);
                        le.setAnchorPoint(new Point2D.Double((Double)data[0], (Double)data[1]));
                    }
                    attachedToData = true;
                    if (le.elem.hasAttribute("SecondaryAttachedToData")) {
                        attachedToData = "true".equalsIgnoreCase(le.elem.getAttribute("SecondaryAttachedToData"));
                    }
                    if ((secondary = ((Annotatable)this.graph).getGraphIDAt((int)(p = le.secondary.screen).getX(), (int)p.getY())) != null && attachedToData && (r2 = ((Annotatable)this.graph).getDataBoundingBox(secondary)).contains(p)) {
                        Point2D p2d = le.getSecondaryPoint();
                        le.setSecondaryParent(secondary);
                        Object[] data = new Double[2];
                        ((Annotatable)this.graph).convertScreenToData(secondary, p2d, data);
                        le.setSecondaryPoint(new Point2D.Double((Double)data[0], (Double)data[1]));
                    }
                }
                ai.finishMove(10, 0, 0);
                ai.addActionListener(this.sgActionListener);
                if (iter != null && iter.hasNext()) {
                    obj = iter.next();
                    continue;
                }
                obj = null;
            }
        }
        this.copying = false;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    private void finishMove(int x, int y) {
        if (this.container != null && this.clipToScreen) {
            Rectangle d = this.container.getBounds();
            Graphics g = this.container.getGraphics();
            double sx = 1.0;
            double sy = 1.0;
            if (g instanceof Graphics2D) {
                sx = ((Graphics2D)g).getTransform().getScaleX();
                sy = ((Graphics2D)g).getTransform().getScaleY();
            }
            if ((double)(x - this.xdmin) < (double)d.x / sx) {
                x = (int)((double)d.x / sx) + this.xdmin;
            } else if ((double)(x + this.xdmax) > (double)(d.x + d.width) / sx) {
                x = (int)((double)(d.x + d.width) / sx) - this.xdmax;
            }
            if ((double)(y - this.ydmin) < (double)d.y / sy) {
                y = (int)((double)d.y / sy) + this.ydmin;
            } else if ((double)(y + this.ydmax) > (double)(d.y + d.height) / sy) {
                y = (int)((double)(d.y + d.height) / sy) - this.ydmax;
            }
        }
        if (this.curGroup != null) {
            this.curGroup.finishMove(10, x - this.prevx, y - this.prevy);
        } else if (this.curElement != null) {
            this.curElement.finishMove(this.moveType, x - this.prevx, y - this.prevy);
        }
        this.graph.annotateRepaint();
        this.moveType = -1;
        this.movingElement = false;
        this.prevx = x;
        this.prevy = y;
    }

    private void finishElement(MouseEvent e) {
        if (this.curElement == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.container != null && this.clipToScreen) {
            Rectangle d = this.container.getBounds();
            Graphics g = this.container.getGraphics();
            double sx = 1.0;
            double sy = 1.0;
            if (g instanceof Graphics2D) {
                sx = ((Graphics2D)g).getTransform().getScaleX();
                sy = ((Graphics2D)g).getTransform().getScaleY();
            }
            x = Math.min((int)((double)(d.x + d.width) / sx), Math.max((int)((double)d.x / sx), x));
            y = Math.min((int)((double)(d.y + d.height) / sy), Math.max((int)((double)d.y / sy), y));
        }
        this.curElement.resetPoint(new Point(x, y));
        if (this.curElement instanceof LineElement) {
            Rectangle r;
            String parent;
            LineElement le = (LineElement)this.curElement;
            String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
            if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
                parent = null;
            }
            String op = null;
            if (e.isControlDown() && this.curElement instanceof ArrowLineElement) {
                this.curElement.setParent(parent);
                op = le.getSecondaryParent();
            } else {
                le.setSecondaryParent(parent);
                op = parent;
                parent = le.getParent();
            }
            if (op != null && !op.equals(parent)) {
                le.setClipOutsideDataOn(false);
            } else {
                le.setClipOutsideDataOn(true);
            }
        }
        this.curElement.finish();
        this.graph.annotateRepaint();
        this.creatingElement = false;
        if (this.drawType == 1 || this.drawType == 0) {
            this.insertText(e.getComponent());
        }
        Element ae = this.curElement.getElement();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            if (!(this.curElement instanceof TextElement)) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
            }
        }
        this.drawType = -1;
        if (this.select != null) {
            this.select.setSelected(true);
        }
        this.selectionList.add(this.curElement);
        this.firePropertyChange("add", null, this.curElement);
    }

    private void createElement(Component c, int x, int y) {
        Rectangle r;
        String parent;
        this.removeKeyListeners();
        if (this.drawType <= -1) {
            return;
        }
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        switch (this.drawType) {
            default: {
                this.curElement = new LineElement(this, this.graph, new Point(x, y), this.annoElem, parent);
                break;
            }
            case 1: {
                this.curElement = new ArrowAndTextCompositeElement(this, this.graph, new Point(x, y), this.annoElem, parent, this.textStyle.getFont());
                break;
            }
            case 4: {
                this.curElement = new ArrowLineElement(this, this.graph, new Point(x, y), this.annoElem, parent);
                break;
            }
            case 6: {
                this.curElement = new RectangleElement(this, this.graph, new Point(x, y), this.annoElem, parent);
                break;
            }
            case 5: {
                this.curElement = new EllipseElement(this, this.graph, new Point(x, y), this.annoElem, parent);
                break;
            }
            case 0: {
                this.curElement = new TextElement(this, this.graph, new Point(x, y), this.annoElem, parent);
                this.onText = true;
            }
        }
        if (!(this.curElement instanceof TextElement)) {
            this.curElement.setStyle(this.style);
        }
        this.curElement.setStyle(this.textStyle);
        this.creatingElement = true;
        this.resetListeners(c, 0, 0, false);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        this.updateFormatToolBar();
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.graph.annotateRepaint();
    }

    public boolean isAnnotateElementSelected() {
        return this.curElement != null || this.curGroup != null;
    }

    public boolean isAnnotatePropertyActive() {
        return (this.curElement != null || this.curGroup != null) && this.selectionList.size() < 2;
    }

    public Object getAnnotateElementSelected() {
        if (this.curGroup != null) {
            return this.curGroup;
        }
        return this.curElement;
    }

    public boolean hasAnnotateElements() {
        return this.drawables.size() > 0;
    }

    public void deleteAnnotateElement() {
        if (this.curElement == null) {
            return;
        }
        if (this.curElement.isCaretOn()) {
            this.curElement.setCaretOn(null, false);
        }
        Element ce = this.curElement.getElement();
        this.elemToAnnotate.put(ce, this.curElement);
        if (this.sgActionListener != null) {
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ce));
        }
        if (ce != null && this.annoElem != null && ce.getParentNode() == this.annoElem) {
            this.annoElem.removeChild(ce);
        }
        this.drawables.remove(this.curElement);
        this.firePropertyChange("delete", this.curElement, null);
        this.curElement = null;
        this.graph.annotateRepaint();
    }

    public void copyAnnotateElement() {
        this.buffer = null;
        if (this.curElement != null) {
            this.buffer = this.curElement.getState();
            Element custom = this.curElement.getCustomAttrs();
            this.buffer.appendChild(custom);
        }
    }

    public void copy() {
        this.buffer = null;
        if (this.curElement != null || this.curGroup != null) {
            if (this.selectionList.size() > 1 && (this.selectionList.contains(this.curElement) || this.selectionList.contains(this.curGroup))) {
                this.copySelectList();
            } else if (this.curGroup != null) {
                this.buffer = this.curGroup.getCopy();
            } else {
                this.buffer = this.curElement.getState();
                this.buffer.appendChild(this.curElement.getCustomAttrs());
            }
            this.xoffset = 0;
            this.yoffset = 0;
        }
        this.graph.annotateRepaint();
    }

    void copySelectList() {
        this.buffer = null;
        if (this.selectionList.size() > 0) {
            this.buffer = this.annoElem.getOwnerDocument().createElement("SelectionList");
            for (Object obj : this.selectionList) {
                if (obj instanceof Group) {
                    Group gr = (Group)obj;
                    this.buffer.appendChild(gr.getCopy());
                    continue;
                }
                AnnotateElement ae = (AnnotateElement)obj;
                Element elem = ae.getState();
                elem.appendChild(ae.getCustomAttrs());
                this.buffer.appendChild(elem);
            }
            this.xoffset = 0;
            this.yoffset = 0;
        }
    }

    public void delete() {
        if (this.clearBuffer) {
            this.buffer = null;
        }
        if (this.curElement != null && this.curElement.isCaretOn()) {
            this.curElement.deleteChar(true);
            return;
        }
        if (this.selectionList.size() > 1) {
            Iterator iter = this.selectionList.iterator();
            ArrayList list = new ArrayList();
            while (iter.hasNext()) {
                Object obj = iter.next();
                list.add(obj);
                if (obj instanceof AnnotateElement) {
                    AnnotateElement ae = (AnnotateElement)obj;
                    this.drawables.remove(ae);
                    Element ce = ae.getElement();
                    if (ce == null || this.annoElem == null) continue;
                    if (ce.getParentNode() == this.annoElem) {
                        this.annoElem.removeChild(ce);
                    }
                    this.elemToAnnotate.put(ce, ae);
                    continue;
                }
                Group gr = (Group)obj;
                ArrayList glist = gr.getAllMembers();
                for (int i = 0; i < glist.size(); ++i) {
                    AnnotateElement ae = (AnnotateElement)glist.get(i);
                    this.drawables.remove(ae);
                    Element ce = ae.getElement();
                    if (ce == null || this.annoElem == null) continue;
                    if (ae.elem.getParentNode() == this.annoElem) {
                        this.annoElem.removeChild(ae.elem);
                    }
                    this.elemToAnnotate.put(ce, ae);
                }
                gr.setVisible(false);
            }
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, list));
            }
            this.firePropertyChange("delete", list, null);
        } else if (this.curGroup != null) {
            String value = "pastegroup:" + this.curGroup.id;
            ArrayList list = this.curGroup.getAllMembers();
            for (int i = 0; i < list.size(); ++i) {
                AnnotateElement ae = (AnnotateElement)list.get(i);
                this.drawables.remove(ae);
                Element ce = ae.getElement();
                if (ce == null || this.annoElem == null) continue;
                if (ae.elem.getParentNode() == this.annoElem) {
                    this.annoElem.removeChild(ae.elem);
                }
                this.elemToAnnotate.put(ce, ae);
            }
            this.curGroup.setVisible(false);
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, value));
            }
            this.firePropertyChange("delete", this.curGroup, null);
            this.curGroup = null;
        } else if (this.curElement != null) {
            Element ce = this.curElement.getElement();
            this.elemToAnnotate.put(ce, this.curElement);
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, ce));
            }
            if (ce != null && this.annoElem != null && ce.getParentNode() == this.annoElem) {
                this.annoElem.removeChild(ce);
            }
            this.drawables.remove(this.curElement);
            this.firePropertyChange("delete", this.curElement, null);
        }
        this.xoffset = 0;
        this.yoffset = 0;
        this.curElement = null;
        this.curGroup = null;
        this._resetSelectionList();
        this.graph.annotateRepaint();
        this.fireChangeEvent();
    }

    public void cut() {
        this.copy();
        this.clearBuffer = false;
        this.delete();
        this.clearBuffer = true;
        this.graph.annotateRepaint();
    }

    void cutSelecionList() {
        this.buffer = null;
        if (this.selectionList.size() > 0) {
            this.buffer = this.annoElem.getOwnerDocument().createElement("SelectionList");
            Element undobuffer = this.annoElem.getOwnerDocument().createElement("SelectionList");
            for (AnnotateElement ae : this.selectionList) {
                this.buffer.appendChild(ae.getState());
                Element ce = ae.getElement();
                undobuffer.appendChild(ce);
                this.elemToAnnotate.put(ce, ae);
                if (ce != null && ce.getParentNode() != null) {
                    Node pelem = ce.getParentNode();
                    pelem.removeChild(ce);
                }
                this.drawables.remove(ae);
            }
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, undobuffer));
            }
            this.firePropertyChange("delete", new ArrayList(this.selectionList), null);
        }
        this.xoffset = 0;
        this.yoffset = 0;
        this.curElement = null;
        this._resetSelectionList();
        this.graph.annotateRepaint();
    }

    public void pasteAnnotateElement() {
        if (this.buffer == null) {
            return;
        }
        if (this.curElement != null) {
            this.isDeletedOnDisable(this.curElement);
        }
        this.copying = true;
        this.annoElem.appendChild(this.buffer);
        this.curElement = AnnotateParser.loadAElement(this, this.graph, this.buffer, false);
        this.xoffset += 10;
        Rectangle bounds = this.curElement.shape.getBounds();
        if ((double)this.xoffset + bounds.getWidth() + bounds.getX() > (double)this.graph.getAnnotationSize().width) {
            this.xoffset = 0;
            this.yoffset += 10;
        }
        this.curElement.finishMove(10, this.xoffset, this.yoffset);
        if (this.buffer.hasAttribute("group")) {
            this.buffer.removeAttribute("group");
        }
        this.removeKeyListeners();
        this.elemToAnnotate.put(this.buffer, this.curElement);
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, this.buffer));
        }
        this.curElement.addPropertyChangeListener(this);
        this.graph.annotateRepaint();
        this.buffer = this.curElement.getState();
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.firePropertyChange("add", null, this.curElement);
    }

    public void paste() {
        int i;
        if (this.buffer == null) {
            return;
        }
        if (this.curElement != null) {
            this.isDeletedOnDisable(this.curElement);
        }
        this.copying = true;
        this.removeKeyListeners();
        this._resetSelectionList();
        String tag = this.buffer.getTagName();
        if (tag.equals("Group")) {
            String id = this.nameGenerator.get("Group");
            this.curGroup = new Group(this, id);
            this.curGroup.addPropertyChangeListener(this);
            this.groups.put(id, this.curGroup);
            boolean offsetSet = false;
            ArrayList<Element> newnodes = new ArrayList<Element>();
            for (Node node = this.buffer.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                Element ce = (Element)node;
                ce.setAttribute("group", id);
                boolean anchorAttachedToData = true;
                if (ce.hasAttribute("AnchorAttachedToData")) {
                    anchorAttachedToData = "true".equalsIgnoreCase(this.buffer.getAttribute("AnchorAttachedToData"));
                }
                if (ce.hasAttribute("Parent")) {
                    if (anchorAttachedToData) {
                        String pp = ce.getAttribute("Parent");
                        double x = Double.parseDouble(ce.getAttribute("AnchorX"));
                        double y = Double.parseDouble(ce.getAttribute("AnchorY"));
                        Point2D p = ((Annotatable)this.graph).convertDataToScreen(pp, new Double[]{new Double(x), new Double(y)});
                        ce.setAttribute("SAnchorX", Double.toString(p.getX()));
                        ce.setAttribute("SAnchorY", Double.toString(p.getY()));
                    }
                    ce.removeAttribute("Parent");
                }
                boolean secondaryAttachedToData = true;
                if (ce.hasAttribute("SecondaryAttachedToData")) {
                    secondaryAttachedToData = "true".equalsIgnoreCase(this.buffer.getAttribute("SecondaryAttachedToData"));
                }
                if (ce.hasAttribute("SecondaryParent")) {
                    if (secondaryAttachedToData) {
                        String pp = ce.getAttribute("SecondaryParent");
                        double x = Double.parseDouble(ce.getAttribute("SecondaryX"));
                        double y = Double.parseDouble(ce.getAttribute("SecondaryY"));
                        Point2D p = ((Annotatable)this.graph).convertDataToScreen(pp, new Double[]{new Double(x), new Double(y)});
                        ce.setAttribute("SSecondaryX", Double.toString(p.getX()));
                        ce.setAttribute("SSecondaryY", Double.toString(p.getY()));
                    }
                    ce.removeAttribute("SecondaryParent");
                }
                this.curElement = AnnotateParser.loadAElement(this, this.graph, ce, false);
                if (!offsetSet) {
                    offsetSet = true;
                    this.xoffset += 10;
                    Rectangle bounds = this.curElement.shape.getBounds();
                    if ((double)this.xoffset + bounds.getWidth() + bounds.getX() > (double)this.graph.getAnnotationSize().width) {
                        this.xoffset = 0;
                        this.yoffset += 10;
                    }
                }
                this.curElement.move(10, this.xoffset, this.yoffset);
                newnodes.add(ce);
                this.elemToAnnotate.put(ce, this.curElement);
                this.curElement.addPropertyChangeListener(this);
            }
            for (AnnotateElement ae : this.curGroup.getAllMembers()) {
                this.annoElem.appendChild(ae.getElement());
            }
            this.curGroup.resetBounds();
            if (this.sgActionListener != null) {
                this.curGroup.addActionListener(this.sgActionListener);
                this.sgActionListener.actionPerformed(new SGActionEvent(this, "cutgroup:" + this.curGroup.getID()));
            }
            this.firePropertyChange("add", null, this.curGroup);
        } else if (tag.equals("SelectionList")) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node node = this.buffer.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                nodes.add(node);
            }
            AnnotateList list = new AnnotateList();
            boolean offsetSet = false;
            for (int i2 = 0; i2 < nodes.size(); ++i2) {
                Element ce = (Element)nodes.get(i2);
                Object obj = this._pasteASelectElement(ce);
                if (!offsetSet) {
                    Rectangle bounds;
                    offsetSet = true;
                    this.xoffset += 10;
                    Rectangle rectangle = bounds = obj instanceof AnnotateElement ? ((AnnotateElement)obj).shape.getBounds() : ((AnnotateElement)((Group)obj).getAllMembers().get((int)0)).shape.getBounds();
                    if ((double)this.xoffset + bounds.getWidth() + bounds.getX() > (double)this.graph.getAnnotationSize().width) {
                        this.xoffset = 0;
                        this.yoffset += 10;
                    }
                }
                if (obj instanceof AnnotateElement) {
                    AnnotateElement ae = (AnnotateElement)obj;
                    ae.removePropertyChangeListener(this);
                    ae.move(10, this.xoffset, this.yoffset);
                    ae.addPropertyChangeListener(this);
                } else {
                    Group gr = (Group)obj;
                    ArrayList al = gr.getAllMembers();
                    for (int j = 0; j < al.size(); ++j) {
                        AnnotateElement ae = (AnnotateElement)al.get(j);
                        ae.removePropertyChangeListener(this);
                        ae.move(10, this.xoffset, this.yoffset);
                        ae.addPropertyChangeListener(this);
                    }
                    gr.removePropertyChangeListener(this);
                    gr.resetBounds();
                    gr.addPropertyChangeListener(this);
                }
                list.add(obj);
                this.selectionList.add(obj);
            }
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, list));
            }
            this.firePropertyChange("add", null, list);
        } else {
            this.annoElem.appendChild(this.buffer);
            if (this.buffer.hasAttribute("group")) {
                this.buffer.removeAttribute("group");
            }
            boolean anchorAttachedToData = true;
            if (this.buffer.hasAttribute("AnchorAttachedToData")) {
                anchorAttachedToData = "true".equalsIgnoreCase(this.buffer.getAttribute("AnchorAttachedToData"));
            }
            if (this.buffer.hasAttribute("Parent") && this.buffer.getAttribute("Parent").length() > 0) {
                if (anchorAttachedToData) {
                    String pp = this.buffer.getAttribute("Parent");
                    double x = Double.parseDouble(this.buffer.getAttribute("AnchorX"));
                    double y = Double.parseDouble(this.buffer.getAttribute("AnchorY"));
                    Point2D p = ((Annotatable)this.graph).convertDataToScreen(pp, new Double[]{new Double(x), new Double(y)});
                    this.buffer.setAttribute("SAnchorX", Double.toString(p.getX()));
                    this.buffer.setAttribute("SAnchorY", Double.toString(p.getY()));
                }
                this.buffer.removeAttribute("Parent");
            }
            boolean secondaryAttachedToData = true;
            if (this.buffer.hasAttribute("SecondaryAttachedToData")) {
                secondaryAttachedToData = "true".equalsIgnoreCase(this.buffer.getAttribute("SecondaryAttachedToData"));
            }
            if (this.buffer.hasAttribute("SecondaryParent") && this.buffer.getAttribute("SecondaryParent").length() > 0) {
                if (secondaryAttachedToData) {
                    String pp = this.buffer.getAttribute("SecondaryParent");
                    double x = Double.parseDouble(this.buffer.getAttribute("SecondaryX"));
                    double y = Double.parseDouble(this.buffer.getAttribute("SecondaryY"));
                    Point2D p = ((Annotatable)this.graph).convertDataToScreen(pp, new Double[]{new Double(x), new Double(y)});
                    this.buffer.setAttribute("SSecondaryX", Double.toString(p.getX()));
                    this.buffer.setAttribute("SSecondaryY", Double.toString(p.getY()));
                }
                this.buffer.removeAttribute("SecondaryParent");
            }
            this.curElement = AnnotateParser.loadAElement(this, this.graph, this.buffer, false);
            this.xoffset += 10;
            Rectangle bounds = this.curElement.shape.getBounds();
            if ((double)this.xoffset + bounds.getWidth() + bounds.getX() > (double)this.graph.getAnnotationSize().width) {
                this.xoffset = 0;
                this.yoffset += 10;
            }
            this.curElement.addPropertyChangeListener(this);
            this.curElement.move(10, this.xoffset, this.yoffset);
            this.curElement.removePropertyChangeListener(this);
            this.elemToAnnotate.put(this.buffer, this.curElement);
            if (this.sgActionListener != null) {
                this.curElement.addActionListener(this.sgActionListener);
                this.sgActionListener.actionPerformed(new SGActionEvent(this, this.buffer));
            }
            this.curElement.addPropertyChangeListener(this);
            this.selectionList.add(this.curElement);
        }
        ArrayList list = new ArrayList();
        if (this.selectionList.size() > 1) {
            for (i = 0; i < this.selectionList.size(); ++i) {
                list.add(this.selectionList.get(i));
            }
        } else if (this.curGroup != null) {
            list.add(this.curGroup);
        } else {
            list.add(this.curElement);
        }
        if (this.graph instanceof Annotatable) {
            this.setElementParent(list);
        }
        if (list.size() > 1) {
            for (i = 0; i < list.size(); ++i) {
                this.selectionList.add(list.get(i));
            }
            Object obj = this.selectionList.get(0);
            this.curElement = obj instanceof AnnotateElement ? (AnnotateElement)obj : (AnnotateElement)((Group)obj).getAllMembers().get(0);
        } else if (list.get(0) instanceof Group) {
            this.curGroup = (Group)list.get(0);
        } else {
            this.curElement = (AnnotateElement)list.get(0);
        }
        this.copy();
        this.copying = false;
        this.updateFormatToolBar();
        this.graph.annotateRepaint();
        this.fireChangeEvent();
    }

    private Object _pasteASelectElement(Element ee) {
        String tag = ee.getTagName();
        if (tag.equals("Group")) {
            String id = this.nameGenerator.get("Group");
            this.curGroup = new Group(this, id);
            this.curGroup.addPropertyChangeListener(this);
            this.groups.put(id, this.curGroup);
            ArrayList<Element> newnodes = new ArrayList<Element>();
            for (Node node = ee.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                Element ce = (Element)node;
                ce.setAttribute("group", id);
                if (ce.hasAttribute("Parent")) {
                    ce.removeAttribute("Parent");
                }
                if (ce.hasAttribute("SecondaryParent")) {
                    ce.removeAttribute("SecondaryParent");
                }
                if (ce.hasAttribute("AnchorAttachedToData") && "true".equalsIgnoreCase(ce.getAttribute("AnchorAttachedToData"))) {
                    ce.removeAttribute("AnchorAttachedToData");
                }
                boolean secondaryAttachedToData = true;
                if (ce.hasAttribute("SecondaryAttachedToData")) {
                    if ("true".equalsIgnoreCase(ce.getAttribute("SecondaryAttachedToData"))) {
                        ce.removeAttribute("SecondaryAttachedToData");
                    } else {
                        secondaryAttachedToData = false;
                    }
                }
                this.curElement = AnnotateParser.loadAElement(this, this.graph, ce, false);
                if (secondaryAttachedToData) {
                    ce.removeAttribute("SecondaryAttachedToData");
                }
                newnodes.add(ce);
                this.elemToAnnotate.put(ce, this.curElement);
                this.curElement.addPropertyChangeListener(this);
            }
            for (AnnotateElement ae : this.curGroup.getAllMembers()) {
                this.annoElem.appendChild(ae.getElement());
            }
            this.firePropertyChange("add", null, this.curGroup);
            return this.curGroup;
        }
        if (ee.hasAttribute("group")) {
            ee.removeAttribute("group");
        }
        if (ee.hasAttribute("Parent")) {
            ee.removeAttribute("Parent");
        }
        if (ee.hasAttribute("SecondaryParent")) {
            ee.removeAttribute("SecondaryParent");
        }
        if (ee.hasAttribute("AnchorAttachedToData") && "true".equalsIgnoreCase(ee.getAttribute("AnchorAttachedToData"))) {
            ee.removeAttribute("AnchorAttachedToData");
        }
        boolean secondaryAttachedToData = true;
        if (ee.hasAttribute("SecondaryAttachedToData")) {
            if ("true".equalsIgnoreCase(ee.getAttribute("SecondaryAttachedToData"))) {
                ee.removeAttribute("SecondaryAttachedToData");
            } else {
                secondaryAttachedToData = false;
            }
        }
        this.curElement = AnnotateParser.loadAElement(this, this.graph, ee, false);
        if (secondaryAttachedToData) {
            ee.removeAttribute("SecondaryAttachedToData");
        }
        this.elemToAnnotate.put(ee, this.curElement);
        this.curElement.addPropertyChangeListener(this);
        this.annoElem.appendChild(this.curElement.getElement());
        return this.curElement;
    }

    public void deleteAllAnnotateElements() {
        if (this.annoElem != null) {
            for (int i = 0; i < this.drawables.size(); ++i) {
                AnnotateElement ae = (AnnotateElement)this.drawables.get(i);
                Element child = ae.getElement();
                this.elemToAnnotate.put(child, ae);
                if (child == null || child.getParentNode() != this.annoElem) continue;
                this.annoElem.removeChild(child);
            }
        }
        ArrayList list = new ArrayList(this.drawables);
        this.drawables.removeAllElements();
        this.curElement = null;
        this.graph.annotateRepaint();
        this.firePropertyChange("delete", list, null);
    }

    public void unSelectAll() {
        if (this.curElement == null) {
            return;
        }
        if (this.curElement != null) {
            this.isDeletedOnDisable(this.curElement);
            this.curElement = null;
            this._resetSelectionList();
            this.curGroup = null;
        }
        this.graph.annotateRepaint();
    }

    public boolean isAnnotateElementAt(int x, int y) {
        boolean contains = false;
        for (int i = 0; i < this.drawables.size(); ++i) {
            if (!((AnnotateElement)this.drawables.get(i)).isSelected(x, y)) continue;
            contains = true;
            break;
        }
        for (Group obj : this.groups.values()) {
            if (!obj.isVisible() || !obj.contains(x, y)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public Object getAnnotateElementAt(int x, int y) {
        for (Group obj : this.groups.values()) {
            if (!obj.isVisible() || !obj.contains(x, y)) continue;
            return obj;
        }
        for (int i = 0; i < this.drawables.size(); ++i) {
            if (!((AnnotateElement)this.drawables.get(i)).isSelected(x, y)) continue;
            return this.drawables.get(i);
        }
        return null;
    }

    public int getAlignment() {
        if (this.curElement != null && this.curElement instanceof AlignInterface) {
            return ((AlignInterface)((Object)this.curElement)).getAlignment();
        }
        return -1;
    }

    public void setAlignment(int align) {
        if (this.curElement != null && this.curElement instanceof AlignInterface) {
            ((AlignInterface)((Object)this.curElement)).setAlignment(align);
            if (this.onText) {
                this.curElement.requestFocus();
            }
        }
    }

    public void setDirty() {
        this.dirty = true;
    }

    private void doPopupMenu(MouseEvent e) {
        JPopupMenu popup;
        JMenu menu;
        this.popupx = e.getX();
        this.popupy = e.getY();
        this.popupComponent = e.getComponent();
        int x = e.getX();
        int y = e.getY();
        if (this.drawType == -1) {
            int i;
            AnnotateElement se = this.curElement;
            boolean found = false;
            for (i = 0; i < this.selectionList.size() && !found; ++i) {
                Object obj = this.selectionList.get(i);
                found = obj instanceof Group ? ((Group)obj).contains(this.prevx, this.prevy) : ((AnnotateElement)obj).isSelected(this.prevx, this.prevy);
                if (!found || this.curElement != null) continue;
                if (obj instanceof Group) {
                    this.curGroup = (Group)obj;
                    this.curElement = (AnnotateElement)this.curGroup.getAllMembers().get(0);
                    continue;
                }
                this.curElement = (AnnotateElement)obj;
            }
            if (!found) {
                this.curElement = null;
                this.curGroup = null;
                for (i = this.drawables.size() - 1; i >= 0; --i) {
                    if (!((AnnotateElement)this.drawables.get(i)).isSelected(this.prevx, this.prevy)) continue;
                    this.curElement = (AnnotateElement)this.drawables.get(i);
                    break;
                }
                if (this.curElement != null) {
                    String gid = this.curElement.getGroup();
                    this.curGroup = this.getGroup(gid);
                }
                this._resetSelectionList();
                if (this.curGroup == null) {
                    this.selectionList.add(this.curElement);
                } else {
                    this.selectionList.add(this.curGroup);
                }
            }
            if (se != this.curElement) {
                this.resetListeners(this.popupComponent, x, y, !e.isControlDown() && this.curGroup == null);
                this.graph.annotateRepaint();
            }
        }
        Point2D screen = new Point2D.Double(x, y);
        Component component = e.getComponent();
        Graphics2D g2 = (Graphics2D)component.getGraphics();
        AffineTransform at = g2.getTransform();
        screen = at.deltaTransform(screen, screen);
        if (this.curElement == null && this.curGroup == null) {
            if (this.insertPopupOn) {
                if (this.insertPM == null) {
                    this.createInsertPopupMenu();
                }
                this.insertPM.show(e.getComponent(), (int)screen.getX(), (int)screen.getY());
            }
            return;
        }
        e.consume();
        if (this.curGroup != null || this.selectionList.size() > 1) {
            if (this.groupPM == null) {
                this.createGroupPopupMenu();
            }
            menu = (JMenu)Annotate.getItem(this.groupPM, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "grouping.txt")));
            JMenuItem mi = Annotate.getItem(menu, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "group.txt")));
            boolean canGroup = this.curGroup == null && this.selectionList.size() > 1;
            for (int i = 0; canGroup && i < this.selectionList.size(); ++i) {
                Object obj = this.selectionList.get(i);
                if (!(obj instanceof Group)) continue;
                canGroup = false;
            }
            mi.setEnabled(canGroup);
            mi = Annotate.getItem(menu, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "ungroup.txt")));
            mi.setEnabled(this.curGroup != null && this.selectionList.size() <= 1);
            mi = Annotate.getItem(this.groupPM, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "groupProperties.txt")));
            if (this.curGroup != null && this.selectionList.size() == 1) {
                if (mi == null) {
                    String label = RB.getStringResource(RB_KEY, "groupProperties.txt");
                    mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
                    mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
                    mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Annotate.this.askAndSaveGroupAttrs();
                        }
                    });
                    if (this.globalMenuItems != null) {
                        int count = this.globalMenuItems.size();
                        int size = this.groupPM.getComponentCount() - 1;
                        Stack<Component> stack = new Stack<Component>();
                        for (int i = 0; i < count; ++i) {
                            stack.push(this.groupPM.getComponent(size - i));
                        }
                        this.groupPM.add(mi);
                        this.groupPM.addSeparator();
                        while (!stack.empty()) {
                            this.groupPM.add((Component)stack.pop());
                        }
                    } else {
                        this.groupPM.addSeparator();
                        this.groupPM.add(mi);
                    }
                }
            } else if (mi != null) {
                int index = this.groupPM.getComponentIndex(mi);
                this.groupPM.remove(index);
                this.groupPM.remove(index - 1);
            }
            popup = this.groupPM;
        } else {
            if (this.curElement instanceof TextElement) {
                if (this.textPM == null) {
                    this.createTextPopupMenu();
                }
                popup = this.textPM;
            } else {
                if (this.shapePM == null) {
                    this.createShapePopupMenu();
                }
                popup = this.shapePM;
            }
            menu = (JMenu)Annotate.getItem(popup, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "order.txt")));
            menu.setEnabled(this.drawables.size() > 1);
            JMenuItem mi = Annotate.getItem(menu, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "btFront.txt")));
            mi.setEnabled(this.canMoveForward());
            mi = Annotate.getItem(menu, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "stBack.txt")));
            mi.setEnabled(this.canMoveBackward());
            mi = Annotate.getItem(menu, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "bForward.txt")));
            mi.setEnabled(this.canMoveForward());
            mi = Annotate.getItem(menu, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "sBackward.txt")));
            mi.setEnabled(this.canMoveBackward());
            mi = Annotate.getItem(popup, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "font.txt")));
            mi.setEnabled(this.curElement.isFormattingEnabled());
        }
        JMenuItem mi = Annotate.getItem(popup, Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "paste.txt")));
        mi.setEnabled(this.buffer != null);
        popup.show(e.getComponent(), (int)screen.getX(), (int)screen.getY());
    }

    private void createShapePopupMenu() {
        this.shapePM = new JPopupMenu();
        this.addCCPtoMenu(this.shapePM);
        this.shapePM.addSeparator();
        String label = RB.getStringResource(RB_KEY, "addEditText.txt");
        JMenuItem mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.insertText(Annotate.this.popupComponent);
                Annotate.this.graph.annotateRepaint();
            }
        });
        this.shapePM.add(mi);
        label = RB.getStringResource(RB_KEY, "font.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.askAndSaveFontAttrs();
            }
        });
        this.shapePM.add(mi);
        this.addGOtoMenu(this.shapePM);
        this.shapePM.addSeparator();
        label = RB.getStringResource(RB_KEY, "annotationProperties.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.askAndSaveAnnoAttrs();
            }
        });
        this.shapePM.add(mi);
        this.addGlobalMenu(this.shapePM);
    }

    private void createInsertPopupMenu() {
        this.insertPM = new JPopupMenu();
        String label = RB.getStringResource(RB_KEY, "text.txt");
        JMenuItem mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.drawType = 0;
            }
        });
        this.insertPM.add(mi);
        label = RB.getStringResource(RB_KEY, "arrowText.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.drawType = 1;
            }
        });
        this.insertPM.add(mi);
        label = RB.getStringResource(RB_KEY, "line.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.drawType = 2;
            }
        });
        this.insertPM.add(mi);
        label = RB.getStringResource(RB_KEY, "ellipse.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.drawType = 5;
            }
        });
        this.insertPM.add(mi);
        label = RB.getStringResource(RB_KEY, "rect.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.drawType = 6;
            }
        });
        this.insertPM.add(mi);
        label = RB.getStringResource(RB_KEY, "image.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.curElement = Annotate.this._addImage(Annotate.this.popupx, Annotate.this.popupy);
            }
        });
        this.insertPM.add(mi);
    }

    private void createGroupPopupMenu() {
        this.groupPM = new JPopupMenu();
        this.addCCPtoMenu(this.groupPM);
        this.addGOtoMenu(this.groupPM);
        this.addGlobalMenu(this.groupPM);
    }

    private void addGlobalMenu(JPopupMenu pm) {
        if (this.globalMenuItems != null) {
            pm.addSeparator();
            for (int i = 0; i < this.globalMenuItems.size(); ++i) {
                JMenuItem mi = (JMenuItem)this.globalMenuItems.get(i);
                JMenuItem ci = new JMenuItem(mi.getText());
                ci.setMnemonic(mi.getMnemonic());
                ci.setDisplayedMnemonicIndex(mi.getDisplayedMnemonicIndex());
                ActionListener[] ll = mi.getActionListeners();
                for (int j = 0; j < ll.length; ++j) {
                    ci.addActionListener(ll[j]);
                }
                ci.setActionCommand(mi.getActionCommand());
                pm.add(ci);
            }
        }
    }

    private void addCCPtoMenu(JPopupMenu pm) {
        String label = RB.getStringResource(RB_KEY, "cut.txt");
        JMenuItem mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.cut();
            }
        });
        mi.setActionCommand("cut");
        pm.add(mi);
        label = RB.getStringResource(RB_KEY, "copy.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.copy();
            }
        });
        mi.setActionCommand("copy");
        pm.add(mi);
        label = RB.getStringResource(RB_KEY, "paste.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.paste();
            }
        });
        mi.setActionCommand("paste");
        pm.add(mi);
    }

    public void group() {
        if (this.curGroup == null) {
            this.curGroup = this.getGroup(null);
        }
        this.curGroup.removeActionListener(this.sgActionListener);
        this.disablePropertyEvents();
        for (AnnotateElement ae : this.selectionList) {
            ae.removeActionListener(this.sgActionListener);
            this.curGroup.add(ae);
        }
        this._resetSelectionList();
        this.graph.annotateRepaint();
        if (this.sgActionListener != null) {
            this.curGroup.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, "ungroup:" + this.curGroup.getID()));
        }
        this.enablePropertyEvents();
        this.updateFormatToolBar();
    }

    public boolean canGroup() {
        boolean canGroup = this.curGroup == null && this.selectionList.size() > 1;
        for (int i = 0; canGroup && i < this.selectionList.size(); ++i) {
            Object obj = this.selectionList.get(i);
            if (!(obj instanceof Group)) continue;
            canGroup = false;
        }
        return canGroup;
    }

    public boolean canUnGroup() {
        return this.curGroup != null && this.selectionList.size() <= 1;
    }

    public boolean canOrder() {
        return this.curElement != null && this.curGroup == null && this.selectionList.size() <= 1 && this.drawables.size() > 1;
    }

    public boolean canMoveForward() {
        if (this.curElement != null && this.curGroup == null && this.selectionList.size() <= 1 && this.drawables.size() > 1) {
            return this.drawables.indexOf(this.curElement) < this.drawables.size() - 1;
        }
        return false;
    }

    public boolean canMoveBackward() {
        if (this.curElement != null && this.curGroup == null && this.selectionList.size() <= 1 && this.drawables.size() > 1) {
            return this.drawables.indexOf(this.curElement) > 0;
        }
        return false;
    }

    public boolean canGrouping() {
        return (this.selectionList.size() > 1 || this.curGroup != null) && this.drawables.size() > 1;
    }

    public void ungroup() {
        ArrayList list = this.curGroup.removeAll();
        String id = this.curGroup.getID();
        this._resetSelectionList();
        this.selectionList.addAll(list);
        this.ungroups.put(id, list);
        this.curGroup = null;
        if (this.sgActionListener != null) {
            this.sgActionListener.actionPerformed(new SGActionEvent(this.getAnnotation(), "group:" + id));
        }
        this.updateFormatToolBar();
        this.graph.annotateRepaint();
    }

    public void align(int dir) {
        this.selectionList.align(dir);
        this.graph.annotateRepaint();
    }

    public boolean canAlign() {
        return this.selectionList.size() > 1;
    }

    public void alignTails(int dir) {
        this.selectionList.alignTails(dir);
        this.graph.annotateRepaint();
    }

    public boolean canAlignArrows() {
        int arrowcount = 0;
        for (int i = 0; i < this.selectionList.size(); ++i) {
            if (!(this.selectionList.get(i) instanceof ArrowLineElement)) continue;
            ++arrowcount;
        }
        return arrowcount > 1;
    }

    public void alignHeads(int dir) {
        this.selectionList.alignHeads(dir);
        this.graph.annotateRepaint();
    }

    private void addGOtoMenu(JPopupMenu pm) {
        pm.addSeparator();
        String label = RB.getStringResource(RB_KEY, "grouping.txt");
        JMenu menu = new JMenu(Util.getLabelWithoutMnemonic((String)label));
        menu.setMnemonic(Util.getDisplayedMnemonic((String)label));
        menu.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        menu.setEnabled(pm == this.groupPM);
        pm.add(menu);
        label = RB.getStringResource(RB_KEY, "group.txt");
        JMenuItem mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.setEnabled(false);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.group();
            }
        });
        menu.add(mi);
        label = RB.getStringResource(RB_KEY, "ungroup.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.setEnabled(false);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.ungroup();
            }
        });
        menu.add(mi);
        label = RB.getStringResource(RB_KEY, "order.txt");
        menu = new JMenu(Util.getLabelWithoutMnemonic((String)label));
        menu.setMnemonic(Util.getDisplayedMnemonic((String)label));
        menu.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        menu.setEnabled(pm != this.groupPM);
        pm.add(menu);
        label = RB.getStringResource(RB_KEY, "btFront.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.moveToFront();
            }
        });
        menu.add(mi);
        label = RB.getStringResource(RB_KEY, "stBack.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.moveToBack();
            }
        });
        menu.add(mi);
        label = RB.getStringResource(RB_KEY, "bForward.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.moveForward();
            }
        });
        menu.add(mi);
        label = RB.getStringResource(RB_KEY, "sBackward.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.moveBackward();
            }
        });
        menu.add(mi);
    }

    private void insertText(Component component) {
        if (this.curElement == null || this.selectionList.size() > 1) {
            return;
        }
        this.moveType = -1;
        component.setCursor(Cursor.getPredefinedCursor(2));
        if (this.curElement.getText() == null) {
            this.curElement.insertText(component);
        } else {
            this.curElement.setCaretOn(component, true);
        }
        this.onText = true;
    }

    private void createTextPopupMenu() {
        this.textPM = new JPopupMenu();
        this.addCCPtoMenu(this.textPM);
        this.textPM.addSeparator();
        String label = RB.getStringResource(RB_KEY, "font.txt");
        JMenuItem mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.askAndSaveFontAttrs();
            }
        });
        this.textPM.add(mi);
        this.addGOtoMenu(this.textPM);
        this.textPM.addSeparator();
        label = RB.getStringResource(RB_KEY, "annotationProperties.txt");
        mi = new JMenuItem(Util.getLabelWithoutMnemonic((String)label));
        mi.setMnemonic(Util.getDisplayedMnemonic((String)label));
        mi.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)label));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Annotate.this.askAndSaveAnnoAttrs();
            }
        });
        this.textPM.add(mi);
        this.addGlobalMenu(this.textPM);
    }

    void askAndSaveFontAttrs() {
        Container frame;
        Container container = frame = this.container instanceof Container ? this.container : this.container.getParent();
        while (frame != null && !(frame instanceof JFrame)) {
            frame = frame.getParent();
        }
        JFrame parent = frame != null ? (JFrame)frame : null;
        this.lastAction = this.sgActionListener != null ? this.sgActionListener.getLastAction() : null;
        SimpleTextCustomizerPanel panel = new SimpleTextCustomizerPanel(this.curElement, this.colorGrabber);
        int result = SGDialog.showInputDialog(parent, RB.getStringResource(RB_KEY, "fontChooser.txt"), panel);
        if (result == -1) {
            this.savedPanel = panel;
            this.savedTitle = RB.getStringResource(RB_KEY, "fontChooser.txt");
            this.colorGrabber.addActionListener(this);
            this.colorGrabber.setLastListener(this);
            return;
        }
        if (result != 0) {
            if (this.lastAction != null) {
                this.sgActionListener.undoAndDiscardActionsUpto(this.lastAction);
            }
        } else {
            this.updateFormatToolBar();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Object source = pce.getSource();
        if (source instanceof AnnotateList) {
            this.curGroup = null;
            this.selectionList = (AnnotateList)source;
            Object obj = this.selectionList.get(0);
            if (obj instanceof AnnotateElement) {
                this.curElement = (AnnotateElement)obj;
            } else {
                this.curGroup = (Group)obj;
                this.curElement = (AnnotateElement)this.curGroup.getAllMembers().get(0);
            }
        } else if (source instanceof Group) {
            this.curGroup = (Group)source;
            this._resetSelectionList();
            this.curElement = null;
        } else if (source instanceof AnnotateElement) {
            String text;
            String name = pce.getPropertyName();
            this.curGroup = null;
            this._resetSelectionList();
            AnnotateElement ae = (AnnotateElement)source;
            if ("undo".equals(name)) {
                this.curElement = ae;
            } else if ("add".equals(name)) {
                if (this.drawables.indexOf(ae) == -1) {
                    this.drawables.add(ae);
                }
                this.curElement = ae;
            } else if ("delete".equals(name)) {
                if (this.drawables.indexOf(ae) != -1) {
                    Element celem = ae.elem;
                    if (celem != null && celem.getParentNode() != null) {
                        Node pelem = celem.getParentNode();
                        pelem.removeChild(celem);
                    }
                    this.drawables.remove(ae);
                }
                this.curElement = null;
            } else if ("caretOn".equals(name) && source instanceof TextElement && ((text = ((AnnotateElement)source).getText()) == null || text.length() == 0)) {
                if (this.drawables.indexOf(ae) != -1) {
                    Element celem = ae.elem;
                    if (celem != null && celem.getParentNode() != null) {
                        Node pelem = celem.getParentNode();
                        pelem.removeChild(celem);
                    }
                    this.drawables.remove(ae);
                }
                this.curElement = null;
            }
        }
        if (this.curElement != null) {
            this.curGroup = this.getGroup(this.curElement.getGroup());
        }
        this.fireChangeEvent();
        if (!this.eventsEnabled) {
            return;
        }
        if (this.selectionList.size() <= 1 && (this.curGroup != null || this.curElement != null && this.curElement.isFormattingEnabled())) {
            this.updateFormatToolBar();
        } else {
            this.disableFormatToolBar();
        }
        this.graph.annotateRepaint();
    }

    public FileOutputStream save(FileOutputStream fos) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.dom);
            StreamResult result = fos == null ? new StreamResult(System.out) : new StreamResult(fos);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        return fos;
    }

    public void addImage(JFileChooser fc, Point pos, String parent) {
        this.addImage(fc, pos);
    }

    public void addImage(JFileChooser fc, Point pos) {
        if (fc == null) {
            fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            fc.setMultiSelectionEnabled(false);
            fc.setAcceptAllFileFilterUsed(false);
        }
        if (this.lastPath != null) {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        fc.resetChoosableFileFilters();
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(filter);
        fc.setDialogTitle(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "image.txt")));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            Rectangle r;
            String parent;
            File file = fc.getSelectedFile();
            String imagepath = file.getAbsolutePath();
            this.imageFileList.add(imagepath);
            this.drawType = -1;
            this.curElement = null;
            this.imageFileList.add(imagepath);
            int x = (int)pos.getX();
            int y = (int)pos.getY();
            String string = parent = this.imageAttachToDataEnabled && this.graph instanceof Annotatable && x > 0 && y > 0 ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
            if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
                parent = null;
            }
            ImageElement ie = new ImageElement(this, this.graph, pos, this.annoElem, parent, imagepath);
            ie.finish();
            this.drawables.add(ie);
            this.graph.annotateRepaint();
            ie.addPropertyChangeListener(this);
            Element ae = ie.getElement();
            this.elemToAnnotate.put(ae, ie);
            if (this.sgActionListener != null) {
                ie.addActionListener(this.sgActionListener);
                this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
            }
            this.lastPath = this.imagePath;
            this.firePropertyChange("add", null, ie);
        }
    }

    public void addMarker(int x, int y) {
        this._addMarker(x, y);
    }

    private AnnotateElement _addMarker(int x, int y) {
        Rectangle r;
        String parent;
        this.drawType = -1;
        if (this.select != null) {
            this.select.setSelected(true);
        }
        this.curElement = null;
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        MarkerElement me = new MarkerElement(this, this.graph, new Point(x, y), this.annoElem, parent, this.markerStyle);
        me.setStyle(this.textStyle);
        me.finish();
        this.drawables.add(me);
        this.graph.annotateRepaint();
        me.addPropertyChangeListener(this);
        Element ae = me.getElement();
        this.elemToAnnotate.put(ae, me);
        if (this.sgActionListener != null) {
            me.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.firePropertyChange("add", null, me);
        return me;
    }

    public void addImage() {
        AnnotateElement ae = this._addImage(-1, -1);
        if (ae != null && ae.isAnchorAttachedToData() && !this.imageAttachToDataEnabled) {
            this.curElement = ae;
            this.curElement.setClipOutsideDataOn(false);
            this.curElement.setAnchorAttachedToData(false);
        }
    }

    public void addImage(int x, int y) {
        this._addImage(x, y);
    }

    private AnnotateElement _addImage(int x, int y) {
        this.drawType = -1;
        if (this.select != null) {
            this.select.setSelected(true);
        }
        if (this.imagePath == null) {
            this.imagePath = this.getImagePath();
        }
        if (this.imagePath != null) {
            ImageElement ie;
            Rectangle r;
            String parent;
            this.curElement = null;
            String string = parent = this.imageAttachToDataEnabled ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
            if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
                parent = null;
            }
            if (x == -1 && y == -1) {
                File f = new File(this.imagePath);
                FileImageInputStream imageInput = null;
                try {
                    Rectangle r2;
                    imageInput = new FileImageInputStream(f);
                    Iterator<ImageReader> it = ImageIO.getImageReaders(imageInput);
                    if (!it.hasNext()) {
                        return null;
                    }
                    ImageReader reader = null;
                    while (it.hasNext()) {
                        reader = it.next();
                    }
                    reader.setInput(imageInput);
                    BufferedImage image = reader.read(0);
                    reader.dispose();
                    imageInput.close();
                    Dimension d = this.graph.getAnnotationSize();
                    int imwidth = ((Image)image).getWidth(null);
                    int imheight = ((Image)image).getHeight(null);
                    if (imwidth <= 0 || imheight <= 0) {
                        x = 0;
                        y = 0;
                    } else {
                        x = Math.max(0, d.width / 2 - imwidth / 2);
                        y = Math.max(0, d.height / 2 - imheight / 2);
                    }
                    String string2 = parent = this.imageAttachToDataEnabled ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
                    if (parent != null && !(r2 = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
                        parent = null;
                    }
                    ie = new ImageElement(this, this.graph, new Point(x, y), this.annoElem, parent, this.imagePath, (Image)image);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    this.imagePath = null;
                    return null;
                }
            } else {
                ie = new ImageElement(this, this.graph, new Point(x, y), this.annoElem, parent, this.imagePath);
            }
            this.imageFileList.add(this.imagePath);
            ie.setStyle(this.textStyle);
            ie.finish();
            this.drawables.add(ie);
            this.graph.annotateRepaint();
            ie.addPropertyChangeListener(this);
            Element ae = ie.getElement();
            this.elemToAnnotate.put(ae, ie);
            if (this.sgActionListener != null) {
                ie.addActionListener(this.sgActionListener);
                this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
            }
            this.firePropertyChange("add", null, ie);
            this.imagePath = null;
            this.onText = false;
            return ie;
        }
        return null;
    }

    private String getImagePath() {
        String imagePath = null;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(filter);
        if (this.lastPath != null) {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        fc.setDialogTitle(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "image.txt")));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            if (!file.exists()) {
                String title;
                String message = Message.format((String)RB.getStringResource(RB_KEY, "noFileFound.fmt.txt"), (Object)file.getName());
                returnVal = JOptionPane.showConfirmDialog(null, message, title = Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "image.txt")), 0, 2);
                if (returnVal == 0) {
                    return this.getImagePath();
                }
                return null;
            }
            if (!filter.accept(file)) {
                String title;
                String message = Message.format((String)RB.getStringResource(RB_KEY, "badFile.fmt.txt"), (Object)file.getName());
                returnVal = JOptionPane.showConfirmDialog(null, message, title = Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "image.txt")), 0, 2);
                if (returnVal == 0) {
                    return this.getImagePath();
                }
                return null;
            }
            this.lastPath = imagePath = file.getAbsolutePath();
        }
        return imagePath;
    }

    public void setImagePath(String path) {
        if (path == null) {
            path = this.getImagePath();
        }
        this.imagePath = path;
    }

    public void addImage(Image im, String imagepath, Point pos, String parent) {
        this.addImage(im, imagepath, pos);
    }

    public void addImage(Image im, String imagepath, Point pos) {
        Rectangle r;
        String parent;
        this.drawType = -1;
        this.curElement = null;
        this.imageFileList.add(imagepath);
        int x = (int)pos.getX();
        int y = (int)pos.getY();
        String string = parent = this.imageAttachToDataEnabled && this.graph instanceof Annotatable && x > 0 && y > 0 ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        ImageElement ie = new ImageElement(this, this.graph, pos, this.annoElem, null, imagepath, im);
        ie.finish();
        this.lastPath = this.imagePath;
        this.drawables.add(ie);
        this.graph.annotateRepaint();
        ie.addPropertyChangeListener(this);
        Element ae = ie.getElement();
        this.elemToAnnotate.put(ae, ie);
        if (this.sgActionListener != null) {
            ie.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.firePropertyChange("add", null, ie);
    }

    public void addImage(Image im, String imagepath, Object[] pos, String parent) {
        this.addImage(im, imagepath, pos);
    }

    public void addImage(Image im, String imagepath, Object[] pos) {
        Rectangle r;
        String parent;
        if (!(this.graph instanceof Annotatable)) {
            return;
        }
        this.drawType = -1;
        this.curElement = null;
        this.imageFileList.add(imagepath);
        int x = ((Double)pos[0]).intValue();
        int y = ((Double)pos[1]).intValue();
        String string = parent = this.imageAttachToDataEnabled && this.graph instanceof Annotatable && x > 0 && y > 0 ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        ImageElement ie = new ImageElement(this, (Annotatable)this.graph, pos, this.annoElem, parent, imagepath, im);
        ie.finish();
        this.lastPath = this.imagePath;
        this.drawables.add(ie);
        this.graph.annotateRepaint();
        ie.addPropertyChangeListener(this);
        Element ae = ie.getElement();
        this.elemToAnnotate.put(ae, ie);
        if (this.sgActionListener != null) {
            ie.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.firePropertyChange("add", null, ie);
    }

    public void addRectangle(Object[] x1, Object[] x2, String parent) {
        this.addRectangle(x1, x2);
    }

    public void addRectangle(Object[] x1, Object[] x2) {
        Rectangle r;
        String parent;
        if (!(this.graph instanceof Annotatable)) {
            return;
        }
        this.drawType = -1;
        int x = (int)Math.round(((Double)x1[0] + (Double)x2[0]) / 2.0);
        int y = (int)Math.round(((Double)x1[1] + (Double)x2[1]) / 2.0);
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new RectangleElement(this, (Annotatable)this.graph, x1, x2, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
        this.firePropertyChange("add", null, this.curElement);
    }

    public void addRectangle(Point x1, Point x2, String parent) {
        this.addRectangle(x1, x2);
    }

    public void addRectangle(Point x1, Point x2) {
        Rectangle r;
        String parent;
        this.drawType = -1;
        int x = (x1.x + x2.x) / 2;
        int y = (x1.y + x2.y) / 2;
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new RectangleElement(this, this.graph, x1, x2, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
        this.firePropertyChange("add", null, this.curElement);
    }

    public void addEllipse(Object[] x1, Object[] x2, String parent) {
        this.addEllipse(x1, x2);
    }

    public void addEllipse(Object[] x1, Object[] x2) {
        Rectangle r;
        String parent;
        if (!(this.graph instanceof Annotatable)) {
            return;
        }
        this.drawType = -1;
        int x = (int)Math.round(((Double)x1[0] + (Double)x2[0]) / 2.0);
        int y = (int)Math.round(((Double)x1[1] + (Double)x2[1]) / 2.0);
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new EllipseElement(this, (Annotatable)this.graph, x1, x2, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
    }

    public void addEllipse(Point x1, Point x2, String parent) {
        this.addEllipse(x1, x2);
    }

    public void addEllipse(Point x1, Point x2) {
        Rectangle r;
        String parent;
        this.drawType = -1;
        int x = (int)Math.round((x1.getX() + x2.getX()) / 2.0);
        int y = (int)Math.round((x1.getY() + x2.getY()) / 2.0);
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new EllipseElement(this, this.graph, x1, x2, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
    }

    public void addLine(Object[] x1, Object[] x2, String parent) {
        this.addLine(x1, x2);
    }

    public void addLine(Object[] x1, Object[] x2) {
        Rectangle r;
        String parent;
        if (!(this.graph instanceof Annotatable)) {
            return;
        }
        this.drawType = -1;
        int x = ((Double)x1[0]).intValue();
        int y = ((Double)x1[1]).intValue();
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new LineElement(this, (Annotatable)this.graph, x1, x2, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
        this.firePropertyChange("add", null, this.curElement);
    }

    public void addLine(Point x1, Point x2, String parent) {
        this.addLine(x1, x2);
    }

    public void addLine(Point x1, Point x2) {
        Rectangle r;
        String parent;
        this.drawType = -1;
        int x = (int)x1.getX();
        int y = (int)x1.getY();
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new LineElement(this, this.graph, x1, x2, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
        this.firePropertyChange("add", null, this.curElement);
    }

    public void addArrow(Object[] head, Object[] tail, String parent) {
        this.addArrow(head, tail);
    }

    public void addArrow(Object[] head, Object[] tail) {
        Rectangle r;
        String parent;
        if (!(this.graph instanceof Annotatable)) {
            return;
        }
        this.drawType = -1;
        int x = ((Double)head[0]).intValue();
        int y = ((Double)head[1]).intValue();
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new ArrowLineElement(this, (Annotatable)this.graph, head, tail, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
        this.firePropertyChange("add", null, this.curElement);
    }

    public void addArrow(Point head, Point tail, String parent) {
        this.addArrow(head, tail);
    }

    public void addArrow(Point head, Point tail) {
        Rectangle r;
        String parent;
        this.drawType = -1;
        int x = (int)head.getX();
        int y = (int)head.getY();
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        this.curElement = new ArrowLineElement(this, this.graph, head, tail, this.annoElem, parent);
        this.curElement.setStyle(this.style);
        this.curElement.setStyle(this.textStyle);
        this.curElement.addPropertyChangeListener(this);
        this._resetSelectionList();
        this.selectionList.add(this.curElement);
        this.drawables.add(this.curElement);
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        this.curElement.finish();
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.graph.annotateRepaint();
        this.firePropertyChange("add", null, this.curElement);
    }

    public void addText(String text, Point pos, String parent) {
        this.addText(text, pos);
    }

    public void addText(String text, Point pos) {
        Rectangle r;
        String parent;
        if (text.length() == 0) {
            this.addText(text, pos, true);
            return;
        }
        if (this.curElement != null && this.curElement.isCaretOn()) {
            String ct = this.curElement.getText();
            StringBuffer sb = new StringBuffer();
            if (ct != null && ct.length() > 0) {
                int cp = this.curElement.caretPosition;
                if (cp > 0) {
                    sb.append(ct.substring(0, cp));
                }
                sb.append(text);
                if (cp < ct.length()) {
                    sb.append(ct.substring(cp));
                }
                text = sb.toString();
            }
            this.curElement.caretPosition = text.length();
            this.curElement.setText(text);
            return;
        }
        this.drawType = -1;
        this.curElement = null;
        int x = pos.x;
        int y = pos.y;
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        TextElement te = new TextElement(this, this.graph, pos, this.annoElem, parent, text);
        te.setStyle(this.style);
        te.setStyle(this.textStyle);
        this.drawables.add(te);
        this.graph.annotateRepaint();
        te.addPropertyChangeListener(this);
        Element ae = te.getElement();
        this.elemToAnnotate.put(ae, te);
        if (this.sgActionListener != null) {
            te.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.firePropertyChange("add", null, te);
    }

    public void addText(String text, Point pos, boolean editMode) {
        Rectangle r;
        String parent;
        if (!editMode) {
            this.addText(text, pos);
            return;
        }
        if (this.curElement != null && this.curElement.isCaretOn()) {
            String ct = this.curElement.getText();
            StringBuffer sb = new StringBuffer();
            if (ct != null && ct.length() > 0) {
                int cp = this.curElement.caretPosition;
                if (cp > 0) {
                    sb.append(ct.substring(0, cp));
                }
                sb.append(text);
                if (cp < ct.length()) {
                    sb.append(ct.substring(cp));
                }
                text = sb.toString();
            }
            this.curElement.caretPosition = text.length();
            this.curElement.setText(text);
            return;
        }
        String string = parent = this.graph instanceof Annotatable ? ((Annotatable)this.graph).getGraphIDAt(pos.x, pos.y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(pos.x, pos.y)) {
            parent = null;
        }
        this.curElement = new TextElement(this, this.graph, pos, this.annoElem, parent, text);
        this.curElement.setLineStyle(this.style);
        this.curElement.setFillColor(this.style.getFillColor());
        this.curElement.finish();
        this.insertText(this.container);
        this.curElement.addPropertyChangeListener(this);
        this.graph.annotateRepaint();
        this.drawables.add(this.curElement);
        this.select.setSelected(true);
        this.drawType = -1;
        Element ae = this.curElement.getElement();
        this.elemToAnnotate.put(ae, this.curElement);
        if (this.sgActionListener != null) {
            this.curElement.addActionListener(this.sgActionListener);
        }
        this.onText = true;
        this.updateFormatToolBar();
        this.firePropertyChange("add", null, this.curElement);
    }

    public void addText(String text, Object[] pos, String parent) {
        this.addText(text, pos);
    }

    public void addText(String text, Object[] pos) {
        Rectangle r;
        String parent;
        if (!(this.graph instanceof Annotatable)) {
            return;
        }
        if (this.curElement != null && this.curElement.isCaretOn()) {
            String ct = this.curElement.getText();
            StringBuffer sb = new StringBuffer();
            if (ct != null && ct.length() > 0) {
                int cp = this.curElement.caretPosition;
                if (cp > 0) {
                    sb.append(ct.substring(0, cp));
                }
                sb.append(text);
                if (cp < ct.length()) {
                    sb.append(ct.substring(cp));
                }
                text = sb.toString();
            }
            this.curElement.caretPosition = text.length();
            this.curElement.setText(text);
            return;
        }
        this.drawType = -1;
        this.curElement = null;
        int x = ((Double)pos[0]).intValue();
        int y = ((Double)pos[1]).intValue();
        String string = parent = this.imageAttachToDataEnabled && this.graph instanceof Annotatable && x > 0 && y > 0 ? ((Annotatable)this.graph).getGraphIDAt(x, y) : null;
        if (parent != null && !(r = ((Annotatable)this.graph).getDataBoundingBox(parent)).contains(x, y)) {
            parent = null;
        }
        TextElement te = new TextElement(this, (Annotatable)this.graph, pos, this.annoElem, parent, text);
        te.setStyle(this.style);
        te.setStyle(this.textStyle);
        this.drawables.add(te);
        this.graph.annotateRepaint();
        te.addPropertyChangeListener(this);
        Element ae = te.getElement();
        this.elemToAnnotate.put(ae, te);
        if (this.sgActionListener != null) {
            te.addActionListener(this.sgActionListener);
            this.sgActionListener.actionPerformed(new SGActionEvent(this, ae));
        }
        this.firePropertyChange("add", null, te);
    }

    public static void setAnnotateInAnnotateToolBar(JToolBar annoToolBar, Annotate anno) {
        Component[] c = annoToolBar.getComponents();
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (!(c[i] instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)c[i];
            ActionListener[] al = button.getActionListeners();
            int count = al == null ? 0 : al.length;
            for (int j = 0; j < count; ++j) {
                if (!(al[j] instanceof ToolbarListener)) continue;
                button.removeActionListener(al[j]);
            }
        }
        if (anno != null) {
            Annotate.addAnnotateToToolBar(annoToolBar, anno);
        }
    }

    public static void addAnnotateToToolBar(JToolBar annoToolBar, Annotate anno) {
        if (anno == null) {
            return;
        }
        Component[] c = annoToolBar.getComponents();
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (!(c[i] instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)c[i];
            button.addActionListener(anno.toolListner);
            String cmd = button.getActionCommand();
            if (cmd.equals("select")) {
                anno.select = (JToggleButton)button;
                continue;
            }
            if (!cmd.equals("marker")) continue;
            anno.markerButton = button;
            button.setIcon(new SGIcon(anno.getCurrentMarker(), 16, 16));
        }
    }

    public static void removeAnnotateFromToolBar(JToolBar annoToolBar, Annotate anno) {
        if (anno == null) {
            return;
        }
        Component[] c = annoToolBar.getComponents();
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (!(c[i] instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)c[i];
            button.removeActionListener(anno.toolListner);
            if (anno.select != button) continue;
            anno.select = null;
        }
    }

    @Override
    public Object undo(Object action) {
        if (action == null) {
            return null;
        }
        if (action instanceof String) {
            StringTokenizer st = new StringTokenizer((String)action, ":");
            String cmd = st.nextToken();
            if (cmd.equals("move")) {
                int curPosition = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
                int newPosition = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
                AnnotateElement newElement = (AnnotateElement)this.drawables.get(curPosition);
                if (this.curElement != null && this.curElement != newElement && this.curElement.isCaretOn()) {
                    this.isDeletedOnDisable(this.curElement);
                    this.updateFormatToolBar();
                }
                this.curElement = newElement;
                this.drawables.remove(this.curElement);
                this.drawables.add(newPosition, this.curElement);
                Element ce = this.curElement.getElement();
                if (this.annoElem != null && ce != null) {
                    if (ce.getParentNode() == this.annoElem) {
                        this.annoElem.removeChild(ce);
                    }
                    if (newPosition < this.drawables.size() - 1) {
                        Element nextChild = ((AnnotateElement)this.drawables.get(newPosition + 1)).getElement();
                        this.annoElem.insertBefore(ce, nextChild);
                    } else {
                        this.annoElem.appendChild(ce);
                    }
                }
                this.graph.annotateRepaint();
                this.fireChangeEvent();
                return "move:" + newPosition + ":" + curPosition;
            }
            if (cmd.equals("group")) {
                String gid = st.nextToken();
                ArrayList list = (ArrayList)this.ungroups.get(gid);
                if (list != null) {
                    Group group = this.getGroup(gid);
                    group.removeActionListener(this.sgActionListener);
                    this.curGroup = null;
                    for (AnnotateElement ae : list) {
                        ae.removeActionListener(this.sgActionListener);
                        if (this.curElement == ae) {
                            this.curGroup = group;
                        }
                        group.add(ae);
                    }
                    group.addActionListener(this.sgActionListener);
                    group.addPropertyChangeListener(this);
                    this.ungroups.remove(gid);
                    this.curGroup = group;
                    this._resetSelectionList();
                    this.curElement = null;
                    this.graph.annotateRepaint();
                    this.disableFormatToolBar();
                    this.fireChangeEvent();
                    return "ungroup:" + gid;
                }
            } else if (cmd.equals("ungroup")) {
                String gid = st.nextToken();
                Group gr = this.getGroup(gid);
                if (gr != null) {
                    ArrayList list = gr.removeAll();
                    this.ungroups.put(gid, list);
                    if (this.curGroup == gr) {
                        this.curGroup = null;
                        this._resetSelectionList();
                        this.selectionList.addAll(list);
                        if (list.size() > 0) {
                            this.curElement = (AnnotateElement)list.get(0);
                        }
                    } else {
                        this.curGroup = null;
                        this._resetSelectionList();
                        this.curElement = null;
                    }
                    this.graph.annotateRepaint();
                    this.disableFormatToolBar();
                    this.fireChangeEvent();
                    return "group:" + gid;
                }
            } else {
                if (cmd.equals("cutgroup")) {
                    String gid = st.nextToken();
                    Group gr = this.getGroup(gid);
                    ArrayList list = gr.getAllMembers();
                    for (int i = 0; i < list.size(); ++i) {
                        AnnotateElement ae = (AnnotateElement)list.get(i);
                        this.drawables.remove(ae);
                        Element ce = ae.getElement();
                        if (ce == null || this.annoElem == null || ce.getParentNode() != this.annoElem) continue;
                        this.annoElem.removeChild(ce);
                    }
                    gr.setVisible(false);
                    if (gr == this.curGroup) {
                        this.curElement = null;
                        this.curGroup = null;
                        this._resetSelectionList();
                    }
                    this.graph.annotateRepaint();
                    this.disableFormatToolBar();
                    this.fireChangeEvent();
                    this.firePropertyChange("delete", gr, null);
                    return "pastegroup:" + gid;
                }
                if (cmd.equals("pastegroup")) {
                    String gid = st.nextToken();
                    Group gr = this.getGroup(gid);
                    ArrayList list = gr.getAllMembers();
                    for (int i = 0; i < list.size(); ++i) {
                        AnnotateElement ae = (AnnotateElement)list.get(i);
                        this.drawables.add(ae);
                        Element ce = ae.getElement();
                        if (ce == null || this.annoElem == null) continue;
                        this.annoElem.appendChild(ce);
                    }
                    gr.setVisible(true);
                    this.graph.annotateRepaint();
                    this.disableFormatToolBar();
                    this.fireChangeEvent();
                    this.firePropertyChange("add", null, gr);
                    return "cutgroup:" + gid;
                }
            }
        } else {
            if (action instanceof ArrayList) {
                AnnotateElement ae;
                ArrayList list = (ArrayList)action;
                this.disableFormatToolBar();
                if (list.size() == 0) {
                    return action;
                }
                this._resetSelectionList();
                this.curGroup = null;
                this.curElement = null;
                Object obj = list.get(0);
                if (obj instanceof Group) {
                    obj = ((Group)obj).getAllMembers().get(0);
                }
                if (this.drawables.indexOf(ae = (AnnotateElement)obj) != -1) {
                    for (int i = 0; i < list.size(); ++i) {
                        obj = list.get(i);
                        if (obj instanceof Group) {
                            ArrayList al = ((Group)obj).getAllMembers();
                            for (int j = 0; j < al.size(); ++j) {
                                ae = (AnnotateElement)al.get(j);
                                this.drawables.remove(ae);
                                Element ce = ae.getElement();
                                if (ce == null || this.annoElem == null) continue;
                                if (ce.getParentNode() == this.annoElem) {
                                    this.annoElem.removeChild(ce);
                                }
                                this.elemToAnnotate.put(ce, ae);
                            }
                            continue;
                        }
                        ae = (AnnotateElement)list.get(i);
                        this.drawables.remove(ae);
                        Element ce = ae.getElement();
                        if (ce == null || this.annoElem == null) continue;
                        if (ce.getParentNode() == this.annoElem) {
                            this.annoElem.removeChild(ce);
                        }
                        this.elemToAnnotate.put(ce, ae);
                    }
                    this.firePropertyChange("delete", list, null);
                } else {
                    this.curElement = ae;
                    for (int i = 0; i < list.size(); ++i) {
                        obj = list.get(i);
                        this.selectionList.add(obj);
                        if (obj instanceof Group) {
                            ArrayList al = ((Group)obj).getAllMembers();
                            for (int j = 0; j < al.size(); ++j) {
                                ae = (AnnotateElement)al.get(j);
                                this.drawables.add(ae);
                                Element ce = ae.getElement();
                                if (ce == null || this.annoElem == null) continue;
                                this.annoElem.appendChild(ce);
                            }
                            continue;
                        }
                        ae = (AnnotateElement)obj;
                        this.drawables.add(ae);
                        Element ce = ae.getElement();
                        if (ce == null || this.annoElem == null) continue;
                        this.annoElem.appendChild(ce);
                    }
                    this.firePropertyChange("add", null, list);
                }
                this.graph.annotateRepaint();
                this.fireChangeEvent();
                return list;
            }
            if (action instanceof Element) {
                Element aElem = (Element)action;
                String tag = aElem.getTagName();
                if (tag.equals("Group")) {
                    String id = aElem.getAttribute("group");
                    Group gr = new Group(this, id);
                    ArrayList<Element> list = new ArrayList<Element>();
                    for (Node node = aElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                        Element e;
                        AnnotateElement ae;
                        if (!(node instanceof Element) || (ae = (AnnotateElement)this.elemToAnnotate.get(e = (Element)node)) == null) continue;
                        ae.removeActionListener(this.sgActionListener);
                        list.add(e);
                        this.drawables.add(ae);
                        gr.add(ae);
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        this.annoElem.appendChild((Node)list.get(i));
                    }
                    gr.addActionListener(this.sgActionListener);
                    gr.addPropertyChangeListener(this);
                    this.groups.put(id, gr);
                    this.graph.annotateRepaint();
                    this.disableFormatToolBar();
                    this.fireChangeEvent();
                    this.firePropertyChange("add", null, gr);
                    return "cutgroup:" + id;
                }
                AnnotateElement ae = (AnnotateElement)this.elemToAnnotate.get(aElem);
                if (ae == null) {
                    return null;
                }
                this._resetSelectionList();
                this.curGroup = null;
                if (this.drawables.indexOf(ae) != -1) {
                    if (aElem != null && this.annoElem != null && aElem.getParentNode() == this.annoElem) {
                        this.annoElem.removeChild(aElem);
                    }
                    this.drawables.remove(ae);
                    this.curElement = null;
                    this.disableFormatToolBar();
                    this.firePropertyChange("delete", ae, null);
                } else {
                    if (aElem != null && this.annoElem != null) {
                        this.annoElem.appendChild(aElem);
                    }
                    this.drawables.add(ae);
                    this.curElement = ae;
                    this.updateFormatToolBar();
                    this.firePropertyChange("add", null, ae);
                }
                this.graph.annotateRepaint();
                this.fireChangeEvent();
                return aElem;
            }
            if (action instanceof Object[]) {
                ArrayList oldList = new ArrayList(this.drawables);
                this.drawables.removeAllElements();
                Object[] old = (Object[])action;
                for (int i = 0; i < old.length; ++i) {
                    AnnotateElement ae = (AnnotateElement)old[i];
                    this.drawables.add(ae);
                    Element ce = ae.getElement();
                    if (ce == null || this.annoElem == null) continue;
                    this.annoElem.appendChild(ce);
                }
                this.disableFormatToolBar();
                this.fireChangeEvent();
                this.firePropertyChange("updateList", oldList, new ArrayList(this.drawables));
                return oldList.toArray();
            }
        }
        return null;
    }

    private void fireChangeEvent() {
        int lsize = this.changeListeners.size();
        if (lsize > 0) {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = 0; i < lsize; ++i) {
                ((ChangeListener)this.changeListeners.get(i)).stateChanged(ce);
            }
        }
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        int lsize = this.propertyChangeListeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.propertyChangeListeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public Element getState() {
        return null;
    }

    public static JToolBar addAnnotateMenuToToolbar(JToolBar annoToolBar, Annotate anno) {
        ButtonGroup abg = new ButtonGroup();
        if (annoToolBar == null) {
            annoToolBar = new JToolBar();
        } else {
            Component[] c = annoToolBar.getComponents();
            int len = c.length;
            for (int i = 0; i < len; ++i) {
                if (!(c[i] instanceof JToggleButton)) continue;
                abg.add((JToggleButton)c[i]);
            }
        }
        JToggleButton button = new JToggleButton();
        button.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "a_select.gif")));
        button.setToolTipText(RB.getStringResource(RB_KEY, "select.txt"));
        button.setSelected(true);
        button.setActionCommand("select");
        if (anno != null) {
            anno.select = button;
            button.addActionListener(anno.toolListner);
        }
        annoToolBar.add(button);
        abg.add(button);
        button = new JToggleButton();
        button.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "text.gif")));
        button.setToolTipText(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "text.txt")));
        button.setActionCommand("text");
        if (anno != null) {
            button.addActionListener(anno.toolListner);
        }
        annoToolBar.add(button);
        abg.add(button);
        button = new JToggleButton();
        button.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "line.gif")));
        button.setToolTipText(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "line.txt")));
        button.setActionCommand("line");
        if (anno != null) {
            button.addActionListener(anno.toolListner);
        }
        annoToolBar.add(button);
        abg.add(button);
        button = new JToggleButton();
        button.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "arrow.gif")));
        button.setToolTipText(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "arrowText.txt")));
        button.setActionCommand("arrowtext");
        if (anno != null) {
            button.addActionListener(anno.toolListner);
        }
        annoToolBar.add(button);
        abg.add(button);
        button = new JToggleButton();
        button.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "rect.gif")));
        button.setToolTipText(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "rect.txt")));
        button.setActionCommand("rect");
        if (anno != null) {
            button.addActionListener(anno.toolListner);
        }
        annoToolBar.add(button);
        abg.add(button);
        button = new JToggleButton();
        button.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "ellipse.gif")));
        button.setToolTipText(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "ellipse.txt")));
        button.setActionCommand("ellipse");
        if (anno != null) {
            button.addActionListener(anno.toolListner);
        }
        annoToolBar.add(button);
        abg.add(button);
        button = new JToggleButton();
        button.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "image.gif")));
        button.setToolTipText(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "image.txt")));
        button.setActionCommand("image");
        if (anno != null) {
            button.addActionListener(anno.toolListner);
        }
        annoToolBar.add(button);
        abg.add(button);
        JToggleButton mbutton = new JToggleButton("");
        mbutton.setIcon(new ImageIcon(com.sas.graphics.sg.util.Util.getImage(null, "a_blank.gif")));
        if (anno != null) {
            anno.markerButton = mbutton;
            mbutton.setIcon(new SGIcon(anno.getCurrentMarker(), 12, 12));
            mbutton.addActionListener(anno.toolListner);
        }
        mbutton.setToolTipText(Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "marker.txt")));
        mbutton.setActionCommand("marker");
        annoToolBar.add(mbutton);
        abg.add(mbutton);
        return annoToolBar;
    }

    private static JMenuItem getItem(JPopupMenu pm, String name) {
        MenuElement[] list = pm.getSubElements();
        for (int i = 0; i < list.length; ++i) {
            if (!((JMenuItem)list[i]).getText().equals(name)) continue;
            return (JMenuItem)list[i];
        }
        return null;
    }

    private static JMenuItem getItem(JMenu pm, String name) {
        int count = pm.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!pm.getItem(i).getText().equals(name)) continue;
            return pm.getItem(i);
        }
        return null;
    }

    public void askAndSaveAnnoAttrs() {
        if (this.curElement != null) {
            String title;
            Element ae = this.curElement.getState();
            this.lastAction = this.sgActionListener == null ? null : this.sgActionListener.getLastAction();
            int tab = this.onText ? 2 : 0;
            AnnotateCustomizerPanel panel = new AnnotateCustomizerPanel(this.curElement, this.colorGrabber, tab);
            Container frame = this.container.getTopLevelAncestor();
            JFrame parent = frame instanceof JFrame ? (JFrame)frame : null;
            int result = SGDialog.showInputDialog(parent, title = Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "annotationProperties.txt")), panel);
            if (result == -1) {
                this.savedPanel = panel;
                this.savedTitle = Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "annotationProperties.txt"));
                this.savedElement = ae;
                this.colorGrabber.addActionListener(this);
                this.colorGrabber.setLastListener(this);
                return;
            }
            if (result != 0) {
                this.curElement.undo(ae);
                if (this.sgActionListener != null) {
                    this.sgActionListener.discardActionsUpto(this.lastAction);
                }
            } else {
                if (this.curElement instanceof MarkerElement) {
                    MarkerElement me = (MarkerElement)this.curElement;
                    this.markerStyle.setMarkerColor(me.getMarkerColor());
                    this.markerStyle.setMarkerSize(me.getMarkerSize());
                    this.markerStyle.setMarkerSymbol(me.getMarkerSymbol());
                    if (this.markerButton != null) {
                        this.markerButton.setIcon(new SGIcon(this.getCurrentMarker(), 16, 16));
                    }
                } else if (this.curElement instanceof LineElement) {
                    this.style.setLineColor(this.curElement.getLineColor());
                    this.style.setLineWidth(this.curElement.getLineWidth());
                    this.style.setLinePattern(this.curElement.getLinePattern());
                } else if (this.curElement instanceof ImageElement) {
                    this.style.setFillTrans(this.curElement.getFillTrans());
                    if (this.curElement.isLineOn()) {
                        this.style.setLineColor(this.curElement.getLineColor());
                        this.style.setLineWidth(this.curElement.getLineWidth());
                        this.style.setLinePattern(this.curElement.getLinePattern());
                    }
                } else if (!(this.curElement instanceof TextElement)) {
                    this.style.setFillTrans(this.curElement.getFillTrans());
                    this.style.setFillOn(this.curElement.isFillOn());
                    this.style.setFillColor(this.curElement.getFillColor());
                    this.style.setLineOn(this.curElement.isLineOn());
                    this.style.setLineColor(this.curElement.getLineColor());
                    this.style.setLineWidth(this.curElement.getLineWidth());
                    this.style.setLinePattern(this.curElement.getLinePattern());
                }
                this.textStyle.setFontColor(this.curElement.getFontColor());
                this.textStyle.setFont(this.curElement.getFont());
                this.updateFormatToolBar();
            }
        }
    }

    public void askAndSaveGroupAttrs() {
        if (this.curGroup != null) {
            String title;
            Container frame;
            Element ae = this.curGroup.getState();
            this.lastAction = this.sgActionListener == null ? null : this.sgActionListener.getLastAction();
            GroupCustomizerPanel panel = new GroupCustomizerPanel(this.curGroup, this.colorGrabber);
            for (frame = this.container; frame != null && !(frame instanceof JFrame); frame = frame.getParent()) {
            }
            JFrame parent = frame != null ? (JFrame)frame : null;
            int result = SGDialog.showInputDialog(parent, title = Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "groupProperties.txt")), (JPanel)panel, (Apply)null);
            if (result == -1) {
                this.savedPanel = panel;
                this.savedTitle = Util.getLabelWithoutMnemonic((String)RB.getStringResource(RB_KEY, "groupProperties.txt"));
                this.savedElement = ae;
                this.colorGrabber.addActionListener(this);
                this.colorGrabber.setLastListener(this);
                return;
            }
            if (result != 0) {
                this.curGroup.undo(ae);
                if (this.sgActionListener != null) {
                    this.sgActionListener.discardActionsUpto(this.lastAction);
                }
            } else {
                Font font;
                if (!this.curGroup.isTextOrMarkersOnly()) {
                    if (this.curGroup.isAreaAttrsEnabled()) {
                        if (this.curGroup.isValidTransparency()) {
                            this.style.setFillTrans(this.curGroup.getFillTrans());
                        }
                        if (this.curGroup.isValidFillOn()) {
                            this.style.setFillOn(this.curGroup.isFillOn());
                        }
                        if (this.curGroup.isValidFillColor()) {
                            this.style.setFillColor(this.curGroup.getFillColor());
                        }
                    }
                    if (this.curGroup.isValidLineOn()) {
                        this.style.setLineOn(this.curGroup.isLineOn());
                    }
                    if (this.curGroup.isValidLineColor()) {
                        this.style.setLineColor(this.curGroup.getLineColor());
                    }
                    if (this.curGroup.isValidLineWidth()) {
                        this.style.setLineWidth(this.curGroup.getLineWidth());
                    }
                    if (this.curGroup.isValidLinePattern()) {
                        this.style.setLinePattern(this.curGroup.getLinePattern());
                    }
                    if (this.curGroup.isValidColor()) {
                        this.textStyle.setFontColor(this.curGroup.getFontColor());
                    }
                }
                if ((font = this.textStyle.getFont()) != null) {
                    int style;
                    int size;
                    String family = this.curGroup.getFontFamily();
                    if (family == null || family.length() == 0) {
                        family = font.getFamily();
                    }
                    if ((size = this.curGroup.getFontSize()) == -1) {
                        size = font.getSize();
                    }
                    if ((style = this.curGroup.getFontStyle()) == -1) {
                        style = font.getStyle();
                    }
                    this.textStyle.setFont(new Font(family, style, size));
                }
            }
        }
    }

    @Override
    public void addActionListener(SGActionListener listener) {
        this.sgActionListener = listener;
        this.selectionList.addActionListener(listener);
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    public void removeAllChangeListeners() {
        this.changeListeners.clear();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeListeners.add(pcl);
    }

    public void removePropertyChangeListener(ChangeListener pcl) {
        this.propertyChangeListeners.remove(pcl);
    }

    public void removeAllPropertyListeners() {
        this.propertyChangeListeners.clear();
    }

    public boolean isPasteActive() {
        return this.buffer != null;
    }

    public void moveBackward() {
        if (this.curGroup == null && this.curElement == null) {
            return;
        }
        ArrayList list = new ArrayList();
        if (this.selectionList.size() > 1 || this.curGroup != null) {
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, this.drawables.toArray()));
            }
            if (this.curGroup != null) {
                list.addAll(this.curGroup.getAllMembers());
            }
            if (this.selectionList.size() > 0) {
                list.addAll(this.selectionList);
            }
            int insertPos = 0;
            for (int i = 0; i < this.drawables.size(); ++i) {
                Object obj = this.drawables.get(i);
                if (!list.contains(obj)) continue;
                if (i <= insertPos) {
                    ++insertPos;
                    continue;
                }
                this.drawables.remove(i);
                this.drawables.insertElementAt(obj, i - 1);
                insertPos = i;
            }
        }
        if (!list.contains(this.curElement)) {
            if (this.curElement == this.drawables.firstElement()) {
                return;
            }
            int curPos = this.drawables.indexOf(this.curElement);
            int newPos = curPos - 1;
            this.drawables.remove(this.curElement);
            if (this.sgActionListener != null && list.size() == 0) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, "move:" + newPos + ":" + curPos));
            }
            this.drawables.remove(this.curElement);
            this.drawables.add(newPos, this.curElement);
            Element ce = this.curElement.getElement();
            if (this.annoElem != null && ce != null) {
                if (ce.getParentNode() == this.annoElem) {
                    this.annoElem.removeChild(ce);
                }
                if (newPos < this.drawables.size() - 1) {
                    Element nextChild = ((AnnotateElement)this.drawables.get(newPos + 1)).getElement();
                    this.annoElem.insertBefore(ce, nextChild);
                } else {
                    this.annoElem.appendChild(ce);
                }
            }
        }
        this.graph.annotateRepaint();
    }

    public void moveForward() {
        if (this.curGroup == null && this.curElement == null) {
            return;
        }
        ArrayList list = new ArrayList();
        if (this.selectionList.size() > 1 || this.curGroup != null) {
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, this.drawables.toArray()));
            }
            if (this.curGroup != null) {
                list.addAll(this.curGroup.getAllMembers());
            }
            if (this.selectionList.size() > 0) {
                list.addAll(this.selectionList);
            }
            int insertPos = this.drawables.size() - 1;
            for (int i = this.drawables.size(); i >= 0; --i) {
                Object obj = this.drawables.get(i);
                if (!list.contains(obj)) continue;
                if (i >= insertPos) {
                    --insertPos;
                    continue;
                }
                this.drawables.remove(i);
                this.drawables.insertElementAt(obj, i + 1);
                insertPos = i;
            }
        }
        if (!list.contains(this.curElement)) {
            if (this.curElement == this.drawables.lastElement()) {
                return;
            }
            int curPos = this.drawables.indexOf(this.curElement);
            int newPos = curPos + 1;
            this.drawables.remove(this.curElement);
            if (this.sgActionListener != null && list.size() == 0) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, "move:" + newPos + ":" + curPos));
            }
            this.drawables.remove(this.curElement);
            this.drawables.add(newPos, this.curElement);
            Element ce = this.curElement.getElement();
            if (this.annoElem != null && ce != null) {
                if (ce.getParentNode() == this.annoElem) {
                    this.annoElem.removeChild(ce);
                }
                if (newPos < this.drawables.size() - 1) {
                    Element nextChild = ((AnnotateElement)this.drawables.get(newPos + 1)).getElement();
                    this.annoElem.insertBefore(ce, nextChild);
                } else {
                    this.annoElem.appendChild(ce);
                }
            }
        }
        this.graph.annotateRepaint();
    }

    public void moveToFront() {
        if (this.curGroup == null && this.curElement == null) {
            return;
        }
        ArrayList list = new ArrayList();
        if (this.selectionList.size() > 1 || this.curGroup != null) {
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, this.drawables.toArray()));
            }
            int insertPos = this.drawables.size() - 1;
            if (this.curGroup != null) {
                list.addAll(this.curGroup.getAllMembers());
            }
            if (this.selectionList.size() > 0) {
                list.addAll(this.selectionList);
            }
            for (int i = this.drawables.size(); i >= 0; --i) {
                Object obj = this.drawables.get(i);
                if (!list.contains(obj)) continue;
                if (i >= insertPos) {
                    --insertPos;
                    continue;
                }
                this.drawables.insertElementAt(obj, insertPos);
                this.drawables.remove(i);
                --insertPos;
            }
        }
        if (!list.contains(this.curElement)) {
            int curPos = this.drawables.indexOf(this.curElement);
            this.drawables.remove(this.curElement);
            if (this.sgActionListener != null && list.size() == 0) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, "move:" + this.drawables.size() + ":" + curPos));
            }
            this.drawables.add(this.curElement);
            Element ce = this.curElement.getElement();
            if (this.annoElem != null && ce != null) {
                if (ce.getParentNode() == this.annoElem) {
                    this.annoElem.removeChild(ce);
                }
                this.annoElem.appendChild(ce);
            }
        }
        this.graph.annotateRepaint();
    }

    public void moveToBack() {
        if (this.curGroup == null && this.curElement == null) {
            return;
        }
        ArrayList list = new ArrayList();
        if (this.selectionList.size() > 1 || this.curGroup != null) {
            if (this.sgActionListener != null) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, this.drawables.toArray()));
            }
            int insertPos = 0;
            if (this.curGroup != null) {
                list.addAll(this.curGroup.getAllMembers());
            }
            if (this.selectionList.size() > 0) {
                list.addAll(this.selectionList);
            }
            for (int i = 0; i < this.drawables.size(); ++i) {
                Object obj = this.drawables.get(i);
                if (!list.contains(obj)) continue;
                if (i <= insertPos) {
                    ++insertPos;
                    continue;
                }
                this.drawables.remove(i);
                this.drawables.insertElementAt(obj, insertPos);
                ++insertPos;
            }
        }
        if (!list.contains(this.curElement)) {
            int curPos = this.drawables.indexOf(this.curElement);
            this.drawables.remove(this.curElement);
            if (this.sgActionListener != null && list.size() == 0) {
                this.sgActionListener.actionPerformed(new SGActionEvent(this, "move:0:" + curPos));
            }
            this.drawables.remove(this.curElement);
            this.drawables.add(0, this.curElement);
            Element ce = this.curElement.getElement();
            if (this.annoElem != null && ce != null) {
                if (ce.getParentNode() == this.annoElem) {
                    this.annoElem.removeChild(ce);
                }
                if (this.drawables.size() > 1) {
                    Element nextChild = ((AnnotateElement)this.drawables.get(1)).getElement();
                    this.annoElem.insertBefore(ce, nextChild);
                } else {
                    this.annoElem.appendChild(ce);
                }
            }
        }
        this.graph.annotateRepaint();
    }

    @Override
    public void disablePropertyEvents() {
        this.eventsEnabled = false;
    }

    @Override
    public void enablePropertyEvents() {
        this.eventsEnabled = true;
    }

    Group getGroup(String id) {
        Group obj = null;
        if (id != null) {
            if (id.equals("")) {
                return null;
            }
            this.nameGenerator.add(id);
            obj = (Group)this.groups.get(id);
        }
        if (obj == null) {
            if (id == null) {
                id = this.nameGenerator.get("Group");
            }
            Group gr = new Group(this, id);
            gr.addActionListener(this.sgActionListener);
            gr.addPropertyChangeListener(this);
            obj = gr;
            this.groups.put(id, obj);
        }
        return obj;
    }

    Annotate getAnnotation() {
        return this;
    }

    public void setInsertPopupEnabled(boolean flag) {
        this.insertPopupOn = flag;
    }

    public boolean isInsertPopupEnabled() {
        return this.insertPopupOn;
    }

    AAreaStyle getDefaultAreaStyle() {
        return this.defaultStyle;
    }

    ATextStyle getDefaultTextStyle() {
        return this.defaultTextStyle;
    }

    AMarkerStyle getDefaultMarkerStyle() {
        return this.defaultMarkerStyle;
    }

    public MarkerInterface getCurrentMarker() {
        Color c;
        int size;
        int symbol = this.markerStyle.getMarkerSymbol();
        if (symbol == -1) {
            symbol = this.markerStyle.getDefaultMarkerSymbol();
        }
        if ((size = this.markerStyle.getMarkerSize()) == -1) {
            size = this.markerStyle.getDefaultMarkerSize();
        }
        if ((c = this.markerStyle.getMarkerColor()) == null) {
            c = this.markerStyle.getDefaultMarkerColor();
        }
        return new SGMarker(symbol, size, c);
    }

    Annotate getAnnotate() {
        return this;
    }

    public JComponent getContainer() {
        return this.container;
    }

    public void setContainer(JComponent container) {
        this.container = container;
    }

    public Color getFontColor() {
        if (this.curElement == null && this.curGroup == null) {
            return null;
        }
        if (this.curGroup != null) {
            return this.curGroup.getFontColor();
        }
        Color c = this.curElement.getFontColor();
        if (c == null) {
            c = this.curElement.getDefaultFontColor();
        }
        return c;
    }

    public void setFontColor(Color color) {
        if (color == null || this.curElement == null && this.curGroup == null) {
            return;
        }
        this.textStyle.setFontColor(color);
        if (this.curGroup != null) {
            this.curGroup.setFontColor(color);
        } else {
            this.curElement.setFontColor(color);
            if (this.onText) {
                this.curElement.requestFocus();
            }
        }
    }

    public String getFontFamily() {
        if (this.curElement == null && this.curGroup == null) {
            return "";
        }
        if (this.curGroup != null) {
            return this.curGroup.getFontFamily();
        }
        String family = this.curElement.getFontFamily();
        if (family == null || family.length() == 0) {
            family = this.curElement.getDefaultFontFamily();
        }
        return family;
    }

    public void setFontFamily(String family) {
        if (family == null || family.length() == 0 || this.curElement == null && this.curGroup == null) {
            return;
        }
        this.textStyle.setFontFamily(family);
        if (this.curGroup != null) {
            this.curGroup.setFontFamily(family);
        } else {
            this.curElement.setFontFamily(family);
            if (this.onText) {
                this.curElement.requestFocus();
            }
        }
    }

    public String getFontSize() {
        if (this.curElement == null && this.curGroup == null) {
            return "";
        }
        if (this.curGroup != null) {
            return Integer.toString(this.curGroup.getFontSize());
        }
        int size = this.curElement.getFontSize();
        if (size == -1) {
            size = this.curElement.getDefaultFontSize();
        }
        return Integer.toString(size);
    }

    public void setFontSize(String family) {
        if (family == null || family.length() == 0 || this.curElement == null && this.curGroup == null) {
            return;
        }
        try {
            int size = Integer.parseInt(family);
            this.textStyle.setFontSize(size);
            if (this.curGroup != null) {
                this.curGroup.setFontSize(size);
            } else {
                this.curElement.setFontSize(size);
                if (this.onText) {
                    this.curElement.requestFocus();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isBold() {
        if (this.curElement == null && this.curGroup == null) {
            return false;
        }
        if (this.curGroup != null) {
            return this.curGroup.isBold();
        }
        return this.curElement.isBold();
    }

    public void setBold(boolean bold) {
        this.textStyle.setBold(bold);
        if (this.curGroup != null) {
            this.curGroup.setBold(bold);
        } else if (this.curElement != null) {
            this.curElement.setBold(bold);
            if (this.onText) {
                this.curElement.requestFocus();
            }
        }
    }

    public boolean isItalic() {
        if (this.curElement == null && this.curGroup == null) {
            return false;
        }
        if (this.curGroup != null) {
            return this.curGroup.isItalic();
        }
        return this.curElement.isItalic();
    }

    public void setItalic(boolean bold) {
        this.textStyle.setItalic(bold);
        if (this.curGroup != null) {
            this.curGroup.setItalic(bold);
        } else if (this.curElement != null) {
            this.curElement.setItalic(bold);
            if (this.onText) {
                this.curElement.requestFocus();
            }
        }
    }

    public void setSelectAll(Component c, boolean select) {
        this.onText = false;
        this.drawType = -1;
        this._resetSelectionList();
        this.resetListeners(c, 0, 0, false);
        if (select) {
            HashSet<String> groups = new HashSet<String>();
            for (int i = 0; i < this.drawables.size(); ++i) {
                AnnotateElement ae = (AnnotateElement)this.drawables.get(i);
                String gid = ae.getGroup();
                if (gid != null && gid.length() > 0) {
                    if (groups.contains(gid)) continue;
                    groups.add(gid);
                    this.selectionList.add(this.getGroup(gid));
                    continue;
                }
                this.selectionList.add(ae);
            }
            this.curElement = (AnnotateElement)this.drawables.get(0);
            String gid = this.curElement.getGroup();
            this.curGroup = gid != null && gid.length() > 0 ? this.getGroup(gid) : null;
        } else {
            this.curElement = null;
            this.curGroup = null;
        }
        this.updateFormatToolBar();
        this.graph.annotateRepaint();
    }

    public void setFormatToolBar(JToolBar formatBar) {
        this.formatBar = formatBar;
        if (this.curElement != null) {
            this.updateFormatToolBar();
        }
    }

    private void disableFormatToolBar() {
        if (this.formatBar == null) {
            return;
        }
        boolean align = this.curGroup == null && this.selectionList.size() <= 1 && this.curElement != null && this.curElement instanceof AlignInterface;
        Component[] c = this.formatBar.getComponents();
        for (int j = 0; j < c.length; ++j) {
            JToggleButton button;
            JComboBox box;
            if (!(c[j] instanceof JToggleButton) && !(c[j] instanceof JComboBox)) continue;
            String name = c[j].getName();
            if ("family".equals(name)) {
                box = (JComboBox)c[j];
                box.setEnabled(false);
            } else if ("size".equals(name)) {
                box = (JComboBox)c[j];
                box.setEnabled(false);
            }
            if ("color".equals(name)) {
                box = (SwatchComboBox)c[j];
                box.setEnabled(false);
                continue;
            }
            if ("italic".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(false);
                continue;
            }
            if ("bold".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(false);
                continue;
            }
            if ("right".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(align);
                continue;
            }
            if ("left".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(align);
                continue;
            }
            if (!"center".equals(name)) continue;
            button = (JToggleButton)c[j];
            button.setEnabled(align);
        }
    }

    private void updateFormatToolBar() {
        Color color;
        if (this.formatBar == null) {
            return;
        }
        if (this.curElement == null && this.curGroup == null) {
            return;
        }
        boolean isGroup = this.curGroup != null;
        boolean align = !isGroup && this.selectionList.size() <= 1 && this.curElement instanceof AlignInterface;
        boolean enable = this.selectionList.size() < 2 && (isGroup || this.curElement.isFormattingEnabled());
        Component[] c = this.formatBar.getComponents();
        String family = isGroup ? this.curGroup.getFontFamily() : this.curElement.textStyle.getFontFamily();
        int value = isGroup ? this.curGroup.getFontSize() : this.curElement.textStyle.getFontSize();
        String size = Integer.toString(value);
        boolean bold = isGroup ? this.curGroup.isBold() : this.curElement.textStyle.isBold();
        boolean italic = isGroup ? this.curGroup.isItalic() : this.curElement.textStyle.isItalic();
        Color color2 = color = isGroup ? this.curGroup.getFontColor() : this.curElement.textStyle.getFontColor();
        if (color == null) {
            color = isGroup ? this.curGroup.getFontColor() : this.curElement.textStyle.getFontColor();
        }
        for (int j = 0; j < c.length; ++j) {
            JToggleButton button;
            int i;
            ActionListener[] listeners;
            JComboBox box;
            if (!(c[j] instanceof JToggleButton) && !(c[j] instanceof JComboBox)) continue;
            String name = c[j].getName();
            if ("family".equals(name)) {
                box = (JComboBox)c[j];
                box.setEnabled(enable);
                if (!box.getSelectedItem().equals(family)) {
                    listeners = box.getActionListeners();
                    for (i = 0; i < listeners.length; ++i) {
                        box.removeActionListener(listeners[i]);
                    }
                    if (((String)box.getItemAt(0)).length() == 0) {
                        box.removeItemAt(0);
                    }
                    box.setSelectedItem(family);
                    for (i = 0; i < listeners.length; ++i) {
                        box.addActionListener(listeners[i]);
                    }
                }
            } else if ("size".equals(name)) {
                box = (JComboBox)c[j];
                box.setEnabled(enable);
                if (!box.getSelectedItem().equals(size)) {
                    String vv;
                    int sz;
                    listeners = box.getActionListeners();
                    for (i = 0; i < listeners.length; ++i) {
                        box.removeActionListener(listeners[i]);
                    }
                    if (((String)box.getItemAt(0)).length() == 0) {
                        box.removeItemAt(0);
                    }
                    for (i = 0; i < box.getItemCount() && (sz = Integer.parseInt(vv = (String)box.getItemAt(i))) != value; ++i) {
                        if (sz <= value) continue;
                        box.insertItemAt(size, i);
                        break;
                    }
                    box.setSelectedItem(size);
                    for (i = 0; i < listeners.length; ++i) {
                        box.addActionListener(listeners[i]);
                    }
                }
            }
            if ("color".equals(name)) {
                box = (SwatchComboBox)c[j];
                box.setEnabled(enable);
                if (color == null) {
                    color = Color.WHITE;
                }
                if (box.getSelectedItem().toString().equals(color.toString())) continue;
                listeners = box.getActionListeners();
                for (i = 0; i < listeners.length; ++i) {
                    box.removeActionListener(listeners[i]);
                }
                ((SwatchComboBox)box).setSelectedItem(color);
                for (i = 0; i < listeners.length; ++i) {
                    box.addActionListener(listeners[i]);
                }
                continue;
            }
            if ("italic".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(enable);
                if (button.isSelected() == italic) continue;
                listeners = button.getActionListeners();
                for (i = 0; i < listeners.length; ++i) {
                    button.removeActionListener(listeners[i]);
                }
                button.setSelected(italic);
                for (i = 0; i < listeners.length; ++i) {
                    button.addActionListener(listeners[i]);
                }
                continue;
            }
            if ("bold".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(enable);
                if (button.isSelected() == bold) continue;
                listeners = button.getActionListeners();
                for (i = 0; i < listeners.length; ++i) {
                    button.removeActionListener(listeners[i]);
                }
                button.setSelected(bold);
                for (i = 0; i < listeners.length; ++i) {
                    button.addActionListener(listeners[i]);
                }
                continue;
            }
            if ("center".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(align);
                if (!align || ((AlignInterface)((Object)this.curElement)).getAlignment() != 0 || button.isSelected()) continue;
                listeners = button.getActionListeners();
                for (i = 0; i < listeners.length; ++i) {
                    button.removeActionListener(listeners[i]);
                }
                button.setSelected(true);
                for (i = 0; i < listeners.length; ++i) {
                    button.addActionListener(listeners[i]);
                }
                continue;
            }
            if ("right".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(align);
                if (!align || ((AlignInterface)((Object)this.curElement)).getAlignment() != 4 || button.isSelected()) continue;
                listeners = button.getActionListeners();
                for (i = 0; i < listeners.length; ++i) {
                    button.removeActionListener(listeners[i]);
                }
                button.setSelected(true);
                for (i = 0; i < listeners.length; ++i) {
                    button.addActionListener(listeners[i]);
                }
                continue;
            }
            if ("left".equals(name)) {
                button = (JToggleButton)c[j];
                button.setEnabled(align);
                if (!align || ((AlignInterface)((Object)this.curElement)).getAlignment() != 2 || button.isSelected()) continue;
                listeners = button.getActionListeners();
                for (i = 0; i < listeners.length; ++i) {
                    button.removeActionListener(listeners[i]);
                }
                button.setSelected(true);
                for (i = 0; i < listeners.length; ++i) {
                    button.addActionListener(listeners[i]);
                }
                continue;
            }
            if (!"none".equals(name) || align) continue;
            button = (JToggleButton)c[j];
            button.setSelected(true);
        }
    }

    private void _resetSelectionList() {
        if (this.selectionList.isModified()) {
            this.selectionList = new AnnotateList();
        } else {
            this.selectionList.clear();
        }
    }

    public ColorGrabber getColorGrabber() {
        return this.colorGrabber;
    }

    public void setColorGrabber(ColorGrabber colorGrabber) {
        this.colorGrabber = colorGrabber;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e instanceof SwatchActionEvent) {
            Point loc;
            Container cc;
            JFrame frame;
            int result;
            if (e.getID() != 4) {
                return;
            }
            String command = e.getActionCommand();
            if (this.savedPanel == null) {
                Color color;
                if (command.equals("colorpicker:done")) {
                    this.updateFormatToolBar();
                    this.colorGrabber.removeMouseEventListener();
                    this.colorGrabber.removeActionListener(this);
                } else if (command.equals("colorpicker:updating") && (color = (Color)((SwatchActionEvent)e).getValue()) != null) {
                    this.updateFormatToolBar();
                }
            } else if (command.equals("colorpicker:done") && (result = SGDialog.showInputDialog(frame = (cc = this.container.getTopLevelAncestor()) instanceof JFrame ? (JFrame)cc : null, this.savedTitle, this.savedPanel, null, loc = this.savedPanel.getTopLevelAncestor().getLocation())) != -1) {
                if (result != 0) {
                    if (this.savedElement != null) {
                        if (this.savedElement.getTagName().equals("Group")) {
                            this.curGroup.undo(this.savedElement);
                        } else {
                            this.curElement.undo(this.savedElement);
                        }
                    }
                    if (this.sgActionListener != null) {
                        this.sgActionListener.discardActionsUpto(this.lastAction);
                    }
                } else if (this.savedPanel instanceof AnnotateCustomizerPanel) {
                    if (this.curElement instanceof MarkerElement) {
                        MarkerElement me = (MarkerElement)this.curElement;
                        this.markerStyle.setMarkerColor(me.getMarkerColor());
                        this.markerStyle.setMarkerSize(me.getMarkerSize());
                        this.markerStyle.setMarkerSymbol(me.getMarkerSymbol());
                        if (this.markerButton != null) {
                            this.markerButton.setIcon(new SGIcon(this.getCurrentMarker(), 16, 16));
                        }
                    } else if (this.curElement instanceof LineElement) {
                        this.style.setFillTrans(this.curElement.getFillTrans());
                        this.style.setLineColor(this.curElement.getLineColor());
                        this.style.setLineWidth(this.curElement.getLineWidth());
                        this.style.setLinePattern(this.curElement.getLinePattern());
                    } else if (this.curElement instanceof ImageElement) {
                        this.style.setFillTrans(this.curElement.getFillTrans());
                        if (this.curElement.isLineOn()) {
                            this.style.setLineColor(this.curElement.getLineColor());
                            this.style.setLineWidth(this.curElement.getLineWidth());
                            this.style.setLinePattern(this.curElement.getLinePattern());
                        }
                    } else if (!(this.curElement instanceof TextElement)) {
                        this.style.setFillTrans(this.curElement.getFillTrans());
                        this.style.setFillOn(this.curElement.isFillOn());
                        this.style.setFillColor(this.curElement.getFillColor());
                        this.style.setLineOn(this.curElement.isLineOn());
                        this.style.setLineColor(this.curElement.getLineColor());
                        this.style.setLineWidth(this.curElement.getLineWidth());
                        this.style.setLinePattern(this.curElement.getLinePattern());
                    }
                    this.textStyle.setFontColor(this.curElement.getFontColor());
                    this.textStyle.setFont(this.curElement.getFont());
                    this.updateFormatToolBar();
                }
                this.savedPanel = null;
                this.savedTitle = null;
                this.colorGrabber.removeActionListener(this);
            }
        }
    }

    public Iterator getImageFiles() {
        return this.imageFileList.iterator();
    }

    public ArrayList getGlobalMenuItems() {
        return this.globalMenuItems;
    }

    public void setGlobalMenuItems(ArrayList globalMenuItems) {
        this.globalMenuItems = globalMenuItems;
    }

    public String getImageFile(AnnotateElement img) {
        if (img instanceof ImageElement) {
            return ((ImageElement)img).file;
        }
        return null;
    }

    public boolean isPopupEnabled() {
        return this.popupEnabled;
    }

    public void setPopupEnabled(boolean popupEnabled) {
        this.popupEnabled = popupEnabled;
    }

    public boolean isImageAttachToDataEnabled() {
        return this.imageAttachToDataEnabled;
    }

    public void setImageAttachToDataEnabled(boolean imageAttachToDataEnabled) {
        this.imageAttachToDataEnabled = imageAttachToDataEnabled;
    }

    public void setClipToScreenEnabled(boolean enable) {
        this.clipToScreen = enable;
    }

    public boolean isClipToScreenEnabled() {
        return this.clipToScreen;
    }

    public void setDataValuesDirty() {
        this.dataValuesDirty = true;
    }

    boolean isDataValuesDirty() {
        return this.dataValuesDirty;
    }

    private Rectangle2D getBounds(ArrayList list) {
        int index;
        if (list.isEmpty()) {
            return new Rectangle();
        }
        for (index = 0; index < list.size() && !(list.get(index) instanceof AnnotateElement); ++index) {
        }
        AnnotateElement ae = (AnnotateElement)list.get(index);
        Rectangle2D bb = ae.getBounds();
        boolean dataSpace = ae.isAnchorAttachedToData();
        for (int i = index + 1; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof AnnotateElement)) continue;
            ae = (AnnotateElement)obj;
            if (!(dataSpace &= ae.isAnchorAttachedToData())) break;
            Rectangle2D r2d = ae.getBounds();
            double xo = Math.min(bb.getX(), r2d.getX());
            double x1 = Math.max(bb.getX() + bb.getWidth(), r2d.getX() + r2d.getWidth());
            double yo = Math.min(bb.getY(), r2d.getY());
            double y1 = Math.max(bb.getY() + bb.getHeight(), r2d.getY() + r2d.getHeight());
            bb.setRect(xo, yo, x1 - xo, y1 - yo);
        }
        if (dataSpace) {
            return bb;
        }
        return this.getScreenBounds(list);
    }

    private Rectangle getScreenBounds(ArrayList list) {
        int index;
        if (list.isEmpty()) {
            return new Rectangle();
        }
        for (index = 0; index < list.size() && !(list.get(index) instanceof AnnotateElement); ++index) {
        }
        AnnotateElement ae = (AnnotateElement)list.get(index);
        Rectangle r = ae.getScreenBounds();
        for (int i = index; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof AnnotateElement)) continue;
            ae = (AnnotateElement)obj;
            Rectangle rr = ae.getScreenBounds();
            r = r.union(rr);
        }
        return r;
    }

    public Rectangle2D getBounds() {
        return this.getBounds(new ArrayList(this.drawables));
    }

    public Rectangle getScreenBounds() {
        return this.getScreenBounds(new ArrayList(this.drawables));
    }

    public Rectangle2D getAnnotateElementBounds(Object obj) {
        if (obj instanceof AnnotateElement) {
            return ((AnnotateElement)obj).getBounds();
        }
        if (obj instanceof Group) {
            return ((Group)obj).getBounds();
        }
        if (obj instanceof AnnotateList) {
            return ((AnnotateList)obj).getBounds();
        }
        if (obj instanceof ArrayList) {
            return this.getBounds((ArrayList)obj);
        }
        return new Rectangle();
    }

    public Rectangle getAnnotateElementScreenBounds(Object obj) {
        if (obj instanceof AnnotateElement) {
            return ((AnnotateElement)obj).getScreenBounds();
        }
        if (obj instanceof Group) {
            return ((Group)obj).getScreenBounds();
        }
        if (obj instanceof AnnotateList) {
            return ((AnnotateList)obj).getScreenBounds();
        }
        if (obj instanceof ArrayList) {
            return this.getScreenBounds((ArrayList)obj);
        }
        return new Rectangle();
    }

    class ToolbarListener
    implements ActionListener {
        ToolbarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand();
            if (cmd.equals("select")) {
                Annotate.this.setType(-1);
            } else if (cmd.equals("text")) {
                Annotate.this.setType(0);
            } else if (cmd.equals("arrowtext")) {
                Annotate.this.setType(1);
            } else if (cmd.equals("line")) {
                Annotate.this.setType(2);
            } else if (cmd.equals("ellipse")) {
                Annotate.this.setType(5);
            } else if (cmd.equals("rect")) {
                Annotate.this.setType(6);
            } else if (cmd.equals("image")) {
                AnnotateElement ae = Annotate.this._addImage(-1, -1);
                if (ae != null && ae.isAnchorAttachedToData() && !Annotate.this.imageAttachToDataEnabled) {
                    Annotate.this.curElement = ae;
                    ae.setClipOutsideDataOn(false);
                    ae.setAnchorAttachedToData(false);
                }
            } else if (cmd.equals("marker")) {
                Annotate.this.setType(9);
            }
        }
    }
}

