/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.elements.SGText;
import com.sas.graphics.sg.interfaces.DefaultTextInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.RB;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.TextStyleElement;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

class ATextStyle
implements TextInterface,
DefaultTextInterface {
    private TextInterface textStyle;
    private ArrayList listeners = new ArrayList();
    final ATextStyle defaultStyle;
    private boolean fallbackToDefault = true;

    public ATextStyle(Annotatable graph) {
        if (graph == null || graph.getStyle() == null) {
            this.textStyle = new SGText(new Font(RB.getStringResource("fontArial.lcl"), 0, 14), Color.BLACK);
        } else {
            Style gstyle = graph.getStyle();
            TextStyleElement textElem = gstyle.getTextStyleElement("AnnoText");
            String family = textElem.getFontFamily();
            int weight = textElem.getFontWeight();
            int style = textElem.getFontStyle();
            int size = textElem.getFontSize().toPoints((int)(graph.getDPIScaleFactor() * 100.0), graph.getAnnotationSize().height);
            int fontStyle = 0;
            if (style == 2) {
                fontStyle |= 2;
            }
            if (weight == 1) {
                fontStyle |= 1;
            }
            this.textStyle = new SGText(new Font(family, fontStyle, size), textElem.getTextColor());
        }
        this.defaultStyle = this;
    }

    public ATextStyle(ATextStyle style) {
        this.textStyle = new SGText(null, null);
        this.defaultStyle = style.textStyle.getFont() == null && style.textStyle.getFontColor() == null ? style.defaultStyle : style;
    }

    public void setStyle(Annotatable graph, Style style) {
        TextStyleElement textElem = style.getTextStyleElement("AnnoText");
        String family = textElem.getFontFamily();
        int weight = textElem.getFontWeight();
        int tstyle = textElem.getFontStyle();
        int size = textElem.getFontSize().toPoints((int)(graph.getDPIScaleFactor() * 100.0), graph.getAnnotationSize().height);
        int fontStyle = 0;
        if (tstyle == 2) {
            fontStyle |= 2;
        }
        if (weight == 1) {
            fontStyle |= 1;
        }
        this.textStyle.setFont(new Font(family, fontStyle, size));
        this.textStyle.setFontColor(textElem.getTextColor());
    }

    @Override
    public Font getFont() {
        if (this.textStyle.getFont() != null) {
            return this.textStyle.getFont();
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.getFont();
        }
        return null;
    }

    @Override
    public void setFont(Font font) {
        Font oldValue = this.textStyle.getFont();
        if (font == null || font.toString().equals(this.defaultStyle.textStyle.getFont().toString())) {
            this.textStyle.setFont(null);
        } else {
            this.textStyle.setFont(font);
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "font", oldValue, font);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    public boolean isFontCustom() {
        return this.textStyle.getFont() != null;
    }

    @Override
    public Color getFontColor() {
        if (this.textStyle.getFontColor() != null) {
            return this.textStyle.getFontColor();
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.getFontColor();
        }
        return null;
    }

    public boolean isCustomColor() {
        return this.textStyle.getFontColor() != null;
    }

    @Override
    public void setFontColor(Color color) {
        Color oldValue = this.textStyle.getFontColor();
        if (color == null || color.getRGB() == this.defaultStyle.textStyle.getFontColor().getRGB()) {
            this.textStyle.setFontColor(null);
        } else {
            this.textStyle.setFontColor(color);
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "color", oldValue, color);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    void reset() {
        this.textStyle.setFont(null);
        this.textStyle.setFontColor(null);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public String getFontFamily() {
        if (this.textStyle.getFont() == null) {
            if (this.fallbackToDefault) {
                return this.defaultStyle.getFontFamily();
            }
            return "";
        }
        String family = this.textStyle.getFont().getFamily();
        if (this.fallbackToDefault) {
            return family;
        }
        String defaultFamily = this.defaultStyle.getFont().getFamily();
        if (defaultFamily.equalsIgnoreCase(family)) {
            return "";
        }
        return family;
    }

    @Override
    public void setFontFamily(String family) {
        if (this.textStyle.getFont() == null) {
            this.textStyle.setFont(this.defaultStyle.getFont());
        }
        if (family == null || family.length() == 0) {
            Font defaultFont = this.defaultStyle.getFont();
            this.textStyle.setFontFamily(defaultFont.getFamily());
        } else {
            this.textStyle.setFontFamily(family);
        }
        if (this.textStyle.getFont().toString().equals(this.defaultStyle.textStyle.getFont().toString())) {
            this.textStyle.setFont(null);
        }
    }

    @Override
    public int getFontSize() {
        if (this.textStyle.getFont() == null) {
            if (this.fallbackToDefault) {
                return this.defaultStyle.getFontSize();
            }
            return -1;
        }
        int size = this.textStyle.getFont().getSize();
        if (this.fallbackToDefault) {
            return size;
        }
        int defaultSize = this.defaultStyle.getFont().getSize();
        if (defaultSize == size) {
            return -1;
        }
        return size;
    }

    @Override
    public void setFontSize(int size) {
        if (this.textStyle.getFont() == null) {
            this.textStyle.setFont(this.defaultStyle.getFont());
        }
        if (size == -1) {
            Font defaultFont = this.defaultStyle.getFont();
            this.textStyle.setFontSize(defaultFont.getSize());
        } else {
            this.textStyle.setFontSize(size);
        }
        if (this.textStyle.getFont().toString().equals(this.defaultStyle.textStyle.getFont().toString())) {
            this.textStyle.setFont(null);
        }
    }

    @Override
    public int getFontStyle() {
        if (this.textStyle.getFont() == null) {
            if (this.fallbackToDefault) {
                return this.defaultStyle.getFontStyle();
            }
            return -1;
        }
        int style = this.textStyle.getFont().getStyle();
        if (this.fallbackToDefault) {
            return style;
        }
        int dStyle = this.defaultStyle.getFont().getStyle();
        if (dStyle == style) {
            return -1;
        }
        return style;
    }

    @Override
    public void setFontStyle(int style) {
        if (this.textStyle.getFont() == null) {
            this.textStyle.setFont(this.defaultStyle.getFont());
        }
        if (style == -1) {
            Font defaultFont = this.defaultStyle.getFont();
            this.textStyle.setFontStyle(defaultFont.getStyle());
        } else {
            this.textStyle.setFontStyle(style);
        }
        if (this.textStyle.getFont().toString().equals(this.defaultStyle.textStyle.getFont().toString())) {
            this.textStyle.setFont(null);
        }
    }

    @Override
    public boolean isBold() {
        if (this.textStyle.getFont() == null) {
            return this.defaultStyle.isBold();
        }
        return this.textStyle.isBold();
    }

    @Override
    public void setBold(boolean bold) {
        if (this.textStyle.getFont() == null) {
            this.textStyle.setFont(this.defaultStyle.getFont());
        }
        this.textStyle.setBold(bold);
        if (this.textStyle.getFont().toString().equals(this.defaultStyle.textStyle.getFont().toString())) {
            this.textStyle.setFont(null);
        }
    }

    @Override
    public boolean isItalic() {
        if (this.textStyle.getFont() == null) {
            return this.defaultStyle.isItalic();
        }
        return this.textStyle.isItalic();
    }

    @Override
    public void setItalic(boolean italic) {
        if (this.textStyle.getFont() == null) {
            this.textStyle.setFont(this.defaultStyle.getFont());
        }
        this.textStyle.setItalic(italic);
        if (this.textStyle.getFont().toString().equals(this.defaultStyle.textStyle.getFont().toString())) {
            this.textStyle.setFont(null);
        }
    }

    @Override
    public Font getDefaultFont() {
        return this.defaultStyle.getFont();
    }

    @Override
    public String getDefaultFontFamily() {
        return this.getDefaultFont().getFamily();
    }

    @Override
    public int getDefaultFontSize() {
        return this.getDefaultFont().getSize();
    }

    @Override
    public int getDefaultFontStyle() {
        return this.getDefaultFont().getStyle();
    }

    @Override
    public Color getDefaultFontColor() {
        return this.defaultStyle.getFontColor();
    }

    public boolean isFallbackToDefault() {
        return this.fallbackToDefault;
    }

    public void setFallbackToDefault(boolean fallbackToDefault) {
        this.fallbackToDefault = fallbackToDefault;
    }
}

