/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.elements.SGFill;
import com.sas.graphics.sg.elements.SGLine;
import com.sas.graphics.sg.interfaces.AreaInterface;
import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.interfaces.FillInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.RB;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.Style;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class AAreaStyle
implements AreaInterface,
DefaultAreaInterface {
    private FillInterface fillStyle;
    private LineInterface lineStyle;
    boolean lineOn = true;
    boolean fillOn = false;
    private int alpha = 255;
    private ArrayList listeners = new ArrayList();
    final AAreaStyle defaultStyle;
    boolean fallbackToDefault = false;

    public AAreaStyle(Annotatable graph) {
        if (graph == null || graph.getStyle() == null) {
            this.fillStyle = new SGFill(Color.WHITE);
            this.lineStyle = new SGLine(1, 2, Color.BLACK);
        } else {
            Style style = graph.getStyle();
            FillStyleElement fillElem = graph.getStyle().getFillStyleElement("AnnoShape");
            this.fillStyle = new SGFill(fillElem.getFillColor());
            LineStyleElement lineElem = style.getLineStyleElement("AnnoShape");
            this.lineStyle = new SGLine(lineElem.getLineStyle(), lineElem.getLineThickness().toPixels((int)(graph.getDPIScaleFactor() * 100.0), graph.getAnnotationSize().height), lineElem.getLineColor());
        }
        this.defaultStyle = this;
    }

    public void setStyle(Annotatable graph, Style style) {
        FillStyleElement fillElem = style.getFillStyleElement("AnnoShape");
        this.fillStyle.setFillColor(fillElem.getFillColor());
        LineStyleElement lineElem = style.getLineStyleElement("AnnoShape");
        this.lineStyle.setLineColor(lineElem.getLineColor());
        this.lineStyle.setLinePattern(lineElem.getLineStyle());
        this.lineStyle.setLineWidth(lineElem.getLineThickness().toPixels((int)(graph.getDPIScaleFactor() * 100.0), graph.getAnnotationSize().height));
    }

    public AAreaStyle(AAreaStyle aStyle) {
        this.defaultStyle = aStyle;
        this.fillStyle = new SGFill(null);
        this.lineStyle = new SGLine(-1, -1, null);
        this.fallbackToDefault = true;
    }

    void reset() {
        this.fillStyle.setFillColor(null);
        this.lineStyle.setLineColor(null);
        this.lineStyle.setLinePattern(-1);
        this.lineStyle.setLineWidth(-1);
    }

    @Override
    public void setLineOn(boolean onOrOff) {
        if (this.lineOn == onOrOff) {
            return;
        }
        Boolean oldValue = this.lineOn ? Boolean.TRUE : Boolean.FALSE;
        this.lineOn = onOrOff;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "lineOn", oldValue, new Boolean(this.lineOn));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public boolean isLineOn() {
        return this.lineOn;
    }

    @Override
    public boolean isFillOn() {
        return this.fillOn;
    }

    @Override
    public void setFillOn(boolean onOrOff) {
        if (this.fillOn == onOrOff) {
            return;
        }
        Boolean oldValue = this.fillOn ? Boolean.TRUE : Boolean.FALSE;
        this.fillOn = onOrOff;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "fillOn", oldValue, new Boolean(this.fillOn));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public void setLinePattern(int patternName) {
        if (patternName == this.lineStyle.getLinePattern()) {
            return;
        }
        Integer oldValue = new Integer(this.lineStyle.getLinePattern());
        this.lineStyle.setLinePattern(patternName);
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "linePattern", oldValue, new Integer(patternName));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public int getLinePattern() {
        int pattern = this.lineStyle.getLinePattern();
        if (this.fallbackToDefault) {
            if (pattern != -1) {
                return pattern;
            }
            return this.defaultStyle.getLinePattern();
        }
        return pattern;
    }

    public boolean isLinePatternCustom() {
        return this.lineStyle.getLinePattern() != -1;
    }

    @Override
    public void setLineWidth(int thickness) {
        if (thickness == this.lineStyle.getLineWidth()) {
            return;
        }
        Integer oldValue = new Integer(this.lineStyle.getLineWidth());
        this.lineStyle.setLineWidth(thickness);
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "lineWidth", oldValue, new Integer(thickness));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public int getLineWidth() {
        int width = this.lineStyle.getLineWidth();
        if (this.fallbackToDefault) {
            if (width != -1) {
                return width;
            }
            return this.defaultStyle.getLineWidth();
        }
        return width;
    }

    public boolean isLineWidthCustom() {
        return this.lineStyle.getLineWidth() != -1;
    }

    @Override
    public Color getLineColor() {
        if (this.lineStyle.getLineColor() != null) {
            return this.lineStyle.getLineColor();
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.getLineColor();
        }
        return null;
    }

    public boolean isLineColorCustom() {
        return this.lineStyle.getLineColor() != null;
    }

    @Override
    public void setLineColor(Color color) {
        Color oldValue = this.lineStyle.getLineColor();
        if (color == null || color.getRGB() == this.defaultStyle.lineStyle.getLineColor().getRGB()) {
            this.lineStyle.setLineColor(null);
        } else {
            this.lineStyle.setLineColor(color);
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "lineColor", oldValue, color);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    public void setLineStyle(LineInterface mi) {
        int value = mi.getLinePattern();
        if (value == this.defaultStyle.lineStyle.getLinePattern()) {
            this.lineStyle.setLinePattern(-1);
        } else {
            this.lineStyle.setLinePattern(value);
        }
        value = mi.getLineWidth();
        if (value == this.defaultStyle.lineStyle.getLineWidth()) {
            this.lineStyle.setLineWidth(-1);
        } else {
            this.lineStyle.setLineWidth(value);
        }
        Color c = mi.getLineColor();
        if (c == null || c.getRGB() == this.defaultStyle.lineStyle.getLineColor().getRGB()) {
            this.lineStyle.setLineColor(null);
        } else {
            this.lineStyle.setLineColor(c);
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "lineStyle", mi, this.lineStyle);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public void setFillColor(Color color) {
        Color oldColor = this.fillStyle.getFillColor();
        if (color == null || color.getRGB() == this.defaultStyle.fillStyle.getFillColor().getRGB()) {
            this.fillStyle.setFillColor(null);
        } else {
            this.fillStyle.setFillColor(color);
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "fillColor", oldColor, color);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public Color getFillColor() {
        if (this.fillStyle.getFillColor() != null) {
            return this.fillStyle.getFillColor();
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.getFillColor();
        }
        return null;
    }

    public boolean isFillColorCustom() {
        return this.fillStyle.getFillColor() != null;
    }

    @Override
    public int getFillTrans() {
        return (255 - this.alpha) * 100 / 255;
    }

    @Override
    public void setFillTrans(int transparency) {
        if (this.alpha == (100 - transparency) * 255 / 100) {
            return;
        }
        Integer oldValue = new Integer((255 - this.alpha) * 100 / 255);
        this.alpha = (100 - transparency) * 255 / 100;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "transparency", oldValue, new Integer(transparency));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.alpha == alpha) {
            return;
        }
        Integer oldValue = new Integer(this.alpha);
        this.alpha = alpha;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "alpha", oldValue, new Integer(alpha));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public String getDisplay() {
        if (!this.fallbackToDefault && this.defaultStyle.lineOn == this.lineOn && this.defaultStyle.fillOn == this.fillOn) {
            return "";
        }
        if (this.lineOn && this.fillOn) {
            return RB.getStringResource("fillOutline.txt");
        }
        if (this.lineOn) {
            return RB.getStringResource("outline.txt");
        }
        return RB.getStringResource("fill.txt");
    }

    public void setDisplay(String value) {
        String oldValue = "";
        oldValue = this.fillOn && this.lineOn ? RB.getStringResource("fillOutline.txt") : (this.lineOn ? RB.getStringResource("outline.txt") : RB.getStringResource("fill.txt"));
        if (RB.getStringResource("fill.txt").equalsIgnoreCase(value)) {
            this.fillOn = true;
            this.lineOn = false;
        } else if (RB.getStringResource("outline.txt").equalsIgnoreCase(value)) {
            this.fillOn = false;
            this.lineOn = true;
        } else if (RB.getStringResource("fillOutline.txt").equalsIgnoreCase(value)) {
            this.fillOn = true;
            this.lineOn = true;
        } else {
            this.fillOn = false;
            this.lineOn = true;
        }
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "display", oldValue, new Integer(this.alpha));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    public String getDefaultDisplay() {
        if (this.defaultStyle.fillOn && this.defaultStyle.lineOn) {
            return RB.getStringResource("fillOutline.txt");
        }
        if (this.defaultStyle.fillOn) {
            return RB.getStringResource("fill.txt");
        }
        return RB.getStringResource("Outline.txt");
    }

    public boolean isDefaultFillOn() {
        return this.defaultStyle.fillOn;
    }

    @Override
    public Color getDefaultFillColor() {
        return this.defaultStyle.fillStyle.getFillColor();
    }

    @Override
    public String getDefaultFillColorSource() {
        return RB.getStringResource("automatic.txt");
    }

    public boolean isDefaultLineOn() {
        return this.defaultStyle.lineOn;
    }

    @Override
    public int getDefaultLinePattern() {
        return this.defaultStyle.lineStyle.getLinePattern();
    }

    @Override
    public String getDefaultLinePatternSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public int getDefaultLineWidth() {
        return this.defaultStyle.lineStyle.getLineWidth();
    }

    @Override
    public String getDefaultLineWidthSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public Color getDefaultLineColor() {
        return this.defaultStyle.lineStyle.getLineColor();
    }

    @Override
    public String getDefaultLineColorSource() {
        return RB.getStringResource("automatic.txt");
    }

    public AAreaStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setFallbackToDefault(boolean value) {
        this.fallbackToDefault = value;
    }

    public boolean isFallbackToDefault() {
        return this.fallbackToDefault;
    }
}

