/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.util;

import com.sas.graphics.sg.interfaces.CompositeTextInterface;
import com.sas.graphics.sg.interfaces.ComputedTextInterface;
import com.sas.graphics.sg.interfaces.RichTextInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.util.RB;
import com.sas.graphics.sg.util.Util;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class SGTextPane
extends JTextPane
implements CaretListener,
CompositeTextInterface,
TextInterface,
KeyListener {
    public static final int EFFECTS_PLAIN = 0;
    public static final int EFFECTS_SUBSCRIPT = 1;
    public static final int EFFECTS_SUPERSCRIPT = 2;
    public static final int EFFECTS_MIXED = -1;
    static final int MAX_CHARACTERS = 80;
    protected int align;
    protected double fontScale = 1.0;
    protected ComputedTextInterface cti = null;
    protected ArrayList curAttrs = new ArrayList();
    protected MyDocumentListener listener;
    protected boolean ready = false;
    String format;
    protected int maxFontSize = -1;
    final UndoManager undo = new UndoManager();
    private static final int EFFECTS = 0;
    private static final int SUPERSCRIPT = 1;
    private static final int SUBSCRIPT = 2;
    private static final int FONT = 3;
    private static final int COLOR = 4;
    private static final int FAMILY = 5;
    private static final int SIZE = 6;
    private static final int STYLE = 7;
    private static final int BOLD = 8;
    private static final int ITALIC = 9;
    private RichTextInterface[] lastText;
    private Rectangle lastBounds = null;
    boolean processing = false;

    public SGTextPane(ComponentListener parent, RichTextInterface[] text, int alignment, ComputedTextInterface cti, double fontScale) {
        this.align = alignment;
        this.fontScale = fontScale;
        this.cti = cti;
        this.initDocument(text);
        this.format = text[0].getFormat();
        this.addBindings();
        this.addCaretListener(this);
        this.addKeyListener(this);
        this.listener = new MyDocumentListener();
        Document doc = this.getDocument();
        doc.addDocumentListener(this.listener);
        if (parent != null) {
            this.addComponentListener(parent);
        }
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                SGTextPane.this.undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (SGTextPane.this.undo.canUndo()) {
                        SGTextPane.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (SGTextPane.this.undo.canRedo()) {
                        SGTextPane.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.ready = true;
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (!this.ready) {
            return;
        }
        StyledDocument doc = this.getStyledDocument();
        Rectangle b = this.getBounds();
        Dimension s = this.getPreferredSize();
        s.width = Math.max(s.width + 4, b.width);
        s.height = Math.max(this.maxFontSize + (int)(8.0 * this.fontScale), b.height);
        try {
            if (doc.getText(0, doc.getLength()).indexOf(13) != -1) {
                s.height /= 2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (s.width > b.width || s.height > b.height) {
            if (this.align == 0) {
                this.setBounds(b.x + (b.width - s.width) / 2, b.y, s.width, s.height);
            } else if (this.align == 4) {
                this.setBounds(b.x + b.width - s.width, b.y, s.width, s.height);
            } else {
                this.setBounds(b.x, b.y, s.width, s.height);
            }
        }
    }

    SGTextPane getPane() {
        return this;
    }

    public void setHorzAlignment(int value) {
        this.align = value;
    }

    protected void _setCurrentAttrs() {
        StyledDocument doc = this.getStyledDocument();
        Caret caret = this.getCaret();
        int mark = caret.getMark();
        int dot = caret.getDot();
        this.curAttrs.clear();
        int min = Math.min(mark, dot);
        int max = Math.max(mark, dot);
        if (max - min <= 1) {
            if (dot == mark && mark == doc.getLength()) {
                if (mark == 0) {
                    this.curAttrs.add(this.getInputAttributes());
                } else {
                    Element elmt = doc.getCharacterElement(mark - 1);
                    this.curAttrs.add(elmt.getAttributes());
                }
            } else if (mark > 0 && mark >= dot) {
                Element elmt = doc.getCharacterElement(mark - 1);
                this._addToCurrentAttrs(elmt, mark - 1, mark);
            } else {
                Element elmt = doc.getCharacterElement(min);
                this._addToCurrentAttrs(elmt, min, max);
            }
        } else {
            Element elmt = doc.getCharacterElement(min);
            this._addToCurrentAttrs(elmt, min, max);
            int prevOffset = -1;
            int nextOffset = elmt.getEndOffset();
            while (elmt != null && nextOffset < max && (nextOffset = (elmt = doc.getCharacterElement(nextOffset)).getEndOffset()) != prevOffset) {
                prevOffset = nextOffset;
                this._addToCurrentAttrs(elmt, min, max);
            }
        }
    }

    private void _addToCurrentAttrs(Element elmt, int min, int max) {
        if (elmt == null) {
            return;
        }
        int count = elmt.getElementCount();
        if (count == 0) {
            if (elmt.getEndOffset() > min && elmt.getStartOffset() <= max) {
                this.curAttrs.add(elmt.getAttributes());
            }
            return;
        }
        for (int i = 0; i < count; ++i) {
            this._addToCurrentAttrs(elmt.getElement(i), min, max);
        }
    }

    @Override
    public void paste() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
            }
            catch (SecurityException se) {
                JOptionPane.showConfirmDialog(this, RB.getStringResource("noAccess.txt"), RB.getStringResource("warning.txt"), -1, 2);
                return;
            }
        }
        Clipboard cb = this.getToolkit().getSystemClipboard();
        try {
            Transferable trans = cb.getContents(null);
            Object obj = trans.getTransferData(DataFlavor.stringFlavor);
            if (obj.toString().length() + this.getDocument().getLength() > 512) {
                JOptionPane.showConfirmDialog(this, RB.getStringResource("invalid.txt"), RB.getStringResource("warning.txt"), -1, 2);
                return;
            }
        }
        catch (Exception ise) {
            String message = Message.format((String)RB.getStringResource("insertFailed.fmt.txt"), (Object)ise.getLocalizedMessage());
            JOptionPane.showConfirmDialog(this, message, RB.getStringResource("warning.txt"), -1, 2);
            return;
        }
        super.paste();
        int index = this.getText().indexOf(13);
        try {
            while (index != -1) {
                this.getDocument().remove(index, 1);
                index = this.getText().indexOf(13);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    SGTextPane getTextPane() {
        return this;
    }

    void exit() {
        this.ready = false;
        this.getDocument().removeDocumentListener(this.listener);
        this.setVisible(false);
    }

    protected void _setProperty(int propertyID, Object value) {
        SimpleAttributeSet as;
        this.lastBounds = this.getBounds();
        this.lastText = this.getRichText();
        Dimension ps = this.getPreferredSize();
        switch (propertyID) {
            case 4: {
                Color c = (Color)value;
                as = this.getAttribute(c);
                break;
            }
            case 3: {
                Font f = (Font)value;
                as = this.getAttribute(f);
                break;
            }
            case 1: {
                boolean sup = (Boolean)value;
                as = this.getAttribute(sup, 1);
                break;
            }
            case 2: {
                boolean sub = (Boolean)value;
                as = this.getAttribute(sub, 2);
                break;
            }
            case 8: {
                boolean bold = (Boolean)value;
                as = this.getAttribute(bold, 8);
                break;
            }
            case 9: {
                boolean italic = (Boolean)value;
                as = this.getAttribute(italic, 9);
                break;
            }
            case 5: {
                String s = (String)value;
                as = this.getAttribute(s);
                break;
            }
            case 6: {
                int sz = value == null ? -1 : (Integer)value;
                as = this.getAttribute(sz, 6);
                break;
            }
            case 7: {
                int se = value == null ? -1 : (Integer)value;
                as = this.getAttribute(se, 7);
                break;
            }
            case 0: {
                int ee = value == null ? -1 : (Integer)value;
                as = this.getAttribute(ee, 0);
                break;
            }
            default: {
                as = new SimpleAttributeSet();
            }
        }
        if (propertyID == 6) {
            int fsize = StyleConstants.getFontSize(this.getCharacterAttributes());
            this.setCharacterAttributes(as, false);
            int fsize2 = StyleConstants.getFontSize(as);
            if (fsize2 > fsize) {
                this.maxFontSize = Math.max(this.maxFontSize, fsize2);
            } else {
                StyledDocument doc = this.getStyledDocument();
                Element elmt = doc.getCharacterElement(0);
                this.maxFontSize = StyleConstants.getFontSize(elmt.getAttributes());
                int prevOffset = -1;
                int nextOffset = elmt.getEndOffset();
                while (elmt != null && nextOffset <= doc.getLength() && prevOffset != (nextOffset = (elmt = doc.getCharacterElement(nextOffset)).getEndOffset())) {
                    prevOffset = nextOffset;
                    this.maxFontSize = Math.max(this.maxFontSize, StyleConstants.getFontSize(elmt.getAttributes()));
                }
            }
        } else {
            this.setCharacterAttributes(as, false);
        }
        Dimension ps2 = this.getPreferredSize();
        if (ps2.width > ps.width || ps2.height > ps.height) {
            this.caretUpdate(null);
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public void setFontColor(Color c) {
        this._setProperty(4, c);
    }

    @Override
    public void setFont(Font f) {
        if (!this.ready) {
            super.setFont(f);
            return;
        }
        this._setProperty(3, f);
    }

    protected void addBindings() {
        InputMap inputMap = this.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(66, 2);
        inputMap.put(key, "caret-backward");
        key = KeyStroke.getKeyStroke(70, 2);
        inputMap.put(key, "caret-forward");
        key = KeyStroke.getKeyStroke(80, 2);
        inputMap.put(key, "caret-up");
        key = KeyStroke.getKeyStroke(78, 2);
        inputMap.put(key, "caret-down");
        key = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(key, new MyEnter());
        key = KeyStroke.getKeyStroke(127, 0);
        inputMap.put(key, "delete-next");
    }

    protected void initDocument(RichTextInterface[] tlist) {
        SimpleAttributeSet[] attrs = this.getAttributes(tlist);
        StyledDocument doc = this.getStyledDocument();
        int length = 0;
        try {
            for (int i = 0; i < tlist.length; ++i) {
                String text = tlist[i].getText();
                if (text == null) continue;
                this.maxFontSize = Math.max(this.maxFontSize, StyleConstants.getFontSize(attrs[i]));
                int tlen = text.length();
                if (length + tlen <= 512) {
                    doc.insertString(length, text, attrs[i]);
                    length += tlen;
                    continue;
                }
                text = text.substring(0, 512 - length);
                doc.insertString(length, text, attrs[i]);
                break;
            }
            if (doc.getLength() == 0 && attrs.length > 0) {
                doc.insertString(doc.getLength(), " ", attrs[0]);
                doc.remove(0, 1);
            }
        }
        catch (BadLocationException ble) {
            System.err.println("SGTextField: initDocument()");
            ble.printStackTrace();
        }
    }

    protected SimpleAttributeSet[] getAttributes(RichTextInterface[] tlist) {
        int length = tlist.length;
        SimpleAttributeSet[] attrs = new SimpleAttributeSet[length];
        for (int i = 0; i < length; ++i) {
            attrs[i] = this.getAttributes(tlist[i]);
        }
        return attrs;
    }

    protected SimpleAttributeSet getAttribute(Color color) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, color);
        return attrs;
    }

    protected SimpleAttributeSet getAttribute(String s) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs, s);
        return attrs;
    }

    protected SimpleAttributeSet getAttribute(Font f) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs, f.getFamily());
        StyleConstants.setBold(attrs, f.isBold());
        StyleConstants.setItalic(attrs, f.isItalic());
        int size = f.getSize();
        if (this.cti != null) {
            size = this.cti.getComputedFontSize(size);
        }
        size = (int)Math.floor((double)size * this.fontScale);
        StyleConstants.setFontSize(attrs, size);
        return attrs;
    }

    protected SimpleAttributeSet getAttribute(int value, int ID) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        switch (ID) {
            case 6: {
                int sz = value;
                if (this.cti != null) {
                    sz = this.cti.getComputedFontSize(sz);
                }
                sz = (int)Math.floor((double)sz * this.fontScale);
                StyleConstants.setFontSize(attrs, sz);
                break;
            }
            case 7: {
                boolean bold = (value & 1) != 0;
                boolean italic = (value & 2) != 0;
                StyleConstants.setBold(attrs, bold);
                StyleConstants.setItalic(attrs, italic);
                break;
            }
            case 0: {
                if (value == 1) {
                    StyleConstants.setSubscript(attrs, true);
                    StyleConstants.setSuperscript(attrs, false);
                    break;
                }
                if (value == 2) {
                    StyleConstants.setSubscript(attrs, false);
                    StyleConstants.setSuperscript(attrs, true);
                    break;
                }
                StyleConstants.setSubscript(attrs, false);
                StyleConstants.setSuperscript(attrs, false);
            }
        }
        return attrs;
    }

    protected SimpleAttributeSet getAttribute(boolean value, int ID) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        switch (ID) {
            case 8: {
                StyleConstants.setBold(attrs, value);
                break;
            }
            case 9: {
                StyleConstants.setItalic(attrs, value);
                break;
            }
            case 1: {
                StyleConstants.setSuperscript(attrs, value);
                break;
            }
            case 2: {
                StyleConstants.setSubscript(attrs, value);
            }
        }
        return attrs;
    }

    protected SimpleAttributeSet getAttributes(RichTextInterface rti) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        Font f = rti.getFont();
        StyleConstants.setForeground(attrs, rti.getFontColor());
        StyleConstants.setFontFamily(attrs, f.getFamily());
        StyleConstants.setBold(attrs, f.isBold());
        StyleConstants.setItalic(attrs, f.isItalic());
        int size = f.getSize();
        if (this.cti != null) {
            size = this.cti.getComputedFontSize(size);
        }
        size = (int)Math.floor((double)size * this.fontScale);
        StyleConstants.setFontSize(attrs, size);
        StyleConstants.setSuperscript(attrs, rti.isSuperscript());
        StyleConstants.setSubscript(attrs, rti.isSubscript());
        return attrs;
    }

    public boolean isSubscript() {
        boolean sub = StyleConstants.isSubscript((AttributeSet)this.curAttrs.get(0));
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            boolean ss = StyleConstants.isSubscript((AttributeSet)this.curAttrs.get(i));
            if (ss == sub) continue;
            return false;
        }
        return sub;
    }

    public boolean isSuperscript() {
        boolean sup = StyleConstants.isSuperscript((AttributeSet)this.curAttrs.get(0));
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            boolean ss = StyleConstants.isSuperscript((AttributeSet)this.curAttrs.get(i));
            if (ss == sup) continue;
            return false;
        }
        return sup;
    }

    public void setSuperscript(boolean value) {
        this._setProperty(1, new Boolean(value));
    }

    public void setSubscript(boolean value) {
        this._setProperty(2, new Boolean(value));
    }

    @Override
    public Color getFontColor() {
        if (!this.ready) {
            return super.getForeground();
        }
        this._setCurrentAttrs();
        Color c = StyleConstants.getForeground((AttributeSet)this.curAttrs.get(0));
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            Color cc = StyleConstants.getForeground((AttributeSet)this.curAttrs.get(i));
            if (cc.getRGB() == c.getRGB()) continue;
            return null;
        }
        return c;
    }

    @Override
    public Font getFont() {
        if (!this.ready) {
            return super.getFont();
        }
        this._setCurrentAttrs();
        AttributeSet set = (AttributeSet)this.curAttrs.get(0);
        int style = 0;
        Object obj = set.getAttribute(StyleConstants.Bold);
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            style |= 1;
        }
        if ((obj = set.getAttribute(StyleConstants.Italic)) instanceof Boolean && ((Boolean)obj).booleanValue()) {
            style |= 2;
        }
        int size = StyleConstants.getFontSize(set);
        int csize = size = (int)Math.ceil((double)size / this.fontScale);
        if (this.cti != null) {
            while (this.cti.getComputedFontSize(csize) > size) {
                --csize;
            }
        }
        return new Font(StyleConstants.getFontFamily(set), style, csize);
    }

    @Override
    public RichTextInterface[] getRichText() {
        return Util.getRichText(this, this.cti, this.fontScale);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
    }

    @Override
    public String getFontFamily() {
        this._setCurrentAttrs();
        String family = StyleConstants.getFontFamily((AttributeSet)this.curAttrs.get(0));
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            String ff = StyleConstants.getFontFamily((AttributeSet)this.curAttrs.get(i));
            if (ff.equals(family)) continue;
            return "";
        }
        return family;
    }

    @Override
    public void setFontFamily(String family) {
        this._setProperty(5, family);
    }

    @Override
    public int getFontSize() {
        this._setCurrentAttrs();
        int fsize = StyleConstants.getFontSize((AttributeSet)this.curAttrs.get(0));
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            int fsize2 = StyleConstants.getFontSize((AttributeSet)this.curAttrs.get(i));
            if (fsize == fsize2) continue;
            return -1;
        }
        int csize = fsize = (int)Math.ceil((double)fsize / this.fontScale);
        if (this.cti != null) {
            while (this.cti.getComputedFontSize(csize) > fsize) {
                --csize;
            }
        }
        return csize;
    }

    @Override
    public void setFontSize(int size) {
        this._setProperty(6, new Integer(size));
    }

    @Override
    public boolean isBold() {
        this._setCurrentAttrs();
        boolean bold = StyleConstants.isBold((AttributeSet)this.curAttrs.get(0));
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            boolean bb = StyleConstants.isBold((AttributeSet)this.curAttrs.get(i));
            if (bb == bold) continue;
            return false;
        }
        return bold;
    }

    @Override
    public void setBold(boolean bold) {
        this._setProperty(8, new Boolean(bold));
    }

    @Override
    public boolean isItalic() {
        this._setCurrentAttrs();
        boolean italic = StyleConstants.isItalic((AttributeSet)this.curAttrs.get(0));
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            boolean ii = StyleConstants.isItalic((AttributeSet)this.curAttrs.get(i));
            if (ii == italic) continue;
            return false;
        }
        return italic;
    }

    @Override
    public void setItalic(boolean italic) {
        this._setProperty(9, new Boolean(italic));
    }

    @Override
    public int getFontStyle() {
        this._setCurrentAttrs();
        int style = 0;
        AttributeSet as = (AttributeSet)this.curAttrs.get(0);
        if (StyleConstants.isBold(as)) {
            style |= 1;
        }
        if (StyleConstants.isItalic(as)) {
            style |= 2;
        }
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            int ss = 0;
            AttributeSet as2 = (AttributeSet)this.curAttrs.get(i);
            if (StyleConstants.isBold(as2)) {
                ss |= 1;
            }
            if (StyleConstants.isItalic(as2)) {
                ss |= 2;
            }
            if (ss == style) continue;
            return -1;
        }
        return style;
    }

    @Override
    public void setFontStyle(int style) {
        this._setProperty(7, new Integer(style));
    }

    public int getEffects() {
        int effect = 0;
        this._setCurrentAttrs();
        AttributeSet as = (AttributeSet)this.curAttrs.get(0);
        if (StyleConstants.isSubscript(as)) {
            effect = 1;
        } else if (StyleConstants.isSuperscript(as)) {
            effect = 2;
        }
        for (int i = 1; i < this.curAttrs.size(); ++i) {
            int ee = 0;
            AttributeSet as2 = (AttributeSet)this.curAttrs.get(i);
            if (StyleConstants.isSubscript(as2)) {
                ee = 1;
            } else if (StyleConstants.isSuperscript(as2)) {
                ee = 2;
            }
            if (ee == effect) continue;
            return -1;
        }
        return effect;
    }

    public void setEffects(int effect) {
        this._setProperty(0, new Integer(effect));
    }

    @Override
    public void setRichText(RichTextInterface[] text) {
        StyledDocument doc = this.getStyledDocument();
        int len = doc.getLength();
        try {
            if (doc instanceof AbstractDocument) {
                DocumentListener[] list = ((AbstractDocument)((Object)doc)).getDocumentListeners();
                for (int i = 0; i < list.length; ++i) {
                    if (!(list[i] instanceof MyDocumentListener)) continue;
                    doc.removeDocumentListener(list[i]);
                }
            }
            this.removeCaretListener(this);
            doc.remove(0, len);
        }
        catch (BadLocationException be) {
            doc = new DefaultStyledDocument();
            this.setStyledDocument(doc);
        }
        this.initDocument(text);
        this.setCaretPosition(doc.getLength());
        this.curAttrs.clear();
        this.curAttrs.add(this.getAttributes(text[text.length - 1]));
        this.getStyledDocument().addDocumentListener(this.listener);
        Rectangle b = this.getBounds();
        Dimension s = this.getPreferredSize();
        s.width += 4;
        s.height = Math.max(s.height, b.height);
        try {
            if (doc.getText(0, doc.getLength()).indexOf(13) != -1) {
                s.height /= 2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (s.width != b.width || s.height > b.height) {
            if (this.align == 0) {
                this.setBounds(b.x + (b.width - s.width) / 2, b.y, s.width, s.height);
            } else if (this.align == 4) {
                this.setBounds(b.x + b.width - s.width, b.y, s.width, s.height);
            } else {
                this.setBounds(b.x, b.y, s.width, s.height);
            }
        }
        this.addCaretListener(this);
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(double fontScale) {
        this.fontScale = fontScale;
    }

    public void undoPropertyChange() {
        this.setRichText(this.lastText);
        this.setBounds(this.lastBounds);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int value = this.getText().length();
        if (!this.processing && value > 512) {
            String message = RB.getStringResource("invalid.txt");
            JOptionPane.showMessageDialog(this.getTextPane().getParent(), message, RB.getStringResource("warning.txt"), 2);
        }
        this.processing = true;
        while (value > 512 && this.undo.canUndo()) {
            this.undo.undo();
            value = this.getText().length();
        }
        this.processing = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int eoffset = e.getOffset();
            Document doc = e.getDocument();
            try {
                if (doc.getText(eoffset, 1).equals(String.valueOf(13))) {
                    SGTextPane.this.ready = false;
                    doc.removeDocumentListener(this);
                    SGTextPane.this.setVisible(false);
                    return;
                }
            }
            catch (BadLocationException ble) {
                System.err.println("SGTextField: insertUpdate()");
                ble.printStackTrace();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    class MyEnter
    extends DefaultEditorKit.DefaultKeyTypedAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof SGTextPane) {
                SGTextPane tp = (SGTextPane)source;
                tp.exit();
            }
            super.actionPerformed(e);
        }
    }
}

