/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.util;

import com.sas.graphics.sg.interfaces.ComputedTextInterface;
import com.sas.graphics.sg.interfaces.DefaultTextInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.util.RB;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class SGTextField
extends JComponent
implements TextInterface,
KeyListener,
ActionListener,
MouseListener,
MouseMotionListener {
    static final Color selectionColor = new JTextField().getSelectionColor();
    static final Color backColor = UIManager.getColor("TextPane.background");
    public static int MINOR_PADDING = 4;
    public static int MAJOR_PADDING = 8;
    public static String BLANK = " ";
    protected Color caretColor = Color.gray;
    protected double fontScale = 1.0;
    TextInterface style;
    DefaultTextInterface dti;
    String text;
    protected int caretPosition = 0;
    protected int selectAnchor = -1;
    protected Point curPosition;
    protected FontRenderContext frc = null;
    protected TextLayout tl = null;
    protected AttributedString as = null;
    protected AffineTransform at = null;
    protected int anchor = 3;
    protected String savedText;
    protected Point minOrigin;
    double theta = 0.0;
    boolean formatingEnabled = false;
    protected int prevx;
    protected int prevy;
    Font saveFont = null;
    private boolean drag = false;
    private boolean firstModification = true;
    boolean discardChange = false;

    public SGTextField(ComponentListener parent, String text, TextInterface style, double fontScale) {
        Color c;
        Font f;
        this.fontScale = fontScale;
        this.style = style;
        if (style instanceof DefaultTextInterface) {
            this.dti = (DefaultTextInterface)((Object)style);
        }
        Font font = f = style instanceof ComputedTextInterface ? ((ComputedTextInterface)((Object)style)).getComputedFont(null) : style.getFont();
        if (f == null && this.dti != null) {
            f = this.dti.getDefaultFont();
        }
        if (f != null) {
            int size = f.getSize();
            int scaledSize = (int)Math.ceil(fontScale * (double)size);
            f = new Font(f.getFamily(), f.getStyle(), scaledSize);
            this.setFont(f);
        }
        if ((c = style.getFontColor()) == null && this.dti != null) {
            c = this.dti.getDefaultFontColor();
        }
        if (c != null) {
            this.setForeground(c);
        }
        this.setBackground(backColor);
        this.text = text;
        this.savedText = text;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (parent != null) {
            this.addComponentListener(parent);
        }
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
    }

    protected final void _drawCaret(Graphics2D gc) {
        TextHitInfo thi;
        if (this.caretPosition == -1 && (thi = this.tl.hitTestChar(this.prevx, this.prevy)) != null) {
            this.caretPosition = thi.getInsertionIndex();
        }
        if (this.caretPosition > this.text.length()) {
            this.caretPosition = this.text.length();
        }
        if (this.selectAnchor > this.text.length()) {
            this.selectAnchor = this.text.length();
        }
        Shape[] carets = this.tl.getCaretShapes(this.caretPosition);
        if (this.selectAnchor != -1 && this.selectAnchor != this.caretPosition) {
            gc.setColor(this.getForeground());
            Shape selection = this.tl.getLogicalHighlightShape(0, this.text.length());
            Rectangle r = selection.getBounds();
            r.x -= 4;
            r.width += 8;
            gc.fill(r);
            Graphics2D g2 = (Graphics2D)gc.create();
            g2.setClip(selection);
            AttributedString as = new AttributedString(this.text);
            as.addAttribute(TextAttribute.FONT, this.getFont());
            as.addAttribute(TextAttribute.FOREGROUND, this.getBackground());
            TextLayout tl = new TextLayout(as.getIterator(), this.frc);
            tl.draw(g2, 0.0f, 0.0f);
            g2.dispose();
        } else {
            gc.setColor(this.caretColor);
            gc.draw(carets[0]);
        }
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String text) {
        if (text.length() > 256) {
            text = text.substring(0, 256);
        }
        this.text = text;
        this.tl = null;
    }

    public final void setStartingText(String text) {
        this.text = text;
        this.savedText = text;
        this.tl = null;
        this.sizeUpdate();
    }

    public final void setSelectAll(boolean select) {
        if (select) {
            this.caretPosition = 0;
            this.selectAnchor = this.text.length();
        } else {
            this.selectAnchor = -1;
        }
    }

    protected final void checkTextLayout() {
        if (this.frc == null) {
            Graphics2D g2d = (Graphics2D)this.getGraphics().create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.frc = ((Graphics2D)this.getGraphics()).getFontRenderContext();
        }
        if (this.tl == null) {
            this.as = this.text == null || this.text.length() == 0 ? new AttributedString(BLANK) : new AttributedString(this.text);
            Font f = this.getFont();
            Color cc = this.selectAnchor != -1 && this.selectAnchor != this.caretPosition ? this.getBackground() : this.getForeground();
            this.as.addAttribute(TextAttribute.FONT, f);
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            this.tl = new TextLayout(this.as.getIterator(), this.frc);
        }
    }

    void insertChar(char c) {
        if (c == '\r' || c == '\n') {
            return;
        }
        if (this.text != null && this.text.length() == 256) {
            this.text = this.text.substring(0, 256);
            String message = RB.getStringResource("invalid.txt");
            JOptionPane.showMessageDialog(this.getParent(), message, RB.getStringResource("warning.txt"), 2);
            return;
        }
        if (this.text == null || this.text.length() == 0 || this.selectAnchor != -1 && this.selectAnchor != this.caretPosition) {
            this.text = Character.toString(c);
            this.selectAnchor = -1;
            this.caretPosition = 1;
        } else {
            this.text = this.text.substring(0, this.caretPosition) + c + this.text.substring(this.caretPosition);
            ++this.caretPosition;
        }
        int index = this.text.indexOf("\\u");
        if (index != -1 && index + 6 <= this.text.length()) {
            try {
                String code = this.text.substring(index + 2, index + 6);
                char ch = (char)Integer.parseInt(code, 16);
                this.text = new String(index > 0 ? this.text.substring(0, index) : "").concat(Character.toString(ch)).concat(index + 6 < this.text.length() ? this.text.substring(index + 6) : "");
                this.caretPosition -= 5;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.tl = null;
        this.sizeUpdate();
        this.formatingEnabled = false;
    }

    void deleteChar(boolean forward) {
        Color cc = this.getForeground();
        if (this.selectAnchor != -1 && this.selectAnchor != this.caretPosition) {
            this.text = "";
            this.as = new AttributedString(BLANK);
            this.as.addAttribute(TextAttribute.FONT, this.getFont());
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            this.tl = new TextLayout(this.as.getIterator(), this.frc);
            this.caretPosition = 0;
        } else if (this.text != null) {
            if (forward && this.caretPosition < this.text.length()) {
                if (this.text.length() == 1) {
                    this.text = "";
                    this.as = new AttributedString(BLANK);
                    this.as.addAttribute(TextAttribute.FONT, this.getFont());
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    this.tl = new TextLayout(this.as.getIterator(), this.frc);
                } else {
                    this.text = this.caretPosition == 0 ? this.text.substring(1) : this.text.substring(0, this.caretPosition).concat(this.text.substring(this.caretPosition + 1));
                    this.as = new AttributedString(this.text);
                    this.as.addAttribute(TextAttribute.FONT, this.getFont());
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    this.tl = new TextLayout(this.as.getIterator(), this.frc);
                }
            } else if (!forward && this.caretPosition > 0) {
                if (this.text.length() == 1) {
                    this.text = "";
                    this.caretPosition = 0;
                    this.as = new AttributedString(BLANK);
                    this.as.addAttribute(TextAttribute.FONT, this.getFont());
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    this.tl = new TextLayout(this.as.getIterator(), this.frc);
                } else {
                    this.text = this.caretPosition == this.text.length() ? this.text.substring(0, this.caretPosition - 1) : this.text.substring(0, this.caretPosition - 1).concat(this.text.substring(this.caretPosition));
                    this.as = new AttributedString(this.text);
                    this.as.addAttribute(TextAttribute.FONT, this.getFont());
                    this.as.addAttribute(TextAttribute.FOREGROUND, cc);
                    --this.caretPosition;
                    this.tl = new TextLayout(this.as.getIterator(), this.frc);
                }
            }
        }
        this.selectAnchor = -1;
        this.formatingEnabled = this.text == null || this.text.length() == 0;
    }

    public final void setCaretPosition(int x, int y) {
        TextHitInfo thi;
        Point p = this.getTransformedPoint(x, y);
        if (this.frc == null) {
            this.caretPosition = -1;
            this.selectAnchor = -1;
            this.prevx = p.x;
            this.prevy = p.y;
            return;
        }
        if (this.text == null || this.text.length() == 0) {
            this.caretPosition = 0;
            this.selectAnchor = -1;
            return;
        }
        if (this.tl == null) {
            this.as = new AttributedString(this.text);
            Font f = this.getFont();
            this.as.addAttribute(TextAttribute.FONT, f);
            Color cc = this.getForeground();
            this.as.addAttribute(TextAttribute.FOREGROUND, cc);
            this.tl = new TextLayout(this.as.getIterator(), this.frc);
        }
        if ((thi = this.tl.hitTestChar(p.x, p.y)) != null) {
            this.caretPosition = thi.getInsertionIndex();
        }
        if (this.caretPosition > this.text.length()) {
            this.caretPosition = this.text.length();
        }
        if (this.selectAnchor != -1 && this.selectAnchor != this.caretPosition) {
            this.formatingEnabled = true;
        }
    }

    private Point getTransformedPoint(int x, int y) {
        if (this.theta == 0.0 || this.theta == 180.0) {
            return new Point(x - MAJOR_PADDING, y - MINOR_PADDING);
        }
        if (this.theta == 90.0) {
            return new Point(this.getHeight() - y - MAJOR_PADDING, x - MINOR_PADDING);
        }
        return new Point(y - MAJOR_PADDING, this.getWidth() - x - MINOR_PADDING);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.formatingEnabled = false;
        if (arg0.isPopupTrigger()) {
            return;
        }
        int x = arg0.getX();
        int y = arg0.getY();
        int count = arg0.getClickCount();
        if (!arg0.isShiftDown()) {
            this.selectAnchor = -1;
        }
        switch (count) {
            default: {
                this.setCaretPosition(x, y);
                this.formatingEnabled = this.text == null || this.text.length() == 0;
                break;
            }
            case 2: 
            case 3: {
                this.selectAnchor = 0;
                this.caretPosition = this.text.length();
                this.formatingEnabled = true;
            }
        }
        this.scrollToCaret();
        this.repaint();
    }

    public void setCaretAtEnd() {
        this.caretPosition = this.text.length();
        this.selectAnchor = -1;
    }

    public boolean isFormattingEnabled() {
        return this.formatingEnabled;
    }

    final void setSelectCaretAnchor(int x, int y) {
        this.setCaretPosition(x, y);
        this.prevx = x;
        this.prevy = y;
        this.selectAnchor = this.caretPosition;
    }

    @Override
    public final void keyTyped(KeyEvent e) {
        this.processEvent(e);
    }

    @Override
    public final void keyPressed(KeyEvent e) {
    }

    @Override
    public final void keyReleased(KeyEvent e) {
        this.processEvent(e);
    }

    protected final void processEvent(KeyEvent e) {
        int kid = e.getID();
        if (kid == 400) {
            char ch = e.getKeyChar();
            if (Character.isIdentifierIgnorable(ch)) {
                return;
            }
            this.insertChar(ch);
        } else {
            int keyCode = e.getKeyCode();
            boolean extsel = this.selectAnchor != -1 && this.selectAnchor != this.caretPosition;
            switch (keyCode) {
                case 8: {
                    this.deleteChar(false);
                    break;
                }
                case 127: {
                    this.deleteChar(true);
                    break;
                }
                case 37: {
                    if (extsel) {
                        this.caretPosition = 0;
                    } else if (this.caretPosition > 0) {
                        --this.caretPosition;
                    }
                    this.selectAnchor = -1;
                    break;
                }
                case 39: {
                    if (extsel) {
                        this.caretPosition = this.text.length();
                    } else if (this.caretPosition < this.text.length()) {
                        ++this.caretPosition;
                    }
                    this.selectAnchor = -1;
                    break;
                }
                case 38: {
                    if (this.theta == 270.0 && this.caretPosition > 0) {
                        this.caretPosition = extsel ? 0 : --this.caretPosition;
                    } else if (this.theta == 90.0 && this.caretPosition < this.text.length()) {
                        this.caretPosition = extsel ? this.text.length() : ++this.caretPosition;
                    }
                    this.selectAnchor = -1;
                    break;
                }
                case 40: {
                    if (this.theta == 270.0 && this.caretPosition < this.text.length()) {
                        this.caretPosition = extsel ? this.text.length() : ++this.caretPosition;
                    } else if (this.theta == 90.0 && this.caretPosition > 0) {
                        if (extsel) {
                            this.caretPosition = 0;
                        } else if (this.caretPosition > 0) {
                            --this.caretPosition;
                        }
                    }
                    this.selectAnchor = -1;
                    break;
                }
                case 36: {
                    this.caretPosition = 0;
                    this.selectAnchor = -1;
                    break;
                }
                case 35: {
                    this.caretPosition = this.getText().length();
                    this.selectAnchor = -1;
                    break;
                }
                case 10: {
                    this.exit();
                    break;
                }
            }
        }
        this.scrollToCaret();
        this.repaint();
    }

    final void deleteText() {
        if (this.text == null || this.text.equals("")) {
            return;
        }
        this.tl = null;
        this.caretPosition = 0;
        this.curPosition = null;
        this.text = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.tl == null) {
            this.checkTextLayout();
        }
        Rectangle2D r = this.tl.getBounds();
        float advance = this.tl.getAdvance();
        if (this.savedText != this.text) {
            AttributedString aas = this.savedText == null || this.savedText.length() == 0 ? new AttributedString(BLANK) : new AttributedString(this.savedText);
            Font f = this.getFont();
            aas.addAttribute(TextAttribute.FONT, f);
            TextLayout stl = new TextLayout(aas.getIterator(), this.frc);
            Rectangle2D sr = stl.getBounds();
            r.setRect(r.getX(), r.getY(), Math.max(r.getWidth(), sr.getWidth()), Math.max(r.getHeight(), sr.getHeight()));
            advance = Math.max(stl.getAdvance(), advance);
        }
        int twidth = (int)advance + 2 * MAJOR_PADDING;
        int theight = (int)Math.ceil(Math.max(r.getHeight(), Math.ceil(this.tl.getAscent()) + Math.ceil(this.tl.getDescent()) + (double)(2 * MINOR_PADDING)));
        if (this.theta == 0.0) {
            return new Dimension(twidth, theight);
        }
        return new Dimension(theight, twidth);
    }

    private void sizeUpdate() {
        Rectangle b = this.getBounds();
        Dimension s = this.getPreferredSize();
        Dimension m = this.getMinimumSize();
        int w = Math.max(s.width, m.width);
        int h = Math.max(s.height, m.height);
        if (this.theta == 0.0) {
            if (s.width < m.width || this.savedText != null && this.savedText.length() > this.text.length()) {
                this.setBounds(this.minOrigin.x, this.minOrigin.y, w, h);
            } else if (this.anchor == 1) {
                this.setBounds(b.x + (b.width - w) / 2, b.y, w, h);
            } else {
                this.setBounds(b.x + (b.width - w) / 2, b.y + (b.height - h), w, h);
            }
        } else if (s.height < m.height || this.savedText != null && this.savedText.length() > this.text.length()) {
            this.setBounds(this.minOrigin.x, this.minOrigin.y, w, h);
        } else if (this.anchor == 2) {
            this.setBounds(b.x, b.y + (b.height - h) / 2, w, h);
        } else {
            this.setBounds(b.x + (b.width - w), b.y + (b.height - h) / 2, w, h);
        }
        this.scrollToCaret();
    }

    private void scrollToCaret() {
        if (this.frc == null || this.text.length() < 2 || this.formatingEnabled) {
            return;
        }
        Container parent = this.getParent();
        Rectangle b = this.getBounds();
        if (this.theta == 0.0 && parent.getWidth() > b.width + 20) {
            return;
        }
        if (this.theta != 0.0 && parent.getHeight() > b.height + 20) {
            return;
        }
        if (this.tl == null) {
            this.checkTextLayout();
        }
        Rectangle2D r2 = this.tl.getBounds();
        float advance = this.tl.getAdvance();
        Rectangle cb = this.tl.getCaretShapes(this.caretPosition)[0].getBounds();
        if (this.theta == 90.0) {
            AffineTransform at = new AffineTransform();
            at.rotate(-1.5707963267948966);
            at.translate(-b.height, 0.0);
            at.translate(((float)b.height - advance) / 2.0f, ((double)b.width - r2.getHeight()) / 2.0);
            Point2D.Double p1 = new Point2D.Double(cb.getX(), cb.getY());
            Point2D.Double p2 = new Point2D.Double();
            at.transform(p1, p2);
            int x = (int)(Math.max(0.0, ((Point2D)p2).getX()) + (double)this.getX());
            int y = (int)(((Point2D)p2).getY() + (double)this.getY());
            int y1 = y + 20;
            int y2 = y - 20;
            if (!parent.contains(x, y2) || !parent.contains(x, y1)) {
                if (y2 < parent.getY()) {
                    b.translate(0, parent.getY() - y2);
                } else {
                    b.translate(0, parent.getY() + parent.getHeight() - y1);
                }
                this.setBounds(b);
            }
        } else {
            Point2D.Double p = new Point2D.Double(cb.getX(), cb.getY());
            int x = (int)(((Point2D)p).getX() + (double)this.getX());
            int x1 = x + 20;
            int x2 = x - 20;
            int y = (int)(((Point2D)p).getY() + (double)this.getY());
            if (!parent.contains(x1, y) || !parent.contains(x2, y)) {
                if (x2 < parent.getX()) {
                    b.translate(parent.getX() - x2, 0);
                } else {
                    b.translate(parent.getX() + parent.getWidth() - x1, 0);
                }
                this.setBounds(b);
            }
        }
    }

    public void setAnchorLocation(int anchor) {
        this.anchor = anchor;
    }

    void exit() {
        this.setVisible(false);
    }

    @Override
    public void setFontColor(Color c) {
        this.discardChange = false;
        this.style.setFontColor(c);
        if (this.discardChange) {
            return;
        }
        this.setForeground(c);
        this.savedText = this.text != null && this.text.length() > 0 ? this.text : BLANK;
        this.firstModification = false;
        this.tl = null;
    }

    @Override
    public Color getFontColor() {
        return super.getForeground();
    }

    @Override
    public String getFontFamily() {
        String family = this.style.getFontFamily();
        if ((family == null || family.length() == 0) && this.dti != null) {
            family = this.dti.getDefaultFontFamily();
        }
        return family;
    }

    @Override
    public void setFontFamily(String family) {
        this.discardChange = false;
        this.saveFont = this.style.getFont();
        this.style.setFontFamily(family);
        if (this.discardChange) {
            return;
        }
        this.savedText = this.text != null && this.text.length() > 0 ? this.text : BLANK;
        this.firstModification = false;
        Font f = super.getFont();
        if ((family == null || family.length() == 0) && this.dti != null) {
            family = this.dti.getDefaultFontFamily();
        }
        f = new Font(family, f.getStyle(), f.getSize());
        this.setFont(f);
        this.tl = null;
        this.sizeUpdate();
    }

    @Override
    public int getFontSize() {
        int sz = this.style.getFontSize();
        if (sz == -1 && this.dti != null) {
            sz = this.dti.getDefaultFontSize();
        }
        return sz;
    }

    @Override
    public void setFontSize(int size) {
        this.discardChange = false;
        this.saveFont = this.style.getFont();
        if (this.saveFont == null) {
            this.saveFont = this.dti.getDefaultFont();
        }
        this.style.setFontSize(size);
        if (this.discardChange) {
            return;
        }
        this.savedText = this.text != null && this.text.length() > 0 ? this.text : BLANK;
        this.firstModification = false;
        if (size == -1 && this.dti != null) {
            size = this.dti.getDefaultFontSize();
        }
        Font f = super.getFont();
        if (this.style instanceof ComputedTextInterface) {
            size = ((ComputedTextInterface)((Object)this.style)).getComputedFontSize(-1);
        }
        f = new Font(f.getFamily(), f.getStyle(), (int)Math.ceil((double)size * this.fontScale));
        this.setFont(f);
        this.tl = null;
        this.sizeUpdate();
    }

    @Override
    public boolean isBold() {
        return super.getFont().isBold();
    }

    @Override
    public void setBold(boolean bold) {
        int style;
        this.discardChange = false;
        this.saveFont = this.style.getFont();
        if (this.saveFont == null) {
            this.saveFont = this.dti.getDefaultFont();
        }
        this.style.setBold(bold);
        if (this.discardChange) {
            return;
        }
        this.savedText = this.text != null && this.text.length() > 0 ? this.text : BLANK;
        this.firstModification = false;
        Font f = super.getFont();
        int n = style = f.isItalic() ? 2 : 0;
        if (bold) {
            style |= 1;
        }
        f = new Font(f.getFamily(), style, f.getSize());
        this.setFont(f);
        this.tl = null;
        this.sizeUpdate();
    }

    @Override
    public boolean isItalic() {
        return super.getFont().isItalic();
    }

    @Override
    public void setItalic(boolean italic) {
        int style;
        this.discardChange = false;
        this.saveFont = this.style.getFont();
        if (this.saveFont == null) {
            this.saveFont = this.dti.getDefaultFont();
        }
        this.style.setItalic(italic);
        if (this.discardChange) {
            return;
        }
        this.savedText = this.text != null && this.text.length() > 0 ? this.text : BLANK;
        this.firstModification = false;
        Font f = super.getFont();
        int n = style = italic ? 2 : 0;
        if (f.isBold()) {
            style |= 1;
        }
        f = new Font(f.getFamily(), style, f.getSize());
        this.setFont(f);
        this.tl = null;
        this.sizeUpdate();
    }

    @Override
    public int getFontStyle() {
        int ss = this.style.getFontStyle();
        if (ss == -1 && this.dti != null) {
            ss = this.dti.getDefaultFontStyle();
        }
        return ss;
    }

    @Override
    public void setFontStyle(int s) {
        this.discardChange = false;
        this.saveFont = this.style.getFont();
        if (this.saveFont == null) {
            this.saveFont = this.dti.getDefaultFont();
        }
        this.style.setFontStyle(s);
        if (this.discardChange) {
            return;
        }
        this.savedText = this.text != null && this.text.length() > 0 ? this.text : BLANK;
        this.firstModification = false;
        Font f = super.getFont();
        this.setFont(new Font(f.getFamily(), s, f.getSize()));
        this.tl = null;
        this.sizeUpdate();
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle r = this.getBounds();
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.selectAnchor != -1 && this.selectAnchor != this.caretPosition) {
            g2d.setColor(this.getForeground());
        } else {
            g2d.setColor(this.getBackground());
        }
        g2d.fillRect(0, 0, r.width, r.height);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.tl == null) {
            if (this.frc == null) {
                this.frc = g2d.getFontRenderContext();
            }
            this.checkTextLayout();
        }
        Rectangle2D r2 = this.tl.getBounds();
        int advance = (int)Math.ceil(this.tl.getAdvance());
        if (this.theta == 90.0) {
            g2d.rotate(-1.5707963267948966);
            g2d.translate(-r.height, 0);
            g2d.translate((double)((r.height - advance) / 2), ((double)r.width - r2.getHeight()) / 2.0);
        } else if (this.theta == 270.0) {
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -r.width);
            g2d.translate((double)((r.height - advance) / 2), ((double)r.width - r2.getHeight()) / 2.0);
        } else {
            g2d.translate((double)((r.width - advance) / 2), ((double)r.height - r2.getHeight()) / 2.0);
        }
        g2d.translate(0, (int)Math.ceil(-r2.getY()));
        this.tl.draw(g2d, 0.0f, 0.0f);
        this._drawCaret(g2d);
        g2d.dispose();
    }

    public void setTheta(double theta) {
        this.theta = theta;
        if (theta == 90.0 || theta == 270.0) {
            Border bd = this.getBorder();
            if (bd instanceof EmptyBorder) {
                Insets in = this.getInsets();
                if (theta == 90.0) {
                    this.setBorder(new EmptyBorder(in.left, in.bottom, in.right, in.top));
                } else {
                    this.setBorder(new EmptyBorder(in.right, in.top, in.left, in.bottom));
                }
            } else if (bd instanceof CompoundBorder) {
                CompoundBorder cb = (CompoundBorder)bd;
                EmptyBorder eb = (EmptyBorder)cb.getInsideBorder();
                Insets in = eb.getBorderInsets();
                CompoundBorder ncb = theta == 90.0 ? new CompoundBorder(cb.getOutsideBorder(), new EmptyBorder(in.left, in.bottom, in.right, in.top)) : new CompoundBorder(cb.getOutsideBorder(), new EmptyBorder(in.right, in.top, in.left, in.bottom));
                this.setBorder(ncb);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this) {
            this.exit();
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (!this.drag) {
            this.setSelectCaretAnchor(arg0.getX(), arg0.getY());
            this.drag = true;
        } else {
            this.setCaretPosition(arg0.getX(), arg0.getY());
            this.formatingEnabled = this.selectAnchor != this.caretPosition;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.drag = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean isTextModified() {
        return this.savedText != this.text;
    }

    public boolean isFirstModification() {
        return this.firstModification;
    }

    public void undoPropertyChange() {
        this.discardChange = true;
        this.style.setFont(this.saveFont);
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public int getMarkPosition() {
        return this.selectAnchor;
    }

    public Point getMinimumOrigin() {
        return this.minOrigin;
    }

    public void setMinimumOrigin(Point minOrigin) {
        this.minOrigin = minOrigin;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
    }
}

