/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.util;

import com.sas.graphics.sg.util.RB;
import com.sas.text.Message;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class GraphFileFilter
extends FileFilter {
    public static final String RB_KEY = "GraphFileFilter.";
    public static final int GDF_FILE = 0;
    public static final int SAS_FILE = 1;
    public static final int GIF_FILE = 2;
    public static final int PNG_FILE = 3;
    public static final int BMP_FILE = 4;
    public static final int TIF_FILE = 5;
    public static final int EPS_FILE = 6;
    public static final int JPG_FILE = 7;
    public static final int XML_FILE = 8;
    public static final int SGE_FILE = 9;
    public static final int IMAGE_FILES = 10;
    public static final int SGE_OPEN = 11;
    public static final int SGE_SAVE = 12;
    public static final int ALL_FILE = 13;
    int type;

    public GraphFileFilter(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = GraphFileFilter.getExtension(f);
        if (extension != null) {
            switch (this.type) {
                case 0: {
                    return extension.equals("gdf");
                }
                case 3: {
                    return extension.equals("png");
                }
                case 4: {
                    return extension.equals("bmp");
                }
                case 2: {
                    return extension.equals("gif");
                }
                case 6: {
                    return extension.equals("ps");
                }
                case 7: {
                    return extension.equals("jpeg") || extension.equals("jpg");
                }
                case 5: {
                    return extension.equals("tif");
                }
                case 1: {
                    return extension.equals("sas");
                }
                case 8: {
                    return extension.equals("xml");
                }
                case 9: {
                    return extension.equals("sge");
                }
                case 10: {
                    return extension.equals("png") || extension.equals("gif") || extension.equals("jpeg") || extension.equals("jpg");
                }
                case 12: {
                    return extension.equals("png") || extension.equals("sge");
                }
                case 11: {
                    return extension.equals("xml") || extension.equals("sge") || extension.equals("png") || extension.equals("gif") || extension.equals("jpeg") || extension.equals("jpg");
                }
                case 13: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        switch (this.type) {
            case 0: {
                return "GDF Files (*.gdf)";
            }
            case 3: {
                return RB.getStringResource(RB_KEY, "pngFile.txt");
            }
            case 4: {
                return "BMP Files (*.bmp)";
            }
            case 2: {
                return "GIF Files (*.gif)";
            }
            case 6: {
                return "PS Files (*.ps)";
            }
            case 7: {
                return "JPEG Files (*.jpeg, *.jpg)";
            }
            case 5: {
                return "TIF Files (*.tif)";
            }
            case 1: {
                return "SAS Files (*.sas)";
            }
            case 8: {
                return "XML Files (*.xml)";
            }
            case 10: {
                return "Image Files (*.png, *.gif, *.jpeg, *.jpg)";
            }
            case 9: {
                return Message.format((String)RB.getStringResource(RB_KEY, "editorFile.fmt.txt"), (Object)"*.sge");
            }
            case 12: {
                return Message.format((String)RB.getStringResource(RB_KEY, "editorFile.fmt.txt"), (Object)"*.sge, *.png");
            }
            case 11: {
                return Message.format((String)RB.getStringResource(RB_KEY, "editorFile.fmt.txt"), (Object)"*.sge, *.xml, *.png, *.gif, *.jpeg, *.jpg");
            }
            case 13: {
                return "All Files";
            }
        }
        return "GDF Files (*.gdf)";
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getFileName(File f) {
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0) {
            return s.substring(0, i);
        }
        return s;
    }

    public static String getExtension(int type) {
        switch (type) {
            case 0: {
                return "gdf";
            }
            case 3: {
                return "png";
            }
            case 4: {
                return "bmp";
            }
            case 2: {
                return "gif";
            }
            case 6: {
                return "ps";
            }
            case 7: {
                return "jpeg";
            }
            case 5: {
                return "tif";
            }
            case 1: {
                return "sas";
            }
            case 8: {
                return "xml";
            }
            case 9: 
            case 11: 
            case 12: {
                return "sge";
            }
            case 10: {
                return "png";
            }
            case 13: {
                return "";
            }
        }
        return "gdf";
    }
}

