/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.util;

import com.sas.graphics.sg.interfaces.CompositeTextInterface;
import com.sas.graphics.sg.interfaces.ComputedTextInterface;
import com.sas.graphics.sg.interfaces.RichTextInterface;
import com.sas.graphics.sg.ui.CharacterGrid;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.RB;
import com.sas.graphics.sg.util.SGTextPane;
import com.sas.graphics.sg.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;

public class CompositeTextPanel
extends JPanel
implements ActionListener,
ItemListener {
    static final Border empty = BorderFactory.createEmptyBorder(UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU);
    static final int[] SIZE_VALUES = new int[]{8, 10, 12, 14, 16, 18, 24};
    JComboBox fontName;
    JComboBox fontSize;
    SwatchComboBox color;
    JToggleButton bold;
    JToggleButton italic;
    JToggleButton sub;
    JToggleButton sup;
    MySGTextPane text;
    CharacterGrid grid;
    boolean ready;
    ColorGrabber colorGrabber;
    private JDialog dialog = null;

    public CompositeTextPanel(CompositeTextInterface textStyle, ComputedTextInterface cti, double fontScale) {
        this.init(textStyle, cti, fontScale);
    }

    public CompositeTextPanel(CompositeTextInterface textStyle, ComputedTextInterface cti, double fontScale, ColorGrabber cg) {
        this.colorGrabber = cg;
        this.init(textStyle, cti, fontScale);
    }

    protected void init(CompositeTextInterface textStyle, ComputedTextInterface cti, double fontScale) {
        this.setLayout(new BorderLayout());
        this.text = new MySGTextPane(textStyle, cti, fontScale);
        JToolBar toolbar = new JToolBar();
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontName = new JComboBox<String>(fontNames);
        this.fontName.setToolTipText(RB.getStringResource("family.txt"));
        Border border = this.fontName.getBorder();
        this.text.setBorder(border);
        CompoundBorder WIDGET_BORDER = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 2 * UIUtil.DLU, 0, 0));
        this.fontName.setEditable(false);
        this.fontName.setBorder(WIDGET_BORDER);
        this.fontName.setSelectedItem(this.text.getFontFamily());
        this.fontName.setActionCommand("name");
        this.fontName.addActionListener(this);
        toolbar.add(this.fontName);
        toolbar.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        int cursize = this.text.getFontSize();
        int len = 7;
        int[] SIZE_VALUES = new int[]{8, 10, 12, 14, 16, 18, 24};
        this.fontSize = new JComboBox();
        int ii = 0;
        boolean found = false;
        if (cursize < 0) {
            this.fontSize.insertItemAt("", 0);
            ii = 1;
            found = true;
            this.fontSize.setSelectedIndex(0);
        }
        for (int i = 0; i < len; ++i) {
            if (!found && cursize < SIZE_VALUES[i]) {
                this.fontSize.insertItemAt(Integer.toString(cursize), i);
                this.fontSize.setSelectedIndex(i);
                ii = 1;
                found = true;
            }
            this.fontSize.insertItemAt(Integer.toString(SIZE_VALUES[i]), i + ii);
            if (SIZE_VALUES[i] != cursize) continue;
            this.fontSize.setSelectedIndex(i);
            found = true;
        }
        if (!found) {
            this.fontSize.insertItemAt(Integer.toString(cursize), len);
            this.fontSize.setSelectedIndex(len);
        }
        this.fontSize.setEditable(false);
        this.fontSize.setToolTipText(RB.getStringResource("size.txt"));
        this.fontSize.setBorder(WIDGET_BORDER);
        this.fontSize.setActionCommand("size");
        this.fontSize.addActionListener(this);
        toolbar.add(this.fontSize);
        toolbar.add(Box.createRigidArea(new Dimension(2 * UIUtil.DLU, 0)));
        toolbar.addSeparator();
        toolbar.add(Box.createRigidArea(new Dimension(2 * UIUtil.DLU, 0)));
        String icon = RB.getStringResource("boldicon.txt");
        this.bold = new JToggleButton(new ImageIcon(Util.getImage(null, icon)));
        this.bold.setToolTipText(RB.getStringResource("bold.txt"));
        Font f = this.bold.getFont();
        this.bold.setFont(new Font(f.getFamily(), 1, f.getSize()));
        int fstyle = this.text.getFontStyle();
        if (fstyle != -1 && (fstyle & 1) != 0) {
            this.bold.setSelected(true);
        } else {
            this.bold.setSelected(false);
        }
        this.bold.setActionCommand("bold");
        this.bold.addActionListener(this);
        toolbar.add(this.bold);
        toolbar.add(Box.createRigidArea(new Dimension(UIUtil.DLU, 0)));
        icon = RB.getStringResource("italicicon.txt");
        this.italic = new JToggleButton(new ImageIcon(Util.getImage(null, icon)));
        this.italic.setToolTipText(RB.getStringResource("italic.txt"));
        this.italic.setFont(new Font(f.getFamily(), 3, f.getSize()));
        if (fstyle != -1 && (fstyle & 2) != 0) {
            this.italic.setSelected(true);
        } else {
            this.italic.setSelected(false);
        }
        this.italic.setActionCommand("italic");
        this.italic.addActionListener(this);
        toolbar.add(this.italic);
        toolbar.add(Box.createRigidArea(new Dimension(2 * UIUtil.DLU, 0)));
        toolbar.addSeparator();
        toolbar.add(Box.createRigidArea(new Dimension(2 * UIUtil.DLU, 0)));
        boolean isSub = this.text.isSubscript();
        boolean isSup = this.text.isSuperscript();
        this.sup = new JToggleButton(new ImageIcon(Util.getImage(null, "super.gif")));
        this.sup.setToolTipText(RB.getStringResource("sup.txt"));
        this.sup.setSelected(isSup);
        this.sup.setActionCommand("superscript");
        this.sup.addActionListener(this);
        toolbar.add(this.sup);
        toolbar.add(Box.createRigidArea(new Dimension(UIUtil.DLU, 0)));
        this.sub = new JToggleButton(new ImageIcon(Util.getImage(null, "sub.gif")));
        this.sub.setSelected(isSub);
        this.sub.setActionCommand("subscript");
        this.sub.addActionListener(this);
        this.sub.setToolTipText(RB.getStringResource("sub.txt"));
        toolbar.add(this.sub);
        toolbar.add(Box.createRigidArea(new Dimension(2 * UIUtil.DLU, 0)));
        toolbar.addSeparator();
        toolbar.add(Box.createRigidArea(new Dimension(2 * UIUtil.DLU, 0)));
        this.color = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, null, null, RB.getStringResource("morecolorsdots.txt")){

            @Override
            public Dimension getPreferredSize() {
                int ht = CompositeTextPanel.this.fontName.getPreferredSize().height;
                return new Dimension(2 * ht, ht);
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        MyComboBoxEditor editor = new MyComboBoxEditor();
        this.color.setToolTipText(RB.getStringResource("color.txt"));
        this.color.setEditor(editor);
        editor.addMouseListener(this.color);
        this.color.setEditable(true);
        Color c = this.text.getFontColor();
        this.color.setSelectedItem(c);
        this.color.setRenderer(new SwatchRenderer());
        this.color.setActionCommand("color");
        this.color.setFocusable(true);
        this.color.addActionListener(this);
        toolbar.add(this.color);
        toolbar.add(Box.createHorizontalGlue());
        JScrollPane textPanel4 = new JScrollPane(this.text, 20, 30);
        textPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), RB.getStringResource("text.txt")), BorderFactory.createEmptyBorder(0, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU)));
        this.text.setPreferredSize(new Dimension(Math.min(240, this.text.getPreferredSize().width), Math.min(160, 2 * this.text.getPreferredSize().height)));
        textPanel4.setPreferredSize(new Dimension(240, 100));
        textPanel4.setSize(new Dimension(240, 160));
        textPanel4.setMaximumSize(new Dimension(toolbar.getPreferredSize().width + 14, 400));
        int ht = this.fontName.getPreferredSize().height;
        Dimension ps = new Dimension(ht, ht);
        this.color.setPreferredSize(new Dimension(2 * ht, ht));
        this.color.setMaximumSize(new Dimension(2 * ht, ht));
        this.fontName.setPreferredSize(new Dimension(this.fontName.getPreferredSize().width, ht));
        this.fontName.setMaximumSize(this.fontName.getPreferredSize());
        this.fontSize.setPreferredSize(new Dimension(this.fontSize.getPreferredSize().width, ht));
        this.fontSize.setMaximumSize(this.fontSize.getPreferredSize());
        this.bold.setPreferredSize(ps);
        this.bold.setMaximumSize(ps);
        this.italic.setPreferredSize(ps);
        this.italic.setMaximumSize(ps);
        this.sub.setPreferredSize(ps);
        this.sub.setMaximumSize(ps);
        this.sup.setPreferredSize(ps);
        this.sup.setMaximumSize(ps);
        this.add((Component)toolbar, "First");
        toolbar.setOrientation(0);
        toolbar.setFloatable(true);
        JPanel main = new JPanel();
        main.setBorder(empty);
        main.setLayout(new BoxLayout(main, 1));
        main.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        main.add(textPanel4);
        main.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.grid = new CharacterGrid(this.text.getFont());
        this.grid.addItemListener(this);
        main.add(this.grid);
        this.add((Component)main, "Center");
    }

    void resetValues() {
        if (this.fontName == null) {
            return;
        }
        this.fontName.removeActionListener(this);
        this.fontName.setSelectedItem(this.text.getFontFamily());
        this.fontName.addActionListener(this);
        int cursize = this.text.getFontSize();
        this.fontSize.removeActionListener(this);
        String value = cursize == -1 ? "" : Integer.toString(cursize);
        this.fontSize.setSelectedItem(value);
        this.fontSize.addActionListener(this);
        int fstyle = this.text.getFontStyle();
        this.bold.removeActionListener(this);
        if (fstyle != -1 && (fstyle & 1) != 0) {
            this.bold.setSelected(true);
        } else {
            this.bold.setSelected(false);
        }
        this.bold.addActionListener(this);
        this.italic.removeActionListener(this);
        if (fstyle != -1 && (fstyle & 2) != 0) {
            this.italic.setSelected(true);
        } else {
            this.italic.setSelected(false);
        }
        this.italic.addActionListener(this);
        boolean isSub = this.text.isSubscript();
        boolean isSup = this.text.isSubscript();
        if (isSub != this.sub.isSelected() || isSup != this.sup.isSelected()) {
            this.sub.removeActionListener(this);
            this.sup.removeActionListener(this);
            this.sub.setSelected(isSub);
            this.sup.setSelected(isSup);
            this.sub.addActionListener(this);
            this.sup.addActionListener(this);
        }
        Color c = this.text.getFontColor();
        this.color.removeActionListener(this);
        this.color.setSelectedItem(c);
        this.color.addActionListener(this);
        this.grid.removeItemListener(this);
        this.grid.setFontFamily(this.text.getFont().getFamily());
        this.grid.addItemListener(this);
    }

    void setSizeBox(int fsize) {
        if (fsize >= SIZE_VALUES[SIZE_VALUES.length - 1]) {
            this.fontSize.setSelectedIndex(SIZE_VALUES.length - 1);
        } else {
            for (int i = 0; i < SIZE_VALUES.length; ++i) {
                if (fsize > SIZE_VALUES[i]) continue;
                this.fontSize.setSelectedIndex(i);
                break;
            }
        }
    }

    public CompositeTextInterface getStyle() {
        return this.text;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block32: {
            Color save;
            block39: {
                int result;
                Container parent;
                JPanel panel;
                JColorChooser cc;
                block30: {
                    String cmd;
                    block38: {
                        int value;
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block31: {
                                                cmd = e.getActionCommand();
                                                if (!cmd.equals("color")) break block31;
                                                Object item = this.color.getSelectedItem();
                                                if (item != null) {
                                                    save = this.text.getFontColor();
                                                    if (item instanceof String) {
                                                        if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                                                            cc = UIUtil.colorChooser;
                                                            cc.setColor(save);
                                                            cc.setPreviewPanel(new JPanel());
                                                            panel = new JPanel();
                                                            panel.setLayout(new BorderLayout());
                                                            panel.add(cc);
                                                            break block30;
                                                        } else {
                                                            Container c = this.getTopLevelAncestor();
                                                            if (c instanceof SGDialog) {
                                                                SGDialog sgd = (SGDialog)c;
                                                                sgd.setValue(-1);
                                                                this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                                                                c.setVisible(false);
                                                                this.dialog.setVisible(true);
                                                            }
                                                            c = this.colorGrabber.getComponent().getTopLevelAncestor();
                                                            c.requestFocus();
                                                            if (this.dialog != null) {
                                                                this.dialog.toFront();
                                                            }
                                                            this.colorGrabber.getComponent().repaint();
                                                            this.colorGrabber.setMouseEventListener();
                                                            this.colorGrabber.addActionListener(this);
                                                            this.colorGrabber.setStartColor(save);
                                                            if (save == null) {
                                                                save = Color.WHITE;
                                                            }
                                                            this.color.removeActionListener(this);
                                                            this.color.setSelectedItem(save);
                                                            this.color.addActionListener(this);
                                                            return;
                                                        }
                                                    }
                                                    if (item instanceof Color) {
                                                        this.text.setFontColor((Color)item);
                                                    }
                                                }
                                                break block32;
                                            }
                                            if (!cmd.equals("bold")) break block33;
                                            this.text.setBold(this.bold.isSelected());
                                            break block32;
                                        }
                                        if (!cmd.equals("italic")) break block34;
                                        this.text.setItalic(this.italic.isSelected());
                                        break block32;
                                    }
                                    if (!cmd.equals("subscript")) break block35;
                                    boolean isSub = this.sub.isSelected();
                                    if (this.sup.isSelected()) {
                                        this.sup.removeActionListener(this);
                                        this.sup.setSelected(false);
                                        this.sup.addActionListener(this);
                                    }
                                    this.text.updateText = false;
                                    this.text.setSuperscript(false);
                                    this.text.updateText = true;
                                    this.text.setSubscript(isSub);
                                    break block32;
                                }
                                if (!cmd.equals("superscript")) break block36;
                                boolean isSup = this.sup.isSelected();
                                if (this.sub.isSelected()) {
                                    this.sub.removeActionListener(this);
                                    this.sub.setSelected(false);
                                    this.sub.addActionListener(this);
                                }
                                this.text.updateText = false;
                                this.text.setSubscript(false);
                                this.text.updateText = true;
                                this.text.setSuperscript(isSup);
                                break block32;
                            }
                            if (!cmd.equals("name")) break block37;
                            String family = (String)this.fontName.getSelectedItem();
                            if (family.length() > 0 && this.fontName.getItemAt(0).equals("")) {
                                this.fontName.removeItemAt(0);
                            }
                            if (family.length() > 0) {
                                this.text.setFontFamily(family);
                                this.grid.setFontFamily(family);
                            }
                            break block32;
                        }
                        if (!cmd.equals("size")) break block38;
                        String fsize = (String)this.fontSize.getSelectedItem();
                        String f0 = (String)this.fontSize.getItemAt(0);
                        int n = value = fsize.length() == 0 ? -1 : Integer.parseInt(fsize);
                        if (value > 0 && f0.equals("")) {
                            this.fontSize.removeItemAt(0);
                        }
                        if (value != -1) {
                            this.text.setFontSize(value);
                        }
                        break block32;
                    }
                    if (cmd.equals("colorpicker:done")) {
                        Object cc2 = ((SwatchActionEvent)e).getValue();
                        if (cc2 != null) {
                            this.color.setSelectedItem(cc2);
                        } else {
                            this.color.removeActionListener(this);
                            this.color.setSelectedItem(Color.white);
                            this.color.addActionListener(this);
                        }
                        this.colorGrabber.removeMouseEventListener();
                        this.colorGrabber.removeActionListener(this);
                        if (this.dialog != null) {
                            this.dialog.dispose();
                        }
                        break block32;
                    } else if (cmd.equals("colorpicker:updating")) {
                        Object cc3 = ((SwatchActionEvent)e).getValue();
                        if (this.color != null) {
                            int i;
                            ActionListener[] listener = this.color.getActionListeners();
                            for (i = 0; i < listener.length; ++i) {
                                this.color.removeActionListener(listener[i]);
                            }
                            this.color.setSelectedItem(cc3);
                            this.color.setEnabled(true);
                            i = 0;
                            while (true) {
                                if (i >= listener.length) {
                                    return;
                                }
                                this.color.addActionListener(listener[i]);
                                ++i;
                            }
                        }
                    }
                    break block32;
                }
                for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
                }
                if (save == null) {
                    this.color.removeActionListener(this);
                    this.color.setSelectedItem(Color.white);
                    this.color.addActionListener(this);
                }
                if ((result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel)) != 0) break block39;
                Color newColor = cc.getColor();
                if (newColor == null) {
                    this.color.setSelectedItem(save);
                    break block32;
                } else if (save == null || save.getRGB() != newColor.getRGB()) {
                    this.text.setFontColor(newColor);
                    this.color.setSelectedItem(newColor);
                }
                break block32;
            }
            if (save != null) {
                this.color.setSelectedItem(save);
                return;
            }
            this.color.removeActionListener(this);
            this.color.setSelectedItem(Color.white);
            this.color.addActionListener(this);
        }
        this.text.requestFocus();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.grid) {
            int value = (Integer)e.getItem();
            String str = Character.toString((char)value);
            try {
                int len;
                Caret caret = this.text.getCaret();
                int mark = caret.getMark();
                int dot = caret.getDot();
                int offset = Math.min(mark, dot);
                if (mark != dot) {
                    this.text.getDocument().remove(offset, Math.abs(mark - dot));
                }
                if ((len = this.text.getText().length()) < 512) {
                    this.text.getDocument().insertString(offset, str, this.text.getInputAttributes());
                } else {
                    String message = RB.getStringResource("invalid.txt");
                    JOptionPane.showMessageDialog(this.getTextPane(), message, RB.getStringResource("warning.txt"), 2);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.text.requestFocus();
    }

    public RichTextInterface[] getRichText() {
        if (this.text == null) {
            return null;
        }
        return this.text.getRichText();
    }

    public void done() {
        this.text.getStyledDocument().removeDocumentListener(this.text.listener);
        this.text.removeCaretListener(this.text);
    }

    CompositeTextPanel getMainPanel() {
        return this;
    }

    @Override
    public void remove(int index) {
        super.remove(index);
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
    }

    public JTextPane getTextPane() {
        return this.text;
    }

    private class MySGTextPane
    extends SGTextPane {
        private CompositeTextInterface textStyle;
        boolean updateText;

        MySGTextPane(CompositeTextInterface textStyle, ComputedTextInterface cti, double fontScale) {
            super(null, textStyle.getRichText(), 0, cti, fontScale);
            this.updateText = true;
            this.textStyle = textStyle;
            this.setCaretPosition(this.getStyledDocument().getLength());
            this.curAttrs.clear();
            this.curAttrs.add(this.getInputAttributes());
            StyledDocument doc = this.getStyledDocument();
            doc.removeDocumentListener(this.listener);
            doc.addDocumentListener(new MyEventHandler(textStyle));
        }

        @Override
        protected void addBindings() {
            super.addBindings();
            InputMap inputMap = this.getInputMap();
            KeyStroke key = KeyStroke.getKeyStroke(10, 0);
            inputMap.put(key, new ModEnter());
        }

        @Override
        protected void _setProperty(int propertyID, Object value) {
            int dot;
            Caret caret;
            int mark;
            super._setProperty(propertyID, value);
            if (this.updateText && (mark = (caret = this.getCaret()).getMark()) != (dot = caret.getDot())) {
                this.textStyle.setRichText(this.getRichText());
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            Color cc;
            int newsize;
            if (CompositeTextPanel.this.text == null) {
                return;
            }
            CompositeTextPanel panel = CompositeTextPanel.this.getMainPanel();
            String family = CompositeTextPanel.this.text.getFontFamily();
            if (!CompositeTextPanel.this.fontName.getSelectedItem().equals(family)) {
                CompositeTextPanel.this.fontName.removeActionListener(panel);
                if (family.length() == 0 && !CompositeTextPanel.this.fontName.getItemAt(0).equals("")) {
                    CompositeTextPanel.this.fontName.insertItemAt("", 0);
                }
                CompositeTextPanel.this.fontName.setSelectedItem(CompositeTextPanel.this.text.getFontFamily());
                CompositeTextPanel.this.fontName.addActionListener(panel);
                CompositeTextPanel.this.grid.removeItemListener(panel);
                CompositeTextPanel.this.grid.setFontFamily(family);
                CompositeTextPanel.this.grid.addItemListener(panel);
            }
            int cursize = CompositeTextPanel.this.text.getFontSize();
            String selitem = (String)CompositeTextPanel.this.fontSize.getSelectedItem();
            int n = newsize = selitem.length() == 0 ? -1 : Integer.parseInt(selitem);
            if (newsize != cursize) {
                CompositeTextPanel.this.fontSize.removeActionListener(panel);
                String value = cursize == -1 ? "" : Integer.toString(cursize);
                String value0 = (String)CompositeTextPanel.this.fontSize.getItemAt(0);
                if (value.length() == 0 && value0.length() != 0) {
                    CompositeTextPanel.this.fontSize.insertItemAt("", 0);
                } else if (value0.length() == 0) {
                    CompositeTextPanel.this.fontSize.removeItemAt(0);
                }
                CompositeTextPanel.this.fontSize.setSelectedItem(value);
                CompositeTextPanel.this.fontSize.addActionListener(panel);
            }
            int oldstyle = CompositeTextPanel.this.text.getFontStyle();
            if (CompositeTextPanel.this.text.isBold() != CompositeTextPanel.this.bold.isSelected()) {
                CompositeTextPanel.this.bold.removeActionListener(panel);
                CompositeTextPanel.this.bold.setSelected(oldstyle != -1 && CompositeTextPanel.this.text.isBold());
                CompositeTextPanel.this.bold.addActionListener(panel);
            }
            if (CompositeTextPanel.this.text.isItalic() != CompositeTextPanel.this.italic.isSelected()) {
                CompositeTextPanel.this.italic.removeActionListener(panel);
                CompositeTextPanel.this.italic.setSelected(oldstyle != -1 && CompositeTextPanel.this.text.isItalic());
                CompositeTextPanel.this.italic.addActionListener(panel);
            }
            if ((cc = CompositeTextPanel.this.text.getFontColor()) == null) {
                cc = Color.WHITE;
            }
            CompositeTextPanel.this.color.removeActionListener(panel);
            CompositeTextPanel.this.color.setSelectedItem(cc);
            CompositeTextPanel.this.color.addActionListener(panel);
            boolean isSub = CompositeTextPanel.this.text.isSubscript();
            boolean isSup = CompositeTextPanel.this.text.isSuperscript();
            if (isSup != CompositeTextPanel.this.sup.isSelected()) {
                CompositeTextPanel.this.sup.removeActionListener(panel);
                CompositeTextPanel.this.sup.setSelected(isSup);
                CompositeTextPanel.this.sup.addActionListener(panel);
            }
            if (isSub != CompositeTextPanel.this.sub.isSelected()) {
                CompositeTextPanel.this.sub.removeActionListener(panel);
                CompositeTextPanel.this.sub.setSelected(isSub);
                CompositeTextPanel.this.sub.addActionListener(panel);
            }
        }

        @Override
        public void setVisible(boolean flag) {
            super.setVisible(flag);
        }
    }

    public class MyComboBoxEditor
    extends JLabel
    implements ComboBoxEditor {
        Color color;

        public MyComboBoxEditor() {
            super("");
        }

        @Override
        public void selectAll() {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null || anObject instanceof ComboBoxEditor) {
                return;
            }
            this.color = anObject instanceof Color ? (Color)anObject : Color.BLACK;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Insets i = this.getInsets();
            Rectangle r = this.getBounds();
            g.setColor(this.color);
            g.fillRect(i.left + 2, i.top + 2 * UIUtil.DLU, r.width - i.left - i.right - 5 * UIUtil.DLU, r.height - i.top - i.bottom - 5 * UIUtil.DLU);
            g.setColor(Color.LIGHT_GRAY);
            g.drawRect(i.left + 2, i.top + 2 * UIUtil.DLU, r.width - i.left - i.right - 5 * UIUtil.DLU, r.height - i.top - i.bottom - 5 * UIUtil.DLU);
        }
    }

    class ModEnter
    extends DefaultEditorKit.DefaultKeyTypedAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof SGTextPane) {
                SGTextPane tp = (SGTextPane)source;
                Container parent = tp.getParent();
                tp.exit();
                while (!(parent instanceof JDialog) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                if (parent instanceof JDialog) {
                    ((JDialog)parent).dispose();
                }
            }
        }
    }

    protected class MyEventHandler
    implements DocumentListener {
        CompositeTextInterface cti;

        public MyEventHandler(CompositeTextInterface cti) {
            this.cti = cti;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int eoffset = e.getOffset();
            Document doc = e.getDocument();
            try {
                if (doc.getText(eoffset, 1).equals(String.valueOf(13))) {
                    Container parent;
                    for (parent = CompositeTextPanel.this.getParent(); parent != null && !(parent instanceof JDialog); parent = parent.getParent()) {
                    }
                    if (parent instanceof JDialog) {
                        ((JDialog)parent).dispose();
                    }
                    return;
                }
                this.cti.setRichText(CompositeTextPanel.this.text.getRichText());
            }
            catch (BadLocationException ble) {
                System.err.println("SGTextField: insertUpdate()");
                ble.printStackTrace();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.cti.setRichText(CompositeTextPanel.this.text.getRichText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

