/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DefaultTextPlotInterface;
import com.sas.graphics.sg.interfaces.TextPlotInterface;
import com.sas.graphics.sg.ui.AreaCustomizerPanel;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SimpleTextCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextPlotCustomizerPanel
extends SGCustomizerPanel
implements ChangeListener {
    private static final String RB_KEY = "TextPlotCustomizerPanel.";
    private TextPlotInterface textPlot;
    ColorGrabber colorGrabber = null;
    private TPSimpleTextCustomizerPanel textPanel;
    private AreaCustomizerPanel areaPanel;
    JTabbedPane tabbedPane;

    public TextPlotCustomizerPanel(TextPlotInterface text) {
        this(text, null);
    }

    public TextPlotCustomizerPanel(TextPlotInterface textPlot, ColorGrabber cg) {
        this.textPlot = textPlot;
        this.colorGrabber = cg;
        this.setLayout(new BoxLayout(this, 1));
        this.tabbedPane = new JTabbedPane(1, 0);
        this.textPanel = new TPSimpleTextCustomizerPanel(textPlot, cg);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        panel1.setBorder(null);
        panel1.add(this.textPanel);
        panel1.add(Box.createVerticalGlue());
        this.areaPanel = new AreaCustomizerPanel(textPlot);
        this.areaPanel.validNoFillNoLine = true;
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(UIUtil.tabBorder);
        panel2.add(this.areaPanel);
        panel2.add(Box.createVerticalGlue());
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "text.txt"), panel1);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "area.txt"), panel2);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addChangeListener(this);
        this.labels.addAll(this.textPanel.getLabels());
        this.labels.addAll(this.areaPanel.getLabels());
        this.widgets.addAll(this.textPanel.getWidgets());
        this.widgets.addAll(this.areaPanel.getWidgets());
        this.add(this.tabbedPane);
    }

    @Override
    public void setValue(Object newValue) {
        if (!(newValue instanceof TextPlotInterface)) {
            return;
        }
        this.textPlot = (TextPlotInterface)newValue;
        this.textPanel.setValue(this.textPlot);
        this.areaPanel.setValue(this.textPlot);
        this.areaPanel.validNoFillNoLine = true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        if (index == 0) {
            this.textPanel.resetSizeAndColor();
        } else {
            this.areaPanel.setValue(this.textPlot);
            this.areaPanel.validNoFillNoLine = true;
            this.areaPanel.fill.setEnabled(true);
            this.areaPanel.outline.setEnabled(true);
        }
    }

    class TPSimpleTextCustomizerPanel
    extends SimpleTextCustomizerPanel {
        public TPSimpleTextCustomizerPanel(TextPlotInterface textPlot, ColorGrabber cg) {
            super(textPlot, cg);
            this.resetSizeAndColor();
        }

        private void resetSizeAndColor() {
            if (TextPlotCustomizerPanel.this.textPlot instanceof DefaultTextPlotInterface) {
                Color c;
                this.color.removeActionListener(this);
                this.fontSize.removeActionListener(this);
                DefaultTextPlotInterface defaultText = (DefaultTextPlotInterface)((Object)TextPlotCustomizerPanel.this.textPlot);
                this.defaultString = defaultText.getDefaultTextColorSource();
                Color defaultColor = defaultText.getDefaultFontColor();
                this.color.setAutomatic(this.defaultString, defaultColor);
                ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultString, defaultColor);
                this.color.setEditor(editor);
                if (defaultColor == null) {
                    this.color.mypopup.swatchFrame.automatic.setText(this.defaultString);
                    this.color.mypopup.swatchFrame.automatic.setHorizontalAlignment(2);
                }
                if ((c = TextPlotCustomizerPanel.this.textPlot.getFontColor()) == null) {
                    this.color.setSelectedItem(this.defaultString);
                }
                String auto = defaultText.getDefaultTextSizeSource();
                int boxSize = this.needtoRemoveBlankSize ? this.fontSize.getItemCount() - 1 : this.fontSize.getItemCount();
                String[] sizes = new String[boxSize];
                sizes[0] = auto;
                for (int i = 1; i < boxSize; ++i) {
                    sizes[i] = (String)this.fontSize.getItemAt(i);
                }
                this.fontSize.setModel(new DefaultComboBoxModel<String>(sizes));
                int csize = TextPlotCustomizerPanel.this.textPlot.getFontSize();
                if (csize == -1) {
                    this.fontSize.setSelectedIndex(0);
                } else {
                    this.fontSize.setSelectedItem(Integer.toString(csize));
                }
                this.needtoRemoveBlankSize = false;
            }
            this.color.setEnabled(TextPlotCustomizerPanel.this.textPlot.isTextColorEditable());
            this.fontSize.setEnabled(TextPlotCustomizerPanel.this.textPlot.isTextSizeEditable());
            this.fontSize.addActionListener(this);
            this.color.addActionListener(this);
        }

        @Override
        public void setValue(Object newValue) {
            if (!(newValue instanceof TextPlotInterface)) {
                return;
            }
            super.setValue(newValue);
            this.resetSizeAndColor();
        }
    }
}

