/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SwatchPopup;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class SwatchComboBox
extends JComboBox
implements MouseListener {
    SwatchPopup mypopup;
    Object[] list;
    Object[] recent;
    int cols = 8;
    int rows = 4;
    String more = null;
    String autoLabel = null;
    Object autoValue = null;
    ColorGrabber cg = null;

    public SwatchComboBox() {
    }

    public SwatchComboBox(Object[] aList, int cols, int rows) {
        this(aList, cols, rows, null, null, null, null);
    }

    public SwatchComboBox(Object[] aList, int cols, int rows, ColorGrabber cg) {
        this(aList, cols, rows, cg, null, null, null);
    }

    public SwatchComboBox(Object[] aList, int cols, int rows, String autoLabel, Object value, String moreLabel) {
        this(aList, cols, rows, null, autoLabel, value, moreLabel);
    }

    public SwatchComboBox(Object[] aList, int cols, int rows, ColorGrabber cg, String autoLabel, Object value, String moreLabel) {
        this.list = aList;
        this.cols = cols;
        this.rows = rows;
        this.more = moreLabel;
        this.cg = cg;
        this.autoValue = value;
        this.autoLabel = autoLabel;
        this.recent = this.more != null ? UIUtil.getRecentColors() : null;
        this.setFocusable(true);
        this.updateUI();
    }

    public void setModel(Object[] aList) {
        this.list = aList;
        this.updateUI();
    }

    public void setAutomatic(String label, Object obj) {
        this.autoLabel = label;
        this.autoValue = obj;
        if (this.mypopup != null) {
            this.mypopup.setAutomatic(this.autoLabel, this.autoValue);
        }
    }

    public void setGrid(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        if (this.mypopup != null) {
            this.mypopup.setGrid(cols, rows);
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        int i;
        AWTEvent event;
        if (item.equals(RB.getStringResource("colorPicker.txt")) || item.equals(this.more)) {
            super.setSelectedItem(item);
            return;
        }
        if (this.mypopup.swatchFrame.isColorGrabberSelected() && (event = EventQueue.getCurrentEvent()) instanceof MouseEvent && event.getID() == 503) {
            this.getEditor().setItem(item);
            super.setSelectedItem(item);
            return;
        }
        ActionListener[] listeners = this.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.removeActionListener(listeners[i]);
        }
        this.mypopup.hideNext = false;
        if (this.autoLabel != null && item instanceof String && ((String)item).indexOf(this.autoLabel) != -1) {
            this.mypopup.swatchFrame.setAutomaticSelected();
        } else if (item instanceof Color) {
            this.checkAndInsertColor((Color)item);
        } else if (item instanceof Number) {
            this.checkAndInsertNumber((Number)item);
        } else if (!(item instanceof String)) {
            this.checkAndInsert(item);
        } else {
            this.checkAndInsert(item);
        }
        for (i = 0; i < listeners.length; ++i) {
            this.addActionListener(listeners[i]);
        }
        this.removeAllItems();
        this.addItem(item);
    }

    private void checkAndInsert(Object item) {
        int i;
        if (this.list == null || item == null || item instanceof String && ((String)item).length() == 0) {
            return;
        }
        for (i = 0; i < this.list.length; ++i) {
            if (!item.equals(this.list[i])) continue;
            this.mypopup.swatchFrame.setSelectedLabel(i);
            return;
        }
        if (this.recent != null) {
            for (i = 0; i < this.recent.length && this.recent[i] != null; ++i) {
                if (!item.equals(this.recent[i])) continue;
                this.mypopup.swatchFrame.setSelectedLabel(i + this.list.length);
                return;
            }
            if (!this.mypopup.colorShifted) {
                for (i = 1; i < this.recent.length; ++i) {
                    this.recent[i] = this.recent[i - 1];
                }
            }
            this.recent[0] = item;
            this.mypopup.swatchFrame.setSelectedLabel(this.list.length);
        } else {
            for (i = 1; i < this.list.length; ++i) {
                this.list[i] = this.list[i - 1];
            }
            this.list[0] = item;
            this.mypopup.swatchFrame.setSelectedLabel(0);
        }
        if (this.mypopup != null) {
            this.mypopup.setGrid(this.cols, this.rows);
        }
    }

    private void checkAndInsertColor(Color item) {
        int i;
        if (this.list == null || item == null) {
            return;
        }
        int rgb = item.getRGB();
        for (i = 0; i < this.list.length; ++i) {
            if (rgb != ((Color)this.list[i]).getRGB()) continue;
            this.mypopup.swatchFrame.setSelectedLabel(i);
            return;
        }
        if (this.recent != null) {
            for (i = 0; i < this.recent.length && this.recent[i] != null; ++i) {
                if (rgb != ((Color)this.recent[i]).getRGB()) continue;
                this.mypopup.swatchFrame.setSelectedLabel(this.list.length + i);
                return;
            }
            if (!this.mypopup.colorShifted) {
                for (i = this.recent.length - 1; i > 0; --i) {
                    this.recent[i] = this.recent[i - 1];
                }
                this.mypopup.colorShifted = true;
            }
            this.recent[0] = item;
            this.mypopup.swatchFrame.setSelectedLabel(this.list.length);
        } else {
            for (i = 0; i < this.list.length; ++i) {
                if (rgb != ((Color)this.list[i]).getRGB()) continue;
                this.mypopup.swatchFrame.setSelectedLabel(i);
                return;
            }
            for (i = this.list.length - 1; i > 0; --i) {
                this.list[i] = this.list[i - 1];
            }
            this.list[0] = item;
            this.mypopup.swatchFrame.setSelectedLabel(0);
        }
        if (this.mypopup != null) {
            this.mypopup.setGrid(this.cols, this.rows);
        }
    }

    private void checkAndInsertNumber(Number item) {
        int i;
        if (this.list == null || item == null) {
            return;
        }
        double value = item.doubleValue();
        for (i = 0; i < this.list.length; ++i) {
            if (value != ((Number)this.list[i]).doubleValue()) continue;
            this.mypopup.swatchFrame.setSelectedLabel(i);
            return;
        }
        for (i = 1; i < this.list.length; ++i) {
            this.list[i] = this.list[i - 1];
        }
        this.list[0] = item;
        this.mypopup.swatchFrame.setSelectedLabel(0);
        if (this.mypopup != null) {
            this.mypopup.setGrid(this.cols, this.rows);
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        this.removeAllItems();
        if (index < this.list.length) {
            this.addItem(this.list[index]);
        } else if (this.recent != null && index < this.list.length + this.recent.length) {
            this.addItem(this.recent[index - this.list.length]);
        }
        super.setSelectedItem(this.list[index]);
    }

    @Override
    public int getSelectedIndex() {
        block7: {
            Object sObject;
            block6: {
                int i;
                sObject = this.getSelectedItem();
                if (!(sObject instanceof Color)) break block6;
                int rgb = ((Color)sObject).getRGB();
                for (i = 0; i < this.list.length; ++i) {
                    if (rgb != ((Color)this.list[i]).getRGB()) continue;
                    return i;
                }
                if (this.recent == null) break block7;
                for (i = 0; i < this.recent.length && this.recent[i] != null; ++i) {
                    if (rgb != ((Color)this.recent[i]).getRGB()) continue;
                    return i + this.list.length;
                }
                break block7;
            }
            if (sObject instanceof Number) {
                double value = ((Number)sObject).doubleValue();
                for (int i = 0; i < this.list.length; ++i) {
                    if (value != ((Number)this.list[i]).doubleValue()) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.list.length; ++i) {
                    if (!this.list[i].equals(sObject)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return ps;
        }
        return new Dimension(Math.max(UIUtil.DEFAULT_WIDGET_WIDTH, ps.width), Math.max(UIUtil.DEFAULT_WIDGET_HEIGHT, ps.height));
    }

    @Override
    public void updateUI() {
        ComboBoxUI ui = (ComboBoxUI)UIManager.getUI(this);
        if (this.list == null) {
            return;
        }
        ComboPopup popup = null;
        LookAndFeel lnf = UIManager.getLookAndFeel();
        String lnfName = lnf.getName();
        if (lnfName.equals("Windows")) {
            ui = new WindowsSwatchComboBoxUI();
            popup = ((WindowsSwatchComboBoxUI)ui).createPopup();
        } else if (lnfName.equals("Metal")) {
            ui = new MetalSwatchComboBoxUI();
            popup = ((MetalSwatchComboBoxUI)ui).createPopup();
        } else if (lnfName.equals("CDE/Motif")) {
            ui = new MotifSwatchComboBoxUI();
            popup = ((MotifSwatchComboBoxUI)ui).createPopup();
        }
        if (popup instanceof SwatchPopup) {
            this.mypopup = (SwatchPopup)popup;
        }
        this.setUI(ui);
    }

    JComboBox getComboBox() {
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mypopup != null) {
            this.mypopup.mouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class WindowsSwatchComboBoxUI
    extends BasicComboBoxUI {
        WindowsSwatchComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            if (this.popup == null || !(this.popup instanceof SwatchPopup)) {
                this.popup = new SwatchPopup(SwatchComboBox.this.getComboBox(), SwatchComboBox.this.list, SwatchComboBox.this.cols, SwatchComboBox.this.rows, SwatchComboBox.this.cg, SwatchComboBox.this.autoLabel, SwatchComboBox.this.autoValue, SwatchComboBox.this.more);
            }
            return this.popup;
        }
    }

    class MetalSwatchComboBoxUI
    extends MetalComboBoxUI {
        MetalSwatchComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            if (this.popup == null || !(this.popup instanceof SwatchPopup)) {
                this.popup = new SwatchPopup(SwatchComboBox.this.getComboBox(), SwatchComboBox.this.list, SwatchComboBox.this.cols, SwatchComboBox.this.rows, SwatchComboBox.this.cg, SwatchComboBox.this.autoLabel, SwatchComboBox.this.autoValue, SwatchComboBox.this.more);
            }
            return this.popup;
        }
    }

    class MotifSwatchComboBoxUI
    extends BasicComboBoxUI {
        private static final long serialVersionUID = 1L;

        MotifSwatchComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            if (this.popup == null || !(this.popup instanceof SwatchPopup)) {
                this.popup = new SwatchPopup(SwatchComboBox.this.getComboBox(), SwatchComboBox.this.list, SwatchComboBox.this.cols, SwatchComboBox.this.rows, SwatchComboBox.this.cg, SwatchComboBox.this.autoLabel, SwatchComboBox.this.autoValue, SwatchComboBox.this.more);
            }
            return this.popup;
        }
    }
}

