/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DefaultSurfaceInterface;
import com.sas.graphics.sg.interfaces.SurfaceInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.FillCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.text.Message;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SurfaceCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    public static final String RB_KEY = "SurfaceCustomizerPanel.";
    private SurfaceInterface surface;
    private JComboBox type;
    private FillCustomizerPanel fillPanel;
    private boolean defaultFill;
    ColorGrabber colorGrabber = null;

    public SurfaceCustomizerPanel(SurfaceInterface surface) {
        this(surface, null);
    }

    public SurfaceCustomizerPanel(SurfaceInterface surface, ColorGrabber cg) {
        this.surface = surface;
        this.colorGrabber = cg;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    protected void init() {
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        JLabel typelabel = new JLabel(RB.getStringResource("type.txt"));
        typePanel.add(typelabel);
        Dimension ps = typelabel.getPreferredSize();
        if (ps.width > this.labelSize.width) {
            this.labelSize.width = ps.width;
        }
        if (ps.height > this.labelSize.height) {
            this.labelSize.height = ps.height;
        }
        this.labels.add(typelabel);
        typePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        String value = this.surface.getSurfaceType().toLowerCase();
        boolean fillOn = true;
        this.defaultFill = true;
        if (this.surface instanceof DefaultSurfaceInterface) {
            String deftype = ((DefaultSurfaceInterface)((Object)this.surface)).getDefaultSurfaceType();
            if (deftype.equals("wireframe")) {
                this.defaultFill = false;
                deftype = RB.getStringResource(RB_KEY, "wireFrame.txt");
            } else {
                deftype = deftype.equals("fill") ? RB.getStringResource("sfill.txt") : RB.getStringResource(RB_KEY, "fillGrid.txt");
            }
            String defvalue = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)deftype);
            this.type = new JComboBox<String>(new String[]{defvalue, RB.getStringResource(RB_KEY, "wireFrame.txt"), RB.getStringResource("sfill.txt"), RB.getStringResource(RB_KEY, "fillGrid.txt")});
            if (value == null || value.equals("")) {
                this.type.setSelectedIndex(0);
                fillOn = this.defaultFill;
            } else if (value.equals("wireframe")) {
                this.type.setSelectedIndex(1);
                fillOn = false;
            } else {
                fillOn = true;
                if (value.equals("fill")) {
                    this.type.setSelectedIndex(2);
                } else {
                    this.type.setSelectedIndex(3);
                }
            }
        } else {
            this.type = new JComboBox<String>(new String[]{RB.getStringResource(RB_KEY, "wireFrame.txt"), RB.getStringResource("sfill.txt"), RB.getStringResource(RB_KEY, "fillGrid.txt")});
            if (value.equals("wireframe")) {
                this.type.setSelectedIndex(0);
                fillOn = false;
            } else if (value.equals("fill")) {
                this.type.setSelectedIndex(1);
            } else {
                this.type.setSelectedIndex(2);
            }
        }
        this.type.setActionCommand("type");
        typePanel.add(this.type);
        typePanel.add(Box.createHorizontalGlue());
        this.type.addActionListener(this);
        this.add(typePanel);
        ps = this.type.getPreferredSize();
        if (ps.width > this.widgetSize.width) {
            this.widgetSize.width = ps.width;
        }
        if (ps.height > this.widgetSize.height) {
            this.widgetSize.height = ps.height;
        }
        this.widgets.add(this.type);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.fillPanel = new FillCustomizerPanel(this.surface, this.colorGrabber);
        this.fillPanel.setFillOn(fillOn && this.surface.isFillColorEditable());
        this.fillPanel.setTransparencyEnabled(fillOn);
        this.add(this.fillPanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        ps = this.fillPanel.widgetSize;
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        ps = this.fillPanel.labelSize;
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.add(Box.createVerticalGlue());
        this.fillPanel.setWidgetPreferredSize(this.widgetSize);
        this.fillPanel.setLabelPreferredSize(this.labelSize);
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
    }

    @Override
    public void setValue(Object newValue) {
        if (!(newValue instanceof SurfaceInterface)) {
            return;
        }
        this.surface = (SurfaceInterface)newValue;
        this.type.removeActionListener(this);
        this.type.removeAllItems();
        String value = this.surface.getSurfaceType().toLowerCase();
        int offset = 0;
        boolean fillOn = true;
        this.defaultFill = true;
        if (this.surface instanceof DefaultSurfaceInterface) {
            String deftype = ((DefaultSurfaceInterface)((Object)this.surface)).getDefaultSurfaceType().toLowerCase();
            if (deftype.equals("wireframe")) {
                this.defaultFill = false;
                deftype = RB.getStringResource(RB_KEY, "wireFrame.txt");
            } else {
                deftype = deftype.equals("fill") ? RB.getStringResource("sfill.txt") : RB.getStringResource(RB_KEY, "fillGrid.txt");
            }
            String defvalue = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)deftype);
            this.type.addItem(defvalue);
            offset = 1;
        }
        this.type.addItem(RB.getStringResource(RB_KEY, "wireFrame.txt"));
        this.type.addItem(RB.getStringResource("sfill.txt"));
        this.type.addItem(RB.getStringResource(RB_KEY, "fillGrid.txt"));
        if (value == null || value.length() == 0) {
            this.type.setSelectedIndex(0);
            fillOn = this.defaultFill;
        } else if (value.equals("wireframe")) {
            fillOn = false;
            this.type.setSelectedIndex(offset);
        } else if (value.equals("fill")) {
            fillOn = true;
            this.type.setSelectedIndex(offset + 1);
        } else {
            fillOn = true;
            this.type.setSelectedIndex(offset + 2);
        }
        this.type.addActionListener(this);
        this.fillPanel.setValue(this.surface);
        this.fillPanel.setTransparencyEnabled(fillOn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("type")) {
            String value;
            int index = this.type.getSelectedIndex();
            if (this.surface instanceof DefaultSurfaceInterface) {
                --index;
            }
            boolean fillOn = true;
            switch (index) {
                case -1: {
                    value = "";
                    fillOn = this.defaultFill;
                    break;
                }
                case 0: {
                    value = "wireFrame";
                    fillOn = false;
                    break;
                }
                case 1: {
                    value = "fill";
                    break;
                }
                default: {
                    value = "fillgrid";
                }
            }
            this.surface.setSurfaceType(value);
            this.fillPanel.setTransparencyEnabled(fillOn);
        }
    }
}

