/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class StandardColorChooserPanel
extends AbstractColorChooserPanel {
    public static final String RB_KEY = "StandardColorChooserPanel.";
    public static final int DLU = Math.max(1, UIUtil.DLU);
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    private static String recentStr = RB.getStringResource("StandardColorChooserPanel.", "recent.txt");

    @Override
    public String getDisplayName() {
        return RB.getStringResource(RB_KEY, "swatches.txt");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.swatchPanel = new MainSwatchPanel();
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        border = new CompoundBorder(border, BorderFactory.createEmptyBorder(3 * DLU, 3 * DLU, 3 * DLU, 3 * DLU));
        this.swatchPanel.setBorder(border);
        this.swatchPanel.setOpaque(false);
        panel.add(this.swatchPanel);
        panel.add(Box.createRigidArea(new Dimension(0, 7 * DLU)));
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        border = new CompoundBorder(BorderFactory.createTitledBorder(new LineBorder(Color.black), recentStr), new LineBorder(Color.white));
        this.recentSwatchPanel.setBorder(border);
        this.recentSwatchPanel.setOpaque(false);
        panel.add(Box.createRigidArea(new Dimension(0, 3 * DLU)));
        panel.add(this.recentSwatchPanel);
        this.add(panel);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchPanel
    extends SwatchPanel {
        MainSwatchPanel() {
        }

        @Override
        protected void initValues() {
            this.swatchSize = new Dimension(9 * DLU, 9 * DLU);
            this.numSwatches = new Dimension(31, 9);
            this.gap = new Dimension(2 * DLU, 2 * DLU);
        }

        @Override
        protected void initColors() {
            int[] rawValues = this.initRawValues();
            int numColors = rawValues.length / 3;
            this.colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                this.colors[i] = new Color(rawValues[i * 3], rawValues[i * 3 + 1], rawValues[i * 3 + 2]);
            }
        }

        private int[] initRawValues() {
            int[] rawValues = new int[]{255, 255, 255, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 255, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 204, 204, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 153, 255, 255, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 204, 204, 204, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 102, 255, 255, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 153, 153, 153, 51, 255, 255, 51, 204, 255, 51, 153, 255, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 51, 255, 255, 51, 255, 255, 51, 204, 255, 51, 153, 255, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 51, 255, 255, 51, 204, 255, 51, 153, 244, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 153, 153, 153, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 0, 255, 255, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 102, 102, 102, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 102, 102, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 51, 51, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 0, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 51, 51, 51};
            return rawValues;
        }
    }

    class SwatchPanel
    extends JPanel {
        protected Color[] colors;
        protected Dimension swatchSize;
        protected Dimension numSwatches;
        protected Dimension gap;

        public SwatchPanel() {
            this.initValues();
            this.initColors();
            this.setToolTipText("");
            this.setBackground(Color.white);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        protected void initValues() {
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            g.setColor(this.getBackground());
            g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            for (int row = 0; row < this.numSwatches.height; ++row) {
                for (int column = 0; column < this.numSwatches.width; ++column) {
                    g.setColor(this.getColorForCell(column, row));
                    int x = insets.left;
                    x = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? (x += (this.numSwatches.width - column - 1) * (this.swatchSize.width + this.gap.width)) : (x += column * (this.swatchSize.width + this.gap.width));
                    int y = row * (this.swatchSize.height + this.gap.height) + insets.top;
                    g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                    g.setColor(Color.black);
                    g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                    g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
            int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
            Insets insets = this.getInsets();
            return new Dimension(x + insets.left + insets.right, y + insets.top + insets.bottom);
        }

        protected void initColors() {
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Color color = this.getColorForLocation(e.getX(), e.getY());
            if (color == null) {
                return "";
            }
            String message = Message.format((String)RB.getStringResource(StandardColorChooserPanel.RB_KEY, "color.fmt.txt"), (Object)Integer.toString(color.getRed()), (Object)Integer.toString(color.getGreen()), (Object)Integer.toString(color.getBlue()));
            return message;
        }

        public Color getColorForLocation(int x, int y) {
            Insets insets = this.getInsets();
            int column = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? this.numSwatches.width - x / (this.swatchSize.width + this.gap.width) - 1 : (x -= insets.left) / (this.swatchSize.width + this.gap.width);
            int row = (y -= insets.top) / (this.swatchSize.height + this.gap.height);
            return this.getColorForCell(column, row);
        }

        private Color getColorForCell(int column, int row) {
            int index = row * this.numSwatches.width + column;
            if (index < 0 || index >= this.colors.length) {
                return null;
            }
            return this.colors[index];
        }
    }

    class RecentSwatchPanel
    extends SwatchPanel {
        RecentSwatchPanel() {
        }

        @Override
        protected void initValues() {
            this.swatchSize = new Dimension(9 * DLU, 9 * DLU);
            this.numSwatches = new Dimension(31, 4);
            this.gap = new Dimension(2 * DLU, 2 * DLU);
        }

        @Override
        protected void initColors() {
            Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
            int numColors = this.numSwatches.width * this.numSwatches.height;
            this.colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                this.colors[i] = defaultRecentColor;
            }
        }

        public void setMostRecentColor(Color c) {
            System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
            this.colors[0] = c;
            this.repaint();
        }
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = StandardColorChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            StandardColorChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            StandardColorChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = StandardColorChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
            StandardColorChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

