/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.BoxInterface;
import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.interfaces.DefaultFillInterface;
import com.sas.graphics.sg.interfaces.FillStyleElementInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.MarkerCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleBoxCustomizerPanel
extends SGCustomizerPanel
implements ActionListener,
ChangeListener {
    private static final String RB_KEY = "BoxCustomizerPanel.";
    private static final int dlu2 = UIUtil.DLU * 2;
    private static final int dlu3 = UIUtil.DLU * 3;
    private static final int dlu4 = UIUtil.DLU * 4;
    private static final int dlu7 = UIUtil.DLU * 7;
    private static final Border left = BorderFactory.createEmptyBorder(0, 2 * dlu7, 0, dlu7);
    JCheckBox fill;
    SwatchComboBox fillColor;
    CompTitledBorder fillBorder;
    protected JPanel fillPanel;
    private JSlider transparency;
    JComboBox fstyle;
    String defaultFillColorSource = "";
    MarkerCustomizerPanel outlierPanel;
    BoxInterface boxStyle;
    ColorGrabber colorGrabber = null;
    private JDialog dialog = null;

    public SimpleBoxCustomizerPanel(BoxInterface boxStyle) {
        this(boxStyle, null);
    }

    public SimpleBoxCustomizerPanel(BoxInterface boxStyle, ColorGrabber cg) {
        this.boxStyle = boxStyle;
        this.colorGrabber = cg;
        this.init();
        this.setSize(this.getPreferredSize());
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        Color defaultFillColor = null;
        boolean fillOn = this.boxStyle.isOn(2);
        boolean markerOn = this.boxStyle.isOn(5);
        this.boxStyle.setEditingState(1);
        if (this.boxStyle instanceof DefaultAreaInterface) {
            DefaultAreaInterface das = (DefaultAreaInterface)((Object)this.boxStyle);
            this.defaultFillColorSource = das.getDefaultFillColorSource();
            defaultFillColor = das.getDefaultFillColor();
        }
        this.fillPanel = new JPanel();
        this.fillPanel.setBorder(left);
        this.fillPanel.setLayout(new BoxLayout(this.fillPanel, 1));
        if (this.boxStyle instanceof FillStyleElementInterface) {
            FillStyleElementInterface styleInterface = (FillStyleElementInterface)((Object)this.boxStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            JLabel styleLabel = new JLabel(RB.getStringResource("element.txt"));
            Dimension ps = styleLabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            this.labels.add(styleLabel);
            stylePanel.add(styleLabel);
            stylePanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
            this.fstyle = new JComboBox<String>(styleInterface.getAllFillStyleElements());
            this.fstyle.setSelectedItem(styleInterface.getFillStyleElement());
            this.fstyle.setEnabled(fillOn);
            this.fstyle.setActionCommand("fillstyle");
            this.fstyle.addActionListener(this);
            this.widgets.add(this.fstyle);
            ps = this.fstyle.getPreferredSize();
            this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
            stylePanel.add(this.fstyle);
            stylePanel.add(Box.createHorizontalGlue());
            this.fillPanel.add(stylePanel);
            this.fillPanel.add(Box.createRigidArea(new Dimension(0, dlu4)));
        }
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorlabel = new JLabel(RB.getStringResource("colorcolon.txt"));
        colorPanel.add(colorlabel);
        colorPanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
        Dimension ps = colorlabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(colorlabel);
        if (this.boxStyle instanceof DefaultFillInterface) {
            DefaultFillInterface das = (DefaultFillInterface)((Object)this.boxStyle);
            this.defaultFillColorSource = das.getDefaultFillColorSource();
            defaultFillColor = das.getDefaultFillColor();
        }
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultFillColorSource, defaultFillColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.boxStyle.getFillColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        this.fillColor.setRenderer(new SwatchRenderer());
        this.fillColor.setEnabled(fillOn);
        this.fillColor.setActionCommand("fillcolor");
        this.fillPanel.add(this.fillColor);
        this.fillPanel.add(Box.createHorizontalGlue());
        this.fillColor.addActionListener(this);
        ps = this.fillColor.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.fillColor);
        colorPanel.add(this.fillColor);
        colorPanel.add(Box.createHorizontalGlue());
        this.fillPanel.add(colorPanel);
        this.fillPanel.add(Box.createRigidArea(new Dimension(0, dlu4)));
        JPanel transparencyPanel = new JPanel();
        transparencyPanel.setLayout(new BoxLayout(transparencyPanel, 0));
        JLabel translabel = new JLabel(RB.getStringResource("transparency.txt"));
        transparencyPanel.add(translabel);
        ps = translabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(translabel);
        this.transparency = new JSlider(0, 0, 100, this.boxStyle.getFillTrans());
        this.transparency.addChangeListener(this);
        this.transparency.setMajorTickSpacing(25);
        this.transparency.setMinorTickSpacing(5);
        this.transparency.setPaintTicks(true);
        this.transparency.setEnabled(fillOn);
        transparencyPanel.add(this.transparency);
        transparencyPanel.add(Box.createHorizontalGlue());
        this.fillPanel.add(transparencyPanel);
        this.fill = new JCheckBox(RB.getStringResource("sfill.txt"));
        this.fill.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        this.fill.addActionListener(this);
        this.fill.setActionCommand("fill");
        JPanel fillGroupPanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                if (SimpleBoxCustomizerPanel.this.fillBorder == null) {
                    return;
                }
                Rectangle compR = SimpleBoxCustomizerPanel.this.fillBorder.getComponentRect(rect, insets);
                SimpleBoxCustomizerPanel.this.fill.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                SimpleBoxCustomizerPanel.this.fillPanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = super.getInsets();
                Dimension ps2 = SimpleBoxCustomizerPanel.this.fillPanel.getPreferredSize();
                return new Dimension((int)(ps2.getWidth() + (double)insets.left + (double)insets.right), (int)ps2.getHeight() + insets.top + insets.bottom);
            }
        };
        fillGroupPanel.add(this.fill);
        fillGroupPanel.add(this.fillPanel);
        this.fillBorder = new CompTitledBorder((Border)new LineBorder(Color.GRAY), this.fill);
        fillGroupPanel.setBorder(this.fillBorder);
        this.boxStyle.setEditingState(6);
        this.outlierPanel = new MarkerCustomizerPanel(this.boxStyle, this.colorGrabber);
        this.outlierPanel.setEnabledAll(markerOn);
        this.outlierPanel.setBorder(BorderFactory.createEmptyBorder(dlu4, dlu7, dlu4, dlu2));
        this.outlierPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource(RB_KEY, "outlier.txt")), BorderFactory.createEmptyBorder(0, 2 * dlu7, dlu4, dlu4)));
        this.add(this.outlierPanel);
        this.add(Box.createRigidArea(new Dimension(0, dlu4)));
        this.add(fillGroupPanel);
        this.add(Box.createRigidArea(new Dimension(0, dlu7)));
        ps = this.outlierPanel.getWidgetPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.outlierPanel.setWidgetPreferredSize(this.widgetSize);
        ps = this.transparency.getPreferredSize();
        this.transparency.setPreferredSize(new Dimension(this.widgetSize.width, ps.height));
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
    }

    @Override
    public void setValue(Object style) {
        Color c;
        if (!(style instanceof BoxInterface)) {
            return;
        }
        this.boxStyle = (BoxInterface)style;
        this.boxStyle.setEditingState(1);
        boolean fillOn = this.boxStyle.isOn(2);
        this.fill.removeActionListener(this);
        this.fill.setSelected(fillOn);
        this.fill.addActionListener(this);
        Color defaultFillColor = null;
        this.fillColor.removeActionListener(this);
        if (this.boxStyle instanceof DefaultFillInterface) {
            defaultFillColor = ((DefaultFillInterface)((Object)this.boxStyle)).getDefaultFillColor();
            this.fillColor.setAutomatic(this.defaultFillColorSource, defaultFillColor);
            this.fillColor.updateUI();
            this.fillColor.setEditor(new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor));
        }
        if ((c = this.boxStyle.getFillColor()) != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        this.fillColor.setEnabled(fillOn);
        this.fillColor.addActionListener(this);
        this.boxStyle.setEditingState(6);
        this.outlierPanel.setValue(this.boxStyle);
        this.outlierPanel.setEnabledAll(this.boxStyle.isOn(5));
        this.transparency.removeChangeListener(this);
        this.transparency.setEnabled(fillOn);
        this.transparency.setValue(this.boxStyle.getFillTrans());
        this.transparency.addChangeListener(this);
        if (this.fstyle != null) {
            this.fstyle.removeActionListener(this);
            if (this.boxStyle instanceof FillStyleElementInterface) {
                this.fstyle.setSelectedItem(((FillStyleElementInterface)((Object)this.boxStyle)).getFillStyleElement());
                this.fstyle.setEnabled(fillOn);
            } else {
                this.fstyle.setEditable(false);
            }
            this.fstyle.addActionListener(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("fill")) {
            boolean fillOn = this.fill.isSelected();
            this.boxStyle.setOn(2, fillOn);
            this.fillColor.setEnabled(fillOn);
            this.transparency.setEnabled(fillOn);
            if (this.fstyle == null) return;
            if (!(this.boxStyle instanceof FillStyleElementInterface)) return;
            this.fstyle.setEnabled(fillOn);
            return;
        }
        if (cmd.equals("fillcolor")) {
            Object item = this.fillColor.getSelectedItem();
            if (item == null) return;
            this.boxStyle.setEditingState(1);
            Color save = this.boxStyle.getFillColor();
            if (!(item instanceof String)) {
                if (!(item instanceof Color)) return;
                this.boxStyle.setFillColor((Color)item);
                this.boxStyle.setEditingState(6);
                return;
            }
            if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                int result;
                JColorChooser cc = UIUtil.colorChooser;
                if (save == null) {
                    if (this.boxStyle instanceof DefaultAreaInterface) {
                        cc.setColor(((DefaultAreaInterface)((Object)this.boxStyle)).getDefaultFillColor());
                    }
                } else {
                    cc.setColor(save);
                }
                cc.setPreviewPanel(new JPanel());
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add(cc);
                Container container = this.getTopLevelAncestor();
                if (!(container instanceof JFrame)) {
                    container = null;
                }
                if ((result = SGDialog.showInputDialog((JFrame)container, RB.getStringResource("morecolors.txt"), panel)) == 0) {
                    Color newColor = cc.getColor();
                    if (newColor == null) {
                        if (save == null) {
                            this.fillColor.setSelectedItem(this.defaultFillColorSource);
                        } else {
                            this.fillColor.setSelectedItem(save);
                        }
                    } else if (save == null || save.getRGB() != newColor.getRGB()) {
                        this.boxStyle.setFillColor(newColor);
                        this.fillColor.setSelectedItem(newColor);
                    }
                    this.boxStyle.setEditingState(6);
                    return;
                }
                if (save == null) {
                    this.fillColor.setSelectedItem(this.defaultFillColorSource);
                } else {
                    this.fillColor.setSelectedItem(save);
                }
                this.boxStyle.setEditingState(6);
                return;
            }
            if (((String)item).equals(this.defaultFillColorSource)) {
                this.boxStyle.setFillColor(null);
                this.boxStyle.setEditingState(6);
                return;
            }
            Container c = this.getTopLevelAncestor();
            if (c instanceof SGDialog) {
                SGDialog sgd = (SGDialog)c;
                sgd.value = -1;
                this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                c.setVisible(false);
                this.dialog.setVisible(true);
            }
            c = this.colorGrabber.grabComponent.getTopLevelAncestor();
            c.requestFocus();
            if (this.dialog != null) {
                this.dialog.toFront();
            }
            this.colorGrabber.grabComponent.repaint();
            this.colorGrabber.setMouseEventListener();
            this.colorGrabber.addActionListener(this);
            if (save == null) {
                this.colorGrabber.setStartColor(this.defaultFillColorSource);
                return;
            }
            this.colorGrabber.setStartColor(save);
            return;
        }
        if (cmd.equals("colorpicker:done")) {
            Object newColor = ((SwatchActionEvent)e).getValue();
            this.fillColor.setSelectedItem(newColor);
            this.fillColor.setEnabled(true);
            this.colorGrabber.removeMouseEventListener();
            this.colorGrabber.removeActionListener(this);
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.boxStyle.setEditingState(6);
            return;
        }
        if (cmd.equals("colorpicker:updating")) {
            int i;
            Color color = (Color)((SwatchActionEvent)e).getValue();
            if (color == null) return;
            ActionListener[] listener = this.fillColor.getActionListeners();
            for (i = 0; i < listener.length; ++i) {
                this.fillColor.removeActionListener(listener[i]);
            }
            this.fillColor.setSelectedItem(color);
            this.fillColor.setEnabled(true);
            i = 0;
            while (i < listener.length) {
                this.fillColor.addActionListener(listener[i]);
                ++i;
            }
            return;
        }
        if (!cmd.equals("fillstyle")) return;
        ((FillStyleElementInterface)((Object)this.boxStyle)).setFillStyleElement((String)this.fstyle.getSelectedItem());
        Color c = this.boxStyle.getFillColor();
        this.fillColor.removeActionListener(this);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        this.fillColor.addActionListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value1 = this.transparency.getModel().getValue();
        if (!this.transparency.getValueIsAdjusting()) {
            this.boxStyle.setFillTrans(value1);
        }
    }
}

