/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.RichTextInterface;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SimpleTextCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RichTextCustomizerPanel
extends SimpleTextCustomizerPanel
implements ActionListener {
    JRadioButton sup;
    JRadioButton sub;
    JRadioButton plain;

    public RichTextCustomizerPanel(RichTextInterface textStyle) {
        super(textStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        boolean issub = ((RichTextInterface)this.textStyle).isSubscript();
        boolean issup = ((RichTextInterface)this.textStyle).isSuperscript();
        ButtonGroup bg = new ButtonGroup();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.plain = new JRadioButton(RB.getStringResource("plain.txt"));
        this.plain.setSelected(!issub && !issup);
        this.plain.setActionCommand("plain");
        bg.add(this.plain);
        this.plain.setMaximumSize(this.plain.getPreferredSize());
        panel.add(this.plain);
        panel.add(Box.createHorizontalGlue());
        this.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.sub = new JRadioButton(RB.getStringResource("sub.txt"));
        this.sub.setSelected(issub);
        this.sub.setActionCommand("sub");
        bg.add(this.sub);
        this.sub.setMaximumSize(this.sub.getPreferredSize());
        panel.add(this.sub);
        panel.add(Box.createHorizontalGlue());
        this.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.sup = new JRadioButton(RB.getStringResource("sup.txt"));
        this.sup.setSelected(issup);
        this.sup.setActionCommand("sup");
        bg.add(this.sup);
        this.sup.setMaximumSize(this.sup.getPreferredSize());
        panel.add(this.sup);
        panel.add(Box.createHorizontalGlue());
        this.add(panel);
        this.plain.addActionListener(this);
        this.sup.addActionListener(this);
        this.sub.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("sub")) {
            boolean val = this.sub.isSelected();
            ((RichTextInterface)this.textStyle).setSubscript(val);
            if (val) {
                ((RichTextInterface)this.textStyle).setSuperscript(false);
            }
        } else if (cmd.equals("sup")) {
            boolean val = this.sup.isSelected();
            ((RichTextInterface)this.textStyle).setSuperscript(this.sup.isSelected());
            if (val) {
                ((RichTextInterface)this.textStyle).setSubscript(false);
            }
        } else if (cmd.equals("plain") && this.plain.isSelected()) {
            ((RichTextInterface)this.textStyle).setSuperscript(false);
            ((RichTextInterface)this.textStyle).setSubscript(false);
        } else {
            super.actionPerformed(e);
        }
    }
}

