/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.AxisInterface;
import com.sas.graphics.sg.interfaces.OverlayContainerInterface;
import com.sas.graphics.sg.interfaces.OverlayInterface;
import com.sas.graphics.sg.ui.AxisCustomizerPanel;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.GraphCellCustomizerPanel;
import com.sas.graphics.sg.ui.PlotCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SimpleAxisCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PlotAreaCustomizerPanel
extends JPanel {
    public static final String RB_KEY = "PlotAreaCustomizerPanel.";
    PlotCustomizerPanel plotPanel;
    JPanel axisPanel;
    GraphCellCustomizerPanel graphPanel;
    OverlayContainerInterface graph;
    ColorGrabber colorGrabber = null;
    protected JTabbedPane tabbedPane = null;

    public PlotAreaCustomizerPanel(OverlayContainerInterface graph, Object curObject) {
        this(graph, curObject, null, null);
    }

    public PlotAreaCustomizerPanel(OverlayContainerInterface graph, Object curObject, ColorGrabber colorGrabber) {
        this(graph, curObject, null, colorGrabber);
    }

    public PlotAreaCustomizerPanel(OverlayContainerInterface graph, Object curObject, PlotCustomizerPanel plotPanel) {
        this(graph, curObject, plotPanel, null);
    }

    public PlotAreaCustomizerPanel(OverlayContainerInterface graph, Object curObject, PlotCustomizerPanel plotPanel, ColorGrabber cg) {
        super(new GridLayout(1, 1));
        this.graph = graph;
        this.colorGrabber = cg;
        OverlayInterface[] allOverlays = graph.getAllOverlays();
        AxisInterface[] allAxes = graph.getAllAxes();
        int curOverlay = 0;
        int curAxis = 0;
        int curTab = 0;
        if (curObject instanceof OverlayInterface) {
            for (int i = 0; i < allOverlays.length; ++i) {
                if (allOverlays[i] != curObject) continue;
                curOverlay = i;
                curTab = 1;
                break;
            }
        } else if (curObject instanceof AxisInterface) {
            for (int i = 0; i < allAxes.length; ++i) {
                if (allAxes[i] != curObject) continue;
                curAxis = i;
                curTab = 2;
                break;
            }
        }
        this.plotPanel = plotPanel == null ? new PlotCustomizerPanel(allOverlays, curOverlay, this.colorGrabber) : plotPanel;
        this.axisPanel = allAxes != null && allAxes.length > 0 ? (allAxes[0].getValueTextStyle() != null ? new AxisCustomizerPanel(allAxes, curAxis) : new SimpleAxisCustomizerPanel(allAxes, curAxis, this.colorGrabber)) : null;
        this.graphPanel = new GraphCellCustomizerPanel(graph, this.colorGrabber);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(RB.getStringResource("general.txt"), this.graphPanel);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "plots.txt"), this.plotPanel);
        if (allOverlays.length == 0) {
            this.tabbedPane.setEnabledAt(1, false);
        }
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "axes.txt"), this.axisPanel);
        if (allAxes.length == 0) {
            this.tabbedPane.setEnabledAt(2, false);
        }
        this.tabbedPane.setMnemonicAt(2, 51);
        this.tabbedPane.setSelectedIndex(curTab);
        this.add(this.tabbedPane);
    }

    public void setGeneralPropertiesEnabled(boolean value) {
        if (!value && this.tabbedPane.getSelectedIndex() == 0) {
            this.tabbedPane.setSelectedIndex(1);
        }
        this.tabbedPane.setEnabledAt(0, value);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        return new Dimension(ps.width + 16 * UIUtil.DLU, ps.height + 7 * UIUtil.DLU);
    }

    public void updateCurrentValues() {
        if (this.plotPanel != null) {
            this.plotPanel.updateCurrentValues();
        }
        if (this.graphPanel != null) {
            this.graphPanel.updateCurrentValues();
        }
    }
}

