/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.elements.SGMarker;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JLabel;

class MarkerLabel
extends JLabel {
    private boolean displayText = true;
    MarkerInterface marker;
    LineInterface line;

    public MarkerLabel() {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
    }

    public MarkerLabel(MarkerInterface m) {
        this();
        this.marker = m;
    }

    public MarkerLabel(MarkerInterface m, LineInterface l) {
        this();
        this.marker = m;
        this.line = l;
    }

    public void setMarker(MarkerInterface m) {
        this.marker = m;
    }

    public void setLine(LineInterface l) {
        this.line = l;
    }

    public void displayText(boolean flag) {
        this.displayText = flag;
    }

    public void setMarker(String markerName, boolean selected) {
        if (markerName.equals(RB.getStringResource("morecolorsdots.txt"))) {
            if (this.displayText) {
                super.setText(markerName);
            }
            this.marker = null;
        } else {
            if (this.displayText) {
                super.setText(UIUtil.getLocalizedMarker(markerName));
            }
            this.marker = new SGMarker(Markers.getShape((String)Util.toGL(markerName)), 15, this.getForeground());
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        super.paintComponent(g);
        Rectangle b = this.getBounds();
        int size = this.marker == null ? 13 : Math.min(b.height - UIUtil.DLU * 6, 13);
        int xo = this.displayText ? g.getFontMetrics().stringWidth(this.getText()) + this.getIconTextGap() + size / 2 : b.width / 2;
        int yo = b.height / 2;
        if (this.marker != null) {
            Markers.draw((Graphics)g, (Color)this.marker.getMarkerColor(), null, (int)this.marker.getMarkerSymbol(), (int)size, (int)xo, (int)yo);
        }
        if (this.line != null && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke save = g2.getStroke();
            BasicStroke stroke = SASLinePatterns.getStroke((int)this.line.getLinePattern(), (int)this.line.getLineWidth());
            g2.setColor(this.line.getLineColor());
            g2.setStroke(stroke);
            g2.drawLine(xo - size, yo, xo + size, yo);
            g2.setStroke(save);
        }
    }
}

