/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.elements.SGLine;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JLabel;

public class LineLabel
extends JLabel {
    protected boolean displayText = false;
    LineInterface line;

    public LineLabel() {
        this.setHorizontalAlignment(2);
    }

    public LineLabel(LineInterface l) {
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        this.setIconTextGap(8);
    }

    public void setLine(LineInterface l) {
        this.line = l;
    }

    public void displayText(boolean flag) {
        this.displayText = flag;
    }

    public void setLine(String lineName, boolean selected) {
        if (lineName.equals(RB.getStringResource("morecolorsdots.txt"))) {
            super.setText(lineName);
            this.line = null;
        } else {
            boolean thickness = false;
            try {
                int width = Integer.parseInt(lineName);
                thickness = true;
                this.line = new SGLine(1, width, this.getForeground());
            }
            catch (NumberFormatException e) {
                this.line = new SGLine(Util.getLineEnum(lineName), 2, this.getForeground());
            }
            if (this.displayText) {
                String[] sizeList = thickness ? UIUtil.getLineThickness() : UIUtil.getLines();
                String assigned = lineName;
                lineName = " ";
                for (int i = 0; i < sizeList.length; ++i) {
                    if (!assigned.equals(sizeList[i])) continue;
                    lineName = Integer.toString(i + 1);
                    break;
                }
                super.setText(lineName);
                if (this.getHorizontalTextPosition() == 11) {
                    super.setHorizontalAlignment(4);
                } else {
                    super.setHorizontalAlignment(2);
                }
            } else {
                super.setText(null);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle b = this.getBounds();
        int xo = 2 * UIUtil.DLU;
        int yo = 2 * UIUtil.DLU + b.height / 2;
        if (this.line != null && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke save = g2.getStroke();
            BasicStroke stroke = Util.getStroke(this.line.getLinePattern(), this.line.getLineWidth());
            g2.setColor(this.getForeground());
            if (stroke != null) {
                g2.setStroke(stroke);
                String text = this.getText();
                if (this.displayText && text != null && text.length() > 0) {
                    int dx = g2.getFontMetrics().stringWidth(text) + this.getIconTextGap();
                    if (this.getHorizontalTextPosition() == 11) {
                        g2.drawLine(xo, yo, xo + b.width - dx - 4 * UIUtil.DLU, yo);
                    } else {
                        g2.drawLine(xo + dx, yo, xo + b.width - 4 * UIUtil.DLU, yo);
                    }
                } else {
                    g2.drawLine(xo, yo, xo + b.width - 2 * UIUtil.DLU, yo);
                }
                g2.setStroke(save);
            }
        }
    }
}

