/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.interfaces.DefaultBackInterface;
import com.sas.graphics.sg.interfaces.LegendInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LegendCustomizerPanel
extends JPanel
implements ActionListener,
ChangeListener {
    public static final String RB_KEY = "LegendCustomizerPanel.";
    protected static final String[] d_outsideList = new String[]{RB.getStringResource("LegendCustomizerPanel.", "top.txt"), RB.getStringResource("LegendCustomizerPanel.", "bottom.txt"), RB.getStringResource("LegendCustomizerPanel.", "left.txt"), RB.getStringResource("LegendCustomizerPanel.", "right.txt")};
    protected static final String[] d_insideList = new String[]{RB.getStringResource("LegendCustomizerPanel.", "top.txt"), RB.getStringResource("LegendCustomizerPanel.", "bottom.txt"), RB.getStringResource("LegendCustomizerPanel.", "left.txt"), RB.getStringResource("LegendCustomizerPanel.", "right.txt"), RB.getStringResource("LegendCustomizerPanel.", "center.txt"), RB.getStringResource("LegendCustomizerPanel.", "topleft.txt"), RB.getStringResource("LegendCustomizerPanel.", "topright.txt"), RB.getStringResource("LegendCustomizerPanel.", "bottomleft.txt"), RB.getStringResource("LegendCustomizerPanel.", "bottomright.txt")};
    protected static final String[] c_List = new String[]{RB.getStringResource("LegendCustomizerPanel.", "top.txt"), RB.getStringResource("LegendCustomizerPanel.", "bottom.txt"), RB.getStringResource("LegendCustomizerPanel.", "left.txt"), RB.getStringResource("LegendCustomizerPanel.", "right.txt"), RB.getStringResource("LegendCustomizerPanel.", "center.txt")};
    private static final Border emptyBorder = BorderFactory.createEmptyBorder(4 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU);
    private boolean isDiscrete;
    private LegendInterface legend;
    private SwatchComboBox fillColor;
    private SwatchComboBox outlineColor;
    String defaultColorSource = "";
    private JComboBox outsideBox;
    private JComboBox insideBox;
    private JCheckBox backCB;
    private JCheckBox borderCB;
    private JSpinner row;
    private JSpinner column;
    ColorGrabber colorGrabber;
    protected JPanel positionPanel;
    protected JPanel appearancePanel;
    private boolean settingFillColor = true;
    private JDialog dialog = null;

    public LegendCustomizerPanel(LegendInterface legend) {
        this(legend, null);
    }

    public LegendCustomizerPanel(LegendInterface legend, ColorGrabber cg) {
        this.legend = legend;
        this.isDiscrete = legend.isDiscrete();
        this.colorGrabber = cg;
        this.init();
    }

    protected void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.appearancePanel = this.createAppearancePanel();
        this.add(this.appearancePanel);
        this.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        this.add(Box.createVerticalGlue());
        this.positionPanel = this.createPositionPanel();
        this.add(this.positionPanel);
        this.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        this.add(Box.createVerticalGlue());
        this.setBorder(BorderFactory.createEmptyBorder(7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU));
    }

    protected JPanel createAppearancePanel() {
        JPanel appPanel = new JPanel();
        appPanel.setLayout(new BoxLayout(appPanel, 1));
        Color defaultFillColor = null;
        Color defaultLineColor = null;
        if (this.legend instanceof DefaultBackInterface) {
            DefaultBackInterface das = (DefaultBackInterface)((Object)this.legend);
            defaultFillColor = das.getDefaultBackgroundColor();
            this.defaultColorSource = RB.getStringResource("automatic.txt");
            defaultLineColor = das.getDefaultBorderColor();
        }
        JPanel fillPanel = new JPanel();
        fillPanel.setLayout(new BoxLayout(fillPanel, 0));
        this.backCB = new JCheckBox(RB.getStringResource("fill.txt"));
        fillPanel.add(this.backCB);
        fillPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.backCB.setActionCommand("back");
        boolean backOn = this.legend.isBackgroundOn();
        this.backCB.setSelected(backOn);
        this.backCB.addActionListener(this);
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultFillColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.legend.getBackgroundColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultColorSource, defaultFillColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultColorSource);
        }
        this.fillColor.setRenderer(new SwatchRenderer());
        this.fillColor.addActionListener(this);
        this.fillColor.setEnabled(backOn);
        this.fillColor.setActionCommand("backColor");
        fillPanel.add(this.fillColor);
        fillPanel.add(Box.createHorizontalGlue());
        appPanel.add(fillPanel);
        appPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        JPanel outlinePanel = new JPanel();
        outlinePanel.setLayout(new BoxLayout(outlinePanel, 0));
        this.borderCB = new JCheckBox(RB.getStringResource("outline.txt"));
        outlinePanel.add(this.borderCB);
        outlinePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.borderCB.setActionCommand("border");
        boolean borderOn = this.legend.isBorderOn();
        this.borderCB.setSelected(borderOn);
        this.borderCB.addActionListener(this);
        Dimension bkps = this.backCB.getPreferredSize();
        Dimension bops = this.borderCB.getPreferredSize();
        Dimension ps = new Dimension(Math.max(bkps.width, bops.width), Math.max(bkps.height, bops.height));
        this.backCB.setPreferredSize(ps);
        this.borderCB.setPreferredSize(ps);
        this.backCB.setMaximumSize(ps);
        this.borderCB.setMaximumSize(ps);
        this.outlineColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultLineColor, RB.getStringResource("morecolorsdots.txt"));
        c = this.legend.getBorderColor();
        this.outlineColor.setEditable(true);
        editor = new ColorComboBoxEditor(this.defaultColorSource, defaultLineColor);
        this.outlineColor.setEditor(editor);
        editor.addMouseListener(this.outlineColor);
        if (c != null) {
            this.outlineColor.setSelectedItem(c);
        } else {
            this.outlineColor.setSelectedItem(this.defaultColorSource);
        }
        this.outlineColor.setRenderer(new SwatchRenderer());
        this.outlineColor.addActionListener(this);
        this.outlineColor.setActionCommand("borderColor");
        this.outlineColor.setEnabled(borderOn);
        bkps = this.fillColor.getPreferredSize();
        bops = this.outlineColor.getPreferredSize();
        ps = new Dimension(100, Math.max(bkps.height, bops.height));
        this.outlineColor.setPreferredSize(ps);
        this.fillColor.setPreferredSize(ps);
        this.outlineColor.setMaximumSize(ps);
        this.fillColor.setMaximumSize(ps);
        outlinePanel.add(this.outlineColor);
        outlinePanel.add(Box.createHorizontalGlue());
        appPanel.add(outlinePanel);
        appPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), RB.getStringResource(RB_KEY, "appearance.txt")), emptyBorder));
        return appPanel;
    }

    protected JPanel createPositionPanel() {
        boolean enabled = this.legend.isPositionEnabled();
        JPanel posPanel = new JPanel();
        posPanel.setLayout(new BoxLayout(posPanel, 1));
        ButtonGroup location = new ButtonGroup();
        JPanel outsidePanel = new JPanel();
        outsidePanel.setLayout(new BoxLayout(outsidePanel, 0));
        boolean isInside = this.legend.isInside();
        JRadioButton orb = new JRadioButton(RB.getStringResource(RB_KEY, "outsidePlotArea.txt"));
        orb.setSelected(!isInside);
        orb.addActionListener(this);
        orb.setActionCommand("outside");
        orb.setEnabled(enabled);
        outsidePanel.add(orb);
        outsidePanel.add(Box.createRigidArea(new Dimension(7 * UIUtil.DLU, 0)));
        location.add(orb);
        this.outsideBox = new JComboBox<String>(d_outsideList);
        if (enabled) {
            int pos = UIUtil.swingToList(this.legend.getOutsidePosition());
            if (pos == 8) {
                pos = 1;
            }
            this.outsideBox.setSelectedIndex(pos);
            this.outsideBox.addActionListener(this);
            this.outsideBox.setActionCommand("outposition");
            this.outsideBox.setEnabled(!isInside);
        } else {
            this.outsideBox.addItem(" ");
            this.outsideBox.setSelectedItem(" ");
            this.outsideBox.setEnabled(false);
        }
        outsidePanel.add(this.outsideBox);
        outsidePanel.add(Box.createHorizontalGlue());
        posPanel.add(outsidePanel);
        posPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel insidePanel = new JPanel();
        insidePanel.setLayout(new BoxLayout(insidePanel, 0));
        JRadioButton irb = new JRadioButton(RB.getStringResource(RB_KEY, "insidePlotArea.txt"));
        irb.setSelected(this.legend.isInside());
        irb.addActionListener(this);
        irb.setActionCommand("inside");
        irb.setEnabled(enabled);
        insidePanel.add(irb);
        insidePanel.add(Box.createRigidArea(new Dimension(7 * UIUtil.DLU, 0)));
        location.add(irb);
        Dimension ops = orb.getPreferredSize();
        Dimension ips = irb.getPreferredSize();
        Dimension ps = new Dimension(Math.max(ips.width, ops.width), Math.max(ips.height, ops.height));
        orb.setPreferredSize(ps);
        irb.setPreferredSize(ps);
        this.insideBox = new JComboBox<String>(this.isDiscrete ? d_insideList : c_List);
        if (enabled) {
            this.insideBox.setSelectedIndex(UIUtil.swingToList(this.legend.getInsidePosition()));
            this.insideBox.addActionListener(this);
            this.insideBox.setActionCommand("inposition");
            this.insideBox.setEnabled(isInside);
        } else {
            this.insideBox.addItem(" ");
            this.insideBox.setSelectedItem(" ");
            this.insideBox.setEnabled(false);
        }
        insidePanel.add(this.insideBox);
        insidePanel.add(Box.createHorizontalGlue());
        ps = this.outsideBox.getPreferredSize();
        Dimension dd = this.insideBox.getPreferredSize();
        if (ps.width < dd.width) {
            ps.width = dd.width;
        }
        if (ps.height < dd.height) {
            ps.height = dd.height;
        }
        this.outsideBox.setPreferredSize(ps);
        this.outsideBox.setMaximumSize(ps);
        this.insideBox.setPreferredSize(ps);
        this.insideBox.setMaximumSize(ps);
        posPanel.add(insidePanel);
        posPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), RB.getStringResource(RB_KEY, "position.txt")), emptyBorder));
        return posPanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Container parent;
        JPanel panel;
        JColorChooser cc;
        Color save;
        block49: {
            Object src;
            String cmd;
            block48: {
                cmd = e.getActionCommand();
                src = e.getSource();
                if (cmd.equals("backColor")) {
                    Object item = this.fillColor.getSelectedItem();
                    if (item == null) return;
                    Color save2 = this.legend.getBackgroundColor();
                    if (!(item instanceof String)) {
                        if (!(item instanceof Color)) return;
                        this.legend.setBackgroundColor((Color)item);
                        return;
                    }
                    if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                        int result;
                        JColorChooser cc2 = UIUtil.colorChooser;
                        if (save2 == null) {
                            if (this.legend instanceof DefaultBackInterface) {
                                cc2.setColor(((DefaultBackInterface)((Object)this.legend)).getDefaultBackgroundColor());
                            }
                        } else {
                            cc2.setColor(save2);
                        }
                        cc2.setPreviewPanel(new JPanel());
                        JPanel panel2 = new JPanel();
                        panel2.setLayout(new BorderLayout());
                        panel2.add(cc2);
                        Container container = this.getTopLevelAncestor();
                        if (!(container instanceof JFrame)) {
                            container = null;
                        }
                        if ((result = SGDialog.showInputDialog((JFrame)container, RB.getStringResource("morecolors.txt"), panel2)) == 0) {
                            Color newColor = cc2.getColor();
                            if (newColor == null) {
                                if (save2 == null) {
                                    this.fillColor.setSelectedItem(this.defaultColorSource);
                                    return;
                                }
                                this.fillColor.setSelectedItem(save2);
                                return;
                            }
                            if (save2 != null) {
                                if (save2.getRGB() == newColor.getRGB()) return;
                            }
                            this.legend.setBackgroundColor(newColor);
                            this.fillColor.setSelectedItem(newColor);
                            return;
                        }
                        if (save2 == null) {
                            this.fillColor.setSelectedItem(this.defaultColorSource);
                            return;
                        }
                        this.fillColor.setSelectedItem(save2);
                        return;
                    }
                    if (((String)item).equals(this.defaultColorSource)) {
                        this.legend.setBackgroundColor(null);
                        return;
                    }
                    Container c = this.getTopLevelAncestor();
                    if (c instanceof SGDialog) {
                        SGDialog sgd = (SGDialog)c;
                        sgd.value = -1;
                        this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                        c.setVisible(false);
                        this.dialog.setVisible(true);
                    }
                    c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                    c.requestFocus();
                    if (this.dialog != null) {
                        this.dialog.toFront();
                    }
                    this.colorGrabber.grabComponent.repaint();
                    this.colorGrabber.setMouseEventListener();
                    this.colorGrabber.addActionListener(this);
                    if (save2 == null) {
                        this.colorGrabber.setStartColor(this.defaultColorSource);
                    } else {
                        this.colorGrabber.setStartColor(save2);
                    }
                    this.settingFillColor = true;
                    return;
                }
                if (cmd.equals("colorpicker:done")) {
                    Object color = ((SwatchActionEvent)e).getValue();
                    if (this.settingFillColor) {
                        this.fillColor.setSelectedItem(color);
                    } else {
                        this.outlineColor.setSelectedItem(color);
                    }
                    this.colorGrabber.removeMouseEventListener();
                    this.colorGrabber.removeActionListener(this);
                    if (this.dialog == null) return;
                    this.dialog.dispose();
                    return;
                }
                if (cmd.equals("colorpicker:updating")) {
                    int i;
                    Color color = (Color)((SwatchActionEvent)e).getValue();
                    if (color == null) return;
                    if (this.settingFillColor) {
                        int i2;
                        ActionListener[] listener = this.fillColor.getActionListeners();
                        for (i2 = 0; i2 < listener.length; ++i2) {
                            this.fillColor.removeActionListener(listener[i2]);
                        }
                        this.fillColor.setSelectedItem(color);
                        this.fillColor.setEnabled(true);
                        i2 = 0;
                        while (i2 < listener.length) {
                            this.fillColor.addActionListener(listener[i2]);
                            ++i2;
                        }
                        return;
                    }
                    ActionListener[] listener = this.outlineColor.getActionListeners();
                    for (i = 0; i < listener.length; ++i) {
                        this.outlineColor.removeActionListener(listener[i]);
                    }
                    this.outlineColor.setSelectedItem(color);
                    this.outlineColor.setEnabled(true);
                    i = 0;
                    while (i < listener.length) {
                        this.outlineColor.addActionListener(listener[i]);
                        ++i;
                    }
                    return;
                }
                if (cmd.equals("back")) {
                    boolean backOn = ((JCheckBox)src).isSelected();
                    this.legend.setBackgroundOn(backOn);
                    this.fillColor.setEnabled(backOn);
                    return;
                }
                if (!cmd.equals("borderColor")) break block48;
                Object item = this.outlineColor.getSelectedItem();
                if (item == null) return;
                save = this.legend.getBorderColor();
                if (!(item instanceof String)) {
                    if (!(item instanceof Color)) return;
                    this.legend.setBorderColor((Color)item);
                    return;
                }
                if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                    cc = UIUtil.colorChooser;
                    if (save == null) {
                        if (this.legend instanceof DefaultAreaInterface) {
                            cc.setColor(((DefaultAreaInterface)((Object)this.legend)).getDefaultLineColor());
                        }
                    } else {
                        cc.setColor(save);
                    }
                    cc.setPreviewPanel(new JPanel());
                    panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add(cc);
                    break block49;
                } else {
                    if (((String)item).equals(this.defaultColorSource)) {
                        this.legend.setBorderColor(null);
                        return;
                    }
                    Container c = this.getTopLevelAncestor();
                    if (c instanceof SGDialog) {
                        SGDialog sgd = (SGDialog)c;
                        sgd.value = -1;
                        this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                        c.setVisible(false);
                        this.dialog.setVisible(true);
                    }
                    c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                    c.requestFocus();
                    if (this.dialog != null) {
                        this.dialog.toFront();
                    }
                    this.colorGrabber.setMouseEventListener();
                    this.colorGrabber.addActionListener(this);
                    if (save == null) {
                        this.colorGrabber.setStartColor(this.defaultColorSource);
                    } else {
                        this.colorGrabber.setStartColor(save);
                    }
                    this.settingFillColor = false;
                    return;
                }
            }
            if (cmd.equals("border")) {
                boolean borderOn = ((JCheckBox)src).isSelected();
                this.legend.setBorderOn(borderOn);
                this.outlineColor.setEnabled(borderOn);
                return;
            }
            if (cmd.equals("inside")) {
                this.insideBox.setEnabled(true);
                this.outsideBox.setEnabled(false);
                this.legend.setInside(true);
                this.backCB.removeActionListener(this);
                this.backCB.setSelected(this.legend.isBackgroundOn());
                this.backCB.addActionListener(this);
                return;
            }
            if (cmd.equals("outside")) {
                this.insideBox.setEnabled(false);
                this.outsideBox.setEnabled(true);
                this.legend.setInside(false);
                this.backCB.removeActionListener(this);
                this.backCB.setSelected(this.legend.isBackgroundOn());
                this.backCB.addActionListener(this);
                return;
            }
            if (cmd.equals("inposition")) {
                this.legend.setInsidePosition(UIUtil.listToSwing(((JComboBox)src).getSelectedIndex()));
                return;
            }
            if (!cmd.equals("outposition")) return;
            this.legend.setOutsidePosition(UIUtil.listToSwing(((JComboBox)src).getSelectedIndex()));
            return;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
        if (result == 0) {
            Color newColor = cc.getColor();
            if (newColor == null) {
                if (save == null) {
                    this.outlineColor.setSelectedItem(this.defaultColorSource);
                    return;
                }
                this.outlineColor.setSelectedItem(save);
                return;
            }
            if (save != null) {
                if (save.getRGB() == newColor.getRGB()) return;
            }
            this.legend.setBorderColor(newColor);
            this.outlineColor.setSelectedItem(newColor);
            return;
        }
        if (save == null) {
            this.outlineColor.setSelectedItem(this.defaultColorSource);
            return;
        }
        this.outlineColor.setSelectedItem(save);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.row) {
            this.legend.setNumberOfRows(((Number)this.row.getValue()).intValue());
        } else if (src == this.column) {
            this.legend.setNumberOfColumns(((Number)this.column.getValue()).intValue());
        }
    }
}

