/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.HighLowInterface;
import com.sas.graphics.sg.ui.AreaCustomizerPanel;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HighLowCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    private static String[] tvalues = new String[]{RB.getStringResource("bar.txt"), RB.getStringResource("sline.txt")};
    private static String[] values = new String[]{"bar", "line"};
    HighLowInterface highlow;
    ColorGrabber colorGrabber = null;
    LineCustomizerPanel linePanel;
    AreaCustomizerPanel areaPanel;
    private JComboBox type;

    public HighLowCustomizerPanel(HighLowInterface highlow) {
        this(highlow, null);
    }

    public HighLowCustomizerPanel(HighLowInterface highlow, ColorGrabber cg) {
        this.highlow = highlow;
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        JLabel label = new JLabel(RB.getStringResource("type.txt"));
        typePanel.add(label);
        this.labels.add(label);
        typePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.type = new JComboBox<String>(tvalues);
        this.type.setActionCommand("type");
        String value = this.highlow.getDisplayType();
        int index = 1;
        if (value == null || value.length() == 0 || value.equalsIgnoreCase(values[0])) {
            index = 0;
        }
        this.type.setSelectedIndex(index);
        this.type.addActionListener(this);
        typePanel.add(this.type);
        typePanel.add(Box.createHorizontalGlue());
        this.widgets.add(this.type);
        this.add(typePanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.linePanel = new LineCustomizerPanel(this.highlow, this.colorGrabber);
        this.linePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("sline.txt")), BorderFactory.createEmptyBorder(0, UIUtil.DLU * 7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
        this.areaPanel = new AreaCustomizerPanel(this.highlow, this.colorGrabber);
        this.areaPanel.setBorder(null);
        Dimension ps1 = this.linePanel.getLabelPreferredSize();
        Dimension ps2 = label.getPreferredSize();
        ps2.setSize(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        ps1 = this.areaPanel.getLabelPreferredSize();
        this.labelSize.setSize(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        ps1 = this.type.getPreferredSize();
        ps2 = this.linePanel.getWidgetPreferredSize();
        ps2.setSize(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        ps1 = this.areaPanel.getWidgetPreferredSize();
        this.widgetSize.setSize(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        this.setLabelPreferredSize(this.labelSize);
        this.setWidgetPreferredSize(this.widgetSize);
        this.linePanel.setLabelPreferredSize(this.labelSize);
        this.linePanel.setWidgetPreferredSize(this.widgetSize);
        this.areaPanel.setLabelPreferredSize(this.labelSize);
        this.areaPanel.setWidgetPreferredSize(this.widgetSize);
        if (index == 0) {
            this.add(this.areaPanel);
        } else {
            this.add(this.linePanel);
        }
    }

    @Override
    public void setValue(Object style) {
        if (!(style instanceof HighLowInterface)) {
            return;
        }
        this.highlow = (HighLowInterface)style;
        this.type.removeActionListener(this);
        String value = this.highlow.getDisplayType();
        int index = 1;
        if (value == null || value.length() == 0 || value.equalsIgnoreCase(values[0])) {
            index = 0;
        }
        this.type.setSelectedIndex(index);
        this.type.addActionListener(this);
        this._setPanel(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("type")) {
            String oldvalue;
            int index = ((JComboBox)e.getSource()).getSelectedIndex();
            String value = values[index];
            if (value.equalsIgnoreCase(oldvalue = this.highlow.getDisplayType())) {
                return;
            }
            this.highlow.setDisplayType(value);
            this._setPanel(index);
            this.invalidate();
            this.validate();
        } else {
            int index = this.type.getSelectedIndex();
            if (index == 0) {
                this.areaPanel.actionPerformed(e);
            } else {
                this.linePanel.actionPerformed(e);
            }
        }
    }

    private void _setPanel(int index) {
        if (index == 0) {
            this.areaPanel.setValue(this.highlow);
            if (this.linePanel.getParent() != null) {
                this.remove(this.linePanel);
            }
            if (this.areaPanel.getParent() == null) {
                this.add(this.areaPanel);
            }
        } else {
            this.linePanel.setValue(this.highlow);
            if (this.areaPanel.getParent() != null) {
                this.remove(this.areaPanel);
            }
            if (this.linePanel.getParent() == null) {
                this.add(this.linePanel);
            }
        }
    }
}

