/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.HeatMapInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.MyCheckBox;
import com.sas.graphics.sg.ui.PlotCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class HeatMapCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    private static final int dlu2 = UIUtil.DLU * 2;
    HeatMapInterface heatmap;
    ColorGrabber colorGrabber = null;
    LineCustomizerPanel linePanel;
    protected JPanel titlePanel;
    private JCheckBox edge;
    CompTitledBorder border;

    public HeatMapCustomizerPanel(HeatMapInterface heatmap) {
        this(heatmap, null);
    }

    public HeatMapCustomizerPanel(HeatMapInterface heatmap, ColorGrabber cg) {
        this.heatmap = heatmap;
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        this.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.edge = new MyCheckBox(RB.getStringResource("displayOutline.txt"));
        boolean isEdgeOn = this.heatmap.isLineOn();
        this.edge.setSelected(isEdgeOn);
        this.edge.setActionCommand("line");
        this.edge.addActionListener(this);
        this.edge.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        this.linePanel = new LineCustomizerPanel(this.heatmap, this.colorGrabber);
        this.linePanel.setBorder(PlotCustomizerPanel.tabBorder);
        this.linePanel.setEnabledAll(isEdgeOn);
        this.linePanel.add(Box.createVerticalGlue());
        JPanel groupPanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                Rectangle compR = HeatMapCustomizerPanel.this.border.getComponentRect(rect, insets);
                HeatMapCustomizerPanel.this.edge.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                HeatMapCustomizerPanel.this.linePanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = super.getInsets();
                Dimension ps2 = HeatMapCustomizerPanel.this.linePanel.getPreferredSize();
                return new Dimension((int)ps2.getWidth(), (int)ps2.getHeight() + insets.top + insets.bottom);
            }
        };
        groupPanel.add(this.edge);
        groupPanel.add(this.linePanel);
        this.border = new CompTitledBorder((Border)new LineBorder(Color.GRAY), this.edge);
        groupPanel.setBorder(this.border);
        this.add(groupPanel);
    }

    @Override
    public void setValue(Object style) {
        if (!(style instanceof HeatMapInterface)) {
            return;
        }
        this.heatmap = (HeatMapInterface)style;
        this.linePanel.setValue(this.heatmap);
        boolean isEdgeOn = this.heatmap.isLineOn();
        this.edge.removeActionListener(this);
        this.edge.setSelected(isEdgeOn);
        this.edge.addActionListener(this);
        this.linePanel.setEnabledAll(isEdgeOn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("line")) {
            boolean selected = this.edge.isSelected();
            this.heatmap.setLineOn(selected);
            this.linePanel.setEnabledAll(selected);
        } else {
            this.linePanel.actionPerformed(e);
        }
    }
}

