/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class CustomColorChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener,
HierarchyListener,
ActionListener {
    public static final String RB_KEY = "CustomColorChooserPanel.";
    private transient CustomImage palette;
    private transient CustomImage sliderPalette;
    private transient Image paletteImage;
    private transient Image sliderPaletteImage;
    private JSlider slider;
    private JSpinner hField;
    private JSpinner sField;
    private JSpinner bField;
    private JSpinner rField;
    private JSpinner gField;
    private JSpinner blField;
    private JSpinner hexField;
    private boolean isAdjusting = false;
    private Point paletteSelection = new Point();
    private JLabel paletteLabel;
    private JLabel sliderPaletteLabel;
    private JRadioButton hRadio;
    private JRadioButton sRadio;
    private JRadioButton bRadio;
    private JRadioButton rRadio;
    private JRadioButton gRadio;
    private JRadioButton blRadio;
    private static final int PALETTE_DIMENSION = 200;
    private static final int MAX_HUE_VALUE = 359;
    private static final int MAX_SATURATION_VALUE = 100;
    private static final int MAX_BRIGHTNESS_VALUE = 100;
    private static final int MAX_RGB_VALUE = 255;
    private int currentMode = 0;
    private static final int HUE_MODE = 0;
    private static final int SATURATION_MODE = 1;
    private static final int BRIGHTNESS_MODE = 2;
    private static final int RED_MODE = 3;
    private static final int GREEN_MODE = 4;
    private static final int BLUE_MODE = 5;
    private static JComboBox REF_COMP;
    static final ColorModel cm;

    private void addPaletteListeners() {
        this.paletteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                float[] hsb = new float[3];
                CustomColorChooserPanel.this.palette.getHSBForLocation(e.getX(), e.getY(), hsb);
                CustomColorChooserPanel.this.updateHSB(hsb[0], hsb[1], hsb[2]);
            }
        });
        this.paletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int labelWidth = CustomColorChooserPanel.this.paletteLabel.getWidth();
                int labelHeight = CustomColorChooserPanel.this.paletteLabel.getHeight();
                int x = e.getX();
                int y = e.getY();
                if (x >= labelWidth) {
                    x = labelWidth - 1;
                }
                if (y >= labelHeight) {
                    y = labelHeight - 1;
                }
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                float[] hsb = new float[3];
                CustomColorChooserPanel.this.palette.getHSBForLocation(x, y, hsb);
                CustomColorChooserPanel.this.updateHSB(hsb[0], hsb[1], hsb[2]);
            }
        });
    }

    private void addSliderPaletteListeners() {
        this.sliderPaletteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                float[] hsb = new float[3];
                CustomColorChooserPanel.this.sliderPalette.getHSBForLocation(e.getX(), e.getY(), hsb);
                CustomColorChooserPanel.this.updateHSB(hsb[0], hsb[1], hsb[2]);
            }
        });
        this.sliderPaletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int labelHeight = CustomColorChooserPanel.this.sliderPaletteLabel.getHeight();
                int y = e.getY();
                if (y >= labelHeight) {
                    y = labelHeight - 1;
                }
                if (y < 0) {
                    y = 0;
                }
                float[] hsb = new float[3];
                CustomColorChooserPanel.this.sliderPalette.getHSBForLocation(10, y, hsb);
                CustomColorChooserPanel.this.updateHSB(hsb[0], hsb[1], hsb[2]);
            }
        });
    }

    private void updatePalette(float c1, float c2, float c3) {
        int x = 0;
        int y = 0;
        Color c = Color.getHSBColor(c1, c2, c3);
        switch (this.currentMode) {
            case 0: {
                if (c1 != this.palette.getHue()) {
                    this.palette.setHue(c1);
                    this.palette.nextFrame();
                }
                x = 200 - (int)(c2 * 200.0f);
                y = 200 - (int)(c3 * 200.0f);
                break;
            }
            case 1: {
                if (c2 != this.palette.getSaturation()) {
                    this.palette.setSaturation(c2);
                    this.palette.nextFrame();
                }
                x = (int)(c1 * 200.0f);
                y = 200 - (int)(c3 * 200.0f);
                break;
            }
            case 2: {
                if (c3 != this.palette.getBrightness()) {
                    this.palette.setBrightness(c3);
                    this.palette.nextFrame();
                }
                x = (int)(c1 * 200.0f);
                y = 200 - (int)(c2 * 200.0f);
                break;
            }
            case 3: {
                if (c.getRed() != this.palette.getRed()) {
                    this.palette.setRed(c.getRed());
                    this.palette.nextFrame();
                }
                x = 200 - c.getGreen() * 200 / 255;
                y = 200 - c.getBlue() * 200 / 255;
                break;
            }
            case 4: {
                if (c.getGreen() != this.palette.getGreen()) {
                    this.palette.setGreen(c.getGreen());
                    this.palette.nextFrame();
                }
                x = 200 - c.getBlue() * 200 / 255;
                y = 200 - c.getRed() * 200 / 255;
                break;
            }
            case 5: {
                if (c.getBlue() != this.palette.getBlue()) {
                    this.palette.setBlue(c.getBlue());
                    this.palette.nextFrame();
                }
                x = 200 - c.getRed() * 200 / 255;
                y = 200 - c.getGreen() * 200 / 255;
            }
        }
        this.paletteSelection.setLocation(x, y);
        this.paletteLabel.repaint();
    }

    private void updateSlider(float c1, float c2, float c3) {
        float value = 0.0f;
        Color c = Color.getHSBColor(c1, c2, c3);
        switch (this.currentMode) {
            case 0: {
                value = c1;
                if (this.sliderPalette.getHue() == c1) break;
                this.sliderPalette.setHue(c1);
                this.sliderPalette.nextFrame();
                break;
            }
            case 1: {
                value = c2;
                if (this.sliderPalette.getSaturation() == c1) break;
                this.sliderPalette.setHue(c1);
                this.sliderPalette.nextFrame();
                break;
            }
            case 2: {
                value = c3;
                if (this.sliderPalette.getBrightness() == c1) break;
                this.sliderPalette.setHue(c1);
                this.sliderPalette.nextFrame();
                break;
            }
            case 3: {
                value = (float)c.getRed() / 255.0f;
                if (this.sliderPalette.getRed() == c.getRed()) break;
                this.sliderPalette.setRed(c.getRed());
                this.sliderPalette.nextFrame();
                break;
            }
            case 4: {
                value = (float)c.getGreen() / 255.0f;
                if (this.sliderPalette.getGreen() == c.getGreen()) break;
                this.sliderPalette.setGreen(c.getGreen());
                this.sliderPalette.nextFrame();
                break;
            }
            case 5: {
                value = (float)c.getBlue() / 255.0f;
                if (this.sliderPalette.getBlue() == c.getBlue()) break;
                this.sliderPalette.setBlue(c.getBlue());
                this.sliderPalette.nextFrame();
            }
        }
        this.slider.setValue((int)(value * (float)this.slider.getMaximum()));
    }

    private void updateHSBTextFields(float hue, float saturation, float brightness) {
        int h = (int)(hue * 359.0f);
        int s = (int)(saturation * 100.0f);
        int b = (int)(brightness * 100.0f);
        if (((Number)this.hField.getValue()).intValue() != h) {
            this.hField.setValue(new Integer(h));
        }
        if (((Number)this.sField.getValue()).intValue() != s) {
            this.sField.setValue(new Integer(s));
        }
        if (((Number)this.bField.getValue()).intValue() != b) {
            this.bField.setValue(new Integer(b));
        }
    }

    private void updateRGBTextFields(int r, int g, int b) {
        if (((Number)this.rField.getValue()).intValue() != r) {
            this.rField.setValue(new Integer(r));
        }
        if (((Number)this.gField.getValue()).intValue() != g) {
            this.gField.setValue(new Integer(g));
        }
        if (((Number)this.blField.getValue()).intValue() != b) {
            this.blField.setValue(new Integer(b));
        }
    }

    private void updateHexTextFields(int rgb) {
        this.hexField.setValue(new Integer(rgb &= 0xFFFFFF));
    }

    private void updateHSB(float h, float s, float b) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.updatePalette(h, s, b);
            this.updateSlider(h, s, b);
            Color color = Color.getHSBColor(h, s, b);
            Color oldColor = this.getColorFromModel();
            if (oldColor.getRGB() != color.getRGB()) {
                this.getColorSelectionModel().setSelectedColor(color);
                this.updateHSBTextFields(h, s, b);
                this.updateRGBTextFields(color.getRed(), color.getGreen(), color.getBlue());
                this.updateHexTextFields(color.getRGB());
            }
            this.isAdjusting = false;
        }
    }

    @Override
    public void updateChooser() {
        if (!this.isAdjusting) {
            float[] hsb = this.getHSBColorFromModel();
            this.updateHSB(hsb[0], hsb[1], hsb[2]);
        }
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
        this.addHierarchyListener(this);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.cleanupPalettesIfNecessary();
        this.removeAll();
        this.removeHierarchyListener(this);
    }

    private float[] getHSBColorFromModel() {
        Color color = this.getColorFromModel();
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return hsb;
    }

    @Override
    protected void buildChooser() {
        String hueString = RB.getStringResource(RB_KEY, "hueText.txt");
        String saturationString = RB.getStringResource(RB_KEY, "saturationText.txt");
        String brightnessString = RB.getStringResource(RB_KEY, "brightnessText.txt");
        int dlu7 = 7 * UIUtil.DLU;
        int dlu3 = 3 * UIUtil.DLU;
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(dlu7, dlu7, dlu7, dlu7));
        this.add(this.buildSliderPalettePanel());
        this.add(Box.createRigidArea(new Dimension(dlu7, 0)));
        float[] hsb = this.getHSBColorFromModel();
        Color color = this.getColorFromModel();
        int rgb = color.getRGB() & 0xFFFFFF;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel hexPanel = new JPanel();
        hexPanel.setLayout(new BoxLayout(hexPanel, 0));
        JLabel hex = new JLabel(RB.getStringResource(RB_KEY, "hex.txt"));
        hex.setHorizontalAlignment(0);
        hexPanel.add(hex);
        this.hexField = new JSpinner(new SpinnerNumberModel(rgb, 0, 0xFFFFFF, 1)){

            @Override
            public Dimension getPreferredSize() {
                if (REF_COMP == null) {
                    REF_COMP = new JComboBox<String>(new String[]{Integer.toString(9999999)});
                }
                return REF_COMP.getPreferredSize();
            }
        };
        JFormattedTextField textField = ((JSpinner.DefaultEditor)this.hexField.getEditor()).getTextField();
        textField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new HexFormat())));
        textField.setColumns(6);
        hexPanel.add(this.hexField);
        ButtonGroup bg = new ButtonGroup();
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        this.hRadio = new JRadioButton(hueString);
        this.hRadio.setSelected(true);
        bg.add(this.hRadio);
        panel1.add(this.hRadio);
        this.hField = new JSpinner(new SpinnerNumberModel((int)(hsb[0] * 359.0f), 0, 359, 1));
        panel1.add(this.hField);
        Dimension ps1 = hex.getPreferredSize();
        Dimension ps2 = this.hRadio.getPreferredSize();
        Dimension ps = new Dimension(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        ps1 = this.hField.getPreferredSize();
        if (ps.height > ps1.height) {
            ps1.height = ps.height;
        } else {
            ps.height = ps1.height;
        }
        panel.add(panel1);
        panel.add(Box.createRigidArea(new Dimension(0, dlu3)));
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        this.sRadio = new JRadioButton(saturationString);
        bg.add(this.sRadio);
        panel1.add(this.sRadio);
        this.sField = new JSpinner(new SpinnerNumberModel((int)(hsb[1] * 100.0f), 0, 100, 1));
        panel1.add(this.sField);
        ps2 = this.sRadio.getPreferredSize();
        if (ps2.width > ps.width) {
            ps.width = ps2.width;
        }
        panel.add(panel1);
        panel.add(Box.createRigidArea(new Dimension(0, dlu3)));
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        this.bRadio = new JRadioButton(brightnessString);
        bg.add(this.bRadio);
        panel1.add(this.bRadio);
        this.bField = new JSpinner(new SpinnerNumberModel((int)(hsb[2] * 100.0f), 0, 100, 1));
        panel1.add(this.bField);
        ps2 = this.bRadio.getPreferredSize();
        if (ps2.width > ps.width) {
            ps.width = ps2.width;
        }
        panel.add(panel1);
        panel.add(Box.createRigidArea(new Dimension(0, 2 * dlu7)));
        String redString = RB.getStringResource(RB_KEY, "redText.txt");
        String greenString = RB.getStringResource(RB_KEY, "greenText.txt");
        String blueString = RB.getStringResource(RB_KEY, "blueText.txt");
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        this.rRadio = new JRadioButton(redString);
        bg.add(this.rRadio);
        panel1.add(this.rRadio);
        this.rField = new JSpinner(new SpinnerNumberModel(color.getRed(), 0, 255, 1));
        panel1.add(this.rField);
        ps2 = this.rRadio.getPreferredSize();
        if (ps2.width > ps.width) {
            ps.width = ps2.width;
        }
        panel.add(panel1);
        panel.add(Box.createRigidArea(new Dimension(0, dlu3)));
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        this.gRadio = new JRadioButton(greenString);
        bg.add(this.gRadio);
        panel1.add(this.gRadio);
        this.gField = new JSpinner(new SpinnerNumberModel(color.getGreen(), 0, 255, 1));
        panel1.add(this.gField);
        ps2 = this.gRadio.getPreferredSize();
        if (ps2.width > ps.width) {
            ps.width = ps2.width;
        }
        panel.add(panel1);
        panel.add(Box.createRigidArea(new Dimension(0, dlu3)));
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        this.blRadio = new JRadioButton(blueString);
        bg.add(this.blRadio);
        panel1.add(this.blRadio);
        this.blField = new JSpinner(new SpinnerNumberModel(color.getBlue(), 0, 255, 1));
        panel1.add(this.blField);
        ps2 = this.blRadio.getPreferredSize();
        if (ps2.width > ps.width) {
            ps.width = ps2.width;
        }
        panel.add(panel1);
        panel.add(Box.createVerticalGlue());
        panel.add(hexPanel);
        ps1 = this.hexField.getPreferredSize();
        ps1.height = ps.height;
        this.hRadio.setPreferredSize(ps);
        this.hRadio.setMaximumSize(ps);
        hex.setPreferredSize(ps);
        hex.setMaximumSize(ps);
        this.sRadio.setPreferredSize(ps);
        this.sRadio.setMaximumSize(ps);
        this.bRadio.setPreferredSize(ps);
        this.bRadio.setMaximumSize(ps);
        this.rRadio.setPreferredSize(ps);
        this.rRadio.setMaximumSize(ps);
        this.gRadio.setPreferredSize(ps);
        this.gRadio.setMaximumSize(ps);
        this.blRadio.setPreferredSize(ps);
        this.blRadio.setMaximumSize(ps);
        this.hexField.setPreferredSize(ps1);
        this.hexField.setMaximumSize(ps1);
        this.hField.setPreferredSize(ps1);
        this.hField.setMaximumSize(ps1);
        this.sField.setPreferredSize(ps1);
        this.sField.setMaximumSize(ps1);
        this.bField.setPreferredSize(ps1);
        this.bField.setMaximumSize(ps1);
        this.rField.setPreferredSize(ps1);
        this.rField.setMaximumSize(ps1);
        this.gField.setPreferredSize(ps1);
        this.gField.setMaximumSize(ps1);
        this.blField.setPreferredSize(ps1);
        this.blField.setMaximumSize(ps1);
        textField = ((JSpinner.DefaultEditor)this.hField.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        textField = ((JSpinner.DefaultEditor)this.sField.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        textField = ((JSpinner.DefaultEditor)this.bField.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        textField = ((JSpinner.DefaultEditor)this.rField.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        textField = ((JSpinner.DefaultEditor)this.gField.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        textField = ((JSpinner.DefaultEditor)this.blField.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        textField = ((JSpinner.DefaultEditor)this.hexField.getEditor()).getTextField();
        textField.setFocusLostBehavior(1);
        this.hField.addChangeListener(this);
        this.sField.addChangeListener(this);
        this.bField.addChangeListener(this);
        this.rField.addChangeListener(this);
        this.gField.addChangeListener(this);
        this.blField.addChangeListener(this);
        this.hexField.addChangeListener(this);
        this.hRadio.addActionListener(this);
        this.sRadio.addActionListener(this);
        this.bRadio.addActionListener(this);
        this.rRadio.addActionListener(this);
        this.gRadio.addActionListener(this);
        this.blRadio.addActionListener(this);
        this.add(panel);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj instanceof JRadioButton) {
            JRadioButton button = (JRadioButton)obj;
            if (button == this.hRadio) {
                this.setMode(0);
            } else if (button == this.sRadio) {
                this.setMode(1);
            } else if (button == this.bRadio) {
                this.setMode(2);
            } else if (button == this.rRadio) {
                this.setMode(3);
            } else if (button == this.gRadio) {
                this.setMode(4);
            } else if (button == this.blRadio) {
                this.setMode(5);
            }
        }
        if (obj instanceof JSpinner) {
            JSpinner textField = (JSpinner)obj;
            Number nn = (Number)textField.getValue();
            if (nn == null) {
                return;
            }
            float value = nn.floatValue();
            Color color = this.getColorFromModel();
            float[] hsb = this.getHSBColorFromModel();
            if (obj == this.hField) {
                this.updateHSB(value / 359.0f, hsb[1], hsb[2]);
            } else if (obj == this.sField) {
                this.updateHSB(hsb[0], value / 100.0f, hsb[2]);
            } else if (obj == this.bField) {
                this.updateHSB(hsb[0], hsb[1], value / 100.0f);
            } else if (obj == this.rField) {
                hsb = Color.RGBtoHSB((int)value, color.getGreen(), color.getBlue(), hsb);
                this.updateHSB(hsb[0], hsb[1], hsb[2]);
            } else if (obj == this.gField) {
                hsb = Color.RGBtoHSB(color.getRed(), (int)value, color.getBlue(), hsb);
                this.updateHSB(hsb[0], hsb[1], hsb[2]);
            } else if (obj == this.blField) {
                hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), (int)value, hsb);
                this.updateHSB(hsb[0], hsb[1], hsb[2]);
            } else if (obj == this.hexField) {
                int rgb = (int)value;
                hsb = Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsb);
                this.updateHSB(hsb[0], hsb[1], hsb[2]);
            }
            textField.getFocusCycleRootAncestor().requestFocus();
        }
    }

    private void setMode(int mode) {
        if (this.currentMode == mode) {
            return;
        }
        this.isAdjusting = true;
        this.currentMode = mode;
        float[] hsb = this.getHSBColorFromModel();
        Color color = this.getColorFromModel();
        switch (this.currentMode) {
            case 0: {
                this.slider.setInverted(true);
                this.slider.setMaximum(359);
                this.palette.setValues(0, hsb[0], 1.0f, 1.0f);
                this.sliderPalette.setValues(3, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.slider.setInverted(false);
                this.slider.setMaximum(100);
                this.palette.setValues(1, hsb[0], hsb[1], 1.0f);
                this.sliderPalette.setValues(4, hsb[0], 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.slider.setInverted(false);
                this.slider.setMaximum(100);
                this.palette.setValues(2, hsb[0], 1.0f, hsb[2]);
                this.sliderPalette.setValues(5, hsb[0], 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.slider.setInverted(false);
                this.slider.setMaximum(255);
                this.palette.setValues(6, color.getRed(), color.getGreen(), color.getBlue());
                this.sliderPalette.setValues(9, color.getRed(), 0.0f, 0.0f);
                break;
            }
            case 4: {
                this.slider.setInverted(false);
                this.slider.setMaximum(255);
                this.palette.setValues(7, color.getRed(), color.getGreen(), color.getBlue());
                this.sliderPalette.setValues(10, 0.0f, color.getGreen(), 0.0f);
                break;
            }
            case 5: {
                this.slider.setInverted(false);
                this.slider.setMaximum(255);
                this.palette.setValues(8, color.getRed(), color.getGreen(), color.getBlue());
                this.sliderPalette.setValues(11, 0.0f, 0.0f, color.getBlue());
            }
        }
        this.isAdjusting = false;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.updateChooser();
    }

    protected JPanel buildSliderPalettePanel() {
        this.slider = new JSlider(1, 0, 359, 0);
        this.slider.setInverted(true);
        this.slider.setPaintTrack(false);
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width, 215));
        this.slider.addChangeListener(this);
        this.slider.putClientProperty("Slider.paintThumbArrowShape", Boolean.TRUE);
        this.paletteLabel = this.createPaletteLabel();
        this.addPaletteListeners();
        this.sliderPaletteLabel = new JLabel();
        this.addSliderPaletteListeners();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(this.paletteLabel);
        panel.add(Box.createRigidArea(new Dimension(UIUtil.DLU * 7, 0)));
        panel.add(this.slider);
        panel.add(this.sliderPaletteLabel);
        panel.add(Box.createHorizontalGlue());
        this.initializePalettesIfNecessary();
        return panel;
    }

    private void initializePalettesIfNecessary() {
        if (this.palette != null) {
            return;
        }
        float[] hsb = this.getHSBColorFromModel();
        Color color = this.getColorFromModel();
        switch (this.currentMode) {
            case 0: {
                this.palette = new CustomImage(0, 200, 200, hsb[0], 1.0f, 1.0f);
                this.sliderPalette = new CustomImage(3, 16, 200, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.palette = new CustomImage(1, 200, 200, 1.0f, hsb[1], 1.0f);
                this.sliderPalette = new CustomImage(4, 16, 200, 1.0f, 0.0f, 1.0f);
                break;
            }
            case 2: {
                this.palette = new CustomImage(2, 200, 200, 1.0f, 1.0f, hsb[2]);
                this.sliderPalette = new CustomImage(5, 16, 200, 1.0f, 1.0f, 0.0f);
                break;
            }
            case 3: {
                this.palette = new CustomImage(6, 200, 200, color.getRed(), color.getGreen(), color.getBlue());
                this.sliderPalette = new CustomImage(9, 16, 200, color.getRed(), 0.0f, 0.0f);
                break;
            }
            case 4: {
                this.palette = new CustomImage(7, 200, 200, color.getRed(), color.getGreen(), color.getBlue());
                this.sliderPalette = new CustomImage(10, 16, 200, 0.0f, color.getGreen(), 0.0f);
                break;
            }
            case 5: {
                this.palette = new CustomImage(8, 200, 200, color.getRed(), color.getGreen(), color.getBlue());
                this.sliderPalette = new CustomImage(11, 16, 200, 0.0f, 0.0f, color.getBlue());
            }
        }
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderPaletteImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderPaletteImage));
    }

    private void cleanupPalettesIfNecessary() {
        if (this.palette == null) {
            return;
        }
        this.palette.aborted = true;
        this.sliderPalette.aborted = true;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.palette = null;
        this.sliderPalette = null;
        this.paletteImage = null;
        this.sliderPaletteImage = null;
        this.paletteLabel.setIcon(null);
        this.sliderPaletteLabel.setIcon(null);
    }

    protected JLabel createPaletteLabel() {
        return new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.white);
                g.drawOval(((CustomColorChooserPanel)CustomColorChooserPanel.this).paletteSelection.x - 4, ((CustomColorChooserPanel)CustomColorChooserPanel.this).paletteSelection.y - 4, 8, 8);
            }
        };
    }

    @Override
    public String getDisplayName() {
        return RB.getStringResource(RB_KEY, "custom.txt");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.slider) {
            boolean modelIsAdjusting = this.slider.getModel().getValueIsAdjusting();
            if (!modelIsAdjusting && !this.isAdjusting) {
                int sliderValue = this.slider.getValue();
                int sliderRange = this.slider.getMaximum();
                float value = (float)sliderValue / (float)sliderRange;
                Color color = this.getColorFromModel();
                float[] hsb = this.getHSBColorFromModel();
                switch (this.currentMode) {
                    case 0: {
                        this.updateHSB(value, hsb[1], hsb[2]);
                        break;
                    }
                    case 1: {
                        this.updateHSB(hsb[0], value, hsb[2]);
                        break;
                    }
                    case 2: {
                        this.updateHSB(hsb[0], hsb[1], value);
                        break;
                    }
                    case 3: {
                        hsb = Color.RGBtoHSB((int)(value * 255.0f), color.getGreen(), color.getBlue(), hsb);
                        this.updateHSB(hsb[0], hsb[1], hsb[2]);
                        break;
                    }
                    case 4: {
                        hsb = Color.RGBtoHSB(color.getRed(), (int)(value * 255.0f), color.getBlue(), hsb);
                        this.updateHSB(hsb[0], hsb[1], hsb[2]);
                        break;
                    }
                    case 5: {
                        hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), (int)(value * 255.0f), hsb);
                        this.updateHSB(hsb[0], hsb[1], hsb[2]);
                    }
                }
            }
        } else if (src instanceof JSpinner) {
            float[] hsb = new float[3];
            if (src == this.hexField) {
                int rgb = ((Number)this.hexField.getValue()).intValue();
                hsb = Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsb);
            } else if (src == this.hField || src == this.sField || src == this.bField) {
                hsb[0] = ((Integer)this.hField.getValue()).floatValue() / 359.0f;
                hsb[1] = ((Integer)this.sField.getValue()).floatValue() / 100.0f;
                hsb[2] = ((Integer)this.bField.getValue()).floatValue() / 100.0f;
            } else {
                int red = (Integer)this.rField.getValue();
                int green = (Integer)this.gField.getValue();
                int blue = (Integer)this.blField.getValue();
                hsb = Color.RGBtoHSB(red, green, blue, hsb);
            }
            this.updateHSB(hsb[0], hsb[1], hsb[2]);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent he) {
        if ((he.getChangeFlags() & 2L) != 0L) {
            if (this.isDisplayable()) {
                this.initializePalettesIfNecessary();
            } else {
                this.cleanupPalettesIfNecessary();
            }
        }
    }

    private static final void doPrivileged(final Runnable doRun) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                doRun.run();
                return null;
            }
        });
    }

    static {
        cm = ColorModel.getRGBdefault();
    }

    class CustomImage
    implements ImageProducer {
        private SyntheticImageGenerator root;
        protected int width = 10;
        protected int height = 100;
        public static final int pixMask = 255;
        protected float h = 0.0f;
        protected float s = 0.0f;
        protected float b = 0.0f;
        protected int red = -1;
        protected int blue = -1;
        protected int green = -1;
        protected float[] hsb = new float[3];
        protected boolean isDirty = true;
        protected int cachedY;
        protected int cachedColor;
        protected int type;
        private static final int HSQUARE = 0;
        private static final int SSQUARE = 1;
        private static final int BSQUARE = 2;
        private static final int HSLIDER = 3;
        private static final int SSLIDER = 4;
        private static final int BSLIDER = 5;
        private static final int RSQUARE = 6;
        private static final int GSQUARE = 7;
        private static final int BLSQUARE = 8;
        private static final int RSLIDER = 9;
        private static final int GSLIDER = 10;
        private static final int BLSLIDER = 11;
        protected volatile boolean aborted = false;

        protected CustomImage(int type, int width, int height, float c1, float c2, float c3) {
            this.width = width;
            this.height = height;
            this.setValues(type, c1, c2, c3);
        }

        public void setValues(int type, float c1, float c2, float c3) {
            this.type = type;
            this.cachedY = -1;
            this.cachedColor = 0;
            if (type >= 6) {
                this.red = (int)c1;
                this.green = (int)c2;
                this.blue = (int)c3;
                this.hsb = Color.RGBtoHSB(this.red, this.green, this.blue, this.hsb);
                this.h = this.hsb[0];
                this.s = this.hsb[1];
                this.b = this.hsb[2];
            } else {
                this.h = c1;
                this.s = c2;
                this.b = c3;
            }
        }

        public final void setHue(float hue) {
            this.h = hue;
        }

        public final void setSaturation(float saturation) {
            this.s = saturation;
        }

        public final void setBrightness(float brightness) {
            this.b = brightness;
        }

        public final void setBlue(int blue) {
            this.blue = blue;
            Color color = CustomColorChooserPanel.this.getColorFromModel();
            if (color.getBlue() != blue) {
                this.hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), blue, this.hsb);
                this.h = this.hsb[0];
                this.s = this.hsb[1];
                this.b = this.hsb[2];
            }
        }

        public final void setGreen(int green) {
            this.green = green;
            Color color = CustomColorChooserPanel.this.getColorFromModel();
            if (color.getGreen() != green) {
                this.hsb = Color.RGBtoHSB(color.getRed(), green, color.getBlue(), this.hsb);
                this.h = this.hsb[0];
                this.s = this.hsb[1];
                this.b = this.hsb[2];
            }
        }

        public final void setRed(int red) {
            this.red = red;
            Color color = CustomColorChooserPanel.this.getColorFromModel();
            if (color.getRed() != red) {
                this.hsb = Color.RGBtoHSB(red, color.getGreen(), color.getBlue(), this.hsb);
                this.h = this.hsb[0];
                this.s = this.hsb[1];
                this.b = this.hsb[2];
            }
        }

        public final float getHue() {
            return this.h;
        }

        public final float getSaturation() {
            return this.s;
        }

        public final float getBrightness() {
            return this.b;
        }

        public final int getRed() {
            return this.red;
        }

        public final int getGreen() {
            return this.green;
        }

        public final int getBlue() {
            return this.blue;
        }

        protected boolean isStatic() {
            return false;
        }

        public synchronized void nextFrame() {
            this.isDirty = true;
            this.notifyAll();
        }

        private int getRGBForLocation(int x, int y) {
            if ((this.type >= 3 && this.type < 6 || this.type >= 9) && y == this.cachedY) {
                return this.cachedColor;
            }
            this.getHSBForLocation(x, y, this.hsb);
            this.cachedColor = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
            this.cachedY = y;
            return this.cachedColor;
        }

        public void getHSBForLocation(int x, int y, float[] hsbArray) {
            Color c = CustomColorChooserPanel.this.getColorFromModel();
            switch (this.type) {
                case 0: {
                    float saturationStep = (float)x / (float)this.width;
                    float brightnessStep = (float)y / (float)this.height;
                    hsbArray[0] = this.h;
                    hsbArray[1] = this.s - saturationStep;
                    hsbArray[2] = this.b - brightnessStep;
                    break;
                }
                case 1: {
                    float brightnessStep = (float)y / (float)this.height;
                    float step = 1.0f / (float)this.width;
                    hsbArray[0] = (float)x * step;
                    hsbArray[1] = this.s;
                    hsbArray[2] = 1.0f - brightnessStep;
                    break;
                }
                case 2: {
                    float saturationStep = (float)y / (float)this.height;
                    float step = 1.0f / (float)this.width;
                    hsbArray[0] = (float)x * step;
                    hsbArray[1] = 1.0f - saturationStep;
                    hsbArray[2] = this.b;
                    break;
                }
                case 3: {
                    float step = 1.0f / (float)this.height;
                    hsbArray[0] = (float)y * step;
                    hsbArray[1] = this.s;
                    hsbArray[2] = this.b;
                    break;
                }
                case 4: {
                    float saturationStep = (float)y / (float)this.height;
                    hsbArray[0] = this.h;
                    hsbArray[1] = 1.0f - saturationStep;
                    hsbArray[2] = this.b;
                    break;
                }
                case 5: {
                    float brightnessStep = (float)y / (float)this.height;
                    hsbArray[0] = this.h;
                    hsbArray[1] = this.s;
                    hsbArray[2] = 1.0f - brightnessStep;
                    break;
                }
                case 6: {
                    int green = (int)((1.0f - (float)x / (float)this.width) * 255.0f);
                    int blue = (int)((1.0f - (float)y / (float)this.height) * 255.0f);
                    hsbArray = Color.RGBtoHSB(c.getRed(), green, blue, hsbArray);
                    break;
                }
                case 7: {
                    int blue = (int)((1.0f - (float)x / (float)this.width) * 255.0f);
                    int red = (int)((1.0f - (float)y / (float)this.height) * 255.0f);
                    hsbArray = Color.RGBtoHSB(red, c.getGreen(), blue, hsbArray);
                    break;
                }
                case 8: {
                    int red = (int)((1.0f - (float)x / (float)this.width) * 255.0f);
                    int green = (int)((1.0f - (float)y / (float)this.height) * 255.0f);
                    hsbArray = Color.RGBtoHSB(red, green, c.getBlue(), hsbArray);
                    break;
                }
                case 9: {
                    int red = (int)(255.0f * (1.0f - (float)y / (float)this.height));
                    hsbArray = Color.RGBtoHSB(red, 0, 0, hsbArray);
                    break;
                }
                case 10: {
                    int green = (int)(255.0f * (1.0f - (float)y / (float)this.height));
                    hsbArray = Color.RGBtoHSB(0, green, 0, hsbArray);
                    break;
                }
                case 11: {
                    int blue = (int)(255.0f * (1.0f - (float)y / (float)this.height));
                    hsbArray = Color.RGBtoHSB(0, 0, blue, hsbArray);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeRow(int y, int[] row) {
            if (y == 0) {
                CustomImage customImage = this;
                synchronized (customImage) {
                    try {
                        while (!this.isDirty) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.isDirty = false;
                }
            }
            if (this.aborted) {
                return;
            }
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.getRGBForLocation(i, y);
            }
        }

        @Override
        public synchronized void addConsumer(ImageConsumer ic) {
            this.isDirty = true;
            SyntheticImageGenerator ics = this.root;
            while (ics != null) {
                if (ics.ic == ic) {
                    return;
                }
                ics = ics.next;
            }
            this.root = new SyntheticImageGenerator(ic, this.root, this);
        }

        @Override
        public synchronized boolean isConsumer(ImageConsumer ic) {
            SyntheticImageGenerator ics = this.root;
            while (ics != null) {
                if (ics.ic == ic) {
                    return true;
                }
                ics = ics.next;
            }
            return false;
        }

        @Override
        public synchronized void removeConsumer(ImageConsumer ic) {
            SyntheticImageGenerator prev = null;
            SyntheticImageGenerator ics = this.root;
            while (ics != null) {
                if (ics.ic == ic) {
                    ics.useful = false;
                    if (prev != null) {
                        prev.next = ics.next;
                    } else {
                        this.root = ics.next;
                    }
                    return;
                }
                prev = ics;
                ics = ics.next;
            }
        }

        @Override
        public synchronized void startProduction(ImageConsumer ic) {
            this.addConsumer(ic);
            SyntheticImageGenerator ics = this.root;
            while (ics != null) {
                if (ics.useful && !ics.isAlive()) {
                    ics.start();
                }
                ics = ics.next;
            }
        }

        public void nextFrame(int param) {
        }

        @Override
        public void requestTopDownLeftRightResend(ImageConsumer ic) {
        }
    }

    class HexFormat
    extends NumberFormat {
        HexFormat() {
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(Integer.toHexString((int)number).toUpperCase());
            return toAppendTo;
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(Integer.toHexString((int)number).toUpperCase());
            return toAppendTo;
        }

        @Override
        public Number parse(String text, ParsePosition pos) {
            int value;
            if (text == null) {
                return null;
            }
            try {
                value = Integer.parseInt(text, 16);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            pos.setIndex(text.length());
            return new Integer(value);
        }
    }

    class SyntheticImageGenerator
    extends Thread {
        ImageConsumer ic;
        boolean useful;
        SyntheticImageGenerator next;
        CustomImage parent;

        SyntheticImageGenerator(ImageConsumer ic, SyntheticImageGenerator next, CustomImage parent) {
            super("SyntheticImageGenerator");
            this.ic = ic;
            this.next = next;
            this.parent = parent;
            this.useful = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ImageConsumer ic = this.ic;
            int w = this.parent.width;
            int h = this.parent.height;
            int hints = 14;
            if (this.parent.isStatic()) {
                hints |= 0x10;
            }
            ic.setHints(hints);
            ic.setDimensions(w, h);
            ic.setProperties(null);
            ic.setColorModel(cm);
            if (this.useful) {
                int[] row = new int[w];
                CustomColorChooserPanel.doPrivileged(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(1);
                    }
                });
                do {
                    for (int y = 0; y < h && this.useful; ++y) {
                        this.parent.computeRow(y, row);
                        if (this.parent.aborted) {
                            ic.imageComplete(4);
                            return;
                        }
                        ic.setPixels(0, y, w, 1, cm, row, 0, w);
                    }
                    ic.imageComplete(this.parent.isStatic() ? 3 : 2);
                } while (!this.parent.isStatic() && this.useful);
            }
        }
    }
}

