/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.AdvancedAxisInterface;
import com.sas.graphics.sg.interfaces.AxisInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.LabelCellRenderer;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SimpleTextCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AxisCustomizerPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String RB_KEY = "AxisCustomizerPanel.";
    private JComboBox axisId;
    private JComboBox dataRange;
    private AxisInterface[] axes;
    private AxisInterface curaxis;
    private int curIndex = 0;
    private CompTitledBorder lineBorder;
    private JPanel titlePanel;
    private SimpleTextCustomizerPanel labelTextPanel;
    private SimpleTextCustomizerPanel valueTextPanel;
    private LineCustomizerPanel gridPanel;
    private JTextField labelField;
    private JPanel axisPanel;
    JCheckBox grid;
    JCheckBox value;
    JCheckBox label;
    JTabbedPane tabbedPane;

    public AxisCustomizerPanel(AxisInterface axis) {
        this.axes = null;
        this.curIndex = -1;
        this.curaxis = axis;
        this.setLayout(new BoxLayout(this, 1));
        this.axisPanel = this.createAxisPanel();
        this.axisPanel.setBorder(UIUtil.emptyBorder);
        this.add(this.axisPanel);
        this.add(Box.createVerticalGlue());
    }

    public AxisCustomizerPanel(AxisInterface[] axes, int curIndex) {
        this.axes = axes;
        this.curIndex = curIndex;
        this.curaxis = axes[curIndex];
        if (axes != null && axes.length > 0) {
            this.init();
        }
    }

    private void init() {
        this.titlePanel = new JPanel();
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(4 * UIUtil.DLU, 3 * UIUtil.DLU, 4 * UIUtil.DLU, 2 * UIUtil.DLU));
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        JLabel title = new JLabel(RB.getStringResource(RB_KEY, "axis.txt"));
        this.titlePanel.add(title);
        this.titlePanel.add(Box.createRigidArea(new Dimension(3, 0)));
        JLabel[] list = new JLabel[this.axes.length];
        ImageIcon[] icons = new ImageIcon[7];
        for (int i = 0; i < this.axes.length; ++i) {
            list[i] = new JLabel((String)this.axes[i].getElementID());
            int type = this.axes[i].getAxisType();
            if (icons[type] == null) {
                switch (type) {
                    default: {
                        icons[type] = new ImageIcon(Util.getImage(null, "xaxis.gif"));
                        break;
                    }
                    case 1: {
                        icons[type] = new ImageIcon(Util.getImage(null, "x2axis.gif"));
                        break;
                    }
                    case 2: {
                        icons[type] = new ImageIcon(Util.getImage(null, "yaxis.gif"));
                        break;
                    }
                    case 3: {
                        icons[type] = new ImageIcon(Util.getImage(null, "y2axis.gif"));
                        break;
                    }
                    case 4: {
                        icons[type] = new ImageIcon(Util.getImage(null, "xaxis_3d.gif"));
                        break;
                    }
                    case 5: {
                        icons[type] = new ImageIcon(Util.getImage(null, "yaxis_3d.gif"));
                        break;
                    }
                    case 6: {
                        icons[type] = new ImageIcon(Util.getImage(null, "zaxis_3d.gif"));
                    }
                }
            }
            list[i].setIcon(icons[type]);
        }
        this.axisId = new JComboBox<JLabel>(list);
        this.axisId.setSelectedIndex(this.curIndex);
        this.axisId.setRenderer(new LabelCellRenderer());
        this.axisId.addActionListener(this);
        this.axisId.setActionCommand("axisid");
        Dimension pref = this.axisId.getPreferredSize();
        this.axisId.setPreferredSize(new Dimension(pref.width + 15, 6 + pref.height));
        this.titlePanel.add(this.axisId);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(11 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU), new LineBorder(Color.GRAY));
        this.lineBorder = new CompTitledBorder((Border)border, this.titlePanel);
        this.setBorder(this.lineBorder);
        this.setLayout(null);
        this.add(this.titlePanel);
        this.axisPanel = this.createAxisPanel();
        this.axisPanel.setBorder(UIUtil.emptyBorder);
        this.add(this.axisPanel);
        this.add(Box.createVerticalGlue());
    }

    private JPanel createAxisPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.tabbedPane = new JTabbedPane(1, 0);
        JPanel generalPanel = this.createGeneralPanel();
        generalPanel.setBorder(UIUtil.emptyBorder);
        JPanel labelPanel = this.createLabelPanel();
        labelPanel.setBorder(UIUtil.emptyBorder);
        if (this.curaxis.getValueTextStyle() != null) {
            this.valueTextPanel = new SimpleTextCustomizerPanel(this.curaxis.getValueTextStyle());
            this.valueTextPanel.setBorder(UIUtil.emptyBorder);
        }
        this.gridPanel = new LineCustomizerPanel(this.curaxis.getGridStyle());
        this.gridPanel.setBorder(UIUtil.emptyBorder);
        this.tabbedPane.addTab(RB.getStringResource("sdisplay.txt"), generalPanel);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "label.txt"), labelPanel);
        if (this.valueTextPanel != null) {
            this.tabbedPane.setMnemonicAt(1, 50);
            this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "value.txt"), this.valueTextPanel);
            this.tabbedPane.setMnemonicAt(2, 51);
            this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "grid.txt"), this.gridPanel);
        } else {
            this.tabbedPane.setMnemonicAt(1, 50);
            this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "grid.txt"), this.gridPanel);
        }
        this.tabbedPane.setEnabledAt(1, this.curaxis.isLabelOn());
        if (this.valueTextPanel != null) {
            this.tabbedPane.setEnabledAt(2, this.curaxis.isTickValuesOn());
            this.tabbedPane.setEnabledAt(3, this.curaxis.isGridOn());
        } else {
            this.tabbedPane.setEnabledAt(2, this.curaxis.isGridOn());
        }
        panel.add(this.tabbedPane);
        if (this.curaxis instanceof AdvancedAxisInterface) {
            panel.add(Box.createRigidArea(new Dimension(0, 8 * UIUtil.DLU)));
            JPanel rangePanel = new JPanel();
            rangePanel.setLayout(new BoxLayout(rangePanel, 0));
            JLabel rangeLabel = new JLabel(RB.getStringResource(RB_KEY, "range.txt"));
            rangePanel.add(rangeLabel);
            this.dataRange = new JComboBox<String>(new String[]{RB.getStringResource(RB_KEY, "data.txt"), RB.getStringResource(RB_KEY, "union.txt"), RB.getStringResource(RB_KEY, "unionall.txt")});
            switch (((AdvancedAxisInterface)this.curaxis).getDataRange()) {
                case 0: {
                    this.dataRange.setSelectedIndex(0);
                    break;
                }
                default: {
                    this.dataRange.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.dataRange.setSelectedIndex(2);
                }
            }
            this.dataRange.setActionCommand("range");
            this.dataRange.addActionListener(this);
            rangePanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
            rangePanel.add(this.dataRange);
            panel.add(rangePanel);
        }
        panel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        return panel;
    }

    private JPanel createGeneralPanel() {
        int i;
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        ArrayList<JCheckBox> labels = new ArrayList<JCheckBox>();
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 0));
        displayPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.grid = new JCheckBox(RB.getStringResource(RB_KEY, "grid.txt"));
        this.grid.setActionCommand("dgrid");
        this.grid.setSelected(this.curaxis.isGridOn());
        this.grid.addActionListener(this);
        labels.add(this.grid);
        displayPanel.add(this.grid);
        displayPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        this.label = new JCheckBox(RB.getStringResource(RB_KEY, "label.txt"));
        this.label.setActionCommand("dlabel");
        boolean labelOn = this.curaxis.isLabelOn();
        this.label.setSelected(labelOn);
        this.label.addActionListener(this);
        labels.add(this.label);
        displayPanel.add(this.label);
        displayPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        this.value = new JCheckBox(RB.getStringResource(RB_KEY, "value.txt"));
        this.value.setActionCommand("dvalue");
        this.value.setSelected(this.curaxis.isTickValuesOn());
        this.value.addActionListener(this);
        labels.add(this.value);
        displayPanel.add(this.value);
        displayPanel.add(Box.createHorizontalGlue());
        generalPanel.add(displayPanel);
        generalPanel.add(Box.createRigidArea(new Dimension(0, 14 * UIUtil.DLU)));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        JLabel titleLabel = new JLabel(RB.getStringResource(RB_KEY, "labelc.txt"));
        labels.add(this.label);
        this.labelField = new JTextField(20);
        this.labelField.setText(this.curaxis.getLabel());
        this.labelField.addActionListener(this);
        this.labelField.setEnabled(labelOn);
        this.labelField.getDocument().addDocumentListener(this);
        this.labelField.setActionCommand("label");
        this.labelField.setMaximumSize(this.labelField.getPreferredSize());
        labelPanel.add(titleLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        labelPanel.add(this.labelField);
        labelPanel.add(Box.createHorizontalGlue());
        generalPanel.add(labelPanel);
        generalPanel.add(Box.createVerticalGlue());
        Dimension ps = new Dimension(0, 0);
        int len = labels.size();
        for (i = 0; i < len; ++i) {
            Dimension ps2 = ((JCheckBox)labels.get(i)).getPreferredSize();
            ps.setSize(Math.max(ps.width, ps2.width), Math.max(ps.height, ps2.height));
        }
        for (i = 0; i < len; ++i) {
            JCheckBox cb = (JCheckBox)labels.get(i);
            cb.setPreferredSize(ps);
            cb.setMaximumSize(ps);
        }
        return generalPanel;
    }

    private JPanel createLabelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        TextInterface style = this.curaxis.getLabelTextStyle();
        this.labelTextPanel = new SimpleTextCustomizerPanel(style);
        this.labelTextPanel.setBorder(null);
        panel.add(this.labelTextPanel);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private void setValues() {
        boolean gridOn = this.curaxis.isGridOn();
        if (this.grid != null) {
            this.grid.removeActionListener(this);
            this.grid.setSelected(gridOn);
            this.grid.addActionListener(this);
        }
        boolean labelOn = this.curaxis.isLabelOn();
        this.label.removeActionListener(this);
        this.label.setSelected(labelOn);
        this.label.addActionListener(this);
        this.value.removeActionListener(this);
        boolean valueOn = this.curaxis.isTickValuesOn();
        this.value.setSelected(valueOn);
        this.value.addActionListener(this);
        this.tabbedPane.setEnabledAt(1, labelOn);
        if (this.valueTextPanel != null) {
            this.tabbedPane.setEnabledAt(2, valueOn);
            this.tabbedPane.setEnabledAt(3, gridOn);
            this.valueTextPanel.setValue(this.curaxis.getValueTextStyle());
            if (!gridOn && this.tabbedPane.getSelectedIndex() == 3) {
                this.tabbedPane.setSelectedIndex(0);
            }
        } else {
            this.tabbedPane.setEnabledAt(2, gridOn);
            if (!gridOn && this.tabbedPane.getSelectedIndex() == 2) {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
        this.gridPanel.setValue(this.curaxis.getGridStyle());
        TextInterface ti = this.curaxis.getLabelTextStyle();
        this.labelTextPanel.setValue(ti);
        this.labelField.removeActionListener(this);
        this.labelField.getDocument().removeDocumentListener(this);
        this.labelField.setText(this.curaxis.getLabel());
        this.labelField.setEnabled(labelOn);
        this.labelField.addActionListener(this);
        this.labelField.getDocument().addDocumentListener(this);
        if (this.curaxis instanceof AdvancedAxisInterface) {
            switch (((AdvancedAxisInterface)this.curaxis).getDataRange()) {
                case 0: {
                    this.dataRange.setSelectedIndex(0);
                    break;
                }
                default: {
                    this.dataRange.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.dataRange.setSelectedIndex(2);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Object src = e.getSource();
        if (cmd.startsWith("axisid")) {
            int oldIndex = this.curIndex;
            this.curIndex = ((JComboBox)src).getSelectedIndex();
            if (this.curIndex != oldIndex) {
                this.curaxis = this.axes[this.curIndex];
                this.setValues();
            }
        } else if (cmd.equals("dgrid")) {
            boolean gridOn = this.grid.isSelected();
            this.curaxis.setGridOn(gridOn);
            if (this.valueTextPanel != null) {
                this.tabbedPane.setEnabledAt(3, gridOn);
            } else {
                this.tabbedPane.setEnabledAt(2, gridOn);
            }
        } else if (cmd.equals("dlabel")) {
            boolean labelOn = this.label.isSelected();
            this.tabbedPane.setEnabledAt(1, labelOn);
            this.labelField.setEnabled(labelOn);
            this.curaxis.setLabelOn(labelOn);
        } else if (cmd.equals("dvalue")) {
            boolean valueOn = this.value.isSelected();
            this.curaxis.setTickValuesOn(valueOn);
            if (this.valueTextPanel != null) {
                this.tabbedPane.setEnabledAt(2, valueOn);
            }
        } else if (cmd.equals("range")) {
            AdvancedAxisInterface aaxis = (AdvancedAxisInterface)this.curaxis;
            switch (this.dataRange.getSelectedIndex()) {
                case 0: {
                    aaxis.setDataRange(0);
                    break;
                }
                default: {
                    aaxis.setDataRange(1);
                    break;
                }
                case 2: {
                    aaxis.setDataRange(2);
                }
            }
        }
    }

    public String getLabelText() {
        return this.labelField.getText();
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        if (this.lineBorder == null) {
            super.doLayout();
            return;
        }
        Rectangle compR = this.lineBorder.getComponentRect(rect, insets);
        this.titlePanel.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this.axisPanel.setBounds(rect);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.curaxis.setLabel(this.labelField.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.curaxis.setLabel(this.labelField.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.curaxis.setLabel(this.labelField.getText());
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.titlePanel != null && this.axisPanel != null) {
            Dimension ps1 = this.titlePanel.getPreferredSize();
            Dimension ps2 = this.axisPanel.getPreferredSize();
            return new Dimension(ps1.width + 16 * UIUtil.DLU, ps1.height + ps2.height);
        }
        return super.getPreferredSize();
    }
}

