/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.VectorInterface;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ArrowCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    public static final String RB_KEY = "ArrowCustomizerPanel.";
    private static String[] dir_lvalues = new String[]{RB.getStringResource("ArrowCustomizerPanel.", "in.txt"), RB.getStringResource("ArrowCustomizerPanel.", "out.txt"), RB.getStringResource("ArrowCustomizerPanel.", "both.txt")};
    private static String[] dir_values = new String[]{"In", "Out", "Both"};
    private static String[] shape_lvalues = new String[]{RB.getStringResource("ArrowCustomizerPanel.", "open.txt"), RB.getStringResource("ArrowCustomizerPanel.", "closed.txt"), RB.getStringResource("ArrowCustomizerPanel.", "fill.txt"), RB.getStringResource("ArrowCustomizerPanel.", "barbed.txt")};
    private static String[] shape_values = new String[]{"Open", "Closed", "Filled", "Barbed"};
    JCheckBox arrow;
    JComboBox dir;
    JComboBox shape;
    VectorInterface vector;

    public ArrowCustomizerPanel(VectorInterface vector) {
        this.vector = vector;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    protected void init() {
        JPanel arrowpanel = new JPanel();
        arrowpanel.setLayout(new BoxLayout(arrowpanel, 0));
        this.arrow = new JCheckBox(RB.getStringResource("sarrow.txt"));
        this.arrow.setSelected(this.vector.isArrowOn());
        this.arrow.addActionListener(this);
        this.arrow.setActionCommand("arrow");
        this.arrow.setMaximumSize(this.arrow.getPreferredSize());
        arrowpanel.add(this.arrow);
        arrowpanel.add(Box.createHorizontalGlue());
        this.add(arrowpanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        JPanel typepanel = new JPanel();
        typepanel.setLayout(new BoxLayout(typepanel, 0));
        JLabel tlabel = new JLabel(RB.getStringResource(RB_KEY, "direction.txt"));
        typepanel.add(tlabel);
        Dimension ps = tlabel.getPreferredSize();
        this.labelSize = new Dimension(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(tlabel);
        this.dir = new JComboBox<String>(dir_lvalues);
        String value = this.vector.getArrowDirection();
        for (int i = 0; i < dir_values.length; ++i) {
            if (!value.equalsIgnoreCase(dir_values[i])) continue;
            this.dir.setSelectedIndex(i);
            break;
        }
        this.dir.setActionCommand("direction");
        this.dir.addActionListener(this);
        typepanel.add(this.dir);
        typepanel.add(Box.createHorizontalGlue());
        this.add(typepanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        ps = this.dir.getPreferredSize();
        this.widgetSize = new Dimension(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.dir);
        JPanel shapepanel = new JPanel();
        shapepanel.setLayout(new BoxLayout(shapepanel, 0));
        JLabel slabel = new JLabel(RB.getStringResource(RB_KEY, "shape.txt"));
        shapepanel.add(slabel);
        ps = slabel.getPreferredSize();
        this.labelSize = new Dimension(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(slabel);
        this.shape = new JComboBox<String>(shape_lvalues);
        value = this.vector.getArrowShape();
        for (int i = 0; i < shape_values.length; ++i) {
            if (!value.equalsIgnoreCase(shape_values[i])) continue;
            this.shape.setSelectedIndex(i);
            break;
        }
        this.shape.setActionCommand("shape");
        this.shape.addActionListener(this);
        shapepanel.add(this.shape);
        shapepanel.add(Box.createHorizontalGlue());
        this.add(shapepanel);
        ps = this.dir.getPreferredSize();
        this.widgetSize = new Dimension(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.shape);
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void setValue(Object newValue) {
        int i;
        if (!(newValue instanceof VectorInterface)) {
            return;
        }
        this.vector = (VectorInterface)newValue;
        this.arrow.removeActionListener(this);
        this.arrow.setSelected(this.vector.isArrowOn());
        this.arrow.addActionListener(this);
        this.dir.removeActionListener(this);
        String value = this.vector.getArrowDirection();
        for (i = 0; i < dir_values.length; ++i) {
            if (!value.equalsIgnoreCase(dir_values[i])) continue;
            this.dir.setSelectedIndex(i);
            break;
        }
        this.dir.addActionListener(this);
        this.shape.removeActionListener(this);
        value = this.vector.getArrowShape();
        for (i = 0; i < shape_values.length; ++i) {
            if (!value.equalsIgnoreCase(shape_values[i])) continue;
            this.shape.setSelectedIndex(i);
            break;
        }
        this.shape.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("arrow")) {
            boolean on = this.arrow.isSelected();
            this.vector.setArrowOn(on);
            this.dir.setEnabled(on);
            this.shape.setEnabled(on);
        } else if (cmd.equals("direction")) {
            this.vector.setArrowDirection(dir_values[this.dir.getSelectedIndex()]);
        } else if (cmd.equals("shape")) {
            this.vector.setArrowShape(shape_values[this.shape.getSelectedIndex()]);
        }
    }
}

