/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.AreaInterface;
import com.sas.graphics.sg.interfaces.ColorEditableInterface;
import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.interfaces.DefaultLineInterface;
import com.sas.graphics.sg.interfaces.FillStyleElementInterface;
import com.sas.graphics.sg.interfaces.LineStyleElementInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AreaCustomizerPanel
extends SGCustomizerPanel
implements ActionListener,
ChangeListener {
    private static final int dlu2 = UIUtil.DLU * 2;
    private static final int dlu3 = UIUtil.DLU * 3;
    private static final int dlu4 = UIUtil.DLU * 4;
    private static final int dlu7 = UIUtil.DLU * 7;
    private static final Border left = BorderFactory.createEmptyBorder(0, dlu7, 0, dlu7);
    AreaInterface areaStyle;
    JCheckBox fill;
    JCheckBox outline;
    CompTitledBorder fillBorder;
    protected JPanel fillPanel;
    SwatchComboBox fillColor;
    SwatchComboBox outlineColor;
    JComboBox fstyle;
    JComboBox lstyle;
    String fillTitle = RB.getStringResource("fill.txt");
    String lineTitle = RB.getStringResource("outline.txt");
    String defaultFillColorSource = "";
    String defaultLineColorSource = "";
    private JSlider transparency;
    ColorGrabber colorGrabber;
    boolean validNoFillNoLine = false;
    private boolean settingFillColor = true;
    private JDialog dialog = null;

    public AreaCustomizerPanel(AreaInterface areaStyle) {
        this(areaStyle, null);
    }

    public AreaCustomizerPanel(AreaInterface areaStyle, ColorGrabber cg) {
        this.areaStyle = areaStyle;
        this.colorGrabber = cg;
        this.init();
    }

    protected void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(null);
        Color defaultFillColor = null;
        Color defaultLineColor = null;
        boolean fillOn = this.areaStyle.isFillOn();
        boolean lineOn = this.areaStyle.isLineOn();
        this.validNoFillNoLine = !fillOn && !lineOn;
        this.fillPanel = new JPanel();
        this.fillPanel.setBorder(left);
        this.fillPanel.setLayout(new BoxLayout(this.fillPanel, 1));
        if (this.areaStyle instanceof FillStyleElementInterface) {
            FillStyleElementInterface styleInterface = (FillStyleElementInterface)((Object)this.areaStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            JLabel styleLabel = new JLabel(RB.getStringResource("element.txt"));
            Dimension ps = styleLabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            this.labels.add(styleLabel);
            stylePanel.add(styleLabel);
            stylePanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
            this.fstyle = new JComboBox<String>(styleInterface.getAllFillStyleElements());
            this.fstyle.setSelectedItem(styleInterface.getFillStyleElement());
            this.fstyle.setEnabled(fillOn);
            this.fstyle.setActionCommand("fillstyle");
            this.fstyle.addActionListener(this);
            this.fstyle.setEnabled(this.fstyle.getItemCount() > 1);
            this.widgets.add(this.fstyle);
            ps = this.fstyle.getPreferredSize();
            this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
            stylePanel.add(this.fstyle);
            stylePanel.add(Box.createHorizontalGlue());
            this.fillPanel.add(stylePanel);
            this.fillPanel.add(Box.createRigidArea(new Dimension(0, dlu4)));
        }
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorlabel = new JLabel(RB.getStringResource("colorcolon.txt"));
        colorPanel.add(colorlabel);
        colorPanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
        Dimension ps = colorlabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(colorlabel);
        if (this.areaStyle instanceof DefaultAreaInterface) {
            DefaultAreaInterface das = (DefaultAreaInterface)((Object)this.areaStyle);
            this.defaultFillColorSource = das.getDefaultFillColorSource();
            defaultFillColor = das.getDefaultFillColor();
            this.defaultLineColorSource = das.getDefaultLineColorSource();
            defaultLineColor = das.getDefaultLineColor();
        }
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultFillColorSource, defaultFillColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.areaStyle.getFillColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        this.fillColor.setRenderer(new SwatchRenderer());
        if (this.areaStyle instanceof ColorEditableInterface) {
            this.fillColor.setEnabled(((ColorEditableInterface)((Object)this.areaStyle)).isFillColorEditable() && fillOn);
        } else {
            this.fillColor.setEnabled(fillOn);
        }
        this.fillColor.setActionCommand("fillcolor");
        this.fillPanel.add(this.fillColor);
        this.fillPanel.add(Box.createHorizontalGlue());
        this.fillColor.addActionListener(this);
        ps = this.fillColor.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.fillColor);
        colorPanel.add(this.fillColor);
        colorPanel.add(Box.createHorizontalGlue());
        this.fillPanel.add(colorPanel);
        this.fillPanel.add(Box.createRigidArea(new Dimension(0, dlu4)));
        JPanel transparencyPanel = new JPanel();
        transparencyPanel.setLayout(new BoxLayout(transparencyPanel, 0));
        JLabel translabel = new JLabel(RB.getStringResource("transparency.txt"));
        transparencyPanel.add(translabel);
        ps = translabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(translabel);
        this.transparency = new JSlider(0, 0, 100, this.areaStyle.getFillTrans());
        this.transparency.addChangeListener(this);
        this.transparency.setMajorTickSpacing(25);
        this.transparency.setMinorTickSpacing(5);
        this.transparency.setPaintTicks(true);
        this.transparency.setEnabled(fillOn);
        transparencyPanel.add(this.transparency);
        transparencyPanel.add(Box.createHorizontalGlue());
        this.fillPanel.add(transparencyPanel);
        this.fill = new JCheckBox(RB.getStringResource("sfill.txt"));
        this.fill.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        this.fill.setSelected(fillOn);
        this.fill.addActionListener(this);
        this.fill.setEnabled(lineOn || this.validNoFillNoLine);
        this.fill.setActionCommand("fill");
        JPanel fillGroupPanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                if (AreaCustomizerPanel.this.fillBorder == null) {
                    return;
                }
                Rectangle compR = AreaCustomizerPanel.this.fillBorder.getComponentRect(rect, insets);
                AreaCustomizerPanel.this.fill.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                AreaCustomizerPanel.this.fillPanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = super.getInsets();
                Dimension ps2 = AreaCustomizerPanel.this.fillPanel.getPreferredSize();
                return new Dimension((int)ps2.getWidth(), (int)ps2.getHeight() + insets.top + insets.bottom);
            }
        };
        fillGroupPanel.add(this.fill);
        fillGroupPanel.add(this.fillPanel);
        this.fillBorder = new CompTitledBorder((Border)new LineBorder(Color.GRAY), this.fill);
        fillGroupPanel.setBorder(this.fillBorder);
        this.add(fillGroupPanel);
        this.add(Box.createRigidArea(new Dimension(0, dlu7)));
        JPanel linePanel = new JPanel();
        linePanel.setBorder(left);
        linePanel.setLayout(new BoxLayout(linePanel, 1));
        if (this.areaStyle instanceof LineStyleElementInterface) {
            LineStyleElementInterface styleInterface = (LineStyleElementInterface)((Object)this.areaStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            JLabel styleLabel = new JLabel(RB.getStringResource("element.txt"));
            ps = styleLabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            this.labels.add(styleLabel);
            stylePanel.add(styleLabel);
            stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
            this.lstyle = new JComboBox<String>(styleInterface.getAllLineStyleElements());
            this.lstyle.setSelectedItem(styleInterface.getLineStyleElement());
            this.lstyle.setEnabled(lineOn);
            this.lstyle.setActionCommand("linestyle");
            this.lstyle.addActionListener(this);
            ps = this.lstyle.getPreferredSize();
            this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
            this.widgets.add(this.lstyle);
            stylePanel.add(this.lstyle);
            stylePanel.add(Box.createHorizontalGlue());
            linePanel.add(stylePanel);
        }
        JPanel outlinePanel = new JPanel();
        outlinePanel.setLayout(new BoxLayout(outlinePanel, 0));
        this.outline = new JCheckBox(this.lineTitle);
        outlinePanel.add(this.outline);
        this.outline.setActionCommand("outline");
        this.outline.setSelected(lineOn);
        this.outline.setEnabled(fillOn || this.validNoFillNoLine);
        this.outline.addActionListener(this);
        outlinePanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
        this.outlineColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultLineColorSource, defaultLineColor, RB.getStringResource("morecolorsdots.txt"));
        c = this.areaStyle.getLineColor();
        this.outlineColor.setEditable(true);
        editor = new ColorComboBoxEditor(this.defaultLineColorSource, defaultLineColor);
        this.outlineColor.setEditor(editor);
        editor.addMouseListener(this.outlineColor);
        if (c != null) {
            this.outlineColor.setSelectedItem(c);
        } else {
            this.outlineColor.setSelectedItem(this.defaultLineColorSource);
        }
        if (this.areaStyle instanceof ColorEditableInterface) {
            this.outlineColor.setEnabled(((ColorEditableInterface)((Object)this.areaStyle)).isLineColorEditable() && lineOn);
        } else {
            this.outlineColor.setEnabled(lineOn);
        }
        this.outlineColor.setRenderer(new SwatchRenderer());
        this.outlineColor.setActionCommand("outlinecolor");
        this.outlineColor.addActionListener(this);
        ps = this.outlineColor.getPreferredSize();
        this.widgetSize.setSize((int)Math.max((double)ps.width, this.widgetSize.getWidth()), (int)Math.max((double)ps.height, this.widgetSize.getHeight()));
        this.widgets.add(this.outlineColor);
        outlinePanel.add(this.outlineColor);
        outlinePanel.add(Box.createHorizontalGlue());
        linePanel.add(outlinePanel);
        this.add(linePanel);
        this.add(Box.createVerticalGlue());
        ps = this.transparency.getPreferredSize();
        this.transparency.setPreferredSize(new Dimension(this.widgetSize.width, ps.height));
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
    }

    @Override
    public void setValue(Object newValue) {
        if (!(newValue instanceof AreaInterface)) {
            return;
        }
        this.areaStyle = (AreaInterface)newValue;
        if (this.areaStyle instanceof DefaultAreaInterface) {
            DefaultAreaInterface das = (DefaultAreaInterface)((Object)this.areaStyle);
            this.defaultFillColorSource = das.getDefaultFillColorSource();
            Color defaultFillColor = das.getDefaultFillColor();
            this.defaultLineColorSource = das.getDefaultLineColorSource();
            Color defaultLineColor = das.getDefaultLineColor();
            if (this.fillColor != null) {
                this.fillColor.setAutomatic(this.defaultFillColorSource, defaultFillColor);
                this.fillColor.updateUI();
                this.fillColor.setEditor(new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor));
            }
            if (this.outlineColor != null) {
                this.outlineColor.setAutomatic(this.defaultLineColorSource, defaultLineColor);
                this.outlineColor.updateUI();
                this.outlineColor.setEditor(new ColorComboBoxEditor(this.defaultLineColorSource, defaultLineColor));
            }
        }
        boolean fillOn = this.areaStyle.isFillOn();
        boolean lineOn = this.areaStyle.isLineOn();
        this.validNoFillNoLine = !fillOn && !lineOn;
        this.fill.removeActionListener(this);
        fillOn = this.areaStyle.isFillOn();
        this.fill.setSelected(fillOn);
        this.fill.setEnabled(lineOn || this.validNoFillNoLine);
        this.fill.addActionListener(this);
        this.outline.removeActionListener(this);
        this.outline.setSelected(lineOn);
        this.outline.setEnabled(fillOn || this.validNoFillNoLine);
        this.outline.addActionListener(this);
        Color c = this.areaStyle.getFillColor();
        this.fillColor.removeActionListener(this);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        if (this.areaStyle instanceof ColorEditableInterface) {
            this.fillColor.setEnabled(((ColorEditableInterface)((Object)this.areaStyle)).isFillColorEditable() && fillOn);
        } else {
            this.fillColor.setEnabled(fillOn);
        }
        this.fillColor.addActionListener(this);
        this.outlineColor.removeActionListener(this);
        c = this.areaStyle.getLineColor();
        if (c != null) {
            this.outlineColor.setSelectedItem(c);
        } else {
            this.outlineColor.setSelectedItem(this.defaultLineColorSource);
        }
        if (this.areaStyle instanceof ColorEditableInterface) {
            this.outlineColor.setEnabled(((ColorEditableInterface)((Object)this.areaStyle)).isLineColorEditable() && lineOn);
        } else {
            this.outlineColor.setEnabled(lineOn);
        }
        this.outlineColor.addActionListener(this);
        if (this.fstyle != null) {
            this.fstyle.removeActionListener(this);
            this.fstyle.setModel(new DefaultComboBoxModel<String>(((FillStyleElementInterface)((Object)this.areaStyle)).getAllFillStyleElements()));
            this.fstyle.setSelectedItem(((FillStyleElementInterface)((Object)this.areaStyle)).getFillStyleElement());
            this.fstyle.setEnabled(this.fstyle.getItemCount() > 1);
            this.fstyle.addActionListener(this);
        }
        this.transparency.removeChangeListener(this);
        this.transparency.setEnabled(fillOn);
        this.transparency.setValue(this.areaStyle.getFillTrans());
        this.transparency.addChangeListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Container parent;
        JPanel panel;
        JColorChooser cc;
        Color save;
        block75: {
            String cmd;
            block74: {
                cmd = e.getActionCommand();
                if (cmd.equals("fill")) {
                    boolean fillOn = this.fill.isSelected();
                    this.areaStyle.setFillOn(fillOn);
                    if (fillOn != this.areaStyle.isFillOn()) {
                        return;
                    }
                    if (this.areaStyle instanceof ColorEditableInterface) {
                        this.fillColor.setEnabled(fillOn && ((ColorEditableInterface)((Object)this.areaStyle)).isFillColorEditable());
                    } else {
                        this.fillColor.setEnabled(fillOn);
                    }
                    this.transparency.setEnabled(fillOn);
                    if (this.fstyle != null) {
                        this.fstyle.setEnabled(fillOn);
                    }
                    if (fillOn) {
                        this.fillColor.removeActionListener(this);
                        Color c = this.areaStyle.getFillColor();
                        if (c == null) {
                            this.fillColor.setSelectedItem(this.defaultFillColorSource);
                        } else {
                            this.fillColor.setSelectedItem(c);
                        }
                        this.fillColor.addActionListener(this);
                        if (this.outline != null) {
                            this.outline.setEnabled(true);
                        }
                    } else if (this.outline != null) {
                        this.outline.setEnabled(this.validNoFillNoLine);
                    }
                    if (!(this.areaStyle instanceof DefaultLineInterface)) return;
                    DefaultLineInterface dli = (DefaultLineInterface)((Object)this.areaStyle);
                    this.defaultLineColorSource = dli.getDefaultLineColorSource();
                    Color defaultColor = dli.getDefaultLineColor();
                    this.outlineColor.removeActionListener(this);
                    this.outlineColor.setAutomatic(this.defaultLineColorSource, defaultColor);
                    if (defaultColor == null) {
                        this.outlineColor.mypopup.swatchFrame.automatic.setText(this.defaultLineColorSource);
                        this.outlineColor.mypopup.swatchFrame.automatic.setHorizontalAlignment(2);
                    }
                    this.outlineColor.setEditor(new ColorComboBoxEditor(this.defaultLineColorSource, defaultColor));
                    if (this.areaStyle.getLineColor() == null) {
                        this.outlineColor.setSelectedItem(this.defaultLineColorSource);
                    } else {
                        this.outlineColor.setSelectedItem(this.areaStyle.getLineColor());
                    }
                    if (this.areaStyle instanceof ColorEditableInterface) {
                        this.outlineColor.setEnabled(((ColorEditableInterface)((Object)this.areaStyle)).isLineColorEditable() && this.outline.isSelected());
                    }
                    this.outlineColor.addActionListener(this);
                    return;
                }
                if (cmd.equals("outline")) {
                    boolean lineOn = this.outline.isSelected();
                    this.areaStyle.setLineOn(lineOn);
                    if (lineOn != this.areaStyle.isLineOn()) {
                        return;
                    }
                    if (this.areaStyle instanceof ColorEditableInterface) {
                        this.outlineColor.setEnabled(lineOn && ((ColorEditableInterface)((Object)this.areaStyle)).isLineColorEditable());
                    } else {
                        this.outlineColor.setEnabled(lineOn);
                    }
                    if (this.lstyle != null) {
                        this.lstyle.setEnabled(lineOn);
                    }
                    if (lineOn) {
                        this.outlineColor.removeActionListener(this);
                        Color c = this.areaStyle.getLineColor();
                        if (c == null) {
                            this.outlineColor.setSelectedItem(this.defaultLineColorSource);
                        } else {
                            this.outlineColor.setSelectedItem(c);
                        }
                        this.outlineColor.addActionListener(this);
                        if (this.fill != null) {
                            this.fill.setEnabled(true);
                        }
                    } else if (this.outline != null) {
                        this.fill.setEnabled(this.validNoFillNoLine);
                    }
                    this.outlineColor.setEnabled(lineOn);
                    return;
                }
                if (cmd.equals("fillcolor")) {
                    Object item = this.fillColor.getSelectedItem();
                    if (item == null) return;
                    Color save2 = this.areaStyle.getFillColor();
                    if (!(item instanceof String)) {
                        if (!(item instanceof Color)) return;
                        this.areaStyle.setFillColor((Color)item);
                        return;
                    }
                    if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                        int result;
                        JColorChooser cc2 = UIUtil.colorChooser;
                        if (save2 == null) {
                            if (this.areaStyle instanceof DefaultAreaInterface) {
                                cc2.setColor(((DefaultAreaInterface)((Object)this.areaStyle)).getDefaultFillColor());
                            }
                        } else {
                            cc2.setColor(save2);
                        }
                        cc2.setPreviewPanel(new JPanel());
                        JPanel panel2 = new JPanel();
                        panel2.setLayout(new BorderLayout());
                        panel2.add(cc2);
                        Container container = this.getTopLevelAncestor();
                        if (!(container instanceof JFrame)) {
                            container = null;
                        }
                        if ((result = SGDialog.showInputDialog((JFrame)container, RB.getStringResource("morecolors.txt"), panel2)) == 0) {
                            Color newColor = cc2.getColor();
                            if (newColor == null) {
                                if (save2 == null) {
                                    this.fillColor.setSelectedItem(this.defaultFillColorSource);
                                    return;
                                }
                                this.fillColor.setSelectedItem(save2);
                                return;
                            }
                            if (save2 != null) {
                                if (save2.getRGB() == newColor.getRGB()) return;
                            }
                            this.areaStyle.setFillColor(newColor);
                            this.fillColor.setSelectedItem(newColor);
                            return;
                        }
                        if (save2 == null) {
                            this.fillColor.setSelectedItem(this.defaultFillColorSource);
                            return;
                        }
                        this.fillColor.setSelectedItem(save2);
                        return;
                    }
                    if (((String)item).equals(this.defaultFillColorSource)) {
                        this.areaStyle.setFillColor(null);
                        return;
                    }
                    Container c = this.getTopLevelAncestor();
                    if (c instanceof SGDialog) {
                        SGDialog sgd = (SGDialog)c;
                        sgd.value = -1;
                        this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                        c.setVisible(false);
                        this.dialog.setVisible(true);
                    }
                    c.requestFocus();
                    if (this.dialog != null) {
                        this.dialog.toFront();
                    }
                    this.colorGrabber.grabComponent.repaint();
                    this.colorGrabber.setMouseEventListener();
                    this.colorGrabber.addActionListener(this);
                    if (save2 == null) {
                        this.colorGrabber.setStartColor(this.defaultFillColorSource);
                    } else {
                        this.colorGrabber.setStartColor(save2);
                    }
                    this.fillColor.showPopup();
                    this.settingFillColor = true;
                    return;
                }
                if (cmd.equals("colorpicker:done")) {
                    Object color = ((SwatchActionEvent)e).getValue();
                    if (this.settingFillColor) {
                        this.fillColor.setSelectedItem(color);
                    } else {
                        this.outlineColor.setSelectedItem(color);
                    }
                    this.colorGrabber.removeMouseEventListener();
                    this.colorGrabber.removeActionListener(this);
                    if (this.dialog == null) return;
                    this.dialog.dispose();
                    return;
                }
                if (cmd.equals("colorpicker:updating")) {
                    int i;
                    Color color = (Color)((SwatchActionEvent)e).getValue();
                    if (color == null) return;
                    if (this.settingFillColor) {
                        int i2;
                        ActionListener[] listener = this.fillColor.getActionListeners();
                        for (i2 = 0; i2 < listener.length; ++i2) {
                            this.fillColor.removeActionListener(listener[i2]);
                        }
                        this.fillColor.setSelectedItem(color);
                        this.fillColor.setEnabled(true);
                        i2 = 0;
                        while (i2 < listener.length) {
                            this.fillColor.addActionListener(listener[i2]);
                            ++i2;
                        }
                        return;
                    }
                    ActionListener[] listener = this.outlineColor.getActionListeners();
                    for (i = 0; i < listener.length; ++i) {
                        this.outlineColor.removeActionListener(listener[i]);
                    }
                    this.outlineColor.setSelectedItem(color);
                    this.outlineColor.setEnabled(true);
                    i = 0;
                    while (i < listener.length) {
                        this.outlineColor.addActionListener(listener[i]);
                        ++i;
                    }
                    return;
                }
                if (cmd.equals("fillstyle")) {
                    ((FillStyleElementInterface)((Object)this.areaStyle)).setFillStyleElement((String)this.fstyle.getSelectedItem());
                    Color c = this.areaStyle.getFillColor();
                    this.fillColor.removeActionListener(this);
                    if (c != null) {
                        this.fillColor.setSelectedItem(c);
                    } else {
                        this.fillColor.setSelectedItem(this.defaultFillColorSource);
                    }
                    this.fillColor.addActionListener(this);
                    return;
                }
                if (!cmd.equals("outlinecolor")) break block74;
                Object item = this.outlineColor.getSelectedItem();
                if (item == null) return;
                save = this.areaStyle.getLineColor();
                if (!(item instanceof String)) {
                    if (!(item instanceof Color)) return;
                    this.areaStyle.setLineColor((Color)item);
                    return;
                }
                if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                    cc = UIUtil.colorChooser;
                    if (save == null) {
                        if (this.areaStyle instanceof DefaultAreaInterface) {
                            cc.setColor(((DefaultAreaInterface)((Object)this.areaStyle)).getDefaultLineColor());
                        }
                    } else {
                        cc.setColor(save);
                    }
                    cc.setPreviewPanel(new JPanel());
                    panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add(cc);
                    break block75;
                } else {
                    if (((String)item).equals(this.defaultLineColorSource)) {
                        this.areaStyle.setLineColor(null);
                        return;
                    }
                    Container c = this.getTopLevelAncestor();
                    if (c instanceof SGDialog) {
                        SGDialog sgd = (SGDialog)c;
                        sgd.value = -1;
                        this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                        c.setVisible(false);
                        this.dialog.setVisible(true);
                    }
                    c.requestFocus();
                    if (this.dialog != null) {
                        this.dialog.toFront();
                    }
                    this.colorGrabber.setMouseEventListener();
                    this.colorGrabber.addActionListener(this);
                    if (save == null) {
                        this.colorGrabber.setStartColor(this.defaultLineColorSource);
                    } else {
                        this.colorGrabber.setStartColor(save);
                    }
                    this.settingFillColor = false;
                    return;
                }
            }
            if (!cmd.equals("linestyle")) return;
            ((LineStyleElementInterface)((Object)this.areaStyle)).setLineStyleElement((String)this.lstyle.getSelectedItem());
            Color c = this.areaStyle.getLineColor();
            this.outlineColor.removeActionListener(this);
            if (c != null) {
                this.outlineColor.setSelectedItem(c);
            } else {
                this.outlineColor.setSelectedItem(this.defaultLineColorSource);
            }
            this.outlineColor.addActionListener(this);
            return;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
        if (result == 0) {
            Color newColor = cc.getColor();
            if (newColor == null) {
                if (save == null) {
                    this.outlineColor.setSelectedItem(this.defaultLineColorSource);
                    return;
                }
                this.outlineColor.setSelectedItem(save);
                return;
            }
            if (save != null) {
                if (save.getRGB() == newColor.getRGB()) return;
            }
            this.areaStyle.setLineColor(newColor);
            this.outlineColor.setSelectedItem(newColor);
            return;
        }
        if (save == null) {
            this.outlineColor.setSelectedItem(this.defaultLineColorSource);
            return;
        }
        this.outlineColor.setSelectedItem(save);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value1 = this.transparency.getModel().getValue();
        if (!this.transparency.getValueIsAdjusting()) {
            this.areaStyle.setFillTrans(value1);
        }
    }
}

