/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.miningresult;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.miningresult.MiningResultObject;
import com.sas.metadata.logical.miningresult.MiningResultType;
import com.sas.metadata.logical.visuals.BIPTreeElementGeneralPropertyTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class MiningResultObjectFactory
implements ObjectFactoryInterface {
    private TypeInterface m_type;
    private Factory m_factory;
    private Action[] m_actionArray = new Action[0];

    public MiningResultObjectFactory(TypeInterface type, Factory factory) {
        this.m_type = type;
        this.m_factory = factory;
    }

    public List getPropertyTabs(LogicalObjectInterface logicalObject, Root root, Config config) throws MdException, RemoteException {
        ArrayList<Object> lTabs = new ArrayList<Object>(2);
        if (!(this.m_type instanceof MiningResultType)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        if (config == null) {
            config = new Config();
        }
        MiningResult miningResult = (MiningResult)root;
        Tree tree = null;
        if (miningResult.getTrees(true).size() > 0) {
            tree = (Tree)miningResult.getTrees(true).get(0);
        }
        BIPTreeElementGeneralPropertyTab generalTab = new BIPTreeElementGeneralPropertyTab((Root)miningResult, tree, 1, this.m_type, config);
        generalTab.setMetadataObjectDisplayType(this.m_type.getDisplayType());
        lTabs.add(generalTab);
        WsGenericGeneralPropertyTab wsTab = new WsGenericGeneralPropertyTab((CMetadata)root);
        lTabs.add(wsTab);
        return lTabs;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        return new MiningResultObject((MiningResult)root, this.m_type, this.m_factory);
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String reposID) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            int fFlags = 260;
            String sTemplate = "<Templates><Job ChangeState=\"\" LockedBy=\"\"/></Templates>";
            List lMiningResults = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "MiningResult", fFlags, sTemplate);
            ArrayList<LogicalObjectInterface> lObjects = new ArrayList<LogicalObjectInterface>(lMiningResults.size());
            for (int iMiningResult = 0; iMiningResult < lMiningResults.size(); ++iMiningResult) {
                lObjects.add(this.createItemFromMetadataObject((Root)((MiningResult)lMiningResults.get(iMiningResult))));
            }
            ArrayList<LogicalObjectInterface> arrayList = lObjects;
            return arrayList;
        }
        finally {
            store.dispose();
        }
    }

    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) {
        return this.m_actionArray;
    }

    public Action[] getActions(LogicalObjectInterface[] logicalObject, Root[] root, Config config) {
        return this.m_actionArray;
    }
}

