/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.editor.LogListHolder;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.SavePanel;
import com.sas.olapadmin.utilities.SaveSasLogActionListener;
import com.sas.workspace.CustomDesktop;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;

public class WsSASLogFrame
extends WAInternalFrame {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(WsSASLogFrame.class);
    private LogListHolder logData;

    public WsSASLogFrame(WsAppServer as) {
        super(bundle.getString("LogFrame.Title.txt"), true, true, true, true);
        ImageIcon icon = bundle.getImageIcon("LogFrame.Icon.image");
        this.setFrameIcon(icon);
        this.layoutWidgets(as);
        this.pack();
        Workspace workspace = Workspace.getWorkspace();
        workspace.getDesktopWindowHandle().addCascaded((Component)((Object)this));
    }

    private void layoutWidgets(WsAppServer as) {
        int height = this.m_appDefaults.getPropertyInt("LogFrameSize.height", 420);
        int width = this.m_appDefaults.getPropertyInt("LogFrameSize.width", 670);
        CustomDesktop desktop = Workspace.getWorkspace().getDesktopWindowHandle();
        if (desktop != null) {
            Dimension desktopSize = desktop.getSize();
            width = Math.min(width, desktopSize.width - desktop.getCascadeXOffset());
            height = Math.min(height, desktopSize.height - desktop.getCascadeXOffset());
        }
        this.setPreferredSize(new Dimension(width, height));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        try {
            this.logData = as.getLog();
        }
        catch (WsAppServerFailException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
        logPropertyTab.appendText(this.logData);
        logPropertyTab.scrollToTop();
        SavePanel panel = new SavePanel((WAPanel)logPropertyTab);
        contentPane.add((Component)((Object)panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.setSaveActionListener(new SaveSasLogActionListener(this.logData));
    }

    public void doDefaultCloseAction() {
        this.m_appDefaults.setPropertyInt("LogFrameSize.height", this.getHeight());
        this.m_appDefaults.setPropertyInt("LogFrameSize.width", this.getWidth());
        super.doDefaultCloseAction();
    }
}

