/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.editor.LogListHolder;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.SavePanel;
import com.sas.olapadmin.utilities.SaveSasLogActionListener;
import com.sas.olapadmin.utilities.WsSASLogFrame;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Dimension;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class WsRunCode {
    protected static WAdminResource bundle = new WAdminResource(WsSASLogFrame.class);
    protected WsAppServer server;
    public boolean hasSubmitError = false;
    protected RunCompletionNotification runCompletionNotification;
    protected CodeSubmitter codeSubmitter;
    private JLabel lblSize;
    private OpRequestUI request;
    protected boolean displayErrorInDetails = false;

    public WsRunCode(WsAppServer as) {
        this.server = as;
        this.hasSubmitError = false;
        try {
            this.server.openSASCodeSession();
        }
        catch (WsAppServerFailException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
            this.hasSubmitError = true;
            return;
        }
        this.request = new OpRequestUI();
        this.request.setProgressShownOnStatusBar(false);
        this.lblSize = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.request.setMessagePreferredSize(this.lblSize.getPreferredSize());
        this.runCompletionNotification = new RunCompletionNotification();
        this.codeSubmitter = new CodeSubmitter();
    }

    public static WsAppServer getServer() {
        WsAppServer server = null;
        boolean ok = false;
        while (!ok) {
            server = WsAppServer.createDefaultAppServer();
            if (server == null) {
                ok = true;
                continue;
            }
            try {
                server.test();
                ok = true;
            }
            catch (WsAppServerFailException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
                WsAppServer.setDefaultAppServerFQID((String)"");
            }
        }
        return server;
    }

    public static boolean checkVersion(WsAppServer srvr) {
        boolean ok = false;
        try {
            String version = srvr.getServerVersion();
            if (version.startsWith("9.01") || version.startsWith("9.00")) {
                MessageUtil.displayMessage((String)bundle.formatString("AppServer.WrongVersion.fmt.txt", (Object)version));
            } else {
                ok = true;
            }
        }
        catch (WsAppServerCodeException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (WsAppServerFailException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
        finally {
            if (srvr.isOpen()) {
                srvr.close();
            }
            if (srvr.isSASCodeSessionOpen()) {
                srvr.closeSASCodeSession();
            }
        }
        return ok;
    }

    public void showLogMessagesInDetails(boolean showLog) {
        this.displayErrorInDetails = showLog;
    }

    public boolean executeCode(StringBuffer runCode, String progressMessage, String progressTitle) {
        this.request.setMessage(progressMessage);
        this.request.setTitle(progressTitle);
        this.codeSubmitter.setCodeToRun(runCode);
        this.request.execute((Runnable)this.codeSubmitter, (Runnable)this.runCompletionNotification);
        return this.hasSubmitError;
    }

    public void term() {
        if (this.server.isSASCodeSessionOpen()) {
            this.server.closeSASCodeSession();
        }
    }

    protected class RunCompletionNotification
    implements Runnable {
        protected RunCompletionNotification() {
        }

        @Override
        public void run() {
            if (!WsRunCode.this.hasSubmitError) {
                WsSASLogFrame logframe = new WsSASLogFrame(WsRunCode.this.server);
                logframe.setVisible(true);
            }
        }
    }

    protected class CodeSubmitter
    implements Runnable {
        String code;

        protected CodeSubmitter() {
        }

        public void setCodeToRun(StringBuffer codeToRun) {
            this.code = codeToRun.toString();
        }

        @Override
        public void run() {
            try {
                WsRunCode.this.server.submitSASCode(this.code);
            }
            catch (WsAppServerFailException e) {
                WsRunCode.this.hasSubmitError = true;
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (WsAppServerCodeException e2) {
                WsRunCode.this.hasSubmitError = true;
                if (WsRunCode.this.displayErrorInDetails) {
                    WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
                    try {
                        LogListHolder logData = WsRunCode.this.server.getLog();
                        logPropertyTab.appendText(logData);
                        logPropertyTab.scrollToTop();
                        SavePanel panel = new SavePanel((WAPanel)logPropertyTab);
                        panel.setPreferredSize(new Dimension(400, 350));
                        panel.setSaveActionListener(new SaveSasLogActionListener(logData));
                        MessageUtil.displayDetailsMessage((String)e2.getLocalizedMessage(), (int)0, (JComponent)((Object)panel));
                    }
                    catch (WsAppServerFailException e3) {
                        ExceptionHandler.handleException((Exception)((Object)e3));
                    }
                }
                ExceptionHandler.handleException((Exception)((Object)e2));
                WsSASLogFrame logframe = new WsSASLogFrame(WsRunCode.this.server);
                logframe.setVisible(true);
            }
        }
    }
}

