/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.beans.Util;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.visuals.dualselector.JPanelDualSelectorAdapter;
import com.sas.workspace.visuals.dualselector.SelectorPanel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class PanelTreeSelector
extends BaseDualSelector
implements WsSelectionChangedListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private boolean clearSelection;
    private transient DefaultTreeModel targetTreeModel;
    protected JPanel m_sourceJPanel;
    protected SelectorPanel m_sourceSelectorPanel;
    protected JTree m_targetJTree;

    public PanelTreeSelector(JPanel panel) {
        if (!(panel instanceof SelectorPanel)) {
            throw new IllegalArgumentException("The JPanel must implement the SelectorPanel interface.");
        }
        this.setDesignTime(Util.isDesignTime());
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        this.sourceAdapter = new JPanelDualSelectorAdapter(panel, (JComponent)((Object)this));
        this.targetAdapter = new JTreeDualSelectorAdapter((JComponent)((Object)this));
        this.m_sourceJPanel = panel;
        this.m_sourceSelectorPanel = (SelectorPanel)panel;
        this.m_targetJTree = (JTree)this.targetAdapter.getComponent();
        this.initializeBaseDualSelector();
        this.m_sourceJPanel.addMouseListener(this.sourceMouseListener);
        this.m_targetJTree.addMouseListener(this.targetMouseListener);
        if (this.m_targetJTree.getModel() == null) {
            this.m_targetJTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
    }

    protected void addListeners() {
        super.addListeners();
        this.m_sourceSelectorPanel.removeSelectionChangedListener((WsSelectionChangedListener)this);
        this.m_sourceSelectorPanel.addSelectionChangedListener((WsSelectionChangedListener)this);
        this.m_targetJTree.removeTreeSelectionListener(this);
        this.m_targetJTree.addTreeSelectionListener(this);
    }

    public TreeCellRenderer getTargetCellRenderer() {
        return this.m_targetJTree.getCellRenderer();
    }

    public void setTargetCellRenderer(TreeCellRenderer newValue) {
        TreeCellRenderer oldValue = this.m_targetJTree.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.m_targetJTree.setCellRenderer(newValue);
        this.firePropertyChange("targetListCellRenderer", oldValue, newValue);
    }

    public DefaultTreeModel getTargetModel() {
        return this.targetTreeModel;
    }

    public void setTargetModel(DefaultTreeModel listModel) throws IllegalArgumentException {
        DefaultTreeModel oldModel;
        if (listModel instanceof DefaultTreeModel) {
            oldModel = this.targetTreeModel;
            if (listModel != null) {
                this.targetTreeModel = listModel;
            }
            if (this.m_targetJTree != null) {
                this.m_targetJTree.setModel(this.targetTreeModel);
            } else {
                this.targetTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
                if (this.m_targetJTree != null) {
                    this.m_targetJTree.setModel(this.targetTreeModel);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("targetListModel", oldModel, this.targetTreeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(WsSelectionChangedEvent ev) {
        WsSelectionProvider source = (WsSelectionProvider)ev.getSource();
        Object[] aObjects = source.getSelectedObjects();
        this.direction = aObjects == null || aObjects.length <= 0;
        if (aObjects != null && aObjects.length > 0) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.m_targetJTree.getSelectionModel().clearSelection();
                this.direction = false;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent ie) {
        this.direction = ie.isAddedPath();
        Object source = ie.getSource();
        if (!this.clearSelection && ie.isAddedPath() && source == this.m_targetJTree) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.m_sourceSelectorPanel.clearSelection();
                this.direction = true;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }
}

