/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.MemberDistinctValues;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Dimension;
import com.sas.storage.olap.sasmdx.Hierarchy;
import com.sas.storage.olap.sasmdx.Member;
import com.sas.storage.olap.sasmdx.Metadata;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MemberTreeNode
extends DefaultMutableTreeNode
implements DataSourceNodeInterface,
TreeNode {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    private String uniqueName;
    private String description;
    private String toolTip;
    private Object userObject;
    private ArrayList childNodes;
    private boolean initialized;
    private boolean showLeafMembers = true;
    private boolean showMeasuresDimension = true;
    private boolean showHierarchies = true;
    private DefaultMutableTreeNode parentNode;
    private boolean hasPermissions = false;
    private OlapServer olapServer;
    private com.sas.metadata.remote.Dimension dimension;
    private OLAPDimension olapDimension;
    private String hierarchyName;
    private String allMemberName;
    private static final String EMPTY_STRING = "";
    private boolean rootInitialized = false;
    private boolean physicalDataExists = false;
    private OLAPHierarchy olapHierarchy;

    public MemberTreeNode(MetadataEntityInterface entity, MemberTreeNode node, boolean leaf, boolean hierarchies, OLAPHierarchy olapHierarchy2) {
        try {
            this.parentNode = node;
            this.name = entity.getName();
            this.displayName = entity.getLabel();
            this.toolTip = this.description = entity.getUniqueName();
            this.userObject = entity;
            this.uniqueName = entity.getUniqueName();
            this.hierarchyName = node.getHierarchyName();
            this.allMemberName = node.getAllMemberName();
            this.childNodes = new ArrayList();
            this.initialized = false;
            this.showLeafMembers = leaf;
            this.showHierarchies = hierarchies;
            this.olapHierarchy = olapHierarchy2;
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException(e);
        }
    }

    public MemberTreeNode(Cube cube, OlapServer server, boolean showLeaf, boolean showMeasures, boolean hierarchies, com.sas.metadata.remote.Dimension selectedDim) {
        try {
            if (cube == null) {
                this.name = selectedDim.getName();
                this.description = selectedDim.getDesc();
                this.userObject = selectedDim;
                this.physicalDataExists = !selectedDim.getUniqueName().equals(EMPTY_STRING);
            } else {
                this.name = cube.getName();
                this.description = cube.getDesc();
                this.userObject = cube;
                this.physicalDataExists = !cube.getCubeName().equals(EMPTY_STRING);
            }
            this.displayName = this.name;
            this.toolTip = this.description;
            this.uniqueName = EMPTY_STRING;
            this.childNodes = new ArrayList();
            this.showLeafMembers = showLeaf;
            this.showMeasuresDimension = showMeasures;
            this.showHierarchies = hierarchies;
            this.dimension = selectedDim;
            this.olapServer = server;
            if (server.isConnected()) {
                this.initializeRoot();
            }
        }
        catch (RemoteException error) {
            ExceptionHandler.handleException(error);
        }
    }

    public MemberTreeNode(OLAPCube olapCube, OlapServer olapServer2, boolean showLeaf, boolean showMeasures, boolean hierarchies, OLAPDimension selectedDim) {
        this(olapCube, olapServer2, showLeaf, showMeasures, hierarchies, selectedDim, null);
    }

    public MemberTreeNode(OLAPCube olapCube, OlapServer olapServer2, boolean showLeaf, boolean showMeasures, boolean hierarchies, OLAPDimension selectedDim, OLAPHierarchy selectedHier) {
        if (olapCube == null && selectedDim != null && selectedDim instanceof OLAPSharedDimension) {
            this.name = selectedDim.getName();
            this.description = selectedDim.getDesc();
            this.userObject = (OLAPSharedDimension)selectedDim;
            this.physicalDataExists = ((OLAPSharedDimension)selectedDim).physicallyExists();
        } else {
            this.name = olapCube.getName();
            this.description = olapCube.getDesc();
            this.userObject = olapCube;
            this.physicalDataExists = olapCube.physicallyExists();
        }
        this.displayName = this.name;
        this.toolTip = this.description;
        this.uniqueName = EMPTY_STRING;
        this.childNodes = new ArrayList();
        this.showLeafMembers = showLeaf;
        this.showMeasuresDimension = showMeasures;
        this.showHierarchies = hierarchies;
        this.olapDimension = selectedDim;
        this.olapServer = olapServer2;
        this.olapHierarchy = selectedHier;
        if (this.olapServer.isConnected()) {
            this.initializeRoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeCube() {
        try {
            Metadata cubeMetadata = this.olapServer.getCubeMetadataSet();
            Filter filter = new Filter();
            filter.setCubeName(this.name);
            OLAPSchema schema = this.olapServer.getOLAPSchema();
            String schemaName = EMPTY_STRING;
            if (schema != null) {
                schemaName = schema.getName();
            }
            filter.setSchemaName(schemaName);
            if (this.dimension != null) {
                filter.setDimensionName(this.dimension.getName());
                filter.setUniqueDimensionName(this.dimension.getUniqueName());
            } else if (this.olapDimension != null) {
                filter.setDimensionName(this.olapDimension.getName());
                filter.setUniqueDimensionName(this.olapDimension.getUniqueName());
            }
            DimensionInterface[] dimensions = cubeMetadata.getDimensions(filter);
            Dimension measuresDimension = null;
            for (int i = 0; i < dimensions.length; ++i) {
                Dimension dim = (Dimension)dimensions[i];
                if (dim.getType() == 2 && this.showMeasuresDimension) {
                    measuresDimension = dim;
                    continue;
                }
                if (dim.getType() == 2) continue;
                MemberTreeNode dimNode = new MemberTreeNode((MetadataEntityInterface)dim, this, this.showLeafMembers, this.showHierarchies, this.olapHierarchy);
                this.childNodes.add(dimNode);
            }
            if (measuresDimension != null) {
                MemberTreeNode dimNode = new MemberTreeNode((MetadataEntityInterface)measuresDimension, this, this.showLeafMembers, this.showHierarchies, null);
                this.childNodes.add(dimNode);
            }
            this.initialized = true;
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException(e);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException(e);
        }
        catch (com.sas.olapadmin.designer.model.OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        finally {
            this.rootInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSharedDimension() {
        try {
            String schemaName;
            OLAPSchema schema;
            Metadata sharedDimensionMetadata = this.olapServer.getSharedDimensionMetadataSet();
            Filter filter = new Filter();
            filter.setIncludeSharedDimensions(true);
            if (this.dimension != null) {
                schema = this.dimension.getAssociatedOLAPSchema();
                schemaName = EMPTY_STRING;
                if (schema != null) {
                    schemaName = schema.getName();
                }
                filter.setSchemaName(schemaName);
                filter.setDimensionName(this.dimension.getName());
                filter.setUniqueDimensionName(this.dimension.getUniqueName());
            } else if (this.olapDimension != null) {
                schema = ((OLAPSharedDimension)this.olapDimension).getAssociatedOLAPSchema();
                schemaName = EMPTY_STRING;
                if (schema != null) {
                    schemaName = schema.getName();
                }
                filter.setSchemaName(schemaName);
                filter.setDimensionName(this.olapDimension.getName());
                filter.setUniqueDimensionName(this.olapDimension.getUniqueName());
            }
            if (this.olapHierarchy != null) {
                filter.setHierarchyName(this.olapHierarchy.getName());
                filter.setUniqueHierarchyName(this.olapHierarchy.getUniqueName());
            }
            DimensionInterface[] dimensions = sharedDimensionMetadata.getDimensions(filter);
            for (int i = 0; i < dimensions.length; ++i) {
                Dimension dim = (Dimension)dimensions[i];
                if (dim.getType() == 2) continue;
                if (this.showHierarchies) {
                    HierarchyInterface[] hierarchies = dim.getHierarchies();
                    for (int j = 0; j < hierarchies.length; ++j) {
                        Hierarchy hier = (Hierarchy)hierarchies[j];
                        MemberTreeNode hierNode = new MemberTreeNode((MetadataEntityInterface)hier, this, this.showLeafMembers, this.showHierarchies, null);
                        this.childNodes.add(hierNode);
                    }
                    continue;
                }
                filter.setLevelNumber(0);
                MetadataInterface metadata = dim.getMetadata();
                MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                this.addChildNodes((MetadataEntityInterface[])members);
            }
            this.initialized = true;
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException(e);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException(e);
        }
        catch (com.sas.olapadmin.designer.model.OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (MdException mde) {
            ExceptionHandler.handleException((Exception)((Object)mde));
        }
        finally {
            this.rootInitialized = true;
        }
    }

    public boolean isRootInitialized() {
        return this.rootInitialized;
    }

    public void initializeRoot() {
        if (!this.physicalDataExists) {
            return;
        }
        if (this.userObject instanceof Cube || this.userObject instanceof OLAPCube) {
            this.initializeCube();
        } else if (this.userObject instanceof SharedDimension || this.userObject instanceof OLAPSharedDimension) {
            this.initializeSharedDimension();
        }
    }

    private void addChildNodes(MetadataEntityInterface[] children1) {
        for (MetadataEntityInterface childMember : children1) {
            MemberTreeNode childNode = new MemberTreeNode(childMember, this, this.showLeafMembers, this.showHierarchies, null);
            this.childNodes.add(childNode);
        }
    }

    public Enumeration children() {
        this.initialize();
        Enumeration kids = new Enumeration(){
            int i = 0;

            @Override
            public boolean hasMoreElements() {
                return this.i < MemberTreeNode.this.childNodes.size();
            }

            public Object nextElement() {
                return MemberTreeNode.this.childNodes.get(this.i++);
            }
        };
        return kids;
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.olapServer != null && !this.olapServer.isConnected()) {
            return true;
        }
        boolean returncode = false;
        if (this.userObject != null && this.getChildCount() > 0) {
            returncode = true;
        }
        return returncode;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.initialize();
        return (TreeNode)this.childNodes.get(childIndex);
    }

    @Override
    public int getChildCount() {
        if (this.olapServer != null && !this.olapServer.isConnected()) {
            return 0;
        }
        this.initialize();
        return this.childNodes.size();
    }

    public DataValuesInterface getDataValuesInterface() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DistinctValuesInterface getDistinctValuesInterface() {
        return new MemberDistinctValues(this);
    }

    public FormattedValuesInterface getFormattedValuesInterface() {
        return null;
    }

    @Override
    public int getIndex(TreeNode node) {
        this.initialize();
        return this.childNodes.indexOf(node);
    }

    public String getInsertName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public TreeNode getParent() {
        return this.parentNode;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    private void initialize() {
        if (!this.initialized) {
            try {
                this.initialized = true;
                if (this.userObject instanceof Dimension) {
                    Dimension dim = (Dimension)this.userObject;
                    Filter filter = dim.getFilter();
                    filter.setDimensionName(dim.getName());
                    filter.setUniqueDimensionName(dim.getUniqueName());
                    if (this.olapHierarchy != null) {
                        filter.setHierarchyName(this.olapHierarchy.getName());
                        filter.setUniqueHierarchyName(this.olapHierarchy.getUniqueName());
                    }
                    if (!this.showHierarchies) {
                        filter.setLevelNumber(0);
                        MetadataInterface metadata = dim.getMetadata();
                        MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                        this.addChildNodes((MetadataEntityInterface[])members);
                    } else {
                        HierarchyInterface[] hierarchies = dim.getHierarchies();
                        this.addChildNodes((MetadataEntityInterface[])hierarchies);
                    }
                } else if (this.userObject instanceof Hierarchy) {
                    Hierarchy hier = (Hierarchy)this.userObject;
                    this.hierarchyName = hier.getUniqueName();
                    MemberInterface topMember = hier.getTopMember();
                    if (topMember != null) {
                        this.allMemberName = topMember.getUniqueName();
                    }
                    Filter filter = hier.getFilter();
                    filter.setHierarchyName(hier.getName());
                    filter.setUniqueHierarchyName(hier.getUniqueName());
                    filter.setLevelNumber(0);
                    MetadataInterface metadata = hier.getMetadata();
                    MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                    this.addChildNodes((MetadataEntityInterface[])members);
                } else if (this.userObject instanceof Member) {
                    Member member = (Member)this.userObject;
                    boolean getChildren = true;
                    if (!this.showLeafMembers) {
                        LevelInterface[] levels = member.getLevel().getHierarchy().getLevels();
                        int depth = member.getLevel().getDepth();
                        if (depth >= levels.length - 2) {
                            getChildren = false;
                        }
                    }
                    if (member.getChildCount() > 0 && getChildren) {
                        MemberInterface[] members = member.getChildren();
                        this.addChildNodes((MetadataEntityInterface[])members);
                    }
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException(e);
            }
        }
    }

    @Override
    public boolean isLeaf() {
        if (this.olapServer != null && !this.olapServer.isConnected()) {
            return false;
        }
        this.initialize();
        boolean returncode = true;
        if (this.userObject != null && this.getChildCount() > 0) {
            returncode = false;
        }
        return returncode;
    }

    @Override
    public String toString() {
        return this.displayName;
    }

    public String getUniqueMemberName() {
        String selectedUniqueName = EMPTY_STRING;
        Object userObject1 = this.getUserObject();
        if (userObject1 != null && userObject1 instanceof Member) {
            try {
                selectedUniqueName = ((Member)userObject1).getUniqueName();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException(e);
            }
        }
        return selectedUniqueName;
    }

    public String getHierarchyName() {
        if (this.hierarchyName != null) {
            return this.hierarchyName;
        }
        return EMPTY_STRING;
    }

    public String getAllMemberName() {
        if (this.allMemberName != null) {
            return this.allMemberName;
        }
        return EMPTY_STRING;
    }

    public void setHasPermissions(boolean hasPerm) {
        this.hasPermissions = hasPerm;
    }

    public boolean hasPermissions() {
        return this.hasPermissions;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setParent(DefaultMutableTreeNode parent) {
        this.parentNode = parent;
    }
}

