/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.olapadmin.utilities.MDXQueryGenerationException;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.Strings;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MDXQueryGeneration {
    private static WAdminResource bundle = new WAdminResource(MDXQueryGeneration.class);
    static final String SELECT = "SELECT ";
    static final String SELECT_RETURN = "SELECT \n   ";
    static final String COMMA = ",";
    static final String FROM_RETURN = "\n FROM \n   ";
    static final String FROM = " FROM ";
    static final String LEFT_BRACE = "(";
    static final String RIGHT_BRACE = ")";
    static final String LEFT_CURLY_BRACKET = "{";
    static final String LEFT_CURLY_BRACKET_NONEMPTY = "NON EMPTY {";
    static final String RIGHT_CURLY_BRACKET = "}";
    static final String LEFT_BRACKET = "[";
    static final String RIGHT_BRACKET = "]";
    static final String CROSSJOIN = "CROSSJOIN";
    static final String CHILDREN = ".CHILDREN";
    static final boolean PREFIXCOMMA_FALSE = false;
    static final boolean PREFIXCOMMA_TRUE = true;
    public static final String ON_COLUMNS = " ON COLUMNS";
    public static final String ON_ROWS = " ON ROWS";
    public static final String WHERE_RETURN = " WHERE \n";
    public static final String WHERE = " WHERE ";
    public static final String RETURN = "\n";
    public static final String INDENT = "   ";
    private String leftCurlyBracketToUse;
    private boolean useNonEmpty;
    private String functionToUse;
    private String columnSet;
    private String rowSet;
    private String queryStatement;
    private String whereClause;
    private String defaultOnColumn;
    private Map dimensionsByAxis = new HashMap();
    private Map setsByDimension = new HashMap();
    private List axisDimensions = new ArrayList();
    private Map previousColumn;
    private Map previousRow;
    private Object[] previousAxisList;
    private String displayMdxText;
    private StringBuffer displayBuffer;
    boolean isResetNeeded;
    private Map allMemberMap;

    public MDXQueryGeneration() {
        this.dimensionsByAxis.put(ON_COLUMNS, this.axisDimensions);
        this.axisDimensions = new ArrayList();
        this.dimensionsByAxis.put(ON_ROWS, this.axisDimensions);
        this.axisDimensions = new ArrayList();
        this.dimensionsByAxis.put(WHERE, this.axisDimensions);
        this.previousColumn = new HashMap();
        this.previousRow = new HashMap();
        this.isResetNeeded = false;
        this.functionToUse = CHILDREN;
        this.columnSet = "";
        this.rowSet = "";
        this.queryStatement = "";
        this.whereClause = "";
        this.defaultOnColumn = "[MEASURES].DEFAULTMEMBER";
        this.leftCurlyBracketToUse = LEFT_CURLY_BRACKET_NONEMPTY;
        this.displayMdxText = "";
    }

    public void resetOnRows() throws MDXQueryGenerationException {
        this.resetAxis(ON_ROWS);
    }

    public void restoreColumnAxis() throws MDXQueryGenerationException {
        if (!this.previousColumn.isEmpty()) {
            for (int i = 0; i < this.previousAxisList.length; ++i) {
                DimensionInterface restoreDimension = (DimensionInterface)this.previousAxisList[i];
                this.addDimensionForAxis(ON_COLUMNS, restoreDimension);
                List dimension_members = (List)this.previousColumn.get(restoreDimension);
                this.setDimensionMembers(restoreDimension, dimension_members);
            }
        }
    }

    public void restoreRowAxis() throws MDXQueryGenerationException {
        if (!this.previousRow.isEmpty()) {
            for (int i = 0; i < this.previousAxisList.length; ++i) {
                DimensionInterface restoreDimension = (DimensionInterface)this.previousAxisList[i];
                this.addDimensionForAxis(ON_ROWS, restoreDimension);
                List dimension_members = (List)this.previousRow.get(restoreDimension);
                this.setDimensionMembers(restoreDimension, dimension_members);
            }
        }
    }

    public void resetOnColumns() throws MDXQueryGenerationException {
        this.resetAxis(ON_COLUMNS);
    }

    public void resetWhere() throws MDXQueryGenerationException {
        this.resetAxis(WHERE);
    }

    private void resetAxis(String axis) throws MDXQueryGenerationException {
        this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(axis);
        this.previousAxisList = this.axisDimensions.toArray();
        if (!this.axisDimensions.isEmpty()) {
            if (axis.equals(ON_COLUMNS)) {
                this.previousColumn.clear();
            } else if (axis.equals(ON_ROWS)) {
                this.previousRow.clear();
            }
            for (int i = this.axisDimensions.size() - 1; i >= 0; --i) {
                DimensionInterface dimension = (DimensionInterface)this.axisDimensions.get(i);
                try {
                    Object dimensionExpression = this.setsByDimension.get(dimension.getUniqueName());
                    if (!this.setsByDimension.containsKey(dimension.getUniqueName())) continue;
                    if (axis.equals(ON_COLUMNS)) {
                        this.previousColumn.put(dimension, dimensionExpression);
                    } else if (axis.equals(ON_ROWS)) {
                        this.previousRow.put(dimension, dimensionExpression);
                    }
                    this.setsByDimension.remove(dimension.getUniqueName());
                    continue;
                }
                catch (OLAPException e) {
                    throw new MDXQueryGenerationException(e.getLocalizedMessage());
                }
            }
            this.axisDimensions.clear();
        }
    }

    public void addDimensionMembersForAxis(DimensionInterface dimension, List dimension_members, String axisToApply) throws MDXQueryGenerationException {
        if (dimension == null) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.NullDimensionException.txt"));
        }
        if (dimension_members == null || dimension_members.isEmpty()) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.InvalidDimensionMembersException.txt"));
        }
        if (axisToApply == null || Utilities.isBlank(axisToApply)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.NullDimensionException.txt"));
        }
        this.addDimensionForAxis(axisToApply, dimension);
        this.setDimensionMembers(dimension, dimension_members);
    }

    public void addToExistingDimensionMembers(DimensionInterface dimension, String dimensionMember) throws MDXQueryGenerationException {
        if (dimension == null) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.NullDimensionException.txt"));
        }
        if (dimensionMember == null || Utilities.isBlank(dimensionMember)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.IllegalDimensionMemberException.txt"));
        }
        List existingMembers = this.getDimensionMembers(dimension);
        if (!MDXQueryGeneration.containsMember(existingMembers, dimensionMember)) {
            for (int i = existingMembers.size() - 1; i >= 0; --i) {
                String previousMember = (String)existingMembers.get(i);
                if (!(previousMember.indexOf(CHILDREN) > 0 | dimensionMember.indexOf(CHILDREN) > 0)) continue;
                existingMembers.remove(i);
            }
            existingMembers.add(dimensionMember);
            this.setDimensionMembers(dimension, existingMembers);
        }
    }

    private void setDimensionMembers(DimensionInterface dimension, List dimensionMembers) throws MDXQueryGenerationException {
        try {
            this.setsByDimension.put(dimension.getUniqueName(), dimensionMembers);
        }
        catch (OLAPException e) {
            throw new MDXQueryGenerationException(e.getLocalizedMessage());
        }
    }

    private List getDimensionMembers(DimensionInterface dimension) throws MDXQueryGenerationException {
        String dimensionUniqueName = null;
        try {
            dimensionUniqueName = dimension.getUniqueName();
        }
        catch (OLAPException e) {
            throw new MDXQueryGenerationException(e.getLocalizedMessage());
        }
        List dimension_members = this.setsByDimension.containsKey(dimensionUniqueName) ? (List)this.setsByDimension.get(dimensionUniqueName) : new ArrayList();
        return dimension_members;
    }

    private boolean isDimensionOnOtherAxis(List otherAxisToCheck, DimensionInterface dimensionToCheck) throws OLAPException {
        boolean onOtherAxis = false;
        for (int p = 0; p < otherAxisToCheck.size(); ++p) {
            String otherDimensionName;
            String dimensionToCheckName = dimensionToCheck.getUniqueName();
            if (!dimensionToCheckName.equals(otherDimensionName = ((DimensionInterface)otherAxisToCheck.get(p)).getUniqueName())) continue;
            onOtherAxis = true;
        }
        return onOtherAxis;
    }

    private void findAndRemoveDimension(String axisMovingFrom, DimensionInterface dimensionToCheck) throws OLAPException {
        ArrayList movingFromAxisDimensions = (ArrayList)this.dimensionsByAxis.get(axisMovingFrom);
        for (int p = 0; p < movingFromAxisDimensions.size(); ++p) {
            String otherDimensionName;
            String dimensionToCheckName = dimensionToCheck.getUniqueName();
            if (!dimensionToCheckName.equals(otherDimensionName = ((DimensionInterface)movingFromAxisDimensions.get(p)).getUniqueName())) continue;
            movingFromAxisDimensions.remove(p);
            this.dimensionsByAxis.put(axisMovingFrom, movingFromAxisDimensions);
            break;
        }
    }

    private void addDimensionForAxis(String axisToApply, DimensionInterface dimension) throws MDXQueryGenerationException {
        try {
            if (axisToApply.equals(ON_ROWS)) {
                this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(ON_COLUMNS);
                if (!this.axisDimensions.isEmpty() & this.isDimensionOnOtherAxis(this.axisDimensions, dimension)) {
                    this.removeDimensionFromAxis(ON_COLUMNS, axisToApply, dimension);
                }
                this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(WHERE);
                if (!this.axisDimensions.isEmpty()) {
                    this.removeDimensionFromAxis(WHERE, axisToApply, dimension);
                }
            }
            if (axisToApply.equals(ON_COLUMNS)) {
                this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(ON_ROWS);
                if (!this.axisDimensions.isEmpty() & this.isDimensionOnOtherAxis(this.axisDimensions, dimension)) {
                    this.removeDimensionFromAxis(ON_ROWS, axisToApply, dimension);
                }
                this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(WHERE);
                if (!this.axisDimensions.isEmpty()) {
                    this.removeDimensionFromAxis(WHERE, axisToApply, dimension);
                }
            }
            if (axisToApply.equals(WHERE)) {
                this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(ON_COLUMNS);
                if (!this.axisDimensions.isEmpty()) {
                    this.removeDimensionFromAxis(ON_COLUMNS, axisToApply, dimension);
                }
                this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(ON_ROWS);
                if (!this.axisDimensions.isEmpty()) {
                    this.removeDimensionFromAxis(ON_ROWS, axisToApply, dimension);
                }
            }
            if (this.dimensionsByAxis.containsKey(axisToApply)) {
                this.axisDimensions = (ArrayList)this.dimensionsByAxis.get(axisToApply);
            }
            if (!MDXQueryGeneration.containsDimension(this.axisDimensions, dimension)) {
                this.axisDimensions.add(dimension);
            }
        }
        catch (OLAPException e) {
            throw new MDXQueryGenerationException(e.getLocalizedMessage());
        }
    }

    private void removeDimensionFromAxis(String axisMovingFrom, String axisMovingTo, DimensionInterface dimension) throws MDXQueryGenerationException {
        String axisUniqueName = null;
        String dimensionUniqueName = null;
        String axisName = null;
        ArrayList movingFromAxisDimensions = (ArrayList)this.dimensionsByAxis.get(axisMovingFrom);
        int axisSize = movingFromAxisDimensions.size();
        try {
            String dimensionName = dimension.getName();
            axisName = axisMovingFrom.equals(ON_COLUMNS) ? bundle.getString("MDXQueryGeneration.NoDimensionOnAxis.column.txt") : bundle.getString("MDXQueryGeneration.NoDimensionOnAxis.row.txt");
            dimensionUniqueName = dimension.getUniqueName();
            if (axisSize > 0) {
                for (int i = axisSize - 1; i >= 0; --i) {
                    DimensionInterface axisDimension = (DimensionInterface)movingFromAxisDimensions.get(i);
                    axisUniqueName = axisDimension.getUniqueName();
                    if (!dimensionUniqueName.equals(axisUniqueName)) continue;
                    if (axisSize == 1 & !axisMovingFrom.equals(WHERE)) {
                        if (axisMovingTo.equals(ON_COLUMNS)) {
                            this.restoreColumnAxis();
                        } else if (axisMovingTo.equals(ON_ROWS)) {
                            this.restoreRowAxis();
                        }
                        throw new MDXQueryGenerationException(bundle.formatString("MDXQueryGeneration.NoDimensionOnAxis.txt", (Object)dimensionName, (Object)axisName));
                    }
                    this.findAndRemoveDimension(axisMovingFrom, dimension);
                }
            }
        }
        catch (OLAPException e) {
            throw new MDXQueryGenerationException(e.getLocalizedMessage());
        }
    }

    public ArrayList getAxisDimensions(String axis) {
        if (axis == null || Utilities.isBlank(axis)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.IllegalAxisException.txt"));
        }
        ArrayList axisDimensionsList = (ArrayList)this.dimensionsByAxis.get(axis);
        return axisDimensionsList;
    }

    public Map getDimensionMembersForAxis(String axis) throws MDXQueryGenerationException {
        if (axis == null || Utilities.isBlank(axis)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.IllegalAxisException.txt"));
        }
        HashMap<DimensionInterface, List> dimensionMembers = new HashMap<DimensionInterface, List>();
        ArrayList dimensionsForAxis = this.getAxisDimensions(axis);
        if (!dimensionsForAxis.isEmpty()) {
            int size = dimensionsForAxis.size();
            for (int i = 0; i < size; ++i) {
                DimensionInterface dimension = (DimensionInterface)dimensionsForAxis.get(i);
                try {
                    List members = (List)this.setsByDimension.get(dimension.getUniqueName());
                    dimensionMembers.put(dimension, members);
                    continue;
                }
                catch (OLAPException e) {
                    throw new MDXQueryGenerationException(e.getLocalizedMessage());
                }
            }
        }
        return dimensionMembers;
    }

    public String getDisplayMdxQuery() {
        return this.displayMdxText;
    }

    public String constructMdxQuery(String cubeName) throws MDXQueryGenerationException {
        if (cubeName == null || Utilities.isBlank(cubeName)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.IllegalAxisException.txt"));
        }
        this.isResetNeeded = true;
        StringBuffer buffer = new StringBuffer(100);
        this.displayBuffer = new StringBuffer(100);
        this.leftCurlyBracketToUse = !this.useNonEmpty ? LEFT_CURLY_BRACKET : LEFT_CURLY_BRACKET_NONEMPTY;
        this.constructSelect(buffer);
        this.constructOnColumns(buffer);
        buffer.append(COMMA);
        this.displayBuffer.append(COMMA).append(RETURN);
        this.constructOnRows(buffer);
        this.constructFrom(buffer, cubeName);
        this.constructWhere(buffer);
        this.queryStatement = buffer.toString();
        this.displayMdxText = this.displayBuffer.toString();
        buffer = null;
        this.isResetNeeded = true;
        return this.queryStatement;
    }

    public String constructDefaultMdxQuery(DimensionInterface measureDimension, DimensionInterface defaultDimension, String dimDefaultHierarchy, String cubeName, boolean useNonEmpty1) throws MDXQueryGenerationException {
        if (measureDimension == null | defaultDimension == null) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.NullDimensionException.txt"));
        }
        if (dimDefaultHierarchy == null || Utilities.isBlank(dimDefaultHierarchy)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.IllegalDimensionHierarchyException.txt"));
        }
        if (cubeName == null || Utilities.isBlank(cubeName)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.IllegalCubeNameException.txt"));
        }
        this.leftCurlyBracketToUse = useNonEmpty1 ? LEFT_CURLY_BRACKET_NONEMPTY : LEFT_CURLY_BRACKET;
        StringBuffer buffer = new StringBuffer(100);
        this.constructSelect(buffer);
        this.columnSet = this.columnSet.concat(this.leftCurlyBracketToUse).concat(this.defaultOnColumn).concat(RIGHT_CURLY_BRACKET);
        ArrayList<String> columnMembersList = new ArrayList<String>();
        columnMembersList.add(this.columnSet);
        this.addDimensionMembersForAxis(measureDimension, columnMembersList, ON_COLUMNS);
        this.constructOnColumns(buffer);
        buffer.append(COMMA);
        buffer.append(RETURN);
        ArrayList<String> rowMembersList = new ArrayList<String>();
        this.rowSet = this.rowSet.concat(this.leftCurlyBracketToUse).concat(dimDefaultHierarchy).concat(this.functionToUse).concat(RIGHT_CURLY_BRACKET);
        rowMembersList.add(this.rowSet);
        this.addDimensionMembersForAxis(defaultDimension, rowMembersList, ON_ROWS);
        this.constructOnRows(buffer);
        buffer.append(RETURN);
        this.constructFrom(buffer, cubeName);
        this.queryStatement = buffer.toString();
        buffer = null;
        return this.queryStatement;
    }

    public String curlyBraceSet(List selected) {
        HashMap membersByHierarchy = new HashMap();
        ArrayList<String> listOfHierarchies = new ArrayList<String>();
        String newSet = "";
        ArrayList<String> noCrossjoinItems = new ArrayList<String>();
        ArrayList<String> crossjoinItems = new ArrayList<String>();
        List membersOfSameHierarchy = new ArrayList();
        String item = null;
        ArrayList<String> newSelected = new ArrayList<String>();
        if (selected.size() == 1) {
            item = (String)selected.get(0);
            noCrossjoinItems.add(item);
        } else {
            for (int p = 0; p < selected.size(); ++p) {
                String currentHierarchy;
                String hierarchyItem;
                int firstPeriodPosition;
                item = (String)selected.get(p);
                int secondPeriodPosition = item.indexOf(46, (firstPeriodPosition = item.indexOf(46)) + 1);
                if (secondPeriodPosition < 1) {
                    hierarchyItem = item.substring(firstPeriodPosition + 2, item.length() - 1);
                    currentHierarchy = this.allMemberMap.containsKey(hierarchyItem) ? hierarchyItem : "MEASURES";
                } else {
                    hierarchyItem = item.substring(firstPeriodPosition + 1, secondPeriodPosition);
                    currentHierarchy = hierarchyItem.substring(hierarchyItem.indexOf(91) + 1, hierarchyItem.indexOf(93));
                }
                if (!listOfHierarchies.contains(currentHierarchy)) {
                    listOfHierarchies.add(currentHierarchy);
                }
                if (membersByHierarchy.containsKey(currentHierarchy)) {
                    List membersList = (List)membersByHierarchy.get(currentHierarchy);
                    membersList.add(item);
                    continue;
                }
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(item);
                membersByHierarchy.put(currentHierarchy, newList);
            }
            String newItem = null;
            for (int i = 0; i < listOfHierarchies.size(); ++i) {
                String hier = (String)listOfHierarchies.get(i);
                membersOfSameHierarchy = (List)membersByHierarchy.get(hier);
                if (membersOfSameHierarchy.size() > 1) {
                    String[] membersArray = new String[membersOfSameHierarchy.size()];
                    membersArray = membersOfSameHierarchy.toArray(membersArray);
                    newItem = Strings.concatenate((String[])membersArray, (String)"", (String)COMMA, (String)"");
                } else {
                    newItem = (String)membersOfSameHierarchy.get(0);
                }
                newSelected.add(newItem);
            }
            for (int p = 0; p < newSelected.size(); ++p) {
                item = (String)newSelected.get(p);
                if (listOfHierarchies.size() > 1) {
                    crossjoinItems.add(item);
                    continue;
                }
                noCrossjoinItems.add(item);
            }
        }
        String[] noCrossjoinArray = new String[noCrossjoinItems.size()];
        noCrossjoinArray = noCrossjoinItems.toArray(noCrossjoinArray);
        if (noCrossjoinArray.length > 0) {
            newSet = Strings.concatenate((String[])noCrossjoinArray, (String)this.leftCurlyBracketToUse, (String)COMMA, (String)RIGHT_CURLY_BRACKET);
        }
        if (crossjoinItems.size() > 0) {
            String[] itemsToCrossjoin = new String[2];
            if (newSet == "") {
                itemsToCrossjoin[0] = (String)crossjoinItems.get(0);
                itemsToCrossjoin[1] = (String)crossjoinItems.get(1);
                newSet = Strings.concatenate((String[])itemsToCrossjoin, (String)("CROSSJOIN(" + this.leftCurlyBracketToUse), (String)"},{", (String)"})");
            } else {
                itemsToCrossjoin[0] = newSet;
                itemsToCrossjoin[1] = (String)crossjoinItems.get(0);
                newSet = Strings.concatenate((String[])itemsToCrossjoin, (String)"CROSSJOIN(", (String)",{", (String)"})");
            }
            for (int i = 2; i < crossjoinItems.size(); ++i) {
                itemsToCrossjoin[0] = newSet;
                itemsToCrossjoin[1] = (String)crossjoinItems.get(i);
                newSet = Strings.concatenate((String[])itemsToCrossjoin, (String)("CROSSJOIN(" + this.leftCurlyBracketToUse), (String)"},{", (String)"})");
            }
        }
        return newSet;
    }

    public String curlyBraceSet(String[] selectedArray) {
        String newSet = Strings.concatenate((String[])selectedArray, (String)this.leftCurlyBracketToUse, (String)COMMA, (String)RIGHT_CURLY_BRACKET);
        return newSet;
    }

    public String bracesWhereClause(List selectedList) {
        String[] strArray = new String[selectedList.size()];
        strArray = selectedList.toArray(strArray);
        String newWhere = Strings.concatenate((String[])strArray, (String)LEFT_BRACE, (String)COMMA, (String)RIGHT_BRACE);
        return newWhere;
    }

    public String bracesWhereClause(String[] selectedArray) {
        if (selectedArray.length == 0) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.EmptyArrayException.txt"));
        }
        String newWhere = Strings.concatenate((String[])selectedArray, (String)LEFT_BRACE, (String)COMMA, (String)RIGHT_BRACE);
        return newWhere;
    }

    public StringBuffer constructSelect(StringBuffer buffer) {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        this.displayBuffer.append(SELECT_RETURN);
        buffer.append(SELECT);
        return buffer;
    }

    private StringBuffer constructOnRows(StringBuffer buffer, List rowMembers) {
        if (!rowMembers.isEmpty()) {
            this.rowSet = this.curlyBraceSet(rowMembers);
            buffer.append(this.rowSet).append(ON_ROWS);
            this.displayBuffer.append(this.rowSet).append(ON_ROWS);
        }
        return buffer;
    }

    public StringBuffer constructOnRows(StringBuffer buffer) throws MDXQueryGenerationException {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        Map rowDimensionMembers = this.getDimensionMembersForAxis(ON_ROWS);
        this.displayBuffer.append(INDENT);
        if (rowDimensionMembers.size() == 1) {
            Object[] y = rowDimensionMembers.keySet().toArray();
            Object dimOneKey = y[0];
            ArrayList setDimensionOne = (ArrayList)rowDimensionMembers.get(dimOneKey);
            this.constructOnRows(buffer, setDimensionOne);
        } else {
            this.constructCrossjoin(buffer, rowDimensionMembers, ON_ROWS);
            buffer.append(ON_ROWS);
        }
        return buffer;
    }

    public StringBuffer constructOnColumns(StringBuffer buffer) throws MDXQueryGenerationException {
        Map columnDimensionMembers;
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        if ((columnDimensionMembers = this.getDimensionMembersForAxis(ON_COLUMNS)).size() == 1) {
            Object[] y = columnDimensionMembers.keySet().toArray();
            Object dimOneKey = y[0];
            ArrayList setDimensionOne = (ArrayList)columnDimensionMembers.get(dimOneKey);
            this.constructOnColumns(buffer, setDimensionOne);
        } else {
            this.constructCrossjoin(buffer, columnDimensionMembers, ON_COLUMNS);
            buffer.append(ON_COLUMNS);
            this.displayBuffer.append(ON_COLUMNS);
        }
        return buffer;
    }

    private StringBuffer constructOnColumns(StringBuffer buffer, List columnMembers) {
        if (!columnMembers.isEmpty()) {
            this.columnSet = this.curlyBraceSet(columnMembers);
            buffer.append(this.columnSet).append(ON_COLUMNS);
            this.displayBuffer.append(INDENT).append(this.columnSet).append(ON_COLUMNS);
        }
        return buffer;
    }

    public StringBuffer constructFrom(StringBuffer buffer, String cubeName) {
        if (cubeName == null || Utilities.isBlank(cubeName)) {
            throw new IllegalArgumentException(bundle.getString("MDXQueryGeneration.IllegalCubeNameException.txt"));
        }
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        buffer.append(FROM).append(LEFT_BRACKET).append(cubeName).append(RIGHT_BRACKET);
        this.displayBuffer.append(FROM_RETURN).append(LEFT_BRACKET).append(cubeName).append(RIGHT_BRACKET);
        return buffer;
    }

    private StringBuffer constructCrossjoin(StringBuffer buffer, String setOne, String setTwo) {
        buffer.append(CROSSJOIN).append(LEFT_BRACE).append(setOne).append(COMMA).append(setTwo).append(RIGHT_BRACE);
        this.displayBuffer.append(CROSSJOIN).append(LEFT_BRACE).append(setOne).append(COMMA).append(setTwo).append(RIGHT_BRACE);
        return buffer;
    }

    private String constructCrossjoin(String setOne, String setTwo) {
        StringBuffer newBuffer = new StringBuffer();
        newBuffer = this.constructCrossjoin(newBuffer, setOne, setTwo);
        String set = newBuffer.toString();
        newBuffer = null;
        return set;
    }

    private StringBuffer constructCrossjoin(StringBuffer buffer, Map selectedByDimension, String axis) throws MDXQueryGenerationException {
        DimensionInterface measureDimension = null;
        int numberDimensions = selectedByDimension.size();
        if (numberDimensions > 1) {
            Object[] dimensionKeys = selectedByDimension.keySet().toArray();
            try {
                for (int p = 0; p < numberDimensions; ++p) {
                    DimensionInterface dimKey = (DimensionInterface)dimensionKeys[p];
                    if (dimKey.getType() != 2) continue;
                    measureDimension = dimKey;
                }
                List<Object> original_dimKeysList = Arrays.asList(dimensionKeys);
                ArrayList<Object> dimKeysList = new ArrayList<Object>();
                int measureIndex = original_dimKeysList.indexOf(measureDimension);
                dimKeysList.addAll(original_dimKeysList);
                if (measureDimension != null & measureIndex != 0 && measureIndex > 0) {
                    dimKeysList.remove(measureIndex);
                    dimKeysList.add(measureDimension);
                    Collections.reverse(dimKeysList);
                }
                DimensionInterface dimOneKey = (DimensionInterface)dimKeysList.get(0);
                ArrayList setDimensionOne = (ArrayList)selectedByDimension.get(dimOneKey);
                DimensionInterface dimTwoKey = (DimensionInterface)dimKeysList.get(1);
                ArrayList setDimensionTwo = (ArrayList)selectedByDimension.get(dimTwoKey);
                String rowSetOne = null;
                String rowSetTwo = null;
                if (dimOneKey.getType() == 2) {
                    rowSetOne = this.curlyBraceSet(setDimensionTwo);
                    rowSetTwo = this.curlyBraceSet(setDimensionOne);
                } else {
                    rowSetOne = this.curlyBraceSet(setDimensionOne);
                    rowSetTwo = this.curlyBraceSet(setDimensionTwo);
                }
                this.addDimensionForAxis(axis, dimOneKey);
                this.addDimensionForAxis(axis, dimTwoKey);
                if (numberDimensions > 2) {
                    String setNext;
                    ArrayList setDimensionNext;
                    DimensionInterface dimNextKey;
                    String currentSet = this.constructCrossjoin(rowSetOne, rowSetTwo);
                    for (int i = 2; i < numberDimensions - 1; ++i) {
                        dimNextKey = (DimensionInterface)dimKeysList.get(i);
                        setDimensionNext = (ArrayList)selectedByDimension.get(dimNextKey);
                        setNext = this.curlyBraceSet(setDimensionNext);
                        this.addDimensionForAxis(axis, dimNextKey);
                        currentSet = this.constructCrossjoin(setNext, currentSet);
                    }
                    dimNextKey = (DimensionInterface)dimKeysList.get(numberDimensions - 1);
                    setDimensionNext = (ArrayList)selectedByDimension.get(dimNextKey);
                    setNext = this.curlyBraceSet(setDimensionNext);
                    this.addDimensionForAxis(axis, dimNextKey);
                    this.constructCrossjoin(buffer, setNext, currentSet);
                } else {
                    buffer = this.constructCrossjoin(buffer, rowSetOne, rowSetTwo);
                }
            }
            catch (OLAPException e) {
                throw new MDXQueryGenerationException(e.getLocalizedMessage());
            }
        }
        return buffer;
    }

    public StringBuffer constructWhere(StringBuffer buffer) throws MDXQueryGenerationException {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        ArrayList whereClauseItems = new ArrayList();
        ArrayList whereDimensions = this.getAxisDimensions(WHERE);
        int whereSize = whereDimensions.size();
        if (whereSize > 0) {
            for (int i = 0; i < whereSize; ++i) {
                DimensionInterface whereDimension = (DimensionInterface)whereDimensions.get(i);
                List where_members = this.getDimensionMembers(whereDimension);
                whereClauseItems.add(where_members.get(0));
            }
            this.whereClause = this.bracesWhereClause(whereClauseItems);
            buffer.append(WHERE).append(this.whereClause);
            this.displayBuffer.append(WHERE_RETURN).append(this.whereClause);
        }
        return buffer;
    }

    public static boolean containsDimension(List dimensionList, DimensionInterface dimension) throws MDXQueryGenerationException {
        boolean found = false;
        for (DimensionInterface dimensionInList : dimensionList) {
            try {
                if (!dimension.getUniqueName().equals(dimensionInList.getUniqueName())) continue;
                found = true;
            }
            catch (OLAPException e) {
                throw new MDXQueryGenerationException(e.getLocalizedMessage());
            }
        }
        return found;
    }

    public static boolean containsMember(List memberList, String member) {
        boolean found = false;
        for (String existingMember : memberList) {
            if (existingMember.equalsIgnoreCase(member)) {
                found = true;
                continue;
            }
            if (!(existingMember.indexOf(CHILDREN) > 0 & member.indexOf(CHILDREN) > 0)) continue;
            found = true;
        }
        return found;
    }

    public void setAllMemberMap(Map allMembers) {
        this.allMemberMap = allMembers;
    }
}

