/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities;

import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.ExpressionTreeCellRenderer;
import com.sas.olapadmin.utilities.MemberTreeNode;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class ExpressionTreeModel
extends DefaultTreeModel
implements DataSourceTreeInterface {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(ExpressionTreeModel.class);
    private static final String PERSONNAME = "\"SUB::SAS.PersonName\"";
    private static final String GROUPNAME = "\"SUB::SAS.IdentityGroupName\"";
    private static final String IDENTITYNAME = "\"SUB::SAS.IdentityName\"";
    private static final String IDENTITYGROUPS = "\"SUB::SAS.IdentityGroups\"";
    private static final String USERID = "\"SUB::SAS.Userid\"";
    private static final String EXTERNALIDENTITY = "\"SUB::SAS.ExternalIdentity\"";
    private static final String QUOTE = "\"";
    MemberTreeNode memberNode;
    JTree tree;

    public ExpressionTreeModel(Cube cube, OlapServer server, Dimension dim, boolean showLeaf, boolean showIdentities, JPanel panel) {
        super(new DefaultMutableTreeNode(), true);
        TreeNode root1 = this.buildRootNode(cube, server, showLeaf, dim, showIdentities, panel);
        this.setRoot(root1);
    }

    public ExpressionTreeModel(OLAPCube olapCube, OlapServer olapServer, OLAPDimension olapDimension, boolean showLeaf, boolean showIdentities, JPanel panel) {
        super(new DefaultMutableTreeNode(), true);
        TreeNode root1 = this.buildRootNode(olapCube, olapServer, showLeaf, olapDimension, showIdentities, panel);
        this.setRoot(root1);
    }

    public ExpressionTreeModel(OlapServer olapServer, Dimension olapDimension, boolean showLeaf, boolean showIdentities, JPanel panel) {
        super(new DefaultMutableTreeNode(), true);
        TreeNode root1 = this.buildRootNode(null, olapServer, showLeaf, olapDimension, showIdentities, panel);
        this.setRoot(root1);
    }

    public TreeCellRenderer getJTreeCellRenderer(JTree arg0) {
        this.tree = arg0;
        return new ExpressionTreeCellRenderer();
    }

    public JTree getTree() {
        return this.tree;
    }

    protected TreeNode buildRootNode(Cube cube, OlapServer server, boolean showLeaf, Dimension selectedDim, boolean showIdentities, JPanel panel) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.memberNode = new MemberTreeNode(cube, server, showLeaf, true, true, selectedDim);
        rootNode.add(this.memberNode);
        DefaultMutableTreeNode memberPropertiesNode = this.buildMemberPropertiesNode(cube, selectedDim);
        rootNode.add(memberPropertiesNode);
        if (showIdentities) {
            this.addIdentitiesNode(rootNode);
        }
        return rootNode;
    }

    protected TreeNode buildRootNode(OLAPCube olapCube, OlapServer olapServer, boolean showLeaf, OLAPDimension selectedDim, boolean showIdentities, JPanel panel) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.memberNode = new MemberTreeNode(olapCube, olapServer, showLeaf, true, true, selectedDim);
        rootNode.add(this.memberNode);
        DefaultMutableTreeNode memberPropertiesNode = this.buildMemberPropertiesNode(olapCube, selectedDim);
        rootNode.add(memberPropertiesNode);
        if (showIdentities) {
            this.addIdentitiesNode(rootNode);
        }
        return rootNode;
    }

    private void addIdentitiesNode(DefaultMutableTreeNode rootNode) {
        int serverVersion = 0;
        try {
            serverVersion = Workspace.getMdFactory().getConnection().getPlatformVersion();
            if (serverVersion >= 9200) {
                DefaultMutableTreeNode identitiesNode = this.buildIdentitiesNode();
                rootNode.add(identitiesNode);
            }
        }
        catch (MdException ex) {
            serverVersion = 0;
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public MemberTreeNode getMemberTreeRoot() {
        return this.memberNode;
    }

    private DefaultMutableTreeNode buildMemberPropertiesNode(Cube inCube, Dimension inDim) {
        DefaultMutableTreeNode memPropNode = new DefaultMutableTreeNode(bundle.getString("ExpressionTreeModel.MemberProperties.txt"));
        try {
            OLAPSharedDimension dim = null;
            List dimensions = null;
            if (inCube != null && inDim != null) {
                OLAPCube cube = new OLAPCube(inCube);
                DimensionSet dimSet = cube.getDimensionSet();
                dimensions = dimSet.getAllCubeDimensions();
                dim = dimSet.getDimension(inDim.getName());
            } else if (inDim != null) {
                OLAPSharedDimension sharedDimension;
                dim = sharedDimension = new OLAPSharedDimension((SharedDimension)inDim);
            }
            if (dim != null) {
                this.addLevelsProperties((OLAPDimension)dim, memPropNode);
            } else if (dimensions != null) {
                for (int a = 0; a < dimensions.size(); ++a) {
                    OLAPDimension dim2 = (OLAPDimension)dimensions.get(a);
                    DefaultMutableTreeNode dimNode = new DefaultMutableTreeNode(dim2.getName());
                    dimNode.setUserObject(dim2);
                    memPropNode.add(dimNode);
                    this.addLevelsProperties(dim2, dimNode);
                }
            }
        }
        catch (OLAPException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            ExceptionHandler.handleException(ex);
        }
        return memPropNode;
    }

    private DefaultMutableTreeNode buildMemberPropertiesNode(OLAPCube olapCube, OLAPDimension selectedDim) {
        DefaultMutableTreeNode memPropNode = new DefaultMutableTreeNode(bundle.getString("ExpressionTreeModel.MemberProperties.txt"));
        try {
            if (selectedDim != null) {
                this.addLevelsProperties(selectedDim, memPropNode);
            } else {
                DimensionSet dimSet = olapCube.getDimensionSet();
                List dimensions = dimSet.getAllCubeDimensions();
                for (int a = 0; a < dimensions.size(); ++a) {
                    OLAPDimension dim = (OLAPDimension)dimensions.get(a);
                    DefaultMutableTreeNode dimNode = new DefaultMutableTreeNode(dim.getName());
                    dimNode.setUserObject(dim);
                    memPropNode.add(dimNode);
                    this.addLevelsProperties(dim, dimNode);
                }
            }
        }
        catch (OLAPException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        return memPropNode;
    }

    public void addLevelsProperties(OLAPDimension currDim, DefaultMutableTreeNode node) {
        if (currDim == null || node == null) {
            return;
        }
        try {
            OLAPList levels = currDim.getLevels();
            for (int i = 0; i < levels.size(); ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                OLAPList properties = level.getOLAPProperties();
                int numProperties = properties.size();
                IdentityNode levelNode = null;
                if (numProperties > 0) {
                    String levelName = level.getName();
                    levelNode = new IdentityNode(levelName, levelName, Resources.getImageIcon((String)"OLAPLevel.gif", (int)16));
                    node.add(levelNode);
                }
                for (int j = 0; j < numProperties; ++j) {
                    OLAPMemberProperty prop = (OLAPMemberProperty)properties.get(j);
                    String name = prop.getName();
                    String quotedName = QUOTE + name + QUOTE;
                    IdentityNode propertyNode = new IdentityNode(name, quotedName, quotedName, bundle.getImageIcon("Tree.MemberProperty.image"));
                    if (levelNode == null) continue;
                    levelNode.add(propertyNode);
                }
            }
        }
        catch (OLAPException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
    }

    private DefaultMutableTreeNode buildIdentitiesNode() {
        DefaultMutableTreeNode identitiesNode = new DefaultMutableTreeNode(bundle.getString("ExpressionTreeModel.IdentityValues.txt"));
        IdentityNode node = new IdentityNode(bundle.getString("ExpressionTreeModel.PersonName.txt"), bundle.getString("ExpressionTreeModel.PersonName.Description.txt"), PERSONNAME, bundle.getImageIcon("Tree.Status.image"));
        identitiesNode.add(node);
        node = new IdentityNode(bundle.getString("ExpressionTreeModel.IdentityGroupName.txt"), bundle.getString("ExpressionTreeModel.IdentityGroupName.Description.txt"), GROUPNAME, bundle.getImageIcon("Tree.Status.image"));
        identitiesNode.add(node);
        node = new IdentityNode(bundle.getString("ExpressionTreeModel.IdentityName.txt"), bundle.getString("ExpressionTreeModel.IdentityName.Description.txt"), IDENTITYNAME, bundle.getImageIcon("Tree.Status.image"));
        identitiesNode.add(node);
        node = new IdentityNode(bundle.getString("ExpressionTreeModel.IdentityGroups.txt"), bundle.getString("ExpressionTreeModel.IdentityGroups.Description.txt"), IDENTITYGROUPS, bundle.getImageIcon("Tree.Status.image"));
        identitiesNode.add(node);
        node = new IdentityNode(bundle.getString("ExpressionTreeModel.Userid.txt"), bundle.getString("ExpressionTreeModel.Userid.Description.txt"), USERID, bundle.getImageIcon("Tree.Status.image"));
        identitiesNode.add(node);
        node = new IdentityNode(bundle.getString("ExpressionTreeModel.ExternalIdentity.txt"), bundle.getString("ExpressionTreeModel.ExternalIdentity.Description.txt"), EXTERNALIDENTITY, bundle.getImageIcon("Tree.Status.image"));
        identitiesNode.add(node);
        return identitiesNode;
    }

    public class IdentityNode
    extends DefaultMutableTreeNode
    implements DataSourceNodeInterface {
        private static final long serialVersionUID = 1L;
        private String m_name;
        private String m_displayName;
        private String m_description;
        private String m_insertName;
        private ImageIcon m_imageIcon;

        IdentityNode(String displayName, String desc, ImageIcon imageIcon) {
            this(displayName, desc, null, imageIcon);
        }

        IdentityNode(String displayName, String desc, String insertName, ImageIcon imageIcon) {
            super(displayName);
            this.m_name = displayName;
            this.m_displayName = displayName;
            this.m_description = desc;
            this.m_insertName = insertName;
            this.m_imageIcon = imageIcon;
        }

        public String getName() {
            return this.m_name;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getToolTip() {
            return this.m_description;
        }

        public String getInsertName() {
            return this.m_insertName;
        }

        public DataValuesInterface getDataValuesInterface() {
            return null;
        }

        public DistinctValuesInterface getDistinctValuesInterface() {
            return null;
        }

        public FormattedValuesInterface getFormattedValuesInterface() {
            return null;
        }

        public ImageIcon getImageIcon() {
            return this.m_imageIcon;
        }
    }
}

